<?php
namespace addons\favorite\controller;
use think\addons\Controller;
use app\common\model\Cmsmodels;
use app\common\model\Cmsfields;
use app\common\model\User;
use app\common\model\Site;
use Request;
use Db;

class Admin extends Controller
{
    // 后台管理操作控制器必须判断管理员登陆
    protected function initialize()
    {
        parent::initialize();
        // 判断是否管理员登陆
        if(!session('?adminid')) abort(404,'访问的内容不存在');
        $this->isInstall();
    }

    // 管理入口
    public function index()
    {
        if(Request::isPost())
        {
            $modelid = Request::post('modelid');
            $data = Db::name('favorite')->withAttr('cinfo',function($value,$data){
                $info['m'] = $modelinfo =  Cmsmodels::get($data['cmsmodels_id']);
                $class = "\\app\\common\\model\\".$modelinfo->classname;
                $info['c'] = (new $class)->whereId($data['cid'])->append(['url','navlist'])->find();
                return $info;
            })->when(!empty($modelid),function($query)use($modelid){
                $query->whereCmsmodelsId($modelid);
            })->group('cid,cmsmodels_id')->field('id,cid,cmsmodels_id,count(*) as fcount')->order('fcount desc')->paginate(input('post.limit/d'))->toArray();
            return json(['code'=>0,'msg'=>'获取数据成功','data'=>$data['data'],'count'=>$data['total']]);
        }
        $config = get_addons_config('favorite',true);
        $cmsmodels = Cmsmodels::whereType(1)->select();
        return $this->fetch('',compact('config','cmsmodels'));
    }
    // 删除
    public function del()
    {
        if(Request::isPost()) {
            $data = Request::post();
            $result = Db::name('favorite')->delete($data['id']);
            if ($result) {
                $this->success('删除成功');
            } else {
                $this->error('删除失败');
            }
        } else {
            $this->error('删除失败');
        }
    }
}