<?php
namespace addons\mylike;  // 注意命名空间规范
use think\Addons;

class Widget extends Addons // 需继承Addons类
{
    // 该插件的基础信息
    public $info = [
        'name' => 'mylike',   // 插件标识
        'title' => '内容赞踩',  // 插件名称
        'author' => 'RGCMS',  // 插件作者
        'is_admin' => true,
        'version' => '0.1',  // 插件版本
        'description' => "内容赞踩插件，可设置会员及频率等，只适用于内容模型内容",  // 插件描述
        'help' => "列表页.显示数据：<Br>赞：{:hook('mylikenum',['modelid' => \$list['cmsmodels_id'],'cid'=>\$list['id']])}<br>踩：{:hook('mylikenum',['modelid' => \$list['cmsmodels_id'],'cid'=>\$list['id'],'type'=>'dislike'])}<Br>详情页.可点击：<br>{:hook('mylikehook',['modelid'=>\$info_cmsmodels_id,'cid'=>\$info_id])}"
    ];

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        if(strtolower(config('database.type')) == 'sqlite') {
            $sql_config = "CREATE TABLE IF NOT EXISTS `".config('database.prefix')."mylike` (";
            $sql_config .= "`id` INTEGER PRIMARY KEY AUTOINCREMENT,";
            $sql_config .= "`cmsmodels_id` INT DEFAULT NULL,";
            $sql_config .= "`cid` INT DEFAULT NULL,";
            $sql_config .= "`user_id` INT DEFAULT 0,";
            $sql_config .= "`islike` INT DEFAULT 0,";
            $sql_config .= "`ip` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "`create_time` BIGINT DEFAULT 0";
            $sql_config .= ");";
        } else {
            $sql_config = "CREATE TABLE IF NOT EXISTS `".config('database.prefix')."mylike`(";
            $sql_config .= "`id` INT(10) NOT NULL AUTO_INCREMENT,";
            $sql_config .= "`cmsmodels_id` INT DEFAULT NULL,";
            $sql_config .= "`cid` INT DEFAULT NULL,";
            $sql_config .= "`user_id` INT DEFAULT 0,";
            $sql_config .= "`islike` INT DEFAULT 0,";
            $sql_config .= "`ip` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "`create_time` BIGINT DEFAULT 0,";
            $sql_config .= "PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件-内容模型赞踩';";
        }
        try {
            \think\Db::execute($sql_config);
        } catch (\Exception $e) {
            return false;
        }
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        try {
            \think\Db::execute("DROP TABLE IF EXISTS `".config('database.prefix')."mylike`;");
        } catch (\Exception $e) {
            return false;
        }
        return true;
    }


    public function mylikehook($param)
    {
        if(empty($param['modelid']) || empty($param['cid'])) return;
        $config = $this->getConfig(true);
        $likeList = \think\Db::name('mylike')->where(['cmsmodels_id' => $param['modelid'],'cid' => $param['cid']])->fetchCollection()->select();
        $likeNum = $likeList->where('islike','=',1)->count();
        $dislikeNum = $likeList->where('islike','=',0)->count();
        return $this->fetch('index/info',compact('param','config','likeNum','dislikeNum'));
    }
    public function mylikenum($param)
    {
        if(empty($param['modelid']) || empty($param['cid'])) return 0;
        $likeList = \think\Db::name('mylike')->where(['cmsmodels_id' => $param['modelid'],'cid' => $param['cid']])->fetchCollection()->select();
        if($param['type'] == 'dislike') {
            return $likeList->where('islike','=',0)->count();
        } else {
            return $likeList->where('islike','=',1)->count();
        }
    }
}