<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-07-11
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\controller;
use think\Controller;
use app\common\model\Site;
use app\common\model\About as AboutModel;
use Request;
use Db;

class About extends Base
{
	// 单页列表
	public function index()
	{
		if(Request::isPost())
		{
			$data = AboutModel::whereSiteId(session('siteid'))->when(!empty(Request::post('order')),function($query){
				$query->order(Request::post('order.field'),Request::post('order.type'));
			},function($query){
				$query->order('torder');
			})->paginate(Request::post('limit/d'))->toArray();
			$recycle_count = AboutModel::onlyTrashed()->whereSiteId(session('siteid'))->count();
			return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$data['data'],'count'=>$data['total'],'recycle_count'=>$recycle_count]);
		}
		return $this->fetch();
	}

	// 添加
	public function add()
	{
		if(Request::isPost()) {
			$data = Request::post();
			$this->checkData($data);
			if(empty($data['template'])) $data['template'] = 'about_content.html';
			$result = AboutModel::create($data,true);
			adminlog(2,'新增('.AboutModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('addtrue'));
			} else {
				$this->error(lang('addfalse'));
			}
		}
		$templist = scan_dir('./public/'.config('tpl_path').'/'.$this->siteinfo['pctemplate'].'/'.$this->siteinfo['pchtml'],0,['html']);
		return $this->fetch('',compact('templist'));
	}

	// 编辑
	public function edit($id)
	{
		$info = AboutModel::get($id);
		if(empty($info)) $this->error(lang('norecord'));
		if(Request::isPost()) {
			$data = Request::post();
			unset($data['create_time']);
			unset($data['update_time']);
			unset($data['delete_time']);
			$this->checkData($data);
			$result = $info->allowField(true)->save($data);
			adminlog(2,'编辑('.AboutModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
		$templist = scan_dir('./public/'.config('tpl_path').'/'.$this->siteinfo['pctemplate'].'/'.$this->siteinfo['pchtml'],0,['html']);
		return $this->fetch('',compact('templist','info'));
	}

	// 删除
	public function del()
	{
		if(Request::isPost()) {
			$data = Request::post();
            if(Request::param('type') == 'soft') {
            	$result = Db::name('about')->whereSiteId(session('siteid'))->whereIn('id',$data['id'])->setField('delete_time',time()); // Db类实现软删除
            	adminlog(2,'删除('.Db::name('about')->getLastSql().')',$result?1:0);
            } else {
            	$result = Db::name('about')->whereSiteId(session('siteid'))->whereIn('id',$data['id'])->delete(); // Db类实现真实删除
            	adminlog(2,'删除('.Db::name('about')->getLastSql().')',$result?1:0);
            	\app\common\model\Diyfields::whereTablename('about')->whereIn('cid',$data['id'])->delete();
            }
			if ($result) {
				$this->success(lang('deltrue'));
			} else {
				$this->error(lang('delfalse'));
			}
		}
	}

	// 回收站
	public function recycle()
	{
		// 获取数据列表
		if(Request::isPost()) {
			$list = AboutModel::onlyTrashed()->whereSiteId(session('siteid'))->order('torder')->paginate(Request::post('limit/d'))->toArray();
			return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$list['data'],'count'=>$list['total']]);
		}
		return $this->fetch();
	}

	// 恢复
	public function restore()
	{
		if(Request::isPost()) {
			$data = Request::post();
            $result = Db::name('about')->whereSiteId(session('siteid'))->whereIn('id',$data['id'])->setField('delete_time',0); // Db类实现数据恢复
			if ($result) {
				$this->success(lang('resttrue'));
			} else {
				$this->error(lang('restfalse'));
			}
		}
	}

	// 数据验证
	private function checkData($data)
	{
		if(!isset($data['list_switch'])) { // 如果不是switch开关操作
			$validate = new \app\admin\validate\About;
			if(!$validate->check($data)) {
				$this->error($validate->getError());
			}
		}
	}
}