<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-11
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\controller;
use think\Controller;
use yupoxiong\region\model\Region;
use Request;

class Area extends Base
{
	public function index()
	{
		$count = Region::count();
		return $this->fetch('',compact('count'));
	}

	// 添加
	public function add()
	{
		if(Request::isPost()) {
			$data = Request::post();
            $result = Region::create($data,true);
            adminlog(2,'新增('.Region::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('addtrue'));
			} else {
				$this->error(lang('addfalse'));
			}
		}
		return $this->fetch('');
	}

	// 编辑
	public function edit($id)
	{
		$info = Region::get($id);
		if(empty($info)) $this->error(lang('norecord'));
		if(Request::isPost()) {
			$data = Request::post();
            $result = $info->allowField(true)->save($data);
            adminlog(2,'编辑('.Region::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
		return $this->fetch('',compact('info'));
	}


	// 删除
	public function del()
	{
		if(Request::isPost()) {
			$data = Request::post();
			if(Region::whereParentId($data['id'])->count()>0) $this->error(lang('delfalse').'：存在下级地区');
			$result = Region::destroy($data['id']);
			adminlog(2,'删除('.Region::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('deltrue'));
			} else {
				$this->error(lang('delfalse'));
			}
		}
	}
}