<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-07-18
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\controller;
use think\Controller;
use app\common\model\Attr as AttrModel;
use app\common\model\Attrgroup as AttrgroupModel;
use Request;

class Attr extends Base
{
	// 属性列表
	public function grouplist()
	{
		if(Request::isPost())
		{
			$data = AttrgroupModel::withCount('attr')->paginate(Request::post('limit/d'))->toArray();
			return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$data['data'],'count'=>$data['total']]);
		}
		return $this->fetch();
	}

	// 添加属性
	public function addgroup()
	{
		if(Request::isPost()) {
			$data = Request::post();
			$this->checkData($data);
			$attrgroup = AttrgroupModel::create(['title' => $data['title'],'name' => $data['name']],true);
			adminlog(2,'新增('.AttrgroupModel::getLastsql().')',$attrgroup?1:0);
			if ($attrgroup) {
				$content = explode("\n",$data['content']);
				foreach ($content as $v) {
					$newcontent[] = ['title' => str_replace(',','',$v)];
				}
				$attrgroup->attr()->saveAll($newcontent);
				$this->success(lang('addtrue'));
			} else {
				$this->error(lang('addfalse'));
			}
		}
		return $this->fetch();
	}

	// 编辑属性
	public function editgroup($id)
	{
		$info = AttrgroupModel::get($id);
		if(empty($info)) $this->error(lang('norecord'));
		if(Request::isPost()) {
			$data = Request::post();
			$this->checkData($data);
			unset($data['create_time']);
			unset($data['update_time']);
			$result = $info->allowField(true)->save($data);
			adminlog(2,'编辑('.AttrgroupModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
		return $this->fetch('',compact('info'));
	}

	// 删除属性
	public function delgroup()
	{
		if(Request::isPost()) {
			$data = Request::post();
            $group = AttrgroupModel::get($data['id'],'attr');
            $result = $group->together('attr')->delete();
            adminlog(2,'删除('.AttrgroupModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('deltrue'));
			} else {
				$this->error(lang('delfalse'));
			}
		}
	}

	// 属性内容首页
	public function index($attrgroup_id)
	{
		if(Request::isPost())
		{
			$data = AttrModel::whereAttrgroupId($attrgroup_id)->paginate(Request::post('limit/d'))->toArray();
			return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$data['data'],'count'=>$data['total']]);
		}
		return $this->fetch('',compact('attrgroup_id'));
	}

	// 添加内容
	public function add($attrgroup_id)
	{
		if(Request::isPost()) {
			$data = Request::post();
			$data['attrgroup_id'] = $attrgroup_id;
			$data['title'] = str_replace(',','',$data['title']);
			$this->checkAttrData($data);
			$result = AttrModel::create($data,true);
			adminlog(2,'新增('.AttrModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('addtrue'),url('index').'?attrgroup_id='.$attrgroup_id);
			} else {
				$this->error(lang('addfalse'));
			}
		}
		return $this->fetch('',compact('attrgroup_id'));
	}

	// 删除内容
	public function del()
	{
		if(Request::isPost()) {
			$data = Request::post();
            $info = AttrModel::get($data['id']);
            $result = $info->delete();
            adminlog(2,'删除('.AttrModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('deltrue'));
			} else {
				$this->error(lang('delfalse'));
			}
		}
	}

	// 编辑内容
	public function edit($id)
	{
		$info = AttrModel::get($id);
		if(empty($info)) $this->error(lang('norecord'));
		if(Request::isPost()) {
			$data = Request::post();
			$data['attrgroup_id'] = $info->attrgroup_id;
			$this->checkAttrData($data);
			unset($data['create_time']);
			unset($data['update_time']);
			$result = $info->allowField(true)->save($data);
			adminlog(2,'编辑('.AttrModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('edittrue'),url('index').'?attrgroup_id='.$info->attrgroup_id);
			} else {
				$this->error(lang('editfalse'));
			}
		}
		return $this->fetch('',compact('info'));
	}

	// 数据验证
	private function checkData($data)
	{
		$validate = new \app\admin\validate\Attrgroup;
		if(!$validate->check($data)) {
			$this->error($validate->getError());
		}
	}
	private function checkAttrData($data)
	{
		if(!isset($data['list_switch'])) {
			$validate = new \app\admin\validate\Attr;
			if(!$validate->check($data)) {
				$this->error($validate->getError());
			}
		}
	}
}