<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-26
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\controller;
use think\Controller;
use Request;

class Config extends Base
{
	// 配置列表
	public function index($name = 'app')
	{
		return $this->fetch($name,compact(['name']));
	}

	// 保存配置信息
	public function saveconfig($name)
	{
		if(Request::isPost()) {
			$data = Request::post();
			$name = $data['name'];
            unset($data['name']);
			foreach ($data as $k => $v) {
				if($v==='false') $data[$k] = false;
				if($v==='true') $data[$k] = true;
				if(is_numeric($v)) {
					if(strstr($v, '.') === false) {
						$data[$k] = (int) $v;
					} else {
						$data[$k] = round($v,2);
					}
				}
			}
			if($name != 'app') {
            	$data = [$name => $data];
            }
            $file = './config/system.php';
            $config = array_merge(include ($file),$data);
            $result = file_put_contents($file, "<?php\nreturn " . var_export($config, true) . ";");
			if($result) {
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
	}

	public function Sendmail()
	{
		if(Request::isPost()) {
			$data = input('post.');
			$mailto = filter_var($data['mailto'], FILTER_VALIDATE_EMAIL);
			if($mailto !== false) {
				$result = sendMail($mailto,'邮箱配置成功！','这是一封来自RGCMS的邮件，收到此邮件说明系统邮箱配置成功！欢迎使用RGCMS系统。',$data);
				if($result['code'] == 1) {
					$this->success($result['msg']);
				} else {
					$this->error($result['msg']);
				}
			} else {
				$this->error('邮箱格式错误');
			}
		}
	}
}