<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-05
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\controller;
use think\Controller;
use app\common\model\Diyfields as DiyfieldsModel;
use Request;

class Diyfields extends Base
{
	protected $tablename;
	protected $cid;
	protected function initialize()
    {
    	parent::initialize();
		if(!Request::has('tablename','param')) {
			$this->tablename = 'site';
			$this->cid = session('siteid');
        } else {
        	$this->tablename = Request::param('tablename');
        	if($this->tablename == 'navlist') {
        		$this->cid = session('siteid');
        	} else {
        		$this->cid = Request::param('cid');
        	}
        }
        if(!$this->tablename || !$this->cid) $this->error(lang('参数错误'));
        $this->assign(['tablename' => $this->tablename,'cid' => $this->cid]);
    }
	// 列表
	public function index()
	{
		if(Request::isPost()) {
			$data = DiyfieldsModel::whereTablename($this->tablename)->whereCid($this->cid)->order('torder asc')->paginate(Request::post('limit'))->toArray();
			return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$data['data'],'count'=>$data['total']]);
		}
		if($this->tablename == 'navlist') {
			return $this->fetch('navlist');
		} else {
			return $this->fetch();
		}
		
	}

	// 添加
	public function add()
	{
		if(Request::isPost()) {
			$data = Request::post();
			$data['tablename'] = $this->tablename;
			$data['cid'] = $this->cid;
			$data['value'] = '';
			$this->checkData($data);
			$result = DiyfieldsModel::create($data,true);
			adminlog(2,'新增('.DiyfieldsModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('addtrue'));
			} else {
				$this->error(lang('addfalse'));
			}
		}
	}

	// 保存内容
	public function save()
	{
		if(Request::isPost()) {
			$data = Request::post('data/a');
			$result = (new DiyfieldsModel())->saveAll($data);
			adminlog(2,'新增('.DiyfieldsModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
	}

	// 编辑
	public function edit($id)
	{
		if(Request::isPost()) {
			$data = Request::post();
			$info = DiyfieldsModel::whereTablename($this->tablename)->whereCid($this->cid)->get($data['id']);
			if(empty($info)) $this->error(lang('norecord'));
			$this->checkData($data);
			unset($data['create_time']);
			unset($data['update_time']);
			$result = $info->allowField(true)->save($data);
			adminlog(2,'编辑('.DiyfieldsModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
	}

	// 删除
	public function del()
	{
		if(Request::isPost()) {
			$data = Request::post();
			$info = DiyfieldsModel::whereTablename($this->tablename)->whereCid($this->cid)->get($data['id']);
			if($info) {
				$result = $info->delete();
				adminlog(2,'删除('.DiyfieldsModel::getLastsql().')',$result?1:0);
				if ($result) {
					$this->success(lang('deltrue'));
				} else {
					$this->error(lang('delfalse'));
				}
			}
			$this->error(lang('delfalse'));
		}
	}

	// 数据验证
	private function checkData($data)
	{
		if(!isset($data['list_switch'])) { // 如果不是switch开关操作
			$validate = new \app\admin\validate\Diyfields;
			if(!$validate->check($data)) {
				$this->error($validate->getError());
			}
		}
	}
}