<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-15
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\controller;
use think\Controller;
use Request;

class Filemanage extends Base
{
	protected $rootdir;
	protected function initialize()
    {
    	parent::initialize();
    	//$this->error('由于在线模板管理存在安全漏洞，在修复前将暂停使用！');
        $this->rootdir = realpath('public'.DS.config('tpl_path'));
        $this->ext = ['htm','html','css','js','txt','xml','scss'];
    }
	
	// 模板文件夹文件列表
	public function template()
	{
		if(Request::isPost()){
			$path = Request::post('path/s');
			if($this->checkpath($path)){
				$postlist = read_allfile($path,1);
				return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$postlist,'count'=>count($postlist),'path' => $path]);
			} else {
				return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>'','count'=>0,'path' => '']);
			}
		}
		//halt(glob($this->rootdir.DS.'*'));
		$dirlist = json_encode(read_allfile('public'.DS.config('tpl_path'),0));
		// halt(read_allfile($this->rootdir,0)); 
		return $this->fetch('',compact('dirlist'));
	}

	// 创建文件
	public function createfile()
	{
		if(Request::isPost()){
			$filename = Request::post('filename');
			if(count(explode('.',$filename)) != 2) {
				$this->error('请输入正确的文件名');
			}
			$path = input('post.path');
			$fullpath = trim($path.DS.$filename);
			if(!$this->checkext($fullpath)) {
				$this->error('非法文件');
			}
			if(file_exists($fullpath)) {
				$this->error('创建失败，该文件已经存在');
			}
			if($this->checkpath($path)){
				$result = file_put_contents($fullpath,"RGCMS");
				if($result) {
					$this->success('创建成功');
				} else {
					$this->error('创建失败');
				}
			} else {
				$this->error('非法路径');
			}
		}
	}

	// 编辑文件
	public function editfile($path,$title='')
	{
		if(!$this->checkpath($path)){
			$this->error('非法路径');
		}
		if(!$this->checkext($path)) {
			$this->error('非法文件');
		}
		$content = file_get_contents($path);
		return $this->fetch('',compact('content','path','title'));
	}

	public function editfilesave()
	{
		if(Request::isPost()){
			$data = Request::post();
			$path = $data['path'];
			if(!$this->checkext($path)) {
				$this->error('非法文件');
			}
			$content = trim($data['content']) ? trim($data['content']) : 'RGCMS';
			if($this->checkpath($path)){
				if(is_writable($path)) {
					$result = file_put_contents($path,$content);
					if($result) {
						$this->success('修改成功');
					} else {
						$this->error('修改失败');
					}
				} else {
					$this->error('文件不可写，修改失败');
				}
				
			} else {
				$this->error('非法路径');
			}
		}
	}

	// 删除文件
	public function delfile()
	{
		if(Request::isPost()){
			$data = Request::post();
			$path = $data['path'];
			if(!$this->checkext($path)) {
				$this->error('非法文件');
			}
			if($this->checkpath($path)){
				$result = @unlink($path);
				if($result) {
					$this->success('删除成功');
				} else {
					$this->error('删除失败');
				}
			} else {
				$this->error('非法路径');
			}
		}
	}

	// 路径验证
	private function checkpath($path)
	{
		if(!empty($path)) {
			$path = realpath($path);
			if($path && strpos($path,$this->rootdir) === 0) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	// 文件验证
	private function checkext($path)
	{
		$filename_ext = strtolower(substr(strrchr(basename($path), '.'), 1));
		if(!in_array($filename_ext,$this->ext)) {
			return false;
		} else {
			return true;
		}
	}
}