<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-03
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\controller;
use think\Controller;
use app\common\model\Site as SiteModel;
use app\common\model\Cmsmodels;
use app\common\model\Diyfields;
use app\common\controller\Office;
use Request;

class Site extends Base
{
	// 站点列表
	public function index()
	{
		if(Request::isPost())
		{
			$data = SiteModel::when(!empty(Request::post('order')),function($query){
				$query->order(Request::post('order.field'),Request::post('order.type'));
			},function($query){
				$query->order('torder');
			})->append(['expired'])->field(['id','title','alias','isdefault','pctemplate','pchtml','waptemplate','waphtml','status','wapstatus','offline','create_time','end_time','torder'])->paginate(input('post.limit/d'))->toArray();
			return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$data['data'],'count'=>$data['total']]);
		}
		return $this->fetch();
	}

	// 添加站点
	public function add()
	{
		if(Request::isPost()) {
			$data = Request::only(['id','title','alias','isdefault','pctemplate','pchtml','waptemplate','waphtml','status','wapstatus','offline','create_time','end_time','torder'], 'post');
			$this->checkData($data);
			if($data['isdefault'] == 1) {
				SiteModel::whereIsdefault(1)->setField('isdefault',0);
			}
			$result = SiteModel::create($data,true);
			adminlog(2,'新增('.SiteModel::getLastsql().')',$result?1:0);
			if ($result) {
				cache("site_nav_list", NULL);
				$this->success(lang('addtrue'));
			} else {
				$this->error(lang('addfalse'));
			}
		}
		$tempdir = scan_dir('./public/'.config('tpl_path').'/');
		return $this->fetch('',compact('tempdir'));
	}

	// 编辑站点
	public function edit($id)
	{
		$info = SiteModel::field(['id','title','alias','isdefault','pctemplate','pchtml','waptemplate','waphtml','status','wapstatus','offline','create_time','end_time','torder'])->get($id);
		if(empty($info)) $this->error(lang('norecord'));
		if(Request::isPost()) {
			$data = Request::only(['id','title','alias','isdefault','pctemplate','pchtml','waptemplate','waphtml','status','wapstatus','offline','create_time','end_time','torder','list_switch'], 'post');
			$this->checkData($data);
			if(isset($data['isdefault']) && $data['isdefault'] == 1) {
				SiteModel::whereIsdefault(1)->setField('isdefault',0);
			}
			$result = $info->allowField(true)->save($data);
			adminlog(2,'编辑('.SiteModel::getLastsql().')',$result?1:0);
			if ($result) {
				cache("site_nav_list", NULL);
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
		$tempdir = scan_dir('./public/'.config('tpl_path').'/');
		return $this->fetch('',compact('info','tempdir'));
	}

	// toexcel
	public function toexcel()
	{
		$data = model('site')->select();
		$excel = new Office();
		$head = ['标题'];
		$keys = ['title'];
		$excel->outdata('内容表', $data, $head, $keys);
	}

	// 删除站点
	public function del()
	{
		if(Request::isPost()) {
			$data = Request::post();			
			if(isset($data['action']) && $data['action'] == 'clear') {
				$models = Cmsmodels::all();
				foreach ($models as $k => $v) {
					\think\Db::name($v['tablename'])->whereSiteId($data['id'])->delete();
				}
				\think\Db::name('about')->whereSiteId($data['id'])->delete();
				\think\Db::name('navlist')->whereSiteId($data['id'])->delete();
				\think\Db::name('navgroup')->whereSiteId($data['id'])->delete();
				\think\Db::name('domains')->whereSiteId($data['id'])->delete();
				\think\Db::name('sitekey')->whereSiteId($data['id'])->delete();
				\think\Db::name('diyfields')->whereSiteId($data['id'])->delete();
				\think\Db::name('visits')->whereSiteId($data['id'])->delete();
				cache("site_nav_list", NULL);
				$this->success('站点初始化成功');
			} else {
				$info = SiteModel::whereIsdefault(0)->get($data['id'],['navlist','navgroup','domains','sitekey','diyfields','visits']);
				if($info) {
					$models = Cmsmodels::all();
					foreach ($models as $k => $v) {
						\think\Db::name($v['tablename'])->whereSiteId($data['id'])->delete();
					}
					\think\Db::name('about')->whereSiteId($data['id'])->delete();
					$result = $info->together('navlist,navgroup,domains,sitekey,diyfields,visits')->delete();
					adminlog(2,'删除('.SiteModel::getLastsql().')',$result?1:0);
					if ($result) {
						cache("site_nav_list", NULL);
						$this->success(lang('deltrue'));
					} else {
						$this->error(lang('delfalse'));
					}
				} else {
					$this->error(lang('delfalse'));
				}
			}
		}
	}

	// 站点信息
	public function info()
	{
		$info = SiteModel::field(['title','alias','isdefault','pctemplate','pchtml','waptemplate','waphtml','status','wapstatus','offline','create_time','end_time','torder'],true)->get(session('siteid'));
		if(empty($info)) $this->error(lang('norecord'));
		return $this->fetch('info',compact('info'));
	}

	// 修改站点信息
	public function infoedit()
	{
		if(Request::isPost()) {
			$data = Request::except(['id','title','alias','isdefault','pctemplate','pchtml','waptemplate','waphtml','status','wapstatus','offline','create_time','end_time','torder'], 'post');
			$info = SiteModel::field(['id','title','alias','isdefault','pctemplate','pchtml','waptemplate','waphtml','status','wapstatus','offline','create_time','end_time','torder'],true)->get(session('siteid'));
			$data['update_time'] = time();
			$result = $info->allowField(true)->save($data);
			adminlog(2,'编辑('.SiteModel::getLastsql().')',$result?1:0);
			if ($result) {
				cache("site_nav_list", NULL);
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
	}

	// 数据验证
	private function checkData($data)
	{
		if(!isset($data['list_switch'])) { // 如果不是switch开关操作
			$validate = new \app\admin\validate\Site;
			if(!$validate->check($data)) {
				$this->error($validate->getError());
			}
		}
	}
}