<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-06-29
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\controller;
use think\Controller;
use app\common\model\Usermenu as UsermenuModel;
use app\common\model\Usergroup;
use Request;

class Usermenu extends Base
{
	protected function initialize()
    {
        parent::initialize();
        $this->type = ['t1'=>'二开功能','t2'=>'单页说明','t3'=>'自定义表单','t4'=>'栏目投稿'];
        $this->assign('type',$this->type);
    }
	// 会员菜单
	public function index()
	{
		if(Request::isPost())
		{
			$data = UsermenuModel::order('torder')->hidden(['content'])->paginate(Request::post('limit/d'))->withAttr('type',function($value,$data){
				if(isset($this->type[$value])) {
					return $this->type[$value];
				} else {
					return '其他栏目';
				}
				
			})->toArray();
			return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$data['data'],'count'=>$data['total']]);
		}
		return $this->fetch('');
	}

	// 会员菜单增加
	public function add()
	{
		if(Request::isPost()) {
			$data = Request::post();
			$this->checkData($data);
			if(!empty($data['usergroupids'])) {
				$data['usergroupids'] = implode(",",$data['usergroupids']);
			} else {
				$data['usergroupids'] = NULL;
			}
			$result = UsermenuModel::create($data,true);
			adminlog(2,'新增('.UsermenuModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('addtrue'));
			} else {
				$this->error(lang('addfalse'));
			}
		}
		return $this->fetch();
	}

	// 会员菜单编辑
	public function edit($id)
	{
		$info = UsermenuModel::get($id);
		if(empty($info)) $this->error(lang('norecord'));
		if(Request::isPost()) {
			$data = Request::post();
			unset($data['type']);
			unset($data['create_time']);
			$this->checkData($data);
			if(!isset($data['list_switch'])) {
				if(!empty($data['usergroupids'])) {
					if(is_array($data['usergroupids'])) $data['usergroupids'] = implode(",",$data['usergroupids']);
				} else {
					$data['usergroupids'] = NULL;
				}
				if(isset($data['content'])) {
	            	$data['content'] = json_encode($data['content']);
	            }
			}
			$result = $info->allowField(true)->save($data);
			adminlog(2,'编辑('.UsermenuModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('edittrue'));
			} else {
				$this->error(lang('editfalse'));
			}
		}
		if(!empty($info['content'])) {
			$info['content'] = json_decode($info['content'],true);
		}
		return $this->fetch('',compact('info'));
	}

	// 会员菜单删除
	public function del()
	{
		if(Request::isPost()) {
			$data = Request::post();
			$result = UsermenuModel::destroy($data['id']);
			adminlog(2,'删除('.UsermenuModel::getLastsql().')',$result?1:0);
			if ($result) {
				$this->success(lang('deltrue'));
			} else {
				$this->error(lang('delfalse'));
			}
		}
	}

	// 数据验证
	private function checkData($data)
	{
		if(!isset($data['list_switch'])) {
			$validate = new \app\admin\validate\Usermenu;
			if(!$validate->check($data)) {
				$this->error($validate->getError());
			}
		}
	}
}