<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-06-28
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\model;
use think\Model as BaseModel;
use app\common\model\User;
use app\admin\model\Admingroup;

class Admin extends BaseModel
{
	public function getLogindataAttr()
	{
		$loginlog = $this->adminlog()->whereType(1);
		$maxid = $loginlog->max('id');
		return ['count' => $loginlog->count(),'lstip' => $loginlog->getFieldById($maxid,'ip'),'lsttime' => date("Y-m-d H:i:s",$loginlog->getFieldById($maxid,'create_time'))];
	}

	// 管理登陆
	public static function adminLogin($data)
	{
		try {
			$validate = new \app\admin\validate\Admin;
			if(!$validate->scene('login')->check($data)) {
				return ['code'=>0 ,'msg'=>$validate->getError()];
			}
			// 查找所属管理组且状态为开启
			$has = self::hasWhere('admingroup',[['Admingroup.status','=',1]])
						->where([['username','=',$data['username']],['Admin.status','=',1]])
						->find();
			if($has) {
				if($has['password']===md5($data['password'].$has['salt'])) {
					session('adminid',$has['id']);
					session('session_start_time',NULL);
					if($has['siteids']) session('siteid',$has['siteids']);
					adminlog(1,'登陆系统');
					return ['code'=>1 ,'msg'=>lang('logintrue')];
				} else {
					adminlog(1,'密码错误(用户名:'.$data['username'].',密码:'.$data['password'].')',0);
					return ['code'=>0 ,'msg'=>lang('loginfalse')];
				}
			} else {
				adminlog(1,'登陆失败(用户名:'.$data['username'].',密码:'.$data['password'].'),检查用户名存在性或组状态',0);
				return ['code'=>0 ,'msg'=>lang('loginfalse')];
			}
		} catch (\Exception $e) {
			adminlog(1,'系统错误('.$e->getMessage().')',0);
			return ['code'=>0 ,'msg'=>$e->getMessage()];
		}
		
	}

	// 管理员信息
	public static function getAdminInfo($id)
	{
		$result = self::hasWhere('admingroup',[['Admingroup.status','=',1]])->where([['Admin.id','=',$id],['Admin.status','=',1]])->with('admingroup')->hidden(['password','salt'])->find();
		// 获取开发组权限
		if($result) {
			if($result['admingroup']['id'] == 1) {
				$result['isboss'] = true;
				$result['userids'] = [];
			} else {
				$result['isboss'] = false;
				$result['userids'] = User::whereAdminId($result['id'])->column('id');
			}
		}
		return $result;
	}

	// 关联
	public function adminGroup()
	{
		return $this->belongsTo('Admingroup')->field(['id','pid','title','status','rules']);
	}

	public function adminlog()
	{
		return $this->hasMany('Adminlog');
	}

	public function user()
	{
		return $this->hasMany('\app\common\model\User');
	}
}