<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-07-15
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\model;
use think\Model as Basemodel;
use app\admin\model\Cmsmodels;
use app\common\model\About;

class Navlist extends Basemodel
{
	protected $type = [
        'config' => 'json'
    ];
	
    // 全局查询范围
    protected function base($query)
    {
        $query->where('site_id',session('siteid'));
    }

    // 标签中不调用
	public function getUrlAttr($value,$data) {
		if($data['type'] == 'link') return $data['link'];
		$siteinfo = $this->site;
		$sitealias = $siteinfo->isdefault ? '' : '/'.$siteinfo->alias;
		if($data['alias']) {
			return $sitealias.'/'.$data['alias'].'/';
		}
		return $sitealias.'/n-'.$data['id'].'/';
	}

    public function getNavtypeAttr($value,$data)
	{
		switch ($data['type']) {
			case 'about':
				$result = '单页';
				$about = About::get($data['typeid']);
				if(empty($about)) {
					$result .= '<font color="#FF5722">【单页不存在】</font>';
				} else {
					$result .= '<font color="#5FB878">【'.$about['title'].'】</font>';
				}
				break;
			case 'model':
				$result = '模型';
				$model = Cmsmodels::whereType(1)->get($data['typeid']);
				if(empty($model)) {
					$result .= '<font color="#FF5722">【模型不存在】</font>';
				} else {
					$result .= '<font color="#5FB878">【'.$model['title'].'】</font>';
				}
				break;
			case 'link':
				$result = '链接';
				break;
			case 'system':
				$result = '系统';
				break;
			default:
				$result = '其他';
				break;
		}
		return $result;
	}

	// 判断是否有子孙
	public function getHaschildAttr($value,$data)
	{
		$haschild = $this->wherePid($data['id'])->count();
		return $haschild ? true : false;
	}

	public function setAliasAttr($value)
	{
		return preg_replace('/\s/','',strtolower($value)); // 去空
	}

	// 获取下拉列表树数据
	public static function getNavlisttree($siteid,$id='')
	{
		$data = self::when(!empty($id),function($query)use($id){
			$query->whereId('<>',$id);
		})->whereSiteId($siteid)->order('torder','id')->select()->toArray();
		$data = array_merge([['id' => 0,'pid' => -1,'name' => '顶级栏目']],$data);
		return \rg\PHPTree::makeTree($data,['top_pv' => -1]);
	}

	// 根据模型获取分类
	public static function getNavlistByModel($siteid,$model_id)
	{
		$data = self::whereType('model')->whereTypeid($model_id)->withAttr('pid',function($value,$data) use($model_id){
			if($value !== 0) {
				$info = self::whereType('model')->whereTypeid($model_id)->get($value);
				if(!$info) {
					return 0;
				} else {
					return $value;
				}
			} else {
				return $value;
			}
		})->withAttr('title',function($value,$data){
			return $data['name'];
		})->withAttr('spread',function($value,$data){
			return true;
		})->whereSiteId($siteid)->append(['title','spread'])->order('torder','id')->select()->toArray();
		if($data) {
			return \rg\PHPTree::makeTree($data);
		} else {
			return [];
		}
	}

	// 关联model模型
	public function cmsmodels()
	{
		return $this->belongsTo('Cmsmodels');
	}

	public function site()
	{
		return $this->belongsTo("app\common\model\Site");
	}
}