<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-06
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\validate;
use think\Validate;

class Admin extends Validate
{
	
	protected $rule = [
		'username|用户名' => 'unique:admin|require|alphaNum|min:5',
		'password|密码'   => 'require|alphaNum|min:6',
		'nickname|昵称'   => 'require|min:2',
		'email|电子邮箱'  => 'email',
		'mobile|手机号码' => 'mobile',
		'status|会员开关' => 'in:0,1'
	];

	//登陆场景
	public function sceneLogin()
	{
		return $this->only(['username','password']) // 只验证用户名和密码
					->remove('username','unique'); // 移除规则
	}

	//编辑场景
	public function sceneEdit()
	{
		return $this->remove('password','require');
	}
}