<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-06
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\admin\validate;
use think\Validate;

class User extends Validate
{
	
	protected $rule = [
		'username|用户名'    => 'require|min:5|unique:user',
		'nickname|昵称'   	 => 'require|min:5|unique:user',
		'password|密码'      => 'require|confirm|alphaNum|min:6',
		'email|电子邮箱'	 => 'email|unique:user',
		'mobile|手机号码' 	 => 'mobile|unique:user',
		'status|会员开关' 	 => 'in:0,1',
		'torder|排序'     	 => '>:0|integer'
	];

	//编辑场景
	public function sceneEdit()
	{
		return $this->remove('password','require');
	}
}