<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-07-14
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\common\model;
use think\Model;
use think\model\concern\SoftDelete;

class About extends Model
{
	use SoftDelete;
	protected $defaultSoftDelete = 0;
    protected $json = ['extend'];
    protected $jsonAssoc = true;
	// 自动完成
	protected $insert = ['site_id','admin_id'];
	protected function setSiteIdAttr()
    {
        return session('siteid');
    }
    protected function setAdminIdAttr()
    {
        return session('adminid');
    }
    public function getDeleteTimeAttr($value)
    {
        return date("Y-m-d H:i:s",intval($value));
    }
    // URL
    public function getUrlAttr($value,$data)
    {
        $alias = Site::cache(config("app.home.homecache"))->getFieldById($data['site_id'],'alias');
        return url("about/index",["lang" => $alias,"id" => $data["id"]]);
    }
    // 动态字段
    public function getExtAttr($value,$date)
    {
        return Diyfields::whereTablename('about')->whereCid($date['id'])->whereStatus(1)->cache(config("app.home.homecache"))->column('value','name');
    }
	// 关联管理员
	public function admin()
	{
		return $this->belongsTo('Admin')->field(['password','salt'],true);
	}
}