<?php
/**
* @author 龙虾 <15108148@qq.com>
* @copyright 睿谷信息 <www.rgxx.com>
* @todo 自定义模型类
*/
namespace app\common\model;
use think\Model;
use app\common\model\Site;
use think\model\concern\SoftDelete;

class Articlemodel extends Model
{
	use SoftDelete;
	protected $defaultSoftDelete = 0;
	protected $json = ['extend'];
    protected $jsonAssoc = true;

    public function getCreateTimeAttr($value)
    {
        return date("Y-m-d H:i:s",intval($value));
    }
    public function getUpdateTimeAttr($value)
    {
        return date("Y-m-d H:i:s",intval($value));
    }
    public function getDeleteTimeAttr($value)
    {
        return date("Y-m-d H:i:s",intval($value));
    }
	// 关联站点
	public function site()
	{
		return $this->belongsTo('Site');
	}
	// 只适用于详情页调用URL
    public function getUrlAttr($value,$data)
    {
    	if(!empty($data["link"])) return $data["link"];
    	$siteinfo = $this->site()->get($data['site_id']);
    	$navinfo = $this->navlist()->get($data['navlist_id']);
    	if($siteinfo['isdefault'] == 1) {
    		$sitealias = '/';
    	} else {
    		$sitealias = '/'.$siteinfo['alias'].'/';
    	}
    	$navalias = $navinfo['alias'] ?: ('n-'. $navinfo['id']);
    	return $sitealias.$navalias.'/'.($data['alias']?:$data['id']).'.html';
    }
	// 关联栏目
	public function navlist()
    {
    	return $this->belongsTo('Navlist');
    }
	// 关联评论
	public function comment()
	{
		return $this->hasMany('Comment');
	}
	// 关联用户
	public function user()
	{
		return $this->belongsTo('User')->field(['password','salt'],true);
	}
	// 关联管理员
	public function admin()
	{
		return $this->belongsTo('Admin')->field(['password','salt'],true);
	}
	// 关联模型
	public function cmsmodels()
	{
		return $this->belongsTo('Cmsmodels');
	}
}