<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-07-29
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\common\model;
use think\Model;
use app\common\model\Cmsmodels;
use app\common\model\Site;

class Navlist extends Model
{
	protected $type = [
        'config' => 'json'
    ];
    protected $append = ['ext'];
    protected $hidden = ['config'];
    public function getExtAttr($value,$data) {
    	return json_decode($data['config'],true);
    }
	// 标签中不调用
	public function getUrlAttr($value,$data) {
		if($data['type'] == 'link') return $data['link'];
		$siteinfo = Site::get($data['site_id']);
		$sitealias = $siteinfo->isdefault ? '' : '/'.$siteinfo->alias;
		if($data['alias']) {
			return $sitealias.'/'.$data['alias'].'/';
		}
		return $sitealias.'/n-'.$data['id'].'/';
	}

	public function getHasChildAttr($value,$data)
	{
		return $this->wherePid($data['id'])->cache(config("app.home.homecache"))->count();
	}

	public function cmsmodels()
	{
		return $this->belongsTo("Cmsmodels","typeid");
	}

	public function site()
	{
		return $this->belongsTo("Site");
	}

}