<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-06
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\common\model;
use think\Model as Basemodel;

class Site extends Basemodel
{
	protected $autoWriteTimestamp = false;
	// 设置为小写
    public function setAliasAttr($value)
    {
        return strtolower($value);
    }
    public function getCreateTimeAttr($value)
    {
    	return date('Y-m-d',intval($value));
    }
    public function getEndTimeAttr($value)
    {
    	return date('Y-m-d',intval($value));
    }

    public function getUrlAttr($value,$data)
	{
		if($data['isdefault']) {
			return '/';
		}
		return '/'.$data['alias'];
	}

	public function getExpiredAttr($value,$data)
	{
		//0过期,1正常
		return $data['end_time'] < time() ? 0 : 1;
	}

	// 关联
	public function domains()
	{
		return $this->hasMany('Domains');
	}
	public function navlist()
	{
		return $this->hasMany('Navlist');
	}
	public function about()
	{
		return $this->hasMany('About');
	}
	public function sitekey()
	{
		return $this->hasMany('Sitekey');
	}
	public function navgroup()
	{
		return $this->hasMany('Navgroup');
	}
	public function diyfields()
	{
		return $this->hasMany('Diyfields');
	}
	public function visits()
	{
		return $this->hasMany('Visits');
	}
}