<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------

// 栏目内容往上寻找
function findup($strvalue,$field = 'img',$nid = '')
{
    if(!empty($strvalue)) {
        return $strvalue;
    } else {
        // 获取栏目ID
        if(empty($nid)) {
            $nid = NAVID;
        }
        // 获取父ID
        $info = model('navlist')->get($nid);
        if($info['pid'] !== 0) {
            $pstrvalue = model('navlist')->where('id',$info['pid'])->value($field);
            return findup($pstrvalue,$field,$info['pid']);
        } else {
            return $info[$field];
        }
    }
}



// 关键词内链替换排序
function cmp($a, $b)
{
    if (mb_strlen($a) == mb_strlen($b)) {
        return 0;
    }
    return (mb_strlen($a) < mb_strlen($b)) ? 1 : -1;
}

// 敏感词过滤
function guolv($content)
{
    if(!empty(config('app.home.blackwords'))) {
        $arr = explode(',',config('app.home.blackwords'));
        // 添加定界符
        $arr = array_map(function($v){return '/'.$v.'/';},$arr);
        $prg = '*';
        $content = preg_replace($arr, $prg, $content);
    }
    return $content;
}

// TKD信息转换
function getTKD($seoinfo,$str='')
{
    if(!empty($str)) {
        $match = array();  
        preg_match_all('/{\$(.*?)}/', $str, $match);
        foreach($match[1] as $key => $value) {  
            if(isset($seoinfo[$value])) {  
                $str = str_replace($match[0][$key], $seoinfo[$value], $str);  
            }  
        }
    }
    return $str;
}

// 获取栏目信息
function getNav($id,$item='')
{
    $navinfo = app\common\model\Navlist::cache(config("app.home.homecache"))->append(['url'])->get($id);
    if(!empty($navinfo)) {
        if(empty($item)) {
            return $navinfo;
        } else if(!empty($navinfo[$item])){
            return $navinfo[$item];
        }
    } else {
        return '';
    }
}

function getFromPage()
{
    $referer = request()->header('referer');
    if($referer) {
        if(strstr( $referer, 'baidu.com')){ //百度
            $from = 'baidu';
        }elseif(strstr( $referer, 'google.com') or strstr( $referer, 'google.cn')){ //谷歌
            $from = 'google';
        }elseif(strstr( $referer, 'so.com')){ //360搜索
            $from = '360'; 
        }elseif(strstr( $referer, 'sogou.com')){ //搜狗
            $from = 'sogou';   
        }elseif(strstr( $referer, 'soso.com')){ //搜搜
            $from = 'soso';
        }else {
            $from = $referer;
        }
    } else {
        $from = '网址输入';
    }
    return $from; 
}



// 安全IP检测，支持IP段检测
function is_safe_ip($ip="",$ips=""){
    if(!$ip) $ip = get_client_ip();  //获取客户端IP
    if($ips){
        if(is_string($ips)){
            //ip用"," 例如白名单IP：192.168.1.13,123.23.23.44,193.134.*.*
            $ips = explode(",", $ips);
        }
    }else{
        //读取后台配置 白名单IP
        $obj = new Setting();
        $ips = explode(",", $obj->getConfig("whiteip"));
    }
    if(in_array($ip, $ips)){
        return true;
    }
    $ipregexp = implode('|', str_replace( array('*','.'), array('\d+','\.') ,$ips));
    $rs = preg_match("/^(".$ipregexp.")$/", $ip);
    if($rs) return true;
    return;
} 
// 前端生成缩略图
function thumb($path, $width, $height,$position = 2,$quality=80,$type=null) {
    if(empty($path) || $width < 1 || $height < 1) return $path;
    $file = pathinfo($path); 
    $dirname = $file['dirname']; 
    $filename = $file['filename']; 
    $ext = $file['extension']; 
    if(!in_array($ext,['jpg','jpeg','gif','png'])) return $path;
    $savePath = '/'.config('app.upload.uppath').'/thumb/';
    if (!is_dir ('.'.$savePath )) {
        mkdir('.'.$savePath, 0777, true );
    }
    $thumbPath = $savePath . $filename . "_" . $width . "_" . $height . "." . $ext;
    if(!is_file('.'.$thumbPath)) {
        $image = \think\Image::open('.'.$path);
        if($width >= $image->width() && $height >= $image->height()) {
            return $path;
        }
        $image->thumb($width, $height,$position)->save('.'.$thumbPath,$type,$quality);
    }
    return $thumbPath;
}