<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-07-31
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\home\controller;
use app\common\model\About as AboutModel;

class About extends Base
{
    protected $route;
    protected function initialize()
    {
        parent::initialize();
        $this->route = $this->request->route();
        if(empty($this->route['id'])) abort(404,lang('param_error'));
    }
    // 单页
    public function index()
    {
        $info = AboutModel::whereStatus(1)->whereSiteId(SITEID)->append(['ext','url'])->get($this->route['id']);
        if(!$info) abort(404,lang('content_error'));
        if(!$this->CheckUgids($info['ugids'])) $this->redirect('user/index/login');
        // 检测模板
        $tpl = $info['template'] ? $this->htmldir . $info['template'] : $this->htmldir . 'about_content.html';
        if(!file_exists($tpl)) abort(500,lang('temp_error').basename($tpl));
        // 待写
        $info->setInc('hits');
        // SEO信息
        $this->seoinfo['seo_title'] = $info['title'].','.$this->seoinfo['seo_title'];
        $this->seoinfo['seo_keys'] = $info['keys'] ?: $this->seoinfo['seo_keys'];
        $this->seoinfo['seo_desc'] = $info['desc'] ?: $this->seoinfo['seo_desc'];
        $this->assign($this->seoinfo);
        // 构建详情信息标签{$info_*形式}
        $aboutinfo = arr2one($info->toArray(),'info');
        $this->assign($aboutinfo);
        return $this->fetch($tpl);
    }
}
