<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-10
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\home\controller;
use app\common\model\Cmsmodels;
use think\facade\Cache;

class Content extends Base
{
    protected $route;
    protected $modelinfo;
    protected function initialize()
    {
        parent::initialize();
        $this->route = $this->request->route();
        if(!$this->route['mid'] || !$this->route['id']) abort(404,lang('param_error'));
        $this->modelinfo = Cmsmodels::get($this->route['mid']);
    }

    // 模型详情
    public function detail()
    {
        if(!$this->modelinfo) abort(404,lang('model_no'));        
        $Class = "app\\common\\model\\".$this->modelinfo['classname'];
        $info = (new $Class)::whereStatus(1)->whereSiteId(SITEID)->append(['url'])->get($this->route['id']);
        if(!$info) abort(404,lang('content_error'));
        // 检测模板
        $tpl = $info['template'] ? $this->htmldir . $info['template'] : $this->htmldir . $this->modelinfo['name'].'_content.html';
        if(!file_exists($tpl)) abort(500,lang('temp_error').basename($tpl));
        $info->setInc('hits');
        // 上一篇--ID比较
        $prev = (new $Class)::whereStatus(1)->whereSiteId(SITEID)->where('id','>',$this->route['id'])->order('id asc')->append(['url'])->find();
        // 下一篇--ID比较
        $next = (new $Class)::whereStatus(1)->whereSiteId(SITEID)->where('id','<',$this->route['id'])->order('id desc')->append(['url'])->find();
        // 构建详情信息标签{$info_*形式}
        $contentinfo = arr2one($info->toArray(),'info');
        $this->assign($contentinfo);
        // SEO信息
        $this->seoinfo['seo_title'] = $info['title'].','.$this->seoinfo['seo_title'];
        $this->seoinfo['seo_keys'] = $this->seoinfo['seo_keys'];
        $this->seoinfo['seo_desc'] = $this->seoinfo['seo_desc'];
        $this->assign($this->seoinfo);
        return $this->fetch($tpl,compact('prev','next'));
    }
}
