<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-21
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\home\controller;
use app\common\model\Cmsmodels;
use app\common\model\Cmsfields;
use Request;

class Form extends Base
{
	protected $modelclass;
	protected $modelinfo;
	protected $config;
	protected function initialize()
    {
    	parent::initialize();
    	// 判断请求信息
    	if(!Request::isPost()) $this->error(lang('no_access'));
    	$model = Request::post('model');
    	if(empty($model)) $this->error(lang('param_error'));
    	// 获取模型信息
    	$this->modelinfo = Cmsmodels::whereName($model)->with('cmsfields')->whereType(3)->find();
    	if(!$this->modelinfo) $this->error(lang('model_no'));
    	$this->config = $this->modelinfo['config'];
    	if($this->config['isstatus'] == 0) $this->error(lang('formid_error'));
    	$this->modelclass = 'app\\common\\model\\'.$this->modelinfo['classname'];
        if(!class_exists($this->modelclass)) $this->error('model_no');
    }
    public function index()
    {
    	// 获取模型自定义字段列表
    	$onlyfields = array_merge(['__form__','captcha'],array_column($this->modelinfo['cmsfields']->toArray(),'name'));
    	// 过滤
    	Request::filter(['trim','strip_tags','htmlspecialchars']);
    	// 过滤其他非自定义字段
		$data = Request::only($onlyfields);
		// 数据验证
        $this->checkData($data);
        // 令牌验证
        if(!$this->checkToken($data)){
            $this->error(lang('token_error')); 
        }
        // 验证验证码
        if($this->config['isverify'] == 1) {
        	if(empty($data['captcha'])) {
                $this->error('请填写验证码');
            }
            if(!captcha_check($data['captcha'])) {
                $this->error("验证码错误");
            }
        }
        // 会员登陆验证
        if($this->config['isuser'] == 1 && !session('?userid')) {
        	$this->error("请登陆会员");
        }
        // 拼装其他信息
        $data['user_ip'] = request()->ip();
        $data['site_id'] = SITEID;
        $data['user_id'] = session('?userid') ? session('userid') : 0;
        $data['status'] = !empty($this->config['ispass']) ? $this->config['ispass'] : 1;
        // 存数据
        $__M = $this->modelclass;
        $result = $__M::create($data,true);
        if ($result) {
        	// 邮件发送
            if(config('app.email.email') && !empty($this->config['email'])) {
                $array = explode('|',$this->config['email']);
                $emailcontent = "";
                if(config('app.email.emailtype')==1) {
                    $emailcontent = lang('new_message_view');
                } else {
                    foreach ($this->modelinfo['cmsfields']->order('torder','asc')->toArray() as $k => $v) {
                        $emailcontent .= "{$v['title']}:".(isset($data[$v['name']])?$data[$v['name']]:"")."<br>";
                    }
                }
                foreach ($array as $k => $v) {
                	if(filter_var($v, FILTER_VALIDATE_EMAIL) !== false) {
                		sendMail($v,lang('new_message'),$emailcontent);
                	}
                }
            }
			$this->success(lang('sub_success'));
		} else {
			$this->error(lang('sub_error'));
		}
	}

	// 令牌验证
    private function checkToken($data)
    {
        if (empty($data['__form__'])) {
            return false;
        }
        $validate = \Validate::make(['__form__' => 'token:__form__']);
        if (!$validate->check(['__form__' => $data['__form__']])) {
            return false;
        }
        return true;
    }

	// 数据验证
	private function checkData($data)
	{
		$validate = new \think\Validate;
		$rulelist = [];
		$listfields = $this->modelinfo['cmsfields'];
		foreach ($listfields as $k => $v) {
			$rule = [];
			// 必填
			if($v['require'] == 1) {
				$rule = array_merge(['require'],$rule);
			}
			// 文本域
			if($v['type'] == 'input' && !empty($v['rule'])) {
				if($v['rule'] == 'regex') {
					$rule = array_merge(["regex:".$v['rule']],$rule);
				} else {
					$rule = array_merge([$v['rule']],$rule);
				}
			}
			// 整数
			if($v['type'] == 'integer') {
				$rule = array_merge(['integer'],$rule);
			}
			// 小数
			if($v['type'] == 'decimal') {
				$rule = array_merge(['float'],$rule);
			}
			$rulelist[$v['name'].'|'.$v['title']] = $rule;
		}
		$validate->rule($rulelist);
		if (!$validate->check($data)) {
			$this->error($validate->getError());
		}
	}
}
