<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-26
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\home\controller;

class Index extends Base
{
    public function index()
    {
        // 首页模板
        $siteinfo = $this->siteinfo;
        $tpl = $this->htmldir.config('app.home.indexhtmlname').'.html';
        $this->assign($this->seoinfo);
        if(!file_exists($tpl)) abort(500,lang('temp_error').basename($tpl));
        // 静态首页文件
        if(config('app.home.indexhtml')) {
            //文件修改时间和现在时间，直接导向html文件，否则重新生成html
            if(file_exists($this->indexhtml) && time() - filemtime($this->indexhtml) < intval(config('app.home.indexhtmltime'))*60) {
                return file_get_contents($this->indexhtml);
            } else {
                $content = $this->fetch($tpl)->getContent();
                $fp = fopen($this->indexhtml, 'w');
                fwrite($fp, $content);
                fclose($fp);
                return $content;
            }
        } else {
            return $this->fetch($tpl);
        }
    }
}
