<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-16
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\home\controller;
use app\common\model\Navlist;
use app\common\model\Cmsmodels;
use app\common\model\About;
use app\common\model\Diyfields;
use think\facade\Cache;

class Nav extends Base
{
    // 当前栏目信息
    protected $navinfo;
    // 路由
    protected $route;
    protected function initialize()
    {
        parent::initialize();
        $this->route = $this->request->route();
        // 获取栏目id或者alias
        // 获取当前栏目信息
        if(empty($this->route['nalias']) && empty($this->route['nid'])) abort(404,lang('param_error'));
        if(!empty($this->route['nalias'])) {
            $navinfoAlias = array_column($this->navlist,NULL,'alias');
            $this->navinfo = isset($navinfoAlias[$this->route['nalias']]) ? $navinfoAlias[$this->route['nalias']] : abort(404,lang('nav_error'));
        } else {
            $navinfoId = array_column($this->navlist,NULL,'id');
            $this->navinfo = isset($navinfoId[$this->route['nid']]) ? $navinfoId[$this->route['nid']] : abort(404,lang('nav_error'));
        }
        if(!$this->navinfo['status']) abort(404,lang('nav_error'));
        define('NAVID',$this->navinfo['id']);
        // 会员权限
        if($this->navinfo['type']=='model' && !$this->CheckUgids($this->navinfo['ugids'])) $this->redirect('user/index/login');
        // 获取所有父级包括自己
        $fnavlist = get_father($this->navlist,NAVID);
        // 获取所有父级ID括自己
        $this->navinfo['fids'] = implode(',',array_column($fnavlist,'id'));
        // 构建栏目信息标签{$nav_*形式}
        $navinfo = arr2one($this->navinfo,'nav');
        $this->assign($navinfo);
        // 构建最顶层栏目信息标签{$topnav_*形式}
        $topnav = arr2one($fnavlist[0],'topnav');
        $this->assign($topnav);
        // SEO信息
        $this->seoinfo['seo_title'] = $this->seoinfo['seo_nav_title'] ? getTKD($navinfo,$this->seoinfo['seo_nav_title']) : $this->navinfo['name'].','.$this->seoinfo['seo_title'];
        $this->seoinfo['seo_keys'] = $this->navinfo['keys'] ?: $this->seoinfo['seo_keys'];
        $this->seoinfo['seo_desc'] = $this->navinfo['desc'] ?: getTKD($navinfo,$this->seoinfo['seo_nav_desc']);
        $this->seoinfo['seo_info_title'] = getTKD($navinfo,$this->seoinfo['seo_info_title']);
    }
    // 栏目内容
    public function index()
    {
        switch ($this->navinfo['type']) {
            case 'link': // 多此一举
                $this->redirect($this->navinfo->link);
                break;
            case 'about':
                $info = About::whereStatus(1)->append(['ext'])->get($this->navinfo['typeid']);
                if(!$info) abort(404,lang('content_error'));
                if(!$this->CheckUgids($info->ugids)) $this->redirect('user/index/login');
                // 检测模板
                $tpl = $info->template? $this->htmldir . $info->template : $this->htmldir . 'about_content.html';
                if(!file_exists($tpl)) abort(500,lang('temp_error').basename($tpl));
                $info->setInc('hits');
                // SEO信息
                $this->seoinfo['seo_keys'] = $info->keys ?: $this->seoinfo['seo_keys'];
                $this->seoinfo['seo_desc'] = $info->desc ?: $this->seoinfo['seo_desc'];
                // 构建单页信息标签{$info_*形式}
                $aboutinfo = arr2one($info->toArray(),'info');
                $this->assign($this->seoinfo);
                $this->assign($aboutinfo);
                return $this->fetch($tpl);
                break;
            case 'model':
                $modelinfo = $this->navinfo['cmsmodels'];
                if(!$modelinfo) abort(404,lang('model_no'));
                $tpl = $this->navinfo['listtemp'] ? $this->htmldir . $this->navinfo['listtemp'] : $this->htmldir . $modelinfo['name'] .'_list.html';
                if(!file_exists($tpl)) abort(500,lang('temp_error').basename($tpl));
                // 构建栏目页面模型标签{$navmodel_*形式}
                $model = arr2one($modelinfo,'modelinfo');
                $this->assign($model);
                $this->assign($this->seoinfo);
                return $this->fetch($tpl);
                break;
            default:
                abort(404,'未知栏目类型');
                break;
        }
    }

    // 栏目模型详情
    public function detail()
    {
        if($this->navinfo['type'] !== 'model') abort(404,lang('nav_error'));
        $cmsmodels = $this->navinfo['cmsmodels'];
        $Class = "app\\common\\model\\".$cmsmodels['classname'];
        $cid = $this->route['cid'];
        $_class = new $Class;
        $info = $_class::whereStatus(1)->when(is_numeric($cid),function($query)use($cid){
            $query->whereId($cid);
        },function($query)use($cid){
            $query->whereAlias($cid)->whereNavlistId(NAVID);
        })->find();
        if(!$info) abort(404,lang('content_error'));
        if(!empty($info->link)) $this->redirect($info->link);
        // 检测模板
        $tpl = $info->template ? $this->htmldir . $info->template : ($this->navinfo['infotemp'] ? $this->htmldir . $this->navinfo['infotemp'] : $this->htmldir . $cmsmodels['name'] . '_content.html');
        if(!file_exists($tpl)) abort(500,lang('temp_error').basename($tpl));
        $info->setInc('hits');
        // 动态字段
        $info->ext = Diyfields::whereTablename($cmsmodels['tablename'])->whereCid($info->id)->whereStatus(1)->column('value','name');
        // 上一篇--ID比较
        $prev = $_class::whereStatus(1)->whereSiteId(SITEID)->whereNavlistId(NAVID)->where('id','>',$info->id)->order('id asc')->append(['url'])->find();
        // 下一篇--ID比较
        $next = $_class::whereStatus(1)->whereSiteId(SITEID)->whereNavlistId(NAVID)->where('id','<',$info->id)->order('id desc')->append(['url'])->find();
        // 详情页模型信息
        $model = arr2one($cmsmodels,'modelinfo');
        $this->assign($model);
        // 构建详情信息标签{$info_*形式}
        $contentinfo = arr2one($info->toArray(),'info');
        $this->assign($contentinfo);
        // SEO信息
        $this->seoinfo['seo_title'] = $this->seoinfo['seo_info_title'] ? getTKD($contentinfo,$this->seoinfo['seo_info_title']) : $info['title'].','.$this->seoinfo['seo_title'];
        $this->seoinfo['seo_keys'] = $info['keys'] ?: $this->seoinfo['seo_keys'];
        $this->seoinfo['seo_desc'] = $info['desc'] ?: $this->seoinfo['seo_desc'];
        $this->assign($this->seoinfo);
        return $this->fetch($tpl,compact('prev','next'));
    }
}
