<?php
namespace app\home\taglib;
use think\template\TagLib;

class Rg extends TagLib {
	protected $tags = [
    'site'      => ['attr' => '','close' => 1], // 站点列表
	'nav'		=> ['attr' => '','close' => 1], // 栏目
    'navi'      => ['attr' => '','close' => 1], // 栏目(极速)
    'list'      => ['attr' => '','close' => 1], // 栏目内容列表
    'location'  => ['attr' => '','close' => 0], // 面包屑
    'func'      => ['attr' => 'name','close' => 1], // 功能列表
    'atta'      => ['attr' => '','close' => 1], // 附属内容列表
    'about'     => ['attr' => '','close' => 1], // 单页内容
    'imgs'      => ['attr' => 'imgs','close' => 1], // 多图解析
    'cons'      => ['attr' => 'cons','close' => 1], // 多内容解析
    'form'      => ['attr' => 'model','close' => 1], // 表单内容列表，model可为模型ID或模型标识
    'each'      => ['attr' => 'str','close' => 1], // 字符串分割遍历
    'search'    => ['attr' => '','close' => 1], // 搜索
    'region'    => ['attr' => '','close' => 1], // 地区
    'sitekey'   => ['attr' => '','close' => 1], // 关键词
    'diypage'   => ['attr' => '','close' => 1], // 自定义分页
    'content'   => ['attr' => 'id,model','close' => 1], // 调用指定ID的模型内容
    'attr'      => ['attr' => 'name','close' => 1], // 属性
    'count'     => ['attr' => '','close' => 0] // 内容统计
	];

    // 站点列表
    public function tagSite($tag, $content)
    {
        // 基础数据
        $name   = empty($tag['name']) ? "site" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $empty  = empty($tag['empty']) ? "" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        $limit = empty($tag['limit']) ? "" : $tag['limit'];// 输出记录数
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $__data__ = cache("site_nav_list");'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'" length="'.$limit.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

	// 栏目
	public function tagNav($tag, $content)
	{
    	// 基础数据
    	$siteid = empty($tag['site']) ? SITEID : $tag['site'];// 站点ID
    	$limit	= empty($tag['limit']) ? 0 : intval($tag['limit']);// 调用数量
    	$name	= empty($tag['name']) ? "nav" : $tag['name'];// 变量名称
    	$key	= empty($tag['key']) ? "i" : $tag['key'];// 计数变量
    	$order	= empty($tag['order']) ? "torder asc,id desc" : $tag['order'];// 排序规则
    	$empty	= empty($tag['empty']) ? "" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
    	// 调用参数
    	$pid	= empty($tag['pid']) ? 0 : $tag['pid'];// 根据上级栏目ID
    	$model	= empty($tag['model']) ? "" : $tag['model'];// 根据模型栏目，如news
    	$id		= empty($tag['id']) ? "" : $tag['id'];// 根据具体栏目ID，可为1,2,3,PID失效
    	$eid	= empty($tag['eid']) ? "" : $tag['eid'];// 排除的栏目ID，可为1,2,3
    	$group	= empty($tag['group']) ? "G0" : strtoupper($tag['group']);// 根据栏目分组，如G1,PID失效
        // 20201229新增
        $palias = empty($tag['palias']) ? "" : $tag['palias'];// 根据上级栏目alias，如about
        $alias  = empty($tag['alias']) ? "" : $tag['alias'];// 根据具体栏目alias，如about,product,pic
    	// 调用条件
    	$where	= empty($tag['where']) ? "" : $tag['where'];// 调用条件
        // 会员模块不使用缓存
        if(request()->module() !== 'user') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        // where字段拼接查询
        $where_str = "->where('".$group."',1)->whereStatus(1)->whereSiteId(".$siteid.")";
        $where_str .= !empty($id) ? "->whereIn('id',".$this->transVar($id).")" : "";
        $where_str .= !empty($eid) ? "->whereNotIn('id',".$this->transVar($eid).")" : "";
        $where_str .= !empty($alias) ? "->whereIn('alias',explode(',',".$this->transVar($alias)."))" : "";
        if($group == 'G0' && empty($id) && empty($alias)) {
            $where_str .= "->wherePid(\$pid)";
        }
        $where_str .= !empty($where) ? "->where(\$where)" : "";
    	// 解析
    	$parse = '<?php 
        $__data__ = array();
        $pid = '.$pid.';
        $model = '.$this->transVar($model).';
        $where = "'.$where.'";
        $palias = '.$this->transVar($palias).';
        $__siteinfo = array_column(cache("site_nav_list"),NULL,"id")['.$siteid.'];
        $typeid = !empty($model) ? app\\common\\model\\Cmsmodels::getFieldByName($model,"id") : "";
        if(!empty($palias)) {
            $__navlist = array_column($__siteinfo["navlist"],NULL,"alias");
            if(isset($__navlist[$palias])) $pid = $__navlist[$palias]["id"];
        }
        $__data__ = app\\common\\model\\Navlist::when(!empty($typeid),function($query)use($typeid){
            $query->whereTypeid($typeid);
        })'.$where_str.'->append(["hasChild","ext"])->limit('.$limit.')->order("'.$order.'")'.$cache_str.'->select()->toArray();'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'"}';
        $parse .= '<?php 
        $'.$name.'["url"] =  $'.$name.'["type"] == "link" ? $'.$name.'["link"] : ('.$siteid.' == DEFAULTSITEID ? "" : "/".$__siteinfo["alias"])."/".($'.$name.'["alias"] ?:"n-".$'.$name.'["id"])."/";
        if (!empty($nav_fids) && in_array($'.$name.'["id"],explode(",",$nav_fids))) {
            $'.$name.'["iscurrent"] = true;
        } else {
            $'.$name.'["iscurrent"] = false;
        }
        ?>';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
	}

    // 栏目信息,不支持排序 默认torder从小到大
    public function tagNavi($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['site']) ? SITEID : $tag['site'];// 站点ID
        $limit  = empty($tag['limit']) ? 0 : intval($tag['limit']);// 调用数量
        $name   = empty($tag['name']) ? "navi" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $empty  = empty($tag['empty']) ? "" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        // 调用参数
        $pid    = empty($tag['pid']) ? 0 : $tag['pid'];// 根据上级栏目ID
        $model  = empty($tag['model']) ? "" : $tag['model'];// 根据模型栏目，如news
        $id     = empty($tag['id']) ? "" : $tag['id'];// 根据具体栏目ID，可为1,2,3,PID失效
        $eid    = empty($tag['eid']) ? "" : $tag['eid'];// 排除的栏目ID，可为1,2,3
        $group  = empty($tag['group']) ? "G0" : strtoupper($tag['group']);// 根据栏目分组，如G1,PID失效
        $palias = empty($tag['palias']) ? "" : $tag['palias'];// 根据上级栏目alias，如about
        $alias  = empty($tag['alias']) ? "" : $tag['alias'];// 根据具体栏目alias，如about,product,pic
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        // 调用
        $whereStr = "->where('".$group."','=',1)->where('status','=',1)";
        if(!empty($id)) $whereStr .= "->where('id','in',explode(',',".$this->transVar($id)."))";
        if(!empty($eid)) $whereStr .= "->where('id','not in',explode(',',".$this->transVar($eid)."))";
        if(!empty($alias)) $whereStr .= "->where('alias','in',explode(',',".$this->transVar($alias)."))";

        if($group == 'G0' && empty($id) && empty($alias)) {
            $whereStr .= "->where('pid','=',\$pid)";
        }
        if(!empty($model)) {
            $typeid = \app\common\model\Cmsmodels::getFieldByName($model,"id");
            if($typeid) $whereStr .= "->where('typeid','=',{$typeid})";
        }
        if(!empty($where)) {
            $w_arr = explode('|',$where);
            foreach ($w_arr as $v) {
                $whereStr .= "->where({$v})";
            }
        }
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $pid = '.$pid.';
        $palias = '.$this->transVar($palias).';
        $thisCollec = new \think\Collection();
        $__siteinfo = array_column(cache("site_nav_list"),NULL,"id")['.$siteid.'];
        if(!empty($palias)) {
            $__navlist = array_column($__siteinfo["navlist"],NULL,"alias");
            if(isset($__navlist[$palias])) $pid = $__navlist[$palias]["id"];
        }
        $__navlist = $thisCollec->make($__siteinfo["navlist"]);
        $__data__ = empty($__navlist) ?: $__navlist'.$whereStr.'->order("torder","asc")->toArray();'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'" length="'.$limit.'"}';
        $parse .= '<?php 
        $'.$name.'["url"] =  $'.$name.'["type"] == "link" ? $'.$name.'["link"] : ('.$siteid.' == DEFAULTSITEID ? "" : "/".$__siteinfo["alias"])."/".($'.$name.'["alias"] ?:"n-".$'.$name.'["id"])."/";
        if (!empty($nav_fids) && in_array($'.$name.'["id"],explode(",",$nav_fids))) {
            $'.$name.'["iscurrent"] = true;
        } else {
            $'.$name.'["iscurrent"] = false;
        }
        ?>';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 列表
    public function tagList($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['siteid']) ? SITEID : $tag['siteid'];// 站点ID
        $limit  = empty($tag['limit']) ? 10 : intval($tag['limit']);// 调用数量
        $name   = empty($tag['name']) ? "list" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $order  = empty($tag['order']) ? "create_time desc" : $tag['order'];// 排序规则
        $empty  = empty($tag['empty']) ? "未查询到相关记录！" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        // 调用参数
        $model  = empty($tag['model']) ? "" : $tag['model'];// 调用的模型名称，首页和单独调用必用
        $nid    = empty($tag['nid']) ? "" : $tag['nid'];// 栏目ID
        $nids   = empty($tag['nids']) ? "" : $tag['nids'];// 调用多个栏目ID，需要配合model参数
        $enid   = empty($tag['enid']) ? "" : $tag['enid'];// 排除的栏目ID，可为1,2,3
        $ispage = !empty($tag['ispage']) && $tag["ispage"] == "true" ? true : false;// 分页开关
        $timing = !empty($tag['timing']) && $tag["timing"] == "true" ? true : false;// 定时开关
        $diypage = !empty($tag['diypage']) && $tag["diypage"] == "true" ? true : false;// 自定义分页
        // 20201229新增 nalias
        $nalias    = empty($tag['nalias']) ? "" : $tag['nalias'];// 栏目alias
        $naliases    = empty($tag['naliases']) ? "" : $tag['naliases'];// 多个栏目alias
        $ealias    = empty($tag['ealias']) ? "" : $tag['ealias'];// 排除的栏目alias，为product1,product2
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        if($ispage) {
            if($diypage) {
                $page_str = '->paginate('.$limit.',false,["type" => "rg\Page","var_page"  => "p","path" => "","query" => getparam()]);$page = $__data__->pageArray();$__data__ = $__data__->toArray()["data"];';
            } else {
                $page_str = '->paginate('.$limit.',false,["type" => "rg\Page","var_page"  => "p","path" => "","query" => getparam()]);$page = $__data__->render();$__data__ = $__data__->toArray()["data"];';
            }
        } else {
            $page_str = '->limit('.$limit.')->select()->toArray();';
        }
        if($order == 'rand') {
            $order_str = '->orderRand()';
        } else {
            $order_str = '->order($order)';
        }
        $timing_str = $timing ? '->whereTime("create_time","<",time())' : '';
        // 会员模块和随机不使用缓存
        if(request()->module() !== 'user' && $order !== 'rand') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $nid = '.$this->transVar($nid).';
        $enid = '.$this->transVar($enid).';
        $nids = '.$this->transVar($nids).';
        $order = '.$this->transVar($order).';
        $nalias = '.$this->transVar($nalias).';
        $naliases = '.$this->transVar($naliases).';
        $ealias = '.$this->transVar($ealias).';
        if(empty($order)) {
            $order = "istop desc,create_time desc";
        } else {
            $order = "istop desc,".$order;
        }
        $where = "'.$where.'";
        $model = "'.$model.'";
        $url_map = [];
        $ispage = boolval("'.$ispage.'");
        $__siteinfo = array_column(cache("site_nav_list"),NULL,"id")['.$siteid.'];
        $thisCollec = new \think\Collection();
        $__navlist = $thisCollec->make($__siteinfo["navlist"]);
        $__navlist_id = array_column($__navlist->where("status","=",1)->toArray(),NULL,"id");
        if(!empty($naliases)) {
            $nids = $__navlist->where("alias","in",explode(",",$naliases))->where("status","=",1)->column("id");
        }
        if(!empty($model)) {
            if(!empty($nalias)) {
                $nid_a = $__navlist->where("alias","=",$nalias)->where("status","=",1)->toArray();
                if(!empty($nid_a)) $nid = reset($nid_a)["id"];
            }
            if(!empty($nid)) {
                $nids = !empty($nids) ? $nids : array_merge([$nid],get_childs($__navlist_id,"id",$nid));
            }
        } else {
            if(!empty($nalias)) {
                $nid_a = $__navlist->where("alias","=",$nalias)->where("status","=",1)->toArray();
                if(!empty($nid_a)) {
                    $nid = reset($nid_a)["id"];
                    $nids = !empty($nids) ? $nids : array_merge([$nid],get_childs($__navlist_id,"id",$nid));
                    $model = reset($nid_a)["cmsmodels"]["name"];
                }
            } else if(!empty($nid)) {
                $nid_a = $__navlist->where("id","=",$nid)->where("status","=",1)->toArray();
                if(!empty($nid_a)) {
                    $nids = !empty($nids) ? $nids : array_merge([$nid],get_childs($__navlist_id,"id",$nid));
                    $model = reset($nid_a)["cmsmodels"]["name"];
                }
            } else {
                if(isset($nav_id) && isset($nav_cmsmodels_name)) {
                    $nids = !empty($nids) ? $nids : array_merge([$nav_id],get_childs($__navlist_id,"id",$nav_id));
                    $model = $nav_cmsmodels_name;
                }
            }
        }
        if(!empty($ealias)) {
            $enid = $__navlist->where("alias","in",explode(",",$ealias))->where("status","=",1)->column("id");
        }
        $thisclass = "app\\\common\\\model\\\".ucfirst($model."model");
        if(!empty($model) && class_exists($thisclass)) {
            if($ispage) {
                $url_query = getparam();
                $_modelinfo = \\app\\common\\model\\Cmsmodels::whereName($model)->with(["cmsfields" => function($query){
                    $query->whereStatus(1);
                }])->cache($model."_modelinfo")->find();
                if(!empty($_modelinfo)) {
                    $url_fields = $_modelinfo["cmsfields"];
                    foreach ($url_fields as $v) {
                        if(isset($url_query[$v["name"]]) && $url_query[$v["name"]] != "") {
                            $url_map[$v["name"]] = urldecode($url_query[$v["name"]]); 
                        }
                    }
                    if($_modelinfo["region"]) {
                        if(isset($url_query["province"]) && $url_query["province"] != "") {
                            $url_map["province"] = $url_query["province"];
                        }
                        if(isset($url_query["city"]) && $url_query["city"] != "") {
                            $url_map["city"] = $url_query["city"];
                        }
                        if(isset($url_query["district"]) && $url_query["district"] != "") {
                            $url_map["district"] = $url_query["district"];
                        }
                    }
                }
            }
            $url_map = unserialize(serialize($url_map));
            $_class = new $thisclass;
            $__data__ = $_class::whereSiteId('.$siteid.')->whereStatus(1)->when(!empty($nids),function($query)use($nids){
                $query->whereIn("navlist_id",$nids);
            })'.$timing_str.'->when(!empty($enid),function($query)use($enid){
                $query->whereNotIn("navlist_id",$enid);
            })->when(!empty($where),function($query)use($where){
                $query->where($where);
            })->when(!empty($url_map),function($query)use($url_map){
                $query->where($url_map);
            })'.$cache_str.$order_str.$page_str.'
        };'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'"}';
        $parse .= '<?php 
        $navinfo_list = $__navlist_id[$'.$name.'["navlist_id"]];
        $navalias_list = $navinfo_list["alias"] ?: "n-".$navinfo_list["id"];
        $'.$name.'["url"] = $'.$name.'["link"] ?: ('.$siteid.' == DEFAULTSITEID ? "/" : "/".$__siteinfo["alias"]."/").$navalias_list."/".($'.$name.'["alias"]?:$'.$name.'["id"]).".html";
        $'.$name.'["navlist"] = $navinfo_list;
        ?>';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 面包屑
    public function tagLocation($tag) {
        // 基础数据
        $index = SITEID == DEFAULTSITEID ? '/' : '/'.SITEALIAS;
        // 调用主参数
        $mark   = empty($tag['mark']) ? "&gt;" : $tag['mark'];// 分割标记
        $home   = empty($tag['home']) ? lang('Home') : $tag['home'];// 首页名称
        $msg    = empty($tag['msg']) ? "页面信息" : $tag['msg'];// 其他信息

        // 解析
        $parse = '<?php '.PHP_EOL;
        $parse .= '$location = "<a href=\"'.$index.'\">'.$home.'</a> ";'.PHP_EOL;
        $nav_list = array_column(cache("site_nav_list"),NULL,"id")[SITEID]['navlist'];
        if(defined('NAVID')) {
            $list = get_father($nav_list,NAVID);
        }
        if(!empty($list)) {
            foreach ($list as $k => $v) {
                $parse .= '$location .= "'.$mark.' <a href =\"'.$v['url'].'\">'.$v['name'].'</a> ";'.PHP_EOL;
            }
        } else {
            $parse .= '$location .= "'.$mark.' <a>'.$msg.'</a> ";'.PHP_EOL;
        }
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{$location|raw}';
        return $parse;
    }

    // 功能列表
    public function tagFunc($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['siteid']) ? SITEID : $tag['siteid'];// 站点ID
        $limit  = empty($tag['limit']) ? 0 : intval($tag['limit']);// 调用数量
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $order  = empty($tag['order']) ? "torder asc,id desc" : $tag['order'];// 排序规则
        $empty  = empty($tag['empty']) ? "未查询到相关记录！" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        $ispage = !empty($tag['ispage']) && $tag["ispage"] == "true" ? true : false;// 分页开关
        $diypage = !empty($tag['diypage']) && $tag["diypage"] == "true" ? true : false;// 自定义分页
        // 调用参数
        $name   = $tag['name'];// 变量、模型名称
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        $func_search_map = [];
        if($ispage) {
            $func_search_query = getparam();
            $func_fields = \app\common\model\Cmsfields::hasWhere('cmsmodels',['name' => $name])->where("is_search",">",0)->select();
            $func_searchdata = \think\facade\Request::get();
            foreach ($func_fields as $v) {
                if(!empty($func_searchdata[$v['name']])) {
                    if($v['is_search'] == 2) {
                        $func_search_map[] = [$v['name'],'=',$func_searchdata[$v['name']]];
                    } else {
                        $func_search_map[] = [$v['name'],'like','%'.$func_searchdata[$v['name']].'%'];
                    }
                    $func_search_query[$v['name']] = $func_searchdata[$v['name']];
                }
            }
            if($diypage) {
                $page_str = '->paginate('.$limit.',false,["type" => "rg\Page","var_page"  => "p","path" => "","query" => getparam()]);$page = $__data__->pageArray();$__data__ = $__data__->toArray()["data"];';
            } else {
                $page_str = '->paginate('.$limit.',false,["type" => "rg\Page","var_page"  => "p","path" => "","query" => getparam()]);$page = $__data__->render();$__data__ = $__data__->toArray()["data"];';
            }
        } else {
            $page_str = '->limit('.$limit.')->select()->toArray();';
        }
        if($order == 'rand') {
            $order_str = '->orderRand()';
        } else {
            $order_str = '->order($order)';
        }
        // 会员模块不使用缓存
        if(request()->module() !== 'user') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $order = "'.$order.'";
        $where = "'.$where.'";
        $thisclass = "app\\\common\\\model\\\".ucfirst('.$name.'."model");
        if(class_exists($thisclass)) {
            $_class = new $thisclass;
            $__data__ = $_class::whereSiteId('.$siteid.')->whereStatus(1)->when(!empty($where),function($query)use($where){
                $query->where($where);
            })->where(unserialize(\''.serialize($func_search_map).'\'))'.$cache_str.$order_str.$page_str.'
        };'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 附属内容列表
    public function tagAtta($tag, $content)
    {
        // 基础数据
        $limit  = empty($tag['limit']) ? 10 : intval($tag['limit']);// 调用数量
        $name   = empty($tag['name']) ? "atta" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $order  = empty($tag['order']) ? "create_time desc" : $tag['order'];// 排序规则
        $empty  = empty($tag['empty']) ? "未查询到相关记录！" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        // 调用参数
        $model  = empty($tag['model']) ? "\$modelinfo_id" : $tag['model'];// 模型，详情页可免设置
        $cid    = empty($tag['cid']) ? "\$info_id" : $tag['cid'];// 内容ID，详情页可免设置
        $ispage = !empty($tag['ispage']) && $tag["ispage"] == "true" ? true : false;// 分页开关
        $diypage = !empty($tag['diypage']) && $tag["diypage"] == "true" ? true : false;// 自定义分页
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        if($ispage) {
            if($diypage) {
                $page_str = '->paginate('.$limit.',request()->isMobile(),["type" => "rg\Page","var_page"  => "p"]);$page = $__data__->pageArray();$__data__ = $__data__->toArray()["data"];';
            } else {
                $page_str = '->paginate('.$limit.',request()->isMobile(),["type" => "rg\Page","var_page"  => "p"]);$page = $__data__->render();$__data__ = $__data__->toArray()["data"];';
            }
            
        } else {
            $page_str = '->limit('.$limit.')->select()->toArray();';
        }
        if($order == 'rand') {
            $order_str = '->orderRand()';
        } else {
            $order_str = '->order($order)';
        }
        // 会员模块不使用缓存
        if(request()->module() !== 'user') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $model = '.$this->transVar($model).';
        $cid = '.$this->transVar($cid).';
        $order = "'.$order.'";
        $where = "'.$where.'";
        if(is_numeric($model)) {
            $attamodel_id = app\\common\\model\\Cmsmodels::getFieldById($model,"attamodel_id");
            $classname = app\\common\\model\\Cmsmodels::whereType(5)->getFieldById($attamodel_id,"classname");
        } else {
            $classname = app\\common\\model\\Cmsmodels::whereType(5)->getFieldByName($model,"classname");
        }
        if(!empty($classname)) {
            $thisclass = "app\\\common\\\model\\\".$classname;
            if(class_exists($thisclass)) {
                $_class = new $thisclass;
                $__data__ = $_class::whereStatus(1)->when(!empty($where),function($query)use($where){
                    $query->where($where);
                })->whereCId($cid)->append(["url"])'.$cache_str.$order_str.$page_str.'
            }
        };'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 单页列表或内容
    public function tagAbout($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['siteid']) ? SITEID : $tag['siteid'];// 站点ID
        $limit  = empty($tag['limit']) ? 0 : intval($tag['limit']);// 调用数量
        $name   = empty($tag['name']) ? "about" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $order  = empty($tag['order']) ? "torder asc,create_time desc" : $tag['order'];// 排序规则
        $empty  = empty($tag['empty']) ? "未查询到相关记录！" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        // 调用参数
        $id    = empty($tag['id']) ? "" : $tag['id'];// 单页ID，可为1,2,3,4 $nid失效
        $nid    = empty($tag['nid']) ? "" : $tag['nid'];// 根据栏目ID 获取单页内容  $id失效
        $nalias = empty($tag['nalias']) ? "" : $tag['nalias'];// 调用栏目别名，$id和$nid失效
        // 会员模块不使用缓存
        if(request()->module() !== 'user') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $__aboutids__ = array();
        $id = '.$this->transVar($id).';
        $nid = '.$this->transVar($nid).';
        $nalias = '.$this->transVar($nalias).';
        $order = "'.$order.'";
        $__siteinfo = array_column(cache("site_nav_list"),NULL,"id")['.$siteid.'];
        $__sitealias = '.$siteid.' == DEFAULTSITEID ? "" : "/".$__siteinfo["alias"];
        if(!empty($nalias) && empty($id)) {
            $thisCollec = new \think\Collection();
            $__aboutids__ = $thisCollec->make($__siteinfo["navlist"])->where("alias","in",explode(",",$nalias))->where("type","=","about")->column(null,"typeid");
            $id = array_keys($__aboutids__);
        }
        if(!empty($nid) && empty($id)) {
            $thisCollec = new \think\Collection();
            $__aboutids__ = $thisCollec->make($__siteinfo["navlist"])->filter(function($data)use($nid){
                return in_array($data["id"],explode(",",$nid));
            })->where("type","=","about")->column(null,"typeid");
            $id = array_keys($__aboutids__);
        }
        $__data__ = \\app\\common\\model\\About::whereSiteId('.$siteid.')->whereStatus(1)->whereIn("id",$id)->append(["ext"])->limit('.$limit.')->order($order)'.$cache_str.'->select()->toArray();'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'"}';
        $parse .= '<?php 
        if(!empty($__aboutids__)) {
            $'.$name.'["url"] = $__sitealias."/".($__aboutids__[$'.$name.'["id"]]["alias"]?:"n-".$__aboutids__[$'.$name.'["id"]]["id"])."/";
        } else {
            $'.$name.'["url"] =  $__sitealias."/about-".$'.$name.'["id"].".html";
        }
        ?>';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 多图解析
    public function tagImgs($tag, $content)
    {
        // 基础数据
        $name   = empty($tag['name']) ? "imgs" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $empty  = empty($tag['empty']) ? "" : $tag['empty'];// 无结果提示
        // 调用参数
        $imgs   = $tag['imgs'];
        $default_src  = empty($tag['default_src']) ? 0 : $tag['default_src'];// 默认图片
        $default_title  = empty($tag['default_title']) ? 0 : $tag['default_title'];// 默认标题
        // 解析
        $parse = '<?php 
        $imgs = '.$this->transVar($imgs).';
        $default_src = '.$this->transVar($default_src).';
        $default_title = '.$this->transVar($default_title).';
        $__data__ = json_decode($imgs,true);
        if(empty($__data__) && $default_src) {
            $__data__ = [["src" => $default_src,"title" => $default_title]];
        };'.PHP_EOL;
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 多内容解析
    public function tagCons($tag, $content)
    {
        // 基础数据
        $name   = empty($tag['name']) ? "cons" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $empty  = empty($tag['empty']) ? "" : $tag['empty'];// 无结果提示
        // 调用参数
        $cons   = $tag['cons'];
        // 解析
        $parse = '<?php 
        $cons = '.$this->transVar($cons).';
        $__data__ = json_decode($cons,true);'.PHP_EOL;
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 表单内容列表
    public function tagForm($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['siteid']) ? SITEID : $tag['siteid'];// 站点ID
        $limit  = empty($tag['limit']) ? 10 : intval($tag['limit']);// 调用数量
        $name   = empty($tag['name']) ? "form" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $order  = empty($tag['order']) ? "create_time desc" : $tag['order'];// 排序规则
        $empty  = empty($tag['empty']) ? "未查询到相关记录！" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        $length = empty($tag['length']) ? "" : $tag['length'];// 输出记录数
        // 调用参数
        $model   = $tag['model'];// 表单模型ID或模型标识
        $ispage = !empty($tag['ispage']) && $tag["ispage"] == "true" ? true : false;// 分页开关
        $diypage = !empty($tag['diypage']) && $tag["diypage"] == "true" ? true : false;// 自定义分页
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        if($ispage) {
            if($diypage) {
                $page_str = '->paginate('.$limit.',request()->isMobile(),["type" => "rg\Page","var_page"  => "p"]);$page = $__data__->pageArray();$__data__ = $__data__->toArray()["data"];';
            } else {
                $page_str = '->paginate('.$limit.',request()->isMobile(),["type" => "rg\Page","var_page"  => "p"]);$page = $__data__->render();$__data__ = $__data__->toArray()["data"];';
            }
            
        } else {
            $page_str = '->limit('.$limit.')->select()->toArray();';
        }
        if($order == 'rand') {
            $order_str = '->orderRand()';
        } else {
            $order_str = '->order($order)';
        }
        // 会员模块不使用缓存
        if(request()->module() !== 'user') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $model = '.$this->transVar($model).';
        $order = "'.$order.'";
        $where = "'.$where.'";
        if(is_numeric($model)) {
            $class = app\\common\\model\\Cmsmodels::whereType(3)->get($model);
        } else {
            $class = app\\common\\model\\Cmsmodels::whereType(3)->whereName($model)->find();
        }
        if(!empty($class)) {
            $thisclass = "app\\\common\\\model\\\".$class["classname"];
            if(class_exists($thisclass)) {
                $_class = new $thisclass;
                $__data__ = $_class::whereSiteId('.$siteid.')->whereStatus(1)->append(["user"])->when(!empty($where),function($query)use($where){
                    $query->where($where);
                })'.$cache_str.$order_str.$page_str.'
            }
        };'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'" length="'.$length.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 字符串分割
    public function tagEach($tag, $content)
    {
        // 基础数据
        $name   = empty($tag['name']) ? "each" : $tag['name'];// 变量名称
        $mark   = empty($tag['mark']) ? "|" : $tag['mark'];// 字符串中的分隔符
        $order  = empty($tag['order']) ? "left" : $tag['order'];// 排序输出
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $empty  = empty($tag['empty']) ? "未找到数据！" : $tag['empty'];// 无结果提示
        // 调用参数
        $str   = $tag['str'];
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $order = "'.$order.'";
        $str = '.$this->transVar($str).';
        if(!empty($str)) {
            $__data__ = explode("'.$mark.'",$str);
            if($order == "right") rsort($__data__);
        };'.PHP_EOL;
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 栏目模型搜索
    public function tagSearch($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['siteid']) ? SITEID : $tag['siteid'];// 站点ID
        $limit  = empty($tag['limit']) ? 10 : intval($tag['limit']);// 调用数量
        $name   = empty($tag['name']) ? "search" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $order  = empty($tag['order']) ? "create_time desc" : $tag['order'];// 排序规则
        $empty  = empty($tag['empty']) ? "未查询到相关记录！" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        $length = empty($tag['length']) ? "" : $tag['length'];// 输出记录数
        // 调用参数
        $ispage = !empty($tag['ispage']) && $tag["ispage"] == "true" ? true : false;// 分页开关
        $diypage = !empty($tag['diypage']) && $tag["diypage"] == "true" ? true : false;// 自定义分页
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        if($ispage) {
            if($diypage) {
                $page_str = '->paginate('.$limit.',request()->isMobile(),["type" => "rg\Page","var_page"  => "p","query" => $search_query,"path" => "./"]);$page = $__data__->pageArray();$__data__ = $__data__->toArray()["data"];';
            } else {
                $page_str = '->paginate('.$limit.',request()->isMobile(),["type" => "rg\Page","var_page"  => "p","query" => $search_query,"path" => "./"]);$page = $__data__->render();$__data__ = $__data__->toArray()["data"];';
            }
            
        } else {
            $page_str = '->limit('.$limit.')->select()->toArray();';
        }
        $order_str = '->order($order)';
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $order = "istop desc,'.$order.'";
        $where = "'.$where.'";
        $siteinfo_list = array_column(cache("site_nav_list"),NULL,"id")['.$siteid.'];
        $sitealias_list = '.$siteid.' == DEFAULTSITEID ? "/" : "/".$siteinfo_list["alias"]."/";
        $navlist_list = array_column($siteinfo_list["navlist"],NULL,"id");
        $thisclass = $search_class;
        $_class = new $thisclass;
        $__data__ = $_class::whereSiteId('.$siteid.')->whereStatus(1)->when(!empty($where),function($query)use($where){
            $query->where($where);
        })->where($search_map)'.$order_str.$page_str.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'" length="'.$length.'"}';
        $parse .= '<?php 
        $navinfo_list = $navlist_list[$'.$name.'["navlist_id"]];
        $navalias_list = $navinfo_list["alias"] ?: "n-".$navinfo_list["id"];
        $'.$name.'["url"] = $'.$name.'["link"] ?: $sitealias_list.$navalias_list."/".($'.$name.'["alias"]?:$'.$name.'["id"]).".html";
        $'.$name.'["navlist"] = $navinfo_list;
        ?>';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 地区列表
    public function tagRegion($tag, $content)
    {
        // 基础数据
        $name   = empty($tag['name']) ? "region" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $empty  = empty($tag['empty']) ? "" : $tag['empty'];// 无结果提示
        // 调用参数
        $parent_id   = empty($tag['pid']) ? 0 : $tag['pid'];// 地区父ID
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $region = new yupoxiong\region\model\Region;
        $__data__ = $region->getRegion('.$parent_id.');'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 关键词
    public function tagSitekey($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['siteid']) ? SITEID : $tag['siteid'];// 站点ID
        $limit  = empty($tag['limit']) ? 0 : intval($tag['limit']);// 调用数量
        $name   = empty($tag['name']) ? "sitekey" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $order  = empty($tag['order']) ? "torder asc" : $tag['order'];// 排序规则
        $empty  = empty($tag['empty']) ? "" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        // 会员模块不使用缓存
        if(request()->module() !== 'user') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $order = "'.$order.'";
        $where = "'.$where.'";
        $__data__ = \\app\\common\\model\\Sitekey::useGlobalScope(false)->whereSiteId('.$siteid.')->when(!empty($where),function($query)use($where){
                $query->where($where);
            })->limit('.$limit.')->order($order)'.$cache_str.'->select()->toArray();'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 自定义分页
    public function tagDiypage($tag, $content)
    {
        // 基础数据
        $name   = empty($tag['name']) ? "diypage" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $empty  = empty($tag['empty']) ? "" : $tag['empty'];// 无结果提示
        $limit = empty($tag['limit']) ? 0 : $tag['limit'];// 输出记录数
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $limit = '.$limit.';
        if($limit !== 0) {
            $begin_page = $page["currentPage"]-$limit >= 1 ? $page["currentPage"]-$limit : 1;
            $end_page = $page["currentPage"]+$limit>=$page["lastPage"] ? $page["lastPage"] : $page["currentPage"]+$limit;
            foreach ($page["pageList"] as $k => $v) {
                if($k>=$begin_page && $k<=$end_page) {
                    $__data__[] = ["page" => $k,"url" => $v,"iscurrent" => $k==$page["currentPage"] ? true : false];
                }
            }
        } else {
            foreach ($page["pageList"] as $k => $v) {
                $__data__[] = ["page" => $k,"url" => $v,"iscurrent" => $k==$page["currentPage"] ? true : false];
            }
        }'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 调用指定ID的模型内容
    public function tagContent($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['siteid']) ? SITEID : $tag['siteid'];// 站点ID
        $name   = empty($tag['name']) ? "content" : $tag['name'];// 变量名称
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $empty  = empty($tag['empty']) ? "未查询到相关记录！" : $tag['empty'];// 无结果提示
        // 调用参数
        $id    = $tag['id'];// ID
        $model    = $tag['model'];// 模型标识
        // 会员模块不使用缓存
        if(request()->module() !== 'user') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $id = '.$this->transVar($id).';
        $model = '.$this->transVar($model).';
        $thisclass = "app\\\common\\\model\\\".ucfirst($model."model");
        if(class_exists($thisclass)) {
            $_class = new $thisclass;
            $__data__ = $_class::whereSiteId('.$siteid.')->whereStatus(1)->whereIn("id",$id)->order("torder asc")'.$cache_str.'->select();
        };'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="'.$name.'" key="'.$key.'" empty="'.$empty.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 属性列表
    public function tagAttr($tag, $content)
    {
        // 基础数据
        $limit  = empty($tag['limit']) ? 0 : intval($tag['limit']);// 调用数量
        $key    = empty($tag['key']) ? "i" : $tag['key'];// 计数变量
        $order  = empty($tag['order']) ? "torder asc,id desc" : $tag['order'];// 排序规则
        $empty  = empty($tag['empty']) ? "未查询到相关记录！" : $tag['empty'];// 无结果提示
        $offset = empty($tag['offset']) ? "" : $tag['offset'];// 从第几个开始输出
        // 调用参数
        $name   = $tag['name'];// 属性分组标识
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        $page_str = '->limit('.$limit.')->select()->toArray();';
        if($order == 'rand') {
            $order_str = '->orderRand()';
        } else {
            $order_str = '->order($order)';
        }
        // 会员模块不使用缓存
        if(request()->module() !== 'user') {
            $cache_str = "->cache(config('app.home.homecache'))";
        } else {
            $cache_str = "";
        }
        // 解析
        $parse = '<?php 
        $__data__ = array();
        $order = "'.$order.'";
        $where = "'.$where.'";
        $__data__ = app\common\model\Attr::hasWhere("attrgroup",["name" => "'.$name.'"])->when(!empty($where),function($query)use($where){
                $query->where($where);
            })'.$cache_str.$order_str.$page_str.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{volist name="__data__" id="attr" key="'.$key.'" empty="'.$empty.'" offset="'.$offset.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    // 统计内容数量
    public function tagCount($tag, $content)
    {
        // 基础数据
        $siteid = empty($tag['siteid']) ? SITEID : $tag['siteid'];// 站点ID
        $model   = empty($tag['model']) ? "" : $tag['model'];// 模型标识如product
        $nid    = empty($tag['nid']) ? "\$nav_id" : $tag['nid'];// 栏目id
        // 调用条件
        $where  = empty($tag['where']) ? "" : $tag['where'];// 调用条件
        // 解析
        $cache_str = "->cache(config('app.home.homecache'))";
        $parse = '<?php 
        $__data__ = array();
        $nid = '.$this->transVar($nid).';
        $model = '.$this->transVar($model).';
        $where = "'.$where.'";
        $count = 0;
        if(!empty($model)) {
            $thisclass = "app\\\common\\\model\\\".ucfirst($model."model");
            $count = $thisclass::when(!empty($where),function($query)use($where){
                $query->where($where);
            })->whereSiteId('.$siteid.')->whereStatus(1)'.$cache_str.'->count();
        } else {
            $__siteinfo = array_column(cache("site_nav_list"),NULL,"id")['.$siteid.'];
            $thisCollec = new \think\Collection();
            $__navlist = $thisCollec->make($__siteinfo["navlist"]);
            $__navlist_id = array_column($__navlist->where("status","=",1)->toArray(),NULL,"id");
            if(isset($__navlist_id[$nid]) && !empty($__navlist_id[$nid]["cmsmodels"])) {
                $thisclass = "app\\\common\\\model\\\".$__navlist_id[$nid]["cmsmodels"]["classname"];
                $nids = array_merge([$nid],get_childs($__navlist_id,"id",$nid));
                $count = $thisclass::when(!empty($where),function($query)use($where){
                    $query->where($where);
                })->whereSiteId('.$siteid.')->whereIn("navlist_id",$nids)->whereStatus(1)'.$cache_str.'->count();
            }
        }'.PHP_EOL; 
        $parse .= ' ?>'.PHP_EOL;
        $parse .= '{$count}';
        return $parse;
    }

    // 参数转换
    private function transVar(&$name)
    {
        if($name === 0) {
            return 0;
        } else if(!empty($name)) {
            $flag = substr($name, 0, 1);
            if('$' == $flag) {
                $name = $name;
            } elseif (':' == $flag) {
                $name = substr($name, 1);
            } else {
                $name = '"'.$name.'"';
            }
            return $name;
        } else {
            return '""';
        }
    }
}