<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-11-11
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\user\controller;

use app\common\model\User;
use Request;
use Db;

class Address extends Base
{
	protected function initialize()
    {
        parent::initialize();
        if(!isInstall('address')) $this->error('请先安装插件');
    }
	// 地址首页
	public function index()
	{
		$pagetitle = '我的地址';
		$addressList = Db::name('address')->whereUserId(session('userid'))->withAttr('address2',function($value,$data){
			$province = Db::name('region')->getFieldById($data['province'],'name');
			$city = Db::name('region')->getFieldById($data['city'],'name');
			$district = Db::name('region')->getFieldById($data['district'],'name');
			return $province .' / '. $city .' / '. $district;
		})->append(['address2'])->limit(5)->order('isdefault desc')->select();
		return $this->fetch('',compact('pagetitle','addressList'));
	}

	// 新增
	public function add()
	{
		$pagetitle = '新增地址';
		return $this->fetch('',compact('pagetitle'));
	}

	// 编辑
	public function edit($id)
	{
		$info = Db::name('address')->where(['id' => $id,'user_id' => session('userid')])->find();
		if(!$info) $this->error('数据不存在');
		$pagetitle = '修改地址';
		return $this->fetch('',compact('pagetitle','info'));
	}
}