<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-11-10
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace app\user\controller;
use think\Controller;
use app\common\model\User;
use app\common\model\Usergroup;
use app\common\model\Diyfields;
use Env;

class Base extends Controller
{
	protected $siteinfo;
	protected $userinfo;
	protected function initialize()
	{
		if(!config('app.user.useron')) $this->error('会员系统不可用');
		config('url_html_suffix','html');
		$controller = request()->controller();
		$action = request()->action();
		$local_rule = strtolower($controller .'/'. $action);
		// 无需登录验证
        $except_login = ['index/login','index/forgot','index/reset','index/reg','sendsms/regverify','sendsms/findverify'];
        // 登陆判断
        if(in_array($local_rule,$except_login)) {
        	if(session('?userid')) $this->error('你已登陆了系统',uUrl('user','index','index'));
        } else {
        	if(!session('?userid')) {
        		$this->relogin();
        	} else {
        		// 验证SESSION是否过期
				if(intval(config('app.user.sessionexpire'))!==0) {
					if(session('session_start_time_user')) {
						if(time()-session('session_start_time_user') > intval(config('app.user.sessionexpire')*60)) {
							session('userid',NULL);
							session('session_start_time_user',NULL);
							$this->relogin();
						}
					}
					session('session_start_time_user',time()); //重新设置开始时间
				}
				$this->userinfo = User::hasWhere('usergroup',['Usergroup.status'=>1])->where(['User.status'=>1,'User.id' => session('userid')])->with('usergroup')->hidden(['password','salt'])->find();
				if(!$this->userinfo) {
					session('userid',NULL);
					$this->error('账号状态异常，请联系管理员');
				}
				$userinfo = arr2one($this->userinfo->toArray(),'user');
				$this->assign($userinfo);
        	}
        }
		// 站点信息
		$this->siteinfo = $this->request->siteinfo;
		// 栏目分离
		unset($this->siteinfo['navlist']);
		// 全局变量
		$this->siteinfo['ext'] = Diyfields::whereStatus(1)->whereTablename('site')->whereSiteId($this->siteinfo['id'])->column('value','name');
		// 构建站点信息标签{$site_*形式}
		$siteinfo = arr2one($this->siteinfo,'site');
		$this->assign($siteinfo);
		// 会员模板
		if($this->request->isMobile()) {
			$this->htmldir = env('root_path') . 'public' . DS . config('tpl_path') . DS . 'user' . DS . 'wap' . DS . 'html' . DS;
			$tempdir = '/public/' . config('tpl_path') . '/user/wap';
		} else {
			$this->htmldir = env('root_path') . 'public' . DS . config('tpl_path') . DS . 'user' . DS . 'pc' . DS . 'html' . DS;
			$tempdir = '/public/' . config('tpl_path') . '/user/pc';
		}
		// $this->tpl = $this->htmldir . strtolower($controller .'_'. $action).'.html';
		// 设置模板路径
		// $this->view->config('view_depr','_');
		$this->view->config('view_path',$this->htmldir);
		// 模板目录标签
		$this->assign('tempdir',$tempdir);
	}

	public function relogin()
	{
		if(request()->isPost()) {
			$this->error(lang('relogin'),uUrl('user','index','login'));
    	} else {
    		$this->redirect(uUrl('user','index','login'));
    	}
	}
}