<?php
namespace app\user\controller;
use app\common\controller\Form;
use app\common\model\Model;
use app\common\model\Modelfields;
use app\common\model\FormContent;

class User extends Base
{
	// 二开实例
    public function diyaction()
    {
        echo '1';
    }

    // 对不存在的action进行处理
    public function _empty()
    {
    	$action = request()->action();
    	$menuinfo = model('usermenu')->where(['action' => $action,'status' => 1])->find();
    	if($menuinfo) {
            $menuinfo['content'] = unserialize($menuinfo['content']);
            $pagetitle = $menuinfo['name'];
            $this->assign('menuinfo',$menuinfo);
            $this->assign('menu_id',$menuinfo['id']);
            $this->assign('pagetitle',$pagetitle);
    		switch ($menuinfo['type']) {
                case 't2':
                    return $this->fetch('menu/spage');
                    break;
                case 't3':
                    $do = input('get.do');
                    $formid = $menuinfo['content']['formid'];
                    // 表单信息
                    $forminfo = Model::hasWhere('formconfig',['status' => 1])->append(['formconfig'])->get($formid);
                    if(!$forminfo) $this->error('表单不存在或已关闭！');
                    $this->assign('forminfo',$forminfo);
                    // 获取字段列表
                    $modelfields = Modelfields::where('model_id','=',$formid)->order('torder')->select()->toArray();
                    $this->assign('modelfields',$modelfields);
                    // 数据表名称
                    $table = tablepref($forminfo['modeltype']).$forminfo['tablename'];
                    // 表单内容详情
                    $id = input('id/d');
                    if(!empty($id)) {
                        $info = FormContent::name($table)->where(['user_id' => session('userid'),'id' => $id])->find();
                        if(!$info) $this->error('你访问的内容不存在！');
                        $this->assign('info',$info);
                    }
                    switch ($do) {
                        case 'add':
                            // 新增
                            if(request()->isPost()) {
                                $Form = new Form();
                                $Form->add();
                            }
                            return $this->fetch('menu/userform_add');
                            break;
                        case 'del':
                            // 删除
                            if($info['user_id'] !== session('userid'))  $this->error('删除失败');
                            if(request()->isPost()) {
                                try {
                                    $result = FormContent::name($table)->where(['user_id'=>session('userid'),'id'=>$id])->delete();
                                    if(!$result) {
                                        $this->error('删除失败');
                                    }
                                } catch (\Exception $e) {
                                    $this->error($e->getMessage());
                                }
                                $this->success('删除成功');
                            }
                            break;
                        case 'view':
                            // 修改
                            if(request()->isPost()) {
                                $Form = new Form();
                                $Form->edit();
                            }
                            // 点查看 设置管理员已回复的userview=1
                            FormContent::name($table)->where('id = '.$id.' and userview = 0 and adminview = 1')->setField('userview',1);
                            return $this->fetch('menu/userform_view');
                            break;
                        default:
                            // 列表
                            if(request()->isPost()) {
                                // 排序
                                $list_order = input('post.order');
                                if($list_order) {
                                    $order = [$list_order['field'] => $list_order['type']];
                                } else {
                                    if(!empty($forminfo['orderfield'])) {
                                        $order = [$forminfo['orderfield'] => $forminfo['ordertype']];
                                    } else {
                                        $order = ['id'=>'desc'];
                                    }
                                }
                                // 筛选
                                $type = input('post.type');
                                if($type ==='1'){
                                    $map = 'reply is not null or replyimgs is not null';
                                } else if($type === '0') {
                                    $map = 'reply is null and replyimgs is null';
                                } else if($type == NULL){
                                    $map = "1=1";
                                }
                                $list = FormContent::name($table)->where($map)->where(['user_id' => session('userid')])->order($order)->paginate(input('post.limit/d'))->toArray();
                                return json(['code'=>0,'msg'=>lang('getdatatrue'),'data'=>$list['data'],'count'=>$list['total']]);
                            }
                            $listfields = Modelfields::where('model_id','=',$formid) // 获取模型
                                        ->where('status','=',1) // 有效模型
                                        ->where('listcolumn','>',1) // 列表显示
                                        ->order('listcolumnorder')->select()->toArray();
                            $this->assign('listfields',$listfields);
                            return $this->fetch('menu/userform');
                            break;
                    }
                    break;
                default:
                    # code...
                    break;
            }
    	} else {
    		$this->error('不存在的方法');
    	}
    }
}