<?php
namespace app\user\model;
use think\Model as Basemodel;
/**
* 
*/
class User extends Basemodel
{

	// 注册
	public function reg($data)
	{
		try{
			$data['salt'] = random();
			$data['password'] = md5(trim($data['password']).$data['salt']);
			$result = $this->allowField(true)->save($data);
			session('userid',$this->id);
			if($result) {
				return ['code'=>1 ,'msg'=>'注册成功','url' => url('user/index/set')];
			} else {
				return ['code'=>0 ,'msg'=>'注册失败'];
			}
		} catch (\Exception $e) {
			return ['code'=>0 ,'msg'=>$e->getMessage()];
		}
	}

	// 登录
	public function login($data)
	{
		try{
			$has = $this->where(['mobile' => $data['mobile']])->with('usergroup')->find(); // 找开启的用户名
			if($has) {
				if($has['usergroup'] && $has['usergroup']['status']!==1) { // 判断该用户所在组是否有效
					return ['code'=>0 ,'msg'=>'用户组异常'];
				} else if($has['status'] == 0) {
					return ['code'=>0 ,'msg'=>'用户账号审核中或暂停使用'];
				} else {
					$data['password'] = md5($data['password'].$has['salt']); // 加盐
					if($data['password']===$has['password']) {
						$map = [
						'logincount' => $has['logincount'] + 1,
						'ip' => getIp(),
						'update_time' => time()
						];
						$this->where('id',$has['id'])->update($map);
						session('userid',$has['id']);
						return ['code'=>1 ,'msg'=>'登录成功','url'=>url('user/index/set')];
					} else {
						return ['code'=>0 ,'msg'=>'密码错误'];
					}
				}
			} else {
				return ['code'=>0 ,'msg'=>'未知用户'];
			}
		} catch (\Exception $e) {
			return ['code'=>0 ,'msg'=>$e->getMessage()];
		}
	}

	// 验证码登录
	public function mlogin($data)
	{
		try{
			$has = $this->where(['mobile' => $data['mobile']])->with('usergroup')->find(); // 找开启的用户名
			if($has) {
				if($has['usergroup']['status']!==1) { // 判断该用户所在组是否有效
					return ['code'=>0 ,'msg'=>'用户组异常'];
				} else if($has['status'] == 0) {
					return ['code'=>0 ,'msg'=>'用户账号审核中或暂停使用'];
				}  else {
					$map = [
					'logincount' => $has['logincount'] + 1,
					'ip' => getIp(),
					'update_time' => time()
					];
					$this->where('id',$has['id'])->update($map);
					session('userid',$has['id']);
					return ['code'=>1 ,'msg'=>'登录成功','url'=>url('user/index/set')];
				}
			} else {
				return ['code'=>0 ,'msg'=>'未知用户'];
			}
		} catch (\Exception $e) {
			return ['code'=>0 ,'msg'=>$e->getMessage()];
		}
	}

	// 个人信息修改
	public function editinfo($data)
	{
		try{
			$user = $this->get(session('userid'));
			if(!isset($data['password']) || !trim($data['password'])) {
				unset($data['password']); // 密码留空不修改
			} else {
				$salt = $user['salt'];
				$data['password'] = md5(trim($data['password']).$salt);
			}
			$result = $user->allowField(['nickname','sex','email','address','face','password'])->save($data);
			if($result) {
				return ['code'=>1 ,'msg'=>'修改成功','url' => url('user/index/set')];
			} else {
				return ['code'=>0 ,'msg'=>'修改失败'];
			}
		} catch (\Exception $e) {
			return ['code'=>0 ,'msg'=>$e->getMessage()];
		}
	}

	// 绑定手机修改
	public function changemobile($data)
	{
		try{
			$user = $this->get($data['id']);
			$data['username'] = $data['mobile'];
			$result = $user->allowField(true)->isAutoWriteTimestamp(false)->save($data);
			if($result) {
				return ['code'=>1 ,'msg'=>'修改成功','url' => url('user/index/set')];
			} else {
				return ['code'=>0 ,'msg'=>'修改失败'];
			}
		} catch (\Exception $e) {
			return ['code'=>0 ,'msg'=>$e->getMessage()];
		}
	}

	// 关联
	public function usergroup()
	{
		return $this->belongsTo('usergroup');
	}
}