-- -----------------------------
-- RGCMS MySQL Data Transfer 
-- 
-- Host     : 127.0.0.1
-- Port     : 3306
-- Database : rgcms102
-- 
-- Part : #1
-- Date : 2020-09-05 15:26:23
-- -----------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `rg_about`
-- -----------------------------
DROP TABLE IF EXISTS `rg_about`;
CREATE TABLE `rg_about` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `etitle` varchar(255) DEFAULT NULL,
  `author` varchar(50) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `template` varchar(255) DEFAULT NULL,
  `keys` varchar(255) DEFAULT NULL,
  `desc` mediumtext,
  `hits` int(11) DEFAULT '0',
  `content` mediumtext,
  `admin_id` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `ugids` varchar(255) DEFAULT NULL,
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `extend` mediumtext,
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_about`
-- -----------------------------
INSERT INTO `rg_about` VALUES ('1', '系统介绍', 'About Us', 'admin', '', '/upload/image/20200904/19b8e26b29682ece20b3af858a0f402e.jpg', '', '', '', '45', '<p>RGCMS V2.0版本是在V1.12版本基础上进行深加工，继承了上个版本的所有优势，并开发了更多的功能，新增了模型类别、附属表功能、关联功能、地区筛选功能，重构V1内核，优化系统运行效率与速度，前台采用标签缓存技术，大大缩短了页面展现速度。</p><p>标签重构，并在原来的基础上取精华去糟粕。后台管理UI全新更换，使用更合理，视觉效果更优雅。</p><p><span style=\"font-size: 24px; color: rgb(31, 73, 125);\">系统介绍</span></p><p>睿谷内容管理系统(简称：RGCMS)是一套开源的建站管理系统并已获得著作权，使用PHP语言编写，框架为Thinkphp5.1.+，数据库采用MYSQL数据库。</p><p>系统特点：</p><p>★ 自定义各种栏目模型、功能模型，以便适应各种生产场景，模板路径文件自由定义<br/>★ 扩展字段，灵活调用，系统没有太多的固定模板标签，大多数标签都是根据自定义的字段来调用<br/>★ 后台使用LAYUI框架，强大的TP模板标签和缓存机制使得内容以毫秒级呈现<br/>★ 过滤机制以及黑名单阻止非法入侵，同步TP官方更新框架，及时修补各种问题<br/>★ 一个后台管理N个站点，可以创作多语言站，也可创作站群，也可根据需求定制各种应用<br/>★ 系统免费提供邮件、七牛、短信等第三方流行接口<br/>★ 有层次的权限分级，让管理变得轻松方便，自定义不同的组别，分配不同的权限<br/>★ 节省空间资源，同一张图片或同一个文件，在第二次上传时会自动获取原来上传的文件地址，有效节省空间资源<br/>★ 多图上传可以标注每个图的描述标题等<br/>★ 无限分级，前台可无限调用，同时可对栏目字段进行向上追溯调用，如当前栏目无栏目图，可自动调用上一级栏目图，直到有图为止<br/>★ 可设置栏目访问级别，如对会员组设置访问权限等<br/>★ 内置素材库存储所有上传资料，直接点击选取即可调用素材<br/>★ 关键词内链机制、SEO标题、关键词、描述设置，自动百度链接提交功能<br/>★ 在线模板编辑，无需FTP即可在线管理<br/>★ 批量添加栏目、批量添加内容</p>', '1', '1', '', '1', '1', '', '1599198843', '1599273567', '0');
INSERT INTO `rg_about` VALUES ('2', '联系我们', '', 'admin', '', '/upload/image/20200904/19b8e26b29682ece20b3af858a0f402e.jpg', 'contact_content.html', '', '', '22', '<h4>公司名称——欢迎使用RGCMS网站内容管理系统</h4><p>电话：021-88888888</p><p>传真：021-66666666</p><p>邮箱：info@yourdomain.com</p><p>地址：上海市松江区佘山工业区</p>', '1', '1', '', '2', '1', '', '1599198880', '1599275809', '0');
INSERT INTO `rg_about` VALUES ('3', '在线留言', '', 'admin', '', '', 'feedback_content.html', '', '', '48', '', '1', '1', '', '3', '1', '', '1599198969', '1599269392', '0');
INSERT INTO `rg_about` VALUES ('19', 'About RGCMS', 'About Us', 'admin', '', '/upload/image/20200904/19b8e26b29682ece20b3af858a0f402e.jpg', '', '', '', '43', '<p>The RGCMS V2.0 version is deep-processing on the basis of the V1.12 version, inheriting all the advantages of the previous version, and developing more functions, adding new model categories, subsidiary table functions, association functions, and regional filtering functions. Refactored the V1 kernel to optimize the efficiency and speed of the system. The front desk adopts tag caching technology, which greatly shortens the page display speed.</p><p>Label reconstruction, and take the essence to remove the dross on the original basis. The back-end management UI is newly replaced, the use is more reasonable, and the visual effect is more elegant.<br/></p><p><span style=\"font-size: 24px; color: rgb(31, 73, 125);\">system introduction</span><br/></p><p>Ruigu Content Management System (referred to as: RGCMS) is an open source management system for website building and has obtained copyright. It is written in PHP language, the framework is Thinkphp5.1.+, and the database uses MYSQL database.<br/></p><p>System Features:<br/></p><p>★ Customize various column models and function models to adapt to various production scenarios, and freely define template path files<br/></p><p>★ Extended fields, flexible calling, the system does not have too many fixed template tags, most tags are called based on custom fields</p><p>★ Using the LAYUI framework in the background, powerful TP template tags and caching mechanism make the content presented in milliseconds</p><p>★ Filter mechanism and blacklist prevent illegal intrusion, synchronize TP official update framework, and fix various problems in time</p><p>★ One background manages N sites, you can create multi-language sites, you can also create site groups, and you can customize various applications according to your needs</p><p>★ The system provides free third-party popular interfaces such as mail, Qiniu, SMS, etc.</p><p>★ Hierarchical levels of authority make management easy and convenient, customize different groups and assign different authorities</p><p>★ Save space resources, the same picture or the same file will automatically obtain the original uploaded file address during the second upload, effectively saving space resources</p><p>★ Multi-picture upload can mark the description title of each picture, etc.</p><p>★ Unlimited grading, unlimited calls at the front desk, and retroactive call to the column fields at the same time. If the current column has no column diagram, the upper-level column diagram can be automatically called until there is a diagram.</p><p>★ Column access levels can be set, such as access permissions for member groups, etc.</p><p>★ The built-in material library stores all uploaded data, and you can directly click to select the material to call</p><p>★ Keyword internal chain mechanism, SEO title, keyword, description setting, automatic Baidu link submission function</p><p>★ Online template editing, online management without FTP</p><p>★ Add columns and content in batches</p>', '1', '4', '', '1', '1', '', '1599198843', '1599284605', '0');
INSERT INTO `rg_about` VALUES ('20', 'Contact Us', '', 'admin', '', '/upload/image/20200904/19b8e26b29682ece20b3af858a0f402e.jpg', 'contact_content.html', '', '', '25', '<h4>welcome to use RGCMS website content management system</h4><p>Phone: 021-88888888<br/></p><p>Fax: 021-66666666<br/></p><p>Email: info@yourdomain.com<br/></p><p>Address: Sheshan Industrial Zone, Songjiang District, Shanghai</p>', '1', '4', '', '2', '1', '', '1599198880', '1599284651', '0');
INSERT INTO `rg_about` VALUES ('21', 'Feedback', '', 'admin', '', '', 'feedback_content.html', '', '', '72', '', '1', '4', '', '3', '1', '', '1599198969', '1599284672', '0');

-- -----------------------------
-- Table structure for `rg_addons`
-- -----------------------------
DROP TABLE IF EXISTS `rg_addons`;
CREATE TABLE `rg_addons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `version` varchar(20) DEFAULT NULL,
  `author` varchar(50) DEFAULT NULL,
  `is_admin` int(11) DEFAULT '0',
  `is_index` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `description` mediumtext,
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_addons`
-- -----------------------------
INSERT INTO `rg_addons` VALUES ('1', '后台系统信息', 'sysinfo', '0.1', '', '0', '0', '1', '', '1573289116', '1573289116', '0');
INSERT INTO `rg_addons` VALUES ('2', 'BOM头清除', 'clearbom', '0.1', '', '0', '0', '1', '', '1574148295', '1574148295', '0');

-- -----------------------------
-- Table structure for `rg_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rg_admin`;
CREATE TABLE `rg_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(30) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `nickname` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobile` varchar(50) DEFAULT NULL,
  `admingroup_id` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `salt` varchar(10) DEFAULT NULL,
  `theme` int(11) DEFAULT '0',
  `siteids` varchar(255) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_admin`
-- -----------------------------
INSERT INTO `rg_admin` VALUES ('1', 'admin', '87c0a812fd7d99f28ee6ba7643c46669', '管理员', 'tangji@yeah.net', '13000000000', '1', '1', 'MlnCwwyGym', '0', '0', '1563864778', '1599121519');

-- -----------------------------
-- Table structure for `rg_admingroup`
-- -----------------------------
DROP TABLE IF EXISTS `rg_admingroup`;
CREATE TABLE `rg_admingroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(80) DEFAULT NULL,
  `pid` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `rules` mediumtext,
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_admingroup`
-- -----------------------------
INSERT INTO `rg_admingroup` VALUES ('1', '开发者', '0', '1', '0', '1582880395', '1572510597');
INSERT INTO `rg_admingroup` VALUES ('20', '超级管理员', '1', '1', '189,183,213,214,482,483,484,485,354,598,599,531,532,355,356,358,359,360,120,151,152,153,154,155,461,157,159,158,160,161,163,165,167,168,166', '1593352864', '1597379832');

-- -----------------------------
-- Table structure for `rg_adminlog`
-- -----------------------------
DROP TABLE IF EXISTS `rg_adminlog`;
CREATE TABLE `rg_adminlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT '0',
  `type` int(11) DEFAULT '0',
  `ip` varchar(100) DEFAULT NULL,
  `content` mediumtext,
  `query` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `method` varchar(20) DEFAULT NULL,
  `controller` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Table structure for `rg_adminrule`
-- -----------------------------
DROP TABLE IF EXISTS `rg_adminrule`;
CREATE TABLE `rg_adminrule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(80) DEFAULT NULL,
  `name` varchar(80) DEFAULT NULL,
  `level` int(11) DEFAULT '0',
  `type` int(11) DEFAULT '0',
  `pid` int(11) DEFAULT '0',
  `icon` varchar(80) DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  `condition` varchar(255) DEFAULT NULL,
  `torder` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `IDX_DBA926A2A3` (`id`,`pid`),
  KEY `IDX_99BBCE4778` (`pid`),
  KEY `IDX_109B64D774` (`title`)
) ENGINE=MyISAM AUTO_INCREMENT=611 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_adminrule`
-- -----------------------------
INSERT INTO `rg_adminrule` VALUES ('120', '运维', '', '1', '1', '0', 'layui-icon-template', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('122', '节点管理', 'sysmenu/index', '3', '1', '348', 'layui-icon-spread-left', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('123', '添加节点', 'sysmenu/add', '4', '1', '122', 'layui-icon-add-1', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('124', '编辑节点', 'sysmenu/edit', '4', '1', '122', 'layui-icon-edit', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('125', '删除节点', 'sysmenu/del', '4', '1', '122', 'layui-icon-delete', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('151', '数据库', '', '2', '1', '120', 'layui-icon-table', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('152', '备份修复', 'data/index', '3', '1', '151', 'layui-icon-date', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('153', '备份数据库', 'data/backup', '4', '1', '152', 'layui-icon-upload-drag', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('154', '修复数据库', 'data/repair', '4', '1', '152', 'layui-icon-template', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('155', '优化数据库', 'data/optimize', '4', '1', '152', 'layui-icon-release', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('158', '删除备份', 'data/delbackup', '4', '1', '152', 'layui-icon-delete', '0', '', '6');
INSERT INTO `rg_adminrule` VALUES ('159', '还原备份', 'data/importbackup', '4', '1', '152', 'layui-icon-return', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('160', '下载备份', 'data/downbackup', '4', '1', '152', 'layui-icon-download-circle', '0', '', '7');
INSERT INTO `rg_adminrule` VALUES ('161', '用户', '', '1', '1', '0', 'layui-icon-user', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('163', '管理员', '', '2', '1', '161', 'layui-icon-username', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('165', '管理列表', 'admin/index', '3', '1', '163', 'layui-icon-user', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('166', '删除管理员', 'admin/del', '4', '1', '165', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('167', '添加管理员', 'admin/add', '4', '1', '165', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('168', '编辑管理员', 'admin/edit', '4', '1', '165', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('169', '角色管理', 'admin/grouplist', '3', '1', '163', 'layui-icon-date', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('170', '添加角色', 'admin/groupadd', '4', '1', '169', 'layui-icon-add-1', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('171', '编辑角色', 'admin/groupedit', '4', '1', '169', 'layui-icon-edit', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('172', '删除角色', 'admin/groupdel', '4', '1', '169', 'layui-icon-delete', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('183', '站点管理', '', '2', '1', '189', 'layui-icon-templeate-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('184', '站点列表', 'site/index', '3', '1', '183', 'layui-icon-table', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('185', '添加站点', 'site/add', '4', '1', '184', 'layui-icon-add-1', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('186', '编辑站点', 'site/edit', '4', '1', '184', 'layui-icon-edit', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('187', '删除站点', 'site/del', '4', '1', '184', 'layui-icon-delete', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('188', '站点信息', 'site/info', '3', '1', '183', 'layui-icon-note', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('189', '站点', '', '1', '1', '0', 'layui-icon-template-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('201', '信息修改', 'site/infoedit', '4', '1', '188', 'layui-icon-edit', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('213', '栏目位置', 'navlist/groupindex', '3', '1', '183', 'layui-icon-transfer', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('214', '添加导航位置', 'navlist/addgroup', '4', '1', '213', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('215', '编辑导航位置', 'navlist/editgroup', '4', '1', '213', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('216', '删除导航位置', 'navlist/delgroup', '4', '1', '213', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('217', '内容管理', '', '2', '1', '189', 'layui-icon-read', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('221', '栏目管理', 'navlist/index', '3', '1', '183', 'layui-icon-templeate-1', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('223', '编辑栏目', 'navlist/edit', '4', '1', '221', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('224', '删除栏目', 'navlist/del', '4', '1', '221', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('225', '添加栏目', 'navlist/add', '4', '1', '221', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('231', '栏目内容', 'content/index', '3', '1', '217', 'layui-icon-read', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('232', '添加内容', 'content/add', '4', '1', '231', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('233', '编辑内容', 'content/edit', '4', '1', '231', 'layui-icon-edit', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('234', '删除内容', 'content/del', '4', '1', '231', 'layui-icon-delete', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('237', '恢复', 'content/restore', '4', '1', '231', 'layui-icon-return', '0', '', '10');
INSERT INTO `rg_adminrule` VALUES ('239', '内容列表', 'content/clist', '4', '1', '231', 'layui-icon-senior', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('242', '模型管理', '', '2', '1', '120', 'layui-icon-senior', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('249', '复制内容', 'content/copy', '4', '1', '231', 'layui-icon-templeate-1', '0', '', '6');
INSERT INTO `rg_adminrule` VALUES ('250', '回收站', 'content/recycle', '4', '1', '231', 'layui-icon-fonts-del', '0', '', '8');
INSERT INTO `rg_adminrule` VALUES ('252', '关键词库', 'sitekey/index', '3', '1', '444', 'layui-icon-template', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('255', '添加关键词', 'sitekey/add', '4', '1', '252', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('256', '编辑关键词', 'sitekey/edit', '4', '1', '252', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('257', '删除关键词', 'sitekey/del', '4', '1', '252', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('260', '功能管理', 'funcontent/index', '3', '1', '217', 'layui-icon-app', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('261', '添加内容', 'funcontent/add', '4', '1', '260', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('262', '编辑内容', 'funcontent/edit', '4', '1', '260', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('263', '删除内容', 'funcontent/del', '4', '1', '260', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('264', '内容列表', 'funcontent/clist', '4', '1', '260', 'layui-icon-read', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('265', '批量修改', 'funcontent/edits', '4', '1', '260', 'layui-icon-edit', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('298', '上传管理', 'media/index', '3', '1', '465', 'layui-icon-upload-drag', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('299', '删除文件', 'media/del', '4', '1', '298', 'layui-icon-delete', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('305', '会员管理', 'user/index', '3', '1', '569', 'layui-icon-user', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('307', '添加会员', 'user/add', '4', '1', '305', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('308', '编辑会员', 'user/edit', '4', '1', '305', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('309', '删除会员', 'user/del', '4', '1', '305', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('310', '会员分组', 'usergroup/index', '3', '1', '569', 'layui-icon-date', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('311', '添加会员组', 'usergroup/add', '4', '1', '310', 'layui-icon-add-1', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('312', '编辑会员组', 'usergroup/edit', '4', '1', '310', 'layui-icon-edit', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('313', '删除会员组', 'usergroup/del', '4', '1', '310', 'layui-icon-delete', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('348', '系统管理', '', '2', '1', '120', 'layui-icon-set-sm', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('349', '配置设置', 'config/index', '3', '1', '348', 'layui-icon-tabs', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('354', '运行日志', '', '2', '1', '120', 'layui-icon-flag', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('355', '访问记录', 'visits/index', '3', '1', '354', 'layui-icon-about', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('356', '删除记录', 'visits/del', '4', '1', '355', 'layui-icon-delete', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('361', '邮箱测试', 'config/sendmail', '4', '1', '349', 'layui-icon-dialogue', '1', '', '6');
INSERT INTO `rg_adminrule` VALUES ('374', '表单管理', 'formcontent/index', '3', '1', '217', 'layui-icon-form', '0', '', '6');
INSERT INTO `rg_adminrule` VALUES ('376', '查看内容', 'formcontent/edit', '4', '1', '374', 'layui-icon-edit', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('377', '删除内容', 'formcontent/del', '4', '1', '374', 'layui-icon-delete', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('442', '素材选择', 'media/show', '4', '1', '298', 'layui-icon-carousel', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('443', '功能', '', '1', '1', '0', 'layui-icon-top', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('444', 'SEO设置', '', '2', '1', '443', 'layui-icon-website', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('445', 'TKD模板', 'tkdtemp/index', '3', '1', '444', 'layui-icon-template-1', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('446', '增加模板', 'tkdtemp/add', '4', '1', '445', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('447', '编辑模板', 'tkdtemp/edit', '4', '1', '445', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('448', '删除模板', 'tkdtemp/del', '4', '1', '445', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('449', '链接提交', 'sitemap/index', '3', '1', '444', 'layui-icon-find-fill', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('450', '主动推送', 'sitemap/tobaidu', '4', '1', '449', 'layui-icon-upload-circle', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('456', '清除不存在', 'media/dels', '4', '1', '298', 'layui-icon-fonts-del', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('461', '重建索引', 'data/reset', '4', '1', '152', 'layui-icon-refresh-3', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('462', '保存配置', 'config/saveconfig', '4', '1', '349', 'layui-icon-ok', '1', '', '5');
INSERT INTO `rg_adminrule` VALUES ('465', '文件管理', '', '2', '1', '443', 'layui-icon-file-b', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('466', '模板管理', 'filemanage/template', '3', '1', '465', 'layui-icon-template', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('467', '创建文件', 'filemanage/createfile', '4', '1', '466', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('468', '删除文件', 'filemanage/delfile', '4', '1', '466', 'layui-icon-delete', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('469', '编辑文件', 'filemanage/editfile', '4', '1', '466', 'layui-icon-edit', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('470', '保存编辑', 'filemanage/editfilesave', '4', '1', '466', 'layui-icon-edit', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('482', '域名中心', 'domains/index', '3', '1', '183', 'layui-icon-website', '0', '', '6');
INSERT INTO `rg_adminrule` VALUES ('483', '增加域名', 'domains/add', '4', '1', '482', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('484', '编辑域名', 'domains/edit', '4', '1', '482', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('485', '删除域名', 'domains/del', '4', '1', '482', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('507', '表单设置', 'formcontent/config', '4', '1', '374', 'layui-icon-list', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('508', '批量修改', 'formcontent/edits', '4', '1', '374', 'layui-icon-edit', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('510', '地区管理', 'area/index', '3', '1', '348', 'layui-icon-website', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('511', '修复库', 'area/setarea', '4', '1', '510', 'layui-icon-right', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('512', '编辑地区', 'area/edit', '4', '1', '510', 'layui-icon-edit', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('513', '删除地区', 'area/del', '4', '1', '510', 'layui-icon-delete', '1', '', '4');
INSERT INTO `rg_adminrule` VALUES ('514', '添加地区', 'area/add', '4', '1', '510', 'layui-icon-add-1', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('516', '插件管理', '', '2', '1', '443', 'layui-icon-list', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('517', '本地插件', 'addons/index', '3', '1', '516', 'layui-icon-tabs', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('518', '插件安装', 'addons/install', '4', '1', '517', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('519', '插件卸载', 'addons/uninstall', '4', '1', '517', 'layui-icon-delete', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('520', '编辑插件', 'addons/edit', '4', '1', '517', 'layui-icon-edit', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('521', '插件市场', 'addons/market', '3', '1', '516', 'layui-icon-dollar', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('522', '插件配置', 'addons/config', '4', '1', '517', 'layui-icon-set', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('523', '插件开关', 'addons/setstatus', '4', '1', '517', 'layui-icon-util', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('525', '会员栏目', 'usermenu/index', '3', '1', '569', 'layui-icon-spread-left', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('526', '增加栏目', 'usermenu/add', '4', '1', '525', 'layui-icon-add-1', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('527', '编辑栏目', 'usermenu/edit', '4', '1', '525', 'layui-icon-edit', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('528', '删除栏目', 'usermenu/del', '4', '1', '525', 'layui-icon-delete', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('530', '导出excel', 'site/toexcel', '4', '1', '184', 'layui-icon-right', '1', '', '4');
INSERT INTO `rg_adminrule` VALUES ('531', '操作日志', 'adminlog/index', '3', '1', '354', 'layui-icon-form', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('532', '删除日志', 'adminlog/del', '4', '1', '531', 'layui-icon-delete', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('540', '系统模型', 'cmsmodel/index', '3', '1', '242', 'layui-icon-right', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('541', '添加模型', 'cmsmodel/add', '4', '1', '540', 'layui-icon-add-1', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('542', '编辑模型', 'cmsmodel/edit', '4', '1', '540', 'layui-icon-edit', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('543', '删除模型', 'cmsmodel/del', '4', '1', '540', 'layui-icon-delete', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('544', '清除数据', 'cmsmodel/clear', '4', '1', '540', 'layui-icon-fonts-del', '1', '', '4');
INSERT INTO `rg_adminrule` VALUES ('545', '复制模型', 'cmsmodel/copy', '4', '1', '540', 'layui-icon-transfer', '1', '', '5');
INSERT INTO `rg_adminrule` VALUES ('547', '表单配置', 'cmsmodel/config', '4', '1', '540', 'layui-icon-form', '1', '', '7');
INSERT INTO `rg_adminrule` VALUES ('548', '添加字段', 'cmsmodel/addfields', '4', '1', '570', 'layui-icon-add-1', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('549', '编辑字段', 'cmsmodel/editfields', '4', '1', '570', 'layui-icon-edit', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('550', '删除字段', 'cmsmodel/delfields', '4', '1', '570', 'layui-icon-delete', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('551', '单页内容', 'about/index', '3', '1', '217', 'layui-icon-template-1', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('552', '添加单页', 'about/add', '4', '1', '551', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('553', '编辑单页', 'about/edit', '4', '1', '551', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('554', '删除单页', 'about/del', '4', '1', '551', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('555', '回收站', 'about/recycle', '4', '1', '551', 'layui-icon-fonts-del', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('556', '恢复单页', 'about/restore', '4', '1', '551', 'layui-icon-refresh-3', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('561', '批量修改', 'content/edits', '4', '1', '231', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('569', '会员', '', '2', '1', '161', 'layui-icon-group', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('570', '字段管理', 'cmsmodel/fieldslist', '3', '1', '242', 'layui-icon-date', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('571', '属性维护', 'attr/grouplist', '3', '1', '242', 'layui-icon-engine', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('572', '添加属性', 'attr/addgroup', '4', '1', '571', 'layui-icon-add-1', '1', '', '1');
INSERT INTO `rg_adminrule` VALUES ('573', '编辑属性', 'attr/editgroup', '4', '1', '571', 'layui-icon-edit', '1', '', '2');
INSERT INTO `rg_adminrule` VALUES ('574', '删除属性', 'attr/delgroup', '4', '1', '571', 'layui-icon-delete', '1', '', '3');
INSERT INTO `rg_adminrule` VALUES ('575', '属性内容', 'attr/index', '4', '1', '571', 'layui-icon-list', '1', '', '4');
INSERT INTO `rg_adminrule` VALUES ('576', '添加内容', 'attr/add', '4', '1', '571', 'layui-icon-add-1', '1', '', '5');
INSERT INTO `rg_adminrule` VALUES ('577', '编辑内容', 'attr/edit', '4', '1', '571', 'layui-icon-edit', '1', '', '6');
INSERT INTO `rg_adminrule` VALUES ('578', '删除内容', 'attr/del', '4', '1', '571', 'layui-icon-delete', '1', '', '7');
INSERT INTO `rg_adminrule` VALUES ('579', '批量设置', 'navlist/setmodel', '4', '1', '221', 'layui-icon-set-fill', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('584', '全局变量', 'diyfields/index', '3', '1', '183', 'layui-icon-fonts-code', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('585', '增加变量', 'diyfields/add', '4', '1', '584', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('586', '编辑变量', 'diyfields/edit', '4', '1', '584', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('587', '删除变量', 'diyfields/del', '4', '1', '584', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('588', '保存内容', 'diyfields/save', '4', '1', '584', 'layui-icon-add-1', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('590', '内容列表', 'formcontent/clist', '4', '1', '374', 'layui-icon-read', '0', '', '7');
INSERT INTO `rg_adminrule` VALUES ('591', '增加内容', 'formcontent/add', '4', '1', '374', 'layui-icon-add-1', '0', '', '9');
INSERT INTO `rg_adminrule` VALUES ('592', '附属表信息', 'attacontent/index', '3', '1', '217', 'layui-icon-chart-screen', '0', '', '7');
INSERT INTO `rg_adminrule` VALUES ('593', '添加内容', 'attacontent/add', '4', '1', '592', 'layui-icon-add-1', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('594', '编辑内容', 'attacontent/edit', '4', '1', '592', 'layui-icon-edit', '0', '', '2');
INSERT INTO `rg_adminrule` VALUES ('595', '删除内容', 'attacontent/del', '4', '1', '592', 'layui-icon-delete', '0', '', '3');
INSERT INTO `rg_adminrule` VALUES ('596', '内容列表', 'attacontent/clist', '4', '1', '592', 'layui-icon-senior', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('597', '批量修改', 'attacontent/edits', '4', '1', '592', 'layui-icon-edit', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('598', '蜘蛛记录', 'spider/index', '3', '1', '354', 'layui-icon-chart', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('599', '删除', 'spider/del', '4', '1', '598', 'layui-icon-delete', '0', '', '1');
INSERT INTO `rg_adminrule` VALUES ('601', '备份列表', 'data/backuplist', '4', '1', '152', 'layui-icon-upload', '0', '', '8');
INSERT INTO `rg_adminrule` VALUES ('602', '内容搜索', 'content/search', '4', '1', '231', 'layui-icon-search', '0', '', '11');
INSERT INTO `rg_adminrule` VALUES ('603', '内容搜索', 'attacontent/search', '4', '1', '592', 'layui-icon-search', '0', '', '6');
INSERT INTO `rg_adminrule` VALUES ('604', '内容搜索', 'funcontent/search', '4', '1', '260', 'layui-icon-search', '0', '', '6');
INSERT INTO `rg_adminrule` VALUES ('605', '内容搜索', 'formcontent/search', '4', '1', '374', 'layui-icon-search', '0', '', '8');
INSERT INTO `rg_adminrule` VALUES ('606', 'Robots', 'robots/index', '3', '1', '444', 'layui-icon-fonts-strong', '0', '', '4');
INSERT INTO `rg_adminrule` VALUES ('607', '模型修复', 'cmsmodel/repair', '4', '1', '540', 'layui-icon-refresh-3', '1', '', '6');
INSERT INTO `rg_adminrule` VALUES ('608', '系统升级', 'upgrade/index', '3', '1', '348', 'layui-icon-upload-circle', '0', '', '5');
INSERT INTO `rg_adminrule` VALUES ('610', '删除插件', 'addons/delete', '4', '1', '517', 'layui-icon-fonts-del', '0', '', '6');

-- -----------------------------
-- Table structure for `rg_articlemodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_articlemodel`;
CREATE TABLE `rg_articlemodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `navlist_id` int(11) DEFAULT '0',
  `link` varchar(255) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `imgs` mediumtext,
  `template` varchar(255) DEFAULT NULL,
  `keys` varchar(255) DEFAULT NULL,
  `desc` mediumtext,
  `hits` int(11) DEFAULT '0',
  `content` mediumtext,
  `user_id` int(11) DEFAULT '0',
  `admin_id` int(11) DEFAULT '0',
  `istop` int(11) DEFAULT '0',
  `target` varchar(50) DEFAULT NULL,
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=148 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_articlemodel`
-- -----------------------------
INSERT INTO `rg_articlemodel` VALUES ('1', '上海微电子实现22nm光刻机的研发', '6', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '10', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '1', '', '0', '0', '0', '1', '159', '1', '1', '1599204063', '1599206468', '0');
INSERT INTO `rg_articlemodel` VALUES ('2', '上海微电子实现22nm光刻机的研发', '6', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204063', '1599204115', '0');
INSERT INTO `rg_articlemodel` VALUES ('3', '上海微电子实现22nm光刻机的研发', '6', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204063', '1599204117', '0');
INSERT INTO `rg_articlemodel` VALUES ('4', '上海微电子实现22nm光刻机的研发', '6', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204063', '1599204118', '0');
INSERT INTO `rg_articlemodel` VALUES ('5', '上海微电子实现22nm光刻机的研发', '6', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204063', '1599204120', '0');
INSERT INTO `rg_articlemodel` VALUES ('6', '上海微电子实现22nm光刻机的研发', '6', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204063', '1599204121', '0');
INSERT INTO `rg_articlemodel` VALUES ('7', '上海微电子实现22nm光刻机的研发', '7', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '4', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '1', '', '0', '0', '0', '1', '159', '1', '1', '1599204130', '1599206458', '0');
INSERT INTO `rg_articlemodel` VALUES ('8', '上海微电子实现22nm光刻机的研发', '7', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '1', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204130', '1599204130', '0');
INSERT INTO `rg_articlemodel` VALUES ('9', '上海微电子实现22nm光刻机的研发', '7', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204130', '1599204130', '0');
INSERT INTO `rg_articlemodel` VALUES ('10', '上海微电子实现22nm光刻机的研发', '7', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204130', '1599204130', '0');
INSERT INTO `rg_articlemodel` VALUES ('11', '上海微电子实现22nm光刻机的研发', '7', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204130', '1599204130', '0');
INSERT INTO `rg_articlemodel` VALUES ('12', '上海微电子实现22nm光刻机的研发', '7', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204130', '1599204130', '0');
INSERT INTO `rg_articlemodel` VALUES ('13', '上海微电子实现22nm光刻机的研发', '8', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '2', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204139', '1599204139', '0');
INSERT INTO `rg_articlemodel` VALUES ('14', '上海微电子实现22nm光刻机的研发', '8', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204139', '1599204139', '0');
INSERT INTO `rg_articlemodel` VALUES ('15', '上海微电子实现22nm光刻机的研发', '8', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204139', '1599204139', '0');
INSERT INTO `rg_articlemodel` VALUES ('16', '上海微电子实现22nm光刻机的研发', '8', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204139', '1599204139', '0');
INSERT INTO `rg_articlemodel` VALUES ('17', '上海微电子实现22nm光刻机的研发', '8', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204139', '1599204139', '0');
INSERT INTO `rg_articlemodel` VALUES ('18', '上海微电子实现22nm光刻机的研发', '8', '', '', '管理员', '', '', '', '', '', '在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升', '0', '<p>在我国对半导体材料的要求超出全世界三分之一，19年单是集成化芯片進口额度就超出3000亿美元，根据所述数据信息不会太难发觉，在我国半导体材料市场容量十分大，但为什么中国沒有半导体材料生产商站出去抢占市场？缘故非常简单，我国芯片产业链发展比较晚，就硬实力来讲，各生产商属于力不从心。</p><p>就算是内地技术*秀的中芯，芯片制造加工工艺也不过是滞留在14nm环节，并且由于沒有高端光刻机扶持的原因，将来中芯工艺提升总是越来越难。但是，近期上海微电子传来一个喜讯。据了解，上海微电子选用紫外线源完成28nm加工工艺，促使国产光刻机技术性迈入重大进展。</p><p>要了解现阶段*秀的EUV光刻技术還是选用13.5nm光波长技术，而22nm技术则是13.5nm技术性以后，*秀的光刻机技术性。上海微电子也凭此技术跨越众多日本国光刻机生产商，变成仅次ASML的第二大光刻机企业。此成效也向全球证实，光刻机技术性强大的并不仅有ASML。</p><p>假如上海微电子所研发的此项技术平稳，可以完成规模生产，那麼对中国芯片加工制造业的发展趋势毫无疑问将具有极大协助。拥有国产光刻机机器设备，美国就没法随便运用封禁芯片加工厂，在我国芯片自力更生能力可能大幅度提高。乃至很有可能，我国摇身一变从芯片进口强国变为出口强国。</p><p>自然，国产光刻机的兴起也并不是一朝一夕，上海微电子现阶段仅仅完成了该加工工艺，具体运用怎样还需进一步明确。并且，就算*上海微电子取得成功造出22nm光刻机，但还要认知到，在我国高端光刻机品质与ASML光刻技术品质对比，依然拥有很大差别。</p><p>到了现在，就越发觉光刻机技术要求越来越高，要想在更多方面完成技术提升，便会越来越艰难。自然，综合看来，上海微电子完成22nm光刻机的研发对我国半导体产业及其芯片制造商来讲，全是激励人心的喜讯。上海微电子也为别的公司在开展技术提升时，开了一个好头。</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '1', '159', '1', '1', '1599204139', '1599204139', '0');
INSERT INTO `rg_articlemodel` VALUES ('109', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '222', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '10', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599204063', '1599285219', '0');
INSERT INTO `rg_articlemodel` VALUES ('115', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '223', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599204130', '1599285269', '0');
INSERT INTO `rg_articlemodel` VALUES ('127', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '222', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '10', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285214', '1599285241', '0');
INSERT INTO `rg_articlemodel` VALUES ('128', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '222', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '10', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285228', '1599285228', '0');
INSERT INTO `rg_articlemodel` VALUES ('129', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '222', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '10', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285228', '1599285240', '0');
INSERT INTO `rg_articlemodel` VALUES ('130', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '222', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '10', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285236', '1599285236', '0');
INSERT INTO `rg_articlemodel` VALUES ('131', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '222', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '10', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p><p><br/></p>', '0', '1', '1', '', '0', '0', '0', '4', '159', '1', '1', '1599285236', '1599285236', '0');
INSERT INTO `rg_articlemodel` VALUES ('132', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '222', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '10', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285236', '1599285236', '0');
INSERT INTO `rg_articlemodel` VALUES ('133', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '222', '', '', '管理员', '', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '10', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285236', '1599285240', '0');
INSERT INTO `rg_articlemodel` VALUES ('134', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '223', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285246', '1599285267', '0');
INSERT INTO `rg_articlemodel` VALUES ('135', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '223', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285254', '1599285267', '0');
INSERT INTO `rg_articlemodel` VALUES ('136', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '223', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285254', '1599285267', '0');
INSERT INTO `rg_articlemodel` VALUES ('137', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '223', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '5', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '1', '', '0', '0', '0', '4', '159', '1', '1', '1599285261', '1599285261', '0');
INSERT INTO `rg_articlemodel` VALUES ('138', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '223', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285261', '1599285265', '0');
INSERT INTO `rg_articlemodel` VALUES ('139', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '223', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285261', '1599285266', '0');
INSERT INTO `rg_articlemodel` VALUES ('140', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '223', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285261', '1599285266', '0');
INSERT INTO `rg_articlemodel` VALUES ('141', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '224', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285277', '1599285277', '0');
INSERT INTO `rg_articlemodel` VALUES ('142', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '224', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285277', '1599285277', '0');
INSERT INTO `rg_articlemodel` VALUES ('143', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '224', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285277', '1599285277', '0');
INSERT INTO `rg_articlemodel` VALUES ('144', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '224', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285277', '1599285277', '0');
INSERT INTO `rg_articlemodel` VALUES ('145', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '224', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '5', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285277', '1599285277', '0');
INSERT INTO `rg_articlemodel` VALUES ('146', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '224', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '5', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285277', '1599285277', '0');
INSERT INTO `rg_articlemodel` VALUES ('147', 'Shanghai Microelectronics realizes the development of 22nm lithography machine', '224', '', '', '管理员', '', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '', '', '', 'my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country\'s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.', '4', '<p>my country’s requirements for semiconductor materials exceed one-third of the world’s. In 19 years, the import quota of integrated chips alone exceeded US$300 billion. According to the data and information, it is not too difficult to find out that the market capacity of semiconductor materials in my country is very large. But why is there no semiconductor material manufacturer in China to go out and seize the market? The reason is very simple. The development of my country&#39;s chip industry chain is relatively late. In terms of hard power, manufacturers are unable to do what they want.</p><p><br/></p><p>Even for SMIC, which has the most outstanding technology in the mainland, the chip manufacturing process is just stuck in the 14nm link, and because there is no support for high-end lithography machines, it will always be more and more difficult to upgrade the SMIC process in the future. However, there is good news from Shanghai Microelectronics recently. It is understood that Shanghai Microelectronics chooses ultraviolet light source to complete the 28nm processing technology, which promotes the major progress of domestic lithography machine technology.</p><p><br/></p><p>It is necessary to understand that the best EUV lithography technology at this stage still uses 13.5nm light wavelength technology, and 22nm technology is 13.5nm technical, the best lithography machine technology. With this technology, Shanghai Microelectronics also leapfrogged many Japanese lithography machine manufacturers and became the second largest lithography machine company after ASML. This effect has also been confirmed to the world that ASML is not the only one that is technically powerful.</p><p><br/></p><p>If the technology developed by Shanghai Microelectronics is stable and can complete mass production, it will undoubtedly be of great assistance to the development trend of China&#39;s chip processing and manufacturing industry. With domestically made lithography machines and equipment, the United States cannot arbitrarily use to block chip processing plants, and the self-reliance of chips in my country may be greatly improved. It is even very possible that my country has transformed from a strong country in chip import to a strong country in export.</p><p><br/></p><p>Naturally, the rise of domestic lithography machines did not happen overnight. Shanghai Microelectronics has only completed the processing technology at this stage, and the specific application needs to be further clarified. Moreover, even if *Shanghai Microelectronics succeeds in building a 22nm lithography machine, it still has to realize that the quality of my country&#39;s high-end lithography machine is still very different from the quality of ASML lithography technology.</p><p><br/></p><p>Nowadays, it is more and more aware that the technical requirements of the lithography machine are getting higher and higher, and it will be more and more difficult to complete the technological improvement in more aspects. Naturally, on the whole, Shanghai Microelectronics&#39; completion of the research and development of 22nm lithography machine is all encouraging news for my country&#39;s semiconductor industry and its chip manufacturers. Shanghai Microelectronics has also made a good start for other companies in their technological upgrading.</p><p><br/></p>', '0', '1', '0', '', '0', '0', '0', '4', '159', '1', '1', '1599285277', '1599285277', '0');

-- -----------------------------
-- Table structure for `rg_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rg_attr`;
CREATE TABLE `rg_attr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `attrgroup_id` int(11) DEFAULT '0',
  `color` varchar(50) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `rg_attrgroup`
-- -----------------------------
DROP TABLE IF EXISTS `rg_attrgroup`;
CREATE TABLE `rg_attrgroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(80) DEFAULT NULL,
  `name` varchar(80) DEFAULT NULL,
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `rg_blockattamodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_blockattamodel`;
CREATE TABLE `rg_blockattamodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template` varchar(255) DEFAULT NULL,
  `hits` int(11) DEFAULT '0',
  `user_id` int(11) DEFAULT '0',
  `admin_id` int(11) DEFAULT '0',
  `c_id` int(11) DEFAULT '0',
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  `title` mediumtext,
  `img` mediumtext,
  `link` mediumtext,
  `content` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_blockattamodel`
-- -----------------------------
INSERT INTO `rg_blockattamodel` VALUES ('1', '', '0', '0', '1', '2', '0', '0', '0', '1', '168', '1', '1', '1599234313', '1599276576', '0', '生产证书、荣誉证书', '/upload/image/20200904/d5dc821fb67ceb684e568d762cb6a197.jpg', '#', '<p>生产基地、国家质量监督局认证</p><p>集研产销于一体，直接面向终端</p><p>无中间环节,让利于您</p>');
INSERT INTO `rg_blockattamodel` VALUES ('2', '', '0', '0', '1', '2', '0', '0', '0', '1', '168', '1', '1', '1599234338', '1599276562', '0', '按产品匹配专业技术指导', '/upload/image/20200904/9214a938547dc5994f429dedda49c428.jpg', '#', '<p>按行业所需配备的指导</p><p>规格齐全，涵盖系统产品</p><p>解决您产品使用过程中的问题</p>');
INSERT INTO `rg_blockattamodel` VALUES ('3', '', '0', '0', '1', '2', '0', '0', '0', '1', '168', '1', '1', '1599234361', '1599276538', '0', '高科技精密检测设备实验室', '/upload/image/20200904/66e70c95757d7c1504bf9757c701a5e6.jpg', '#', '<p>每个产品均经过检测</p><p>每批次产品均经过检测</p><p>每批次成品包装前进行试验</p>');
INSERT INTO `rg_blockattamodel` VALUES ('4', '', '0', '0', '1', '2', '0', '0', '0', '1', '168', '1', '1', '1599234394', '1599234415', '0', '产品销售客户覆盖全国', '/upload/image/20200904/80c571386145f4228afc85d9692f3c1e.jpg', '#', '<p>客户已覆盖全国</p><p>国内24小时售前售后服务</p><p>所生产销售产品均质量保证</p>');
INSERT INTO `rg_blockattamodel` VALUES ('5', '', '0', '0', '1', '3', '0', '0', '0', '1', '168', '1', '1', '1599234838', '1599276618', '0', '高效率的服务团队', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('6', '', '0', '0', '1', '3', '0', '0', '0', '1', '168', '1', '1', '1599234838', '1599234849', '0', '专业的客服团队、完善的服务体系', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('7', '', '0', '0', '1', '3', '0', '0', '0', '1', '168', '1', '1', '1599234838', '1599276482', '0', '产品通过质量体系认证', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('8', '', '0', '0', '1', '3', '0', '0', '0', '1', '168', '1', '1', '1599234838', '1599276488', '0', '全套检测设备、保障产品品质', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('9', '', '0', '0', '1', '3', '0', '0', '0', '1', '168', '1', '1', '1599234838', '1599276495', '0', '专注于行业10年，技术成熟', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('10', '', '0', '0', '1', '3', '0', '0', '0', '1', '168', '1', '1', '1599234838', '1599234875', '0', '产品种类齐全、库存充足，一站式采购', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('31', '', '0', '0', '1', '26', '0', '0', '0', '4', '168', '1', '1', '1599234313', '1599285551', '0', 'Certificate & Honor', '/upload/image/20200904/d5dc821fb67ceb684e568d762cb6a197.jpg', '#', '<p>Production base, National Quality Supervision Bureau certification</p><p>Integrate research, production and sales, directly facing the terminal</p>');
INSERT INTO `rg_blockattamodel` VALUES ('32', '', '0', '0', '1', '26', '0', '0', '0', '4', '168', '1', '1', '1599234338', '1599285555', '0', 'Professional technical guidance', '/upload/image/20200904/9214a938547dc5994f429dedda49c428.jpg', '#', '<p>Guidance required by industry</p><p>Complete specifications, covering system products</p>');
INSERT INTO `rg_blockattamodel` VALUES ('33', '', '0', '0', '1', '26', '0', '0', '0', '4', '168', '1', '1', '1599234361', '1599285565', '0', 'High-tech equipment laboratory', '/upload/image/20200904/66e70c95757d7c1504bf9757c701a5e6.jpg', '#', '<p>Every product is tested</p><p>Each batch of products is tested</p>');
INSERT INTO `rg_blockattamodel` VALUES ('34', '', '0', '0', '1', '26', '0', '0', '0', '4', '168', '1', '1', '1599234394', '1599285576', '0', 'Customers cover the whole country', '/upload/image/20200904/80c571386145f4228afc85d9692f3c1e.jpg', '#', '<p>Customers have covered the whole country</p><p>Domestic 24-hour pre-sale and after-sales service</p>');
INSERT INTO `rg_blockattamodel` VALUES ('35', '', '0', '0', '1', '27', '0', '0', '0', '4', '168', '1', '1', '1599234838', '1599285336', '0', 'Efficient service team', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('36', '', '0', '0', '1', '27', '0', '0', '0', '4', '168', '1', '1', '1599234838', '1599285342', '0', 'Perfect service system', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('37', '', '0', '0', '1', '27', '0', '0', '0', '4', '168', '1', '1', '1599234838', '1599285352', '0', 'Quality certification', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('38', '', '0', '0', '1', '27', '0', '0', '0', '4', '168', '1', '1', '1599234838', '1599285363', '0', 'Guarantee product quality', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('39', '', '0', '0', '1', '27', '0', '0', '0', '4', '168', '1', '1', '1599234838', '1599285371', '0', 'Focus on the industry for 10 years', '', '', '');
INSERT INTO `rg_blockattamodel` VALUES ('40', '', '0', '0', '1', '27', '0', '0', '0', '4', '168', '1', '1', '1599234838', '1599285378', '0', 'Complete product range', '', '', '');

-- -----------------------------
-- Table structure for `rg_blockmodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_blockmodel`;
CREATE TABLE `rg_blockmodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT '0',
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  `title1` mediumtext,
  `title2` mediumtext,
  `title` mediumtext,
  `img` mediumtext,
  `nids` mediumtext,
  `content` mediumtext,
  `alias` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_blockmodel`
-- -----------------------------
INSERT INTO `rg_blockmodel` VALUES ('1', '1', '0', '0', '0', '1', '167', '1', '1', '1599233152', '1599278171', '0', '板块主标题 一 后台功能管理中的块管理', '块管理中的首页产品橱窗', '首页产品橱窗', '', '10,11,12,13', '', 'index_cp');
INSERT INTO `rg_blockmodel` VALUES ('2', '1', '0', '0', '0', '1', '167', '1', '1', '1599233197', '1599278168', '0', '板块主标题 一 后台功能管理中的块管理', '块管理中的首页解决方案', '首页解决方案', '', '', '', 'index_jjfa');
INSERT INTO `rg_blockmodel` VALUES ('3', '1', '0', '0', '0', '1', '167', '1', '1', '1599233221', '1599278164', '0', '板块主标题 一 后台功能管理中的块管理', '块管理中的首页优势管理', '首页优势', '', '', '', 'index_ys');
INSERT INTO `rg_blockmodel` VALUES ('4', '1', '0', '0', '0', '1', '167', '1', '1', '1599233277', '1599278160', '0', '板块主标题 一 后台功能管理中的块管理', '首页关于我们块副标题管理', '首页关于我们', '', '2', '', 'index_gywm');
INSERT INTO `rg_blockmodel` VALUES ('25', '1', '0', '0', '0', '4', '167', '1', '1', '1599233152', '1599284863', '0', 'The main title of the section I. Block management in the background function management', 'Home Product Showcase in Block Management', '首页产品橱窗', '', '226,227,228,229', '', 'index_cp');
INSERT INTO `rg_blockmodel` VALUES ('26', '1', '0', '0', '0', '4', '167', '1', '1', '1599233197', '1599284895', '0', 'The main title of the section I. Block management in the background function management', 'Home page solution in block management', '首页解决方案', '', '', '', 'index_jjfa');
INSERT INTO `rg_blockmodel` VALUES ('27', '1', '0', '0', '0', '4', '167', '1', '1', '1599233221', '1599284935', '0', 'The main title of the section I. Block management in the background function management', 'Home page advantage management in block management', '首页优势', '', '', '', 'index_ys');
INSERT INTO `rg_blockmodel` VALUES ('28', '1', '0', '0', '0', '4', '167', '1', '1', '1599233277', '1599284918', '0', 'The main title of the section I. Block management in the background function management', 'HomeAbout UsBlock Subtitle Management', '首页关于我们', '', '218', '', 'index_gywm');
INSERT INTO `rg_blockmodel` VALUES ('29', '1', '0', '0', '0', '1', '167', '1', '1', '1599283976', '1599284031', '0', '', '', '首页底部左侧新闻', '', '6,7', '', 'index_xinwen');
INSERT INTO `rg_blockmodel` VALUES ('30', '1', '0', '0', '0', '1', '167', '1', '1', '1599284024', '1599284024', '0', '', '', '首页底部右侧滚动', '', '8', '', 'index_gundong');
INSERT INTO `rg_blockmodel` VALUES ('31', '1', '0', '0', '0', '4', '167', '1', '1', '1599284148', '1599284148', '0', '', '', '首页底部左侧新闻', '', '222,223', '', 'index_xinwen');
INSERT INTO `rg_blockmodel` VALUES ('32', '1', '0', '0', '0', '4', '167', '1', '1', '1599284165', '1599284165', '0', '', '', '首页底部右侧滚动', '', '224', '', 'index_gundong');

-- -----------------------------
-- Table structure for `rg_casemodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_casemodel`;
CREATE TABLE `rg_casemodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `navlist_id` int(11) DEFAULT '0',
  `link` varchar(255) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `imgs` mediumtext,
  `template` varchar(255) DEFAULT NULL,
  `keys` varchar(255) DEFAULT NULL,
  `desc` mediumtext,
  `hits` int(11) DEFAULT '0',
  `content` mediumtext,
  `user_id` int(11) DEFAULT '0',
  `admin_id` int(11) DEFAULT '0',
  `istop` int(11) DEFAULT '0',
  `target` varchar(50) DEFAULT NULL,
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_casemodel`
-- -----------------------------
INSERT INTO `rg_casemodel` VALUES ('1', '工程案例', '34', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '4', '', '0', '1', '0', '', '0', '0', '0', '1', '169', '1', '1', '1599240371', '1599240408', '0');
INSERT INTO `rg_casemodel` VALUES ('2', '工程案例', '34', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '1', '', '0', '1', '0', '', '0', '0', '0', '1', '169', '1', '1', '1599240371', '1599240410', '0');
INSERT INTO `rg_casemodel` VALUES ('3', '工程案例', '34', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '169', '1', '1', '1599240371', '1599240412', '0');
INSERT INTO `rg_casemodel` VALUES ('4', '工程案例', '34', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '2', '', '0', '1', '0', '', '0', '0', '0', '1', '169', '1', '1', '1599240421', '1599240421', '0');
INSERT INTO `rg_casemodel` VALUES ('5', '工程案例', '34', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '169', '1', '1', '1599240421', '1599240421', '0');
INSERT INTO `rg_casemodel` VALUES ('6', '工程案例', '34', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '169', '1', '1', '1599240421', '1599240421', '0');
INSERT INTO `rg_casemodel` VALUES ('37', 'Case', '250', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '4', '', '0', '1', '0', '', '0', '0', '0', '4', '169', '1', '1', '1599240371', '1599240408', '0');
INSERT INTO `rg_casemodel` VALUES ('38', 'Case', '250', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '1', '', '0', '1', '0', '', '0', '0', '0', '4', '169', '1', '1', '1599240371', '1599240410', '0');
INSERT INTO `rg_casemodel` VALUES ('39', 'Case', '250', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '169', '1', '1', '1599240371', '1599240412', '0');
INSERT INTO `rg_casemodel` VALUES ('40', 'Case', '250', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '3', '', '0', '1', '0', '', '0', '0', '0', '4', '169', '1', '1', '1599240421', '1599240421', '0');
INSERT INTO `rg_casemodel` VALUES ('41', 'Case', '250', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '169', '1', '1', '1599240421', '1599240421', '0');
INSERT INTO `rg_casemodel` VALUES ('42', 'Case', '250', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '169', '1', '1', '1599240421', '1599240421', '0');

-- -----------------------------
-- Table structure for `rg_cmsfields`
-- -----------------------------
DROP TABLE IF EXISTS `rg_cmsfields`;
CREATE TABLE `rg_cmsfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `type` varchar(10) DEFAULT NULL,
  `createtype` int(11) DEFAULT '0',
  `defaultval` mediumtext,
  `content` mediumtext,
  `require` int(11) DEFAULT '0',
  `rule` varchar(100) DEFAULT NULL,
  `regexrule` varchar(255) DEFAULT NULL,
  `source_type` varchar(20) DEFAULT NULL,
  `source_id` int(11) DEFAULT '0',
  `source_name` varchar(100) DEFAULT NULL,
  `source_title` varchar(50) DEFAULT NULL,
  `source_value` varchar(20) DEFAULT NULL,
  `time_format` varchar(50) DEFAULT NULL,
  `width` int(11) DEFAULT '0',
  `is_edit` int(11) DEFAULT '0',
  `is_show` int(11) DEFAULT '0',
  `is_sort` int(11) DEFAULT '0',
  `is_search` int(11) DEFAULT '0',
  `thumb` int(11) DEFAULT '0',
  `water` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `config` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_cmsfields`
-- -----------------------------
INSERT INTO `rg_cmsfields` VALUES ('21', '标题', 'title', 'input', '1', '', '', '1', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '1', '162', '');
INSERT INTO `rg_cmsfields` VALUES ('22', '图片', 'img', 'img', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '2', '162', '');
INSERT INTO `rg_cmsfields` VALUES ('23', '链接', 'link', 'input', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '3', '162', '');
INSERT INTO `rg_cmsfields` VALUES ('30', '推荐', 'tuijian', 'switch', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '1', '158', '');
INSERT INTO `rg_cmsfields` VALUES ('35', '标题', 'title', 'input', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '1', '165', '');
INSERT INTO `rg_cmsfields` VALUES ('36', '链接', 'link', 'input', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '2', '165', '');
INSERT INTO `rg_cmsfields` VALUES ('37', '图片', 'img', 'img', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '3', '165', '');
INSERT INTO `rg_cmsfields` VALUES ('38', '手机站', 'iwap', 'switch', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '4', '162', '');
INSERT INTO `rg_cmsfields` VALUES ('41', '块主标题', 'title1', 'input', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '0', '0', '0', '0', '0', '1', '3', '167', '');
INSERT INTO `rg_cmsfields` VALUES ('42', '块副标题', 'title2', 'input', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '0', '0', '0', '0', '0', '1', '3', '167', '');
INSERT INTO `rg_cmsfields` VALUES ('43', '块描述', 'title', 'input', '1', '', '', '1', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '1', '167', '');
INSERT INTO `rg_cmsfields` VALUES ('44', '图片', 'img', 'img', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '4', '167', '');
INSERT INTO `rg_cmsfields` VALUES ('45', '块内栏目', 'nids', 'transfer', '1', '', '', '0', '', '', 'navlist', '0', '', 'name', 'id', '', '0', '1', '0', '0', '0', '0', '0', '1', '5', '167', '');
INSERT INTO `rg_cmsfields` VALUES ('46', '其他内容', 'content', 'ueditor', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '0', '0', '0', '0', '0', '1', '6', '167', '');
INSERT INTO `rg_cmsfields` VALUES ('47', '标题', 'title', 'input', '1', '', '', '1', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '1', '168', '');
INSERT INTO `rg_cmsfields` VALUES ('48', '图片', 'img', 'img', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '2', '168', '');
INSERT INTO `rg_cmsfields` VALUES ('49', '链接', 'link', 'input', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '0', '0', '0', '0', '0', '1', '3', '168', '');
INSERT INTO `rg_cmsfields` VALUES ('50', '内容', 'content', 'ueditor', '1', '', '', '0', '', '', '', '0', '', '', '', '', '0', '1', '0', '0', '0', '0', '0', '1', '4', '168', '');
INSERT INTO `rg_cmsfields` VALUES ('51', '姓名', 'name', 'input', '1', '', '', '1', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '1', '170', '');
INSERT INTO `rg_cmsfields` VALUES ('52', '手机', 'mobile', 'input', '1', '', '', '1', 'mobile', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '2', '170', '');
INSERT INTO `rg_cmsfields` VALUES ('53', '邮箱', 'email', 'input', '1', '', '', '0', 'email', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '3', '170', '');
INSERT INTO `rg_cmsfields` VALUES ('54', '内容', 'content', 'textarea', '1', '', '', '1', '', '', '', '0', '', '', '', '', '0', '1', '0', '0', '0', '0', '0', '1', '4', '170', '');
INSERT INTO `rg_cmsfields` VALUES ('56', '调用标识', 'alias', 'input', '1', '', '', '1', '', '', '', '0', '', '', '', '', '0', '1', '1', '0', '0', '0', '0', '1', '2', '167', '');

-- -----------------------------
-- Table structure for `rg_cmsmodels`
-- -----------------------------
DROP TABLE IF EXISTS `rg_cmsmodels`;
CREATE TABLE `rg_cmsmodels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `type` int(11) DEFAULT '0',
  `name` varchar(50) DEFAULT NULL,
  `tablename` varchar(50) DEFAULT NULL,
  `classname` varchar(50) DEFAULT NULL,
  `torder` int(11) DEFAULT '0',
  `config` mediumtext,
  `orderfield` varchar(50) DEFAULT NULL,
  `ordertype` varchar(20) DEFAULT NULL,
  `siteids` varchar(255) DEFAULT NULL,
  `site_id` int(11) DEFAULT '0',
  `attamodel_id` int(11) DEFAULT '0',
  `region` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=171 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_cmsmodels`
-- -----------------------------
INSERT INTO `rg_cmsmodels` VALUES ('158', '产品', '1', 'product', 'productmodel', 'Productmodel', '1', '', '', '', '', '0', '0', '0');
INSERT INTO `rg_cmsmodels` VALUES ('159', '文章', '1', 'article', 'articlemodel', 'Articlemodel', '2', '', '', '', '', '0', '0', '0');
INSERT INTO `rg_cmsmodels` VALUES ('160', '图片', '1', 'pic', 'picmodel', 'Picmodel', '3', '', '', '', '', '0', '0', '0');
INSERT INTO `rg_cmsmodels` VALUES ('161', '招聘', '1', 'jobs', 'jobsmodel', 'Jobsmodel', '4', '', '', '', '', '0', '0', '0');
INSERT INTO `rg_cmsmodels` VALUES ('162', '幻灯片', '2', 'slide', 'slidemodel', 'Slidemodel', '5', '', '', '', '', '0', '0', '0');
INSERT INTO `rg_cmsmodels` VALUES ('165', '友情链接', '2', 'flink', 'flinkmodel', 'Flinkmodel', '7', '', '', '', '', '0', '0', '0');
INSERT INTO `rg_cmsmodels` VALUES ('167', '块管理', '2', 'block', 'blockmodel', 'Blockmodel', '9', '', '', '', '', '0', '168', '0');
INSERT INTO `rg_cmsmodels` VALUES ('168', '功能块附属表', '5', 'blockatta', 'blockattamodel', 'Blockattamodel', '10', '', '', '', '', '0', '0', '0');
INSERT INTO `rg_cmsmodels` VALUES ('169', '案例', '1', 'case', 'casemodel', 'Casemodel', '9', '', '', '', '', '0', '0', '0');
INSERT INTO `rg_cmsmodels` VALUES ('170', '在线留言', '3', 'feedback', 'feedbackmodel', 'Feedbackmodel', '10', '', '', '', '', '0', '0', '0');

-- -----------------------------
-- Table structure for `rg_diyfields`
-- -----------------------------
DROP TABLE IF EXISTS `rg_diyfields`;
CREATE TABLE `rg_diyfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `type` varchar(10) DEFAULT NULL,
  `tablename` varchar(50) DEFAULT NULL,
  `value` mediumtext,
  `cid` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `IDX_2EE6232602` (`tablename`,`cid`,`status`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_diyfields`
-- -----------------------------
INSERT INTO `rg_diyfields` VALUES ('1', 'QQ', 'qq', 'input', 'site', '15108148', '1', '1', '1', '1', '1599202525', '1599273116');
INSERT INTO `rg_diyfields` VALUES ('2', '微信', 'weixin', 'img', 'site', '/upload/image/20200904/6d003eb1031746e808cc10987e63506d.jpg', '1', '1', '1', '2', '1599206789', '1599273116');
INSERT INTO `rg_diyfields` VALUES ('3', '底部LOGO', 'dlogo', 'img', 'site', '/upload/image/20200904/e9d42f4cdaae5c6915cfaaf7ccfbbb3d.jpg', '1', '1', '1', '3', '1599208376', '1599273116');
INSERT INTO `rg_diyfields` VALUES ('4', '头部标语', 'topword', 'textarea', 'site', '<strong>简单易用的<span>PHP建站</span>管理系统</strong>RGCMS使用方便，扩展性强', '1', '1', '1', '4', '1599210092', '1599273116');
INSERT INTO `rg_diyfields` VALUES ('5', '内页顶图', 'nbanner', 'img', 'site', '/upload/image/20200905/60e10ea5e31283772893e3d5090e19d4.jpg', '1', '1', '1', '5', '1599235999', '1599273116');
INSERT INTO `rg_diyfields` VALUES ('31', 'QQ', 'qq', 'input', 'site', '15108148', '4', '4', '1', '1', '1599202525', '1599284253');
INSERT INTO `rg_diyfields` VALUES ('32', '微信', 'weixin', 'img', 'site', '/upload/image/20200904/6d003eb1031746e808cc10987e63506d.jpg', '4', '4', '1', '2', '1599206789', '1599284253');
INSERT INTO `rg_diyfields` VALUES ('33', '底部LOGO', 'dlogo', 'img', 'site', '/upload/image/20200904/e9d42f4cdaae5c6915cfaaf7ccfbbb3d.jpg', '4', '4', '1', '3', '1599208376', '1599284253');
INSERT INTO `rg_diyfields` VALUES ('34', '头部标语', 'topword', 'textarea', 'site', '<strong>The easy-to-use <span>PHP website</span> management system</strong>RGCMS is easy to use and has strong scalability', '4', '4', '1', '4', '1599210092', '1599284253');
INSERT INTO `rg_diyfields` VALUES ('35', '内页顶图', 'nbanner', 'img', 'site', '/upload/image/20200905/60e10ea5e31283772893e3d5090e19d4.jpg', '4', '4', '1', '5', '1599235999', '1599284253');

-- -----------------------------
-- Table structure for `rg_domains`
-- -----------------------------
DROP TABLE IF EXISTS `rg_domains`;
CREATE TABLE `rg_domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) DEFAULT NULL,
  `site_id` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `rg_feedbackmodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_feedbackmodel`;
CREATE TABLE `rg_feedbackmodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT '0',
  `pid` int(11) DEFAULT '0',
  `user_ip` varchar(50) DEFAULT NULL,
  `reply` mediumtext,
  `userview` int(11) DEFAULT '0',
  `adminview` int(11) DEFAULT '0',
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  `name` mediumtext,
  `mobile` mediumtext,
  `email` mediumtext,
  `content` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_feedbackmodel`
-- -----------------------------
INSERT INTO `rg_feedbackmodel` VALUES ('1', '0', '0', '127.0.0.1', '', '0', '1', '0', '0', '0', '1', '0', '1', '0', '1599271581', '1599271581', '0', '李小军', '13999999999', 'tangji@yeah.net', '留言测试');
INSERT INTO `rg_feedbackmodel` VALUES ('2', '0', '0', '127.0.0.1', '', '0', '0', '0', '0', '0', '1', '0', '1', '0', '1599272242', '1599272242', '0', 'werew', '13999999999', 'tangji@yeah.net', 'werer');

-- -----------------------------
-- Table structure for `rg_flinkmodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_flinkmodel`;
CREATE TABLE `rg_flinkmodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT '0',
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  `title` mediumtext,
  `link` mediumtext,
  `img` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_flinkmodel`
-- -----------------------------
INSERT INTO `rg_flinkmodel` VALUES ('1', '1', '0', '0', '0', '1', '165', '1', '1', '1599206631', '1599206631', '0', 'CMS系统', 'http://www.rgxx.com', '');
INSERT INTO `rg_flinkmodel` VALUES ('2', '1', '0', '0', '0', '1', '165', '1', '1', '1599206638', '1599206638', '0', '睿谷信息', 'http://www.rgxx.com', '');
INSERT INTO `rg_flinkmodel` VALUES ('3', '1', '0', '0', '0', '1', '165', '1', '1', '1599206648', '1599206648', '0', 'RGCMS', 'http://www.rgxx.com', '');
INSERT INTO `rg_flinkmodel` VALUES ('19', '1', '0', '0', '0', '4', '165', '1', '1', '1599206631', '1599206631', '0', 'CMS系统', 'http://www.rgxx.com', '');
INSERT INTO `rg_flinkmodel` VALUES ('20', '1', '0', '0', '0', '4', '165', '1', '1', '1599206638', '1599206638', '0', '睿谷信息', 'http://www.rgxx.com', '');
INSERT INTO `rg_flinkmodel` VALUES ('21', '1', '0', '0', '0', '4', '165', '1', '1', '1599206648', '1599206648', '0', 'RGCMS', 'http://www.rgxx.com', '');

-- -----------------------------
-- Table structure for `rg_formconfig`
-- -----------------------------
DROP TABLE IF EXISTS `rg_formconfig`;
CREATE TABLE `rg_formconfig` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mail` int(11) DEFAULT '0',
  `sms` int(11) DEFAULT '0',
  `mailto` varchar(255) DEFAULT NULL,
  `smsto` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  `user` int(11) DEFAULT '0',
  `ispass` int(11) DEFAULT '0',
  `verify` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `rg_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `rg_hooks`;
CREATE TABLE `rg_hooks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `addon_name` varchar(50) DEFAULT NULL,
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_hooks`
-- -----------------------------
INSERT INTO `rg_hooks` VALUES ('1', 'sysinfohook', 'sysinfo', '1573289116', '1573289116');

-- -----------------------------
-- Table structure for `rg_jobsmodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_jobsmodel`;
CREATE TABLE `rg_jobsmodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `navlist_id` int(11) DEFAULT '0',
  `link` varchar(255) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `imgs` mediumtext,
  `template` varchar(255) DEFAULT NULL,
  `keys` varchar(255) DEFAULT NULL,
  `desc` mediumtext,
  `hits` int(11) DEFAULT '0',
  `content` mediumtext,
  `user_id` int(11) DEFAULT '0',
  `admin_id` int(11) DEFAULT '0',
  `istop` int(11) DEFAULT '0',
  `target` varchar(50) DEFAULT NULL,
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `rg_media`
-- -----------------------------
DROP TABLE IF EXISTS `rg_media`;
CREATE TABLE `rg_media` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `original` varchar(255) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `size` varchar(50) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `filemd5` varchar(255) DEFAULT NULL,
  `create_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_media`
-- -----------------------------
INSERT INTO `rg_media` VALUES ('1', '19b8e26b29682ece20b3af858a0f402e.jpg', '1.jpg', 'image', '90983', '/upload/image/20200904/19b8e26b29682ece20b3af858a0f402e.jpg', '0ca916ab536f7d10f1d431fcf5f71869', '1599198957');
INSERT INTO `rg_media` VALUES ('2', '5a59e604011c32be4f424a9700d6e33b.jpg', '1.jpg', 'image', '155979', '/upload/image/20200904/5a59e604011c32be4f424a9700d6e33b.jpg', '5394b294e7ae6331e07f82e6a6190eca', '1599200813');
INSERT INTO `rg_media` VALUES ('3', 'd16f1d7350b99cf118b77163332cbc3c.jpg', '2.jpg', 'image', '255495', '/upload/image/20200904/d16f1d7350b99cf118b77163332cbc3c.jpg', '1f4b56f6bdb149d4ce5cc89291251220', '1599200821');
INSERT INTO `rg_media` VALUES ('4', 'eea3c449842137da1290a8e655e420a0.jpg', '3.jpg', 'image', '152202', '/upload/image/20200904/eea3c449842137da1290a8e655e420a0.jpg', '12b568983926b16e5c4841044bed0250', '1599200833');
INSERT INTO `rg_media` VALUES ('5', '714c74ee60d2c9f5186d3efa51920a9b.jpg', '1.jpg', 'image', '18068', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '7381468f3dbec1f1651bd132fddbdac6', '1599201907');
INSERT INTO `rg_media` VALUES ('6', 'd5dc821fb67ceb684e568d762cb6a197.jpg', 'fa3.jpg', 'image', '11833', '/upload/image/20200904/d5dc821fb67ceb684e568d762cb6a197.jpg', 'd9f9b27d35bd4bac40bf8540eb824c55', '1599203050');
INSERT INTO `rg_media` VALUES ('7', '9214a938547dc5994f429dedda49c428.jpg', 'fa2.jpg', 'image', '20972', '/upload/image/20200904/9214a938547dc5994f429dedda49c428.jpg', '01e153ac105674f52ba61926d6cf52dd', '1599203076');
INSERT INTO `rg_media` VALUES ('8', '66e70c95757d7c1504bf9757c701a5e6.jpg', 'fa1.jpg', 'image', '23124', '/upload/image/20200904/66e70c95757d7c1504bf9757c701a5e6.jpg', '8aaa14498b4e93359b61075d1dc641eb', '1599203096');
INSERT INTO `rg_media` VALUES ('9', '80c571386145f4228afc85d9692f3c1e.jpg', 'fa4.jpg', 'image', '17339', '/upload/image/20200904/80c571386145f4228afc85d9692f3c1e.jpg', '3f9c3c5a05b3c77cabef267585f94b24', '1599203116');
INSERT INTO `rg_media` VALUES ('10', '7e22b5dbf6c0b8905d3d56298d8598b7.jpg', '1.jpg', 'image', '26182', '/upload/image/20200904/7e22b5dbf6c0b8905d3d56298d8598b7.jpg', 'de6d1a1371d2ae2cf16e5558ad3f6447', '1599206456');
INSERT INTO `rg_media` VALUES ('11', '983a8655f2fb9ae20392038fead01808.jpeg', '2.jpeg', 'image', '29215', '/upload/image/20200904/983a8655f2fb9ae20392038fead01808.jpeg', '383c19f8c01257d9fca9fe7d6677b751', '1599206467');
INSERT INTO `rg_media` VALUES ('12', '6d003eb1031746e808cc10987e63506d.jpg', '1.jpg', 'image', '16548', '/upload/image/20200904/6d003eb1031746e808cc10987e63506d.jpg', 'ba78b5dabee938d9cecdc8a183f0209e', '1599206860');
INSERT INTO `rg_media` VALUES ('13', 'e9d42f4cdaae5c6915cfaaf7ccfbbb3d.jpg', '2.jpg', 'image', '23276', '/upload/image/20200904/e9d42f4cdaae5c6915cfaaf7ccfbbb3d.jpg', '03b0645d9c9c730720d15a0f5430e51f', '1599208382');
INSERT INTO `rg_media` VALUES ('14', 'de6f62ebe88833304773d1a07ae7ede9.jpg', '1.jpg', 'image', '20358', '/upload/image/20200904/de6f62ebe88833304773d1a07ae7ede9.jpg', 'f942cc274d4c1c6ab783175900c570d6', '1599208388');
INSERT INTO `rg_media` VALUES ('15', '60e10ea5e31283772893e3d5090e19d4.jpg', 'nybanner.jpg', 'image', '219221', '/upload/image/20200905/60e10ea5e31283772893e3d5090e19d4.jpg', '19fd061abfa6843c8113484ed12721c3', '1599236024');
INSERT INTO `rg_media` VALUES ('16', '966eefa1d43c817a2343d70f88a458c5.jpg', '1.jpg', 'image', '23614', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '5196f1fe9adcaea281f4c8442fc70945', '1599236389');
INSERT INTO `rg_media` VALUES ('17', 'd375cbeb088892eeec72c23e2676ab41.jpg', '2.jpg', 'image', '11911', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', 'a9e15ea4e863043a8aa68345841ad5c9', '1599236433');

-- -----------------------------
-- Table structure for `rg_navgroup`
-- -----------------------------
DROP TABLE IF EXISTS `rg_navgroup`;
CREATE TABLE `rg_navgroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `site_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_navgroup`
-- -----------------------------
INSERT INTO `rg_navgroup` VALUES ('1', '底部导航', 'G1', '1');
INSERT INTO `rg_navgroup` VALUES ('7', '底部导航', 'G1', '4');

-- -----------------------------
-- Table structure for `rg_navlist`
-- -----------------------------
DROP TABLE IF EXISTS `rg_navlist`;
CREATE TABLE `rg_navlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `ename` varchar(255) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `site_id` int(11) DEFAULT '0',
  `pid` int(11) DEFAULT '0',
  `type` varchar(100) DEFAULT NULL,
  `typeid` int(11) DEFAULT '0',
  `listtemp` varchar(255) DEFAULT NULL,
  `infotemp` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `config` mediumtext,
  `keys` mediumtext,
  `desc` mediumtext,
  `G0` int(11) DEFAULT '0',
  `G1` int(11) DEFAULT '0',
  `G2` int(11) DEFAULT '0',
  `G3` int(11) DEFAULT '0',
  `G4` int(11) DEFAULT '0',
  `G5` int(11) DEFAULT '0',
  `G6` int(11) DEFAULT '0',
  `G7` int(11) DEFAULT '0',
  `G8` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `agids` varchar(255) DEFAULT NULL,
  `ugids` varchar(255) DEFAULT NULL,
  `target` varchar(50) DEFAULT NULL,
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `IDX_356CBC4F93` (`id`,`site_id`,`status`)
) ENGINE=MyISAM AUTO_INCREMENT=253 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_navlist`
-- -----------------------------
INSERT INTO `rg_navlist` VALUES ('1', '关于我们', '', '', '1', '0', 'link', '0', '', '', 'javascript:;', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '', '1599198990', '1599207107');
INSERT INTO `rg_navlist` VALUES ('2', '企业概况', '', '', '1', '1', 'about', '1', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '2', '1', '0', '0', '', '1599199025', '1599207107');
INSERT INTO `rg_navlist` VALUES ('3', '车间设备', '', '', '1', '1', 'model', '160', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '3', '1', '0', '0', '', '1599199052', '1599207108');
INSERT INTO `rg_navlist` VALUES ('4', '荣誉资质', '', '', '1', '1', 'model', '160', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '4', '1', '0', '0', '', '1599199066', '1599199066');
INSERT INTO `rg_navlist` VALUES ('5', '新闻资讯', '', '', '1', '0', 'model', '159', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '5', '1', '0', '0', '', '1599199086', '1599199086');
INSERT INTO `rg_navlist` VALUES ('6', '公司动态', '', '', '1', '5', 'model', '159', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '6', '1', '0', '0', '', '1599199115', '1599199115');
INSERT INTO `rg_navlist` VALUES ('7', '行业资讯', '', '', '1', '5', 'model', '159', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '7', '1', '0', '0', '', '1599199115', '1599238175');
INSERT INTO `rg_navlist` VALUES ('8', '技术百科', '', '', '1', '5', 'model', '159', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '8', '1', '0', '0', '', '1599199115', '1599238177');
INSERT INTO `rg_navlist` VALUES ('9', '产品中心', '', '', '1', '0', 'model', '158', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '9', '1', '0', '0', '', '1599199126', '1599206988');
INSERT INTO `rg_navlist` VALUES ('10', '产品系列一', '', '', '1', '9', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '10', '1', '0', '0', '', '1599199158', '1599199158');
INSERT INTO `rg_navlist` VALUES ('11', '产品系列二', '', '', '1', '9', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '11', '1', '0', '0', '', '1599199158', '1599202250');
INSERT INTO `rg_navlist` VALUES ('12', '产品系列三', '', '', '1', '9', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '12', '1', '0', '0', '', '1599199158', '1599202253');
INSERT INTO `rg_navlist` VALUES ('13', '产品系列四', '', '', '1', '9', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '13', '1', '0', '0', '', '1599199158', '1599202256');
INSERT INTO `rg_navlist` VALUES ('14', '产品系列五', '', '', '1', '9', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '14', '1', '0', '0', '', '1599199158', '1599202259');
INSERT INTO `rg_navlist` VALUES ('15', '产品系列六', '', '', '1', '9', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '15', '1', '0', '0', '', '1599199158', '1599202264');
INSERT INTO `rg_navlist` VALUES ('16', '三级分类一', '', '', '1', '10', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '16', '1', '0', '0', '', '1599199194', '1599199194');
INSERT INTO `rg_navlist` VALUES ('17', '三级分类二', '', '', '1', '10', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '16', '1', '0', '0', '', '1599199194', '1599199194');
INSERT INTO `rg_navlist` VALUES ('18', '三级分类三', '', '', '1', '10', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '16', '1', '0', '0', '', '1599199194', '1599199194');
INSERT INTO `rg_navlist` VALUES ('19', '三级分类四', '', '', '1', '10', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '16', '1', '0', '0', '', '1599199194', '1599199194');
INSERT INTO `rg_navlist` VALUES ('20', '三级分类五', '', '', '1', '11', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '20', '1', '0', '0', '', '1599199214', '1599199214');
INSERT INTO `rg_navlist` VALUES ('21', '三级分类六', '', '', '1', '11', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '20', '1', '0', '0', '', '1599199214', '1599199214');
INSERT INTO `rg_navlist` VALUES ('22', '三级分类七', '', '', '1', '11', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '20', '1', '0', '0', '', '1599199214', '1599199214');
INSERT INTO `rg_navlist` VALUES ('23', '三级分类八', '', '', '1', '12', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '23', '1', '0', '0', '', '1599199238', '1599199238');
INSERT INTO `rg_navlist` VALUES ('24', '三级分类九', '', '', '1', '12', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '23', '1', '0', '0', '', '1599199238', '1599199238');
INSERT INTO `rg_navlist` VALUES ('25', '三级分类十', '', '', '1', '12', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '23', '1', '0', '0', '', '1599199238', '1599199238');
INSERT INTO `rg_navlist` VALUES ('26', '三级分类十一', '', '', '1', '13', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '26', '1', '0', '0', '', '1599199262', '1599199262');
INSERT INTO `rg_navlist` VALUES ('27', '三级分类十二', '', '', '1', '13', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '26', '1', '0', '0', '', '1599199262', '1599199262');
INSERT INTO `rg_navlist` VALUES ('28', '三级分类十三', '', '', '1', '13', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '26', '1', '0', '0', '', '1599199262', '1599199262');
INSERT INTO `rg_navlist` VALUES ('29', '三级分类十四', '', '', '1', '13', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '26', '1', '0', '0', '', '1599199262', '1599199262');
INSERT INTO `rg_navlist` VALUES ('30', '三级分类十五', '', '', '1', '14', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '30', '1', '0', '0', '', '1599199275', '1599199275');
INSERT INTO `rg_navlist` VALUES ('31', '三级分类十六', '', '', '1', '14', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '30', '1', '0', '0', '', '1599199275', '1599199275');
INSERT INTO `rg_navlist` VALUES ('32', '三级分类十七', '', '', '1', '15', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '32', '1', '0', '0', '', '1599199288', '1599199288');
INSERT INTO `rg_navlist` VALUES ('33', '三级分类十八', '', '', '1', '15', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '32', '1', '0', '0', '', '1599199288', '1599199288');
INSERT INTO `rg_navlist` VALUES ('34', '案例展示', '', '', '1', '0', 'model', '169', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '34', '1', '0', '0', '', '1599199316', '1599240337');
INSERT INTO `rg_navlist` VALUES ('35', '在线留言', '', '', '1', '0', 'about', '3', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '35', '1', '0', '0', '', '1599199346', '1599206993');
INSERT INTO `rg_navlist` VALUES ('36', '联系我们', '', '', '1', '0', 'about', '2', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '36', '1', '0', '0', '', '1599199356', '1599269277');
INSERT INTO `rg_navlist` VALUES ('217', 'About us', '', '', '4', '0', 'link', '0', '', '', 'javascript:;', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '', '1599198990', '1599284279');
INSERT INTO `rg_navlist` VALUES ('218', 'About', '', '', '4', '217', 'about', '19', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '2', '1', '0', '0', '', '1599199025', '1599284283');
INSERT INTO `rg_navlist` VALUES ('219', 'Equipment', '', '', '4', '217', 'model', '160', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '3', '1', '0', '0', '', '1599199052', '1599284288');
INSERT INTO `rg_navlist` VALUES ('220', 'Honor', '', '', '4', '217', 'model', '160', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '4', '1', '0', '0', '', '1599199066', '1599284296');
INSERT INTO `rg_navlist` VALUES ('221', 'News', '', '', '4', '0', 'model', '159', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '5', '1', '0', '0', '', '1599199086', '1599284300');
INSERT INTO `rg_navlist` VALUES ('222', 'Company', '', '', '4', '221', 'model', '159', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '6', '1', '0', '0', '', '1599199115', '1599284303');
INSERT INTO `rg_navlist` VALUES ('223', 'Industry', '', '', '4', '221', 'model', '159', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '7', '1', '0', '0', '', '1599199115', '1599284314');
INSERT INTO `rg_navlist` VALUES ('224', 'Technology', '', '', '4', '221', 'model', '159', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '8', '1', '0', '0', '', '1599199115', '1599284322');
INSERT INTO `rg_navlist` VALUES ('225', 'Product', '', '', '4', '0', 'model', '158', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '9', '1', '0', '0', '', '1599199126', '1599284327');
INSERT INTO `rg_navlist` VALUES ('226', 'Product01', '', '', '4', '225', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '10', '1', '0', '0', '', '1599199158', '1599284338');
INSERT INTO `rg_navlist` VALUES ('227', 'Product02', '', '', '4', '225', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '11', '1', '0', '0', '', '1599199158', '1599284341');
INSERT INTO `rg_navlist` VALUES ('228', 'Product03', '', '', '4', '225', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '12', '1', '0', '0', '', '1599199158', '1599284344');
INSERT INTO `rg_navlist` VALUES ('229', 'Product04', '', '', '4', '225', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '13', '1', '0', '0', '', '1599199158', '1599284347');
INSERT INTO `rg_navlist` VALUES ('230', 'Product05', '', '', '4', '225', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '14', '1', '0', '0', '', '1599199158', '1599284351');
INSERT INTO `rg_navlist` VALUES ('231', 'Product06', '', '', '4', '225', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '15', '1', '0', '0', '', '1599199158', '1599284353');
INSERT INTO `rg_navlist` VALUES ('232', 'Product01-1', '', '', '4', '226', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '16', '1', '0', '0', '', '1599199194', '1599284359');
INSERT INTO `rg_navlist` VALUES ('233', 'Product01-2', '', '', '4', '226', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '16', '1', '0', '0', '', '1599199194', '1599284362');
INSERT INTO `rg_navlist` VALUES ('234', 'Product01-3', '', '', '4', '226', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '16', '1', '0', '0', '', '1599199194', '1599284365');
INSERT INTO `rg_navlist` VALUES ('235', 'Product01-4', '', '', '4', '226', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '16', '1', '0', '0', '', '1599199194', '1599284368');
INSERT INTO `rg_navlist` VALUES ('236', 'Product02-5', '', '', '4', '227', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '20', '1', '0', '0', '', '1599199214', '1599284373');
INSERT INTO `rg_navlist` VALUES ('237', 'Product02-6', '', '', '4', '227', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '20', '1', '0', '0', '', '1599199214', '1599284378');
INSERT INTO `rg_navlist` VALUES ('238', 'Product02-7', '', '', '4', '227', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '20', '1', '0', '0', '', '1599199214', '1599284381');
INSERT INTO `rg_navlist` VALUES ('239', 'Product03-8', '', '', '4', '228', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '23', '1', '0', '0', '', '1599199238', '1599284387');
INSERT INTO `rg_navlist` VALUES ('240', 'Product03-9', '', '', '4', '228', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '23', '1', '0', '0', '', '1599199238', '1599284390');
INSERT INTO `rg_navlist` VALUES ('241', 'Product03-10', '', '', '4', '228', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '23', '1', '0', '0', '', '1599199238', '1599284393');
INSERT INTO `rg_navlist` VALUES ('242', 'Product04-11', '', '', '4', '229', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '26', '1', '0', '0', '', '1599199262', '1599284397');
INSERT INTO `rg_navlist` VALUES ('243', 'Product04-12', '', '', '4', '229', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '26', '1', '0', '0', '', '1599199262', '1599284402');
INSERT INTO `rg_navlist` VALUES ('244', 'Product04-13', '', '', '4', '229', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '26', '1', '0', '0', '', '1599199262', '1599284407');
INSERT INTO `rg_navlist` VALUES ('245', 'Product04-14', '', '', '4', '229', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '26', '1', '0', '0', '', '1599199262', '1599284410');
INSERT INTO `rg_navlist` VALUES ('246', 'Product05-15', '', '', '4', '230', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '30', '1', '0', '0', '', '1599199275', '1599284414');
INSERT INTO `rg_navlist` VALUES ('247', 'Product05-16', '', '', '4', '230', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '30', '1', '0', '0', '', '1599199275', '1599284417');
INSERT INTO `rg_navlist` VALUES ('248', 'Product06-17', '', '', '4', '231', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '32', '1', '0', '0', '', '1599199288', '1599284421');
INSERT INTO `rg_navlist` VALUES ('249', 'Product06-18', '', '', '4', '231', 'model', '158', '', '', '', '', '', '', '', '1', '0', '0', '0', '0', '0', '0', '0', '0', '32', '1', '0', '0', '', '1599199288', '1599284424');
INSERT INTO `rg_navlist` VALUES ('250', 'Case', '', '', '4', '0', 'model', '169', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '34', '1', '0', '0', '', '1599199316', '1599284429');
INSERT INTO `rg_navlist` VALUES ('251', 'Book', '', '', '4', '0', 'about', '21', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '35', '1', '0', '0', '', '1599199346', '1599284436');
INSERT INTO `rg_navlist` VALUES ('252', 'Contact', '', '', '4', '0', 'about', '20', '', '', '', '', '', '', '', '1', '1', '0', '0', '0', '0', '0', '0', '0', '36', '1', '0', '0', '', '1599199356', '1599284440');

-- -----------------------------
-- Table structure for `rg_picmodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_picmodel`;
CREATE TABLE `rg_picmodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `navlist_id` int(11) DEFAULT '0',
  `link` varchar(255) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `imgs` mediumtext,
  `template` varchar(255) DEFAULT NULL,
  `keys` varchar(255) DEFAULT NULL,
  `desc` mediumtext,
  `hits` int(11) DEFAULT '0',
  `content` mediumtext,
  `user_id` int(11) DEFAULT '0',
  `admin_id` int(11) DEFAULT '0',
  `istop` int(11) DEFAULT '0',
  `target` varchar(50) DEFAULT NULL,
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=155 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_picmodel`
-- -----------------------------
INSERT INTO `rg_picmodel` VALUES ('1', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236355', '1599236391', '0');
INSERT INTO `rg_picmodel` VALUES ('2', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236355', '1599236395', '0');
INSERT INTO `rg_picmodel` VALUES ('3', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236355', '1599236396', '0');
INSERT INTO `rg_picmodel` VALUES ('4', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236355', '1599236398', '0');
INSERT INTO `rg_picmodel` VALUES ('5', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236355', '1599236399', '0');
INSERT INTO `rg_picmodel` VALUES ('6', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('7', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('8', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('9', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('10', '车间设备', '3', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('11', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236426', '1599236434', '0');
INSERT INTO `rg_picmodel` VALUES ('12', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236426', '1599236436', '0');
INSERT INTO `rg_picmodel` VALUES ('13', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236426', '1599236437', '0');
INSERT INTO `rg_picmodel` VALUES ('14', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236443', '1599236443', '0');
INSERT INTO `rg_picmodel` VALUES ('15', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236443', '1599236443', '0');
INSERT INTO `rg_picmodel` VALUES ('16', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236443', '1599236443', '0');
INSERT INTO `rg_picmodel` VALUES ('17', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('18', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('19', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('20', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('21', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('22', '荣誉资质', '4', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '1', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('133', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236355', '1599236391', '0');
INSERT INTO `rg_picmodel` VALUES ('134', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236355', '1599236395', '0');
INSERT INTO `rg_picmodel` VALUES ('135', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236355', '1599236396', '0');
INSERT INTO `rg_picmodel` VALUES ('136', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236355', '1599236398', '0');
INSERT INTO `rg_picmodel` VALUES ('137', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236355', '1599236399', '0');
INSERT INTO `rg_picmodel` VALUES ('138', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('139', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('140', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('141', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('142', 'Equipment', '219', '', '', '管理员', '', '/upload/image/20200905/966eefa1d43c817a2343d70f88a458c5.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236406', '1599236406', '0');
INSERT INTO `rg_picmodel` VALUES ('143', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236426', '1599236434', '0');
INSERT INTO `rg_picmodel` VALUES ('144', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236426', '1599236436', '0');
INSERT INTO `rg_picmodel` VALUES ('145', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236426', '1599236437', '0');
INSERT INTO `rg_picmodel` VALUES ('146', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236443', '1599236443', '0');
INSERT INTO `rg_picmodel` VALUES ('147', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236443', '1599236443', '0');
INSERT INTO `rg_picmodel` VALUES ('148', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236443', '1599236443', '0');
INSERT INTO `rg_picmodel` VALUES ('149', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('150', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('151', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('152', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('153', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236451', '1599236451', '0');
INSERT INTO `rg_picmodel` VALUES ('154', 'Honor', '220', '', '', '管理员', '', '/upload/image/20200905/d375cbeb088892eeec72c23e2676ab41.jpg', '', '', '', '', '0', '', '0', '1', '0', '', '0', '0', '0', '4', '160', '1', '1', '1599236451', '1599236451', '0');

-- -----------------------------
-- Table structure for `rg_productmodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_productmodel`;
CREATE TABLE `rg_productmodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `navlist_id` int(11) DEFAULT '0',
  `link` varchar(255) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `imgs` mediumtext,
  `template` varchar(255) DEFAULT NULL,
  `keys` varchar(255) DEFAULT NULL,
  `desc` mediumtext,
  `hits` int(11) DEFAULT '0',
  `content` mediumtext,
  `user_id` int(11) DEFAULT '0',
  `admin_id` int(11) DEFAULT '0',
  `istop` int(11) DEFAULT '0',
  `target` varchar(50) DEFAULT NULL,
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  `tuijian` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=332 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_productmodel`
-- -----------------------------
INSERT INTO `rg_productmodel` VALUES ('1', '产品名称', '21', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599201896', '1599202055', '0', '');
INSERT INTO `rg_productmodel` VALUES ('2', '产品名称', '21', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '1', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599201896', '1599202059', '0', '');
INSERT INTO `rg_productmodel` VALUES ('3', '产品名称', '21', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599201896', '1599202060', '0', '');
INSERT INTO `rg_productmodel` VALUES ('4', '产品名称', '21', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599201896', '1599202062', '0', '');
INSERT INTO `rg_productmodel` VALUES ('5', '产品名称', '17', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202070', '1599202070', '0', '');
INSERT INTO `rg_productmodel` VALUES ('6', '产品名称', '17', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202070', '1599202070', '0', '');
INSERT INTO `rg_productmodel` VALUES ('7', '产品名称', '17', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202070', '1599202070', '0', '');
INSERT INTO `rg_productmodel` VALUES ('8', '产品名称', '17', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '1', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202070', '1599202070', '0', '');
INSERT INTO `rg_productmodel` VALUES ('9', '产品名称', '18', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '2', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202080', '1599202080', '0', '');
INSERT INTO `rg_productmodel` VALUES ('10', '产品名称', '18', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202080', '1599202080', '0', '');
INSERT INTO `rg_productmodel` VALUES ('11', '产品名称', '18', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202080', '1599202080', '0', '');
INSERT INTO `rg_productmodel` VALUES ('12', '产品名称', '18', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202080', '1599202080', '0', '');
INSERT INTO `rg_productmodel` VALUES ('13', '产品名称', '19', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '9', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202087', '1599202087', '0', '');
INSERT INTO `rg_productmodel` VALUES ('14', '产品名称', '19', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '7', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202087', '1599202087', '0', '');
INSERT INTO `rg_productmodel` VALUES ('15', '产品名称', '19', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202087', '1599202087', '0', '');
INSERT INTO `rg_productmodel` VALUES ('16', '产品名称', '19', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202087', '1599202087', '0', '');
INSERT INTO `rg_productmodel` VALUES ('17', '产品名称', '20', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '1', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202096', '1599202096', '0', '');
INSERT INTO `rg_productmodel` VALUES ('18', '产品名称', '20', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202096', '1599202096', '0', '');
INSERT INTO `rg_productmodel` VALUES ('19', '产品名称', '20', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202096', '1599202096', '0', '');
INSERT INTO `rg_productmodel` VALUES ('20', '产品名称', '20', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202096', '1599202096', '0', '');
INSERT INTO `rg_productmodel` VALUES ('21', '产品名称', '16', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202116', '1599202116', '0', '');
INSERT INTO `rg_productmodel` VALUES ('22', '产品名称', '16', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202116', '1599202116', '0', '');
INSERT INTO `rg_productmodel` VALUES ('23', '产品名称', '16', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202116', '1599202116', '0', '');
INSERT INTO `rg_productmodel` VALUES ('24', '产品名称', '16', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202116', '1599202116', '0', '');
INSERT INTO `rg_productmodel` VALUES ('25', '产品名称', '23', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202124', '1599202124', '0', '');
INSERT INTO `rg_productmodel` VALUES ('26', '产品名称', '23', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202124', '1599202124', '0', '');
INSERT INTO `rg_productmodel` VALUES ('27', '产品名称', '23', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202124', '1599202124', '0', '');
INSERT INTO `rg_productmodel` VALUES ('28', '产品名称', '23', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202124', '1599202124', '0', '');
INSERT INTO `rg_productmodel` VALUES ('29', '产品名称', '25', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202132', '1599202132', '0', '');
INSERT INTO `rg_productmodel` VALUES ('30', '产品名称', '25', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202132', '1599202132', '0', '');
INSERT INTO `rg_productmodel` VALUES ('31', '产品名称', '25', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202132', '1599202132', '0', '');
INSERT INTO `rg_productmodel` VALUES ('32', '产品名称', '25', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202132', '1599202132', '0', '');
INSERT INTO `rg_productmodel` VALUES ('33', '产品名称', '30', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202141', '1599202141', '0', '');
INSERT INTO `rg_productmodel` VALUES ('34', '产品名称', '30', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202141', '1599202141', '0', '');
INSERT INTO `rg_productmodel` VALUES ('35', '产品名称', '30', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202141', '1599202141', '0', '');
INSERT INTO `rg_productmodel` VALUES ('36', '产品名称', '30', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202141', '1599202141', '0', '');
INSERT INTO `rg_productmodel` VALUES ('37', '产品名称', '32', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202150', '1599202427', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('38', '产品名称', '32', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202150', '1599202426', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('39', '产品名称', '32', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202150', '1599202150', '0', '');
INSERT INTO `rg_productmodel` VALUES ('40', '产品名称', '32', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202150', '1599202150', '0', '');
INSERT INTO `rg_productmodel` VALUES ('41', '产品名称', '28', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '2', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202163', '1599202424', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('42', '产品名称', '28', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202163', '1599202425', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('43', '产品名称', '28', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202163', '1599202425', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('44', '产品名称', '28', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', '产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！', '0', '<p>产品描述，主要写产品的相关介绍和一些表格参数，可图文结合，内容可在后台栏目内容管理里进行添加修改和删除。产品可自定义字段，并且支持动态字段以及产品的附属表信息。极大增强了系统的实用性以及多适用性，欢迎您的使用！</p>', '0', '1', '0', '', '0', '0', '0', '1', '158', '1', '1', '1599202163', '1599202425', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('305', 'Product name', '244', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599202163', '1599284751', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('309', 'Product name', '232', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '4', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284761', '1599284761', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('310', 'Product name', '232', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284768', '1599284768', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('311', 'Product name', '232', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284768', '1599284768', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('312', 'Product name', '233', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '6', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284777', '1599284777', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('313', 'Product name', '233', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284777', '1599284777', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('314', 'Product name', '233', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284777', '1599284777', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('315', 'Product name', '233', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284777', '1599284777', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('316', 'Product name', '236', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284790', '1599284790', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('317', 'Product name', '236', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284790', '1599284790', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('318', 'Product name', '236', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284790', '1599284790', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('319', 'Product name', '236', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284790', '1599284790', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('320', 'Product name', '239', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284800', '1599284800', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('321', 'Product name', '239', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284800', '1599284800', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('322', 'Product name', '239', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284800', '1599284800', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('323', 'Product name', '239', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '4', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284800', '1599284800', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('324', 'Product name', '244', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284809', '1599284827', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('325', 'Product name', '244', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284809', '1599284827', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('326', 'Product name', '244', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284809', '1599284809', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('327', 'Product name', '244', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284809', '1599284809', '0', '0');
INSERT INTO `rg_productmodel` VALUES ('328', 'Product name', '246', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '9', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284818', '1599284824', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('329', 'Product name', '246', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284818', '1599284824', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('330', 'Product name', '246', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284818', '1599284825', '0', '1');
INSERT INTO `rg_productmodel` VALUES ('331', 'Product name', '246', '', '', '管理员', '', '/upload/image/20200904/714c74ee60d2c9f5186d3efa51920a9b.jpg', '', '', '', 'Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!', '3', '<p>Product description, mainly related to the product introduction and some table parameters, can be combined with graphics and text, and the content can be added, modified and deleted in the background column content management. Products can customize fields, and support dynamic fields and product subsidiary table information. Greatly enhance the practicality and applicability of the system, you are welcome to use it!</p>', '0', '1', '0', '', '0', '0', '0', '4', '158', '1', '1', '1599284818', '1599284826', '0', '1');

-- -----------------------------
-- Table structure for `rg_region`
-- -----------------------------
DROP TABLE IF EXISTS `rg_region`;
CREATE TABLE `rg_region` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '0',
  `name` varchar(50) DEFAULT NULL,
  `initial` varchar(50) DEFAULT NULL,
  `pinyin` varchar(255) DEFAULT NULL,
  `citycode` varchar(10) DEFAULT NULL,
  `adcode` varchar(10) DEFAULT NULL,
  `lng_lat` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8E67E4DC81` (`initial`),
  KEY `IDX_618D25060D` (`name`),
  KEY `IDX_D0714290FC` (`pinyin`)
) ENGINE=MyISAM AUTO_INCREMENT=46228 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_region`
-- -----------------------------
INSERT INTO `rg_region` VALUES ('1', '0', '1', '广东省', 'gds', 'guangdongsheng', '', '440000', '113.280637,23.125178');
INSERT INTO `rg_region` VALUES ('2', '1', '2', '汕头市', 'sts', 'shantoushi', '0754', '440500', '116.708463,23.37102');
INSERT INTO `rg_region` VALUES ('3', '2', '3', '澄海区', 'chq', 'chenghaiqu', '0754', '440515', '116.76336,23.46844');
INSERT INTO `rg_region` VALUES ('15', '2', '3', '潮阳区', 'cyq', 'chaoyangqu', '0754', '440513', '116.602602,23.262336');
INSERT INTO `rg_region` VALUES ('29', '2', '3', '南澳县', 'nax', 'nanaoxian', '0754', '440523', '117.027105,23.419562');
INSERT INTO `rg_region` VALUES ('33', '2', '3', '濠江区', 'hjq', 'haojiangqu', '0754', '440512', '116.729528,23.279345');
INSERT INTO `rg_region` VALUES ('41', '2', '3', '潮南区', 'cnq', 'chaonanqu', '0754', '440514', '116.423607,23.249798');
INSERT INTO `rg_region` VALUES ('53', '2', '3', '金平区', 'jpq', 'jinpingqu', '0754', '440511', '116.703583,23.367071');
INSERT INTO `rg_region` VALUES ('71', '2', '3', '龙湖区', 'lhq', 'longhuqu', '0754', '440507', '116.732015,23.373754');
INSERT INTO `rg_region` VALUES ('79', '1', '2', '佛山市', 'fss', 'foshanshi', '0757', '440600', '113.122717,23.028762');
INSERT INTO `rg_region` VALUES ('80', '79', '3', '三水区', 'ssq', 'sanshuiqu', '0757', '440607', '112.899414,23.16504');
INSERT INTO `rg_region` VALUES ('93', '79', '3', '高明区', 'gmq', 'gaomingqu', '0757', '440608', '112.882123,22.893855');
INSERT INTO `rg_region` VALUES ('102', '79', '3', '顺德区', 'sdq', 'shundequ', '0757', '440606', '113.281826,22.75851');
INSERT INTO `rg_region` VALUES ('113', '79', '3', '禅城区', 'ccq', 'chanchengqu', '0757', '440604', '113.112414,23.019643');
INSERT INTO `rg_region` VALUES ('118', '79', '3', '南海区', 'nhq', 'nanhaiqu', '0757', '440605', '113.145577,23.031562');
INSERT INTO `rg_region` VALUES ('126', '1', '2', '肇庆市', 'zqs', 'zhaoqingshi', '0758', '441200', '112.472529,23.051546');
INSERT INTO `rg_region` VALUES ('127', '126', '3', '怀集县', 'hjx', 'huaijixian', '0758', '441224', '112.182466,23.913072');
INSERT INTO `rg_region` VALUES ('148', '126', '3', '广宁县', 'gnx', 'guangningxian', '0758', '441223', '112.440419,23.631486');
INSERT INTO `rg_region` VALUES ('164', '126', '3', '封开县', 'fkx', 'fengkaixian', '0758', '441225', '111.502973,23.434731');
INSERT INTO `rg_region` VALUES ('181', '126', '3', '四会市', 'shs', 'sihuishi', '0758', '441284', '112.695028,23.340324');
INSERT INTO `rg_region` VALUES ('197', '126', '3', '德庆县', 'dqx', 'deqingxian', '0758', '441226', '111.78156,23.141711');
INSERT INTO `rg_region` VALUES ('211', '126', '3', '鼎湖区', 'dhq', 'dinghuqu', '0758', '441203', '112.565249,23.155822');
INSERT INTO `rg_region` VALUES ('219', '126', '3', '端州区', 'dzq', 'duanzhouqu', '0758', '441202', '112.472329,23.052662');
INSERT INTO `rg_region` VALUES ('224', '126', '3', '高要区', 'gyq', 'gaoyaoqu', '0758', '441204', '112.460846,23.027694');
INSERT INTO `rg_region` VALUES ('242', '1', '2', '惠州市', 'hzs', 'huizhoushi', '0752', '441300', '114.412599,23.079404');
INSERT INTO `rg_region` VALUES ('243', '242', '3', '博罗县', 'blx', 'boluoxian', '0752', '441322', '114.284254,23.167575');
INSERT INTO `rg_region` VALUES ('262', '242', '3', '龙门县', 'lmx', 'longmenxian', '0752', '441324', '114.259986,23.723894');
INSERT INTO `rg_region` VALUES ('275', '242', '3', '惠东县', 'hdx', 'huidongxian', '0752', '441323', '114.723092,22.983036');
INSERT INTO `rg_region` VALUES ('297', '242', '3', '惠阳区', 'hyq', 'huiyangqu', '0752', '441303', '114.469444,22.78851');
INSERT INTO `rg_region` VALUES ('310', '242', '3', '惠城区', 'hcq', 'huichengqu', '0752', '441302', '114.413978,23.079883');
INSERT INTO `rg_region` VALUES ('330', '1', '2', '东沙群岛', 'dsqd', 'dongshaqundao', '0767', '442100', '116.887312,20.617512');
INSERT INTO `rg_region` VALUES ('331', '1', '2', '深圳市', 'szs', 'shenzhenshi', '0755', '440300', '114.085947,22.547');
INSERT INTO `rg_region` VALUES ('332', '331', '3', '宝安区', 'baq', 'baoanqu', '0755', '440306', '113.828671,22.754741');
INSERT INTO `rg_region` VALUES ('342', '331', '3', '南山区', 'nsq', 'nanshanqu', '0755', '440305', '113.92943,22.531221');
INSERT INTO `rg_region` VALUES ('351', '331', '3', '福田区', 'ftq', 'futianqu', '0755', '440304', '114.05096,22.541009');
INSERT INTO `rg_region` VALUES ('363', '331', '3', '盐田区', 'ytq', 'yantianqu', '0755', '440308', '114.235366,22.555069');
INSERT INTO `rg_region` VALUES ('369', '331', '3', '罗湖区', 'lhq', 'luohuqu', '0755', '440303', '114.123885,22.555341');
INSERT INTO `rg_region` VALUES ('380', '331', '3', '坪山区', 'psq', 'pingshanqu', '0755', '440310', '114.338441,22.69423');
INSERT INTO `rg_region` VALUES ('383', '331', '3', '龙华区', 'lhq', 'longhuaqu', '0755', '440309', '114.044346,22.691963');
INSERT INTO `rg_region` VALUES ('390', '331', '3', '龙岗区', 'lgq', 'longgangqu', '0755', '440307', '114.251372,22.721511');
INSERT INTO `rg_region` VALUES ('403', '331', '3', '光明区', 'gmq', 'guangmingqu', '0755', '440311', '113.935895,22.748816');
INSERT INTO `rg_region` VALUES ('410', '1', '2', '潮州市', 'czs', 'chaozhoushi', '0768', '445100', '116.632301,23.661701');
INSERT INTO `rg_region` VALUES ('411', '410', '3', '饶平县', 'rpx', 'raopingxian', '0768', '445122', '117.00205,23.668171');
INSERT INTO `rg_region` VALUES ('434', '410', '3', '湘桥区', 'xqq', 'xiangqiaoqu', '0768', '445102', '116.63365,23.664675');
INSERT INTO `rg_region` VALUES ('450', '410', '3', '潮安区', 'caq', 'chaoanqu', '0768', '445103', '116.67931,23.461012');
INSERT INTO `rg_region` VALUES ('471', '1', '2', '阳江市', 'yjs', 'yangjiangshi', '0662', '441700', '111.975107,21.859222');
INSERT INTO `rg_region` VALUES ('472', '471', '3', '阳春市', 'ycs', 'yangchunshi', '0662', '441781', '111.7905,22.169598');
INSERT INTO `rg_region` VALUES ('499', '471', '3', '阳西县', 'yxx', 'yangxixian', '0662', '441721', '111.617556,21.75367');
INSERT INTO `rg_region` VALUES ('510', '471', '3', '江城区', 'jcq', 'jiangchengqu', '0662', '441702', '111.968909,21.859182');
INSERT INTO `rg_region` VALUES ('527', '471', '3', '阳东区', 'ydq', 'yangdongqu', '0662', '441704', '112.011267,21.864728');
INSERT INTO `rg_region` VALUES ('547', '1', '2', '湛江市', 'zjs', 'zhanjiangshi', '0759', '440800', '110.364977,21.274898');
INSERT INTO `rg_region` VALUES ('548', '547', '3', '吴川市', 'wcs', 'wuchuanshi', '0759', '440883', '110.780508,21.428453');
INSERT INTO `rg_region` VALUES ('564', '547', '3', '廉江市', 'ljs', 'lianjiangshi', '0759', '440881', '110.284961,21.611281');
INSERT INTO `rg_region` VALUES ('587', '547', '3', '霞山区', 'xsq', 'xiashanqu', '0759', '440803', '110.406382,21.194229');
INSERT INTO `rg_region` VALUES ('600', '547', '3', '雷州市', 'lzs', 'leizhoushi', '0759', '440882', '110.088275,20.908523');
INSERT INTO `rg_region` VALUES ('628', '547', '3', '麻章区', 'mzq', 'mazhangqu', '0759', '440811', '110.329167,21.265997');
INSERT INTO `rg_region` VALUES ('637', '547', '3', '徐闻县', 'xwx', 'xuwenxian', '0759', '440825', '110.175718,20.326083');
INSERT INTO `rg_region` VALUES ('658', '547', '3', '坡头区', 'ptq', 'potouqu', '0759', '440804', '110.455632,21.24441');
INSERT INTO `rg_region` VALUES ('668', '547', '3', '赤坎区', 'ckq', 'chikanqu', '0759', '440802', '110.361634,21.273365');
INSERT INTO `rg_region` VALUES ('677', '547', '3', '遂溪县', 'sxx', 'suixixian', '0759', '440823', '110.255321,21.376915');
INSERT INTO `rg_region` VALUES ('694', '1', '2', '江门市', 'jms', 'jiangmenshi', '0750', '440700', '113.094942,22.590431');
INSERT INTO `rg_region` VALUES ('695', '694', '3', '鹤山市', 'hss', 'heshanshi', '0750', '440784', '112.961795,22.768104');
INSERT INTO `rg_region` VALUES ('708', '694', '3', '开平市', 'kps', 'kaipingshi', '0750', '440783', '112.692262,22.366286');
INSERT INTO `rg_region` VALUES ('725', '694', '3', '江海区', 'jhq', 'jianghaiqu', '0750', '440704', '113.120601,22.572211');
INSERT INTO `rg_region` VALUES ('729', '694', '3', '台山市', 'tss', 'taishanshi', '0750', '440781', '112.793414,22.250713');
INSERT INTO `rg_region` VALUES ('748', '694', '3', '恩平市', 'eps', 'enpingshi', '0750', '440785', '112.314051,22.182956');
INSERT INTO `rg_region` VALUES ('760', '694', '3', '蓬江区', 'pjq', 'pengjiangqu', '0750', '440703', '113.07859,22.59677');
INSERT INTO `rg_region` VALUES ('767', '694', '3', '新会区', 'xhq', 'xinhuiqu', '0750', '440705', '113.038584,22.520247');
INSERT INTO `rg_region` VALUES ('782', '1', '2', '珠海市', 'zhs', 'zhuhaishi', '0756', '440400', '113.553986,22.224979');
INSERT INTO `rg_region` VALUES ('783', '782', '3', '斗门区', 'dmq', 'doumenqu', '0756', '440403', '113.297739,22.209117');
INSERT INTO `rg_region` VALUES ('790', '782', '3', '金湾区', 'jwq', 'jinwanqu', '0756', '440404', '113.345071,22.139122');
INSERT INTO `rg_region` VALUES ('797', '782', '3', '香洲区', 'xzq', 'xiangzhouqu', '0756', '440402', '113.55027,22.271249');
INSERT INTO `rg_region` VALUES ('818', '1', '2', '汕尾市', 'sws', 'shanwoishi', '0660', '441500', '115.364238,22.774485');
INSERT INTO `rg_region` VALUES ('819', '818', '3', '陆河县', 'lhx', 'luhexian', '0660', '441523', '115.657565,23.302682');
INSERT INTO `rg_region` VALUES ('828', '818', '3', '海丰县', 'hfx', 'haifengxian', '0660', '441521', '115.337324,22.971042');
INSERT INTO `rg_region` VALUES ('846', '818', '3', '陆丰市', 'lfs', 'lufengshi', '0660', '441581', '115.644203,22.946104');
INSERT INTO `rg_region` VALUES ('876', '818', '3', '城区', 'cq', 'chengqu', '0660', '441502', '115.363667,22.776227');
INSERT INTO `rg_region` VALUES ('887', '1', '2', '茂名市', 'mms', 'maomingshi', '0668', '440900', '110.919229,21.659751');
INSERT INTO `rg_region` VALUES ('888', '887', '3', '信宜市', 'xys', 'xinyishi', '0668', '440983', '110.941656,22.352681');
INSERT INTO `rg_region` VALUES ('909', '887', '3', '电白区', 'dbq', 'dianbaiqu', '0668', '440904', '111.007264,21.507219');
INSERT INTO `rg_region` VALUES ('937', '887', '3', '高州市', 'gzs', 'gaozhoushi', '0668', '440981', '110.853251,21.915153');
INSERT INTO `rg_region` VALUES ('969', '887', '3', '化州市', 'hzs', 'huazhoushi', '0668', '440982', '110.63839,21.654953');
INSERT INTO `rg_region` VALUES ('1000', '887', '3', '茂南区', 'mnq', 'maonanqu', '0668', '440902', '110.920542,21.660425');
INSERT INTO `rg_region` VALUES ('1018', '1', '2', '梅州市', 'mzs', 'meizhoushi', '0753', '441400', '116.117582,24.299112');
INSERT INTO `rg_region` VALUES ('1019', '1018', '3', '蕉岭县', 'jlx', 'jiaolingxian', '0753', '441427', '116.170531,24.653313');
INSERT INTO `rg_region` VALUES ('1029', '1018', '3', '平远县', 'pyx', 'pingyuanxian', '0753', '441426', '115.891729,24.569651');
INSERT INTO `rg_region` VALUES ('1042', '1018', '3', '兴宁市', 'xns', 'xingningshi', '0753', '441481', '115.731648,24.138077');
INSERT INTO `rg_region` VALUES ('1063', '1018', '3', '五华县', 'whx', 'wuhuaxian', '0753', '441424', '115.775004,23.925424');
INSERT INTO `rg_region` VALUES ('1080', '1018', '3', '大埔县', 'dpx', 'dapuxian', '0753', '441422', '116.69552,24.351587');
INSERT INTO `rg_region` VALUES ('1098', '1018', '3', '梅县区', 'mxq', 'meixianqu', '0753', '441403', '116.083482,24.267825');
INSERT INTO `rg_region` VALUES ('1119', '1018', '3', '梅江区', 'mjq', 'meijiangqu', '0753', '441402', '116.12116,24.302593');
INSERT INTO `rg_region` VALUES ('1127', '1018', '3', '丰顺县', 'fsx', 'fengshunxian', '0753', '441423', '116.184419,23.752771');
INSERT INTO `rg_region` VALUES ('1145', '1', '2', '韶关市', 'sgs', 'shaoguanshi', '0751', '440200', '113.591544,24.801322');
INSERT INTO `rg_region` VALUES ('1146', '1145', '3', '南雄市', 'nxs', 'nanxiongshi', '0751', '440282', '114.311231,25.115328');
INSERT INTO `rg_region` VALUES ('1166', '1145', '3', '仁化县', 'rhx', 'renhuaxian', '0751', '440224', '113.748627,25.088226');
INSERT INTO `rg_region` VALUES ('1178', '1145', '3', '始兴县', 'sxx', 'shixingxian', '0751', '440222', '114.067205,24.948364');
INSERT INTO `rg_region` VALUES ('1189', '1145', '3', '乳源瑶族自治县', 'ryyzzzx', 'ruyuanyaozuzizhixian', '0751', '440232', '113.278417,24.776109');
INSERT INTO `rg_region` VALUES ('1201', '1145', '3', '浈江区', 'zjq', 'zhenjiangqu', '0751', '440204', '113.599224,24.803977');
INSERT INTO `rg_region` VALUES ('1213', '1145', '3', '武江区', 'wjq', 'wujiangqu', '0751', '440203', '113.588289,24.80016');
INSERT INTO `rg_region` VALUES ('1221', '1145', '3', '曲江区', 'qjq', 'qujiangqu', '0751', '440205', '113.605582,24.680195');
INSERT INTO `rg_region` VALUES ('1235', '1145', '3', '新丰县', 'xfx', 'xinfengxian', '0751', '440233', '114.207034,24.055412');
INSERT INTO `rg_region` VALUES ('1243', '1145', '3', '翁源县', 'wyx', 'wengyuanxian', '0751', '440229', '114.131289,24.353887');
INSERT INTO `rg_region` VALUES ('1252', '1145', '3', '乐昌市', 'lcs', 'lechangshi', '0751', '440281', '113.352413,25.128445');
INSERT INTO `rg_region` VALUES ('1272', '1', '2', '揭阳市', 'jys', 'jieyangshi', '0663', '445200', '116.355733,23.543778');
INSERT INTO `rg_region` VALUES ('1273', '1272', '3', '揭西县', 'jxx', 'jiexixian', '0663', '445222', '115.838708,23.4273');
INSERT INTO `rg_region` VALUES ('1297', '1272', '3', '普宁市', 'pns', 'puningshi', '0663', '445281', '116.165082,23.29788');
INSERT INTO `rg_region` VALUES ('1331', '1272', '3', '惠来县', 'hlx', 'huilaixian', '0663', '445224', '116.295832,23.029834');
INSERT INTO `rg_region` VALUES ('1352', '1272', '3', '榕城区', 'rcq', 'rongchengqu', '0663', '445202', '116.357045,23.535524');
INSERT INTO `rg_region` VALUES ('1367', '1272', '3', '揭东区', 'jdq', 'jiedongqu', '0663', '445203', '116.412947,23.569887');
INSERT INTO `rg_region` VALUES ('1387', '1', '2', '东莞市', 'dgs', 'dongguanshi', '0769', '441900', '113.746262,23.046237');
INSERT INTO `rg_region` VALUES ('1388', '1387', '3', '莞城街道', 'gcjd', 'guanchengjiedao', '0769', '441900', '113.743,23.0225');
INSERT INTO `rg_region` VALUES ('1389', '1387', '3', '常平镇', 'cpz', 'changpingzhen', '0769', '441900', '114.036,23.0074');
INSERT INTO `rg_region` VALUES ('1390', '1387', '3', '望牛墩镇', 'wndz', 'wangniudunzhen', '0769', '441900', '113.676,23.0683');
INSERT INTO `rg_region` VALUES ('1391', '1387', '3', '麻涌镇', 'myz', 'mayongzhen', '0769', '441900', '113.562,22.9718');
INSERT INTO `rg_region` VALUES ('1392', '1387', '3', '大朗镇', 'dlz', 'dalangzhen', '0769', '441900', '113.939,22.8654');
INSERT INTO `rg_region` VALUES ('1393', '1387', '3', '黄江镇', 'hjz', 'huangjiangzhen', '0769', '441900', '113.973,22.8121');
INSERT INTO `rg_region` VALUES ('1394', '1387', '3', '东莞生态园', 'dgsty', 'dongguanshengtaiyuan', '0769', '441900', '113.917,23.0806');
INSERT INTO `rg_region` VALUES ('1395', '1387', '3', '桥头镇', 'qtz', 'qiaotouzhen', '0769', '441900', '114.065,23.0315');
INSERT INTO `rg_region` VALUES ('1396', '1387', '3', '凤岗镇', 'fgz', 'fenggangzhen', '0769', '441900', '114.105,22.7308');
INSERT INTO `rg_region` VALUES ('1397', '1387', '3', '樟木头镇', 'zmtz', 'zhangmutouzhen', '0769', '441900', '114.018,22.8704');
INSERT INTO `rg_region` VALUES ('1398', '1387', '3', '松山湖管委会', 'sshgwh', 'songshanhuguanwoihui', '0769', '441900', '113.875,22.869');
INSERT INTO `rg_region` VALUES ('1399', '1387', '3', '石龙镇', 'slz', 'shilongzhen', '0769', '441900', '113.833,23.1123');
INSERT INTO `rg_region` VALUES ('1400', '1387', '3', '高埗镇', 'gbz', 'gaobuzhen', '0769', '441900', '113.773,23.112');
INSERT INTO `rg_region` VALUES ('1401', '1387', '3', '寮步镇', 'lbz', 'liaobuzhen', '0769', '441900', '113.888,22.9529');
INSERT INTO `rg_region` VALUES ('1402', '1387', '3', '塘厦镇', 'tsz', 'tangshazhen', '0769', '441900', '114.05,22.7713');
INSERT INTO `rg_region` VALUES ('1403', '1387', '3', '谢岗镇', 'xgz', 'xiegangzhen', '0769', '441900', '114.128,22.9901');
INSERT INTO `rg_region` VALUES ('1404', '1387', '3', '厚街镇', 'hjz', 'houjiezhen', '0769', '441900', '113.776,22.9097');
INSERT INTO `rg_region` VALUES ('1405', '1387', '3', '虎门镇', 'hmz', 'humenzhen', '0769', '441900', '113.797,22.8587');
INSERT INTO `rg_region` VALUES ('1406', '1387', '3', '南城街道', 'ncjd', 'nanchengjiedao', '0769', '441900', '113.737,23.0249');
INSERT INTO `rg_region` VALUES ('1407', '1387', '3', '虎门港管委会', 'hmggwh', 'humengangguanwoihui', '0769', '441900', '113.562,22.9718');
INSERT INTO `rg_region` VALUES ('1408', '1387', '3', '横沥镇', 'hlz', 'henglizhen', '0769', '441900', '114.006,23.0504');
INSERT INTO `rg_region` VALUES ('1409', '1387', '3', '东坑镇', 'dkz', 'dongkengzhen', '0769', '441900', '113.918,22.995');
INSERT INTO `rg_region` VALUES ('1410', '1387', '3', '企石镇', 'qsz', 'qishizhen', '0769', '441900', '113.99,23.0541');
INSERT INTO `rg_region` VALUES ('1411', '1387', '3', '东城街道', 'dcjd', 'dongchengjiedao', '0769', '441900', '113.757,23.0485');
INSERT INTO `rg_region` VALUES ('1412', '1387', '3', '石排镇', 'spz', 'shipaizhen', '0769', '441900', '113.988,23.068');
INSERT INTO `rg_region` VALUES ('1413', '1387', '3', '洪梅镇', 'hmz', 'hongmeizhen', '0769', '441900', '113.607,23.0155');
INSERT INTO `rg_region` VALUES ('1414', '1387', '3', '长安镇', 'caz', 'changanzhen', '0769', '441900', '113.77,22.8195');
INSERT INTO `rg_region` VALUES ('1415', '1387', '3', '沙田镇', 'stz', 'shatianzhen', '0769', '441900', '113.582,22.9426');
INSERT INTO `rg_region` VALUES ('1416', '1387', '3', '道滘镇', 'djz', 'daojiaozhen', '0769', '441900', '113.692,23.004');
INSERT INTO `rg_region` VALUES ('1417', '1387', '3', '大岭山镇', 'dlsz', 'dalingshanzhen', '0769', '441900', '113.843,22.9534');
INSERT INTO `rg_region` VALUES ('1418', '1387', '3', '茶山镇', 'csz', 'chashanzhen', '0769', '441900', '113.839,23.0813');
INSERT INTO `rg_region` VALUES ('1419', '1387', '3', '清溪镇', 'qxz', 'qingxizhen', '0769', '441900', '114.11,22.862');
INSERT INTO `rg_region` VALUES ('1420', '1387', '3', '万江街道', 'wjjd', 'wanjiangjiedao', '0769', '441900', '113.709,23.0014');
INSERT INTO `rg_region` VALUES ('1421', '1387', '3', '中堂镇', 'ztz', 'zhongtangzhen', '0769', '441900', '113.734,23.1164');
INSERT INTO `rg_region` VALUES ('1422', '1387', '3', '石碣镇', 'sjz', 'shijiezhen', '0769', '441900', '113.846,23.1024');
INSERT INTO `rg_region` VALUES ('1423', '1', '2', '河源市', 'hys', 'heyuanshi', '0762', '441600', '114.697802,23.746266');
INSERT INTO `rg_region` VALUES ('1424', '1423', '3', '龙川县', 'lcx', 'longchuanxian', '0762', '441622', '115.256415,24.101174');
INSERT INTO `rg_region` VALUES ('1449', '1423', '3', '东源县', 'dyx', 'dongyuanxian', '0762', '441625', '114.742711,23.789093');
INSERT INTO `rg_region` VALUES ('1471', '1423', '3', '连平县', 'lpx', 'lianpingxian', '0762', '441623', '114.495952,24.364227');
INSERT INTO `rg_region` VALUES ('1485', '1423', '3', '和平县', 'hpx', 'hepingxian', '0762', '441624', '114.941473,24.44318');
INSERT INTO `rg_region` VALUES ('1503', '1423', '3', '源城区', 'ycq', 'yuanchengqu', '0762', '441602', '114.696828,23.746255');
INSERT INTO `rg_region` VALUES ('1511', '1423', '3', '紫金县', 'zjx', 'zijinxian', '0762', '441621', '115.184383,23.633744');
INSERT INTO `rg_region` VALUES ('1530', '1', '2', '清远市', 'qys', 'qingyuanshi', '0763', '441800', '113.051227,23.685022');
INSERT INTO `rg_region` VALUES ('1531', '1530', '3', '连州市', 'lzs', 'lianzhoushi', '0763', '441882', '112.379271,24.783966');
INSERT INTO `rg_region` VALUES ('1544', '1530', '3', '连南瑶族自治县', 'lnyzzzx', 'liannanyaozuzizhixian', '0763', '441826', '112.290808,24.719097');
INSERT INTO `rg_region` VALUES ('1552', '1530', '3', '连山壮族瑶族自治县', 'lszzyzzzx', 'lianshanzhuangzuyaozuzizhixian', '0763', '441825', '112.086555,24.567271');
INSERT INTO `rg_region` VALUES ('1562', '1530', '3', '英德市', 'yds', 'yingdeshi', '0763', '441881', '113.405404,24.18612');
INSERT INTO `rg_region` VALUES ('1587', '1530', '3', '佛冈县', 'fgx', 'fogangxian', '0763', '441821', '113.534094,23.866739');
INSERT INTO `rg_region` VALUES ('1594', '1530', '3', '阳山县', 'ysx', 'yangshanxian', '0763', '441823', '112.634019,24.470286');
INSERT INTO `rg_region` VALUES ('1608', '1530', '3', '清新区', 'qxq', 'qingxinqu', '0763', '441803', '113.015203,23.736949');
INSERT INTO `rg_region` VALUES ('1618', '1530', '3', '清城区', 'qcq', 'qingchengqu', '0763', '441802', '113.048698,23.688976');
INSERT INTO `rg_region` VALUES ('1629', '1', '2', '云浮市', 'yfs', 'yunfushi', '0766', '445300', '112.044439,22.929801');
INSERT INTO `rg_region` VALUES ('1630', '1629', '3', '郁南县', 'ynx', 'yunanxian', '0766', '445322', '111.535921,23.237709');
INSERT INTO `rg_region` VALUES ('1650', '1629', '3', '罗定市', 'lds', 'luodingshi', '0766', '445381', '111.578201,22.765415');
INSERT INTO `rg_region` VALUES ('1673', '1629', '3', '新兴县', 'xxx', 'xinxingxian', '0766', '445321', '112.23083,22.703204');
INSERT INTO `rg_region` VALUES ('1689', '1629', '3', '云安区', 'yaq', 'yunanqu', '0766', '445303', '112.005609,23.073152');
INSERT INTO `rg_region` VALUES ('1698', '1629', '3', '云城区', 'ycq', 'yunchengqu', '0766', '445302', '112.04471,22.930827');
INSERT INTO `rg_region` VALUES ('1707', '1', '2', '广州市', 'gzs', 'guangzhoushi', '020', '440100', '113.280637,23.125178');
INSERT INTO `rg_region` VALUES ('1708', '1707', '3', '从化区', 'chq', 'conghuaqu', '020', '440117', '113.587386,23.545283');
INSERT INTO `rg_region` VALUES ('1720', '1707', '3', '增城区', 'zcq', 'zengchengqu', '020', '440118', '113.829579,23.290497');
INSERT INTO `rg_region` VALUES ('1732', '1707', '3', '南沙区', 'nsq', 'nanshaqu', '020', '440115', '113.53738,22.794531');
INSERT INTO `rg_region` VALUES ('1742', '1707', '3', '花都区', 'hdq', 'huaduqu', '020', '440114', '113.211184,23.39205');
INSERT INTO `rg_region` VALUES ('1753', '1707', '3', '黄埔区', 'hpq', 'huangpuqu', '020', '440112', '113.450761,23.103239');
INSERT INTO `rg_region` VALUES ('1769', '1707', '3', '海珠区', 'hzq', 'haizhuqu', '020', '440105', '113.262008,23.103131');
INSERT INTO `rg_region` VALUES ('1788', '1707', '3', '天河区', 'thq', 'tianhequ', '020', '440106', '113.335367,23.13559');
INSERT INTO `rg_region` VALUES ('1810', '1707', '3', '白云区', 'byq', 'baiyunqu', '020', '440111', '113.262831,23.162281');
INSERT INTO `rg_region` VALUES ('1832', '1707', '3', '越秀区', 'yxq', 'yuexiuqu', '020', '440104', '113.280714,23.125624');
INSERT INTO `rg_region` VALUES ('1851', '1707', '3', '番禺区', 'fyq', 'fanyuqu', '020', '440113', '113.364619,22.938582');
INSERT INTO `rg_region` VALUES ('1868', '1707', '3', '荔湾区', 'lwq', 'liwanqu', '020', '440103', '113.243038,23.124943');
INSERT INTO `rg_region` VALUES ('1891', '1', '2', '中山市', 'zss', 'zhongshanshi', '0760', '442000', '113.382391,22.521113');
INSERT INTO `rg_region` VALUES ('1892', '1891', '3', '横栏镇', 'hlz', 'henglanzhen', '0760', '442000', '113.224,22.6048');
INSERT INTO `rg_region` VALUES ('1893', '1891', '3', '三角镇', 'sjz', 'sanjiaozhen', '0760', '442000', '113.416,22.7079');
INSERT INTO `rg_region` VALUES ('1894', '1891', '3', '五桂山街道', 'wgsjd', 'wuguishanjiedao', '0760', '442000', '113.399,22.4847');
INSERT INTO `rg_region` VALUES ('1895', '1891', '3', '东升镇', 'dsz', 'dongshengzhen', '0760', '442000', '113.321,22.5607');
INSERT INTO `rg_region` VALUES ('1896', '1891', '3', '神湾镇', 'swz', 'shenwanzhen', '0760', '442000', '113.376,22.2768');
INSERT INTO `rg_region` VALUES ('1897', '1891', '3', '火炬开发区街道', 'hjkfqjd', 'huojukaifaqujiedao', '0760', '442000', '113.42,22.5577');
INSERT INTO `rg_region` VALUES ('1898', '1891', '3', '小榄镇', 'xlz', 'xiaolanzhen', '0760', '442000', '113.23,22.7026');
INSERT INTO `rg_region` VALUES ('1899', '1891', '3', '古镇镇', 'gzz', 'guzhenzhen', '0760', '442000', '113.167,22.6751');
INSERT INTO `rg_region` VALUES ('1900', '1891', '3', '南朗镇', 'nlz', 'nanlangzhen', '0760', '442000', '113.482,22.519');
INSERT INTO `rg_region` VALUES ('1901', '1891', '3', '民众镇', 'mzz', 'minzhongzhen', '0760', '442000', '113.499,22.6855');
INSERT INTO `rg_region` VALUES ('1902', '1891', '3', '港口镇', 'gkz', 'gangkouzhen', '0760', '442000', '113.354,22.6027');
INSERT INTO `rg_region` VALUES ('1903', '1891', '3', '三乡镇', 'sxz', 'sanxiangzhen', '0760', '442000', '113.432,22.3879');
INSERT INTO `rg_region` VALUES ('1904', '1891', '3', '石岐区街道', 'sqqjd', 'shiqiqujiedao', '0760', '442000', '113.405,22.5247');
INSERT INTO `rg_region` VALUES ('1905', '1891', '3', '大涌镇', 'dyz', 'dayongzhen', '0760', '442000', '113.297,22.4834');
INSERT INTO `rg_region` VALUES ('1906', '1891', '3', '南头镇', 'ntz', 'nantouzhen', '0760', '442000', '113.328,22.6882');
INSERT INTO `rg_region` VALUES ('1907', '1891', '3', '黄圃镇', 'hpz', 'huangpuzhen', '0760', '442000', '113.329,22.7457');
INSERT INTO `rg_region` VALUES ('1908', '1891', '3', '东区街道', 'dqjd', 'dongqujiedao', '0760', '442000', '113.4,22.5274');
INSERT INTO `rg_region` VALUES ('1909', '1891', '3', '阜沙镇', 'fsz', 'fushazhen', '0760', '442000', '113.34,22.6406');
INSERT INTO `rg_region` VALUES ('1910', '1891', '3', '坦洲镇', 'tzz', 'tanzhouzhen', '0760', '442000', '113.434,22.321');
INSERT INTO `rg_region` VALUES ('1911', '1891', '3', '西区街道', 'xqjd', 'xiqujiedao', '0760', '442000', '113.314,22.5649');
INSERT INTO `rg_region` VALUES ('1912', '1891', '3', '板芙镇', 'bfz', 'banfuzhen', '0760', '442000', '113.358,22.4068');
INSERT INTO `rg_region` VALUES ('1913', '1891', '3', '沙溪镇', 'sxz', 'shaxizhen', '0760', '442000', '113.344,22.5248');
INSERT INTO `rg_region` VALUES ('1914', '1891', '3', '南区街道', 'nqjd', 'nanqujiedao', '0760', '442000', '113.367,22.4892');
INSERT INTO `rg_region` VALUES ('1915', '1891', '3', '东凤镇', 'dfz', 'dongfengzhen', '0760', '442000', '113.308,22.6803');
INSERT INTO `rg_region` VALUES ('1916', '0', '1', '河南省', 'hns', 'henansheng', '', '410000', '113.665412,34.757975');
INSERT INTO `rg_region` VALUES ('1917', '1916', '2', '濮阳市', 'pys', 'puyangshi', '0393', '410900', '115.041299,35.768234');
INSERT INTO `rg_region` VALUES ('1918', '1917', '3', '南乐县', 'nlx', 'nanlexian', '0393', '410923', '115.204336,36.075204');
INSERT INTO `rg_region` VALUES ('1931', '1917', '3', '清丰县', 'qfx', 'qingfengxian', '0393', '410922', '115.107287,35.902413');
INSERT INTO `rg_region` VALUES ('1949', '1917', '3', '台前县', 'tqx', 'taiqianxian', '0393', '410927', '115.855681,35.996474');
INSERT INTO `rg_region` VALUES ('1959', '1917', '3', '范县', 'fx', 'fanxian', '0393', '410926', '115.504212,35.851977');
INSERT INTO `rg_region` VALUES ('1972', '1917', '3', '华龙区', 'hlq', 'hualongqu', '0393', '410902', '115.03184,35.760473');
INSERT INTO `rg_region` VALUES ('1992', '1917', '3', '濮阳县', 'pyx', 'puyangxian', '0393', '410928', '115.023844,35.710349');
INSERT INTO `rg_region` VALUES ('2013', '1916', '2', '三门峡市', 'smxs', 'sanmenxiashi', '0398', '411200', '111.194099,34.777338');
INSERT INTO `rg_region` VALUES ('2014', '2013', '3', '义马市', 'yms', 'yimashi', '0398', '411281', '111.869417,34.746868');
INSERT INTO `rg_region` VALUES ('2022', '2013', '3', '湖滨区', 'hbq', 'hubinqu', '0398', '411202', '111.19487,34.77812');
INSERT INTO `rg_region` VALUES ('2034', '2013', '3', '渑池县', 'mcx', 'mianchixian', '0398', '411221', '111.762992,34.763487');
INSERT INTO `rg_region` VALUES ('2047', '2013', '3', '卢氏县', 'lsx', 'lushixian', '0398', '411224', '111.052649,34.053995');
INSERT INTO `rg_region` VALUES ('2067', '2013', '3', '陕州区', 'szq', 'shanzhouqu', '0398', '411203', '111.103851,34.720244');
INSERT INTO `rg_region` VALUES ('2081', '2013', '3', '灵宝市', 'lbs', 'lingbaoshi', '0398', '411282', '110.88577,34.521264');
INSERT INTO `rg_region` VALUES ('2100', '1916', '2', '洛阳市', 'lys', 'luoyangshi', '0379', '410300', '112.434468,34.663041');
INSERT INTO `rg_region` VALUES ('2101', '2100', '3', '新安县', 'xax', 'xinanxian', '0379', '410323', '112.141403,34.728679');
INSERT INTO `rg_region` VALUES ('2114', '2100', '3', '栾川县', 'lcx', 'luanchuanxian', '0379', '410324', '111.618386,33.783195');
INSERT INTO `rg_region` VALUES ('2129', '2100', '3', '涧西区', 'jxq', 'jianxiqu', '0379', '410305', '112.399243,34.654251');
INSERT INTO `rg_region` VALUES ('2144', '2100', '3', '伊川县', 'ycx', 'yichuanxian', '0379', '410329', '112.429384,34.423416');
INSERT INTO `rg_region` VALUES ('2159', '2100', '3', '汝阳县', 'ryx', 'ruyangxian', '0379', '410326', '112.473789,34.15323');
INSERT INTO `rg_region` VALUES ('2174', '2100', '3', '吉利区', 'jlq', 'jiliqu', '0379', '410306', '112.584796,34.899093');
INSERT INTO `rg_region` VALUES ('2179', '2100', '3', '宜阳县', 'yyx', 'yiyangxian', '0379', '410327', '112.179989,34.516478');
INSERT INTO `rg_region` VALUES ('2196', '2100', '3', '洛宁县', 'lnx', 'luoningxian', '0379', '410328', '111.655399,34.387179');
INSERT INTO `rg_region` VALUES ('2215', '2100', '3', '偃师市', 'yss', 'yanshishi', '0379', '410381', '112.787739,34.723042');
INSERT INTO `rg_region` VALUES ('2229', '2100', '3', '瀍河回族区', 'chhzq', 'chanhehuizuqu', '0379', '410304', '112.491625,34.684738');
INSERT INTO `rg_region` VALUES ('2238', '2100', '3', '西工区', 'xgq', 'xigongqu', '0379', '410303', '112.443232,34.667847');
INSERT INTO `rg_region` VALUES ('2248', '2100', '3', '老城区', 'lcq', 'laochengqu', '0379', '410302', '112.477298,34.682945');
INSERT INTO `rg_region` VALUES ('2258', '2100', '3', '洛龙区', 'llq', 'luolongqu', '0379', '410311', '112.456634,34.618557');
INSERT INTO `rg_region` VALUES ('2276', '2100', '3', '孟津县', 'mjx', 'mengjinxian', '0379', '410322', '112.443892,34.826485');
INSERT INTO `rg_region` VALUES ('2287', '2100', '3', '嵩县', 'sx', 'songxian', '0379', '410325', '112.087765,34.131563');
INSERT INTO `rg_region` VALUES ('2307', '1916', '2', '漯河市', 'lhs', 'luoheshi', '0395', '411100', '114.026405,33.575855');
INSERT INTO `rg_region` VALUES ('2308', '2307', '3', '临颍县', 'lyx', 'linyingxian', '0395', '411122', '113.938891,33.80609');
INSERT INTO `rg_region` VALUES ('2324', '2307', '3', '源汇区', 'yhq', 'yuanhuiqu', '0395', '411102', '114.017948,33.565441');
INSERT INTO `rg_region` VALUES ('2333', '2307', '3', '舞阳县', 'wyx', 'wuyangxian', '0395', '411121', '113.610565,33.436278');
INSERT INTO `rg_region` VALUES ('2348', '2307', '3', '召陵区', 'zlq', 'zhaolingqu', '0395', '411104', '114.051686,33.567555');
INSERT INTO `rg_region` VALUES ('2358', '2307', '3', '郾城区', 'ycq', 'yanchengqu', '0395', '411103', '114.016813,33.588897');
INSERT INTO `rg_region` VALUES ('2368', '1916', '2', '许昌市', 'xcs', 'xuchangshi', '0374', '411000', '113.826063,34.022956');
INSERT INTO `rg_region` VALUES ('2369', '2368', '3', '建安区', 'jaq', 'jiananqu', '0374', '411003', '113.842898,34.005018');
INSERT INTO `rg_region` VALUES ('2386', '2368', '3', '襄城县', 'xcx', 'xiangchengxian', '0374', '411025', '113.493166,33.855943');
INSERT INTO `rg_region` VALUES ('2403', '2368', '3', '魏都区', 'wdq', 'weiduqu', '0374', '411002', '113.828307,34.02711');
INSERT INTO `rg_region` VALUES ('2417', '2368', '3', '长葛市', 'cgs', 'changgeshi', '0374', '411082', '113.768912,34.219257');
INSERT INTO `rg_region` VALUES ('2434', '2368', '3', '禹州市', 'yzs', 'yuzhoushi', '0374', '411081', '113.471316,34.154403');
INSERT INTO `rg_region` VALUES ('2461', '2368', '3', '鄢陵县', 'ylx', 'yanlingxian', '0374', '411024', '114.188507,34.100502');
INSERT INTO `rg_region` VALUES ('2474', '1916', '2', '南阳市', 'nys', 'nanyangshi', '0377', '411300', '112.540918,32.999082');
INSERT INTO `rg_region` VALUES ('2475', '2474', '3', '西峡县', 'xxx', 'xixiaxian', '0377', '411323', '111.485772,33.302981');
INSERT INTO `rg_region` VALUES ('2495', '2474', '3', '卧龙区', 'wlq', 'wolongqu', '0377', '411303', '112.528789,32.989877');
INSERT INTO `rg_region` VALUES ('2517', '2474', '3', '南召县', 'nzx', 'nanzhaoxian', '0377', '411321', '112.435583,33.488617');
INSERT INTO `rg_region` VALUES ('2539', '2474', '3', '社旗县', 'sqx', 'sheqixian', '0377', '411327', '112.938279,33.056126');
INSERT INTO `rg_region` VALUES ('2556', '2474', '3', '桐柏县', 'tbx', 'tongbaixian', '0377', '411330', '113.406059,32.367153');
INSERT INTO `rg_region` VALUES ('2573', '2474', '3', '唐河县', 'thx', 'tanghexian', '0377', '411328', '112.838492,32.687892');
INSERT INTO `rg_region` VALUES ('2596', '2474', '3', '淅川县', 'xcx', 'xichuanxian', '0377', '411326', '111.489026,33.136106');
INSERT INTO `rg_region` VALUES ('2614', '2474', '3', '内乡县', 'nxx', 'neixiangxian', '0377', '411325', '111.843801,33.046358');
INSERT INTO `rg_region` VALUES ('2631', '2474', '3', '宛城区', 'wcq', 'wanchengqu', '0377', '411302', '112.544591,32.994857');
INSERT INTO `rg_region` VALUES ('2650', '2474', '3', '镇平县', 'zpx', 'zhenpingxian', '0377', '411324', '112.232722,33.036651');
INSERT INTO `rg_region` VALUES ('2673', '2474', '3', '新野县', 'xyx', 'xinyoxian', '0377', '411329', '112.365624,32.524006');
INSERT INTO `rg_region` VALUES ('2689', '2474', '3', '方城县', 'fcx', 'fangchengxian', '0377', '411322', '113.010933,33.255138');
INSERT INTO `rg_region` VALUES ('2709', '2474', '3', '邓州市', 'dzs', 'dengzhoushi', '0377', '411381', '112.092716,32.681642');
INSERT INTO `rg_region` VALUES ('2739', '1916', '2', '信阳市', 'xys', 'xinyangshi', '0376', '411500', '114.075031,32.123274');
INSERT INTO `rg_region` VALUES ('2740', '2739', '3', '潢川县', 'hcx', 'huangchuanxian', '0376', '411526', '115.050123,32.134024');
INSERT INTO `rg_region` VALUES ('2764', '2739', '3', '罗山县', 'lsx', 'luoshanxian', '0376', '411521', '114.533414,32.203206');
INSERT INTO `rg_region` VALUES ('2785', '2739', '3', '光山县', 'gsx', 'guangshanxian', '0376', '411522', '114.903577,32.010398');
INSERT INTO `rg_region` VALUES ('2805', '2739', '3', '淮滨县', 'hbx', 'huaibinxian', '0376', '411527', '115.415451,32.452639');
INSERT INTO `rg_region` VALUES ('2825', '2739', '3', '浉河区', 'shq', 'shihequ', '0376', '411502', '114.075031,32.123274');
INSERT INTO `rg_region` VALUES ('2844', '2739', '3', '固始县', 'gsx', 'gushixian', '0376', '411525', '115.667328,32.183074');
INSERT INTO `rg_region` VALUES ('2878', '2739', '3', '商城县', 'scx', 'shangchengxian', '0376', '411524', '115.406297,31.799982');
INSERT INTO `rg_region` VALUES ('2899', '2739', '3', '新县', 'xx', 'xinxian', '0376', '411523', '114.87705,31.63515');
INSERT INTO `rg_region` VALUES ('2915', '2739', '3', '息县', 'xx', 'xixian', '0376', '411528', '114.740713,32.344744');
INSERT INTO `rg_region` VALUES ('2938', '2739', '3', '平桥区', 'pqq', 'pingqiaoqu', '0376', '411503', '114.126027,32.098395');
INSERT INTO `rg_region` VALUES ('2970', '1916', '2', '济源市', 'jys', 'jiyuanshi', '1391', '419001', '112.590047,35.090378');
INSERT INTO `rg_region` VALUES ('2971', '2970', '3', '济源市坡头镇', 'jysptz', 'jiyuanshipotouzhen', '1391', '419001', '112.538,34.9308');
INSERT INTO `rg_region` VALUES ('2972', '2970', '3', '济源市梨林镇', 'jysllz', 'jiyuanshililinzhen', '1391', '419001', '112.753,35.0882');
INSERT INTO `rg_region` VALUES ('2973', '2970', '3', '济源市大峪镇', 'jysdyz', 'jiyuanshidayuzhen', '1391', '419001', '112.338,34.9398');
INSERT INTO `rg_region` VALUES ('2974', '2970', '3', '济源市思礼镇', 'jysslz', 'jiyuanshisilizhen', '1391', '419001', '112.388,35.2103');
INSERT INTO `rg_region` VALUES ('2975', '2970', '3', '济源市五龙口镇', 'jyswlkz', 'jiyuanshiwulongkouzhen', '1391', '419001', '112.761,35.1956');
INSERT INTO `rg_region` VALUES ('2976', '2970', '3', '济源市王屋镇', 'jyswwz', 'jiyuanshiwangwuzhen', '1391', '419001', '112.169,35.1244');
INSERT INTO `rg_region` VALUES ('2977', '2970', '3', '济源市玉泉街道', 'jysyqjd', 'jiyuanshiyuquanjiedao', '1391', '419001', '112.624,35.1189');
INSERT INTO `rg_region` VALUES ('2978', '2970', '3', '济源市轵城镇', 'jyszcz', 'jiyuanshizhichengzhen', '1391', '419001', '112.622,35.0625');
INSERT INTO `rg_region` VALUES ('2979', '2970', '3', '济源市济水街道', 'jysjsjd', 'jiyuanshijishuijiedao', '1391', '419001', '112.595,35.0944');
INSERT INTO `rg_region` VALUES ('2980', '2970', '3', '济源市沁园街道', 'jysqyjd', 'jiyuanshiqinyuanjiedao', '1391', '419001', '112.593,35.0822');
INSERT INTO `rg_region` VALUES ('2981', '2970', '3', '济源市下冶镇', 'jysxyz', 'jiyuanshixiayozhen', '1391', '419001', '112.212,35.1131');
INSERT INTO `rg_region` VALUES ('2982', '2970', '3', '济源市克井镇', 'jyskjz', 'jiyuanshikejingzhen', '1391', '419001', '112.635,35.255');
INSERT INTO `rg_region` VALUES ('2983', '2970', '3', '济源市天坛街道', 'jysttjd', 'jiyuanshitiantanjiedao', '1391', '419001', '112.567,35.1229');
INSERT INTO `rg_region` VALUES ('2984', '2970', '3', '济源市邵原镇', 'jyssyz', 'jiyuanshishaoyuanzhen', '1391', '419001', '112.113,35.2704');
INSERT INTO `rg_region` VALUES ('2985', '2970', '3', '济源市北海街道', 'jysbhjd', 'jiyuanshibeihaijiedao', '1391', '419001', '112.569,35.1116');
INSERT INTO `rg_region` VALUES ('2986', '2970', '3', '济源市承留镇', 'jysclz', 'jiyuanshichengliuzhen', '1391', '419001', '112.509,35.0243');
INSERT INTO `rg_region` VALUES ('2987', '1916', '2', '安阳市', 'ays', 'anyangshi', '0372', '410500', '114.352482,36.103442');
INSERT INTO `rg_region` VALUES ('2988', '2987', '3', '汤阴县', 'tyx', 'tangyinxian', '0372', '410523', '114.362357,35.922349');
INSERT INTO `rg_region` VALUES ('2999', '2987', '3', '内黄县', 'nhx', 'neihuangxian', '0372', '410527', '114.904582,35.953702');
INSERT INTO `rg_region` VALUES ('3017', '2987', '3', '殷都区', 'ydq', 'yinduqu', '0372', '410505', '114.300098,36.108974');
INSERT INTO `rg_region` VALUES ('3026', '2987', '3', '滑县', 'hx', 'huaxian', '0372', '410526', '114.524,35.574628');
INSERT INTO `rg_region` VALUES ('3050', '2987', '3', '文峰区', 'wfq', 'wenfengqu', '0372', '410502', '114.352562,36.098101');
INSERT INTO `rg_region` VALUES ('3070', '2987', '3', '北关区', 'bgq', 'beiguanqu', '0372', '410503', '114.352646,36.10978');
INSERT INTO `rg_region` VALUES ('3080', '2987', '3', '林州市', 'lzs', 'linzhoushi', '0372', '410581', '113.823767,36.063403');
INSERT INTO `rg_region` VALUES ('3101', '2987', '3', '安阳县', 'ayx', 'anyangxian', '0372', '410522', '114.130207,36.130585');
INSERT INTO `rg_region` VALUES ('3123', '2987', '3', '龙安区', 'laq', 'longanqu', '0372', '410506', '114.323522,36.095568');
INSERT INTO `rg_region` VALUES ('3133', '1916', '2', '驻马店市', 'zmds', 'zhumadianshi', '0396', '411700', '114.024736,32.980169');
INSERT INTO `rg_region` VALUES ('3134', '3133', '3', '西平县', 'xpx', 'xipingxian', '0396', '411721', '114.026864,33.382315');
INSERT INTO `rg_region` VALUES ('3156', '3133', '3', '上蔡县', 'scx', 'shangcaixian', '0396', '411722', '114.266892,33.264719');
INSERT INTO `rg_region` VALUES ('3183', '3133', '3', '新蔡县', 'xcx', 'xincaixian', '0396', '411729', '114.975246,32.749948');
INSERT INTO `rg_region` VALUES ('3207', '3133', '3', '平舆县', 'pyx', 'pingyuxian', '0396', '411723', '114.637105,32.955626');
INSERT INTO `rg_region` VALUES ('3227', '3133', '3', '汝南县', 'rnx', 'runanxian', '0396', '411727', '114.359495,33.004535');
INSERT INTO `rg_region` VALUES ('3245', '3133', '3', '遂平县', 'spx', 'suipingxian', '0396', '411728', '114.00371,33.14698');
INSERT INTO `rg_region` VALUES ('3262', '3133', '3', '泌阳县', 'myx', 'miyangxian', '0396', '411726', '113.32605,32.725129');
INSERT INTO `rg_region` VALUES ('3285', '3133', '3', '确山县', 'qsx', 'queshanxian', '0396', '411725', '114.026679,32.801538');
INSERT INTO `rg_region` VALUES ('3298', '3133', '3', '驿城区', 'ycq', 'yichengqu', '0396', '411702', '114.029149,32.977559');
INSERT INTO `rg_region` VALUES ('3324', '3133', '3', '正阳县', 'zyx', 'zhengyangxian', '0396', '411724', '114.38948,32.601826');
INSERT INTO `rg_region` VALUES ('3344', '1916', '2', '焦作市', 'jzs', 'jiaozuoshi', '0391', '410800', '113.238266,35.23904');
INSERT INTO `rg_region` VALUES ('3345', '3344', '3', '马村区', 'mcq', 'macunqu', '0391', '410804', '113.321703,35.265453');
INSERT INTO `rg_region` VALUES ('3353', '3344', '3', '孟州市', 'mzs', 'mengzhoushi', '0391', '410883', '112.78708,34.90963');
INSERT INTO `rg_region` VALUES ('3365', '3344', '3', '温县', 'wx', 'wenxian', '0391', '410825', '113.079118,34.941233');
INSERT INTO `rg_region` VALUES ('3378', '3344', '3', '解放区', 'jfq', 'jiofangqu', '0391', '410802', '113.226126,35.241353');
INSERT INTO `rg_region` VALUES ('3388', '3344', '3', '沁阳市', 'qys', 'qinyangshi', '0391', '410882', '112.934538,35.08901');
INSERT INTO `rg_region` VALUES ('3402', '3344', '3', '武陟县', 'wzx', 'wuzhixian', '0391', '410823', '113.408334,35.09885');
INSERT INTO `rg_region` VALUES ('3419', '3344', '3', '博爱县', 'bax', 'boaixian', '0391', '410822', '113.069313,35.170351');
INSERT INTO `rg_region` VALUES ('3429', '3344', '3', '山阳区', 'syq', 'shanyangqu', '0391', '410811', '113.26766,35.21476');
INSERT INTO `rg_region` VALUES ('3445', '3344', '3', '中站区', 'zzq', 'zhongzhanqu', '0391', '410803', '113.175485,35.236145');
INSERT INTO `rg_region` VALUES ('3454', '3344', '3', '修武县', 'xwx', 'xiuwuxian', '0391', '410821', '113.447465,35.229923');
INSERT INTO `rg_region` VALUES ('3464', '1916', '2', '鹤壁市', 'hbs', 'hebishi', '0392', '410600', '114.295444,35.748236');
INSERT INTO `rg_region` VALUES ('3465', '3464', '3', '鹤山区', 'hsq', 'heshanqu', '0392', '410602', '114.166551,35.936128');
INSERT INTO `rg_region` VALUES ('3473', '3464', '3', '淇县', 'qx', 'qixian', '0392', '410622', '114.200379,35.609478');
INSERT INTO `rg_region` VALUES ('3483', '3464', '3', '山城区', 'scq', 'shanchengqu', '0392', '410603', '114.184202,35.896058');
INSERT INTO `rg_region` VALUES ('3492', '3464', '3', '浚县', 'jx', 'junxian', '0392', '410621', '114.550162,35.671282');
INSERT INTO `rg_region` VALUES ('3504', '3464', '3', '淇滨区', 'qbq', 'qibinqu', '0392', '410611', '114.293917,35.748382');
INSERT INTO `rg_region` VALUES ('3516', '1916', '2', '新乡市', 'xxs', 'xinxiangshi', '0373', '410700', '113.883991,35.302616');
INSERT INTO `rg_region` VALUES ('3517', '3516', '3', '获嘉县', 'hjx', 'huojiaxian', '0373', '410724', '113.657249,35.261685');
INSERT INTO `rg_region` VALUES ('3530', '3516', '3', '辉县市', 'hxs', 'huixianshi', '0373', '410782', '113.802518,35.461318');
INSERT INTO `rg_region` VALUES ('3553', '3516', '3', '凤泉区', 'fqq', 'fengquanqu', '0373', '410704', '113.906712,35.379855');
INSERT INTO `rg_region` VALUES ('3559', '3516', '3', '封丘县', 'fqx', 'fengqiuxian', '0373', '410727', '114.423405,35.04057');
INSERT INTO `rg_region` VALUES ('3579', '3516', '3', '延津县', 'yjx', 'yanjinxian', '0373', '410726', '114.200982,35.149515');
INSERT INTO `rg_region` VALUES ('3592', '3516', '3', '长垣县', 'cyx', 'changyuanxian', '0373', '410728', '114.673807,35.19615');
INSERT INTO `rg_region` VALUES ('3611', '3516', '3', '原阳县', 'yyx', 'yuanyangxian', '0373', '410725', '113.965966,35.054001');
INSERT INTO `rg_region` VALUES ('3630', '3516', '3', '卫辉市', 'whs', 'weihuishi', '0373', '410781', '114.065855,35.404295');
INSERT INTO `rg_region` VALUES ('3649', '3516', '3', '牧野区', 'myq', 'muyoqu', '0373', '410711', '113.89716,35.312974');
INSERT INTO `rg_region` VALUES ('3660', '3516', '3', '新乡县', 'xxx', 'xinxiangxian', '0373', '410721', '113.806186,35.190021');
INSERT INTO `rg_region` VALUES ('3669', '3516', '3', '红旗区', 'hqq', 'hongqiqu', '0373', '410702', '113.878158,35.302684');
INSERT INTO `rg_region` VALUES ('3680', '3516', '3', '卫滨区', 'wbq', 'weibinqu', '0373', '410703', '113.866065,35.304905');
INSERT INTO `rg_region` VALUES ('3689', '1916', '2', '开封市', 'kfs', 'kaifengshi', '0378', '410200', '114.341447,34.797049');
INSERT INTO `rg_region` VALUES ('3690', '3689', '3', '兰考县', 'lkx', 'lankaoxian', '0378', '410225', '114.820572,34.829899');
INSERT INTO `rg_region` VALUES ('3707', '3689', '3', '祥符区', 'xfq', 'xiangfuqu', '0378', '410212', '114.437622,34.756476');
INSERT INTO `rg_region` VALUES ('3723', '3689', '3', '禹王台区', 'ywtq', 'yuwangtaiqu', '0378', '410205', '114.350246,34.779727');
INSERT INTO `rg_region` VALUES ('3731', '3689', '3', '顺河回族区', 'shhzq', 'shunhehuizuqu', '0378', '410203', '114.364875,34.800459');
INSERT INTO `rg_region` VALUES ('3740', '3689', '3', '通许县', 'txx', 'tongxuxian', '0378', '410222', '114.467734,34.477302');
INSERT INTO `rg_region` VALUES ('3753', '3689', '3', '尉氏县', 'wsx', 'weishixian', '0378', '410223', '114.193927,34.412256');
INSERT INTO `rg_region` VALUES ('3771', '3689', '3', '鼓楼区', 'glq', 'gulouqu', '0378', '410204', '114.3485,34.792383');
INSERT INTO `rg_region` VALUES ('3780', '3689', '3', '龙亭区', 'ltq', 'longtingqu', '0378', '410202', '114.353348,34.799833');
INSERT INTO `rg_region` VALUES ('3794', '3689', '3', '杞县', 'qx', 'qixian', '0378', '410221', '114.770472,34.554585');
INSERT INTO `rg_region` VALUES ('3816', '1916', '2', '平顶山市', 'pdss', 'pingdingshanshi', '0375', '410400', '113.307718,33.735241');
INSERT INTO `rg_region` VALUES ('3817', '3816', '3', '郏县', 'jx', 'jiaxian', '0375', '410425', '113.220451,33.971993');
INSERT INTO `rg_region` VALUES ('3833', '3816', '3', '石龙区', 'slq', 'shilongqu', '0375', '410404', '112.889885,33.901538');
INSERT INTO `rg_region` VALUES ('3838', '3816', '3', '湛河区', 'zhq', 'zhanhequ', '0375', '410411', '113.320873,33.725681');
INSERT INTO `rg_region` VALUES ('3847', '3816', '3', '卫东区', 'wdq', 'weidongqu', '0375', '410403', '113.310327,33.739285');
INSERT INTO `rg_region` VALUES ('3860', '3816', '3', '鲁山县', 'lsx', 'lushanxian', '0375', '410423', '112.906703,33.740325');
INSERT INTO `rg_region` VALUES ('3885', '3816', '3', '叶县', 'yx', 'yexian', '0375', '410422', '113.358298,33.621252');
INSERT INTO `rg_region` VALUES ('3904', '3816', '3', '舞钢市', 'wgs', 'wugangshi', '0375', '410481', '113.52625,33.302082');
INSERT INTO `rg_region` VALUES ('3918', '3816', '3', '新华区', 'xhq', 'xinhuaqu', '0375', '410402', '113.299061,33.737579');
INSERT INTO `rg_region` VALUES ('3934', '3816', '3', '汝州市', 'rzs', 'ruzhoushi', '0375', '410482', '112.845336,34.167408');
INSERT INTO `rg_region` VALUES ('3955', '3816', '3', '宝丰县', 'bfx', 'baofengxian', '0375', '410421', '113.066812,33.866359');
INSERT INTO `rg_region` VALUES ('3969', '1916', '2', '郑州市', 'zzs', 'zhengzhoushi', '0371', '410100', '113.665412,34.757975');
INSERT INTO `rg_region` VALUES ('3970', '3969', '3', '巩义市', 'gys', 'gongyishi', '0371', '410181', '112.98283,34.75218');
INSERT INTO `rg_region` VALUES ('3991', '3969', '3', '登封市', 'dfs', 'dengfengshi', '0371', '410185', '113.037768,34.459939');
INSERT INTO `rg_region` VALUES ('4009', '3969', '3', '上街区', 'sjq', 'shangjiequ', '0371', '410106', '113.298282,34.808689');
INSERT INTO `rg_region` VALUES ('4015', '3969', '3', '金水区', 'jsq', 'jinshuiqu', '0371', '410105', '113.686037,34.775838');
INSERT INTO `rg_region` VALUES ('4040', '3969', '3', '惠济区', 'hjq', 'huijiqu', '0371', '410108', '113.61836,34.828591');
INSERT INTO `rg_region` VALUES ('4049', '3969', '3', '荥阳市', 'xys', 'xingyangshi', '0371', '410182', '113.391523,34.789077');
INSERT INTO `rg_region` VALUES ('4064', '3969', '3', '中原区', 'zyq', 'zhongyuanqu', '0371', '410102', '113.611576,34.748286');
INSERT INTO `rg_region` VALUES ('4082', '3969', '3', '二七区', 'eqq', 'erqiqu', '0371', '410103', '113.645422,34.730936');
INSERT INTO `rg_region` VALUES ('4098', '3969', '3', '新密市', 'xms', 'xinmishi', '0371', '410183', '113.380616,34.537846');
INSERT INTO `rg_region` VALUES ('4118', '3969', '3', '管城回族区', 'gchzq', 'guanchenghuizuqu', '0371', '410104', '113.685313,34.746453');
INSERT INTO `rg_region` VALUES ('4135', '3969', '3', '中牟县', 'zmx', 'zhongmouxian', '0371', '410122', '114.022521,34.721976');
INSERT INTO `rg_region` VALUES ('4160', '3969', '3', '新郑市', 'xzs', 'xinzhengshi', '0371', '410184', '113.73967,34.394219');
INSERT INTO `rg_region` VALUES ('4181', '1916', '2', '周口市', 'zks', 'zhoukoushi', '0394', '411600', '114.649653,33.620357');
INSERT INTO `rg_region` VALUES ('4182', '4181', '3', '鹿邑县', 'lyx', 'luyixian', '0394', '411628', '115.486386,33.861067');
INSERT INTO `rg_region` VALUES ('4207', '4181', '3', '沈丘县', 'sqx', 'shonqiuxian', '0394', '411624', '115.078375,33.395514');
INSERT INTO `rg_region` VALUES ('4230', '4181', '3', '郸城县', 'dcx', 'danchengxian', '0394', '411625', '115.189,33.643852');
INSERT INTO `rg_region` VALUES ('4253', '4181', '3', '扶沟县', 'fgx', 'fugouxian', '0394', '411621', '114.392008,34.054061');
INSERT INTO `rg_region` VALUES ('4271', '4181', '3', '淮阳县', 'hyx', 'huaiyangxian', '0394', '411626', '114.870166,33.732547');
INSERT INTO `rg_region` VALUES ('4290', '4181', '3', '项城市', 'xcs', 'xiangchengshi', '0394', '411681', '114.899521,33.443085');
INSERT INTO `rg_region` VALUES ('4312', '4181', '3', '太康县', 'tkx', 'taikangxian', '0394', '411627', '114.853834,34.065312');
INSERT INTO `rg_region` VALUES ('4336', '4181', '3', '西华县', 'xhx', 'xihuaxian', '0394', '411622', '114.530067,33.784378');
INSERT INTO `rg_region` VALUES ('4360', '4181', '3', '商水县', 'ssx', 'shangshuixian', '0394', '411623', '114.60927,33.543845');
INSERT INTO `rg_region` VALUES ('4385', '4181', '3', '川汇区', 'chq', 'chuanhuiqu', '0394', '411602', '114.652136,33.614836');
INSERT INTO `rg_region` VALUES ('4400', '1916', '2', '商丘市', 'sqs', 'shangqiushi', '0370', '411400', '115.650497,34.437054');
INSERT INTO `rg_region` VALUES ('4401', '4400', '3', '宁陵县', 'nlx', 'ninglingxian', '0370', '411423', '115.320055,34.449299');
INSERT INTO `rg_region` VALUES ('4417', '4400', '3', '柘城县', 'zcx', 'zhechengxian', '0370', '411424', '115.307433,34.075277');
INSERT INTO `rg_region` VALUES ('4440', '4400', '3', '梁园区', 'lyq', 'liangyuanqu', '0370', '411402', '115.65459,34.436553');
INSERT INTO `rg_region` VALUES ('4461', '4400', '3', '睢阳区', 'syq', 'suiyangqu', '0370', '411403', '115.653813,34.390536');
INSERT INTO `rg_region` VALUES ('4481', '4400', '3', '夏邑县', 'xyx', 'xiayixian', '0370', '411426', '116.13989,34.240894');
INSERT INTO `rg_region` VALUES ('4506', '4400', '3', '永城市', 'ycs', 'yongchengshi', '0370', '411481', '116.449672,33.931318');
INSERT INTO `rg_region` VALUES ('4536', '4400', '3', '虞城县', 'ycx', 'yuchengxian', '0370', '411425', '115.863811,34.399634');
INSERT INTO `rg_region` VALUES ('4563', '4400', '3', '民权县', 'mqx', 'minquanxian', '0370', '411421', '115.148146,34.648455');
INSERT INTO `rg_region` VALUES ('4584', '4400', '3', '睢县', 'sx', 'suixian', '0370', '411422', '115.070109,34.428433');
INSERT INTO `rg_region` VALUES ('4605', '0', '1', '内蒙古自治区', 'nmgzzq', 'neimengguzizhiqu', '', '150000', '111.670801,40.818311');
INSERT INTO `rg_region` VALUES ('4606', '4605', '2', '巴彦淖尔市', 'bynos', 'bayannaoorshi', '0478', '150800', '107.416959,40.757402');
INSERT INTO `rg_region` VALUES ('4607', '4606', '3', '乌拉特中旗', 'wltzq', 'wulatezhongqi', '0478', '150824', '108.515255,41.57254');
INSERT INTO `rg_region` VALUES ('4620', '4606', '3', '磴口县', 'dkx', 'dengkouxian', '0478', '150822', '107.006056,40.330479');
INSERT INTO `rg_region` VALUES ('4632', '4606', '3', '五原县', 'wyx', 'wuyuanxian', '0478', '150821', '108.270658,41.097639');
INSERT INTO `rg_region` VALUES ('4644', '4606', '3', '杭锦后旗', 'hjhq', 'hangjinhouqi', '0478', '150826', '107.147682,40.888797');
INSERT INTO `rg_region` VALUES ('4655', '4606', '3', '临河区', 'lhq', 'linhequ', '0478', '150802', '107.417018,40.757092');
INSERT INTO `rg_region` VALUES ('4678', '4606', '3', '乌拉特前旗', 'wltqq', 'wulateqianqi', '0478', '150823', '108.656816,40.725209');
INSERT INTO `rg_region` VALUES ('4696', '4606', '3', '乌拉特后旗', 'wlthq', 'wulatehouqi', '0478', '150825', '107.074941,41.084307');
INSERT INTO `rg_region` VALUES ('4703', '4605', '2', '乌海市', 'whs', 'wuhaishi', '0473', '150300', '106.825563,39.673734');
INSERT INTO `rg_region` VALUES ('4704', '4703', '3', '海南区', 'hnq', 'hainanqu', '0473', '150303', '106.884789,39.44153');
INSERT INTO `rg_region` VALUES ('4710', '4703', '3', '海勃湾区', 'hbwq', 'haibowanqu', '0473', '150302', '106.817762,39.673527');
INSERT INTO `rg_region` VALUES ('4719', '4703', '3', '乌达区', 'wdq', 'wudaqu', '0473', '150304', '106.722711,39.502288');
INSERT INTO `rg_region` VALUES ('4729', '4605', '2', '鄂尔多斯市', 'eodss', 'eorduosishi', '0477', '150600', '109.99029,39.817179');
INSERT INTO `rg_region` VALUES ('4730', '4729', '3', '杭锦旗', 'hjq', 'hangjinqi', '0477', '150625', '108.736324,39.831789');
INSERT INTO `rg_region` VALUES ('4737', '4729', '3', '鄂托克旗', 'etkq', 'etuokeqi', '0477', '150624', '107.982604,39.095752');
INSERT INTO `rg_region` VALUES ('4746', '4729', '3', '达拉特旗', 'dltq', 'dalateqi', '0477', '150621', '110.040281,40.404076');
INSERT INTO `rg_region` VALUES ('4763', '4729', '3', '准格尔旗', 'zgoq', 'zhungeorqi', '0477', '150622', '111.238332,39.865221');
INSERT INTO `rg_region` VALUES ('4779', '4729', '3', '乌审旗', 'wsq', 'wushonqi', '0477', '150626', '108.842454,38.596611');
INSERT INTO `rg_region` VALUES ('4786', '4729', '3', '鄂托克前旗', 'etkqq', 'etuokeqianqi', '0477', '150623', '107.48172,38.183257');
INSERT INTO `rg_region` VALUES ('4791', '4729', '3', '东胜区', 'dsq', 'dongshengqu', '0477', '150602', '109.98945,39.81788');
INSERT INTO `rg_region` VALUES ('4811', '4729', '3', '伊金霍洛旗', 'yjhlq', 'yijinhuoluoqi', '0477', '150627', '109.787402,39.604312');
INSERT INTO `rg_region` VALUES ('4819', '4729', '3', '康巴什区', 'kbsq', 'kangbashiqu', '0477', '150603', '109.790076,39.607472');
INSERT INTO `rg_region` VALUES ('4824', '4605', '2', '包头市', 'bts', 'baotoushi', '0472', '150200', '109.840405,40.658168');
INSERT INTO `rg_region` VALUES ('4825', '4824', '3', '达尔罕茂明安联合旗', 'dohmmalhq', 'daorhanmaominganlianheqi', '0472', '150223', '110.438452,41.702836');
INSERT INTO `rg_region` VALUES ('4838', '4824', '3', '土默特右旗', 'tmtyq', 'tumoteyouqi', '0472', '150221', '110.526766,40.566434');
INSERT INTO `rg_region` VALUES ('4848', '4824', '3', '白云鄂博矿区', 'byebkq', 'baiyunebokuangqu', '0472', '150206', '109.97016,41.769246');
INSERT INTO `rg_region` VALUES ('4851', '4824', '3', '东河区', 'dhq', 'donghequ', '0472', '150202', '110.026895,40.587056');
INSERT INTO `rg_region` VALUES ('4867', '4824', '3', '昆都仑区', 'kdlq', 'kundulunqu', '0472', '150203', '109.822932,40.661345');
INSERT INTO `rg_region` VALUES ('4884', '4824', '3', '固阳县', 'gyx', 'guyangxian', '0472', '150222', '110.063421,41.030004');
INSERT INTO `rg_region` VALUES ('4891', '4824', '3', '石拐区', 'sgq', 'shiguaiqu', '0472', '150205', '110.272565,40.672094');
INSERT INTO `rg_region` VALUES ('4901', '4824', '3', '九原区', 'jyq', 'jiuyuanqu', '0472', '150207', '109.968122,40.600581');
INSERT INTO `rg_region` VALUES ('4910', '4824', '3', '青山区', 'qsq', 'qingshanqu', '0472', '150204', '109.880049,40.668558');
INSERT INTO `rg_region` VALUES ('4925', '4605', '2', '呼伦贝尔市', 'hlbos', 'hulunbeiorshi', '0470', '150700', '119.758168,49.215333');
INSERT INTO `rg_region` VALUES ('4926', '4925', '3', '根河市', 'ghs', 'genheshi', '0470', '150785', '121.532724,50.780454');
INSERT INTO `rg_region` VALUES ('4935', '4925', '3', '额尔古纳市', 'eogns', 'eorgunashi', '0470', '150784', '120.178636,50.2439');
INSERT INTO `rg_region` VALUES ('4949', '4925', '3', '牙克石市', 'ykss', 'yakeshishi', '0470', '150782', '120.729005,49.287024');
INSERT INTO `rg_region` VALUES ('4969', '4925', '3', '陈巴尔虎旗', 'cbohq', 'chenbaorhuqi', '0470', '150725', '119.437609,49.328422');
INSERT INTO `rg_region` VALUES ('4980', '4925', '3', '莫力达瓦达斡尔族自治旗', 'mldwdwozzzq', 'molidawadawoorzuzizhiqi', '0470', '150722', '124.507401,48.478385');
INSERT INTO `rg_region` VALUES ('4998', '4925', '3', '扎兰屯市', 'zlts', 'zalantunshi', '0470', '150783', '122.744401,48.007412');
INSERT INTO `rg_region` VALUES ('5027', '4925', '3', '阿荣旗', 'arq', 'arongqi', '0470', '150721', '123.464615,48.130503');
INSERT INTO `rg_region` VALUES ('5042', '4925', '3', '海拉尔区', 'hloq', 'hailaorqu', '0470', '150702', '119.764923,49.213889');
INSERT INTO `rg_region` VALUES ('5051', '4925', '3', '鄂温克族自治旗', 'ewkzzzq', 'ewenkezuzizhiqi', '0470', '150724', '119.754041,49.143293');
INSERT INTO `rg_region` VALUES ('5066', '4925', '3', '扎赉诺尔区', 'zlnoq', 'zalainuoorqu', '0470', '150703', '117.716373,49.456567');
INSERT INTO `rg_region` VALUES ('5073', '4925', '3', '满洲里市', 'mzls', 'manzhoulishi', '0470', '150781', '117.455561,49.590788');
INSERT INTO `rg_region` VALUES ('5079', '4925', '3', '新巴尔虎右旗', 'xbohyq', 'xinbaorhuyouqi', '0470', '150727', '116.825991,48.669134');
INSERT INTO `rg_region` VALUES ('5088', '4925', '3', '新巴尔虎左旗', 'xbohzq', 'xinbaorhuzuoqi', '0470', '150726', '118.267454,48.216571');
INSERT INTO `rg_region` VALUES ('5097', '4925', '3', '鄂伦春自治旗', 'elczzq', 'elunchunzizhiqi', '0470', '150723', '123.725684,50.590177');
INSERT INTO `rg_region` VALUES ('5127', '4605', '2', '通辽市', 'tls', 'tongliaoshi', '0475', '150500', '122.263119,43.617429');
INSERT INTO `rg_region` VALUES ('5128', '5127', '3', '霍林郭勒市', 'hlgls', 'huolinguoleshi', '0475', '150581', '119.657862,45.532361');
INSERT INTO `rg_region` VALUES ('5134', '5127', '3', '扎鲁特旗', 'zltq', 'zaluteqi', '0475', '150526', '120.905275,44.555294');
INSERT INTO `rg_region` VALUES ('5154', '5127', '3', '科尔沁左翼中旗', 'koqzyzq', 'keorqinzuoyizhongqi', '0475', '150521', '123.313873,44.127166');
INSERT INTO `rg_region` VALUES ('5176', '5127', '3', '奈曼旗', 'nmq', 'naimanqi', '0475', '150525', '120.662543,42.84685');
INSERT INTO `rg_region` VALUES ('5192', '5127', '3', '科尔沁区', 'koqq', 'keorqinqu', '0475', '150502', '122.264042,43.617422');
INSERT INTO `rg_region` VALUES ('5225', '5127', '3', '开鲁县', 'klx', 'kailuxian', '0475', '150523', '121.308797,43.602432');
INSERT INTO `rg_region` VALUES ('5239', '5127', '3', '库伦旗', 'klq', 'kulunqi', '0475', '150524', '121.774886,42.734692');
INSERT INTO `rg_region` VALUES ('5249', '5127', '3', '科尔沁左翼后旗', 'koqzyhq', 'keorqinzuoyihouqi', '0475', '150522', '122.355155,42.954564');
INSERT INTO `rg_region` VALUES ('5277', '4605', '2', '阿拉善盟', 'alsm', 'alashanmeng', '0483', '152900', '105.706422,38.844814');
INSERT INTO `rg_region` VALUES ('5278', '5277', '3', '额济纳旗', 'ejnq', 'ejinaqi', '0483', '152923', '101.06944,41.958813');
INSERT INTO `rg_region` VALUES ('5287', '5277', '3', '阿拉善右旗', 'alsyq', 'alashanyouqi', '0483', '152922', '101.671984,39.21159');
INSERT INTO `rg_region` VALUES ('5295', '5277', '3', '阿拉善左旗', 'alszq', 'alashanzuoqi', '0483', '152921', '105.70192,38.847241');
INSERT INTO `rg_region` VALUES ('5315', '4605', '2', '赤峰市', 'cfs', 'chifengshi', '0476', '150400', '118.956806,42.275317');
INSERT INTO `rg_region` VALUES ('5316', '5315', '3', '巴林右旗', 'blyq', 'balinyouqi', '0476', '150423', '118.678347,43.528963');
INSERT INTO `rg_region` VALUES ('5327', '5315', '3', '阿鲁科尔沁旗', 'alkoqq', 'alukeorqinqi', '0476', '150421', '120.094969,43.87877');
INSERT INTO `rg_region` VALUES ('5346', '5315', '3', '巴林左旗', 'blzq', 'balinzuoqi', '0476', '150422', '119.391737,43.980715');
INSERT INTO `rg_region` VALUES ('5360', '5315', '3', '林西县', 'lxx', 'linxixian', '0476', '150424', '118.05775,43.605326');
INSERT INTO `rg_region` VALUES ('5373', '5315', '3', '翁牛特旗', 'wntq', 'wengniuteqi', '0476', '150426', '119.022619,42.937128');
INSERT INTO `rg_region` VALUES ('5391', '5315', '3', '克什克腾旗', 'ksktq', 'keshiketengqi', '0476', '150425', '117.542465,43.256233');
INSERT INTO `rg_region` VALUES ('5409', '5315', '3', '松山区', 'ssq', 'songshanqu', '0476', '150404', '118.938958,42.281046');
INSERT INTO `rg_region` VALUES ('5431', '5315', '3', '宁城县', 'ncx', 'ningchengxian', '0476', '150429', '119.339242,41.598692');
INSERT INTO `rg_region` VALUES ('5447', '5315', '3', '喀喇沁旗', 'klqq', 'kalaqinqi', '0476', '150428', '118.708572,41.92778');
INSERT INTO `rg_region` VALUES ('5461', '5315', '3', '红山区', 'hsq', 'hongshanqu', '0476', '150402', '118.961087,42.269732');
INSERT INTO `rg_region` VALUES ('5478', '5315', '3', '元宝山区', 'ybsq', 'yuanbaoshanqu', '0476', '150403', '119.289877,42.041168');
INSERT INTO `rg_region` VALUES ('5492', '5315', '3', '敖汉旗', 'ahq', 'aohanqi', '0476', '150430', '119.906486,42.287012');
INSERT INTO `rg_region` VALUES ('5511', '4605', '2', '兴安盟', 'xam', 'xinganmeng', '0482', '152200', '122.070317,46.076268');
INSERT INTO `rg_region` VALUES ('5512', '5511', '3', '阿尔山市', 'aoss', 'aorshanshi', '0482', '152202', '119.943656,47.177');
INSERT INTO `rg_region` VALUES ('5521', '5511', '3', '扎赉特旗', 'zltq', 'zalaiteqi', '0482', '152223', '122.909332,46.725136');
INSERT INTO `rg_region` VALUES ('5542', '5511', '3', '科尔沁右翼中旗', 'koqyyzq', 'keorqinyouyizhongqi', '0482', '152222', '121.472818,45.059645');
INSERT INTO `rg_region` VALUES ('5559', '5511', '3', '突泉县', 'tqx', 'tuquanxian', '0482', '152224', '121.564856,45.380986');
INSERT INTO `rg_region` VALUES ('5570', '5511', '3', '乌兰浩特市', 'wlhts', 'wulanhaoteshi', '0482', '152201', '122.068975,46.077238');
INSERT INTO `rg_region` VALUES ('5587', '5511', '3', '科尔沁右翼前旗', 'koqyyqq', 'keorqinyouyiqianqi', '0482', '152221', '121.957544,46.076497');
INSERT INTO `rg_region` VALUES ('5608', '4605', '2', '锡林郭勒盟', 'xlglm', 'xilinguolemeng', '0479', '152500', '116.090996,43.944018');
INSERT INTO `rg_region` VALUES ('5609', '5608', '3', '东乌珠穆沁旗', 'dwzmqq', 'dongwuzhumuqinqi', '0479', '152525', '116.980022,45.510307');
INSERT INTO `rg_region` VALUES ('5625', '5608', '3', '锡林浩特市', 'xlhts', 'xilinhaoteshi', '0479', '152502', '116.091903,43.944301');
INSERT INTO `rg_region` VALUES ('5642', '5608', '3', '西乌珠穆沁旗', 'xwzmqq', 'xiwuzhumuqinqi', '0479', '152526', '117.615249,44.586147');
INSERT INTO `rg_region` VALUES ('5652', '5608', '3', '阿巴嘎旗', 'abgq', 'abagaqi', '0479', '152522', '114.970618,44.022728');
INSERT INTO `rg_region` VALUES ('5662', '5608', '3', '苏尼特左旗', 'sntzq', 'sunitezuoqi', '0479', '152523', '113.653412,43.854108');
INSERT INTO `rg_region` VALUES ('5672', '5608', '3', '二连浩特市', 'elhts', 'erlianhaoteshi', '0479', '152501', '111.97981,43.652895');
INSERT INTO `rg_region` VALUES ('5676', '5608', '3', '苏尼特右旗', 'sntyq', 'suniteyouqi', '0479', '152524', '112.65539,42.746662');
INSERT INTO `rg_region` VALUES ('5685', '5608', '3', '多伦县', 'dlx', 'duolunxian', '0479', '152531', '116.477288,42.197962');
INSERT INTO `rg_region` VALUES ('5692', '5608', '3', '太仆寺旗', 'tpsq', 'taipusiqi', '0479', '152527', '115.28728,41.895199');
INSERT INTO `rg_region` VALUES ('5701', '5608', '3', '正蓝旗', 'zlq', 'zhenglanqi', '0479', '152530', '116.003311,42.245895');
INSERT INTO `rg_region` VALUES ('5711', '5608', '3', '镶黄旗', 'xhq', 'xianghuangqi', '0479', '152528', '113.843869,42.239229');
INSERT INTO `rg_region` VALUES ('5716', '5608', '3', '正镶白旗', 'zxbq', 'zhengxiangbaiqi', '0479', '152529', '115.031423,42.286807');
INSERT INTO `rg_region` VALUES ('5724', '4605', '2', '乌兰察布市', 'wlcbs', 'wulanchabushi', '0474', '150900', '113.114543,41.034126');
INSERT INTO `rg_region` VALUES ('5725', '5724', '3', '四子王旗', 'szwq', 'siziwangqi', '0474', '150929', '111.70123,41.528114');
INSERT INTO `rg_region` VALUES ('5740', '5724', '3', '化德县', 'hdx', 'huadexian', '0474', '150922', '114.01008,41.899335');
INSERT INTO `rg_region` VALUES ('5747', '5724', '3', '商都县', 'sdx', 'shangduxian', '0474', '150923', '113.560643,41.560163');
INSERT INTO `rg_region` VALUES ('5758', '5724', '3', '察哈尔右翼中旗', 'choyyzq', 'chahaoryouyizhongqi', '0474', '150927', '112.633563,41.274212');
INSERT INTO `rg_region` VALUES ('5771', '5724', '3', '卓资县', 'zzx', 'zhuozixian', '0474', '150921', '112.577702,40.89576');
INSERT INTO `rg_region` VALUES ('5780', '5724', '3', '察哈尔右翼后旗', 'choyyhq', 'chahaoryouyihouqi', '0474', '150928', '113.1906,41.447213');
INSERT INTO `rg_region` VALUES ('5789', '5724', '3', '兴和县', 'xhx', 'xinghexian', '0474', '150924', '113.834009,40.872437');
INSERT INTO `rg_region` VALUES ('5800', '5724', '3', '丰镇市', 'fzs', 'fengzhenshi', '0474', '150981', '113.163462,40.437534');
INSERT INTO `rg_region` VALUES ('5814', '5724', '3', '凉城县', 'lcx', 'liangchengxian', '0474', '150925', '112.500911,40.531627');
INSERT INTO `rg_region` VALUES ('5827', '5724', '3', '集宁区', 'jnq', 'jiningqu', '0474', '150902', '113.116453,41.034134');
INSERT INTO `rg_region` VALUES ('5838', '5724', '3', '察哈尔右翼前旗', 'choyyqq', 'chahaoryouyiqianqi', '0474', '150926', '113.211958,40.786859');
INSERT INTO `rg_region` VALUES ('5850', '4605', '2', '呼和浩特市', 'hhhts', 'huhehaoteshi', '0471', '150100', '111.670801,40.818311');
INSERT INTO `rg_region` VALUES ('5851', '5850', '3', '和林格尔县', 'hlgox', 'helingeorxian', '0471', '150123', '111.824143,40.380288');
INSERT INTO `rg_region` VALUES ('5861', '5850', '3', '回民区', 'hmq', 'huiminqu', '0471', '150103', '111.662162,40.815149');
INSERT INTO `rg_region` VALUES ('5870', '5850', '3', '玉泉区', 'yqq', 'yuquanqu', '0471', '150104', '111.66543,40.799421');
INSERT INTO `rg_region` VALUES ('5881', '5850', '3', '武川县', 'wcx', 'wuchuanxian', '0471', '150125', '111.456563,41.094483');
INSERT INTO `rg_region` VALUES ('5893', '5850', '3', '土默特左旗', 'tmtzq', 'tumotezuoqi', '0471', '150121', '111.133615,40.720416');
INSERT INTO `rg_region` VALUES ('5907', '5850', '3', '托克托县', 'tktx', 'tuoketuoxian', '0471', '150122', '111.197317,40.276729');
INSERT INTO `rg_region` VALUES ('5914', '5850', '3', '新城区', 'xcq', 'xinchengqu', '0471', '150102', '111.685964,40.826225');
INSERT INTO `rg_region` VALUES ('5925', '5850', '3', '赛罕区', 'shq', 'saihanqu', '0471', '150105', '111.698463,40.807834');
INSERT INTO `rg_region` VALUES ('5940', '5850', '3', '清水河县', 'qshx', 'qingshuihexian', '0471', '150124', '111.67222,39.912479');
INSERT INTO `rg_region` VALUES ('5949', '0', '1', '黑龙江省', 'hljs', 'heilongjiangsheng', '', '230000', '126.642464,45.756967');
INSERT INTO `rg_region` VALUES ('5950', '5949', '2', '七台河市', 'qths', 'qitaiheshi', '0464', '230900', '131.015584,45.771266');
INSERT INTO `rg_region` VALUES ('5951', '5950', '3', '桃山区', 'tsq', 'taoshanqu', '0464', '230903', '131.015848,45.771217');
INSERT INTO `rg_region` VALUES ('5963', '5950', '3', '茄子河区', 'qzhq', 'qiezihequ', '0464', '230904', '131.071561,45.776587');
INSERT INTO `rg_region` VALUES ('5973', '5950', '3', '新兴区', 'xxq', 'xinxingqu', '0464', '230902', '130.889482,45.794258');
INSERT INTO `rg_region` VALUES ('5996', '5950', '3', '勃利县', 'blx', 'bolixian', '0464', '230921', '130.575025,45.751573');
INSERT INTO `rg_region` VALUES ('6012', '5949', '2', '大兴安岭地区', 'dxaldq', 'daxinganlingdiqu', '0457', '232700', '124.711526,52.335262');
INSERT INTO `rg_region` VALUES ('6013', '6012', '3', '漠河市', 'mhs', 'moheshi', '0457', '232701', '122.536256,52.972074');
INSERT INTO `rg_region` VALUES ('6022', '6012', '3', '塔河县', 'thx', 'tahexian', '0457', '232722', '124.710516,52.335229');
INSERT INTO `rg_region` VALUES ('6030', '6012', '3', '呼玛县', 'hmx', 'humaxian', '0457', '232721', '126.662105,51.726998');
INSERT INTO `rg_region` VALUES ('6051', '6012', '3', '加格达奇区', 'jgdqq', 'jiagedaqiqu', '0457', '232718', '124.126716,50.424654');
INSERT INTO `rg_region` VALUES ('6061', '5949', '2', '鹤岗市', 'hgs', 'hegangshi', '0468', '230400', '130.277487,47.332085');
INSERT INTO `rg_region` VALUES ('6062', '6061', '3', '绥滨县', 'sbx', 'suibinxian', '0468', '230422', '131.860526,47.289892');
INSERT INTO `rg_region` VALUES ('6079', '6061', '3', '工农区', 'gnq', 'gongnongqu', '0468', '230403', '130.276652,47.331678');
INSERT INTO `rg_region` VALUES ('6086', '6061', '3', '兴山区', 'xsq', 'xingshanqu', '0468', '230407', '130.30534,47.35997');
INSERT INTO `rg_region` VALUES ('6091', '6061', '3', '向阳区', 'xyq', 'xiangyangqu', '0468', '230402', '130.292478,47.345372');
INSERT INTO `rg_region` VALUES ('6097', '6061', '3', '兴安区', 'xaq', 'xinganqu', '0468', '230405', '130.236169,47.252911');
INSERT INTO `rg_region` VALUES ('6105', '6061', '3', '南山区', 'nsq', 'nanshanqu', '0468', '230404', '130.275533,47.31324');
INSERT INTO `rg_region` VALUES ('6112', '6061', '3', '萝北县', 'lbx', 'luobeixian', '0468', '230421', '130.829087,47.577577');
INSERT INTO `rg_region` VALUES ('6131', '6061', '3', '东山区', 'dsq', 'dongshanqu', '0468', '230406', '130.31714,47.337385');
INSERT INTO `rg_region` VALUES ('6142', '5949', '2', '伊春市', 'ycs', 'yichunshi', '0458', '230700', '128.899396,47.724775');
INSERT INTO `rg_region` VALUES ('6143', '6142', '3', '红星区', 'hxq', 'hongxingqu', '0458', '230715', '129.388796,48.238368');
INSERT INTO `rg_region` VALUES ('6153', '6142', '3', '乌伊岭区', 'wylq', 'wuyilingqu', '0458', '230714', '129.437847,48.59112');
INSERT INTO `rg_region` VALUES ('6162', '6142', '3', '汤旺河区', 'twhq', 'tangwanghequ', '0458', '230712', '129.57224,48.453651');
INSERT INTO `rg_region` VALUES ('6175', '6142', '3', '嘉荫县', 'jyx', 'jiayinxian', '0458', '230722', '130.397684,48.891378');
INSERT INTO `rg_region` VALUES ('6189', '6142', '3', '友好区', 'yhq', 'youhaoqu', '0458', '230704', '128.838961,47.854303');
INSERT INTO `rg_region` VALUES ('6207', '6142', '3', '新青区', 'xqq', 'xinqingqu', '0458', '230707', '129.52995,48.288292');
INSERT INTO `rg_region` VALUES ('6216', '6142', '3', '五营区', 'wyq', 'wuyingqu', '0458', '230710', '129.245028,48.108204');
INSERT INTO `rg_region` VALUES ('6226', '6142', '3', '乌马河区', 'wmhq', 'wumahequ', '0458', '230711', '128.802941,47.726961');
INSERT INTO `rg_region` VALUES ('6240', '6142', '3', '美溪区', 'mxq', 'moixiqu', '0458', '230708', '129.133411,47.636102');
INSERT INTO `rg_region` VALUES ('6256', '6142', '3', '上甘岭区', 'sglq', 'shangganlingqu', '0458', '230716', '129.02508,47.974859');
INSERT INTO `rg_region` VALUES ('6270', '6142', '3', '翠峦区', 'clq', 'cuiluanqu', '0458', '230706', '128.671746,47.726228');
INSERT INTO `rg_region` VALUES ('6281', '6142', '3', '铁力市', 'tls', 'tiolishi', '0458', '230781', '128.030561,46.985772');
INSERT INTO `rg_region` VALUES ('6294', '6142', '3', '伊春区', 'ycq', 'yichunqu', '0458', '230702', '128.899284,47.726851');
INSERT INTO `rg_region` VALUES ('6300', '6142', '3', '金山屯区', 'jstq', 'jinshantunqu', '0458', '230709', '129.435944,47.41295');
INSERT INTO `rg_region` VALUES ('6313', '6142', '3', '西林区', 'xlq', 'xilinqu', '0458', '230705', '129.311441,47.479437');
INSERT INTO `rg_region` VALUES ('6317', '6142', '3', '带岭区', 'dlq', 'dailingqu', '0458', '230713', '129.021151,47.027532');
INSERT INTO `rg_region` VALUES ('6331', '6142', '3', '南岔区', 'ncq', 'nanchaqu', '0458', '230703', '129.28246,47.137314');
INSERT INTO `rg_region` VALUES ('6352', '5949', '2', '绥化市', 'shs', 'suihuashi', '0455', '231200', '126.99293,46.637393');
INSERT INTO `rg_region` VALUES ('6353', '6352', '3', '绥棱县', 'slx', 'suilengxian', '0455', '231226', '127.111121,47.247195');
INSERT INTO `rg_region` VALUES ('6374', '6352', '3', '海伦市', 'hls', 'hailunshi', '0455', '231283', '126.969383,47.460428');
INSERT INTO `rg_region` VALUES ('6404', '6352', '3', '庆安县', 'qax', 'qinganxian', '0455', '231224', '127.510024,46.879203');
INSERT INTO `rg_region` VALUES ('6421', '6352', '3', '北林区', 'blq', 'beilinqu', '0455', '231202', '126.990665,46.634912');
INSERT INTO `rg_region` VALUES ('6449', '6352', '3', '望奎县', 'wkx', 'wangkuixian', '0455', '231221', '126.484191,46.83352');
INSERT INTO `rg_region` VALUES ('6469', '6352', '3', '青冈县', 'qgx', 'qinggangxian', '0455', '231223', '126.112268,46.686596');
INSERT INTO `rg_region` VALUES ('6491', '6352', '3', '兰西县', 'lxx', 'lanxixian', '0455', '231222', '126.289315,46.259037');
INSERT INTO `rg_region` VALUES ('6510', '6352', '3', '肇东市', 'zds', 'zhaodongshi', '0455', '231282', '125.991402,46.069471');
INSERT INTO `rg_region` VALUES ('6538', '6352', '3', '明水县', 'msx', 'mingshuixian', '0455', '231225', '125.907544,47.183527');
INSERT INTO `rg_region` VALUES ('6558', '6352', '3', '安达市', 'ads', 'andashi', '0455', '231281', '125.329926,46.410614');
INSERT INTO `rg_region` VALUES ('6580', '5949', '2', '黑河市', 'hhs', 'heiheshi', '0456', '231100', '127.499023,50.249585');
INSERT INTO `rg_region` VALUES ('6581', '6580', '3', '嫩江县', 'njx', 'nenjiangxian', '0456', '231121', '125.229904,49.177461');
INSERT INTO `rg_region` VALUES ('6609', '6580', '3', '爱辉区', 'ahq', 'aihuiqu', '0456', '231102', '127.497639,50.249027');
INSERT INTO `rg_region` VALUES ('6647', '6580', '3', '北安市', 'bas', 'beianshi', '0456', '231181', '126.508737,48.245437');
INSERT INTO `rg_region` VALUES ('6669', '6580', '3', '五大连池市', 'wdlcs', 'wudalianchishi', '0456', '231182', '126.197694,48.512688');
INSERT INTO `rg_region` VALUES ('6708', '6580', '3', '孙吴县', 'swx', 'sunwuxian', '0456', '231124', '127.327315,49.423941');
INSERT INTO `rg_region` VALUES ('6732', '6580', '3', '逊克县', 'xkx', 'xunkexian', '0456', '231123', '128.476152,49.582974');
INSERT INTO `rg_region` VALUES ('6750', '5949', '2', '哈尔滨市', 'hobs', 'haorbinshi', '0451', '230100', '126.642464,45.756967');
INSERT INTO `rg_region` VALUES ('6751', '6750', '3', '巴彦县', 'byx', 'bayanxian', '0451', '230126', '127.403602,46.081889');
INSERT INTO `rg_region` VALUES ('6772', '6750', '3', '依兰县', 'ylx', 'yilanxian', '0451', '230123', '129.565594,46.315105');
INSERT INTO `rg_region` VALUES ('6785', '6750', '3', '通河县', 'thx', 'tonghexian', '0451', '230128', '128.747786,45.977618');
INSERT INTO `rg_region` VALUES ('6797', '6750', '3', '双城区', 'scq', 'shuangchengqu', '0451', '230113', '126.308784,45.377942');
INSERT INTO `rg_region` VALUES ('6823', '6750', '3', '延寿县', 'ysx', 'yanshouxian', '0451', '230129', '128.331886,45.455648');
INSERT INTO `rg_region` VALUES ('6835', '6750', '3', '方正县', 'fzx', 'fangzhengxian', '0451', '230124', '128.836131,45.839536');
INSERT INTO `rg_region` VALUES ('6846', '6750', '3', '平房区', 'pfq', 'pingfangqu', '0451', '230108', '126.629257,45.605567');
INSERT INTO `rg_region` VALUES ('6856', '6750', '3', '木兰县', 'mlx', 'mulanxian', '0451', '230127', '128.042675,45.949826');
INSERT INTO `rg_region` VALUES ('6866', '6750', '3', '宾县', 'bx', 'binxian', '0451', '230125', '127.48594,45.759369');
INSERT INTO `rg_region` VALUES ('6886', '6750', '3', '尚志市', 'szs', 'shangzhishi', '0451', '230183', '127.968539,45.214953');
INSERT INTO `rg_region` VALUES ('6906', '6750', '3', '香坊区', 'xfq', 'xiangfangqu', '0451', '230110', '126.667049,45.713067');
INSERT INTO `rg_region` VALUES ('6933', '6750', '3', '道里区', 'dlq', 'daoliqu', '0451', '230102', '126.612532,45.762035');
INSERT INTO `rg_region` VALUES ('6959', '6750', '3', '五常市', 'wcs', 'wuchangshi', '0451', '230184', '127.15759,44.919418');
INSERT INTO `rg_region` VALUES ('6985', '6750', '3', '阿城区', 'acq', 'achengqu', '0451', '230112', '126.972726,45.538372');
INSERT INTO `rg_region` VALUES ('7006', '6750', '3', '南岗区', 'ngq', 'nangangqu', '0451', '230103', '126.652098,45.755971');
INSERT INTO `rg_region` VALUES ('7029', '6750', '3', '道外区', 'dwq', 'daowaiqu', '0451', '230104', '126.648838,45.78454');
INSERT INTO `rg_region` VALUES ('7059', '6750', '3', '松北区', 'sbq', 'songbeiqu', '0451', '230109', '126.563066,45.814656');
INSERT INTO `rg_region` VALUES ('7066', '6750', '3', '呼兰区', 'hlq', 'hulanqu', '0451', '230111', '126.603302,45.98423');
INSERT INTO `rg_region` VALUES ('7088', '5949', '2', '齐齐哈尔市', 'qqhos', 'qiqihaorshi', '0452', '230200', '123.95792,47.342081');
INSERT INTO `rg_region` VALUES ('7089', '7088', '3', '克山县', 'ksx', 'keshanxian', '0452', '230229', '125.874355,48.034342');
INSERT INTO `rg_region` VALUES ('7113', '7088', '3', '讷河市', 'nhs', 'neheshi', '0452', '230281', '124.882172,48.481133');
INSERT INTO `rg_region` VALUES ('7147', '7088', '3', '甘南县', 'gnx', 'gannanxian', '0452', '230225', '123.506034,47.917838');
INSERT INTO `rg_region` VALUES ('7160', '7088', '3', '富裕县', 'fyx', 'fuyuxian', '0452', '230227', '124.469106,47.797172');
INSERT INTO `rg_region` VALUES ('7173', '7088', '3', '克东县', 'kdx', 'kedongxian', '0452', '230230', '126.249094,48.03732');
INSERT INTO `rg_region` VALUES ('7192', '7088', '3', '依安县', 'yax', 'yianxian', '0452', '230223', '125.307561,47.890098');
INSERT INTO `rg_region` VALUES ('7210', '7088', '3', '梅里斯达斡尔族区', 'mlsdwozq', 'meilisidawoorzuqu', '0452', '230208', '123.754599,47.311113');
INSERT INTO `rg_region` VALUES ('7219', '7088', '3', '龙江县', 'ljx', 'longjiangxian', '0452', '230221', '123.187225,47.336388');
INSERT INTO `rg_region` VALUES ('7234', '7088', '3', '碾子山区', 'nzsq', 'nianzishanqu', '0452', '230207', '122.887972,47.51401');
INSERT INTO `rg_region` VALUES ('7240', '7088', '3', '龙沙区', 'lsq', 'longshaqu', '0452', '230202', '123.957338,47.341736');
INSERT INTO `rg_region` VALUES ('7249', '7088', '3', '建华区', 'jhq', 'jianhuaqu', '0452', '230203', '123.955888,47.354494');
INSERT INTO `rg_region` VALUES ('7256', '7088', '3', '铁锋区', 'tfq', 'tiofengqu', '0452', '230204', '123.973555,47.339499');
INSERT INTO `rg_region` VALUES ('7266', '7088', '3', '富拉尔基区', 'flojq', 'fulaorjiqu', '0452', '230206', '123.638873,47.20697');
INSERT INTO `rg_region` VALUES ('7277', '7088', '3', '昂昂溪区', 'aaxq', 'angangxiqu', '0452', '230205', '123.813181,47.156867');
INSERT INTO `rg_region` VALUES ('7284', '7088', '3', '泰来县', 'tlx', 'tailaixian', '0452', '230224', '123.41953,46.39233');
INSERT INTO `rg_region` VALUES ('7306', '7088', '3', '拜泉县', 'bqx', 'baiquanxian', '0452', '230231', '126.091911,47.607363');
INSERT INTO `rg_region` VALUES ('7323', '5949', '2', '牡丹江市', 'mdjs', 'mudanjiangshi', '0453', '231000', '129.618602,44.582962');
INSERT INTO `rg_region` VALUES ('7324', '7323', '3', '爱民区', 'amq', 'aiminqu', '0453', '231004', '129.601232,44.595443');
INSERT INTO `rg_region` VALUES ('7333', '7323', '3', '东安区', 'daq', 'donganqu', '0453', '231002', '129.623292,44.582399');
INSERT INTO `rg_region` VALUES ('7339', '7323', '3', '绥芬河市', 'sfhs', 'suifenheshi', '0453', '231081', '131.164856,44.396864');
INSERT INTO `rg_region` VALUES ('7342', '7323', '3', '宁安市', 'nas', 'ninganshi', '0453', '231084', '129.470019,44.346836');
INSERT INTO `rg_region` VALUES ('7358', '7323', '3', '东宁市', 'dns', 'dongningshi', '0453', '231086', '131.125296,44.063578');
INSERT INTO `rg_region` VALUES ('7366', '7323', '3', '阳明区', 'ymq', 'yangmingqu', '0453', '231003', '129.634645,44.596328');
INSERT INTO `rg_region` VALUES ('7375', '7323', '3', '穆棱市', 'mls', 'mulengshi', '0453', '231085', '130.527085,44.91967');
INSERT INTO `rg_region` VALUES ('7386', '7323', '3', '林口县', 'lkx', 'linkouxian', '0453', '231025', '130.268402,45.286645');
INSERT INTO `rg_region` VALUES ('7399', '7323', '3', '西安区', 'xaq', 'xianqu', '0453', '231005', '129.61311,44.581032');
INSERT INTO `rg_region` VALUES ('7408', '7323', '3', '海林市', 'hls', 'hailinshi', '0453', '231083', '129.387902,44.574149');
INSERT INTO `rg_region` VALUES ('7424', '5949', '2', '鸡西市', 'jxs', 'jixishi', '0467', '230300', '130.975966,45.300046');
INSERT INTO `rg_region` VALUES ('7425', '7424', '3', '城子河区', 'czhq', 'chengzihequ', '0467', '230306', '131.010501,45.338248');
INSERT INTO `rg_region` VALUES ('7432', '7424', '3', '鸡冠区', 'jgq', 'jiguanqu', '0467', '230302', '130.974374,45.30034');
INSERT INTO `rg_region` VALUES ('7442', '7424', '3', '恒山区', 'hsq', 'hengshanqu', '0467', '230303', '130.910636,45.213242');
INSERT INTO `rg_region` VALUES ('7450', '7424', '3', '麻山区', 'msq', 'mashanqu', '0467', '230307', '130.481126,45.209607');
INSERT INTO `rg_region` VALUES ('7453', '7424', '3', '梨树区', 'lsq', 'lishuqu', '0467', '230305', '130.697781,45.092195');
INSERT INTO `rg_region` VALUES ('7460', '7424', '3', '滴道区', 'ddq', 'didaoqu', '0467', '230304', '130.846823,45.348812');
INSERT INTO `rg_region` VALUES ('7467', '7424', '3', '密山市', 'mss', 'mishanshi', '0467', '230382', '131.874137,45.54725');
INSERT INTO `rg_region` VALUES ('7502', '7424', '3', '鸡东县', 'jdx', 'jidongxian', '0467', '230321', '131.148907,45.250892');
INSERT INTO `rg_region` VALUES ('7516', '7424', '3', '虎林市', 'hls', 'hulinshi', '0467', '230381', '132.973881,45.767985');
INSERT INTO `rg_region` VALUES ('7536', '5949', '2', '大庆市', 'dqs', 'daqingshi', '0459', '230600', '125.11272,46.590734');
INSERT INTO `rg_region` VALUES ('7537', '7536', '3', '让胡路区', 'rhlq', 'ranghuluqu', '0459', '230604', '124.868341,46.653254');
INSERT INTO `rg_region` VALUES ('7548', '7536', '3', '肇源县', 'zyx', 'zhaoyuanxian', '0459', '230622', '125.081974,45.518832');
INSERT INTO `rg_region` VALUES ('7572', '7536', '3', '红岗区', 'hgq', 'honggangqu', '0459', '230605', '124.889528,46.403049');
INSERT INTO `rg_region` VALUES ('7580', '7536', '3', '大同区', 'dtq', 'datongqu', '0459', '230606', '124.818509,46.034304');
INSERT INTO `rg_region` VALUES ('7596', '7536', '3', '杜尔伯特蒙古族自治县', 'dobtmgzzzx', 'duorbotemengguzuzizhixian', '0459', '230624', '124.446259,46.865973');
INSERT INTO `rg_region` VALUES ('7610', '7536', '3', '林甸县', 'ldx', 'lindianxian', '0459', '230623', '124.877742,47.186411');
INSERT INTO `rg_region` VALUES ('7623', '7536', '3', '龙凤区', 'lfq', 'longfengqu', '0459', '230603', '125.145794,46.573948');
INSERT INTO `rg_region` VALUES ('7632', '7536', '3', '萨尔图区', 'sotq', 'saortuqu', '0459', '230602', '125.114643,46.596356');
INSERT INTO `rg_region` VALUES ('7642', '7536', '3', '肇州县', 'zzx', 'zhaozhouxian', '0459', '230621', '125.273254,45.708685');
INSERT INTO `rg_region` VALUES ('7657', '5949', '2', '双鸭山市', 'syss', 'shuangyashanshi', '0469', '230500', '131.157304,46.643442');
INSERT INTO `rg_region` VALUES ('7658', '7657', '3', '岭东区', 'ldq', 'lingdongqu', '0469', '230503', '131.163675,46.591076');
INSERT INTO `rg_region` VALUES ('7668', '7657', '3', '尖山区', 'jsq', 'jianshanqu', '0469', '230502', '131.15896,46.642961');
INSERT INTO `rg_region` VALUES ('7677', '7657', '3', '宝山区', 'bsq', 'baoshanqu', '0469', '230506', '131.404294,46.573366');
INSERT INTO `rg_region` VALUES ('7685', '7657', '3', '友谊县', 'yyx', 'youyixian', '0469', '230522', '131.810622,46.775159');
INSERT INTO `rg_region` VALUES ('7699', '7657', '3', '四方台区', 'sftq', 'sifangtaiqu', '0469', '230505', '131.333181,46.594347');
INSERT INTO `rg_region` VALUES ('7704', '7657', '3', '宝清县', 'bqx', 'baoqingxian', '0469', '230523', '132.206415,46.328781');
INSERT INTO `rg_region` VALUES ('7728', '7657', '3', '饶河县', 'rhx', 'raohexian', '0469', '230524', '134.021162,46.801288');
INSERT INTO `rg_region` VALUES ('7754', '7657', '3', '集贤县', 'jxx', 'jixianxian', '0469', '230521', '131.13933,46.72898');
INSERT INTO `rg_region` VALUES ('7775', '5949', '2', '佳木斯市', 'jmss', 'jiamusishi', '0454', '230800', '130.361634,46.809606');
INSERT INTO `rg_region` VALUES ('7776', '7775', '3', '同江市', 'tjs', 'tongjiangshi', '0454', '230881', '132.510119,47.651131');
INSERT INTO `rg_region` VALUES ('7799', '7775', '3', '桦川县', 'hcx', 'huachuanxian', '0454', '230826', '130.723713,47.023039');
INSERT INTO `rg_region` VALUES ('7811', '7775', '3', '汤原县', 'tyx', 'tangyuanxian', '0454', '230828', '129.904463,46.730048');
INSERT INTO `rg_region` VALUES ('7826', '7775', '3', '向阳区', 'xyq', 'xiangyangqu', '0454', '230803', '130.361786,46.809645');
INSERT INTO `rg_region` VALUES ('7834', '7775', '3', '郊区', 'jq', 'jiaoqu', '0454', '230811', '130.351588,46.80712');
INSERT INTO `rg_region` VALUES ('7850', '7775', '3', '前进区', 'qjq', 'qianjinqu', '0454', '230804', '130.377684,46.812345');
INSERT INTO `rg_region` VALUES ('7853', '7775', '3', '东风区', 'dfq', 'dongfengqu', '0454', '230805', '130.403297,46.822476');
INSERT INTO `rg_region` VALUES ('7862', '7775', '3', '抚远市', 'fys', 'fuyuanshi', '0454', '230883', '134.294501,48.364707');
INSERT INTO `rg_region` VALUES ('7875', '7775', '3', '桦南县', 'hnx', 'huananxian', '0454', '230822', '130.570112,46.240118');
INSERT INTO `rg_region` VALUES ('7889', '7775', '3', '富锦市', 'fjs', 'fujinshi', '0454', '230882', '132.037951,47.250747');
INSERT INTO `rg_region` VALUES ('7917', '0', '1', '新疆维吾尔自治区', 'xjwwozzq', 'xinjiangweiwuorzizhiqu', '', '650000', '87.617733,43.792818');
INSERT INTO `rg_region` VALUES ('7918', '7917', '2', '双河市', 'shs', 'shuangheshi', '1909', '659007', '82.353656,44.840524');
INSERT INTO `rg_region` VALUES ('7919', '7918', '3', '兵团八十九团', 'btbsjt', 'bingtuanbashijiutuan', '1909', '659007', '82.2853,45.0582');
INSERT INTO `rg_region` VALUES ('7920', '7918', '3', '兵团八十六团', 'btbslt', 'bingtuanbashiliutuan', '1909', '659007', '82.1787,44.8089');
INSERT INTO `rg_region` VALUES ('7921', '7918', '3', '兵团八十四团', 'btbsst', 'bingtuanbashisituan', '1909', '659007', '82.215,45.1246');
INSERT INTO `rg_region` VALUES ('7922', '7918', '3', '兵团九十团', 'btjst', 'bingtuanjiushituan', '1909', '659007', '82.6473,44.7651');
INSERT INTO `rg_region` VALUES ('7923', '7918', '3', '兵团八十一团', 'btbsyt', 'bingtuanbashiyituan', '1909', '659007', '82.4908,44.7469');
INSERT INTO `rg_region` VALUES ('7924', '7917', '2', '昆玉市', 'kys', 'kunyushi', '1903', '659009', '79.287372,37.207994');
INSERT INTO `rg_region` VALUES ('7925', '7924', '3', '兵团皮山农场', 'btpsnc', 'bingtuanpishannongchang', '1903', '659009', '78.5171,37.563');
INSERT INTO `rg_region` VALUES ('7926', '7924', '3', '兵团二二四团', 'bteest', 'bingtuanerersituan', '1903', '659009', '79.3401,37.416');
INSERT INTO `rg_region` VALUES ('7927', '7924', '3', '乌尔其乡', 'woqx', 'wuorqixiang', '1903', '659009', '79.5866,37.332');
INSERT INTO `rg_region` VALUES ('7928', '7924', '3', '兵团四十七团', 'btssqt', 'bingtuansishiqituan', '1903', '659009', '79.6039,37.3666');
INSERT INTO `rg_region` VALUES ('7929', '7924', '3', '阔依其乡', 'kyqx', 'kuoyiqixiang', '1903', '659009', '79.6876,37.3691');
INSERT INTO `rg_region` VALUES ('7930', '7924', '3', '乌鲁克萨依乡', 'wlksyx', 'wulukesayixiang', '1903', '659009', '80.8148,36.2925');
INSERT INTO `rg_region` VALUES ('7931', '7924', '3', '喀拉喀什镇', 'klksz', 'kalakashizhen', '1903', '659009', '79.7678,37.2867');
INSERT INTO `rg_region` VALUES ('7932', '7924', '3', '普恰克其乡', 'pqkqx', 'puqiakeqixiang', '1903', '659009', '79.783,37.5805');
INSERT INTO `rg_region` VALUES ('7933', '7924', '3', '奴尔乡', 'nox', 'nuorxiang', '1903', '659009', '81.0072,36.2605');
INSERT INTO `rg_region` VALUES ('7934', '7924', '3', '兵团一牧场', 'btymc', 'bingtuanyimuchang', '1903', '659009', '81.0295,36.3152');
INSERT INTO `rg_region` VALUES ('7935', '7924', '3', '博斯坦乡', 'bstx', 'bositanxiang', '1903', '659009', '81.3298,36.4124');
INSERT INTO `rg_region` VALUES ('7936', '7917', '2', '塔城地区', 'tcdq', 'tachengdiqu', '0901', '654200', '82.985732,46.746301');
INSERT INTO `rg_region` VALUES ('7937', '7936', '3', '裕民县', 'ymx', 'yuminxian', '0901', '654225', '82.982157,46.202781');
INSERT INTO `rg_region` VALUES ('7946', '7936', '3', '额敏县', 'emx', 'eminxian', '0901', '654221', '83.622118,46.522555');
INSERT INTO `rg_region` VALUES ('7970', '7936', '3', '托里县', 'tlx', 'tuolixian', '0901', '654224', '83.60469,45.935863');
INSERT INTO `rg_region` VALUES ('7982', '7936', '3', '塔城市', 'tcs', 'tachengshi', '0901', '654201', '82.983988,46.746281');
INSERT INTO `rg_region` VALUES ('7998', '7936', '3', '和布克赛尔蒙古自治县', 'hbksomgzzx', 'hebukesaiormengguzizhixian', '0901', '654226', '85.733551,46.793001');
INSERT INTO `rg_region` VALUES ('8014', '7936', '3', '沙湾县', 'swx', 'shawanxian', '0901', '654223', '85.622508,44.329544');
INSERT INTO `rg_region` VALUES ('8037', '7936', '3', '乌苏市', 'wss', 'wusushi', '0901', '654202', '84.677624,44.430115');
INSERT INTO `rg_region` VALUES ('8069', '7917', '2', '和田地区', 'htdq', 'hetiandiqu', '0903', '653200', '79.92533,37.110687');
INSERT INTO `rg_region` VALUES ('8070', '8069', '3', '民丰县', 'mfx', 'minfengxian', '0903', '653227', '82.692354,37.064909');
INSERT INTO `rg_region` VALUES ('8078', '8069', '3', '和田市', 'hts', 'hetianshi', '0903', '653201', '79.927542,37.108944');
INSERT INTO `rg_region` VALUES ('8091', '8069', '3', '于田县', 'ytx', 'yutianxian', '0903', '653226', '81.667845,36.854628');
INSERT INTO `rg_region` VALUES ('8110', '8069', '3', '洛浦县', 'lpx', 'luopuxian', '0903', '653224', '80.184038,37.074377');
INSERT INTO `rg_region` VALUES ('8122', '8069', '3', '和田县', 'htx', 'hetianxian', '0903', '653221', '79.81907,37.120031');
INSERT INTO `rg_region` VALUES ('8136', '8069', '3', '皮山县', 'psx', 'pishanxian', '0903', '653223', '78.282301,37.616332');
INSERT INTO `rg_region` VALUES ('8158', '8069', '3', '墨玉县', 'myx', 'moyuxian', '0903', '653222', '79.736629,37.271511');
INSERT INTO `rg_region` VALUES ('8176', '8069', '3', '策勒县', 'clx', 'celexian', '0903', '653225', '80.803572,37.001672');
INSERT INTO `rg_region` VALUES ('8186', '7917', '2', '博尔塔拉蒙古自治州', 'botlmgzzz', 'boortalamengguzizhizhou', '0909', '652700', '82.074778,44.903258');
INSERT INTO `rg_region` VALUES ('8187', '8186', '3', '温泉县', 'wqx', 'wenquanxian', '0909', '652723', '81.03099,44.973751');
INSERT INTO `rg_region` VALUES ('8199', '8186', '3', '精河县', 'jhx', 'jinghexian', '0909', '652722', '82.892938,44.605645');
INSERT INTO `rg_region` VALUES ('8209', '8186', '3', '阿拉山口市', 'alsks', 'alashankoushi', '0909', '652702', '82.569389,45.16777');
INSERT INTO `rg_region` VALUES ('8212', '8186', '3', '博乐市', 'bls', 'boleshi', '0909', '652701', '82.072237,44.903087');
INSERT INTO `rg_region` VALUES ('8224', '7917', '2', '铁门关市', 'tmgs', 'tiomenguanshi', '1996', '659006', '85.501218,41.827251');
INSERT INTO `rg_region` VALUES ('8225', '8224', '3', '兵团二十九团', 'btesjt', 'bingtuanershijiutuan', '1996', '659006', '85.5849,41.8825');
INSERT INTO `rg_region` VALUES ('8226', '8224', '3', '农二师三十团', 'nessst', 'nongershisanshituan', '1996', '659006', '85.5849,41.8825');
INSERT INTO `rg_region` VALUES ('8227', '7917', '2', '阿勒泰地区', 'altdq', 'aletaidiqu', '0906', '654300', '88.13963,47.848393');
INSERT INTO `rg_region` VALUES ('8228', '8227', '3', '布尔津县', 'bojx', 'buorjinxian', '0906', '654321', '86.86186,47.70453');
INSERT INTO `rg_region` VALUES ('8236', '8227', '3', '哈巴河县', 'hbhx', 'habahexian', '0906', '654324', '86.418964,48.059284');
INSERT INTO `rg_region` VALUES ('8245', '8227', '3', '吉木乃县', 'jmnx', 'jimunaixian', '0906', '654326', '85.876064,47.434633');
INSERT INTO `rg_region` VALUES ('8254', '8227', '3', '富蕴县', 'fyx', 'fuyunxian', '0906', '654322', '89.524993,46.993106');
INSERT INTO `rg_region` VALUES ('8264', '8227', '3', '青河县', 'qhx', 'qinghexian', '0906', '654325', '90.381561,46.672446');
INSERT INTO `rg_region` VALUES ('8272', '8227', '3', '阿勒泰市', 'alts', 'aletaishi', '0906', '654301', '88.138743,47.848911');
INSERT INTO `rg_region` VALUES ('8289', '8227', '3', '福海县', 'fhx', 'fuhaixian', '0906', '654323', '87.494569,47.113128');
INSERT INTO `rg_region` VALUES ('8300', '7917', '2', '北屯市', 'bts', 'beitunshi', '1906', '659005', '87.824932,47.353177');
INSERT INTO `rg_region` VALUES ('8301', '8300', '3', '兵团一八八团', 'btybbt', 'bingtuanyibabatuan', '1906', '659005', '87.5186,47.4099');
INSERT INTO `rg_region` VALUES ('8302', '8300', '3', '北屯镇', 'btz', 'beitunzhen', '1906', '659005', '87.7224,47.4017');
INSERT INTO `rg_region` VALUES ('8303', '8300', '3', '兵团一八七团', 'btybqt', 'bingtuanyibaqituan', '1906', '659005', '87.761,47.1948');
INSERT INTO `rg_region` VALUES ('8304', '8300', '3', '兵团一八三团', 'btybst', 'bingtuanyibasantuan', '1906', '659005', '88.1187,47.1285');
INSERT INTO `rg_region` VALUES ('8305', '7917', '2', '可克达拉市', 'kkdls', 'kokedalashi', '1999', '659008', '80.63579,43.6832');
INSERT INTO `rg_region` VALUES ('8306', '8305', '3', '兵团六十八团', 'btlsbt', 'bingtuanliushibatuan', '1999', '659008', '80.9903,43.8897');
INSERT INTO `rg_region` VALUES ('8307', '8305', '3', '都拉塔口岸', 'dltka', 'dulatakouan', '1999', '659008', '80.6882,43.7131');
INSERT INTO `rg_region` VALUES ('8308', '8305', '3', '兵团六十七团', 'btlsqt', 'bingtuanliushiqituan', '1999', '659008', '80.6068,43.7652');
INSERT INTO `rg_region` VALUES ('8309', '8305', '3', '兵团六十六团', 'btlslt', 'bingtuanliushiliutuan', '1999', '659008', '81.086,43.9599');
INSERT INTO `rg_region` VALUES ('8310', '8305', '3', '兵团六十四团', 'btlsst', 'bingtuanliushisituan', '1999', '659008', '80.6749,44.0986');
INSERT INTO `rg_region` VALUES ('8311', '8305', '3', '兵团六十三团', 'btlsst', 'bingtuanliushisantuan', '1999', '659008', '80.4844,43.931');
INSERT INTO `rg_region` VALUES ('8312', '7917', '2', '克拉玛依市', 'klmys', 'kelamayishi', '0990', '650200', '84.873946,45.595886');
INSERT INTO `rg_region` VALUES ('8313', '8312', '3', '乌尔禾区', 'wohq', 'wuorhequ', '0990', '650205', '85.697767,46.08776');
INSERT INTO `rg_region` VALUES ('8317', '8312', '3', '白碱滩区', 'bjtq', 'baijiantanqu', '0990', '650204', '85.129882,45.689021');
INSERT INTO `rg_region` VALUES ('8320', '8312', '3', '克拉玛依区', 'klmyq', 'kelamayiqu', '0990', '650203', '84.868918,45.600477');
INSERT INTO `rg_region` VALUES ('8331', '8312', '3', '独山子区', 'dszq', 'dushanziqu', '0990', '650202', '84.882267,44.327207');
INSERT INTO `rg_region` VALUES ('8335', '7917', '2', '五家渠市', 'wjqs', 'wujiaqushi', '1994', '659004', '87.526884,44.167401');
INSERT INTO `rg_region` VALUES ('8336', '8335', '3', '兵团一零二团', 'btylet', 'bingtuanyilingertuan', '1994', '659004', '87.5925,44.2694');
INSERT INTO `rg_region` VALUES ('8337', '8335', '3', '军垦路街道', 'jkljd', 'junkonlujiedao', '1994', '659004', '87.5084,44.1889');
INSERT INTO `rg_region` VALUES ('8338', '8335', '3', '兵团一零一团', 'btylyt', 'bingtuanyilingyituan', '1994', '659004', '87.5562,44.1752');
INSERT INTO `rg_region` VALUES ('8339', '8335', '3', '人民路街道', 'rmljd', 'renminlujiedao', '1994', '659004', '87.5728,44.1822');
INSERT INTO `rg_region` VALUES ('8340', '8335', '3', '兵团一零三团', 'btylst', 'bingtuanyilingsantuan', '1994', '659004', '87.4075,44.5317');
INSERT INTO `rg_region` VALUES ('8341', '8335', '3', '青湖路街道', 'qhljd', 'qinghulujiedao', '1994', '659004', '87.5245,44.1764');
INSERT INTO `rg_region` VALUES ('8342', '7917', '2', '乌鲁木齐市', 'wlmqs', 'wulumuqishi', '0991', '650100', '87.617733,43.792818');
INSERT INTO `rg_region` VALUES ('8343', '8342', '3', '达坂城区', 'dbcq', 'dabanchengqu', '0991', '650107', '88.30994,43.36181');
INSERT INTO `rg_region` VALUES ('8352', '8342', '3', '天山区', 'tsq', 'tianshanqu', '0991', '650102', '87.620116,43.796428');
INSERT INTO `rg_region` VALUES ('8371', '8342', '3', '沙依巴克区', 'sybkq', 'shayibakequ', '0991', '650103', '87.596639,43.788872');
INSERT INTO `rg_region` VALUES ('8389', '8342', '3', '米东区', 'mdq', 'midongqu', '0991', '650109', '87.691801,43.960982');
INSERT INTO `rg_region` VALUES ('8403', '8342', '3', '水磨沟区', 'smgq', 'shuimogouqu', '0991', '650105', '87.613093,43.816747');
INSERT INTO `rg_region` VALUES ('8413', '8342', '3', '新市区', 'xsq', 'xinshiqu', '0991', '650104', '87.560653,43.870882');
INSERT INTO `rg_region` VALUES ('8431', '8342', '3', '乌鲁木齐县', 'wlmqx', 'wulumuqixian', '0991', '650121', '87.505603,43.982546');
INSERT INTO `rg_region` VALUES ('8438', '8342', '3', '头屯河区', 'tthq', 'toutunhequ', '0991', '650106', '87.425823,43.876053');
INSERT INTO `rg_region` VALUES ('8448', '7917', '2', '巴音郭楞蒙古自治州', 'byglmgzzz', 'bayinguolengmengguzizhizhou', '0996', '652800', '86.150969,41.768552');
INSERT INTO `rg_region` VALUES ('8449', '8448', '3', '和静县', 'hjx', 'hejingxian', '0996', '652827', '86.391067,42.31716');
INSERT INTO `rg_region` VALUES ('8467', '8448', '3', '博湖县', 'bhx', 'bohuxian', '0996', '652829', '86.631576,41.980166');
INSERT INTO `rg_region` VALUES ('8476', '8448', '3', '和硕县', 'hsx', 'heshuoxian', '0996', '652828', '86.864947,42.268863');
INSERT INTO `rg_region` VALUES ('8487', '8448', '3', '焉耆回族自治县', 'yqhzzzx', 'yanqihuizuzizhixian', '0996', '652826', '86.5698,42.064349');
INSERT INTO `rg_region` VALUES ('8499', '8448', '3', '若羌县', 'rqx', 'ruoqiangxian', '0996', '652824', '88.168807,39.023807');
INSERT INTO `rg_region` VALUES ('8509', '8448', '3', '且末县', 'qmx', 'qiomoxian', '0996', '652825', '85.532629,38.138562');
INSERT INTO `rg_region` VALUES ('8524', '8448', '3', '库尔勒市', 'kols', 'kuorleshi', '0996', '652801', '86.145948,41.763122');
INSERT INTO `rg_region` VALUES ('8552', '8448', '3', '轮台县', 'ltx', 'luntaixian', '0996', '652822', '84.248542,41.781266');
INSERT INTO `rg_region` VALUES ('8564', '8448', '3', '尉犁县', 'wlx', 'weilixian', '0996', '652823', '86.263412,41.337428');
INSERT INTO `rg_region` VALUES ('8576', '7917', '2', '伊犁哈萨克自治州', 'ylhskzzz', 'yilihasakezizhizhou', '0999', '654000', '81.317946,43.92186');
INSERT INTO `rg_region` VALUES ('8577', '8576', '3', '奎屯市', 'kts', 'kuitunshi', '0999', '654003', '84.901602,44.423445');
INSERT INTO `rg_region` VALUES ('8586', '8576', '3', '伊宁县', 'ynx', 'yiningxian', '0999', '654021', '81.524671,43.977876');
INSERT INTO `rg_region` VALUES ('8608', '8576', '3', '尼勒克县', 'nlkx', 'nilekexian', '0999', '654028', '82.504119,43.789737');
INSERT INTO `rg_region` VALUES ('8623', '8576', '3', '昭苏县', 'zsx', 'zhaosuxian', '0999', '654026', '81.126029,43.157765');
INSERT INTO `rg_region` VALUES ('8641', '8576', '3', '新源县', 'xyx', 'xinyuanxian', '0999', '654025', '83.258493,43.434249');
INSERT INTO `rg_region` VALUES ('8657', '8576', '3', '察布查尔锡伯自治县', 'cbcoxbzzx', 'chabuchaorxibozizhixian', '0999', '654022', '81.150874,43.838883');
INSERT INTO `rg_region` VALUES ('8677', '8576', '3', '伊宁市', 'yns', 'yiningshi', '0999', '654002', '81.316343,43.922209');
INSERT INTO `rg_region` VALUES ('8699', '8576', '3', '巩留县', 'glx', 'gongliuxian', '0999', '654024', '82.227044,43.481618');
INSERT INTO `rg_region` VALUES ('8715', '8576', '3', '特克斯县', 'tksx', 'tekesixian', '0999', '654027', '81.840058,43.214861');
INSERT INTO `rg_region` VALUES ('8727', '8576', '3', '霍城县', 'hcx', 'huochengxian', '0999', '654023', '80.872508,44.049912');
INSERT INTO `rg_region` VALUES ('8741', '8576', '3', '霍尔果斯市', 'hogss', 'huoorguosishi', '0999', '654004', '80.420759,44.201669');
INSERT INTO `rg_region` VALUES ('8750', '7917', '2', '石河子市', 'shzs', 'shihezishi', '0993', '659001', '86.041075,44.305886');
INSERT INTO `rg_region` VALUES ('8751', '8750', '3', '兵团一五二团', 'btywet', 'bingtuanyiwuertuan', '0993', '659001', '86.0704,44.2827');
INSERT INTO `rg_region` VALUES ('8752', '8750', '3', '红山街道', 'hsjd', 'hongshanjiedao', '0993', '659001', '86.048,44.2682');
INSERT INTO `rg_region` VALUES ('8753', '8750', '3', '向阳街道', 'xyjd', 'xiangyangjiedao', '0993', '659001', '86.0397,44.3429');
INSERT INTO `rg_region` VALUES ('8754', '8750', '3', '东城街道', 'dcjd', 'dongchengjiedao', '0993', '659001', '86.0687,44.2873');
INSERT INTO `rg_region` VALUES ('8755', '8750', '3', '老街街道', 'ljjd', 'laojiejiedao', '0993', '659001', '85.9909,44.3496');
INSERT INTO `rg_region` VALUES ('8756', '8750', '3', '石河子乡', 'shzx', 'shihezixiang', '0993', '659001', '86.1022,44.1352');
INSERT INTO `rg_region` VALUES ('8757', '8750', '3', '北泉镇', 'bqz', 'beiquanzhen', '0993', '659001', '86.0983,44.4346');
INSERT INTO `rg_region` VALUES ('8758', '8750', '3', '新城街道', 'xcjd', 'xinchengjiedao', '0993', '659001', '85.9823,44.2893');
INSERT INTO `rg_region` VALUES ('8759', '7917', '2', '昌吉回族自治州', 'cjhzzzz', 'changjihuizuzizhizhou', '0994', '652300', '87.304012,44.014577');
INSERT INTO `rg_region` VALUES ('8760', '8759', '3', '奇台县', 'qtx', 'qitaixian', '0994', '652325', '89.591437,44.021996');
INSERT INTO `rg_region` VALUES ('8778', '8759', '3', '玛纳斯县', 'mnsx', 'manasixian', '0994', '652324', '86.217687,44.305625');
INSERT INTO `rg_region` VALUES ('8799', '8759', '3', '木垒哈萨克自治县', 'mlhskzzx', 'muloihasakezizhixian', '0994', '652328', '90.282833,43.832442');
INSERT INTO `rg_region` VALUES ('8813', '8759', '3', '阜康市', 'fks', 'fukangshi', '0994', '652302', '87.98384,44.152153');
INSERT INTO `rg_region` VALUES ('8827', '8759', '3', '呼图壁县', 'htbx', 'hutubixian', '0994', '652323', '86.888613,44.189342');
INSERT INTO `rg_region` VALUES ('8841', '8759', '3', '昌吉市', 'cjs', 'changjishi', '0994', '652301', '87.304112,44.013183');
INSERT INTO `rg_region` VALUES ('8862', '8759', '3', '吉木萨尔县', 'jmsox', 'jimusaorxian', '0994', '652327', '89.181288,43.997162');
INSERT INTO `rg_region` VALUES ('8874', '7917', '2', '阿拉尔市', 'alos', 'alaorshi', '1997', '659002', '81.285884,40.541914');
INSERT INTO `rg_region` VALUES ('8875', '8874', '3', '阿拉尔农场', 'alonc', 'alaornongchang', '1997', '659002', '81.0627,40.5567');
INSERT INTO `rg_region` VALUES ('8876', '8874', '3', '幸福路街道', 'xfljd', 'xingfulujiedao', '1997', '659002', '81.2681,40.577');
INSERT INTO `rg_region` VALUES ('8877', '8874', '3', '兵团第一师幸福农场', 'btdysxfnc', 'bingtuandiyishixingfunongchang', '1997', '659002', '80.9904,40.7025');
INSERT INTO `rg_region` VALUES ('8878', '8874', '3', '工业园区', 'gyyq', 'gongyeyuanqu', '1997', '659002', '81.2448,40.5461');
INSERT INTO `rg_region` VALUES ('8879', '8874', '3', '兵团七团', 'btqt', 'bingtuanqituan', '1997', '659002', '80.6543,40.6569');
INSERT INTO `rg_region` VALUES ('8880', '8874', '3', '兵团十一团', 'btsyt', 'bingtuanshiyituan', '1997', '659002', '81.5619,40.6277');
INSERT INTO `rg_region` VALUES ('8881', '8874', '3', '托喀依乡', 'tkyx', 'tuokayixiang', '1997', '659002', '81.3541,40.5818');
INSERT INTO `rg_region` VALUES ('8882', '8874', '3', '青松路街道', 'qsljd', 'qingsonglujiedao', '1997', '659002', '81.2545,40.542');
INSERT INTO `rg_region` VALUES ('8883', '8874', '3', '兵团第一师水利水电工程处', 'btdysslsdgcc', 'bingtuandiyishishuilishuidiangongchengchu', '1997', '659002', '81.2858,40.5496');
INSERT INTO `rg_region` VALUES ('8884', '8874', '3', '兵团八团', 'btbt', 'bingtuanbatuan', '1997', '659002', '80.7996,40.5973');
INSERT INTO `rg_region` VALUES ('8885', '8874', '3', '中心监狱', 'zxjy', 'zhongxinjianyu', '1997', '659002', '81.2766,40.6692');
INSERT INTO `rg_region` VALUES ('8886', '8874', '3', '兵团第一师塔里木灌区水利管理处', 'btdystlmgqslglc', 'bingtuandiyishitalimuguanqushuiliguanlichu', '1997', '659002', '81.2876,40.5454');
INSERT INTO `rg_region` VALUES ('8887', '8874', '3', '兵团十四团', 'btsst', 'bingtuanshisituan', '1997', '659002', '81.8688,40.9423');
INSERT INTO `rg_region` VALUES ('8888', '8874', '3', '兵团十三团', 'btsst', 'bingtuanshisantuan', '1997', '659002', '81.4734,40.5742');
INSERT INTO `rg_region` VALUES ('8889', '8874', '3', '兵团十团', 'btst', 'bingtuanshituan', '1997', '659002', '81.259,40.6387');
INSERT INTO `rg_region` VALUES ('8890', '8874', '3', '金银川路街道', 'jycljd', 'jinyinchuanlujiedao', '1997', '659002', '81.2613,40.5355');
INSERT INTO `rg_region` VALUES ('8891', '8874', '3', '兵团十二团', 'btset', 'bingtuanshiertuan', '1997', '659002', '81.1109,40.4977');
INSERT INTO `rg_region` VALUES ('8892', '8874', '3', '兵团十六团', 'btslt', 'bingtuanshiliutuan', '1997', '659002', '80.7871,40.4163');
INSERT INTO `rg_region` VALUES ('8893', '8874', '3', '南口街道', 'nkjd', 'nankoujiedao', '1997', '659002', '81.2988,40.5154');
INSERT INTO `rg_region` VALUES ('8894', '7917', '2', '阿克苏地区', 'aksdq', 'akesudiqu', '0997', '652900', '80.265068,41.170712');
INSERT INTO `rg_region` VALUES ('8895', '8894', '3', '拜城县', 'bcx', 'baichengxian', '0997', '652926', '81.869881,41.796101');
INSERT INTO `rg_region` VALUES ('8912', '8894', '3', '库车县', 'kcx', 'kuchexian', '0997', '652923', '82.96304,41.717141');
INSERT INTO `rg_region` VALUES ('8939', '8894', '3', '温宿县', 'wsx', 'wensuxian', '0997', '652922', '80.243273,41.272995');
INSERT INTO `rg_region` VALUES ('8964', '8894', '3', '新和县', 'xhx', 'xinhexian', '0997', '652925', '82.610828,41.551176');
INSERT INTO `rg_region` VALUES ('8975', '8894', '3', '沙雅县', 'syx', 'shayaxian', '0997', '652924', '82.78077,41.226268');
INSERT INTO `rg_region` VALUES ('8992', '8894', '3', '阿克苏市', 'akss', 'akesushi', '0997', '652901', '80.2629,41.171272');
INSERT INTO `rg_region` VALUES ('9015', '8894', '3', '柯坪县', 'kpx', 'kepingxian', '0997', '652929', '79.04785,40.50624');
INSERT INTO `rg_region` VALUES ('9021', '8894', '3', '阿瓦提县', 'awtx', 'awatixian', '0997', '652928', '80.378426,40.638422');
INSERT INTO `rg_region` VALUES ('9036', '8894', '3', '乌什县', 'wsx', 'wushixian', '0997', '652927', '79.230805,41.21587');
INSERT INTO `rg_region` VALUES ('9047', '7917', '2', '喀什地区', 'ksdq', 'kashidiqu', '0998', '653100', '75.989138,39.467664');
INSERT INTO `rg_region` VALUES ('9048', '9047', '3', '伽师县', 'qsx', 'qieshixian', '0998', '653129', '76.741982,39.494325');
INSERT INTO `rg_region` VALUES ('9063', '9047', '3', '岳普湖县', 'yphx', 'yuepuhuxian', '0998', '653128', '76.7724,39.235248');
INSERT INTO `rg_region` VALUES ('9079', '9047', '3', '麦盖提县', 'mgtx', 'maigaitixian', '0998', '653127', '77.651538,38.903384');
INSERT INTO `rg_region` VALUES ('9096', '9047', '3', '叶城县', 'ycx', 'yechengxian', '0998', '653126', '77.420353,37.884679');
INSERT INTO `rg_region` VALUES ('9126', '9047', '3', '塔什库尔干塔吉克自治县', 'tskogtjkzzx', 'tashikuorgantajikezizhixian', '0998', '653131', '75.228068,37.775437');
INSERT INTO `rg_region` VALUES ('9140', '9047', '3', '疏勒县', 'slx', 'shulexian', '0998', '653122', '76.053653,39.399461');
INSERT INTO `rg_region` VALUES ('9158', '9047', '3', '莎车县', 'scx', 'suochexian', '0998', '653125', '77.248884,38.414499');
INSERT INTO `rg_region` VALUES ('9198', '9047', '3', '泽普县', 'zpx', 'zepuxian', '0998', '653124', '77.273593,38.191217');
INSERT INTO `rg_region` VALUES ('9215', '9047', '3', '巴楚县', 'bcx', 'bachuxian', '0998', '653130', '78.55041,39.783479');
INSERT INTO `rg_region` VALUES ('9229', '9047', '3', '英吉沙县', 'yjsx', 'yingjishaxian', '0998', '653123', '76.174292,38.929839');
INSERT INTO `rg_region` VALUES ('9246', '9047', '3', '疏附县', 'sfx', 'shufuxian', '0998', '653121', '75.863075,39.378306');
INSERT INTO `rg_region` VALUES ('9263', '9047', '3', '喀什市', 'kss', 'kashishi', '0998', '653101', '75.98838,39.467861');
INSERT INTO `rg_region` VALUES ('9281', '7917', '2', '图木舒克市', 'tmsks', 'tumushukeshi', '1998', '659003', '79.077978,39.867316');
INSERT INTO `rg_region` VALUES ('9282', '9281', '3', '兵团四十九团', 'btssjt', 'bingtuansishijiutuan', '1998', '659003', '78.756,39.8224');
INSERT INTO `rg_region` VALUES ('9283', '9281', '3', '兵团图木舒克市永安坝', 'bttmsksyab', 'bingtuantumushukeshiyonganba', '1998', '659003', '79.0133,39.8385');
INSERT INTO `rg_region` VALUES ('9284', '9281', '3', '兵团五十一团', 'btwsyt', 'bingtuanwushiyituan', '1998', '659003', '79.2902,39.9888');
INSERT INTO `rg_region` VALUES ('9285', '9281', '3', '前海街道', 'qhjd', 'qianhaijiedao', '1998', '659003', '79.0778,39.855');
INSERT INTO `rg_region` VALUES ('9286', '9281', '3', '兵团图木舒克市喀拉拜勒镇', 'bttmsksklblz', 'bingtuantumushukeshikalabailezhen', '1998', '659003', '79.0112,39.8526');
INSERT INTO `rg_region` VALUES ('9287', '9281', '3', '永安坝街道', 'yabjd', 'yonganbajiedao', '1998', '659003', '79.0229,39.8507');
INSERT INTO `rg_region` VALUES ('9288', '9281', '3', '齐干却勒街道', 'qgqljd', 'qiganquelejiedao', '1998', '659003', '79.0906,39.8753');
INSERT INTO `rg_region` VALUES ('9289', '9281', '3', '兵团五十三团', 'btwsst', 'bingtuanwushisantuan', '1998', '659003', '79.3214,40.0318');
INSERT INTO `rg_region` VALUES ('9290', '9281', '3', '兵团五十团', 'btwst', 'bingtuanwushituan', '1998', '659003', '79.2315,39.9549');
INSERT INTO `rg_region` VALUES ('9291', '9281', '3', '兵团四十四团', 'btssst', 'bingtuansishisituan', '1998', '659003', '79.1926,39.9168');
INSERT INTO `rg_region` VALUES ('9292', '7917', '2', '哈密市', 'hms', 'hamishi', '0902', '650500', '93.51316,42.833248');
INSERT INTO `rg_region` VALUES ('9293', '9292', '3', '伊州区', 'yzq', 'yizhouqu', '0902', '650502', '93.509174,42.833888');
INSERT INTO `rg_region` VALUES ('9329', '9292', '3', '伊吾县', 'ywx', 'yiwuxian', '0902', '650522', '94.692773,43.252012');
INSERT INTO `rg_region` VALUES ('9338', '9292', '3', '巴里坤哈萨克自治县', 'blkhskzzx', 'balikunhasakezizhixian', '0902', '650521', '93.021795,43.599032');
INSERT INTO `rg_region` VALUES ('9354', '7917', '2', '克孜勒苏柯尔克孜自治州', 'kzlskokzzzz', 'kezilesukeorkezizizhizhou', '0908', '653000', '76.172825,39.713431');
INSERT INTO `rg_region` VALUES ('9355', '9354', '3', '阿图什市', 'atss', 'atushishi', '0908', '653001', '76.173939,39.712898');
INSERT INTO `rg_region` VALUES ('9366', '9354', '3', '乌恰县', 'wqx', 'wuqiaxian', '0908', '653024', '75.25969,39.716633');
INSERT INTO `rg_region` VALUES ('9379', '9354', '3', '阿克陶县', 'aktx', 'aketaoxian', '0908', '653022', '75.945159,39.147079');
INSERT INTO `rg_region` VALUES ('9398', '9354', '3', '阿合奇县', 'ahqx', 'aheqixian', '0908', '653023', '78.450164,40.937567');
INSERT INTO `rg_region` VALUES ('9405', '7917', '2', '吐鲁番市', 'tlfs', 'tulufanshi', '0995', '650400', '89.184078,42.947613');
INSERT INTO `rg_region` VALUES ('9406', '9405', '3', '高昌区', 'gcq', 'gaochangqu', '0995', '650402', '89.182324,42.947627');
INSERT INTO `rg_region` VALUES ('9422', '9405', '3', '鄯善县', 'ssx', 'shanshanxian', '0995', '650421', '90.212692,42.865503');
INSERT INTO `rg_region` VALUES ('9435', '9405', '3', '托克逊县', 'tkxx', 'tuokexunxian', '0995', '650422', '88.655771,42.793536');
INSERT INTO `rg_region` VALUES ('9444', '0', '1', '湖北省', 'hbs', 'hubeisheng', '', '420000', '114.298572,30.584355');
INSERT INTO `rg_region` VALUES ('9445', '9444', '2', '荆门市', 'jms', 'jingmenshi', '0724', '420800', '112.204251,31.03542');
INSERT INTO `rg_region` VALUES ('9446', '9445', '3', '钟祥市', 'zxs', 'zhongxiangshi', '0724', '420881', '112.587267,31.165573');
INSERT INTO `rg_region` VALUES ('9477', '9445', '3', '京山市', 'jss', 'jingshanshi', '0724', '420882', '113.114595,31.022458');
INSERT INTO `rg_region` VALUES ('9500', '9445', '3', '东宝区', 'dbq', 'dongbaoqu', '0724', '420802', '112.204804,31.033461');
INSERT INTO `rg_region` VALUES ('9511', '9445', '3', '掇刀区', 'ddq', 'duodaoqu', '0724', '420804', '112.198413,30.980798');
INSERT INTO `rg_region` VALUES ('9519', '9445', '3', '沙洋县', 'syx', 'shayangxian', '0724', '420822', '112.595218,30.70359');
INSERT INTO `rg_region` VALUES ('9534', '9444', '2', '十堰市', 'sys', 'shiyanshi', '0719', '420300', '110.787916,32.646907');
INSERT INTO `rg_region` VALUES ('9535', '9534', '3', '茅箭区', 'mjq', 'maojianqu', '0719', '420302', '110.78621,32.644463');
INSERT INTO `rg_region` VALUES ('9544', '9534', '3', '张湾区', 'zwq', 'zhangwanqu', '0719', '420303', '110.772365,32.652516');
INSERT INTO `rg_region` VALUES ('9557', '9534', '3', '丹江口市', 'djks', 'danjiangkoushi', '0719', '420381', '111.513793,32.538839');
INSERT INTO `rg_region` VALUES ('9579', '9534', '3', '郧阳区', 'yyq', 'yunyangqu', '0719', '420304', '110.812099,32.838267');
INSERT INTO `rg_region` VALUES ('9600', '9534', '3', '竹溪县', 'zxx', 'zhuxixian', '0719', '420324', '109.717196,32.315342');
INSERT INTO `rg_region` VALUES ('9631', '9534', '3', '竹山县', 'zsx', 'zhushanxian', '0719', '420323', '110.2296,32.22586');
INSERT INTO `rg_region` VALUES ('9649', '9534', '3', '房县', 'fx', 'fangxian', '0719', '420325', '110.741966,32.055002');
INSERT INTO `rg_region` VALUES ('9679', '9534', '3', '郧西县', 'yxx', 'yunxixian', '0719', '420322', '110.426472,32.991457');
INSERT INTO `rg_region` VALUES ('9699', '9444', '2', '黄冈市', 'hgs', 'huanggangshi', '0713', '421100', '114.879365,30.447711');
INSERT INTO `rg_region` VALUES ('9700', '9699', '3', '红安县', 'hax', 'honganxian', '0713', '421122', '114.615095,31.284777');
INSERT INTO `rg_region` VALUES ('9714', '9699', '3', '罗田县', 'ltx', 'luotianxian', '0713', '421123', '115.398984,30.781679');
INSERT INTO `rg_region` VALUES ('9732', '9699', '3', '麻城市', 'mcs', 'machengshi', '0713', '421181', '115.02541,31.177906');
INSERT INTO `rg_region` VALUES ('9762', '9699', '3', '英山县', 'ysx', 'yingshanxian', '0713', '421124', '115.67753,30.735794');
INSERT INTO `rg_region` VALUES ('9778', '9699', '3', '团风县', 'tfx', 'tuanfengxian', '0713', '421121', '114.872029,30.63569');
INSERT INTO `rg_region` VALUES ('9791', '9699', '3', '浠水县', 'xsx', 'xishuixian', '0713', '421125', '115.26344,30.454837');
INSERT INTO `rg_region` VALUES ('9808', '9699', '3', '蕲春县', 'qcx', 'qichunxian', '0713', '421126', '115.433964,30.234927');
INSERT INTO `rg_region` VALUES ('9825', '9699', '3', '黄州区', 'hzq', 'huangzhouqu', '0713', '421102', '114.878934,30.447435');
INSERT INTO `rg_region` VALUES ('9836', '9699', '3', '黄梅县', 'hmx', 'huangmeixian', '0713', '421127', '115.942548,30.075113');
INSERT INTO `rg_region` VALUES ('9864', '9699', '3', '武穴市', 'wxs', 'wuxueshi', '0713', '421182', '115.56242,29.849342');
INSERT INTO `rg_region` VALUES ('9877', '9444', '2', '宜昌市', 'ycs', 'yichangshi', '0717', '420500', '111.290843,30.702636');
INSERT INTO `rg_region` VALUES ('9878', '9877', '3', '兴山县', 'xsx', 'xingshanxian', '0717', '420526', '110.754499,31.34795');
INSERT INTO `rg_region` VALUES ('9887', '9877', '3', '远安县', 'yax', 'yuananxian', '0717', '420525', '111.64331,31.059626');
INSERT INTO `rg_region` VALUES ('9895', '9877', '3', '当阳市', 'dys', 'dangyangshi', '0717', '420582', '111.793419,30.824492');
INSERT INTO `rg_region` VALUES ('9906', '9877', '3', '秭归县', 'zgx', 'ziguixian', '0717', '420527', '110.976785,30.823908');
INSERT INTO `rg_region` VALUES ('9919', '9877', '3', '长阳土家族自治县', 'cytjzzzx', 'changyangtujiazuzizhixian', '0717', '420528', '111.198475,30.466534');
INSERT INTO `rg_region` VALUES ('9931', '9877', '3', '伍家岗区', 'wjgq', 'wujiagangqu', '0717', '420503', '111.307215,30.679053');
INSERT INTO `rg_region` VALUES ('9937', '9877', '3', '点军区', 'djq', 'dianjunqu', '0717', '420504', '111.268163,30.692322');
INSERT INTO `rg_region` VALUES ('9943', '9877', '3', '猇亭区', 'xtq', 'xiaotingqu', '0717', '420505', '111.427642,30.530744');
INSERT INTO `rg_region` VALUES ('9947', '9877', '3', '五峰土家族自治县', 'wftjzzzx', 'wufengtujiazuzizhixian', '0717', '420529', '110.674938,30.199252');
INSERT INTO `rg_region` VALUES ('9956', '9877', '3', '枝江市', 'zjs', 'zhijiangshi', '0717', '420583', '111.751799,30.425364');
INSERT INTO `rg_region` VALUES ('9966', '9877', '3', '宜都市', 'yds', 'yidushi', '0717', '420581', '111.454367,30.387234');
INSERT INTO `rg_region` VALUES ('9978', '9877', '3', '西陵区', 'xlq', 'xilingqu', '0717', '420502', '111.295468,30.702476');
INSERT INTO `rg_region` VALUES ('9991', '9877', '3', '夷陵区', 'ylq', 'yilingqu', '0717', '420506', '111.326747,30.770199');
INSERT INTO `rg_region` VALUES ('10006', '9444', '2', '襄阳市', 'xys', 'xiangyangshi', '0710', '420600', '112.144146,32.042426');
INSERT INTO `rg_region` VALUES ('10007', '10006', '3', '老河口市', 'lhks', 'laohekoushi', '0710', '420682', '111.675732,32.385438');
INSERT INTO `rg_region` VALUES ('10022', '10006', '3', '枣阳市', 'zys', 'zaoyangshi', '0710', '420683', '112.765268,32.123083');
INSERT INTO `rg_region` VALUES ('10041', '10006', '3', '谷城县', 'gcx', 'guchengxian', '0710', '420625', '111.640147,32.262676');
INSERT INTO `rg_region` VALUES ('10053', '10006', '3', '南漳县', 'nzx', 'nanzhangxian', '0710', '420624', '111.844424,31.77692');
INSERT INTO `rg_region` VALUES ('10065', '10006', '3', '保康县', 'bkx', 'baokangxian', '0710', '420626', '111.262235,31.873507');
INSERT INTO `rg_region` VALUES ('10078', '10006', '3', '襄州区', 'xzq', 'xiangzhouqu', '0710', '420607', '112.197378,32.085517');
INSERT INTO `rg_region` VALUES ('10096', '10006', '3', '宜城市', 'ycs', 'yichengshi', '0710', '420684', '112.261441,31.709203');
INSERT INTO `rg_region` VALUES ('10111', '10006', '3', '樊城区', 'fcq', 'fanchengqu', '0710', '420606', '112.13957,32.058589');
INSERT INTO `rg_region` VALUES ('10132', '10006', '3', '襄城区', 'xcq', 'xiangchengqu', '0710', '420602', '112.150327,32.015088');
INSERT INTO `rg_region` VALUES ('10142', '9444', '2', '武汉市', 'whs', 'wuhanshi', '027', '420100', '114.298572,30.584355');
INSERT INTO `rg_region` VALUES ('10143', '10142', '3', '黄陂区', 'hbq', 'huangbeiqu', '027', '420116', '114.374025,30.874155');
INSERT INTO `rg_region` VALUES ('10164', '10142', '3', '新洲区', 'xzq', 'xinzhouqu', '027', '420117', '114.802108,30.842149');
INSERT INTO `rg_region` VALUES ('10181', '10142', '3', '江岸区', 'jaq', 'jianganqu', '027', '420102', '114.30304,30.594911');
INSERT INTO `rg_region` VALUES ('10199', '10142', '3', '汉南区', 'hnq', 'hannanqu', '027', '420113', '114.08124,30.309637');
INSERT INTO `rg_region` VALUES ('10204', '10142', '3', '蔡甸区', 'cdq', 'caidianqu', '027', '420114', '114.029341,30.582186');
INSERT INTO `rg_region` VALUES ('10224', '10142', '3', '江汉区', 'jhq', 'jianghanqu', '027', '420103', '114.283109,30.578771');
INSERT INTO `rg_region` VALUES ('10239', '10142', '3', '青山区', 'qsq', 'qingshanqu', '027', '420107', '114.39707,30.634215');
INSERT INTO `rg_region` VALUES ('10257', '10142', '3', '武昌区', 'wcq', 'wuchangqu', '027', '420106', '114.307344,30.546536');
INSERT INTO `rg_region` VALUES ('10273', '10142', '3', '江夏区', 'jxq', 'jiangxiaqu', '027', '420115', '114.313961,30.349045');
INSERT INTO `rg_region` VALUES ('10294', '10142', '3', '汉阳区', 'hyq', 'hanyangqu', '027', '420105', '114.265807,30.549326');
INSERT INTO `rg_region` VALUES ('10305', '10142', '3', '洪山区', 'hsq', 'hongshanqu', '027', '420111', '114.400718,30.504259');
INSERT INTO `rg_region` VALUES ('10323', '10142', '3', '东西湖区', 'dxhq', 'dongxihuqu', '027', '420112', '114.142483,30.622467');
INSERT INTO `rg_region` VALUES ('10341', '10142', '3', '硚口区', 'qkq', 'qiaokouqu', '027', '420104', '114.264568,30.57061');
INSERT INTO `rg_region` VALUES ('10353', '9444', '2', '恩施土家族苗族自治州', 'estjzmzzzz', 'enshitujiazumiaozuzizhizhou', '0718', '422800', '109.48699,30.283114');
INSERT INTO `rg_region` VALUES ('10354', '10353', '3', '建始县', 'jsx', 'jianshixian', '0718', '422822', '109.723822,30.601632');
INSERT INTO `rg_region` VALUES ('10365', '10353', '3', '恩施市', 'ess', 'enshishi', '0718', '422801', '109.486761,30.282406');
INSERT INTO `rg_region` VALUES ('10383', '10353', '3', '利川市', 'lcs', 'lichuanshi', '0718', '422802', '108.943491,30.294247');
INSERT INTO `rg_region` VALUES ('10399', '10353', '3', '鹤峰县', 'hfx', 'hefengxian', '0718', '422828', '110.033699,29.887298');
INSERT INTO `rg_region` VALUES ('10409', '10353', '3', '来凤县', 'lfx', 'laifengxian', '0718', '422827', '109.408328,29.506945');
INSERT INTO `rg_region` VALUES ('10418', '10353', '3', '宣恩县', 'xex', 'xuanenxian', '0718', '422825', '109.482819,29.98867');
INSERT INTO `rg_region` VALUES ('10428', '10353', '3', '巴东县', 'bdx', 'badongxian', '0718', '422823', '110.336665,31.041403');
INSERT INTO `rg_region` VALUES ('10441', '10353', '3', '咸丰县', 'xfx', 'xianfengxian', '0718', '422826', '109.15041,29.678967');
INSERT INTO `rg_region` VALUES ('10453', '9444', '2', '咸宁市', 'xns', 'xianningshi', '0715', '421200', '114.328963,29.832798');
INSERT INTO `rg_region` VALUES ('10454', '10453', '3', '嘉鱼县', 'jyx', 'jiayuxian', '0715', '421221', '113.921547,29.973363');
INSERT INTO `rg_region` VALUES ('10465', '10453', '3', '咸安区', 'xaq', 'xiananqu', '0715', '421202', '114.333894,29.824716');
INSERT INTO `rg_region` VALUES ('10482', '10453', '3', '崇阳县', 'cyx', 'chongyangxian', '0715', '421223', '114.049958,29.54101');
INSERT INTO `rg_region` VALUES ('10496', '10453', '3', '通山县', 'tsx', 'tongshanxian', '0715', '421224', '114.493163,29.604455');
INSERT INTO `rg_region` VALUES ('10511', '10453', '3', '赤壁市', 'cbs', 'chibishi', '0715', '421281', '113.88366,29.716879');
INSERT INTO `rg_region` VALUES ('10531', '10453', '3', '通城县', 'tcx', 'tongchengxian', '0715', '421222', '113.814131,29.246076');
INSERT INTO `rg_region` VALUES ('10548', '9444', '2', '神农架林区', 'snjlq', 'shennongjialinqu', '1719', '429021', '110.671525,31.744449');
INSERT INTO `rg_region` VALUES ('10549', '10548', '3', '木鱼镇', 'myz', 'muyuzhen', '1719', '429021', '110.312,31.3933');
INSERT INTO `rg_region` VALUES ('10550', '10548', '3', '下谷坪土家族乡', 'xgptjzx', 'xiagupingtujiazuxiang', '1719', '429021', '110.113,31.4153');
INSERT INTO `rg_region` VALUES ('10551', '10548', '3', '新华镇', 'xhz', 'xinhuazhen', '1719', '429021', '110.842,31.6218');
INSERT INTO `rg_region` VALUES ('10552', '10548', '3', '九湖镇', 'jhz', 'jiuhuzhen', '1719', '429021', '110.062,31.4095');
INSERT INTO `rg_region` VALUES ('10553', '10548', '3', '宋洛乡', 'slx', 'songluoxiang', '1719', '429021', '110.59,31.7303');
INSERT INTO `rg_region` VALUES ('10554', '10548', '3', '松柏镇', 'sbz', 'songbaizhen', '1719', '429021', '110.609,31.7041');
INSERT INTO `rg_region` VALUES ('10555', '10548', '3', '红坪镇', 'hpz', 'hongpingzhen', '1719', '429021', '110.196,31.4718');
INSERT INTO `rg_region` VALUES ('10556', '10548', '3', '阳日镇', 'yrz', 'yangrizhen', '1719', '429021', '110.763,31.677');
INSERT INTO `rg_region` VALUES ('10557', '9444', '2', '孝感市', 'xgs', 'xiaoganshi', '0712', '420900', '113.926655,30.926423');
INSERT INTO `rg_region` VALUES ('10558', '10557', '3', '大悟县', 'dwx', 'dawuxian', '0712', '420922', '114.126249,31.565483');
INSERT INTO `rg_region` VALUES ('10576', '10557', '3', '安陆市', 'als', 'anlushi', '0712', '420982', '113.690401,31.26174');
INSERT INTO `rg_region` VALUES ('10593', '10557', '3', '应城市', 'ycs', 'yingchengshi', '0712', '420981', '113.573842,30.939038');
INSERT INTO `rg_region` VALUES ('10611', '10557', '3', '云梦县', 'ymx', 'yunmengxian', '0712', '420923', '113.750616,31.021691');
INSERT INTO `rg_region` VALUES ('10625', '10557', '3', '孝南区', 'xnq', 'xiaonanqu', '0712', '420902', '113.925849,30.925966');
INSERT INTO `rg_region` VALUES ('10647', '10557', '3', '汉川市', 'hcs', 'hanchuanshi', '0712', '420984', '113.835301,30.652165');
INSERT INTO `rg_region` VALUES ('10675', '10557', '3', '孝昌县', 'xcx', 'xiaochangxian', '0712', '420921', '113.988964,31.251618');
INSERT INTO `rg_region` VALUES ('10691', '9444', '2', '潜江市', 'qjs', 'qianjiangshi', '2728', '429005', '112.896866,30.421215');
INSERT INTO `rg_region` VALUES ('10692', '10691', '3', '积玉口镇', 'jykz', 'jiyukouzhen', '2728', '429005', '112.721,30.4185');
INSERT INTO `rg_region` VALUES ('10693', '10691', '3', '广华街道', 'ghjd', 'guanghuajiedao', '2728', '429005', '112.666,30.4633');
INSERT INTO `rg_region` VALUES ('10694', '10691', '3', '泰丰街道', 'tfjd', 'taifengjiedao', '2728', '429005', '112.981,30.4167');
INSERT INTO `rg_region` VALUES ('10695', '10691', '3', '潜江经济开发区', 'qjjjkfq', 'qianjiangjingjikaifaqu', '2728', '429005', '112.883,30.4825');
INSERT INTO `rg_region` VALUES ('10696', '10691', '3', '周矶管理区', 'zjglq', 'zhoujiguanliqu', '2728', '429005', '112.826,30.4567');
INSERT INTO `rg_region` VALUES ('10697', '10691', '3', '周矶街道', 'zjjd', 'zhoujijiedao', '2728', '429005', '112.818,30.4576');
INSERT INTO `rg_region` VALUES ('10698', '10691', '3', '高场街道', 'gcjd', 'gaochangjiedao', '2728', '429005', '112.775,30.4076');
INSERT INTO `rg_region` VALUES ('10699', '10691', '3', '总口管理区', 'zkglq', 'zongkouguanliqu', '2728', '429005', '112.89,30.2581');
INSERT INTO `rg_region` VALUES ('10700', '10691', '3', '运粮湖管理区', 'ylhglq', 'yunlianghuguanliqu', '2728', '429005', '112.582,30.252');
INSERT INTO `rg_region` VALUES ('10701', '10691', '3', '王场镇', 'wcz', 'wangchangzhen', '2728', '429005', '112.819,30.4906');
INSERT INTO `rg_region` VALUES ('10702', '10691', '3', '竹根滩镇', 'zgtz', 'zhugentanzhen', '2728', '429005', '112.979,30.4716');
INSERT INTO `rg_region` VALUES ('10703', '10691', '3', '白鹭湖管理区', 'blhglq', 'bailuhuguanliqu', '2728', '429005', '112.716,30.1788');
INSERT INTO `rg_region` VALUES ('10704', '10691', '3', '园林街道', 'yljd', 'yuanlinjiedao', '2728', '429005', '112.91,30.377');
INSERT INTO `rg_region` VALUES ('10705', '10691', '3', '渔洋镇', 'yyz', 'yuyangzhen', '2728', '429005', '112.966,30.2392');
INSERT INTO `rg_region` VALUES ('10706', '10691', '3', '熊口镇', 'xkz', 'xiongkouzhen', '2728', '429005', '112.724,30.3404');
INSERT INTO `rg_region` VALUES ('10707', '10691', '3', '后湖管理区', 'hhglq', 'houhuguanliqu', '2728', '429005', '112.768,30.4049');
INSERT INTO `rg_region` VALUES ('10708', '10691', '3', '熊口管理区', 'xkglq', 'xiongkouguanliqu', '2728', '429005', '112.802,30.195');
INSERT INTO `rg_region` VALUES ('10709', '10691', '3', '江汉石油管理局', 'jhsyglj', 'jianghanshiyouguanliju', '2728', '429005', '112.793,30.4635');
INSERT INTO `rg_region` VALUES ('10710', '10691', '3', '张金镇', 'zjz', 'zhangjinzhen', '2728', '429005', '112.577,30.2389');
INSERT INTO `rg_region` VALUES ('10711', '10691', '3', '杨市街道', 'ysjd', 'yangshijiedao', '2728', '429005', '112.915,30.3835');
INSERT INTO `rg_region` VALUES ('10712', '10691', '3', '高石碑镇', 'gsbz', 'gaoshibeizhen', '2728', '429005', '112.626,30.6203');
INSERT INTO `rg_region` VALUES ('10713', '10691', '3', '浩口原种场', 'hkyzc', 'haokouyuanzhongchang', '2728', '429005', '112.643,30.3784');
INSERT INTO `rg_region` VALUES ('10714', '10691', '3', '浩口镇', 'hkz', 'haokouzhen', '2728', '429005', '112.65,30.3695');
INSERT INTO `rg_region` VALUES ('10715', '10691', '3', '老新镇', 'lxz', 'laoxinzhen', '2728', '429005', '112.81,30.2185');
INSERT INTO `rg_region` VALUES ('10716', '10691', '3', '龙湾镇', 'lwz', 'longwanzhen', '2728', '429005', '112.69,30.2848');
INSERT INTO `rg_region` VALUES ('10717', '9444', '2', '随州市', 'szs', 'suizhoushi', '0722', '421300', '113.37377,31.717497');
INSERT INTO `rg_region` VALUES ('10718', '10717', '3', '广水市', 'gss', 'guangshuishi', '0722', '421381', '113.826601,31.617731');
INSERT INTO `rg_region` VALUES ('10738', '10717', '3', '曾都区', 'zdq', 'zengduqu', '0722', '421303', '113.374519,31.717521');
INSERT INTO `rg_region` VALUES ('10751', '10717', '3', '随县', 'sx', 'suixian', '0722', '421321', '113.301384,31.854246');
INSERT INTO `rg_region` VALUES ('10771', '9444', '2', '荆州市', 'jzs', 'jingzhoushi', '0716', '421000', '112.23813,30.326857');
INSERT INTO `rg_region` VALUES ('10772', '10771', '3', '荆州区', 'jzq', 'jingzhouqu', '0716', '421003', '112.195354,30.350674');
INSERT INTO `rg_region` VALUES ('10785', '10771', '3', '江陵县', 'jlx', 'jianglingxian', '0716', '421024', '112.41735,30.033919');
INSERT INTO `rg_region` VALUES ('10799', '10771', '3', '洪湖市', 'hhs', 'honghushi', '0716', '421083', '113.470304,29.81297');
INSERT INTO `rg_region` VALUES ('10820', '10771', '3', '监利县', 'jlx', 'jianlixian', '0716', '421023', '112.904344,29.820079');
INSERT INTO `rg_region` VALUES ('10844', '10771', '3', '石首市', 'sss', 'shishoushi', '0716', '421081', '112.40887,29.716437');
INSERT INTO `rg_region` VALUES ('10860', '10771', '3', '松滋市', 'szs', 'songzishi', '0716', '421087', '111.77818,30.176037');
INSERT INTO `rg_region` VALUES ('10877', '10771', '3', '沙市区', 'ssq', 'shashiqu', '0716', '421002', '112.257433,30.315895');
INSERT INTO `rg_region` VALUES ('10891', '10771', '3', '公安县', 'gax', 'gonganxian', '0716', '421022', '112.230179,30.059065');
INSERT INTO `rg_region` VALUES ('10908', '9444', '2', '天门市', 'tms', 'tianmenshi', '1728', '429006', '113.165862,30.653061');
INSERT INTO `rg_region` VALUES ('10909', '10908', '3', '胡市镇', 'hsz', 'hushizhen', '1728', '429006', '113.422,30.802');
INSERT INTO `rg_region` VALUES ('10910', '10908', '3', '多祥镇', 'dxz', 'duoxiangzhen', '1728', '429006', '113.331,30.4446');
INSERT INTO `rg_region` VALUES ('10911', '10908', '3', '黄潭镇', 'htz', 'huangtanzhen', '1728', '429006', '113.039,30.6922');
INSERT INTO `rg_region` VALUES ('10912', '10908', '3', '沉湖管委会', 'chgwh', 'chenhuguanwoihui', '1728', '429006', '113.444,30.4698');
INSERT INTO `rg_region` VALUES ('10913', '10908', '3', '干驿镇', 'gyz', 'ganyizhen', '1728', '429006', '113.451,30.503');
INSERT INTO `rg_region` VALUES ('10914', '10908', '3', '横林镇', 'hlz', 'henglinzhen', '1728', '429006', '113.215,30.5643');
INSERT INTO `rg_region` VALUES ('10915', '10908', '3', '马湾镇', 'mwz', 'mawanzhen', '1728', '429006', '113.312,30.5993');
INSERT INTO `rg_region` VALUES ('10916', '10908', '3', '小板镇', 'xbz', 'xiaobanzhen', '1728', '429006', '113.264,30.6151');
INSERT INTO `rg_region` VALUES ('10917', '10908', '3', '蒋湖农场', 'jhnc', 'jianghunongchang', '1728', '429006', '112.802,30.6364');
INSERT INTO `rg_region` VALUES ('10918', '10908', '3', '岳口镇', 'ykz', 'yuekouzhen', '1728', '429006', '113.105,30.5868');
INSERT INTO `rg_region` VALUES ('10919', '10908', '3', '多宝镇', 'dbz', 'duobaozhen', '1728', '429006', '112.614,30.7034');
INSERT INTO `rg_region` VALUES ('10920', '10908', '3', '蒋场镇', 'jcz', 'jiangchangzhen', '1728', '429006', '112.927,30.646');
INSERT INTO `rg_region` VALUES ('10921', '10908', '3', '石家河镇', 'sjhz', 'shijiahezhen', '1728', '429006', '113.076,30.8211');
INSERT INTO `rg_region` VALUES ('10922', '10908', '3', '彭市镇', 'psz', 'pengshizhen', '1728', '429006', '113.157,30.4315');
INSERT INTO `rg_region` VALUES ('10923', '10908', '3', '佛子山镇', 'fzsz', 'fozishanzhen', '1728', '429006', '112.974,30.7608');
INSERT INTO `rg_region` VALUES ('10924', '10908', '3', '九真镇', 'jzz', 'jiuzhenzhen', '1728', '429006', '113.206,30.8245');
INSERT INTO `rg_region` VALUES ('10925', '10908', '3', '侨乡街道开发区', 'qxjdkfq', 'qiaoxiangjiedaokaifaqu', '1728', '429006', '113.134,30.652');
INSERT INTO `rg_region` VALUES ('10926', '10908', '3', '竟陵街道', 'jljd', 'jinglingjiedao', '1728', '429006', '113.183,30.7066');
INSERT INTO `rg_region` VALUES ('10927', '10908', '3', '麻洋镇', 'myz', 'mayangzhen', '1728', '429006', '113.309,30.5249');
INSERT INTO `rg_region` VALUES ('10928', '10908', '3', '杨林街道', 'yljd', 'yanglinjiedao', '1728', '429006', '113.265,30.6856');
INSERT INTO `rg_region` VALUES ('10929', '10908', '3', '白茅湖农场', 'bmhnc', 'baimaohunongchang', '1728', '429006', '113.063,30.5868');
INSERT INTO `rg_region` VALUES ('10930', '10908', '3', '汪场镇', 'wcz', 'wangchangzhen', '1728', '429006', '112.979,30.638');
INSERT INTO `rg_region` VALUES ('10931', '10908', '3', '张港镇', 'zgz', 'zhanggangzhen', '1728', '429006', '112.801,30.5529');
INSERT INTO `rg_region` VALUES ('10932', '10908', '3', '渔薪镇', 'yxz', 'yuxinzhen', '1728', '429006', '112.879,30.6744');
INSERT INTO `rg_region` VALUES ('10933', '10908', '3', '拖市镇', 'tsz', 'tuoshizhen', '1728', '429006', '112.856,30.7135');
INSERT INTO `rg_region` VALUES ('10934', '10908', '3', '皂市镇', 'zsz', 'zaoshizhen', '1728', '429006', '113.223,30.7957');
INSERT INTO `rg_region` VALUES ('10935', '10908', '3', '卢市镇', 'lsz', 'lushizhen', '1728', '429006', '113.397,30.6596');
INSERT INTO `rg_region` VALUES ('10936', '10908', '3', '净潭乡', 'jtx', 'jingtanxiang', '1728', '429006', '113.451,30.6464');
INSERT INTO `rg_region` VALUES ('10937', '9444', '2', '仙桃市', 'xts', 'xiantaoshi', '0728', '429004', '113.453974,30.364953');
INSERT INTO `rg_region` VALUES ('10938', '10937', '3', '畜禽良种场', 'xqlzc', 'xuqinliangzhongchang', '0728', '429004', '113.751,30.1779');
INSERT INTO `rg_region` VALUES ('10939', '10937', '3', '豆河镇', 'dhz', 'douhezhen', '0728', '429004', '113,30.37');
INSERT INTO `rg_region` VALUES ('10940', '10937', '3', '沙湖镇', 'shz', 'shahuzhen', '0728', '429004', '113.6,30.1698');
INSERT INTO `rg_region` VALUES ('10941', '10937', '3', '工业园区', 'gyyq', 'gongyeyuanqu', '0728', '429004', '113.413,30.3233');
INSERT INTO `rg_region` VALUES ('10942', '10937', '3', '通海口镇', 'thkz', 'tonghaikouzhen', '0728', '429004', '113.206,30.2722');
INSERT INTO `rg_region` VALUES ('10943', '10937', '3', '胡场镇', 'hcz', 'huchangzhen', '0728', '429004', '113.29,30.4278');
INSERT INTO `rg_region` VALUES ('10944', '10937', '3', '长倘口镇', 'ctkz', 'changtangkouzhen', '0728', '429004', '113.611,30.4752');
INSERT INTO `rg_region` VALUES ('10945', '10937', '3', '五湖渔场', 'whyc', 'wuhuyuchang', '0728', '429004', '113.783,30.161');
INSERT INTO `rg_region` VALUES ('10946', '10937', '3', '干河街道', 'ghjd', 'ganhejiedao', '0728', '429004', '113.451,30.3772');
INSERT INTO `rg_region` VALUES ('10947', '10937', '3', '杨林尾镇', 'ylwz', 'yanglinwoizhen', '0728', '429004', '113.561,30.2014');
INSERT INTO `rg_region` VALUES ('10948', '10937', '3', '西流河镇', 'xlhz', 'xiliuhezhen', '0728', '429004', '113.761,30.297');
INSERT INTO `rg_region` VALUES ('10949', '10937', '3', '赵西垸林场', 'zxylc', 'zhaoxiyuanlinchang', '0728', '429004', '113.027,30.285');
INSERT INTO `rg_region` VALUES ('10950', '10937', '3', '九合垸原种场', 'jhyyzc', 'jiuheyuanyuanzhongchang', '0728', '429004', '113.006,30.2473');
INSERT INTO `rg_region` VALUES ('10951', '10937', '3', '彭场镇', 'pcz', 'pengchangzhen', '0728', '429004', '113.446,30.2518');
INSERT INTO `rg_region` VALUES ('10952', '10937', '3', '沔城回族镇', 'mchzz', 'mianchenghuizuzhen', '0728', '429004', '113.201,30.1921');
INSERT INTO `rg_region` VALUES ('10953', '10937', '3', '龙华山街道', 'lhsjd', 'longhuashanjiedao', '0728', '429004', '113.46,30.3649');
INSERT INTO `rg_region` VALUES ('10954', '10937', '3', '沙湖原种场', 'shyzc', 'shahuyuanzhongchang', '0728', '429004', '113.643,30.1482');
INSERT INTO `rg_region` VALUES ('10955', '10937', '3', '陈场镇', 'ccz', 'chenchangzhen', '0728', '429004', '113.111,30.2879');
INSERT INTO `rg_region` VALUES ('10956', '10937', '3', '郑场镇', 'zcz', 'zhengchangzhen', '0728', '429004', '112.979,30.4707');
INSERT INTO `rg_region` VALUES ('10957', '10937', '3', '郭河镇', 'ghz', 'guohezhen', '0728', '429004', '113.304,30.3027');
INSERT INTO `rg_region` VALUES ('10958', '10937', '3', '排湖风景区', 'phfjq', 'paihufengjingqu', '0728', '429004', '113.223,30.2987');
INSERT INTO `rg_region` VALUES ('10959', '10937', '3', '沙嘴街道', 'szjd', 'shazuijiedao', '0728', '429004', '113.441,30.3596');
INSERT INTO `rg_region` VALUES ('10960', '10937', '3', '毛嘴镇', 'mzz', 'maozuizhen', '0728', '429004', '113.045,30.4188');
INSERT INTO `rg_region` VALUES ('10961', '10937', '3', '张沟镇', 'zgz', 'zhanggouzhen', '0728', '429004', '113.438,30.2968');
INSERT INTO `rg_region` VALUES ('10962', '10937', '3', '三伏潭镇', 'sftz', 'sanfutanzhen', '0728', '429004', '113.207,30.3395');
INSERT INTO `rg_region` VALUES ('10963', '9444', '2', '黄石市', 'hss', 'huangshishi', '0714', '420200', '115.077048,30.220074');
INSERT INTO `rg_region` VALUES ('10964', '10963', '3', '西塞山区', 'xssq', 'xisaishanqu', '0714', '420203', '115.093354,30.205365');
INSERT INTO `rg_region` VALUES ('10967', '10963', '3', '下陆区', 'xlq', 'xialuqu', '0714', '420204', '114.975755,30.177845');
INSERT INTO `rg_region` VALUES ('10972', '10963', '3', '铁山区', 'tsq', 'tioshanqu', '0714', '420205', '114.901366,30.20601');
INSERT INTO `rg_region` VALUES ('10974', '10963', '3', '阳新县', 'yxx', 'yangxinxian', '0714', '420222', '115.212883,29.841572');
INSERT INTO `rg_region` VALUES ('10997', '10963', '3', '大冶市', 'dys', 'dayoshi', '0714', '420281', '114.974842,30.098804');
INSERT INTO `rg_region` VALUES ('11015', '10963', '3', '黄石港区', 'hsgq', 'huangshigangqu', '0714', '420202', '115.090164,30.212086');
INSERT INTO `rg_region` VALUES ('11018', '9444', '2', '鄂州市', 'ezs', 'ezhoushi', '0711', '420700', '114.890593,30.396536');
INSERT INTO `rg_region` VALUES ('11019', '11018', '3', '华容区', 'hrq', 'huarongqu', '0711', '420703', '114.74148,30.534468');
INSERT INTO `rg_region` VALUES ('11027', '11018', '3', '梁子湖区', 'lzhq', 'liangzihuqu', '0711', '420702', '114.681967,30.098191');
INSERT INTO `rg_region` VALUES ('11034', '11018', '3', '鄂城区', 'ecq', 'echengqu', '0711', '420704', '114.890012,30.39669');
INSERT INTO `rg_region` VALUES ('11049', '0', '1', '辽宁省', 'lns', 'liaoningsheng', '', '210000', '123.429096,41.796767');
INSERT INTO `rg_region` VALUES ('11050', '11049', '2', '葫芦岛市', 'hlds', 'huludaoshi', '0429', '211400', '120.856394,40.755572');
INSERT INTO `rg_region` VALUES ('11051', '11050', '3', '建昌县', 'jcx', 'jianchangxian', '0429', '211422', '119.807776,40.812871');
INSERT INTO `rg_region` VALUES ('11080', '11050', '3', '兴城市', 'xcs', 'xingchengshi', '0429', '211481', '120.729365,40.619413');
INSERT INTO `rg_region` VALUES ('11108', '11050', '3', '龙港区', 'lgq', 'longgangqu', '0429', '211403', '120.838569,40.709991');
INSERT INTO `rg_region` VALUES ('11122', '11050', '3', '绥中县', 'szx', 'suizhongxian', '0429', '211421', '120.342112,40.328407');
INSERT INTO `rg_region` VALUES ('11150', '11050', '3', '南票区', 'npq', 'nanpiaoqu', '0429', '211404', '120.752314,41.098813');
INSERT INTO `rg_region` VALUES ('11168', '11050', '3', '连山区', 'lsq', 'lianshanqu', '0429', '211402', '120.85937,40.755143');
INSERT INTO `rg_region` VALUES ('11188', '11049', '2', '大连市', 'dls', 'dalianshi', '0411', '210200', '121.618622,38.91459');
INSERT INTO `rg_region` VALUES ('11189', '11188', '3', '金州区', 'jzq', 'jinzhouqu', '0411', '210213', '121.789413,39.052745');
INSERT INTO `rg_region` VALUES ('11217', '11188', '3', '庄河市', 'zhs', 'zhuangheshi', '0411', '210283', '122.970612,39.69829');
INSERT INTO `rg_region` VALUES ('11244', '11188', '3', '长海县', 'chx', 'changhaixian', '0411', '210224', '122.587824,39.272399');
INSERT INTO `rg_region` VALUES ('11250', '11188', '3', '甘井子区', 'gjzq', 'ganjingziqu', '0411', '210211', '121.582614,38.975148');
INSERT INTO `rg_region` VALUES ('11267', '11188', '3', '瓦房店市', 'wfds', 'wafangdianshi', '0411', '210281', '122.002656,39.63065');
INSERT INTO `rg_region` VALUES ('11300', '11188', '3', '普兰店区', 'pldq', 'pulandianqu', '0411', '210214', '121.9705,39.401555');
INSERT INTO `rg_region` VALUES ('11320', '11188', '3', '西岗区', 'xgq', 'xigangqu', '0411', '210203', '121.616112,38.914266');
INSERT INTO `rg_region` VALUES ('11328', '11188', '3', '中山区', 'zsq', 'zhongshanqu', '0411', '210202', '121.64376,38.921553');
INSERT INTO `rg_region` VALUES ('11337', '11188', '3', '旅顺口区', 'lskq', 'lushunkouqu', '0411', '210212', '121.26713,38.812043');
INSERT INTO `rg_region` VALUES ('11353', '11188', '3', '沙河口区', 'shkq', 'shahekouqu', '0411', '210204', '121.593702,38.912859');
INSERT INTO `rg_region` VALUES ('11363', '11049', '2', '丹东市', 'dds', 'dandongshi', '0415', '210600', '124.383044,40.124296');
INSERT INTO `rg_region` VALUES ('11364', '11363', '3', '凤城市', 'fcs', 'fengchengshi', '0415', '210682', '124.071067,40.457567');
INSERT INTO `rg_region` VALUES ('11386', '11363', '3', '东港市', 'dgs', 'donggangshi', '0415', '210681', '124.149437,39.883467');
INSERT INTO `rg_region` VALUES ('11410', '11363', '3', '振安区', 'zaq', 'zhenanqu', '0415', '210604', '124.427709,40.158557');
INSERT INTO `rg_region` VALUES ('11420', '11363', '3', '振兴区', 'zxq', 'zhenxingqu', '0415', '210603', '124.361153,40.102801');
INSERT INTO `rg_region` VALUES ('11434', '11363', '3', '元宝区', 'ybq', 'yuanbaoqu', '0415', '210602', '124.397814,40.136483');
INSERT INTO `rg_region` VALUES ('11442', '11363', '3', '宽甸满族自治县', 'kdmzzzx', 'kuandianmanzuzizhixian', '0415', '210624', '124.784867,40.730412');
INSERT INTO `rg_region` VALUES ('11465', '11049', '2', '朝阳市', 'cys', 'chaoyangshi', '0421', '211300', '120.451176,41.576758');
INSERT INTO `rg_region` VALUES ('11466', '11465', '3', '建平县', 'jpx', 'jianpingxian', '0421', '211322', '119.642363,41.402576');
INSERT INTO `rg_region` VALUES ('11498', '11465', '3', '北票市', 'bps', 'beipiaoshi', '0421', '211381', '120.766951,41.803286');
INSERT INTO `rg_region` VALUES ('11536', '11465', '3', '双塔区', 'stq', 'shuangtaqu', '0421', '211302', '120.44877,41.579389');
INSERT INTO `rg_region` VALUES ('11552', '11465', '3', '龙城区', 'lcq', 'longchengqu', '0421', '211303', '120.413376,41.576749');
INSERT INTO `rg_region` VALUES ('11565', '11465', '3', '朝阳县', 'cyx', 'chaoyangxian', '0421', '211321', '120.404217,41.526342');
INSERT INTO `rg_region` VALUES ('11594', '11465', '3', '凌源市', 'lys', 'lingyuanshi', '0421', '211382', '119.404789,41.243086');
INSERT INTO `rg_region` VALUES ('11625', '11465', '3', '喀喇沁左翼蒙古族自治县', 'klqzymgzzzx', 'kalaqinzuoyimengguzuzizhixian', '0421', '211324', '119.744883,41.125428');
INSERT INTO `rg_region` VALUES ('11649', '11049', '2', '锦州市', 'jzs', 'jinzhoushi', '0416', '210700', '121.135742,41.119269');
INSERT INTO `rg_region` VALUES ('11650', '11649', '3', '黑山县', 'hsx', 'heishanxian', '0416', '210726', '122.117915,41.691804');
INSERT INTO `rg_region` VALUES ('11673', '11649', '3', '义县', 'yx', 'yixian', '0416', '210727', '121.242831,41.537224');
INSERT INTO `rg_region` VALUES ('11692', '11649', '3', '太和区', 'thq', 'taihequ', '0416', '210711', '121.107297,41.105378');
INSERT INTO `rg_region` VALUES ('11708', '11649', '3', '凌海市', 'lhs', 'linghaishi', '0416', '210781', '121.364236,41.171738');
INSERT INTO `rg_region` VALUES ('11731', '11649', '3', '北镇市', 'bzs', 'beizhenshi', '0416', '210782', '121.795962,41.598764');
INSERT INTO `rg_region` VALUES ('11753', '11649', '3', '凌河区', 'lhq', 'linghequ', '0416', '210703', '121.151304,41.114662');
INSERT INTO `rg_region` VALUES ('11766', '11649', '3', '古塔区', 'gtq', 'gutaqu', '0416', '210702', '121.130085,41.115719');
INSERT INTO `rg_region` VALUES ('11777', '11049', '2', '抚顺市', 'fss', 'fushunshi', '0413', '210400', '123.921109,41.875956');
INSERT INTO `rg_region` VALUES ('11778', '11777', '3', '清原满族自治县', 'qymzzzx', 'qingyuanmanzuzizhixian', '0413', '210423', '124.927192,42.10135');
INSERT INTO `rg_region` VALUES ('11793', '11777', '3', '新宾满族自治县', 'xbmzzzx', 'xinbinmanzuzizhixian', '0413', '210422', '125.037547,41.732456');
INSERT INTO `rg_region` VALUES ('11809', '11777', '3', '新抚区', 'xfq', 'xinfuqu', '0413', '210402', '123.902858,41.86082');
INSERT INTO `rg_region` VALUES ('11821', '11777', '3', '抚顺县', 'fsx', 'fushunxian', '0413', '210421', '124.097979,41.922644');
INSERT INTO `rg_region` VALUES ('11830', '11777', '3', '望花区', 'whq', 'wanghuaqu', '0413', '210404', '123.801509,41.851803');
INSERT INTO `rg_region` VALUES ('11844', '11777', '3', '顺城区', 'scq', 'shunchengqu', '0413', '210411', '123.917165,41.881132');
INSERT INTO `rg_region` VALUES ('11854', '11777', '3', '东洲区', 'dzq', 'dongzhouqu', '0413', '210403', '124.047219,41.866829');
INSERT INTO `rg_region` VALUES ('11869', '11049', '2', '铁岭市', 'tls', 'tiolingshi', '0410', '211200', '123.844279,42.290585');
INSERT INTO `rg_region` VALUES ('11870', '11869', '3', '调兵山市', 'dbss', 'diaobingshanshi', '0410', '211281', '123.545366,42.450734');
INSERT INTO `rg_region` VALUES ('11876', '11869', '3', '清河区', 'qhq', 'qinghequ', '0410', '211204', '124.14896,42.542978');
INSERT INTO `rg_region` VALUES ('11882', '11869', '3', '开原市', 'kys', 'kaiyuanshi', '0410', '211282', '124.045551,42.542141');
INSERT INTO `rg_region` VALUES ('11904', '11869', '3', '银州区', 'yzq', 'yinzhouqu', '0410', '211202', '123.844877,42.292278');
INSERT INTO `rg_region` VALUES ('11914', '11869', '3', '西丰县', 'xfx', 'xifengxian', '0410', '211223', '124.72332,42.738091');
INSERT INTO `rg_region` VALUES ('11933', '11869', '3', '铁岭县', 'tlx', 'tiolingxian', '0410', '211221', '123.725669,42.223316');
INSERT INTO `rg_region` VALUES ('11949', '11869', '3', '昌图县', 'ctx', 'changtuxian', '0410', '211224', '124.11017,42.784441');
INSERT INTO `rg_region` VALUES ('11989', '11049', '2', '沈阳市', 'sys', 'shonyangshi', '024', '210100', '123.429096,41.796767');
INSERT INTO `rg_region` VALUES ('11990', '11989', '3', '沈北新区', 'sbxq', 'shonbeixinqu', '024', '210113', '123.521471,42.052312');
INSERT INTO `rg_region` VALUES ('12004', '11989', '3', '新民市', 'xms', 'xinminshi', '024', '210181', '122.828868,41.996508');
INSERT INTO `rg_region` VALUES ('12034', '11989', '3', '浑南区', 'hnq', 'hunnanqu', '024', '210112', '123.458981,41.741946');
INSERT INTO `rg_region` VALUES ('12048', '11989', '3', '和平区', 'hpq', 'hepingqu', '024', '210102', '123.406664,41.788074');
INSERT INTO `rg_region` VALUES ('12062', '11989', '3', '苏家屯区', 'sjtq', 'sujiatunqu', '024', '210111', '123.341604,41.665904');
INSERT INTO `rg_region` VALUES ('12080', '11989', '3', '皇姑区', 'hgq', 'huangguqu', '024', '210105', '123.405677,41.822336');
INSERT INTO `rg_region` VALUES ('12093', '11989', '3', '于洪区', 'yhq', 'yuhongqu', '024', '210114', '123.310829,41.795833');
INSERT INTO `rg_region` VALUES ('12109', '11989', '3', '康平县', 'kpx', 'kangpingxian', '024', '210123', '123.352703,42.741533');
INSERT INTO `rg_region` VALUES ('12126', '11989', '3', '法库县', 'fkx', 'fakuxian', '024', '210124', '123.416722,42.507045');
INSERT INTO `rg_region` VALUES ('12146', '11989', '3', '沈河区', 'shq', 'shonhequ', '024', '210103', '123.445696,41.795591');
INSERT INTO `rg_region` VALUES ('12162', '11989', '3', '大东区', 'ddq', 'dadongqu', '024', '210104', '123.469956,41.808503');
INSERT INTO `rg_region` VALUES ('12177', '11989', '3', '铁西区', 'txq', 'tioxiqu', '024', '210106', '123.350664,41.787808');
INSERT INTO `rg_region` VALUES ('12199', '11989', '3', '辽中区', 'lzq', 'liaozhongqu', '024', '210115', '122.731269,41.512725');
INSERT INTO `rg_region` VALUES ('12217', '11049', '2', '辽阳市', 'lys', 'liaoyangshi', '0419', '211000', '123.18152,41.269402');
INSERT INTO `rg_region` VALUES ('12218', '12217', '3', '辽阳县', 'lyx', 'liaoyangxian', '0419', '211021', '123.079674,41.216479');
INSERT INTO `rg_region` VALUES ('12234', '12217', '3', '灯塔市', 'dts', 'dengtashi', '0419', '211081', '123.325864,41.427836');
INSERT INTO `rg_region` VALUES ('12249', '12217', '3', '弓长岭区', 'gclq', 'gongchanglingqu', '0419', '211005', '123.431633,41.157831');
INSERT INTO `rg_region` VALUES ('12255', '12217', '3', '白塔区', 'btq', 'baitaqu', '0419', '211002', '123.172611,41.26745');
INSERT INTO `rg_region` VALUES ('12267', '12217', '3', '太子河区', 'tzhq', 'taizihequ', '0419', '211011', '123.185336,41.251682');
INSERT INTO `rg_region` VALUES ('12274', '12217', '3', '文圣区', 'wsq', 'wenshengqu', '0419', '211003', '123.188227,41.266765');
INSERT INTO `rg_region` VALUES ('12279', '12217', '3', '宏伟区', 'hwq', 'hongwoiqu', '0419', '211004', '123.200461,41.205747');
INSERT INTO `rg_region` VALUES ('12286', '11049', '2', '鞍山市', 'ass', 'anshanshi', '0412', '210300', '122.995632,41.110626');
INSERT INTO `rg_region` VALUES ('12287', '12286', '3', '台安县', 'tax', 'taianxian', '0412', '210321', '122.429736,41.38686');
INSERT INTO `rg_region` VALUES ('12305', '12286', '3', '岫岩满族自治县', 'xymzzzx', 'xiuyanmanzuzizhixian', '0412', '210323', '123.28833,40.281509');
INSERT INTO `rg_region` VALUES ('12332', '12286', '3', '立山区', 'lsq', 'lishanqu', '0412', '210304', '123.024806,41.150622');
INSERT INTO `rg_region` VALUES ('12346', '12286', '3', '铁西区', 'txq', 'tioxiqu', '0412', '210303', '122.971834,41.11069');
INSERT INTO `rg_region` VALUES ('12361', '12286', '3', '千山区', 'qsq', 'qianshanqu', '0412', '210311', '122.949298,41.068909');
INSERT INTO `rg_region` VALUES ('12369', '12286', '3', '铁东区', 'tdq', 'tiodongqu', '0412', '210302', '122.994475,41.110344');
INSERT INTO `rg_region` VALUES ('12387', '12286', '3', '海城市', 'hcs', 'haichengshi', '0412', '210381', '122.752199,40.852533');
INSERT INTO `rg_region` VALUES ('12415', '11049', '2', '营口市', 'yks', 'yingkoushi', '0417', '210800', '122.235151,40.667432');
INSERT INTO `rg_region` VALUES ('12416', '12415', '3', '西市区', 'xsq', 'xishiqu', '0417', '210803', '122.210067,40.663086');
INSERT INTO `rg_region` VALUES ('12427', '12415', '3', '大石桥市', 'dsqs', 'dashiqiaoshi', '0417', '210882', '122.505894,40.633973');
INSERT INTO `rg_region` VALUES ('12446', '12415', '3', '鲅鱼圈区', 'byqq', 'bayuquanqu', '0417', '210804', '122.127242,40.263646');
INSERT INTO `rg_region` VALUES ('12454', '12415', '3', '盖州市', 'gzs', 'gaizhoushi', '0417', '210881', '122.355534,40.405234');
INSERT INTO `rg_region` VALUES ('12482', '12415', '3', '站前区', 'zqq', 'zhanqianqu', '0417', '210802', '122.253235,40.669949');
INSERT INTO `rg_region` VALUES ('12490', '12415', '3', '老边区', 'lbq', 'laobianqu', '0417', '210811', '122.382584,40.682723');
INSERT INTO `rg_region` VALUES ('12497', '11049', '2', '盘锦市', 'pjs', 'panjinshi', '0427', '211100', '122.06957,41.124484');
INSERT INTO `rg_region` VALUES ('12498', '12497', '3', '盘山县', 'psx', 'panshanxian', '0427', '211122', '121.98528,41.240701');
INSERT INTO `rg_region` VALUES ('12513', '12497', '3', '大洼区', 'dwq', 'dawaqu', '0427', '211104', '122.071708,40.994428');
INSERT INTO `rg_region` VALUES ('12531', '12497', '3', '双台子区', 'stzq', 'shuangtaiziqu', '0427', '211102', '122.055733,41.190365');
INSERT INTO `rg_region` VALUES ('12542', '12497', '3', '兴隆台区', 'xltq', 'xinglongtaiqu', '0427', '211103', '122.071624,41.122423');
INSERT INTO `rg_region` VALUES ('12561', '11049', '2', '阜新市', 'fxs', 'fuxinshi', '0418', '210900', '121.648962,42.011796');
INSERT INTO `rg_region` VALUES ('12562', '12561', '3', '细河区', 'xhq', 'xihequ', '0418', '210911', '121.654791,42.019218');
INSERT INTO `rg_region` VALUES ('12571', '12561', '3', '太平区', 'tpq', 'taipingqu', '0418', '210904', '121.677575,42.011145');
INSERT INTO `rg_region` VALUES ('12578', '12561', '3', '清河门区', 'qhmq', 'qinghemenqu', '0418', '210905', '121.42018,41.780477');
INSERT INTO `rg_region` VALUES ('12584', '12561', '3', '海州区', 'hzq', 'haizhouqu', '0418', '210902', '121.657639,42.011162');
INSERT INTO `rg_region` VALUES ('12595', '12561', '3', '阜新蒙古族自治县', 'fxmgzzzx', 'fuxinmengguzuzizhixian', '0418', '210921', '121.743125,42.058607');
INSERT INTO `rg_region` VALUES ('12633', '12561', '3', '新邱区', 'xqq', 'xinqiuqu', '0418', '210903', '121.790541,42.086603');
INSERT INTO `rg_region` VALUES ('12639', '12561', '3', '彰武县', 'zwx', 'zhangwuxian', '0418', '210922', '122.537444,42.384823');
INSERT INTO `rg_region` VALUES ('12664', '11049', '2', '本溪市', 'bxs', 'bonxishi', '0414', '210500', '123.770519,41.297909');
INSERT INTO `rg_region` VALUES ('12665', '12664', '3', '桓仁满族自治县', 'hrmzzzx', 'huanrenmanzuzizhixian', '0414', '210522', '125.359195,41.268997');
INSERT INTO `rg_region` VALUES ('12679', '12664', '3', '溪湖区', 'xhq', 'xihuqu', '0414', '210503', '123.765226,41.330056');
INSERT INTO `rg_region` VALUES ('12690', '12664', '3', '南芬区', 'nfq', 'nanfenqu', '0414', '210505', '123.748381,41.104093');
INSERT INTO `rg_region` VALUES ('12696', '12664', '3', '明山区', 'msq', 'mingshanqu', '0414', '210504', '123.763288,41.302429');
INSERT INTO `rg_region` VALUES ('12706', '12664', '3', '平山区', 'psq', 'pingshanqu', '0414', '210502', '123.761231,41.291581');
INSERT INTO `rg_region` VALUES ('12716', '12664', '3', '本溪满族自治县', 'bxmzzzx', 'bonximanzuzizhixian', '0414', '210521', '124.126156,41.300344');
INSERT INTO `rg_region` VALUES ('12729', '0', '1', '山东省', 'sds', 'shandongsheng', '', '370000', '117.000923,36.675807');
INSERT INTO `rg_region` VALUES ('12730', '12729', '2', '青岛市', 'qds', 'qingdaoshi', '0532', '370200', '120.355173,36.082982');
INSERT INTO `rg_region` VALUES ('12731', '12730', '3', '平度市', 'pds', 'pingdushi', '0532', '370283', '119.959012,36.788828');
INSERT INTO `rg_region` VALUES ('12750', '12730', '3', '莱西市', 'lxs', 'laixishi', '0532', '370285', '120.526226,36.86509');
INSERT INTO `rg_region` VALUES ('12762', '12730', '3', '崂山区', 'lsq', 'laoshanqu', '0532', '370212', '120.467393,36.102569');
INSERT INTO `rg_region` VALUES ('12767', '12730', '3', '即墨区', 'jmq', 'jimoqu', '0532', '370215', '120.447352,36.390847');
INSERT INTO `rg_region` VALUES ('12783', '12730', '3', '李沧区', 'lcq', 'licangqu', '0532', '370213', '120.421236,36.160023');
INSERT INTO `rg_region` VALUES ('12795', '12730', '3', '黄岛区', 'hdq', 'huangdaoqu', '0532', '370211', '119.995518,35.875138');
INSERT INTO `rg_region` VALUES ('12818', '12730', '3', '城阳区', 'cyq', 'chengyangqu', '0532', '370214', '120.389135,36.306833');
INSERT INTO `rg_region` VALUES ('12827', '12730', '3', '胶州市', 'jzs', 'jiaozhoushi', '0532', '370281', '120.006202,36.285878');
INSERT INTO `rg_region` VALUES ('12840', '12730', '3', '市北区', 'sbq', 'shibeiqu', '0532', '370203', '120.355026,36.083819');
INSERT INTO `rg_region` VALUES ('12864', '12730', '3', '市南区', 'snq', 'shinanqu', '0532', '370202', '120.395966,36.070892');
INSERT INTO `rg_region` VALUES ('12875', '12729', '2', '烟台市', 'yts', 'yantaishi', '0535', '370600', '121.391382,37.539297');
INSERT INTO `rg_region` VALUES ('12876', '12875', '3', '长岛县', 'cdx', 'changdaoxian', '0535', '370634', '120.738345,37.916194');
INSERT INTO `rg_region` VALUES ('12885', '12875', '3', '莱州市', 'lzs', 'laizhoushi', '0535', '370683', '119.942135,37.182725');
INSERT INTO `rg_region` VALUES ('12903', '12875', '3', '芝罘区', 'zfq', 'zhifuqu', '0535', '370602', '121.385877,37.540925');
INSERT INTO `rg_region` VALUES ('12916', '12875', '3', '海阳市', 'hys', 'haiyangshi', '0535', '370687', '121.168392,36.780657');
INSERT INTO `rg_region` VALUES ('12932', '12875', '3', '牟平区', 'mpq', 'moupingqu', '0535', '370612', '121.60151,37.388356');
INSERT INTO `rg_region` VALUES ('12946', '12875', '3', '龙口市', 'lks', 'longkoushi', '0535', '370681', '120.528328,37.648446');
INSERT INTO `rg_region` VALUES ('12960', '12875', '3', '蓬莱市', 'pls', 'penglaishi', '0535', '370684', '120.762689,37.811168');
INSERT INTO `rg_region` VALUES ('12973', '12875', '3', '莱阳市', 'lys', 'laiyangshi', '0535', '370682', '120.711151,36.977037');
INSERT INTO `rg_region` VALUES ('12992', '12875', '3', '招远市', 'zys', 'zhaoyuanshi', '0535', '370685', '120.403142,37.364919');
INSERT INTO `rg_region` VALUES ('13007', '12875', '3', '福山区', 'fsq', 'fushanqu', '0535', '370611', '121.264741,37.496875');
INSERT INTO `rg_region` VALUES ('13019', '12875', '3', '莱山区', 'lsq', 'laishanqu', '0535', '370613', '121.448866,37.473549');
INSERT INTO `rg_region` VALUES ('13027', '12875', '3', '栖霞市', 'qxs', 'qixiashi', '0535', '370686', '120.834097,37.305854');
INSERT INTO `rg_region` VALUES ('13044', '12729', '2', '淄博市', 'zbs', 'ziboshi', '0533', '370300', '118.047648,36.814939');
INSERT INTO `rg_region` VALUES ('13045', '13044', '3', '高青县', 'gqx', 'gaoqingxian', '0533', '370322', '117.829839,37.169581');
INSERT INTO `rg_region` VALUES ('13055', '13044', '3', '桓台县', 'htx', 'huantaixian', '0533', '370321', '118.101556,36.959773');
INSERT INTO `rg_region` VALUES ('13065', '13044', '3', '临淄区', 'lzq', 'linziqu', '0533', '370305', '118.306018,36.816657');
INSERT INTO `rg_region` VALUES ('13078', '13044', '3', '张店区', 'zdq', 'zhangdianqu', '0533', '370303', '118.053521,36.807049');
INSERT INTO `rg_region` VALUES ('13092', '13044', '3', '沂源县', 'yyx', 'yiyuanxian', '0533', '370323', '118.166161,36.186282');
INSERT INTO `rg_region` VALUES ('13105', '13044', '3', '博山区', 'bsq', 'boshanqu', '0533', '370304', '117.85823,36.497567');
INSERT INTO `rg_region` VALUES ('13116', '13044', '3', '周村区', 'zcq', 'zhoucunqu', '0533', '370306', '117.851036,36.803699');
INSERT INTO `rg_region` VALUES ('13127', '13044', '3', '淄川区', 'zcq', 'zichuanqu', '0533', '370302', '117.967696,36.647272');
INSERT INTO `rg_region` VALUES ('13141', '12729', '2', '聊城市', 'lcs', 'liaochengshi', '0635', '371500', '115.980367,36.456013');
INSERT INTO `rg_region` VALUES ('13142', '13141', '3', '冠县', 'gx', 'guanxian', '0635', '371525', '115.444808,36.483753');
INSERT INTO `rg_region` VALUES ('13161', '13141', '3', '东阿县', 'dax', 'dongaxian', '0635', '371524', '116.248855,36.336004');
INSERT INTO `rg_region` VALUES ('13172', '13141', '3', '高唐县', 'gtx', 'gaotangxian', '0635', '371526', '116.229662,36.859755');
INSERT INTO `rg_region` VALUES ('13185', '13141', '3', '莘县', 'sx', 'shenxian', '0635', '371522', '115.667291,36.237597');
INSERT INTO `rg_region` VALUES ('13210', '13141', '3', '阳谷县', 'ygx', 'yangguxian', '0635', '371521', '115.784287,36.113708');
INSERT INTO `rg_region` VALUES ('13229', '13141', '3', '茌平县', 'cpx', 'chipingxian', '0635', '371523', '116.25335,36.591934');
INSERT INTO `rg_region` VALUES ('13244', '13141', '3', '临清市', 'lqs', 'linqingshi', '0635', '371581', '115.713462,36.842598');
INSERT INTO `rg_region` VALUES ('13261', '13141', '3', '东昌府区', 'dcfq', 'dongchangfuqu', '0635', '371502', '115.980023,36.45606');
INSERT INTO `rg_region` VALUES ('13286', '12729', '2', '威海市', 'whs', 'weihaishi', '0631', '371000', '122.116394,37.509691');
INSERT INTO `rg_region` VALUES ('13287', '13286', '3', '环翠区', 'hcq', 'huancuiqu', '0631', '371002', '122.116189,37.510754');
INSERT INTO `rg_region` VALUES ('13307', '13286', '3', '荣成市', 'rcs', 'rongchengshi', '0631', '371082', '122.422896,37.160134');
INSERT INTO `rg_region` VALUES ('13330', '13286', '3', '文登区', 'wdq', 'wendengqu', '0631', '371003', '122.057139,37.196211');
INSERT INTO `rg_region` VALUES ('13348', '13286', '3', '乳山市', 'rss', 'rushanshi', '0631', '371083', '121.536346,36.919622');
INSERT INTO `rg_region` VALUES ('13364', '12729', '2', '临沂市', 'lys', 'linyishi', '0539', '371300', '118.326443,35.065282');
INSERT INTO `rg_region` VALUES ('13365', '13364', '3', '蒙阴县', 'myx', 'mengyinxian', '0539', '371328', '117.943271,35.712435');
INSERT INTO `rg_region` VALUES ('13376', '13364', '3', '沂水县', 'ysx', 'yishuixian', '0539', '371323', '118.634543,35.787029');
INSERT INTO `rg_region` VALUES ('13395', '13364', '3', '平邑县', 'pyx', 'pingyixian', '0539', '371326', '117.631884,35.511519');
INSERT INTO `rg_region` VALUES ('13410', '13364', '3', '郯城县', 'tcx', 'tanchengxian', '0539', '371322', '118.342963,34.614741');
INSERT INTO `rg_region` VALUES ('13424', '13364', '3', '兰山区', 'lsq', 'lanshanqu', '0539', '371302', '118.327667,35.061631');
INSERT INTO `rg_region` VALUES ('13437', '13364', '3', '莒南县', 'jnx', 'junanxian', '0539', '371327', '118.838322,35.175911');
INSERT INTO `rg_region` VALUES ('13454', '13364', '3', '沂南县', 'ynx', 'yinanxian', '0539', '371321', '118.455395,35.547002');
INSERT INTO `rg_region` VALUES ('13470', '13364', '3', '罗庄区', 'lzq', 'luozhuangqu', '0539', '371311', '118.284795,34.997204');
INSERT INTO `rg_region` VALUES ('13480', '13364', '3', '临沭县', 'lsx', 'linshuxian', '0539', '371329', '118.648379,34.917062');
INSERT INTO `rg_region` VALUES ('13491', '13364', '3', '河东区', 'hdq', 'hedongqu', '0539', '371312', '118.398296,35.085004');
INSERT INTO `rg_region` VALUES ('13503', '13364', '3', '费县', 'fx', 'feixian', '0539', '371325', '117.968869,35.269174');
INSERT INTO `rg_region` VALUES ('13516', '13364', '3', '兰陵县', 'llx', 'lanlingxian', '0539', '371324', '118.049968,34.855573');
INSERT INTO `rg_region` VALUES ('13534', '12729', '2', '潍坊市', 'wfs', 'weifangshi', '0536', '370700', '119.107078,36.70925');
INSERT INTO `rg_region` VALUES ('13535', '13534', '3', '奎文区', 'kwq', 'kuiwenqu', '0536', '370705', '119.137357,36.709494');
INSERT INTO `rg_region` VALUES ('13546', '13534', '3', '潍城区', 'wcq', 'weichengqu', '0536', '370702', '119.103784,36.710062');
INSERT INTO `rg_region` VALUES ('13554', '13534', '3', '高密市', 'gms', 'gaomishi', '0536', '370785', '119.757033,36.37754');
INSERT INTO `rg_region` VALUES ('13565', '13534', '3', '坊子区', 'fzq', 'fangziqu', '0536', '370704', '119.166326,36.654616');
INSERT INTO `rg_region` VALUES ('13573', '13534', '3', '临朐县', 'lqx', 'linquxian', '0536', '370724', '118.539876,36.516371');
INSERT INTO `rg_region` VALUES ('13584', '13534', '3', '安丘市', 'aqs', 'anqiushi', '0536', '370784', '119.206886,36.427417');
INSERT INTO `rg_region` VALUES ('13597', '13534', '3', '诸城市', 'zcs', 'zhuchengshi', '0536', '370782', '119.403182,35.997093');
INSERT INTO `rg_region` VALUES ('13612', '13534', '3', '寿光市', 'sgs', 'shouguangshi', '0536', '370783', '118.736451,36.874411');
INSERT INTO `rg_region` VALUES ('13628', '13534', '3', '昌邑市', 'cys', 'changyishi', '0536', '370786', '119.394502,36.854937');
INSERT INTO `rg_region` VALUES ('13638', '13534', '3', '寒亭区', 'htq', 'hantingqu', '0536', '370703', '119.207866,36.772103');
INSERT INTO `rg_region` VALUES ('13646', '13534', '3', '青州市', 'qzs', 'qingzhoushi', '0536', '370781', '118.484693,36.697855');
INSERT INTO `rg_region` VALUES ('13660', '13534', '3', '昌乐县', 'clx', 'changlexian', '0536', '370725', '118.839995,36.703253');
INSERT INTO `rg_region` VALUES ('13670', '12729', '2', '枣庄市', 'zzs', 'zaozhuangshi', '0632', '370400', '117.557964,34.856424');
INSERT INTO `rg_region` VALUES ('13671', '13670', '3', '山亭区', 'stq', 'shantingqu', '0632', '370406', '117.458968,35.096077');
INSERT INTO `rg_region` VALUES ('13682', '13670', '3', '峄城区', 'ycq', 'yichengqu', '0632', '370404', '117.586316,34.767713');
INSERT INTO `rg_region` VALUES ('13690', '13670', '3', '市中区', 'szq', 'shizhongqu', '0632', '370402', '117.557281,34.856651');
INSERT INTO `rg_region` VALUES ('13702', '13670', '3', '薛城区', 'xcq', 'xuechengqu', '0632', '370403', '117.265293,34.79789');
INSERT INTO `rg_region` VALUES ('13712', '13670', '3', '台儿庄区', 'tezq', 'taierzhuangqu', '0632', '370405', '117.734747,34.564815');
INSERT INTO `rg_region` VALUES ('13719', '13670', '3', '滕州市', 'tzs', 'tengzhoushi', '0632', '370481', '117.162098,35.088498');
INSERT INTO `rg_region` VALUES ('13741', '12729', '2', '东营市', 'dys', 'dongyingshi', '0546', '370500', '118.66471,37.434564');
INSERT INTO `rg_region` VALUES ('13742', '13741', '3', '利津县', 'ljx', 'lijinxian', '0546', '370522', '118.248854,37.493365');
INSERT INTO `rg_region` VALUES ('13753', '13741', '3', '广饶县', 'grx', 'guangraoxian', '0546', '370523', '118.407522,37.05161');
INSERT INTO `rg_region` VALUES ('13765', '13741', '3', '东营区', 'dyq', 'dongyingqu', '0546', '370502', '118.507543,37.461567');
INSERT INTO `rg_region` VALUES ('13776', '13741', '3', '河口区', 'hkq', 'hekouqu', '0546', '370503', '118.529613,37.886015');
INSERT INTO `rg_region` VALUES ('13785', '13741', '3', '垦利区', 'klq', 'konliqu', '0546', '370505', '118.551314,37.588679');
INSERT INTO `rg_region` VALUES ('13798', '12729', '2', '日照市', 'rzs', 'rizhaoshi', '0633', '371100', '119.461208,35.428588');
INSERT INTO `rg_region` VALUES ('13799', '13798', '3', '五莲县', 'wlx', 'wulianxian', '0633', '371121', '119.206745,35.751936');
INSERT INTO `rg_region` VALUES ('13812', '13798', '3', '莒县', 'jx', 'juxian', '0633', '371122', '118.832859,35.588115');
INSERT INTO `rg_region` VALUES ('13834', '13798', '3', '东港区', 'dgq', 'donggangqu', '0633', '371102', '119.457703,35.426152');
INSERT INTO `rg_region` VALUES ('13849', '13798', '3', '岚山区', 'lsq', 'lanshanqu', '0633', '371103', '119.315844,35.119794');
INSERT INTO `rg_region` VALUES ('13859', '12729', '2', '滨州市', 'bzs', 'binzhoushi', '0543', '371600', '118.016974,37.383542');
INSERT INTO `rg_region` VALUES ('13860', '13859', '3', '沾化区', 'zhq', 'zhanhuaqu', '0543', '371603', '118.129902,37.698456');
INSERT INTO `rg_region` VALUES ('13872', '13859', '3', '滨城区', 'bcq', 'binchengqu', '0543', '371602', '118.020149,37.384842');
INSERT INTO `rg_region` VALUES ('13888', '13859', '3', '博兴县', 'bxx', 'boxingxian', '0543', '371625', '118.123096,37.147002');
INSERT INTO `rg_region` VALUES ('13901', '13859', '3', '邹平市', 'zps', 'zoupingshi', '0543', '371681', '117.736807,36.87803');
INSERT INTO `rg_region` VALUES ('13918', '13859', '3', '无棣县', 'wdx', 'wudixian', '0543', '371623', '117.616325,37.740848');
INSERT INTO `rg_region` VALUES ('13931', '13859', '3', '惠民县', 'hmx', 'huiminxian', '0543', '371621', '117.508941,37.483876');
INSERT INTO `rg_region` VALUES ('13947', '13859', '3', '阳信县', 'yxx', 'yangxinxian', '0543', '371622', '117.581326,37.640492');
INSERT INTO `rg_region` VALUES ('13958', '12729', '2', '济宁市', 'jns', 'jiningshi', '0537', '370800', '116.587245,35.415393');
INSERT INTO `rg_region` VALUES ('13959', '13958', '3', '曲阜市', 'qfs', 'qufushi', '0537', '370881', '116.991885,35.592788');
INSERT INTO `rg_region` VALUES ('13972', '13958', '3', '泗水县', 'ssx', 'sishuixian', '0537', '370831', '117.273605,35.653216');
INSERT INTO `rg_region` VALUES ('13986', '13958', '3', '汶上县', 'wsx', 'wenshangxian', '0537', '370830', '116.487146,35.721746');
INSERT INTO `rg_region` VALUES ('14002', '13958', '3', '邹城市', 'zcs', 'zouchengshi', '0537', '370883', '116.96673,35.405259');
INSERT INTO `rg_region` VALUES ('14019', '13958', '3', '金乡县', 'jxx', 'jinxiangxian', '0537', '370828', '116.310364,35.06977');
INSERT INTO `rg_region` VALUES ('14033', '13958', '3', '鱼台县', 'ytx', 'yutaixian', '0537', '370827', '116.650023,34.997706');
INSERT INTO `rg_region` VALUES ('14045', '13958', '3', '任城区', 'rcq', 'renchengqu', '0537', '370811', '116.595261,35.414828');
INSERT INTO `rg_region` VALUES ('14067', '13958', '3', '嘉祥县', 'jxx', 'jiaxiangxian', '0537', '370829', '116.342885,35.398098');
INSERT INTO `rg_region` VALUES ('14084', '13958', '3', '梁山县', 'lsx', 'liangshanxian', '0537', '370832', '116.08963,35.801843');
INSERT INTO `rg_region` VALUES ('14100', '13958', '3', '微山县', 'wsx', 'weishanxian', '0537', '370826', '117.12861,34.809525');
INSERT INTO `rg_region` VALUES ('14116', '13958', '3', '兖州区', 'yzq', 'yanzhouqu', '0537', '370812', '116.828996,35.556445');
INSERT INTO `rg_region` VALUES ('14129', '12729', '2', '泰安市', 'tas', 'taianshi', '0538', '370900', '117.129063,36.194968');
INSERT INTO `rg_region` VALUES ('14130', '14129', '3', '新泰市', 'xts', 'xintaishi', '0538', '370982', '117.766092,35.910387');
INSERT INTO `rg_region` VALUES ('14151', '14129', '3', '肥城市', 'fcs', 'feichengshi', '0538', '370983', '116.763703,36.1856');
INSERT INTO `rg_region` VALUES ('14166', '14129', '3', '东平县', 'dpx', 'dongpingxian', '0538', '370923', '116.461052,35.930467');
INSERT INTO `rg_region` VALUES ('14181', '14129', '3', '宁阳县', 'nyx', 'ningyangxian', '0538', '370921', '116.799297,35.76754');
INSERT INTO `rg_region` VALUES ('14195', '14129', '3', '泰山区', 'tsq', 'taishanqu', '0538', '370902', '117.129984,36.189313');
INSERT INTO `rg_region` VALUES ('14204', '14129', '3', '岱岳区', 'dyq', 'daiyuequ', '0538', '370911', '117.04353,36.1841');
INSERT INTO `rg_region` VALUES ('14223', '12729', '2', '德州市', 'dzs', 'dezhoushi', '0534', '371400', '116.307428,37.453968');
INSERT INTO `rg_region` VALUES ('14224', '14223', '3', '宁津县', 'njx', 'ningjinxian', '0534', '371422', '116.79372,37.649619');
INSERT INTO `rg_region` VALUES ('14237', '14223', '3', '乐陵市', 'lls', 'lelingshi', '0534', '371481', '117.216657,37.729115');
INSERT INTO `rg_region` VALUES ('14254', '14223', '3', '陵城区', 'lcq', 'lingchengqu', '0534', '371403', '116.574929,37.332848');
INSERT INTO `rg_region` VALUES ('14268', '14223', '3', '德城区', 'dcq', 'dechengqu', '0534', '371402', '116.307076,37.453923');
INSERT INTO `rg_region` VALUES ('14281', '14223', '3', '临邑县', 'lyx', 'linyixian', '0534', '371424', '116.867028,37.192044');
INSERT INTO `rg_region` VALUES ('14294', '14223', '3', '武城县', 'wcx', 'wuchengxian', '0534', '371428', '116.078627,37.209527');
INSERT INTO `rg_region` VALUES ('14303', '14223', '3', '禹城市', 'ycs', 'yuchengshi', '0534', '371482', '116.642554,36.934485');
INSERT INTO `rg_region` VALUES ('14315', '14223', '3', '夏津县', 'xjx', 'xiajinxian', '0534', '371427', '116.003816,36.950501');
INSERT INTO `rg_region` VALUES ('14330', '14223', '3', '平原县', 'pyx', 'pingyuanxian', '0534', '371426', '116.433904,37.164465');
INSERT INTO `rg_region` VALUES ('14343', '14223', '3', '齐河县', 'qhx', 'qihexian', '0534', '371425', '116.758394,36.795497');
INSERT INTO `rg_region` VALUES ('14359', '14223', '3', '庆云县', 'qyx', 'qingyunxian', '0534', '371423', '117.390507,37.777724');
INSERT INTO `rg_region` VALUES ('14369', '12729', '2', '济南市', 'jns', 'jinanshi', '0531', '370100', '117.000923,36.675807');
INSERT INTO `rg_region` VALUES ('14370', '14369', '3', '章丘区', 'zqq', 'zhangqiuqu', '0531', '370114', '117.54069,36.71209');
INSERT INTO `rg_region` VALUES ('14389', '14369', '3', '长清区', 'cqq', 'changqingqu', '0531', '370113', '116.74588,36.561049');
INSERT INTO `rg_region` VALUES ('14400', '14369', '3', '钢城区', 'gcq', 'gangchengqu', '0531', '370117', '117.82033,36.058038');
INSERT INTO `rg_region` VALUES ('14406', '14369', '3', '莱芜区', 'lwq', 'laiwuqu', '0531', '370116', '117.678351,36.213662');
INSERT INTO `rg_region` VALUES ('14422', '14369', '3', '槐荫区', 'hyq', 'huaiyinqu', '0531', '370104', '116.947921,36.668205');
INSERT INTO `rg_region` VALUES ('14439', '14369', '3', '天桥区', 'tqq', 'tianqiaoqu', '0531', '370105', '116.996086,36.693374');
INSERT INTO `rg_region` VALUES ('14455', '14369', '3', '市中区', 'szq', 'shizhongqu', '0531', '370103', '116.99898,36.657354');
INSERT INTO `rg_region` VALUES ('14473', '14369', '3', '平阴县', 'pyx', 'pingyinxian', '0531', '370124', '116.455054,36.286923');
INSERT INTO `rg_region` VALUES ('14482', '14369', '3', '历城区', 'lcq', 'lichengqu', '0531', '370112', '117.063744,36.681744');
INSERT INTO `rg_region` VALUES ('14504', '14369', '3', '历下区', 'lxq', 'lixiaqu', '0531', '370102', '117.03862,36.664169');
INSERT INTO `rg_region` VALUES ('14519', '14369', '3', '济阳区', 'jyq', 'jiyangqu', '0531', '370115', '117.176035,36.976772');
INSERT INTO `rg_region` VALUES ('14530', '14369', '3', '商河县', 'shx', 'shanghexian', '0531', '370126', '117.156369,37.310544');
INSERT INTO `rg_region` VALUES ('14543', '12729', '2', '菏泽市', 'hzs', 'hezeshi', '0530', '371700', '115.469381,35.246531');
INSERT INTO `rg_region` VALUES ('14544', '14543', '3', '鄄城县', 'jcx', 'juanchengxian', '0530', '371726', '115.51434,35.560257');
INSERT INTO `rg_region` VALUES ('14562', '14543', '3', '牡丹区', 'mdq', 'mudanqu', '0530', '371702', '115.470946,35.24311');
INSERT INTO `rg_region` VALUES ('14587', '14543', '3', '定陶区', 'dtq', 'dingtaoqu', '0530', '371703', '115.569601,35.072701');
INSERT INTO `rg_region` VALUES ('14600', '14543', '3', '东明县', 'dmx', 'dongmingxian', '0530', '371728', '115.098412,35.289637');
INSERT INTO `rg_region` VALUES ('14615', '14543', '3', '曹县', 'cx', 'caoxian', '0530', '371721', '115.549482,34.823253');
INSERT INTO `rg_region` VALUES ('14643', '14543', '3', '成武县', 'cwx', 'chengwuxian', '0530', '371723', '115.897349,34.947366');
INSERT INTO `rg_region` VALUES ('14657', '14543', '3', '郓城县', 'ycx', 'yunchengxian', '0530', '371725', '115.93885,35.594773');
INSERT INTO `rg_region` VALUES ('14680', '14543', '3', '巨野县', 'jyx', 'juyoxian', '0530', '371724', '116.089341,35.390999');
INSERT INTO `rg_region` VALUES ('14698', '14543', '3', '单县', 'dx', 'danxian', '0530', '371722', '116.08262,34.790851');
INSERT INTO `rg_region` VALUES ('14721', '0', '1', '江苏省', 'jss', 'jiangsusheng', '', '320000', '118.767413,32.041544');
INSERT INTO `rg_region` VALUES ('14722', '14721', '2', '连云港市', 'lygs', 'lianyungangshi', '0518', '320700', '119.178821,34.600018');
INSERT INTO `rg_region` VALUES ('14723', '14722', '3', '赣榆区', 'gyq', 'ganyuqu', '0518', '320707', '119.128774,34.839154');
INSERT INTO `rg_region` VALUES ('14743', '14722', '3', '东海县', 'dhx', 'donghaixian', '0518', '320722', '118.766489,34.522859');
INSERT INTO `rg_region` VALUES ('14764', '14722', '3', '连云区', 'lyq', 'lianyunqu', '0518', '320703', '119.366487,34.739529');
INSERT INTO `rg_region` VALUES ('14780', '14722', '3', '灌云县', 'gyx', 'guanyunxian', '0518', '320723', '119.255741,34.298436');
INSERT INTO `rg_region` VALUES ('14798', '14722', '3', '灌南县', 'gnx', 'guannanxian', '0518', '320724', '119.352331,34.092553');
INSERT INTO `rg_region` VALUES ('14810', '14722', '3', '海州区', 'hzq', 'haizhouqu', '0518', '320706', '119.179793,34.601584');
INSERT INTO `rg_region` VALUES ('14834', '14721', '2', '镇江市', 'zjs', 'zhenjiangshi', '0511', '321100', '119.452753,32.204402');
INSERT INTO `rg_region` VALUES ('14835', '14834', '3', '扬中市', 'yzs', 'yangzhongshi', '0511', '321182', '119.828054,32.237266');
INSERT INTO `rg_region` VALUES ('14842', '14834', '3', '润州区', 'rzq', 'runzhouqu', '0511', '321111', '119.414877,32.213501');
INSERT INTO `rg_region` VALUES ('14852', '14834', '3', '丹阳市', 'dys', 'danyangshi', '0511', '321181', '119.581911,31.991459');
INSERT INTO `rg_region` VALUES ('14865', '14834', '3', '句容市', 'jrs', 'jurongshi', '0511', '321183', '119.167135,31.947355');
INSERT INTO `rg_region` VALUES ('14878', '14834', '3', '丹徒区', 'dtq', 'dantuqu', '0511', '321112', '119.433883,32.128972');
INSERT INTO `rg_region` VALUES ('14889', '14834', '3', '京口区', 'jkq', 'jingkouqu', '0511', '321102', '119.454571,32.206191');
INSERT INTO `rg_region` VALUES ('14903', '14721', '2', '南京市', 'njs', 'nanjingshi', '025', '320100', '118.767413,32.041544');
INSERT INTO `rg_region` VALUES ('14904', '14903', '3', '浦口区', 'pkq', 'pukouqu', '025', '320111', '118.625307,32.05839');
INSERT INTO `rg_region` VALUES ('14918', '14903', '3', '雨花台区', 'yhtq', 'yuhuataiqu', '025', '320114', '118.77207,31.995946');
INSERT INTO `rg_region` VALUES ('14928', '14903', '3', '溧水区', 'lsq', 'lishuiqu', '025', '320117', '119.028732,31.653061');
INSERT INTO `rg_region` VALUES ('14938', '14903', '3', '江宁区', 'jnq', 'jiangningqu', '025', '320115', '118.850621,31.953418');
INSERT INTO `rg_region` VALUES ('14949', '14903', '3', '高淳区', 'gcq', 'gaochunqu', '025', '320118', '118.87589,31.327132');
INSERT INTO `rg_region` VALUES ('14962', '14903', '3', '六合区', 'lhq', 'liuhequ', '025', '320116', '118.85065,32.340655');
INSERT INTO `rg_region` VALUES ('14977', '14903', '3', '建邺区', 'jyq', 'jianyequ', '025', '320105', '118.732688,32.004538');
INSERT INTO `rg_region` VALUES ('14988', '14903', '3', '鼓楼区', 'glq', 'gulouqu', '025', '320106', '118.769739,32.066966');
INSERT INTO `rg_region` VALUES ('15002', '14903', '3', '秦淮区', 'qhq', 'qinhuaiqu', '025', '320104', '118.786088,32.033818');
INSERT INTO `rg_region` VALUES ('15016', '14903', '3', '栖霞区', 'qxq', 'qixiaqu', '025', '320113', '118.808702,32.102147');
INSERT INTO `rg_region` VALUES ('15037', '14903', '3', '玄武区', 'xwq', 'xuanwuqu', '025', '320102', '118.792199,32.050678');
INSERT INTO `rg_region` VALUES ('15045', '14721', '2', '宿迁市', 'sqs', 'suqianshi', '0527', '321300', '118.275162,33.963008');
INSERT INTO `rg_region` VALUES ('15046', '15045', '3', '沭阳县', 'syx', 'shuyangxian', '0527', '321322', '118.775889,34.129097');
INSERT INTO `rg_region` VALUES ('15088', '15045', '3', '泗洪县', 'shx', 'sihongxian', '0527', '321324', '118.211824,33.456538');
INSERT INTO `rg_region` VALUES ('15117', '15045', '3', '泗阳县', 'syx', 'siyangxian', '0527', '321323', '118.681284,33.711433');
INSERT INTO `rg_region` VALUES ('15137', '15045', '3', '宿城区', 'scq', 'suchengqu', '0527', '321302', '118.278984,33.937726');
INSERT INTO `rg_region` VALUES ('15159', '15045', '3', '宿豫区', 'syq', 'suyuqu', '0527', '321311', '118.330012,33.941071');
INSERT INTO `rg_region` VALUES ('15180', '14721', '2', '南通市', 'nts', 'nantongshi', '0513', '320600', '120.864608,32.016212');
INSERT INTO `rg_region` VALUES ('15181', '15180', '3', '海门市', 'hms', 'haimenshi', '0513', '320684', '121.176609,31.893528');
INSERT INTO `rg_region` VALUES ('15195', '15180', '3', '如皋市', 'rgs', 'rugaoshi', '0513', '320682', '120.566324,32.391591');
INSERT INTO `rg_region` VALUES ('15210', '15180', '3', '海安市', 'has', 'haianshi', '0513', '320685', '120.465995,32.540289');
INSERT INTO `rg_region` VALUES ('15222', '15180', '3', '如东县', 'rdx', 'rudongxian', '0513', '320623', '121.186088,32.311832');
INSERT INTO `rg_region` VALUES ('15242', '15180', '3', '启东市', 'qds', 'qidongshi', '0513', '320681', '121.659724,31.810158');
INSERT INTO `rg_region` VALUES ('15258', '15180', '3', '港闸区', 'gzq', 'gangzhaqu', '0513', '320611', '120.8339,32.040299');
INSERT INTO `rg_region` VALUES ('15265', '15180', '3', '通州区', 'tzq', 'tongzhouqu', '0513', '320612', '121.073171,32.084287');
INSERT INTO `rg_region` VALUES ('15283', '15180', '3', '崇川区', 'ccq', 'chongchuanqu', '0513', '320602', '120.86635,32.015278');
INSERT INTO `rg_region` VALUES ('15302', '14721', '2', '淮安市', 'has', 'huaianshi', '0517', '320800', '119.021265,33.597506');
INSERT INTO `rg_region` VALUES ('15303', '15302', '3', '淮安区', 'haq', 'huaianqu', '0517', '320803', '119.14634,33.507499');
INSERT INTO `rg_region` VALUES ('15321', '15302', '3', '洪泽区', 'hzq', 'hongzequ', '0517', '320813', '118.867875,33.294975');
INSERT INTO `rg_region` VALUES ('15332', '15302', '3', '淮阴区', 'hyq', 'huaiyinqu', '0517', '320804', '119.020817,33.622452');
INSERT INTO `rg_region` VALUES ('15347', '15302', '3', '涟水县', 'lsx', 'lianshuixian', '0517', '320826', '119.266078,33.771308');
INSERT INTO `rg_region` VALUES ('15380', '15302', '3', '盱眙县', 'xyx', 'xuyixian', '0517', '320830', '118.493823,33.00439');
INSERT INTO `rg_region` VALUES ('15402', '15302', '3', '金湖县', 'jhx', 'jinhuxian', '0517', '320831', '119.016936,33.018162');
INSERT INTO `rg_region` VALUES ('15415', '15302', '3', '清江浦区', 'qjpq', 'qingjiangpuqu', '0517', '320812', '119.019454,33.603234');
INSERT INTO `rg_region` VALUES ('15439', '14721', '2', '盐城市', 'ycs', 'yanchengshi', '0515', '320900', '120.139998,33.377631');
INSERT INTO `rg_region` VALUES ('15440', '15439', '3', '响水县', 'xsx', 'xiangshuixian', '0515', '320921', '119.579573,34.19996');
INSERT INTO `rg_region` VALUES ('15452', '15439', '3', '滨海县', 'bhx', 'binhaixian', '0515', '320922', '119.828434,33.989888');
INSERT INTO `rg_region` VALUES ('15473', '15439', '3', '射阳县', 'syx', 'sheyangxian', '0515', '320924', '120.257444,33.773779');
INSERT INTO `rg_region` VALUES ('15493', '15439', '3', '阜宁县', 'fnx', 'funingxian', '0515', '320923', '119.805338,33.78573');
INSERT INTO `rg_region` VALUES ('15510', '15439', '3', '建湖县', 'jhx', 'jianhuxian', '0515', '320925', '119.793105,33.472621');
INSERT INTO `rg_region` VALUES ('15525', '15439', '3', '亭湖区', 'thq', 'tinghuqu', '0515', '320902', '120.136078,33.383912');
INSERT INTO `rg_region` VALUES ('15544', '15439', '3', '盐都区', 'ydq', 'yanduqu', '0515', '320903', '120.139753,33.341288');
INSERT INTO `rg_region` VALUES ('15566', '15439', '3', '大丰区', 'dfq', 'dafengqu', '0515', '320904', '120.470324,33.199531');
INSERT INTO `rg_region` VALUES ('15586', '15439', '3', '东台市', 'dts', 'dongtaishi', '0515', '320981', '120.314101,32.853174');
INSERT INTO `rg_region` VALUES ('15607', '14721', '2', '徐州市', 'xzs', 'xuzhoushi', '0516', '320300', '117.184811,34.261792');
INSERT INTO `rg_region` VALUES ('15608', '15607', '3', '丰县', 'fx', 'fengxian', '0516', '320321', '116.592888,34.696946');
INSERT INTO `rg_region` VALUES ('15625', '15607', '3', '邳州市', 'pzs', 'pizhoushi', '0516', '320382', '117.963923,34.314708');
INSERT INTO `rg_region` VALUES ('15651', '15607', '3', '新沂市', 'xys', 'xinyishi', '0516', '320381', '118.345828,34.368779');
INSERT INTO `rg_region` VALUES ('15671', '15607', '3', '泉山区', 'qsq', 'quanshanqu', '0516', '320311', '117.182225,34.262249');
INSERT INTO `rg_region` VALUES ('15687', '15607', '3', '铜山区', 'tsq', 'tongshanqu', '0516', '320312', '117.183894,34.19288');
INSERT INTO `rg_region` VALUES ('15712', '15607', '3', '睢宁县', 'snx', 'suiningxian', '0516', '320324', '117.95066,33.899222');
INSERT INTO `rg_region` VALUES ('15735', '15607', '3', '云龙区', 'ylq', 'yunlongqu', '0516', '320303', '117.194589,34.254805');
INSERT INTO `rg_region` VALUES ('15745', '15607', '3', '沛县', 'px', 'peixian', '0516', '320322', '116.937182,34.729044');
INSERT INTO `rg_region` VALUES ('15765', '15607', '3', '贾汪区', 'jwq', 'jiawangqu', '0516', '320305', '117.450212,34.441642');
INSERT INTO `rg_region` VALUES ('15779', '15607', '3', '鼓楼区', 'glq', 'gulouqu', '0516', '320302', '117.192941,34.269397');
INSERT INTO `rg_region` VALUES ('15789', '14721', '2', '扬州市', 'yzs', 'yangzhoushi', '0514', '321000', '119.421003,32.393159');
INSERT INTO `rg_region` VALUES ('15790', '15789', '3', '江都区', 'jdq', 'jiangduqu', '0514', '321012', '119.567481,32.426564');
INSERT INTO `rg_region` VALUES ('15805', '15789', '3', '邗江区', 'hjq', 'hanjiangqu', '0514', '321003', '119.397777,32.377899');
INSERT INTO `rg_region` VALUES ('15830', '15789', '3', '广陵区', 'glq', 'guanglingqu', '0514', '321002', '119.442267,32.392154');
INSERT INTO `rg_region` VALUES ('15843', '15789', '3', '仪征市', 'yzs', 'yizhengshi', '0514', '321081', '119.182443,32.271965');
INSERT INTO `rg_region` VALUES ('15863', '15789', '3', '高邮市', 'gys', 'gaoyoushi', '0514', '321084', '119.443842,32.785164');
INSERT INTO `rg_region` VALUES ('15879', '15789', '3', '宝应县', 'byx', 'baoyingxian', '0514', '321023', '119.321284,33.23694');
INSERT INTO `rg_region` VALUES ('15895', '14721', '2', '泰州市', 'tzs', 'taizhoushi', '0523', '321200', '119.915176,32.484882');
INSERT INTO `rg_region` VALUES ('15896', '15895', '3', '靖江市', 'jjs', 'jingjiangshi', '0523', '321282', '120.26825,32.018168');
INSERT INTO `rg_region` VALUES ('15910', '15895', '3', '高港区', 'ggq', 'gaogangqu', '0523', '321203', '119.88166,32.315701');
INSERT INTO `rg_region` VALUES ('15920', '15895', '3', '海陵区', 'hlq', 'hailingqu', '0523', '321202', '119.920187,32.488406');
INSERT INTO `rg_region` VALUES ('15936', '15895', '3', '姜堰区', 'jyq', 'jiangyanqu', '0523', '321204', '120.148208,32.508483');
INSERT INTO `rg_region` VALUES ('15953', '15895', '3', '兴化市', 'xhs', 'xinghuashi', '0523', '321281', '119.840162,32.938065');
INSERT INTO `rg_region` VALUES ('15982', '15895', '3', '泰兴市', 'txs', 'taixingshi', '0523', '321283', '120.020228,32.168784');
INSERT INTO `rg_region` VALUES ('15999', '14721', '2', '常州市', 'czs', 'changzhoushi', '0519', '320400', '119.946973,31.772752');
INSERT INTO `rg_region` VALUES ('16000', '15999', '3', '金坛区', 'jtq', 'jintanqu', '0519', '320413', '119.573395,31.744399');
INSERT INTO `rg_region` VALUES ('16010', '15999', '3', '溧阳市', 'lys', 'liyangshi', '0519', '320481', '119.487816,31.427081');
INSERT INTO `rg_region` VALUES ('16024', '15999', '3', '钟楼区', 'zlq', 'zhonglouqu', '0519', '320404', '119.948388,31.78096');
INSERT INTO `rg_region` VALUES ('16033', '15999', '3', '天宁区', 'tnq', 'tianningqu', '0519', '320402', '119.963783,31.779632');
INSERT INTO `rg_region` VALUES ('16041', '15999', '3', '新北区', 'xbq', 'xinbeiqu', '0519', '320411', '119.974654,31.824664');
INSERT INTO `rg_region` VALUES ('16052', '15999', '3', '武进区', 'wjq', 'wujinqu', '0519', '320412', '119.958773,31.718566');
INSERT INTO `rg_region` VALUES ('16069', '14721', '2', '无锡市', 'wxs', 'wuxishi', '0510', '320200', '120.301663,31.574729');
INSERT INTO `rg_region` VALUES ('16070', '16069', '3', '宜兴市', 'yxs', 'yixingshi', '0510', '320282', '119.820538,31.364384');
INSERT INTO `rg_region` VALUES ('16089', '16069', '3', '锡山区', 'xsq', 'xishanqu', '0510', '320205', '120.357298,31.585559');
INSERT INTO `rg_region` VALUES ('16098', '16069', '3', '梁溪区', 'lxq', 'liangxiqu', '0510', '320213', '120.296595,31.575706');
INSERT INTO `rg_region` VALUES ('16115', '16069', '3', '新吴区', 'xwq', 'xinwuqu', '0510', '320214', '120.352782,31.550966');
INSERT INTO `rg_region` VALUES ('16126', '16069', '3', '惠山区', 'hsq', 'huishanqu', '0510', '320206', '120.303543,31.681019');
INSERT INTO `rg_region` VALUES ('16134', '16069', '3', '江阴市', 'jys', 'jiangyinshi', '0510', '320281', '120.275891,31.910984');
INSERT INTO `rg_region` VALUES ('16151', '16069', '3', '滨湖区', 'bhq', 'binhuqu', '0510', '320211', '120.266053,31.550228');
INSERT INTO `rg_region` VALUES ('16161', '14721', '2', '苏州市', 'szs', 'suzhoushi', '0512', '320500', '120.619585,31.299379');
INSERT INTO `rg_region` VALUES ('16162', '16161', '3', '张家港市', 'zjgs', 'zhangjiagangshi', '0512', '320582', '120.543441,31.865553');
INSERT INTO `rg_region` VALUES ('16177', '16161', '3', '太仓市', 'tcs', 'taicangshi', '0512', '320585', '121.112275,31.452568');
INSERT INTO `rg_region` VALUES ('16186', '16161', '3', '常熟市', 'css', 'changshushi', '0512', '320581', '120.74852,31.658156');
INSERT INTO `rg_region` VALUES ('16202', '16161', '3', '虎丘区', 'hqq', 'huqiuqu', '0512', '320505', '120.566833,31.294845');
INSERT INTO `rg_region` VALUES ('16214', '16161', '3', '姑苏区', 'gsq', 'gusuqu', '0512', '320508', '120.622249,31.311414');
INSERT INTO `rg_region` VALUES ('16223', '16161', '3', '吴江区', 'wjq', 'wujiangqu', '0512', '320509', '120.641601,31.160404');
INSERT INTO `rg_region` VALUES ('16234', '16161', '3', '相城区', 'xcq', 'xiangchengqu', '0512', '320507', '120.618956,31.396684');
INSERT INTO `rg_region` VALUES ('16246', '16161', '3', '昆山市', 'kss', 'kunshanshi', '0512', '320583', '120.958137,31.381925');
INSERT INTO `rg_region` VALUES ('16258', '16161', '3', '苏州工业园区', 'szgyyq', 'suzhougongyeyuanqu', '0512', '320571', '120.723343,31.324036');
INSERT INTO `rg_region` VALUES ('16264', '16161', '3', '吴中区', 'wzq', 'wuzhongqu', '0512', '320506', '120.624621,31.270839');
INSERT INTO `rg_region` VALUES ('16281', '0', '1', '陕西省', 'sxs', 'shanxisheng', '', '610000', '108.948024,34.263161');
INSERT INTO `rg_region` VALUES ('16282', '16281', '2', '商洛市', 'sls', 'shangluoshi', '0914', '611000', '109.939776,33.868319');
INSERT INTO `rg_region` VALUES ('16283', '16282', '3', '商州区', 'szq', 'shangzhouqu', '0914', '611002', '109.937685,33.869208');
INSERT INTO `rg_region` VALUES ('16311', '16282', '3', '洛南县', 'lnx', 'luonanxian', '0914', '611021', '110.145716,34.088502');
INSERT INTO `rg_region` VALUES ('16328', '16282', '3', '柞水县', 'zsx', 'zuoshuixian', '0914', '611026', '109.111249,33.682773');
INSERT INTO `rg_region` VALUES ('16338', '16282', '3', '山阳县', 'syx', 'shanyangxian', '0914', '611024', '109.880435,33.530411');
INSERT INTO `rg_region` VALUES ('16358', '16282', '3', '丹凤县', 'dfx', 'danfengxian', '0914', '611022', '110.33191,33.694711');
INSERT INTO `rg_region` VALUES ('16371', '16282', '3', '镇安县', 'zax', 'zhenanxian', '0914', '611025', '109.151075,33.423981');
INSERT INTO `rg_region` VALUES ('16390', '16282', '3', '商南县', 'snx', 'shangnanxian', '0914', '611023', '110.885437,33.526367');
INSERT INTO `rg_region` VALUES ('16401', '16281', '2', '西安市', 'xas', 'xianshi', '029', '610100', '108.948024,34.263161');
INSERT INTO `rg_region` VALUES ('16402', '16401', '3', '阎良区', 'ylq', 'yanliangqu', '029', '610114', '109.22802,34.662141');
INSERT INTO `rg_region` VALUES ('16410', '16401', '3', '临潼区', 'ltq', 'lintongqu', '029', '610115', '109.213986,34.372065');
INSERT INTO `rg_region` VALUES ('16434', '16401', '3', '鄠邑区', 'hyq', 'huyiqu', '029', '610118', '108.607385,34.108668');
INSERT INTO `rg_region` VALUES ('16449', '16401', '3', '高陵区', 'glq', 'gaolingqu', '029', '610117', '109.088896,34.535065');
INSERT INTO `rg_region` VALUES ('16456', '16401', '3', '蓝田县', 'ltx', 'lantianxian', '029', '610122', '109.317634,34.156189');
INSERT INTO `rg_region` VALUES ('16476', '16401', '3', '长安区', 'caq', 'changanqu', '029', '610116', '108.941579,34.157097');
INSERT INTO `rg_region` VALUES ('16502', '16401', '3', '未央区', 'wyq', 'weiyangqu', '029', '610112', '108.946022,34.30823');
INSERT INTO `rg_region` VALUES ('16515', '16401', '3', '莲湖区', 'lhq', 'lianhuqu', '029', '610104', '108.933194,34.2656');
INSERT INTO `rg_region` VALUES ('16525', '16401', '3', '周至县', 'zzx', 'zhouzhixian', '029', '610124', '108.216465,34.161532');
INSERT INTO `rg_region` VALUES ('16546', '16401', '3', '新城区', 'xcq', 'xinchengqu', '029', '610102', '108.959903,34.26927');
INSERT INTO `rg_region` VALUES ('16556', '16401', '3', '灞桥区', 'bqq', 'baqiaoqu', '029', '610111', '109.067261,34.267453');
INSERT INTO `rg_region` VALUES ('16566', '16401', '3', '碑林区', 'blq', 'beilinqu', '029', '610103', '108.946994,34.251061');
INSERT INTO `rg_region` VALUES ('16575', '16401', '3', '雁塔区', 'ytq', 'yantaqu', '029', '610113', '108.926593,34.213389');
INSERT INTO `rg_region` VALUES ('16584', '16281', '2', '铜川市', 'tcs', 'tongchuanshi', '0919', '610200', '108.979608,34.916582');
INSERT INTO `rg_region` VALUES ('16585', '16584', '3', '宜君县', 'yjx', 'yijunxian', '0919', '610222', '109.118278,35.398766');
INSERT INTO `rg_region` VALUES ('16594', '16584', '3', '王益区', 'wyq', 'wangyiqu', '0919', '610202', '109.075862,35.069098');
INSERT INTO `rg_region` VALUES ('16602', '16584', '3', '印台区', 'ytq', 'yintaiqu', '0919', '610203', '109.100814,35.111927');
INSERT INTO `rg_region` VALUES ('16612', '16584', '3', '耀州区', 'yzq', 'yaozhouqu', '0919', '610204', '108.962538,34.910206');
INSERT INTO `rg_region` VALUES ('16627', '16281', '2', '汉中市', 'hzs', 'hanzhongshi', '0916', '610700', '107.028621,33.077668');
INSERT INTO `rg_region` VALUES ('16628', '16627', '3', '洋县', 'yx', 'yangxian', '0916', '610723', '107.549962,33.223283');
INSERT INTO `rg_region` VALUES ('16648', '16627', '3', '留坝县', 'lbx', 'liubaxian', '0916', '610729', '106.924377,33.61334');
INSERT INTO `rg_region` VALUES ('16657', '16627', '3', '佛坪县', 'fpx', 'fopingxian', '0916', '610730', '107.988582,33.520745');
INSERT INTO `rg_region` VALUES ('16665', '16627', '3', '宁强县', 'nqx', 'ningqiangxian', '0916', '610726', '106.25739,32.830806');
INSERT INTO `rg_region` VALUES ('16684', '16627', '3', '西乡县', 'xxx', 'xixiangxian', '0916', '610724', '107.765858,32.987961');
INSERT INTO `rg_region` VALUES ('16701', '16627', '3', '勉县', 'mx', 'mianxian', '0916', '610725', '106.680175,33.155618');
INSERT INTO `rg_region` VALUES ('16720', '16627', '3', '城固县', 'cgx', 'chengguxian', '0916', '610722', '107.329887,33.153098');
INSERT INTO `rg_region` VALUES ('16739', '16627', '3', '略阳县', 'lyx', 'l<eyangxian', '0916', '610727', '106.153899,33.329638');
INSERT INTO `rg_region` VALUES ('16757', '16627', '3', '汉台区', 'htq', 'hantaiqu', '0916', '610702', '107.028233,33.077674');
INSERT INTO `rg_region` VALUES ('16773', '16627', '3', '南郑区', 'nzq', 'nanzhengqu', '0916', '610703', '106.942393,33.003341');
INSERT INTO `rg_region` VALUES ('16795', '16627', '3', '镇巴县', 'zbx', 'zhenbaxian', '0916', '610728', '107.89531,32.535854');
INSERT INTO `rg_region` VALUES ('16816', '16281', '2', '安康市', 'aks', 'ankangshi', '0915', '610900', '109.029273,32.6903');
INSERT INTO `rg_region` VALUES ('16817', '16816', '3', '宁陕县', 'nsx', 'ningshanxian', '0915', '610923', '108.313714,33.312184');
INSERT INTO `rg_region` VALUES ('16829', '16816', '3', '汉阴县', 'hyx', 'hanyinxian', '0915', '610921', '108.510946,32.891121');
INSERT INTO `rg_region` VALUES ('16840', '16816', '3', '石泉县', 'sqx', 'shiquanxian', '0915', '610922', '108.250512,33.038512');
INSERT INTO `rg_region` VALUES ('16852', '16816', '3', '旬阳县', 'xyx', 'xunyangxian', '0915', '610928', '109.368149,32.833567');
INSERT INTO `rg_region` VALUES ('16874', '16816', '3', '汉滨区', 'hbq', 'hanbinqu', '0915', '610902', '109.029098,32.690817');
INSERT INTO `rg_region` VALUES ('16904', '16816', '3', '白河县', 'bhx', 'baihexian', '0915', '610929', '110.114186,32.809484');
INSERT INTO `rg_region` VALUES ('16916', '16816', '3', '平利县', 'plx', 'pinglixian', '0915', '610926', '109.361865,32.387933');
INSERT INTO `rg_region` VALUES ('16928', '16816', '3', '紫阳县', 'zyx', 'ziyangxian', '0915', '610924', '108.537788,32.520176');
INSERT INTO `rg_region` VALUES ('16946', '16816', '3', '镇坪县', 'zpx', 'zhenpingxian', '0915', '610927', '109.526437,31.883395');
INSERT INTO `rg_region` VALUES ('16954', '16816', '3', '岚皋县', 'lgx', 'langaoxian', '0915', '610925', '108.900663,32.31069');
INSERT INTO `rg_region` VALUES ('16967', '16281', '2', '榆林市', 'yls', 'yulinshi', '0912', '610800', '109.741193,38.290162');
INSERT INTO `rg_region` VALUES ('16968', '16967', '3', '府谷县', 'fgx', 'fuguxian', '0912', '610822', '111.069645,39.029243');
INSERT INTO `rg_region` VALUES ('16983', '16967', '3', '榆阳区', 'yyq', 'yuyangqu', '0912', '610802', '109.74791,38.299267');
INSERT INTO `rg_region` VALUES ('17011', '16967', '3', '靖边县', 'jbx', 'jingbianxian', '0912', '610824', '108.80567,37.596084');
INSERT INTO `rg_region` VALUES ('17029', '16967', '3', '子洲县', 'zzx', 'zizhouxian', '0912', '610831', '110.03457,37.611573');
INSERT INTO `rg_region` VALUES ('17043', '16967', '3', '佳县', 'jx', 'jiaxian', '0912', '610828', '110.493367,38.021597');
INSERT INTO `rg_region` VALUES ('17057', '16967', '3', '神木市', 'sms', 'shenmushi', '0912', '610881', '110.497005,38.835641');
INSERT INTO `rg_region` VALUES ('17073', '16967', '3', '横山区', 'hsq', 'hengshanqu', '0912', '610803', '109.292596,37.964048');
INSERT INTO `rg_region` VALUES ('17088', '16967', '3', '绥德县', 'sdx', 'suidexian', '0912', '610826', '110.265377,37.507701');
INSERT INTO `rg_region` VALUES ('17104', '16967', '3', '米脂县', 'mzx', 'mizhixian', '0912', '610827', '110.178683,37.759081');
INSERT INTO `rg_region` VALUES ('17114', '16967', '3', '吴堡县', 'wbx', 'wubaoxian', '0912', '610829', '110.739315,37.451925');
INSERT INTO `rg_region` VALUES ('17121', '16967', '3', '清涧县', 'qjx', 'qingjianxian', '0912', '610830', '110.12146,37.087702');
INSERT INTO `rg_region` VALUES ('17131', '16967', '3', '定边县', 'dbx', 'dingbianxian', '0912', '610825', '107.601284,37.59523');
INSERT INTO `rg_region` VALUES ('17151', '16281', '2', '延安市', 'yas', 'yananshi', '0911', '610600', '109.49081,36.596537');
INSERT INTO `rg_region` VALUES ('17152', '17151', '3', '子长县', 'zcx', 'zichangxian', '0911', '610623', '109.675968,37.14207');
INSERT INTO `rg_region` VALUES ('17162', '17151', '3', '吴起县', 'wqx', 'wuqixian', '0911', '610626', '108.176976,36.924852');
INSERT INTO `rg_region` VALUES ('17172', '17151', '3', '甘泉县', 'gqx', 'ganquanxian', '0911', '610627', '109.34961,36.277729');
INSERT INTO `rg_region` VALUES ('17179', '17151', '3', '延长县', 'ycx', 'yanchangxian', '0911', '610621', '110.012961,36.578306');
INSERT INTO `rg_region` VALUES ('17188', '17151', '3', '延川县', 'ycx', 'yanchuanxian', '0911', '610622', '110.190314,36.882066');
INSERT INTO `rg_region` VALUES ('17197', '17151', '3', '安塞区', 'asq', 'ansaiqu', '0911', '610603', '109.325341,36.86441');
INSERT INTO `rg_region` VALUES ('17207', '17151', '3', '富县', 'fx', 'fuxian', '0911', '610628', '109.384136,35.996495');
INSERT INTO `rg_region` VALUES ('17216', '17151', '3', '宝塔区', 'btq', 'baotaqu', '0911', '610602', '109.49069,36.596291');
INSERT INTO `rg_region` VALUES ('17235', '17151', '3', '志丹县', 'zdx', 'zhidanxian', '0911', '610625', '108.768898,36.823031');
INSERT INTO `rg_region` VALUES ('17244', '17151', '3', '宜川县', 'ycx', 'yichuanxian', '0911', '610630', '110.175537,36.050391');
INSERT INTO `rg_region` VALUES ('17252', '17151', '3', '洛川县', 'lcx', 'luochuanxian', '0911', '610629', '109.435712,35.762133');
INSERT INTO `rg_region` VALUES ('17262', '17151', '3', '黄陵县', 'hlx', 'huanglingxian', '0911', '610632', '109.262469,35.580165');
INSERT INTO `rg_region` VALUES ('17269', '17151', '3', '黄龙县', 'hlx', 'huanglongxian', '0911', '610631', '109.83502,35.583276');
INSERT INTO `rg_region` VALUES ('17277', '16281', '2', '咸阳市', 'xys', 'xianyangshi', '0910', '610400', '108.705117,34.333439');
INSERT INTO `rg_region` VALUES ('17278', '17277', '3', '彬州市', 'bzs', 'binzhoushi', '0910', '610482', '108.083674,35.034233');
INSERT INTO `rg_region` VALUES ('17288', '17277', '3', '旬邑县', 'xyx', 'xunyixian', '0910', '610429', '108.337231,35.112234');
INSERT INTO `rg_region` VALUES ('17299', '17277', '3', '乾县', 'qx', 'qianxian', '0910', '610424', '108.247406,34.527261');
INSERT INTO `rg_region` VALUES ('17316', '17277', '3', '淳化县', 'chx', 'chunhuaxian', '0910', '610430', '108.581173,34.79797');
INSERT INTO `rg_region` VALUES ('17325', '17277', '3', '永寿县', 'ysx', 'yongshouxian', '0910', '610426', '108.143129,34.692619');
INSERT INTO `rg_region` VALUES ('17333', '17277', '3', '渭城区', 'wcq', 'weichengqu', '0910', '610404', '108.730957,34.336847');
INSERT INTO `rg_region` VALUES ('17344', '17277', '3', '武功县', 'wgx', 'wugongxian', '0910', '610431', '108.212857,34.259732');
INSERT INTO `rg_region` VALUES ('17353', '17277', '3', '泾阳县', 'jyx', 'jingyangxian', '0910', '610423', '108.83784,34.528493');
INSERT INTO `rg_region` VALUES ('17367', '17277', '3', '长武县', 'cwx', 'changwuxian', '0910', '610428', '107.795835,35.206122');
INSERT INTO `rg_region` VALUES ('17376', '17277', '3', '秦都区', 'qdq', 'qinduqu', '0910', '610402', '108.698636,34.329801');
INSERT INTO `rg_region` VALUES ('17389', '17277', '3', '礼泉县', 'lqx', 'liquanxian', '0910', '610425', '108.428317,34.482583');
INSERT INTO `rg_region` VALUES ('17402', '17277', '3', '杨陵区', 'ylq', 'yanglingqu', '0910', '610403', '108.086348,34.27135');
INSERT INTO `rg_region` VALUES ('17408', '17277', '3', '兴平市', 'xps', 'xingpingshi', '0910', '610481', '108.488493,34.297134');
INSERT INTO `rg_region` VALUES ('17422', '17277', '3', '三原县', 'syx', 'sanyuanxian', '0910', '610422', '108.943481,34.613996');
INSERT INTO `rg_region` VALUES ('17433', '16281', '2', '宝鸡市', 'bjs', 'baojishi', '0917', '610300', '107.14487,34.369315');
INSERT INTO `rg_region` VALUES ('17434', '17433', '3', '陇县', 'lx', 'longxian', '0917', '610327', '106.857066,34.893262');
INSERT INTO `rg_region` VALUES ('17445', '17433', '3', '麟游县', 'lyx', 'linyouxian', '0917', '610329', '107.796608,34.677714');
INSERT INTO `rg_region` VALUES ('17453', '17433', '3', '千阳县', 'qyx', 'qianyangxian', '0917', '610328', '107.132987,34.642584');
INSERT INTO `rg_region` VALUES ('17461', '17433', '3', '岐山县', 'qsx', 'qishanxian', '0917', '610323', '107.624464,34.44296');
INSERT INTO `rg_region` VALUES ('17471', '17433', '3', '金台区', 'jtq', 'jintaiqu', '0917', '610303', '107.149943,34.375192');
INSERT INTO `rg_region` VALUES ('17483', '17433', '3', '渭滨区', 'wbq', 'weibinqu', '0917', '610302', '107.144467,34.371008');
INSERT INTO `rg_region` VALUES ('17494', '17433', '3', '凤县', 'fx', 'fengxian', '0917', '610330', '106.525212,33.912464');
INSERT INTO `rg_region` VALUES ('17506', '17433', '3', '眉县', 'mx', 'meixian', '0917', '610326', '107.752371,34.272137');
INSERT INTO `rg_region` VALUES ('17515', '17433', '3', '太白县', 'tbx', 'taibaixian', '0917', '610331', '107.316533,34.059215');
INSERT INTO `rg_region` VALUES ('17523', '17433', '3', '陈仓区', 'ccq', 'chencangqu', '0917', '610304', '107.383645,34.352747');
INSERT INTO `rg_region` VALUES ('17542', '17433', '3', '凤翔县', 'fxx', 'fengxiangxian', '0917', '610322', '107.400577,34.521668');
INSERT INTO `rg_region` VALUES ('17555', '17433', '3', '扶风县', 'ffx', 'fufengxian', '0917', '610324', '107.891419,34.375497');
INSERT INTO `rg_region` VALUES ('17564', '16281', '2', '渭南市', 'wns', 'weinanshi', '0913', '610500', '109.502882,34.499381');
INSERT INTO `rg_region` VALUES ('17565', '17564', '3', '韩城市', 'hcs', 'hanchengshi', '0913', '610581', '110.452391,35.475238');
INSERT INTO `rg_region` VALUES ('17574', '17564', '3', '白水县', 'bsx', 'baishuixian', '0913', '610527', '109.594309,35.177291');
INSERT INTO `rg_region` VALUES ('17583', '17564', '3', '华州区', 'hzq', 'huazhouqu', '0913', '610503', '109.76141,34.511958');
INSERT INTO `rg_region` VALUES ('17594', '17564', '3', '大荔县', 'dlx', 'dalixian', '0913', '610523', '109.943123,34.795011');
INSERT INTO `rg_region` VALUES ('17614', '17564', '3', '华阴市', 'hys', 'huayinshi', '0913', '610582', '110.08952,34.565359');
INSERT INTO `rg_region` VALUES ('17622', '17564', '3', '潼关县', 'tgx', 'tongguanxian', '0913', '610522', '110.24726,34.544515');
INSERT INTO `rg_region` VALUES ('17628', '17564', '3', '合阳县', 'hyx', 'heyangxian', '0913', '610524', '110.147979,35.237098');
INSERT INTO `rg_region` VALUES ('17641', '17564', '3', '澄城县', 'ccx', 'chengchengxian', '0913', '610525', '109.937609,35.184');
INSERT INTO `rg_region` VALUES ('17652', '17564', '3', '临渭区', 'lwq', 'linweiqu', '0913', '610502', '109.503299,34.501271');
INSERT INTO `rg_region` VALUES ('17677', '17564', '3', '蒲城县', 'pcx', 'puchengxian', '0913', '610526', '109.589653,34.956034');
INSERT INTO `rg_region` VALUES ('17694', '17564', '3', '富平县', 'fpx', 'fupingxian', '0913', '610528', '109.187174,34.746679');
INSERT INTO `rg_region` VALUES ('17710', '0', '1', '上海市', 'shs', 'shanghaishi', '021', '310000', '121.472644,31.231706');
INSERT INTO `rg_region` VALUES ('17711', '17710', '2', '上海城区', 'shcq', 'shanghaichengqu', '021', '310100', '121.472644,31.231706');
INSERT INTO `rg_region` VALUES ('17712', '17711', '3', '金山区', 'jsq', 'jinshanqu', '021', '310116', '121.330736,30.724697');
INSERT INTO `rg_region` VALUES ('17724', '17711', '3', '奉贤区', 'fxq', 'fengxianqu', '021', '310120', '121.458472,30.912345');
INSERT INTO `rg_region` VALUES ('17737', '17711', '3', '崇明区', 'cmq', 'chongmingqu', '021', '310151', '121.397516,31.626946');
INSERT INTO `rg_region` VALUES ('17759', '17711', '3', '浦东新区', 'pdxq', 'pudongxinqu', '021', '310115', '121.567706,31.245944');
INSERT INTO `rg_region` VALUES ('17799', '17711', '3', '嘉定区', 'jdq', 'jiadingqu', '021', '310114', '121.250333,31.383524');
INSERT INTO `rg_region` VALUES ('17812', '17711', '3', '普陀区', 'ptq', 'putuoqu', '021', '310107', '121.392499,31.241701');
INSERT INTO `rg_region` VALUES ('17823', '17711', '3', '宝山区', 'bsq', 'baoshanqu', '021', '310113', '121.489934,31.398896');
INSERT INTO `rg_region` VALUES ('17837', '17711', '3', '黄浦区', 'hpq', 'huangpuqu', '021', '310101', '121.490317,31.222771');
INSERT INTO `rg_region` VALUES ('17848', '17711', '3', '杨浦区', 'ypq', 'yangpuqu', '021', '310110', '121.522797,31.270755');
INSERT INTO `rg_region` VALUES ('17861', '17711', '3', '松江区', 'sjq', 'songjiangqu', '021', '310117', '121.223543,31.03047');
INSERT INTO `rg_region` VALUES ('17880', '17711', '3', '长宁区', 'cnq', 'changningqu', '021', '310105', '121.4222,31.218123');
INSERT INTO `rg_region` VALUES ('17891', '17711', '3', '虹口区', 'hkq', 'hongkouqu', '021', '310109', '121.491832,31.26097');
INSERT INTO `rg_region` VALUES ('17900', '17711', '3', '静安区', 'jaq', 'jinganqu', '021', '310106', '121.448224,31.229003');
INSERT INTO `rg_region` VALUES ('17915', '17711', '3', '徐汇区', 'xhq', 'xuhuiqu', '021', '310104', '121.43752,31.179973');
INSERT INTO `rg_region` VALUES ('17930', '17711', '3', '闵行区', 'mxq', 'minhangqu', '021', '310112', '121.375972,31.111658');
INSERT INTO `rg_region` VALUES ('17945', '17711', '3', '青浦区', 'qpq', 'qingpuqu', '021', '310118', '121.113021,31.151209');
INSERT INTO `rg_region` VALUES ('17957', '0', '1', '贵州省', 'gzs', 'guizhousheng', '', '520000', '106.713478,26.578343');
INSERT INTO `rg_region` VALUES ('17958', '17957', '2', '铜仁市', 'trs', 'tongrenshi', '0856', '520600', '109.191555,27.718346');
INSERT INTO `rg_region` VALUES ('17959', '17958', '3', '印江土家族苗族自治县', 'yjtjzmzzzx', 'yinjiangtujiazumiaozuzizhixian', '0856', '520625', '108.405517,27.997976');
INSERT INTO `rg_region` VALUES ('17977', '17958', '3', '石阡县', 'sqx', 'shiqianxian', '0856', '520623', '108.229854,27.519386');
INSERT INTO `rg_region` VALUES ('17996', '17958', '3', '玉屏侗族自治县', 'ypdzzzx', 'yupingdongzuzizhixian', '0856', '520622', '108.917882,27.238024');
INSERT INTO `rg_region` VALUES ('18004', '17958', '3', '碧江区', 'bjq', 'bijiangqu', '0856', '520602', '109.192117,27.718745');
INSERT INTO `rg_region` VALUES ('18018', '17958', '3', '思南县', 'snx', 'sinanxian', '0856', '520624', '108.255827,27.941331');
INSERT INTO `rg_region` VALUES ('18046', '17958', '3', '德江县', 'djx', 'dejiangxian', '0856', '520626', '108.117317,28.26094');
INSERT INTO `rg_region` VALUES ('18068', '17958', '3', '沿河土家族自治县', 'yhtjzzzx', 'yanhetujiazuzizhixian', '0856', '520627', '108.495746,28.560487');
INSERT INTO `rg_region` VALUES ('18091', '17958', '3', '江口县', 'jkx', 'jiangkouxian', '0856', '520621', '108.848427,27.691904');
INSERT INTO `rg_region` VALUES ('18101', '17958', '3', '万山区', 'wsq', 'wanshanqu', '0856', '520603', '109.21199,27.51903');
INSERT INTO `rg_region` VALUES ('18111', '17958', '3', '松桃苗族自治县', 'stmzzzx', 'songtaomiaozuzizhixian', '0856', '520628', '109.202627,28.165419');
INSERT INTO `rg_region` VALUES ('18140', '17957', '2', '遵义市', 'zys', 'zunyishi', '0852', '520300', '106.937265,27.706626');
INSERT INTO `rg_region` VALUES ('18141', '18140', '3', '绥阳县', 'syx', 'suiyangxian', '0852', '520323', '107.191024,27.951342');
INSERT INTO `rg_region` VALUES ('18157', '18140', '3', '桐梓县', 'tzx', 'tongzixian', '0852', '520322', '106.826591,28.131559');
INSERT INTO `rg_region` VALUES ('18182', '18140', '3', '余庆县', 'yqx', 'yuqingxian', '0852', '520329', '107.892566,27.221552');
INSERT INTO `rg_region` VALUES ('18193', '18140', '3', '湄潭县', 'mtx', 'meitanxian', '0852', '520328', '107.485723,27.765839');
INSERT INTO `rg_region` VALUES ('18211', '18140', '3', '汇川区', 'hcq', 'huichuanqu', '0852', '520303', '106.937265,27.706626');
INSERT INTO `rg_region` VALUES ('18226', '18140', '3', '红花岗区', 'hhgq', 'honghuagangqu', '0852', '520302', '106.943784,27.694395');
INSERT INTO `rg_region` VALUES ('18248', '18140', '3', '凤冈县', 'fgx', 'fenggangxian', '0852', '520327', '107.722021,27.960858');
INSERT INTO `rg_region` VALUES ('18263', '18140', '3', '仁怀市', 'rhs', 'renhuaishi', '0852', '520382', '106.412476,27.803377');
INSERT INTO `rg_region` VALUES ('18285', '18140', '3', '务川仡佬族苗族自治县', 'wcylzmzzzx', 'wuchuanyilaozumiaozuzizhixian', '0852', '520326', '107.887857,28.521567');
INSERT INTO `rg_region` VALUES ('18301', '18140', '3', '播州区', 'bzq', 'bozhouqu', '0852', '520304', '106.831668,27.535288');
INSERT INTO `rg_region` VALUES ('18323', '18140', '3', '赤水市', 'css', 'chishuishi', '0852', '520381', '105.698116,28.587057');
INSERT INTO `rg_region` VALUES ('18341', '18140', '3', '习水县', 'xsx', 'xishuixian', '0852', '520330', '106.200954,28.327826');
INSERT INTO `rg_region` VALUES ('18368', '18140', '3', '正安县', 'zax', 'zhenganxian', '0852', '520324', '107.441872,28.550337');
INSERT INTO `rg_region` VALUES ('18388', '18140', '3', '道真仡佬族苗族自治县', 'dzylzmzzzx', 'daozhenyilaozumiaozuzizhixian', '0852', '520325', '107.605342,28.880088');
INSERT INTO `rg_region` VALUES ('18403', '17957', '2', '六盘水市', 'lpss', 'liupanshuishi', '0858', '520200', '104.846743,26.584643');
INSERT INTO `rg_region` VALUES ('18404', '18403', '3', '钟山区', 'zsq', 'zhongshanqu', '0858', '520201', '104.846244,26.584805');
INSERT INTO `rg_region` VALUES ('18417', '18403', '3', '六枝特区', 'lztq', 'liuzhitequ', '0858', '520203', '105.474235,26.210662');
INSERT INTO `rg_region` VALUES ('18436', '18403', '3', '盘州市', 'pzs', 'panzhoushi', '0858', '520281', '104.468367,25.706966');
INSERT INTO `rg_region` VALUES ('18464', '18403', '3', '水城县', 'scx', 'shuichengxian', '0858', '520221', '104.95685,26.540478');
INSERT INTO `rg_region` VALUES ('18495', '17957', '2', '黔东南苗族侗族自治州', 'qdnmzdzzzz', 'qiandongnanmiaozudongzuzizhizhou', '0855', '522600', '107.977488,26.583352');
INSERT INTO `rg_region` VALUES ('18496', '18495', '3', '三穗县', 'ssx', 'sansuixian', '0855', '522624', '108.681121,26.959884');
INSERT INTO `rg_region` VALUES ('18506', '18495', '3', '雷山县', 'lsx', 'leishanxian', '0855', '522634', '108.079613,26.381027');
INSERT INTO `rg_region` VALUES ('18515', '18495', '3', '天柱县', 'tzx', 'tianzhuxian', '0855', '522627', '109.212798,26.909684');
INSERT INTO `rg_region` VALUES ('18532', '18495', '3', '黎平县', 'lpx', 'lipingxian', '0855', '522631', '109.136504,26.230636');
INSERT INTO `rg_region` VALUES ('18558', '18495', '3', '剑河县', 'jhx', 'jianhexian', '0855', '522629', '108.440499,26.727349');
INSERT INTO `rg_region` VALUES ('18571', '18495', '3', '锦屏县', 'jpx', 'jinpingxian', '0855', '522628', '109.20252,26.680625');
INSERT INTO `rg_region` VALUES ('18587', '18495', '3', '榕江县', 'rjx', 'rongjiangxian', '0855', '522632', '108.521026,25.931085');
INSERT INTO `rg_region` VALUES ('18607', '18495', '3', '从江县', 'cjx', 'congjiangxian', '0855', '522633', '108.912648,25.747058');
INSERT INTO `rg_region` VALUES ('18628', '18495', '3', '施秉县', 'sbx', 'shibingxian', '0855', '522623', '108.12678,27.034657');
INSERT INTO `rg_region` VALUES ('18637', '18495', '3', '镇远县', 'zyx', 'zhenyuanxian', '0855', '522625', '108.423656,27.050233');
INSERT INTO `rg_region` VALUES ('18650', '18495', '3', '凯里市', 'kls', 'kailishi', '0855', '522601', '107.977541,26.582964');
INSERT INTO `rg_region` VALUES ('18669', '18495', '3', '丹寨县', 'dzx', 'danzhaixian', '0855', '522636', '107.794808,26.199497');
INSERT INTO `rg_region` VALUES ('18676', '18495', '3', '麻江县', 'mjx', 'majiangxian', '0855', '522635', '107.593172,26.494803');
INSERT INTO `rg_region` VALUES ('18683', '18495', '3', '黄平县', 'hpx', 'huangpingxian', '0855', '522622', '107.901337,26.896973');
INSERT INTO `rg_region` VALUES ('18695', '18495', '3', '台江县', 'tjx', 'taijiangxian', '0855', '522630', '108.314637,26.669138');
INSERT INTO `rg_region` VALUES ('18704', '18495', '3', '岑巩县', 'cgx', 'cengongxian', '0855', '522626', '108.816459,27.173244');
INSERT INTO `rg_region` VALUES ('18716', '17957', '2', '黔西南布依族苗族自治州', 'qxnbyzmzzzz', 'qianxinanbuyizumiaozuzizhizhou', '0859', '522300', '104.897971,25.08812');
INSERT INTO `rg_region` VALUES ('18717', '18716', '3', '兴仁市', 'xrs', 'xingrenshi', '0859', '522302', '105.192778,25.431378');
INSERT INTO `rg_region` VALUES ('18734', '18716', '3', '安龙县', 'alx', 'anlongxian', '0859', '522328', '105.471498,25.108959');
INSERT INTO `rg_region` VALUES ('18748', '18716', '3', '册亨县', 'chx', 'cehengxian', '0859', '522327', '105.81241,24.983338');
INSERT INTO `rg_region` VALUES ('18761', '18716', '3', '兴义市', 'xys', 'xingyishi', '0859', '522301', '104.897982,25.088599');
INSERT INTO `rg_region` VALUES ('18792', '18716', '3', '普安县', 'pax', 'puanxian', '0859', '522323', '104.955347,25.786404');
INSERT INTO `rg_region` VALUES ('18805', '18716', '3', '望谟县', 'wmx', 'wangmoxian', '0859', '522326', '106.091563,25.166667');
INSERT INTO `rg_region` VALUES ('18821', '18716', '3', '贞丰县', 'zfx', 'zhenfengxian', '0859', '522325', '105.650133,25.385752');
INSERT INTO `rg_region` VALUES ('18835', '18716', '3', '晴隆县', 'qlx', 'qinglongxian', '0859', '522324', '105.218773,25.832881');
INSERT INTO `rg_region` VALUES ('18850', '17957', '2', '安顺市', 'ass', 'anshunshi', '0853', '520400', '105.932188,26.245544');
INSERT INTO `rg_region` VALUES ('18851', '18850', '3', '西秀区', 'xxq', 'xixiuqu', '0853', '520402', '105.946169,26.248323');
INSERT INTO `rg_region` VALUES ('18876', '18850', '3', '镇宁布依族苗族自治县', 'znbyzmzzzx', 'zhenningbuyizumiaozuzizhixian', '0853', '520423', '105.768656,26.056096');
INSERT INTO `rg_region` VALUES ('18893', '18850', '3', '关岭布依族苗族自治县', 'glbyzmzzzx', 'guanlingbuyizumiaozuzizhixian', '0853', '520424', '105.618454,25.944248');
INSERT INTO `rg_region` VALUES ('18908', '18850', '3', '紫云苗族布依族自治县', 'zymzbyzzzx', 'ziyunmiaozubuyizuzizhixian', '0853', '520425', '106.084515,25.751567');
INSERT INTO `rg_region` VALUES ('18921', '18850', '3', '平坝区', 'pbq', 'pingbaqu', '0853', '520403', '106.259942,26.40608');
INSERT INTO `rg_region` VALUES ('18933', '18850', '3', '普定县', 'pdx', 'pudingxian', '0853', '520422', '105.745609,26.305794');
INSERT INTO `rg_region` VALUES ('18945', '17957', '2', '黔南布依族苗族自治州', 'qnbyzmzzzz', 'qiannanbuyizumiaozuzizhizhou', '0854', '522700', '107.517156,26.258219');
INSERT INTO `rg_region` VALUES ('18946', '18945', '3', '惠水县', 'hsx', 'huishuixian', '0854', '522731', '106.657848,26.128637');
INSERT INTO `rg_region` VALUES ('18957', '18945', '3', '都匀市', 'dys', 'duyunshi', '0854', '522701', '107.517021,26.258205');
INSERT INTO `rg_region` VALUES ('18968', '18945', '3', '荔波县', 'lbx', 'liboxian', '0854', '522722', '107.8838,25.412239');
INSERT INTO `rg_region` VALUES ('18984', '18945', '3', '长顺县', 'csx', 'changshunxian', '0854', '522729', '106.447376,26.022116');
INSERT INTO `rg_region` VALUES ('18992', '18945', '3', '独山县', 'dsx', 'dushanxian', '0854', '522726', '107.542757,25.826283');
INSERT INTO `rg_region` VALUES ('19001', '18945', '3', '罗甸县', 'ldx', 'luodianxian', '0854', '522728', '106.750006,25.429894');
INSERT INTO `rg_region` VALUES ('19011', '18945', '3', '平塘县', 'ptx', 'pingtangxian', '0854', '522727', '107.32405,25.831803');
INSERT INTO `rg_region` VALUES ('19023', '18945', '3', '福泉市', 'fqs', 'fuquanshi', '0854', '522702', '107.513508,26.702508');
INSERT INTO `rg_region` VALUES ('19041', '18945', '3', '贵定县', 'gdx', 'guidingxian', '0854', '522723', '107.233588,26.580807');
INSERT INTO `rg_region` VALUES ('19050', '18945', '3', '三都水族自治县', 'sdszzzx', 'sandushuizuzizhixian', '0854', '522732', '107.87747,25.985183');
INSERT INTO `rg_region` VALUES ('19072', '18945', '3', '龙里县', 'llx', 'longlixian', '0854', '522730', '106.977733,26.448809');
INSERT INTO `rg_region` VALUES ('19079', '18945', '3', '瓮安县', 'wax', 'wenganxian', '0854', '522725', '107.478417,27.066339');
INSERT INTO `rg_region` VALUES ('19093', '17957', '2', '毕节市', 'bjs', 'bijieshi', '0857', '520500', '105.28501,27.301693');
INSERT INTO `rg_region` VALUES ('19094', '19093', '3', '七星关区', 'qxgq', 'qixingguanqu', '0857', '520502', '105.284852,27.302085');
INSERT INTO `rg_region` VALUES ('19140', '19093', '3', '黔西县', 'qxx', 'qianxixian', '0857', '520522', '106.038299,27.024923');
INSERT INTO `rg_region` VALUES ('19172', '19093', '3', '大方县', 'dfx', 'dafangxian', '0857', '520521', '105.609254,27.143521');
INSERT INTO `rg_region` VALUES ('19210', '19093', '3', '金沙县', 'jsx', 'jinshaxian', '0857', '520523', '106.222103,27.459693');
INSERT INTO `rg_region` VALUES ('19236', '19093', '3', '织金县', 'zjx', 'zhijinxian', '0857', '520524', '105.768997,26.668497');
INSERT INTO `rg_region` VALUES ('19269', '19093', '3', '纳雍县', 'nyx', 'nayongxian', '0857', '520525', '105.375322,26.769875');
INSERT INTO `rg_region` VALUES ('19296', '19093', '3', '赫章县', 'hzx', 'hezhangxian', '0857', '520527', '104.726438,27.119243');
INSERT INTO `rg_region` VALUES ('19324', '19093', '3', '威宁彝族回族苗族自治县', 'wnyzhzmzzzx', 'weiningyizuhuizumiaozuzizhixian', '0857', '520526', '104.286523,26.859099');
INSERT INTO `rg_region` VALUES ('19360', '17957', '2', '贵阳市', 'gys', 'guiyangshi', '0851', '520100', '106.713478,26.578343');
INSERT INTO `rg_region` VALUES ('19361', '19360', '3', '开阳县', 'kyx', 'kaiyangxian', '0851', '520121', '106.969438,27.056793');
INSERT INTO `rg_region` VALUES ('19380', '19360', '3', '乌当区', 'wdq', 'wudangqu', '0851', '520112', '106.762123,26.630928');
INSERT INTO `rg_region` VALUES ('19395', '19360', '3', '白云区', 'byq', 'baiyunqu', '0851', '520113', '106.633037,26.676849');
INSERT INTO `rg_region` VALUES ('19407', '19360', '3', '观山湖区', 'gshq', 'guanshanhuqu', '0851', '520115', '106.626323,26.646358');
INSERT INTO `rg_region` VALUES ('19419', '19360', '3', '息烽县', 'xfx', 'xifengxian', '0851', '520122', '106.737693,27.092665');
INSERT INTO `rg_region` VALUES ('19431', '19360', '3', '修文县', 'xwx', 'xiuwenxian', '0851', '520123', '106.599218,26.840672');
INSERT INTO `rg_region` VALUES ('19443', '19360', '3', '清镇市', 'qzs', 'qingzhenshi', '0851', '520181', '106.470278,26.551289');
INSERT INTO `rg_region` VALUES ('19458', '19360', '3', '南明区', 'nmq', 'nanmingqu', '0851', '520102', '106.715963,26.573743');
INSERT INTO `rg_region` VALUES ('19481', '19360', '3', '云岩区', 'yyq', 'yunyanqu', '0851', '520103', '106.713397,26.58301');
INSERT INTO `rg_region` VALUES ('19509', '19360', '3', '花溪区', 'hxq', 'huaxiqu', '0851', '520111', '106.670791,26.410464');
INSERT INTO `rg_region` VALUES ('19539', '0', '1', '重庆市', 'cqs', 'chongqingshi', '023', '500000', '106.504962,29.533155');
INSERT INTO `rg_region` VALUES ('19540', '19539', '2', '重庆城区', 'cqcq', 'chongqingchengqu', '023', '500100', '106.504962,29.533155');
INSERT INTO `rg_region` VALUES ('19541', '19540', '3', '潼南区', 'tnq', 'tongnanqu', '023', '500152', '105.841818,30.189554');
INSERT INTO `rg_region` VALUES ('19564', '19540', '3', '合川区', 'hcq', 'hechuanqu', '023', '500117', '106.265554,29.990993');
INSERT INTO `rg_region` VALUES ('19595', '19540', '3', '大足区', 'dzq', 'dazuqu', '023', '500111', '105.715319,29.700498');
INSERT INTO `rg_region` VALUES ('19623', '19540', '3', '长寿区', 'csq', 'changshouqu', '023', '500115', '107.074854,29.833671');
INSERT INTO `rg_region` VALUES ('19642', '19540', '3', '渝中区', 'yzq', 'yuzhongqu', '023', '500103', '106.56288,29.556742');
INSERT INTO `rg_region` VALUES ('19654', '19540', '3', '璧山区', 'bsq', 'bishanqu', '023', '500120', '106.231126,29.593581');
INSERT INTO `rg_region` VALUES ('19670', '19540', '3', '铜梁区', 'tlq', 'tongliangqu', '023', '500151', '106.054948,29.839944');
INSERT INTO `rg_region` VALUES ('19699', '19540', '3', '江北区', 'jbq', 'jiangbeiqu', '023', '500105', '106.532844,29.575352');
INSERT INTO `rg_region` VALUES ('19712', '19540', '3', '荣昌区', 'rcq', 'rongchangqu', '023', '500153', '105.594061,29.403627');
INSERT INTO `rg_region` VALUES ('19734', '19540', '3', '永川区', 'ycq', 'yongchuanqu', '023', '500118', '105.894714,29.348748');
INSERT INTO `rg_region` VALUES ('19758', '19540', '3', '武隆区', 'wlq', 'wulongqu', '023', '500156', '107.75655,29.32376');
INSERT INTO `rg_region` VALUES ('19786', '19540', '3', '渝北区', 'ybq', 'yubeiqu', '023', '500112', '106.512851,29.601451');
INSERT INTO `rg_region` VALUES ('19817', '19540', '3', '南川区', 'ncq', 'nanchuanqu', '023', '500119', '107.098153,29.156646');
INSERT INTO `rg_region` VALUES ('19852', '19540', '3', '万州区', 'wzq', 'wanzhouqu', '023', '500101', '108.380246,30.807807');
INSERT INTO `rg_region` VALUES ('19905', '19540', '3', '大渡口区', 'ddkq', 'dadukouqu', '023', '500104', '106.48613,29.481002');
INSERT INTO `rg_region` VALUES ('19914', '19540', '3', '綦江区', 'qjq', 'qijiangqu', '023', '500110', '106.651417,29.028091');
INSERT INTO `rg_region` VALUES ('19945', '19540', '3', '九龙坡区', 'jlpq', 'jiulongpoqu', '023', '500107', '106.480989,29.523492');
INSERT INTO `rg_region` VALUES ('19964', '19540', '3', '涪陵区', 'flq', 'fulingqu', '023', '500102', '107.394905,29.703652');
INSERT INTO `rg_region` VALUES ('19991', '19540', '3', '梁平区', 'lpq', 'liangpingqu', '023', '500155', '107.800034,30.672168');
INSERT INTO `rg_region` VALUES ('20027', '19540', '3', '开州区', 'kzq', 'kaizhouqu', '023', '500154', '108.413317,31.167735');
INSERT INTO `rg_region` VALUES ('20068', '19540', '3', '黔江区', 'qjq', 'qianjiangqu', '023', '500114', '108.782577,29.527548');
INSERT INTO `rg_region` VALUES ('20099', '19540', '3', '江津区', 'jjq', 'jiangjinqu', '023', '500116', '106.253156,29.283387');
INSERT INTO `rg_region` VALUES ('20128', '19540', '3', '沙坪坝区', 'spbq', 'shapingbaqu', '023', '500106', '106.4542,29.541224');
INSERT INTO `rg_region` VALUES ('20155', '19540', '3', '南岸区', 'naq', 'nananqu', '023', '500108', '106.560813,29.523992');
INSERT INTO `rg_region` VALUES ('20171', '19540', '3', '巴南区', 'bnq', 'bananqu', '023', '500113', '106.519423,29.381919');
INSERT INTO `rg_region` VALUES ('20194', '19540', '3', '北碚区', 'bbq', 'beibeiqu', '023', '500109', '106.437868,29.82543');
INSERT INTO `rg_region` VALUES ('20212', '19539', '2', '重庆郊县', 'cqjx', 'chongqingjiaoxian', '023', '500200', '108.170255,29.291965');
INSERT INTO `rg_region` VALUES ('20213', '20212', '3', '奉节县', 'fjx', 'fengjiexian', '023', '500236', '109.465774,31.019967');
INSERT INTO `rg_region` VALUES ('20245', '20212', '3', '丰都县', 'fdx', 'fengduxian', '023', '500230', '107.73248,29.866424');
INSERT INTO `rg_region` VALUES ('20276', '20212', '3', '城口县', 'ckx', 'chengkouxian', '023', '500229', '108.6649,31.946293');
INSERT INTO `rg_region` VALUES ('20302', '20212', '3', '巫溪县', 'wxx', 'wuxixian', '023', '500238', '109.628912,31.3966');
INSERT INTO `rg_region` VALUES ('20336', '20212', '3', '彭水苗族土家族自治县', 'psmztjzzzx', 'pengshuimiaozutujiazuzizhixian', '023', '500243', '108.166551,29.293856');
INSERT INTO `rg_region` VALUES ('20376', '20212', '3', '巫山县', 'wsx', 'wushanxian', '023', '500237', '109.878928,31.074843');
INSERT INTO `rg_region` VALUES ('20403', '20212', '3', '云阳县', 'yyx', 'yunyangxian', '023', '500235', '108.697698,30.930529');
INSERT INTO `rg_region` VALUES ('20446', '20212', '3', '秀山土家族苗族自治县', 'xstjzmzzzx', 'xiushantujiazumiaozuzizhixian', '023', '500241', '108.996043,28.444772');
INSERT INTO `rg_region` VALUES ('20474', '20212', '3', '垫江县', 'djx', 'dianjiangxian', '023', '500231', '107.348692,30.330012');
INSERT INTO `rg_region` VALUES ('20501', '20212', '3', '酉阳土家族苗族自治县', 'yytjzmzzzx', 'youyangtujiazumiaozuzizhixian', '023', '500242', '108.767201,28.839828');
INSERT INTO `rg_region` VALUES ('20541', '20212', '3', '忠县', 'zx', 'zhongxian', '023', '500233', '108.037518,30.291537');
INSERT INTO `rg_region` VALUES ('20571', '20212', '3', '石柱土家族自治县', 'sztjzzzx', 'shizhutujiazuzizhixian', '023', '500240', '108.112448,29.99853');
INSERT INTO `rg_region` VALUES ('20605', '0', '1', '西藏自治区', 'xczzq', 'xicangzizhiqu', '', '540000', '91.132212,29.660361');
INSERT INTO `rg_region` VALUES ('20606', '20605', '2', '那曲市', 'nqs', 'naqushi', '0896', '540600', '92.060214,31.476004');
INSERT INTO `rg_region` VALUES ('20607', '20606', '3', '安多县', 'adx', 'anduoxian', '0896', '540624', '91.681879,32.260299');
INSERT INTO `rg_region` VALUES ('20617', '20606', '3', '巴青县', 'bqx', 'baqingxian', '0896', '540628', '94.054049,31.918691');
INSERT INTO `rg_region` VALUES ('20628', '20606', '3', '聂荣县', 'nrx', 'nierongxian', '0896', '540623', '92.303659,32.107855');
INSERT INTO `rg_region` VALUES ('20639', '20606', '3', '索县', 'sx', 'suoxian', '0896', '540626', '93.784964,31.886173');
INSERT INTO `rg_region` VALUES ('20650', '20606', '3', '比如县', 'brx', 'biruxian', '0896', '540622', '93.68044,31.479917');
INSERT INTO `rg_region` VALUES ('20661', '20606', '3', '申扎县', 'szx', 'shenzaxian', '0896', '540625', '88.709777,30.929056');
INSERT INTO `rg_region` VALUES ('20670', '20606', '3', '色尼区', 'snq', 'seniqu', '0896', '540602', '92.061862,31.475756');
INSERT INTO `rg_region` VALUES ('20683', '20606', '3', '班戈县', 'bgx', 'bangexian', '0896', '540627', '90.011822,31.394578');
INSERT INTO `rg_region` VALUES ('20694', '20606', '3', '嘉黎县', 'jlx', 'jialixian', '0896', '540621', '93.232907,30.640846');
INSERT INTO `rg_region` VALUES ('20705', '20606', '3', '尼玛县', 'nmx', 'nimaxian', '0896', '540629', '87.236646,31.784979');
INSERT INTO `rg_region` VALUES ('20720', '20606', '3', '双湖县', 'shx', 'shuanghuxian', '0896', '540630', '88.838578,33.18698');
INSERT INTO `rg_region` VALUES ('20728', '20605', '2', '昌都市', 'cds', 'changdushi', '0895', '540300', '97.178452,31.136875');
INSERT INTO `rg_region` VALUES ('20729', '20728', '3', '丁青县', 'dqx', 'dingqingxian', '0895', '540324', '95.597748,31.410681');
INSERT INTO `rg_region` VALUES ('20743', '20728', '3', '类乌齐县', 'lwqx', 'leiwuqixian', '0895', '540323', '96.601259,31.213048');
INSERT INTO `rg_region` VALUES ('20754', '20728', '3', '江达县', 'jdx', 'jiangdaxian', '0895', '540321', '98.218351,31.499534');
INSERT INTO `rg_region` VALUES ('20768', '20728', '3', '卡若区', 'qrq', 'qiaruoqu', '0895', '540302', '97.178255,31.137035');
INSERT INTO `rg_region` VALUES ('20784', '20728', '3', '边坝县', 'bbx', 'bianbaxian', '0895', '540330', '94.707504,30.933849');
INSERT INTO `rg_region` VALUES ('20796', '20728', '3', '贡觉县', 'gjx', 'gongjuexian', '0895', '540322', '98.271191,30.859206');
INSERT INTO `rg_region` VALUES ('20809', '20728', '3', '洛隆县', 'llx', 'luolongxian', '0895', '540329', '95.823418,30.741947');
INSERT INTO `rg_region` VALUES ('20821', '20728', '3', '察雅县', 'cyx', 'chayaxian', '0895', '540325', '97.565701,30.653038');
INSERT INTO `rg_region` VALUES ('20835', '20728', '3', '八宿县', 'bsx', 'basuxian', '0895', '540326', '96.917893,30.053408');
INSERT INTO `rg_region` VALUES ('20850', '20728', '3', '左贡县', 'zgx', 'zuogongxian', '0895', '540327', '97.840532,29.671335');
INSERT INTO `rg_region` VALUES ('20861', '20728', '3', '芒康县', 'mkx', 'mangkangxian', '0895', '540328', '98.596444,29.686615');
INSERT INTO `rg_region` VALUES ('20878', '20605', '2', '日喀则市', 'rkzs', 'rikazeshi', '0892', '540200', '88.885148,29.267519');
INSERT INTO `rg_region` VALUES ('20879', '20878', '3', '仲巴县', 'zbx', 'zhongbaxian', '0892', '540232', '84.032826,29.768336');
INSERT INTO `rg_region` VALUES ('20893', '20878', '3', '昂仁县', 'arx', 'angrenxian', '0892', '540226', '87.23578,29.294758');
INSERT INTO `rg_region` VALUES ('20911', '20878', '3', '谢通门县', 'xtmx', 'xietongmenxian', '0892', '540227', '88.260517,29.431597');
INSERT INTO `rg_region` VALUES ('20931', '20878', '3', '南木林县', 'nmlx', 'nanmulinxian', '0892', '540221', '89.099434,29.680459');
INSERT INTO `rg_region` VALUES ('20949', '20878', '3', '萨嘎县', 'sgx', 'sagaxian', '0892', '540236', '85.234622,29.328194');
INSERT INTO `rg_region` VALUES ('20958', '20878', '3', '桑珠孜区', 'szzq', 'sangzhuziqu', '0892', '540202', '88.88667,29.267003');
INSERT INTO `rg_region` VALUES ('20971', '20878', '3', '拉孜县', 'lzx', 'lazixian', '0892', '540225', '87.63743,29.085136');
INSERT INTO `rg_region` VALUES ('20983', '20878', '3', '仁布县', 'rbx', 'renbuxian', '0892', '540229', '89.843207,29.230299');
INSERT INTO `rg_region` VALUES ('20993', '20878', '3', '萨迦县', 'sjx', 'sajiaxian', '0892', '540224', '88.023007,28.901077');
INSERT INTO `rg_region` VALUES ('21005', '20878', '3', '吉隆县', 'jlx', 'jilongxian', '0892', '540234', '85.298349,28.852416');
INSERT INTO `rg_region` VALUES ('21011', '20878', '3', '康马县', 'kmx', 'kangmaxian', '0892', '540230', '89.683406,28.554719');
INSERT INTO `rg_region` VALUES ('21021', '20878', '3', '江孜县', 'jzx', 'jiangzixian', '0892', '540222', '89.605044,28.908845');
INSERT INTO `rg_region` VALUES ('21041', '20878', '3', '白朗县', 'blx', 'bailangxian', '0892', '540228', '89.263618,29.106627');
INSERT INTO `rg_region` VALUES ('21053', '20878', '3', '定日县', 'drx', 'dingrixian', '0892', '540223', '87.123887,28.656667');
INSERT INTO `rg_region` VALUES ('21067', '20878', '3', '聂拉木县', 'nlmx', 'nielamuxian', '0892', '540235', '85.981953,28.15595');
INSERT INTO `rg_region` VALUES ('21075', '20878', '3', '岗巴县', 'gbx', 'gangbaxian', '0892', '540237', '88.518903,28.274371');
INSERT INTO `rg_region` VALUES ('21081', '20878', '3', '亚东县', 'ydx', 'yadongxian', '0892', '540233', '88.906806,27.482772');
INSERT INTO `rg_region` VALUES ('21089', '20878', '3', '定结县', 'djx', 'dingjiexian', '0892', '540231', '87.767723,28.36409');
INSERT INTO `rg_region` VALUES ('21100', '20605', '2', '拉萨市', 'lss', 'lasashi', '0891', '540100', '91.132212,29.660361');
INSERT INTO `rg_region` VALUES ('21101', '21100', '3', '当雄县', 'dxx', 'dangxiongxian', '0891', '540122', '91.103551,30.474819');
INSERT INTO `rg_region` VALUES ('21110', '21100', '3', '林周县', 'lzx', 'linzhouxian', '0891', '540121', '91.261842,29.895754');
INSERT INTO `rg_region` VALUES ('21121', '21100', '3', '墨竹工卡县', 'mzgqx', 'mozhugongqiaxian', '0891', '540127', '91.731158,29.834657');
INSERT INTO `rg_region` VALUES ('21130', '21100', '3', '堆龙德庆区', 'dldqq', 'duilongdeqingqu', '0891', '540103', '91.002823,29.647347');
INSERT INTO `rg_region` VALUES ('21138', '21100', '3', '城关区', 'cgq', 'chengguanqu', '0891', '540102', '91.132911,29.659472');
INSERT INTO `rg_region` VALUES ('21151', '21100', '3', '达孜区', 'dzq', 'daziqu', '0891', '540104', '91.350976,29.670314');
INSERT INTO `rg_region` VALUES ('21158', '21100', '3', '尼木县', 'nmx', 'nimuxian', '0891', '540123', '90.165545,29.431346');
INSERT INTO `rg_region` VALUES ('21167', '21100', '3', '曲水县', 'qsx', 'qushuixian', '0891', '540124', '90.738051,29.349895');
INSERT INTO `rg_region` VALUES ('21174', '20605', '2', '山南市', 'sns', 'shannanshi', '0893', '540500', '91.766529,29.236023');
INSERT INTO `rg_region` VALUES ('21175', '21174', '3', '加查县', 'jcx', 'jiachaxian', '0893', '540528', '92.591043,29.140921');
INSERT INTO `rg_region` VALUES ('21183', '21174', '3', '桑日县', 'srx', 'sangrixian', '0893', '540523', '92.015732,29.259774');
INSERT INTO `rg_region` VALUES ('21188', '21174', '3', '乃东区', 'ndq', 'naidongqu', '0893', '540502', '91.76525,29.236106');
INSERT INTO `rg_region` VALUES ('21196', '21174', '3', '贡嘎县', 'ggx', 'gonggaxian', '0893', '540522', '90.985271,29.289078');
INSERT INTO `rg_region` VALUES ('21205', '21174', '3', '扎囊县', 'znx', 'zanangxian', '0893', '540521', '91.338,29.246476');
INSERT INTO `rg_region` VALUES ('21211', '21174', '3', '浪卡子县', 'lqzx', 'langqiazixian', '0893', '540531', '90.398747,28.96836');
INSERT INTO `rg_region` VALUES ('21222', '21174', '3', '措美县', 'cmx', 'cuomoixian', '0893', '540526', '91.432347,28.437353');
INSERT INTO `rg_region` VALUES ('21227', '21174', '3', '曲松县', 'qsx', 'qusongxian', '0893', '540525', '92.201066,29.063656');
INSERT INTO `rg_region` VALUES ('21233', '21174', '3', '隆子县', 'lzx', 'longzixian', '0893', '540529', '92.463309,28.408548');
INSERT INTO `rg_region` VALUES ('21245', '21174', '3', '琼结县', 'qjx', 'qiongjiexian', '0893', '540524', '91.683753,29.025242');
INSERT INTO `rg_region` VALUES ('21250', '21174', '3', '错那县', 'cnx', 'cuonaxian', '0893', '540530', '91.960132,27.991707');
INSERT INTO `rg_region` VALUES ('21261', '21174', '3', '洛扎县', 'lzx', 'luozaxian', '0893', '540527', '90.858243,28.385765');
INSERT INTO `rg_region` VALUES ('21269', '20605', '2', '阿里地区', 'aldq', 'alidiqu', '0897', '542500', '80.105498,32.503187');
INSERT INTO `rg_region` VALUES ('21270', '21269', '3', '改则县', 'gzx', 'gaizexian', '0897', '542526', '84.062384,32.302076');
INSERT INTO `rg_region` VALUES ('21278', '21269', '3', '札达县', 'zdx', 'zhadaxian', '0897', '542522', '79.803191,31.478587');
INSERT INTO `rg_region` VALUES ('21286', '21269', '3', '措勤县', 'cqx', 'cuoqinxian', '0897', '542527', '85.159254,31.016774');
INSERT INTO `rg_region` VALUES ('21292', '21269', '3', '普兰县', 'plx', 'pulanxian', '0897', '542521', '81.177588,30.291896');
INSERT INTO `rg_region` VALUES ('21296', '21269', '3', '革吉县', 'gjx', 'gejixian', '0897', '542525', '81.142896,32.389192');
INSERT INTO `rg_region` VALUES ('21302', '21269', '3', '日土县', 'rtx', 'rituxian', '0897', '542524', '79.731937,33.382454');
INSERT INTO `rg_region` VALUES ('21308', '21269', '3', '噶尔县', 'gox', 'gaorxian', '0897', '542523', '80.105005,32.503373');
INSERT INTO `rg_region` VALUES ('21314', '20605', '2', '林芝市', 'lzs', 'linzhishi', '0894', '540400', '94.362348,29.654693');
INSERT INTO `rg_region` VALUES ('21315', '21314', '3', '波密县', 'bmx', 'bomixian', '0894', '540424', '95.768151,29.858771');
INSERT INTO `rg_region` VALUES ('21326', '21314', '3', '工布江达县', 'gbjdx', 'gongbujiangdaxian', '0894', '540421', '93.246515,29.88447');
INSERT INTO `rg_region` VALUES ('21336', '21314', '3', '巴宜区', 'byq', 'bayiqu', '0894', '540402', '94.360987,29.653732');
INSERT INTO `rg_region` VALUES ('21344', '21314', '3', '墨脱县', 'mtx', 'motuoxian', '0894', '540423', '95.332245,29.32573');
INSERT INTO `rg_region` VALUES ('21353', '21314', '3', '米林县', 'mlx', 'milinxian', '0894', '540422', '94.213679,29.213811');
INSERT INTO `rg_region` VALUES ('21362', '21314', '3', '朗县', 'lx', 'langxian', '0894', '540426', '93.073429,29.0446');
INSERT INTO `rg_region` VALUES ('21369', '21314', '3', '察隅县', 'cyx', 'chayuxian', '0894', '540425', '97.465002,28.660244');
INSERT INTO `rg_region` VALUES ('21376', '0', '1', '安徽省', 'ahs', 'anhuisheng', '', '340000', '117.283042,31.86119');
INSERT INTO `rg_region` VALUES ('21377', '21376', '2', '亳州市', 'bzs', 'bozhoushi', '0558', '341600', '115.782939,33.869338');
INSERT INTO `rg_region` VALUES ('21378', '21377', '3', '谯城区', 'qcq', 'qiaochengqu', '0558', '341602', '115.781214,33.869284');
INSERT INTO `rg_region` VALUES ('21406', '21377', '3', '涡阳县', 'wyx', 'woyangxian', '0558', '341621', '116.211551,33.502831');
INSERT INTO `rg_region` VALUES ('21432', '21377', '3', '蒙城县', 'mcx', 'mengchengxian', '0558', '341622', '116.560337,33.260814');
INSERT INTO `rg_region` VALUES ('21455', '21377', '3', '利辛县', 'lxx', 'lixinxian', '0558', '341623', '116.207782,33.143503');
INSERT INTO `rg_region` VALUES ('21481', '21376', '2', '马鞍山市', 'mass', 'maanshanshi', '0555', '340500', '118.507906,31.689362');
INSERT INTO `rg_region` VALUES ('21482', '21481', '3', '博望区', 'bwq', 'bowangqu', '0555', '340506', '118.843742,31.562321');
INSERT INTO `rg_region` VALUES ('21487', '21481', '3', '当涂县', 'dtx', 'dangtuxian', '0555', '340521', '118.489873,31.556167');
INSERT INTO `rg_region` VALUES ('21502', '21481', '3', '花山区', 'hsq', 'huashanqu', '0555', '340503', '118.511308,31.69902');
INSERT INTO `rg_region` VALUES ('21515', '21481', '3', '雨山区', 'ysq', 'yushanqu', '0555', '340504', '118.493104,31.685912');
INSERT INTO `rg_region` VALUES ('21524', '21481', '3', '和县', 'hx', 'hexian', '0555', '340523', '118.362998,31.716634');
INSERT INTO `rg_region` VALUES ('21537', '21481', '3', '含山县', 'hsx', 'hanshanxian', '0555', '340522', '118.105545,31.727758');
INSERT INTO `rg_region` VALUES ('21549', '21376', '2', '淮北市', 'hbs', 'huaibeishi', '0561', '340600', '116.794664,33.971707');
INSERT INTO `rg_region` VALUES ('21550', '21549', '3', '濉溪县', 'sxx', 'suixixian', '0561', '340621', '116.767435,33.916407');
INSERT INTO `rg_region` VALUES ('21564', '21549', '3', '相山区', 'xsq', 'xiangshanqu', '0561', '340603', '116.790775,33.970916');
INSERT INTO `rg_region` VALUES ('21576', '21549', '3', '杜集区', 'djq', 'dujiqu', '0561', '340602', '116.833925,33.991218');
INSERT INTO `rg_region` VALUES ('21582', '21549', '3', '烈山区', 'lsq', 'lieshanqu', '0561', '340604', '116.809465,33.889529');
INSERT INTO `rg_region` VALUES ('21588', '21376', '2', '蚌埠市', 'bbs', 'bangbushi', '0552', '340300', '117.363228,32.939667');
INSERT INTO `rg_region` VALUES ('21589', '21588', '3', '固镇县', 'gzx', 'guzhenxian', '0552', '340323', '117.315962,33.318679');
INSERT INTO `rg_region` VALUES ('21602', '21588', '3', '淮上区', 'hsq', 'huaishangqu', '0552', '340311', '117.34709,32.963147');
INSERT INTO `rg_region` VALUES ('21611', '21588', '3', '五河县', 'whx', 'wuhexian', '0552', '340322', '117.888809,33.146202');
INSERT INTO `rg_region` VALUES ('21627', '21588', '3', '怀远县', 'hyx', 'huaiyuanxian', '0552', '340321', '117.200171,32.956934');
INSERT INTO `rg_region` VALUES ('21648', '21588', '3', '禹会区', 'yhq', 'yuhuiqu', '0552', '340304', '117.35259,32.931933');
INSERT INTO `rg_region` VALUES ('21655', '21588', '3', '蚌山区', 'bsq', 'bangshanqu', '0552', '340303', '117.355789,32.938066');
INSERT INTO `rg_region` VALUES ('21667', '21588', '3', '龙子湖区', 'lzhq', 'longzihuqu', '0552', '340302', '117.382312,32.950452');
INSERT INTO `rg_region` VALUES ('21676', '21376', '2', '池州市', 'czs', 'chizhoushi', '0566', '341700', '117.489157,30.656037');
INSERT INTO `rg_region` VALUES ('21677', '21676', '3', '青阳县', 'qyx', 'qingyangxian', '0566', '341723', '117.857395,30.63818');
INSERT INTO `rg_region` VALUES ('21692', '21676', '3', '东至县', 'dzx', 'dongzhixian', '0566', '341721', '117.021476,30.096568');
INSERT INTO `rg_region` VALUES ('21710', '21676', '3', '贵池区', 'gcq', 'guichiqu', '0566', '341702', '117.488342,30.657378');
INSERT INTO `rg_region` VALUES ('21736', '21676', '3', '石台县', 'stx', 'shitaixian', '0566', '341722', '117.482907,30.210324');
INSERT INTO `rg_region` VALUES ('21745', '21376', '2', '阜阳市', 'fys', 'fuyangshi', '1558', '341200', '115.819729,32.896969');
INSERT INTO `rg_region` VALUES ('21746', '21745', '3', '太和县', 'thx', 'taihexian', '1558', '341222', '115.627243,33.16229');
INSERT INTO `rg_region` VALUES ('21779', '21745', '3', '临泉县', 'lqx', 'linquanxian', '1558', '341221', '115.261688,33.062698');
INSERT INTO `rg_region` VALUES ('21808', '21745', '3', '颍州区', 'yzq', 'yingzhouqu', '1558', '341202', '115.813914,32.891238');
INSERT INTO `rg_region` VALUES ('21826', '21745', '3', '颍泉区', 'yqq', 'yingquanqu', '1558', '341204', '115.804525,32.924797');
INSERT INTO `rg_region` VALUES ('21833', '21745', '3', '颍东区', 'ydq', 'yingdongqu', '1558', '341203', '115.858747,32.908861');
INSERT INTO `rg_region` VALUES ('21846', '21745', '3', '阜南县', 'fnx', 'funanxian', '1558', '341225', '115.590534,32.638102');
INSERT INTO `rg_region` VALUES ('21877', '21745', '3', '颍上县', 'ysx', 'yingshangxian', '1558', '341226', '116.259122,32.637065');
INSERT INTO `rg_region` VALUES ('21908', '21745', '3', '界首市', 'jss', 'jieshoushi', '1558', '341282', '115.362117,33.26153');
INSERT INTO `rg_region` VALUES ('21927', '21376', '2', '铜陵市', 'tls', 'tonglingshi', '0562', '340700', '117.816576,30.929935');
INSERT INTO `rg_region` VALUES ('21928', '21927', '3', '铜官区', 'tgq', 'tongguanqu', '0562', '340705', '117.818427,30.93182');
INSERT INTO `rg_region` VALUES ('21934', '21927', '3', '郊区', 'jq', 'jiaoqu', '0562', '340711', '117.80707,30.908927');
INSERT INTO `rg_region` VALUES ('21946', '21927', '3', '义安区', 'yaq', 'yianqu', '0562', '340706', '117.792288,30.952338');
INSERT INTO `rg_region` VALUES ('21957', '21927', '3', '枞阳县', 'cyx', 'congyangxian', '0562', '340722', '117.222027,30.700615');
INSERT INTO `rg_region` VALUES ('21978', '21376', '2', '滁州市', 'czs', 'chuzhoushi', '0550', '341100', '118.316264,32.303627');
INSERT INTO `rg_region` VALUES ('21979', '21978', '3', '明光市', 'mgs', 'mingguangshi', '0550', '341182', '117.998048,32.781206');
INSERT INTO `rg_region` VALUES ('21997', '21978', '3', '天长市', 'tcs', 'tianchangshi', '0550', '341181', '119.011212,32.6815');
INSERT INTO `rg_region` VALUES ('22015', '21978', '3', '全椒县', 'qjx', 'quanjiaoxian', '0550', '341124', '118.268576,32.09385');
INSERT INTO `rg_region` VALUES ('22026', '21978', '3', '凤阳县', 'fyx', 'fengyangxian', '0550', '341126', '117.562461,32.867146');
INSERT INTO `rg_region` VALUES ('22044', '21978', '3', '来安县', 'lax', 'laianxian', '0550', '341122', '118.433293,32.450231');
INSERT INTO `rg_region` VALUES ('22057', '21978', '3', '定远县', 'dyx', 'dingyuanxian', '0550', '341125', '117.683713,32.527105');
INSERT INTO `rg_region` VALUES ('22083', '21978', '3', '南谯区', 'nqq', 'nanqiaoqu', '0550', '341103', '118.296955,32.329841');
INSERT INTO `rg_region` VALUES ('22095', '21978', '3', '琅琊区', 'lyq', 'langyaqu', '0550', '341102', '118.316475,32.303797');
INSERT INTO `rg_region` VALUES ('22108', '21376', '2', '宣城市', 'xcs', 'xuanchengshi', '0563', '341800', '118.757995,30.945667');
INSERT INTO `rg_region` VALUES ('22109', '22108', '3', '广德县', 'gdx', 'guangdexian', '0563', '341822', '119.417521,30.893116');
INSERT INTO `rg_region` VALUES ('22120', '22108', '3', '泾县', 'jx', 'jingxian', '0563', '341823', '118.412397,30.685975');
INSERT INTO `rg_region` VALUES ('22132', '22108', '3', '旌德县', 'jdx', 'jingdexian', '0563', '341825', '118.543081,30.288057');
INSERT INTO `rg_region` VALUES ('22143', '22108', '3', '绩溪县', 'jxx', 'jixixian', '0563', '341824', '118.594705,30.065267');
INSERT INTO `rg_region` VALUES ('22156', '22108', '3', '宣州区', 'xzq', 'xuanzhouqu', '0563', '341802', '118.758412,30.946003');
INSERT INTO `rg_region` VALUES ('22183', '22108', '3', '宁国市', 'ngs', 'ningguoshi', '0563', '341881', '118.983407,30.626529');
INSERT INTO `rg_region` VALUES ('22202', '22108', '3', '郎溪县', 'lxx', 'langxixian', '0563', '341821', '119.185024,31.127834');
INSERT INTO `rg_region` VALUES ('22215', '21376', '2', '黄山市', 'hss', 'huangshanshi', '0559', '341000', '118.317325,29.709239');
INSERT INTO `rg_region` VALUES ('22216', '22215', '3', '黄山区', 'hsq', 'huangshanqu', '0559', '341003', '118.136639,30.294517');
INSERT INTO `rg_region` VALUES ('22232', '22215', '3', '黟县', 'yx', 'yixian', '0559', '341023', '117.942911,29.923812');
INSERT INTO `rg_region` VALUES ('22241', '22215', '3', '祁门县', 'qmx', 'qimenxian', '0559', '341024', '117.717237,29.853472');
INSERT INTO `rg_region` VALUES ('22260', '22215', '3', '歙县', 'xx', 'xixian', '0559', '341021', '118.428025,29.867748');
INSERT INTO `rg_region` VALUES ('22290', '22215', '3', '屯溪区', 'txq', 'tunxiqu', '0559', '341002', '118.317354,29.709186');
INSERT INTO `rg_region` VALUES ('22300', '22215', '3', '休宁县', 'xnx', 'xiuningxian', '0559', '341022', '118.188531,29.788878');
INSERT INTO `rg_region` VALUES ('22322', '22215', '3', '徽州区', 'hzq', 'huizhouqu', '0559', '341004', '118.339743,29.825201');
INSERT INTO `rg_region` VALUES ('22331', '21376', '2', '安庆市', 'aqs', 'anqingshi', '0556', '340800', '117.043551,30.50883');
INSERT INTO `rg_region` VALUES ('22332', '22331', '3', '岳西县', 'yxx', 'yuexixian', '0556', '340828', '116.360482,30.848502');
INSERT INTO `rg_region` VALUES ('22357', '22331', '3', '潜山市', 'qss', 'qianshanshi', '0556', '340824', '116.573666,30.638222');
INSERT INTO `rg_region` VALUES ('22376', '22331', '3', '宜秀区', 'yxq', 'yixiuqu', '0556', '340811', '117.070003,30.541323');
INSERT INTO `rg_region` VALUES ('22384', '22331', '3', '太湖县', 'thx', 'taihuxian', '0556', '340825', '116.305225,30.451869');
INSERT INTO `rg_region` VALUES ('22402', '22331', '3', '望江县', 'wjx', 'wangjiangxian', '0556', '340827', '116.690927,30.12491');
INSERT INTO `rg_region` VALUES ('22414', '22331', '3', '桐城市', 'tcs', 'tongchengshi', '0556', '340881', '116.959656,31.050576');
INSERT INTO `rg_region` VALUES ('22431', '22331', '3', '迎江区', 'yjq', 'yingjiangqu', '0556', '340802', '117.044965,30.506375');
INSERT INTO `rg_region` VALUES ('22442', '22331', '3', '宿松县', 'ssx', 'susongxian', '0556', '340826', '116.120204,30.158327');
INSERT INTO `rg_region` VALUES ('22467', '22331', '3', '大观区', 'dgq', 'daguanqu', '0556', '340803', '117.034512,30.505632');
INSERT INTO `rg_region` VALUES ('22481', '22331', '3', '怀宁县', 'hnx', 'huainingxian', '0556', '340822', '116.828664,30.734994');
INSERT INTO `rg_region` VALUES ('22502', '21376', '2', '六安市', 'las', 'liuanshi', '0564', '341500', '116.507676,31.752889');
INSERT INTO `rg_region` VALUES ('22503', '22502', '3', '霍山县', 'hsx', 'huoshanxian', '0564', '341525', '116.333078,31.402456');
INSERT INTO `rg_region` VALUES ('22521', '22502', '3', '裕安区', 'yaq', 'yuanqu', '0564', '341503', '116.494543,31.750692');
INSERT INTO `rg_region` VALUES ('22545', '22502', '3', '金寨县', 'jzx', 'jinzhaixian', '0564', '341524', '115.878514,31.681624');
INSERT INTO `rg_region` VALUES ('22570', '22502', '3', '舒城县', 'scx', 'shuchengxian', '0564', '341523', '116.944088,31.462848');
INSERT INTO `rg_region` VALUES ('22593', '22502', '3', '金安区', 'jaq', 'jinanqu', '0564', '341502', '116.503288,31.754491');
INSERT INTO `rg_region` VALUES ('22617', '22502', '3', '霍邱县', 'hqx', 'huoqiuxian', '0564', '341522', '116.278875,32.341305');
INSERT INTO `rg_region` VALUES ('22650', '22502', '3', '叶集区', 'yjq', 'yejiqu', '0564', '341504', '115.913594,31.84768');
INSERT INTO `rg_region` VALUES ('22657', '21376', '2', '淮南市', 'hns', 'huainanshi', '0554', '340400', '117.018329,32.647574');
INSERT INTO `rg_region` VALUES ('22658', '22657', '3', '凤台县', 'ftx', 'fengtaixian', '0554', '340421', '116.722769,32.705382');
INSERT INTO `rg_region` VALUES ('22678', '22657', '3', '八公山区', 'bgsq', 'bagongshanqu', '0554', '340405', '116.841111,32.628229');
INSERT INTO `rg_region` VALUES ('22685', '22657', '3', '潘集区', 'pjq', 'panjiqu', '0554', '340406', '116.816879,32.782117');
INSERT INTO `rg_region` VALUES ('22697', '22657', '3', '大通区', 'dtq', 'datongqu', '0554', '340402', '117.052927,32.632066');
INSERT INTO `rg_region` VALUES ('22704', '22657', '3', '寿县', 'sx', 'shouxian', '0554', '340422', '116.785349,32.577304');
INSERT INTO `rg_region` VALUES ('22733', '22657', '3', '田家庵区', 'tjaq', 'tianjiaanqu', '0554', '340403', '117.018318,32.644342');
INSERT INTO `rg_region` VALUES ('22748', '22657', '3', '谢家集区', 'xjjq', 'xiejiajiqu', '0554', '340404', '116.865354,32.598289');
INSERT INTO `rg_region` VALUES ('22760', '21376', '2', '合肥市', 'hfs', 'hefeishi', '0551', '340100', '117.283042,31.86119');
INSERT INTO `rg_region` VALUES ('22761', '22760', '3', '庐阳区', 'lyq', 'luyangqu', '0551', '340103', '117.283776,31.869011');
INSERT INTO `rg_region` VALUES ('22773', '22760', '3', '庐江县', 'ljx', 'lujiangxian', '0551', '340124', '117.289844,31.251488');
INSERT INTO `rg_region` VALUES ('22792', '22760', '3', '肥东县', 'fdx', 'feidongxian', '0551', '340122', '117.463222,31.883992');
INSERT INTO `rg_region` VALUES ('22813', '22760', '3', '长丰县', 'cfx', 'changfengxian', '0551', '340121', '117.164699,32.478548');
INSERT INTO `rg_region` VALUES ('22829', '22760', '3', '瑶海区', 'yhq', 'yaohaiqu', '0551', '340102', '117.315358,31.86961');
INSERT INTO `rg_region` VALUES ('22848', '22760', '3', '包河区', 'bhq', 'baohequ', '0551', '340111', '117.285751,31.82956');
INSERT INTO `rg_region` VALUES ('22859', '22760', '3', '巢湖市', 'chs', 'chaohushi', '0551', '340181', '117.874155,31.600518');
INSERT INTO `rg_region` VALUES ('22878', '22760', '3', '肥西县', 'fxx', 'feixixian', '0551', '340123', '117.166118,31.719646');
INSERT INTO `rg_region` VALUES ('22893', '22760', '3', '蜀山区', 'ssq', 'shushanqu', '0551', '340104', '117.262072,31.855868');
INSERT INTO `rg_region` VALUES ('22913', '21376', '2', '宿州市', 'szs', 'suzhoushi', '0557', '341300', '116.984084,33.633891');
INSERT INTO `rg_region` VALUES ('22914', '22913', '3', '砀山县', 'dsx', 'dangshanxian', '0557', '341321', '116.351113,34.426247');
INSERT INTO `rg_region` VALUES ('22931', '22913', '3', '泗县', 'sx', 'sixian', '0557', '341324', '117.885443,33.47758');
INSERT INTO `rg_region` VALUES ('22948', '22913', '3', '灵璧县', 'lbx', 'lingbixian', '0557', '341323', '117.551493,33.540629');
INSERT INTO `rg_region` VALUES ('22969', '22913', '3', '埇桥区', 'yqq', 'yongqiaoqu', '0557', '341302', '116.983309,33.633853');
INSERT INTO `rg_region` VALUES ('23012', '22913', '3', '萧县', 'xx', 'xiaoxian', '0557', '341322', '116.945399,34.183266');
INSERT INTO `rg_region` VALUES ('23037', '21376', '2', '芜湖市', 'whs', 'wuhushi', '0553', '340200', '118.376451,31.326319');
INSERT INTO `rg_region` VALUES ('23038', '23037', '3', '繁昌县', 'fcx', 'fanchangxian', '0553', '340222', '118.201349,31.080896');
INSERT INTO `rg_region` VALUES ('23046', '23037', '3', '弋江区', 'yjq', 'yijiangqu', '0553', '340203', '118.377476,31.313394');
INSERT INTO `rg_region` VALUES ('23056', '23037', '3', '无为县', 'wwx', 'wuweixian', '0553', '340225', '117.911432,31.303075');
INSERT INTO `rg_region` VALUES ('23078', '23037', '3', '镜湖区', 'jhq', 'jinghuqu', '0553', '340202', '118.376343,31.32559');
INSERT INTO `rg_region` VALUES ('23090', '23037', '3', '南陵县', 'nlx', 'nanlingxian', '0553', '340223', '118.337104,30.919638');
INSERT INTO `rg_region` VALUES ('23100', '23037', '3', '三山区', 'ssq', 'sanshanqu', '0553', '340208', '118.233987,31.225423');
INSERT INTO `rg_region` VALUES ('23107', '23037', '3', '鸠江区', 'jjq', 'jiujiangqu', '0553', '340207', '118.400174,31.362716');
INSERT INTO `rg_region` VALUES ('23122', '23037', '3', '芜湖县', 'whx', 'wuhuxian', '0553', '340221', '118.572301,31.145262');
INSERT INTO `rg_region` VALUES ('23129', '0', '1', '福建省', 'fjs', 'fujiansheng', '', '350000', '119.306239,26.075302');
INSERT INTO `rg_region` VALUES ('23130', '23129', '2', '莆田市', 'pts', 'putianshi', '0594', '350300', '119.007558,25.431011');
INSERT INTO `rg_region` VALUES ('23131', '23130', '3', '仙游县', 'xyx', 'xianyouxian', '0594', '350322', '118.694331,25.356529');
INSERT INTO `rg_region` VALUES ('23150', '23130', '3', '荔城区', 'lcq', 'lichengqu', '0594', '350304', '119.020047,25.430047');
INSERT INTO `rg_region` VALUES ('23157', '23130', '3', '城厢区', 'cxq', 'chengxiangqu', '0594', '350302', '119.001028,25.433737');
INSERT INTO `rg_region` VALUES ('23165', '23130', '3', '秀屿区', 'xyq', 'xiuyuqu', '0594', '350305', '119.092607,25.316141');
INSERT INTO `rg_region` VALUES ('23179', '23130', '3', '涵江区', 'hjq', 'hanjiangqu', '0594', '350303', '119.119102,25.459273');
INSERT INTO `rg_region` VALUES ('23193', '23129', '2', '福州市', 'fzs', 'fuzhoushi', '0591', '350100', '119.306239,26.075302');
INSERT INTO `rg_region` VALUES ('23194', '23193', '3', '闽侯县', 'mhx', 'minhouxian', '0591', '350121', '119.145117,26.148567');
INSERT INTO `rg_region` VALUES ('23211', '23193', '3', '连江县', 'ljx', 'lianjiangxian', '0591', '350122', '119.538365,26.202109');
INSERT INTO `rg_region` VALUES ('23234', '23193', '3', '罗源县', 'lyx', 'luoyuanxian', '0591', '350123', '119.552645,26.487234');
INSERT INTO `rg_region` VALUES ('23247', '23193', '3', '闽清县', 'mqx', 'minqingxian', '0591', '350124', '118.868416,26.223793');
INSERT INTO `rg_region` VALUES ('23264', '23193', '3', '福清市', 'fqs', 'fuqingshi', '0591', '350181', '119.376992,25.720402');
INSERT INTO `rg_region` VALUES ('23291', '23193', '3', '永泰县', 'ytx', 'yongtaixian', '0591', '350125', '118.939089,25.864825');
INSERT INTO `rg_region` VALUES ('23313', '23193', '3', '长乐区', 'clq', 'changlequ', '0591', '350112', '119.510849,25.960583');
INSERT INTO `rg_region` VALUES ('23332', '23193', '3', '仓山区', 'csq', 'cangshanqu', '0591', '350104', '119.320988,26.038912');
INSERT INTO `rg_region` VALUES ('23347', '23193', '3', '平潭县', 'ptx', 'pingtanxian', '0591', '350128', '119.791197,25.503672');
INSERT INTO `rg_region` VALUES ('23363', '23193', '3', '鼓楼区', 'glq', 'gulouqu', '0591', '350102', '119.29929,26.082284');
INSERT INTO `rg_region` VALUES ('23374', '23193', '3', '台江区', 'tjq', 'taijiangqu', '0591', '350103', '119.310156,26.058616');
INSERT INTO `rg_region` VALUES ('23385', '23193', '3', '马尾区', 'mwq', 'mawoiqu', '0591', '350105', '119.458725,25.991975');
INSERT INTO `rg_region` VALUES ('23390', '23193', '3', '晋安区', 'jaq', 'jinanqu', '0591', '350111', '119.328597,26.078837');
INSERT INTO `rg_region` VALUES ('23400', '23129', '2', '泉州市', 'qzs', 'quanzhoushi', '0595', '350500', '118.589421,24.908853');
INSERT INTO `rg_region` VALUES ('23401', '23400', '3', '德化县', 'dhx', 'dehuaxian', '0595', '350526', '118.242986,25.489004');
INSERT INTO `rg_region` VALUES ('23420', '23400', '3', '永春县', 'ycx', 'yongchunxian', '0595', '350525', '118.29503,25.320721');
INSERT INTO `rg_region` VALUES ('23443', '23400', '3', '南安市', 'nas', 'nananshi', '0595', '350583', '118.387031,24.959494');
INSERT INTO `rg_region` VALUES ('23471', '23400', '3', '安溪县', 'axx', 'anxixian', '0595', '350524', '118.186014,25.056824');
INSERT INTO `rg_region` VALUES ('23496', '23400', '3', '惠安县', 'hax', 'huianxian', '0595', '350521', '118.798954,25.028718');
INSERT INTO `rg_region` VALUES ('23515', '23400', '3', '泉港区', 'qgq', 'quangangqu', '0595', '350505', '118.912285,25.126859');
INSERT INTO `rg_region` VALUES ('23523', '23400', '3', '丰泽区', 'fzq', 'fengzequ', '0595', '350503', '118.605147,24.896041');
INSERT INTO `rg_region` VALUES ('23532', '23400', '3', '洛江区', 'ljq', 'luojiangqu', '0595', '350504', '118.670312,24.941153');
INSERT INTO `rg_region` VALUES ('23539', '23400', '3', '石狮市', 'sss', 'shishishi', '0595', '350581', '118.628402,24.731978');
INSERT INTO `rg_region` VALUES ('23549', '23400', '3', '晋江市', 'jjs', 'jinjiangshi', '0595', '350582', '118.577338,24.807322');
INSERT INTO `rg_region` VALUES ('23572', '23400', '3', '金门县', 'jmx', 'jinmenxian', '0595', '350527', '118.323221,24.436417');
INSERT INTO `rg_region` VALUES ('23573', '23400', '3', '鲤城区', 'lcq', 'lichengqu', '0595', '350502', '118.588929,24.907645');
INSERT INTO `rg_region` VALUES ('23583', '23129', '2', '宁德市', 'nds', 'ningdeshi', '0593', '350900', '119.527082,26.65924');
INSERT INTO `rg_region` VALUES ('23584', '23583', '3', '寿宁县', 'snx', 'shouningxian', '0593', '350924', '119.506733,27.457798');
INSERT INTO `rg_region` VALUES ('23599', '23583', '3', '周宁县', 'znx', 'zhouningxian', '0593', '350925', '119.338239,27.103106');
INSERT INTO `rg_region` VALUES ('23609', '23583', '3', '屏南县', 'pnx', 'pingnanxian', '0593', '350923', '118.987544,26.910826');
INSERT INTO `rg_region` VALUES ('23621', '23583', '3', '福安市', 'fas', 'fuanshi', '0593', '350981', '119.650798,27.084246');
INSERT INTO `rg_region` VALUES ('23646', '23583', '3', '柘荣县', 'zrx', 'zherongxian', '0593', '350926', '119.898226,27.236163');
INSERT INTO `rg_region` VALUES ('23656', '23583', '3', '古田县', 'gtx', 'gutianxian', '0593', '350922', '118.743156,26.577491');
INSERT INTO `rg_region` VALUES ('23671', '23583', '3', '福鼎市', 'fds', 'fudingshi', '0593', '350982', '120.219761,27.318884');
INSERT INTO `rg_region` VALUES ('23689', '23583', '3', '霞浦县', 'xpx', 'xiapuxian', '0593', '350921', '120.005214,26.882068');
INSERT INTO `rg_region` VALUES ('23704', '23583', '3', '蕉城区', 'jcq', 'jiaochengqu', '0593', '350902', '119.527225,26.659253');
INSERT INTO `rg_region` VALUES ('23722', '23129', '2', '龙岩市', 'lys', 'longyanshi', '0597', '350800', '117.02978,25.091603');
INSERT INTO `rg_region` VALUES ('23723', '23722', '3', '长汀县', 'ctx', 'changtingxian', '0597', '350821', '116.361007,25.842278');
INSERT INTO `rg_region` VALUES ('23742', '23722', '3', '连城县', 'lcx', 'lianchengxian', '0597', '350825', '116.756687,25.708506');
INSERT INTO `rg_region` VALUES ('23760', '23722', '3', '漳平市', 'zps', 'zhangpingshi', '0597', '350881', '117.42073,25.291597');
INSERT INTO `rg_region` VALUES ('23777', '23722', '3', '上杭县', 'shx', 'shanghangxian', '0597', '350823', '116.424774,25.050019');
INSERT INTO `rg_region` VALUES ('23800', '23722', '3', '武平县', 'wpx', 'wupingxian', '0597', '350824', '116.100928,25.08865');
INSERT INTO `rg_region` VALUES ('23818', '23722', '3', '新罗区', 'xlq', 'xinluoqu', '0597', '350802', '117.030721,25.0918');
INSERT INTO `rg_region` VALUES ('23839', '23722', '3', '永定区', 'ydq', 'yongdingqu', '0597', '350803', '116.732691,24.720442');
INSERT INTO `rg_region` VALUES ('23864', '23129', '2', '厦门市', 'sms', 'shamenshi', '0592', '350200', '118.11022,24.490474');
INSERT INTO `rg_region` VALUES ('23865', '23864', '3', '同安区', 'taq', 'tonganqu', '0592', '350212', '118.150455,24.729333');
INSERT INTO `rg_region` VALUES ('23877', '23864', '3', '思明区', 'smq', 'simingqu', '0592', '350203', '118.087828,24.462059');
INSERT INTO `rg_region` VALUES ('23888', '23864', '3', '海沧区', 'hcq', 'haicangqu', '0592', '350205', '118.036364,24.492512');
INSERT INTO `rg_region` VALUES ('23896', '23864', '3', '集美区', 'jmq', 'jimoiqu', '0592', '350211', '118.100869,24.572874');
INSERT INTO `rg_region` VALUES ('23907', '23864', '3', '湖里区', 'hlq', 'huliqu', '0592', '350206', '118.10943,24.512764');
INSERT INTO `rg_region` VALUES ('23915', '23864', '3', '翔安区', 'xaq', 'xianganqu', '0592', '350213', '118.242811,24.637479');
INSERT INTO `rg_region` VALUES ('23922', '23129', '2', '漳州市', 'zzs', 'zhangzhoushi', '0596', '350600', '117.661801,24.510897');
INSERT INTO `rg_region` VALUES ('23923', '23922', '3', '华安县', 'hax', 'huaanxian', '0596', '350629', '117.53631,25.001416');
INSERT INTO `rg_region` VALUES ('23934', '23922', '3', '长泰县', 'ctx', 'changtaixian', '0596', '350625', '117.755913,24.621475');
INSERT INTO `rg_region` VALUES ('23944', '23922', '3', '南靖县', 'njx', 'nanjingxian', '0596', '350627', '117.365462,24.516425');
INSERT INTO `rg_region` VALUES ('23957', '23922', '3', '漳浦县', 'zpx', 'zhangpuxian', '0596', '350623', '117.614023,24.117907');
INSERT INTO `rg_region` VALUES ('23988', '23922', '3', '诏安县', 'zax', 'zhaoanxian', '0596', '350624', '117.176083,23.710834');
INSERT INTO `rg_region` VALUES ('24009', '23922', '3', '龙海市', 'lhs', 'longhaishi', '0596', '350681', '117.817292,24.445341');
INSERT INTO `rg_region` VALUES ('24034', '23922', '3', '东山县', 'dsx', 'dongshanxian', '0596', '350626', '117.427679,23.702845');
INSERT INTO `rg_region` VALUES ('24042', '23922', '3', '芗城区', 'xcq', 'xiangchengqu', '0596', '350602', '117.656461,24.509955');
INSERT INTO `rg_region` VALUES ('24057', '23922', '3', '龙文区', 'lwq', 'longwenqu', '0596', '350603', '117.671387,24.515656');
INSERT INTO `rg_region` VALUES ('24063', '23922', '3', '云霄县', 'yxx', 'yunxiaoxian', '0596', '350622', '117.340946,23.950486');
INSERT INTO `rg_region` VALUES ('24076', '23922', '3', '平和县', 'phx', 'pinghexian', '0596', '350628', '117.313549,24.366158');
INSERT INTO `rg_region` VALUES ('24094', '23129', '2', '南平市', 'nps', 'nanpingshi', '0599', '350700', '118.178459,26.635627');
INSERT INTO `rg_region` VALUES ('24095', '24094', '3', '松溪县', 'sxx', 'songxixian', '0599', '350724', '118.783491,27.525785');
INSERT INTO `rg_region` VALUES ('24105', '24094', '3', '武夷山市', 'wyss', 'wuyishanshi', '0599', '350782', '118.032796,27.751733');
INSERT INTO `rg_region` VALUES ('24116', '24094', '3', '浦城县', 'pcx', 'puchengxian', '0599', '350722', '118.536822,27.920412');
INSERT INTO `rg_region` VALUES ('24137', '24094', '3', '建阳区', 'jyq', 'jianyangqu', '0599', '350703', '118.12267,27.332067');
INSERT INTO `rg_region` VALUES ('24151', '24094', '3', '政和县', 'zhx', 'zhenghexian', '0599', '350725', '118.858661,27.365398');
INSERT INTO `rg_region` VALUES ('24162', '24094', '3', '邵武市', 'sws', 'shaowushi', '0599', '350781', '117.491544,27.337952');
INSERT INTO `rg_region` VALUES ('24182', '24094', '3', '光泽县', 'gzx', 'guangzexian', '0599', '350723', '117.337897,27.542803');
INSERT INTO `rg_region` VALUES ('24191', '24094', '3', '顺昌县', 'scx', 'shunchangxian', '0599', '350721', '117.80771,26.792851');
INSERT INTO `rg_region` VALUES ('24204', '24094', '3', '延平区', 'ypq', 'yanpingqu', '0599', '350702', '118.178918,26.636079');
INSERT INTO `rg_region` VALUES ('24226', '24094', '3', '建瓯市', 'jos', 'jianoushi', '0599', '350783', '118.321765,27.03502');
INSERT INTO `rg_region` VALUES ('24245', '23129', '2', '三明市', 'sms', 'sanmingshi', '0598', '350400', '117.635001,26.265444');
INSERT INTO `rg_region` VALUES ('24246', '24245', '3', '泰宁县', 'tnx', 'tainingxian', '0598', '350429', '117.177522,26.897995');
INSERT INTO `rg_region` VALUES ('24256', '24245', '3', '清流县', 'qlx', 'qingliuxian', '0598', '350423', '116.815821,26.17761');
INSERT INTO `rg_region` VALUES ('24270', '24245', '3', '三元区', 'syq', 'sanyuanqu', '0598', '350403', '117.607418,26.234191');
INSERT INTO `rg_region` VALUES ('24279', '24245', '3', '宁化县', 'nhx', 'ninghuaxian', '0598', '350424', '116.659725,26.259932');
INSERT INTO `rg_region` VALUES ('24296', '24245', '3', '梅列区', 'mlq', 'meiliequ', '0598', '350402', '117.63687,26.269208');
INSERT INTO `rg_region` VALUES ('24303', '24245', '3', '大田县', 'dtx', 'datianxian', '0598', '350425', '117.849355,25.690803');
INSERT INTO `rg_region` VALUES ('24323', '24245', '3', '永安市', 'yas', 'yonganshi', '0598', '350481', '117.364447,25.974075');
INSERT INTO `rg_region` VALUES ('24339', '24245', '3', '沙县', 'sx', 'shaxian', '0598', '350427', '117.789095,26.397361');
INSERT INTO `rg_region` VALUES ('24356', '24245', '3', '尤溪县', 'yxx', 'youxixian', '0598', '350426', '118.188577,26.169261');
INSERT INTO `rg_region` VALUES ('24372', '24245', '3', '建宁县', 'jnx', 'jianningxian', '0598', '350430', '116.845832,26.831398');
INSERT INTO `rg_region` VALUES ('24383', '24245', '3', '明溪县', 'mxx', 'mingxixian', '0598', '350421', '117.201845,26.357375');
INSERT INTO `rg_region` VALUES ('24393', '24245', '3', '将乐县', 'jlx', 'jianglexian', '0598', '350428', '117.473558,26.728667');
INSERT INTO `rg_region` VALUES ('24407', '0', '1', '湖南省', 'hns', 'hunansheng', '', '430000', '112.982279,28.19409');
INSERT INTO `rg_region` VALUES ('24408', '24407', '2', '益阳市', 'yys', 'yiyangshi', '0737', '430900', '112.355042,28.570066');
INSERT INTO `rg_region` VALUES ('24409', '24408', '3', '南县', 'nx', 'nanxian', '0737', '430921', '112.410399,29.372181');
INSERT INTO `rg_region` VALUES ('24428', '24408', '3', '资阳区', 'zyq', 'ziyangqu', '0737', '430902', '112.33084,28.592771');
INSERT INTO `rg_region` VALUES ('24438', '24408', '3', '沅江市', 'yjs', 'yuanjiangshi', '0737', '430981', '112.361088,28.839713');
INSERT INTO `rg_region` VALUES ('24456', '24408', '3', '桃江县', 'tjx', 'taojiangxian', '0737', '430922', '112.139732,28.520993');
INSERT INTO `rg_region` VALUES ('24473', '24408', '3', '赫山区', 'hsq', 'heshanqu', '0737', '430903', '112.360946,28.568327');
INSERT INTO `rg_region` VALUES ('24491', '24408', '3', '安化县', 'ahx', 'anhuaxian', '0737', '430923', '111.221824,28.377421');
INSERT INTO `rg_region` VALUES ('24515', '24407', '2', '衡阳市', 'hys', 'hengyangshi', '0734', '430400', '112.607693,26.900358');
INSERT INTO `rg_region` VALUES ('24516', '24515', '3', '衡山县', 'hsx', 'hengshanxian', '0734', '430423', '112.86971,27.234808');
INSERT INTO `rg_region` VALUES ('24529', '24515', '3', '衡东县', 'hdx', 'hengdongxian', '0734', '430424', '112.950412,27.083531');
INSERT INTO `rg_region` VALUES ('24548', '24515', '3', '南岳区', 'nyq', 'nanyuequ', '0734', '430412', '112.734147,27.240536');
INSERT INTO `rg_region` VALUES ('24552', '24515', '3', '衡阳县', 'hyx', 'hengyangxian', '0734', '430421', '112.379643,26.962388');
INSERT INTO `rg_region` VALUES ('24578', '24515', '3', '衡南县', 'hnx', 'hengnanxian', '0734', '430422', '112.677459,26.739973');
INSERT INTO `rg_region` VALUES ('24604', '24515', '3', '石鼓区', 'sgq', 'shiguqu', '0734', '430407', '112.607635,26.903908');
INSERT INTO `rg_region` VALUES ('24613', '24515', '3', '雁峰区', 'yfq', 'yanfengqu', '0734', '430406', '112.612241,26.893694');
INSERT INTO `rg_region` VALUES ('24621', '24515', '3', '珠晖区', 'zhq', 'zhuhuiqu', '0734', '430405', '112.626324,26.891063');
INSERT INTO `rg_region` VALUES ('24636', '24515', '3', '祁东县', 'qdx', 'qidongxian', '0734', '430426', '112.111192,26.787109');
INSERT INTO `rg_region` VALUES ('24660', '24515', '3', '耒阳市', 'lys', 'loiyangshi', '0734', '430481', '112.847215,26.414162');
INSERT INTO `rg_region` VALUES ('24690', '24515', '3', '蒸湘区', 'zxq', 'zhengxiangqu', '0734', '430408', '112.570608,26.89087');
INSERT INTO `rg_region` VALUES ('24697', '24515', '3', '常宁市', 'cns', 'changningshi', '0734', '430482', '112.396821,26.406773');
INSERT INTO `rg_region` VALUES ('24720', '24407', '2', '张家界市', 'zjjs', 'zhangjiajieshi', '0744', '430800', '110.479921,29.127401');
INSERT INTO `rg_region` VALUES ('24721', '24720', '3', '慈利县', 'clx', 'cilixian', '0744', '430821', '111.132702,29.423876');
INSERT INTO `rg_region` VALUES ('24748', '24720', '3', '武陵源区', 'wlyq', 'wulingyuanqu', '0744', '430811', '110.54758,29.347827');
INSERT INTO `rg_region` VALUES ('24753', '24720', '3', '桑植县', 'szx', 'sangzhixian', '0744', '430822', '110.164039,29.399939');
INSERT INTO `rg_region` VALUES ('24782', '24720', '3', '永定区', 'ydq', 'yongdingqu', '0744', '430802', '110.484559,29.125961');
INSERT INTO `rg_region` VALUES ('24809', '24407', '2', '岳阳市', 'yys', 'yueyangshi', '0730', '430600', '113.132855,29.37029');
INSERT INTO `rg_region` VALUES ('24810', '24809', '3', '华容县', 'hrx', 'huarongxian', '0730', '430623', '112.559369,29.524107');
INSERT INTO `rg_region` VALUES ('24825', '24809', '3', '君山区', 'jsq', 'junshanqu', '0730', '430611', '113.004082,29.438062');
INSERT INTO `rg_region` VALUES ('24831', '24809', '3', '云溪区', 'yxq', 'yunxiqu', '0730', '430603', '113.27387,29.473395');
INSERT INTO `rg_region` VALUES ('24839', '24809', '3', '岳阳楼区', 'yylq', 'yueyanglouqu', '0730', '430602', '113.120751,29.366784');
INSERT INTO `rg_region` VALUES ('24863', '24809', '3', '汨罗市', 'mls', 'miluoshi', '0730', '430681', '113.079419,28.803149');
INSERT INTO `rg_region` VALUES ('24884', '24809', '3', '湘阴县', 'xyx', 'xiangyinxian', '0730', '430624', '112.889748,28.677498');
INSERT INTO `rg_region` VALUES ('24900', '24809', '3', '临湘市', 'lxs', 'linxiangshi', '0730', '430682', '113.450809,29.471594');
INSERT INTO `rg_region` VALUES ('24920', '24809', '3', '岳阳县', 'yyx', 'yueyangxian', '0730', '430621', '113.116073,29.144843');
INSERT INTO `rg_region` VALUES ('24936', '24809', '3', '平江县', 'pjx', 'pingjiangxian', '0730', '430626', '113.593751,28.701523');
INSERT INTO `rg_region` VALUES ('24961', '24407', '2', '娄底市', 'lds', 'loudishi', '0738', '431300', '112.008497,27.728136');
INSERT INTO `rg_region` VALUES ('24962', '24961', '3', '冷水江市', 'lsjs', 'longshuijiangshi', '0738', '431381', '111.434674,27.685759');
INSERT INTO `rg_region` VALUES ('24977', '24961', '3', '新化县', 'xhx', 'xinhuaxian', '0738', '431322', '111.306747,27.737456');
INSERT INTO `rg_region` VALUES ('25007', '24961', '3', '涟源市', 'lys', 'lianyuanshi', '0738', '431382', '111.670847,27.692301');
INSERT INTO `rg_region` VALUES ('25027', '24961', '3', '双峰县', 'sfx', 'shuangfengxian', '0738', '431321', '112.198245,27.459126');
INSERT INTO `rg_region` VALUES ('25044', '24961', '3', '娄星区', 'lxq', 'louxingqu', '0738', '431302', '112.008486,27.726643');
INSERT INTO `rg_region` VALUES ('25059', '24407', '2', '长沙市', 'css', 'changshashi', '0731', '430100', '112.982279,28.19409');
INSERT INTO `rg_region` VALUES ('25060', '25059', '3', '开福区', 'kfq', 'kaifuqu', '0731', '430105', '112.985525,28.201336');
INSERT INTO `rg_region` VALUES ('25077', '25059', '3', '岳麓区', 'ylq', 'yueluqu', '0731', '430104', '112.911591,28.213044');
INSERT INTO `rg_region` VALUES ('25096', '25059', '3', '浏阳市', 'lys', 'liuyangshi', '0731', '430181', '113.633301,28.141112');
INSERT INTO `rg_region` VALUES ('25129', '25059', '3', '天心区', 'txq', 'tianxinqu', '0731', '430103', '112.97307,28.192375');
INSERT INTO `rg_region` VALUES ('25144', '25059', '3', '雨花区', 'yhq', 'yuhuaqu', '0731', '430111', '113.016337,28.109937');
INSERT INTO `rg_region` VALUES ('25159', '25059', '3', '芙蓉区', 'frq', 'furongqu', '0731', '430102', '112.988094,28.193106');
INSERT INTO `rg_region` VALUES ('25174', '25059', '3', '长沙县', 'csx', 'changshaxian', '0731', '430121', '113.080098,28.237888');
INSERT INTO `rg_region` VALUES ('25193', '25059', '3', '宁乡市', 'nxs', 'ningxiangshi', '0731', '430182', '112.553182,28.253928');
INSERT INTO `rg_region` VALUES ('25223', '25059', '3', '望城区', 'wcq', 'wangchengqu', '0731', '430112', '112.819549,28.347458');
INSERT INTO `rg_region` VALUES ('25239', '24407', '2', '怀化市', 'hhs', 'huaihuashi', '0745', '431200', '109.97824,27.550082');
INSERT INTO `rg_region` VALUES ('25240', '25239', '3', '洪江市', 'hjs', 'hongjiangshi', '0745', '431281', '109.831765,27.201876');
INSERT INTO `rg_region` VALUES ('25267', '25239', '3', '芷江侗族自治县', 'zjdzzzx', 'zhijiangdongzuzizhixian', '0745', '431228', '109.687777,27.437996');
INSERT INTO `rg_region` VALUES ('25296', '25239', '3', '通道侗族自治县', 'tddzzzx', 'tongdaodongzuzizhixian', '0745', '431230', '109.783359,26.158349');
INSERT INTO `rg_region` VALUES ('25310', '25239', '3', '沅陵县', 'ylx', 'yuanlingxian', '0745', '431222', '110.399161,28.455554');
INSERT INTO `rg_region` VALUES ('25334', '25239', '3', '辰溪县', 'cxx', 'chenxixian', '0745', '431223', '110.196953,28.005474');
INSERT INTO `rg_region` VALUES ('25358', '25239', '3', '溆浦县', 'xpx', 'xupuxian', '0745', '431224', '110.593373,27.903802');
INSERT INTO `rg_region` VALUES ('25384', '25239', '3', '会同县', 'htx', 'huitongxian', '0745', '431225', '109.720785,26.870789');
INSERT INTO `rg_region` VALUES ('25403', '25239', '3', '靖州苗族侗族自治县', 'jzmzdzzzx', 'jingzhoumiaozudongzuzizhixian', '0745', '431229', '109.691159,26.573511');
INSERT INTO `rg_region` VALUES ('25417', '25239', '3', '麻阳苗族自治县', 'mymzzzx', 'mayangmiaozuzizhixian', '0745', '431226', '109.802807,27.865991');
INSERT INTO `rg_region` VALUES ('25436', '25239', '3', '新晃侗族自治县', 'xhdzzzx', 'xinhuangdongzuzizhixian', '0745', '431227', '109.174443,27.359897');
INSERT INTO `rg_region` VALUES ('25448', '25239', '3', '中方县', 'zfx', 'zhongfangxian', '0745', '431221', '109.948061,27.43736');
INSERT INTO `rg_region` VALUES ('25461', '25239', '3', '鹤城区', 'hcq', 'hechengqu', '0745', '431202', '109.982242,27.548474');
INSERT INTO `rg_region` VALUES ('25473', '24407', '2', '邵阳市', 'sys', 'shaoyangshi', '0739', '430500', '111.46923,27.237842');
INSERT INTO `rg_region` VALUES ('25474', '25473', '3', '隆回县', 'lhx', 'longhuixian', '0739', '430524', '111.038785,27.116002');
INSERT INTO `rg_region` VALUES ('25501', '25473', '3', '大祥区', 'dxq', 'daxiangqu', '0739', '430503', '111.462968,27.233593');
INSERT INTO `rg_region` VALUES ('25516', '25473', '3', '北塔区', 'btq', 'beitaqu', '0739', '430511', '111.452315,27.245688');
INSERT INTO `rg_region` VALUES ('25521', '25473', '3', '邵阳县', 'syx', 'shaoyangxian', '0739', '430523', '111.2757,26.989713');
INSERT INTO `rg_region` VALUES ('25547', '25473', '3', '双清区', 'sqq', 'shuangqingqu', '0739', '430502', '111.479756,27.240001');
INSERT INTO `rg_region` VALUES ('25557', '25473', '3', '绥宁县', 'snx', 'suiningxian', '0739', '430527', '110.155075,26.580622');
INSERT INTO `rg_region` VALUES ('25583', '25473', '3', '新宁县', 'xnx', 'xinningxian', '0739', '430528', '110.859115,26.438912');
INSERT INTO `rg_region` VALUES ('25600', '25473', '3', '城步苗族自治县', 'cbmzzzx', 'chengbumiaozuzizhixian', '0739', '430529', '110.313226,26.363575');
INSERT INTO `rg_region` VALUES ('25612', '25473', '3', '武冈市', 'wgs', 'wugangshi', '0739', '430581', '110.636804,26.732086');
INSERT INTO `rg_region` VALUES ('25634', '25473', '3', '洞口县', 'dkx', 'dongkouxian', '0739', '430525', '110.579212,27.062286');
INSERT INTO `rg_region` VALUES ('25659', '25473', '3', '邵东县', 'sdx', 'shaodongxian', '0739', '430521', '111.743168,27.257273');
INSERT INTO `rg_region` VALUES ('25685', '25473', '3', '新邵县', 'xsx', 'xinshaoxian', '0739', '430522', '111.459762,27.311429');
INSERT INTO `rg_region` VALUES ('25701', '24407', '2', '株洲市', 'zzs', 'zhuzhoushi', '0733', '430200', '113.151737,27.835806');
INSERT INTO `rg_region` VALUES ('25702', '25701', '3', '荷塘区', 'htq', 'hetangqu', '0733', '430202', '113.162548,27.833036');
INSERT INTO `rg_region` VALUES ('25709', '25701', '3', '攸县', 'yx', 'youxian', '0733', '430223', '113.345774,27.000071');
INSERT INTO `rg_region` VALUES ('25730', '25701', '3', '茶陵县', 'clx', 'chalingxian', '0733', '430224', '113.546509,26.789534');
INSERT INTO `rg_region` VALUES ('25754', '25701', '3', '炎陵县', 'ylx', 'yanlingxian', '0733', '430225', '113.776884,26.489459');
INSERT INTO `rg_region` VALUES ('25767', '25701', '3', '天元区', 'tyq', 'tianyuanqu', '0733', '430211', '113.136252,27.826909');
INSERT INTO `rg_region` VALUES ('25775', '25701', '3', '渌口区', 'lkq', 'lukouqu', '0733', '430212', '113.146176,27.705844');
INSERT INTO `rg_region` VALUES ('25786', '25701', '3', '芦淞区', 'lsq', 'lusongqu', '0733', '430203', '113.155169,27.827246');
INSERT INTO `rg_region` VALUES ('25795', '25701', '3', '石峰区', 'sfq', 'shifengqu', '0733', '430204', '113.11295,27.871945');
INSERT INTO `rg_region` VALUES ('25804', '25701', '3', '醴陵市', 'lls', 'lilingshi', '0733', '430281', '113.507157,27.657873');
INSERT INTO `rg_region` VALUES ('25828', '24407', '2', '湘西土家族苗族自治州', 'xxtjzmzzzz', 'xiangxitujiazumiaozuzizhizhou', '0743', '433100', '109.739735,28.314296');
INSERT INTO `rg_region` VALUES ('25829', '25828', '3', '永顺县', 'ysx', 'yongshunxian', '0743', '433127', '109.853292,28.998068');
INSERT INTO `rg_region` VALUES ('25853', '25828', '3', '保靖县', 'bjx', 'baojingxian', '0743', '433125', '109.651445,28.709605');
INSERT INTO `rg_region` VALUES ('25874', '25828', '3', '花垣县', 'hyx', 'huayuanxian', '0743', '433124', '109.479063,28.581352');
INSERT INTO `rg_region` VALUES ('25887', '25828', '3', '吉首市', 'jss', 'jishoushi', '0743', '433101', '109.738273,28.314827');
INSERT INTO `rg_region` VALUES ('25898', '25828', '3', '泸溪县', 'lxx', 'luxixian', '0743', '433122', '110.214428,28.214516');
INSERT INTO `rg_region` VALUES ('25912', '25828', '3', '古丈县', 'gzx', 'guzhangxian', '0743', '433126', '109.949592,28.616973');
INSERT INTO `rg_region` VALUES ('25920', '25828', '3', '龙山县', 'lsx', 'longshanxian', '0743', '433130', '109.441189,29.453438');
INSERT INTO `rg_region` VALUES ('25943', '25828', '3', '凤凰县', 'fhx', 'fenghuangxian', '0743', '433123', '109.599191,27.948308');
INSERT INTO `rg_region` VALUES ('25961', '24407', '2', '常德市', 'cds', 'changdeshi', '0736', '430700', '111.691347,29.040225');
INSERT INTO `rg_region` VALUES ('25962', '25961', '3', '澧县', 'lx', 'lixian', '0736', '430723', '111.761682,29.64264');
INSERT INTO `rg_region` VALUES ('25982', '25961', '3', '石门县', 'smx', 'shimenxian', '0736', '430726', '111.379087,29.584703');
INSERT INTO `rg_region` VALUES ('26008', '25961', '3', '临澧县', 'llx', 'linlixian', '0736', '430724', '111.645602,29.443217');
INSERT INTO `rg_region` VALUES ('26025', '25961', '3', '鼎城区', 'dcq', 'dingchengqu', '0736', '430703', '111.685327,29.014426');
INSERT INTO `rg_region` VALUES ('26054', '25961', '3', '津市市', 'jss', 'jinshishi', '0736', '430781', '111.879609,29.630867');
INSERT INTO `rg_region` VALUES ('26066', '25961', '3', '汉寿县', 'hsx', 'hanshouxian', '0736', '430722', '111.968506,28.907319');
INSERT INTO `rg_region` VALUES ('26088', '25961', '3', '武陵区', 'wlq', 'wulingqu', '0736', '430702', '111.690718,29.040477');
INSERT INTO `rg_region` VALUES ('26107', '25961', '3', '桃源县', 'tyx', 'taoyuanxian', '0736', '430725', '111.484503,28.902734');
INSERT INTO `rg_region` VALUES ('26136', '25961', '3', '安乡县', 'axx', 'anxiangxian', '0736', '430721', '112.172289,29.414483');
INSERT INTO `rg_region` VALUES ('26149', '24407', '2', '湘潭市', 'xts', 'xiangtanshi', '0732', '430300', '112.944052,27.82973');
INSERT INTO `rg_region` VALUES ('26150', '26149', '3', '岳塘区', 'ytq', 'yuetangqu', '0732', '430304', '112.927707,27.828854');
INSERT INTO `rg_region` VALUES ('26166', '26149', '3', '湘潭县', 'xtx', 'xiangtanxian', '0732', '430321', '112.952829,27.778601');
INSERT INTO `rg_region` VALUES ('26184', '26149', '3', '雨湖区', 'yhq', 'yuhuqu', '0732', '430302', '112.907427,27.86077');
INSERT INTO `rg_region` VALUES ('26202', '26149', '3', '韶山市', 'sss', 'shaoshanshi', '0732', '430382', '112.52848,27.922682');
INSERT INTO `rg_region` VALUES ('26207', '26149', '3', '湘乡市', 'xxs', 'xiangxiangshi', '0732', '430381', '112.525217,27.734918');
INSERT INTO `rg_region` VALUES ('26230', '24407', '2', '郴州市', 'czs', 'chenzhoushi', '0735', '431000', '113.032067,25.793589');
INSERT INTO `rg_region` VALUES ('26231', '26230', '3', '安仁县', 'arx', 'anrenxian', '0735', '431028', '113.27217,26.708625');
INSERT INTO `rg_region` VALUES ('26245', '26230', '3', '资兴市', 'zxs', 'zixingshi', '0735', '431081', '113.23682,25.974152');
INSERT INTO `rg_region` VALUES ('26264', '26230', '3', '永兴县', 'yxx', 'yongxingxian', '0735', '431023', '113.114819,26.129392');
INSERT INTO `rg_region` VALUES ('26281', '26230', '3', '桂东县', 'gdx', 'guidongxian', '0735', '431027', '113.945879,26.073917');
INSERT INTO `rg_region` VALUES ('26294', '26230', '3', '苏仙区', 'sxq', 'suxianqu', '0735', '431003', '113.038698,25.793157');
INSERT INTO `rg_region` VALUES ('26309', '26230', '3', '汝城县', 'rcx', 'ruchengxian', '0735', '431026', '113.685686,25.553759');
INSERT INTO `rg_region` VALUES ('26324', '26230', '3', '临武县', 'lwx', 'linwuxian', '0735', '431025', '112.564589,25.279119');
INSERT INTO `rg_region` VALUES ('26338', '26230', '3', '北湖区', 'bhq', 'beihuqu', '0735', '431002', '113.032208,25.792628');
INSERT INTO `rg_region` VALUES ('26351', '26230', '3', '桂阳县', 'gyx', 'guiyangxian', '0735', '431021', '112.734466,25.737447');
INSERT INTO `rg_region` VALUES ('26377', '26230', '3', '宜章县', 'yzx', 'yizhangxian', '0735', '431022', '112.947884,25.394345');
INSERT INTO `rg_region` VALUES ('26398', '26230', '3', '嘉禾县', 'jhx', 'jiahexian', '0735', '431024', '112.370618,25.587309');
INSERT INTO `rg_region` VALUES ('26409', '24407', '2', '永州市', 'yzs', 'yongzhoushi', '0746', '431100', '111.608019,26.434516');
INSERT INTO `rg_region` VALUES ('26410', '26409', '3', '东安县', 'dax', 'donganxian', '0746', '431122', '111.313035,26.397278');
INSERT INTO `rg_region` VALUES ('26428', '26409', '3', '祁阳县', 'qyx', 'qiyangxian', '0746', '431121', '111.85734,26.585929');
INSERT INTO `rg_region` VALUES ('26457', '26409', '3', '冷水滩区', 'lstq', 'longshuitanqu', '0746', '431103', '111.607156,26.434364');
INSERT INTO `rg_region` VALUES ('26475', '26409', '3', '新田县', 'xtx', 'xintianxian', '0746', '431128', '112.220341,25.906927');
INSERT INTO `rg_region` VALUES ('26488', '26409', '3', '零陵区', 'llq', 'linglingqu', '0746', '431102', '111.626348,26.223347');
INSERT INTO `rg_region` VALUES ('26503', '26409', '3', '江华瑶族自治县', 'jhyzzzx', 'jianghuayaozuzizhixian', '0746', '431129', '111.577276,25.182596');
INSERT INTO `rg_region` VALUES ('26520', '26409', '3', '宁远县', 'nyx', 'ningyuanxian', '0746', '431126', '111.944529,25.584112');
INSERT INTO `rg_region` VALUES ('26540', '26409', '3', '道县', 'dx', 'daoxian', '0746', '431124', '111.591614,25.518444');
INSERT INTO `rg_region` VALUES ('26566', '26409', '3', '江永县', 'jyx', 'jiangyongxian', '0746', '431125', '111.346803,25.268154');
INSERT INTO `rg_region` VALUES ('26577', '26409', '3', '双牌县', 'spx', 'shuangpaixian', '0746', '431123', '111.662146,25.959397');
INSERT INTO `rg_region` VALUES ('26590', '26409', '3', '蓝山县', 'lsx', 'lanshanxian', '0746', '431127', '112.194195,25.375255');
INSERT INTO `rg_region` VALUES ('26610', '0', '1', '海南省', 'hns', 'hainansheng', '', '460000', '110.33119,20.031971');
INSERT INTO `rg_region` VALUES ('26611', '26610', '2', '临高县', 'lgx', 'lingaoxian', '1896', '469024', '109.687697,19.908293');
INSERT INTO `rg_region` VALUES ('26612', '26611', '3', '南宝镇', 'nbz', 'nanbaozhen', '1896', '469024', '109.638,19.7516');
INSERT INTO `rg_region` VALUES ('26613', '26611', '3', '博厚镇', 'bhz', 'bohouzhen', '1896', '469024', '109.716,19.893');
INSERT INTO `rg_region` VALUES ('26614', '26611', '3', '和舍镇', 'hsz', 'heshezhen', '1896', '469024', '109.715,19.6717');
INSERT INTO `rg_region` VALUES ('26615', '26611', '3', '东英镇', 'dyz', 'dongyingzhen', '1896', '469024', '109.613,19.9349');
INSERT INTO `rg_region` VALUES ('26616', '26611', '3', '调楼镇', 'dlz', 'diaolouzhen', '1896', '469024', '109.61,19.9231');
INSERT INTO `rg_region` VALUES ('26617', '26611', '3', '国营加来农场', 'gyjlnc', 'guoyingjialainongchang', '1896', '469024', '109.651,19.7591');
INSERT INTO `rg_region` VALUES ('26618', '26611', '3', '波莲镇', 'blz', 'bolianzhen', '1896', '469024', '109.615,19.8555');
INSERT INTO `rg_region` VALUES ('26619', '26611', '3', '临城镇', 'lcz', 'linchengzhen', '1896', '469024', '109.673,19.8932');
INSERT INTO `rg_region` VALUES ('26620', '26611', '3', '新盈镇', 'xyz', 'xinyingzhen', '1896', '469024', '109.624,19.8719');
INSERT INTO `rg_region` VALUES ('26621', '26611', '3', '国营红华农场', 'gyhhnc', 'guoyinghonghuanongchang', '1896', '469024', '109.764,19.8244');
INSERT INTO `rg_region` VALUES ('26622', '26611', '3', '多文镇', 'dwz', 'duowenzhen', '1896', '469024', '109.802,19.7418');
INSERT INTO `rg_region` VALUES ('26623', '26611', '3', '皇桐镇', 'htz', 'huangtongzhen', '1896', '469024', '109.816,19.8743');
INSERT INTO `rg_region` VALUES ('26624', '26610', '2', '白沙黎族自治县', 'bslzzzx', 'baishalizuzizhixian', '0802', '469025', '109.452606,19.224584');
INSERT INTO `rg_region` VALUES ('26625', '26624', '3', '七坊镇', 'qfz', 'qifangzhen', '0802', '469025', '109.298,19.3459');
INSERT INTO `rg_region` VALUES ('26626', '26624', '3', '金波乡', 'jbx', 'jinboxiang', '0802', '469025', '109.157,19.2577');
INSERT INTO `rg_region` VALUES ('26627', '26624', '3', '南开乡', 'nkx', 'nankaixiang', '0802', '469025', '109.293,19.0596');
INSERT INTO `rg_region` VALUES ('26628', '26624', '3', '荣邦乡', 'rbx', 'rongbangxiang', '0802', '469025', '109.064,19.4868');
INSERT INTO `rg_region` VALUES ('26629', '26624', '3', '邦溪镇', 'bxz', 'bangxizhen', '0802', '469025', '109.09,19.3912');
INSERT INTO `rg_region` VALUES ('26630', '26624', '3', '国营龙江农场', 'gyljnc', 'guoyinglongjiangnongchang', '0802', '469025', '109.178,19.2369');
INSERT INTO `rg_region` VALUES ('26631', '26624', '3', '青松乡', 'qsx', 'qingsongxiang', '0802', '469025', '109.302,19.0689');
INSERT INTO `rg_region` VALUES ('26632', '26624', '3', '细水乡', 'xsx', 'xishuixiang', '0802', '469025', '109.523,19.2096');
INSERT INTO `rg_region` VALUES ('26633', '26624', '3', '元门乡', 'ymx', 'yuanmenxiang', '0802', '469025', '109.455,19.0981');
INSERT INTO `rg_region` VALUES ('26634', '26624', '3', '牙叉镇', 'ycz', 'yachazhen', '0802', '469025', '109.45,19.3004');
INSERT INTO `rg_region` VALUES ('26635', '26624', '3', '阜龙乡', 'flx', 'fulongxiang', '0802', '469025', '109.436,19.3316');
INSERT INTO `rg_region` VALUES ('26636', '26624', '3', '打安镇', 'daz', 'daanzhen', '0802', '469025', '109.36,19.3756');
INSERT INTO `rg_region` VALUES ('26637', '26624', '3', '国营白沙农场', 'gybsnc', 'guoyingbaishanongchang', '0802', '469025', '109.429,19.2881');
INSERT INTO `rg_region` VALUES ('26638', '26624', '3', '国营邦溪农场', 'gybxnc', 'guoyingbangxinongchang', '0802', '469025', '109.18,19.4104');
INSERT INTO `rg_region` VALUES ('26639', '26610', '2', '定安县', 'dax', 'dinganxian', '0806', '469021', '110.349235,19.684966');
INSERT INTO `rg_region` VALUES ('26640', '26639', '3', '黄竹镇', 'hzz', 'huangzhuzhen', '0806', '469021', '110.528,19.4887');
INSERT INTO `rg_region` VALUES ('26641', '26639', '3', '国营中瑞农场', 'gyzrnc', 'guoyingzhongruinongchang', '0806', '469021', '110.244,19.3008');
INSERT INTO `rg_region` VALUES ('26642', '26639', '3', '富文镇', 'fwz', 'fuwenzhen', '0806', '469021', '110.232,19.521');
INSERT INTO `rg_region` VALUES ('26643', '26639', '3', '新竹镇', 'xzz', 'xinzhuzhen', '0806', '469021', '110.159,19.5843');
INSERT INTO `rg_region` VALUES ('26644', '26639', '3', '岭口镇', 'lkz', 'lingkouzhen', '0806', '469021', '110.276,19.3601');
INSERT INTO `rg_region` VALUES ('26645', '26639', '3', '定城镇', 'dcz', 'dingchengzhen', '0806', '469021', '110.317,19.7017');
INSERT INTO `rg_region` VALUES ('26646', '26639', '3', '雷鸣镇', 'lmz', 'leimingzhen', '0806', '469021', '110.273,19.5137');
INSERT INTO `rg_region` VALUES ('26647', '26639', '3', '翰林镇', 'hlz', 'hanlinzhen', '0806', '469021', '110.24,19.2982');
INSERT INTO `rg_region` VALUES ('26648', '26639', '3', '龙门镇', 'lmz', 'longmenzhen', '0806', '469021', '110.298,19.4997');
INSERT INTO `rg_region` VALUES ('26649', '26639', '3', '国营金鸡岭农场', 'gyjjlnc', 'guoyingjinjilingnongchang', '0806', '469021', '110.252,19.5171');
INSERT INTO `rg_region` VALUES ('26650', '26639', '3', '国营南海农场', 'gynhnc', 'guoyingnanhainongchang', '0806', '469021', '110.469,19.4432');
INSERT INTO `rg_region` VALUES ('26651', '26639', '3', '龙湖镇', 'lhz', 'longhuzhen', '0806', '469021', '110.469,19.5845');
INSERT INTO `rg_region` VALUES ('26652', '26639', '3', '龙河镇', 'lhz', 'longhezhen', '0806', '469021', '110.226,19.4221');
INSERT INTO `rg_region` VALUES ('26653', '26610', '2', '昌江黎族自治县', 'cjlzzzx', 'changjianglizuzizhixian', '0803', '469026', '109.053351,19.260968');
INSERT INTO `rg_region` VALUES ('26654', '26653', '3', '十月田镇', 'sytz', 'shiyuetianzhen', '0803', '469026', '108.989,19.3818');
INSERT INTO `rg_region` VALUES ('26655', '26653', '3', '国营霸王岭林场', 'gybwllc', 'guoyingbawanglinglinchang', '0803', '469026', '109.03,19.1725');
INSERT INTO `rg_region` VALUES ('26656', '26653', '3', '乌烈镇', 'wlz', 'wuliezhen', '0803', '469026', '108.81,19.3525');
INSERT INTO `rg_region` VALUES ('26657', '26653', '3', '七叉镇', 'qcz', 'qichazhen', '0803', '469026', '109.069,19.1732');
INSERT INTO `rg_region` VALUES ('26658', '26653', '3', '石碌镇', 'slz', 'shiluzhen', '0803', '469026', '109.05,19.2444');
INSERT INTO `rg_region` VALUES ('26659', '26653', '3', '海南矿业联合有限公司', 'hnkylhyxgs', 'hainankuangyelianheyouxiangongsi', '0803', '469026', '108.989,19.2538');
INSERT INTO `rg_region` VALUES ('26660', '26653', '3', '叉河镇', 'chz', 'chahezhen', '0803', '469026', '108.989,19.2536');
INSERT INTO `rg_region` VALUES ('26661', '26653', '3', '海尾镇', 'hwz', 'haiwoizhen', '0803', '469026', '108.952,19.4945');
INSERT INTO `rg_region` VALUES ('26662', '26653', '3', '昌化镇', 'chz', 'changhuazhen', '0803', '469026', '108.732,19.3836');
INSERT INTO `rg_region` VALUES ('26663', '26653', '3', '王下乡', 'wxx', 'wangxiaxiang', '0803', '469026', '109.094,18.9052');
INSERT INTO `rg_region` VALUES ('26664', '26653', '3', '国营红林农场', 'gyhlnc', 'guoyinghonglinnongchang', '0803', '469026', '109.088,19.2367');
INSERT INTO `rg_region` VALUES ('26665', '26610', '2', '五指山市', 'wzss', 'wuzhishanshi', '1897', '469001', '109.516662,18.776921');
INSERT INTO `rg_region` VALUES ('26666', '26665', '3', '南圣镇', 'nsz', 'nanshengzhen', '1897', '469001', '109.659,18.841');
INSERT INTO `rg_region` VALUES ('26667', '26665', '3', '毛阳镇', 'myz', 'maoyangzhen', '1897', '469001', '109.45,18.8811');
INSERT INTO `rg_region` VALUES ('26668', '26665', '3', '国营畅好农场', 'gychnc', 'guoyingchanghaonongchang', '1897', '469001', '109.541,18.7112');
INSERT INTO `rg_region` VALUES ('26669', '26665', '3', '通什镇', 'tsz', 'tongshizhen', '1897', '469001', '109.614,18.8418');
INSERT INTO `rg_region` VALUES ('26670', '26665', '3', '水满乡', 'smx', 'shuimanxiang', '1897', '469001', '109.601,18.8995');
INSERT INTO `rg_region` VALUES ('26671', '26665', '3', '畅好乡', 'chx', 'changhaoxiang', '1897', '469001', '109.407,18.6294');
INSERT INTO `rg_region` VALUES ('26672', '26665', '3', '番阳镇', 'fyz', 'fanyangzhen', '1897', '469001', '109.334,18.9132');
INSERT INTO `rg_region` VALUES ('26673', '26665', '3', '毛道乡', 'mdx', 'maodaoxiang', '1897', '469001', '109.356,18.7134');
INSERT INTO `rg_region` VALUES ('26674', '26610', '2', '琼中黎族苗族自治县', 'qzlzmzzzx', 'qiongzhonglizumiaozuzizhixian', '1899', '469030', '109.839996,19.03557');
INSERT INTO `rg_region` VALUES ('26675', '26674', '3', '吊罗山乡', 'dlsx', 'diaoluoshanxiang', '1899', '469030', '109.917,18.8198');
INSERT INTO `rg_region` VALUES ('26676', '26674', '3', '什运乡', 'syx', 'shiyunxiang', '1899', '469030', '109.583,18.9237');
INSERT INTO `rg_region` VALUES ('26677', '26674', '3', '和平镇', 'hpz', 'hepingzhen', '1899', '469030', '109.894,18.899');
INSERT INTO `rg_region` VALUES ('26678', '26674', '3', '国营乌石农场', 'gywsnc', 'guoyingwushinongchang', '1899', '469030', '109.937,19.0977');
INSERT INTO `rg_region` VALUES ('26679', '26674', '3', '湾岭镇', 'wlz', 'wanlingzhen', '1899', '469030', '109.9,19.1334');
INSERT INTO `rg_region` VALUES ('26680', '26674', '3', '国营阳江农场', 'gyyjnc', 'guoyingyangjiangnongchang', '1899', '469030', '109.823,19.2127');
INSERT INTO `rg_region` VALUES ('26681', '26674', '3', '国营加钗农场', 'gyjcnc', 'guoyingjiachainongchang', '1899', '469030', '109.783,19.0265');
INSERT INTO `rg_region` VALUES ('26682', '26674', '3', '营根镇', 'ygz', 'yinggenzhen', '1899', '469030', '109.733,18.9748');
INSERT INTO `rg_region` VALUES ('26683', '26674', '3', '上安乡', 'sax', 'shanganxiang', '1899', '469030', '109.731,18.9133');
INSERT INTO `rg_region` VALUES ('26684', '26674', '3', '国营黎母山林业公司', 'gylmslygs', 'guoyinglimushanlinyegongsi', '1899', '469030', '109.703,19.1542');
INSERT INTO `rg_region` VALUES ('26685', '26674', '3', '中平镇', 'zpz', 'zhongpingzhen', '1899', '469030', '110.107,19.0716');
INSERT INTO `rg_region` VALUES ('26686', '26674', '3', '国营长征农场', 'gycznc', 'guoyingchangzhengnongchang', '1899', '469030', '109.899,18.9965');
INSERT INTO `rg_region` VALUES ('26687', '26674', '3', '长征镇', 'czz', 'changzhengzhen', '1899', '469030', '109.799,18.8976');
INSERT INTO `rg_region` VALUES ('26688', '26674', '3', '黎母山镇', 'lmsz', 'limushanzhen', '1899', '469030', '109.704,19.2577');
INSERT INTO `rg_region` VALUES ('26689', '26674', '3', '红毛镇', 'hmz', 'hongmaozhen', '1899', '469030', '109.734,19.0657');
INSERT INTO `rg_region` VALUES ('26690', '26610', '2', '万宁市', 'wns', 'wanningshi', '1898', '469006', '110.388793,18.796216');
INSERT INTO `rg_region` VALUES ('26691', '26690', '3', '后安镇', 'haz', 'houanzhen', '1898', '469006', '110.374,18.9087');
INSERT INTO `rg_region` VALUES ('26692', '26690', '3', '国营东和农场', 'gydhnc', 'guoyingdonghenongchang', '1898', '469006', '110.217,18.7629');
INSERT INTO `rg_region` VALUES ('26693', '26690', '3', '万城镇', 'wcz', 'wanchengzhen', '1898', '469006', '110.414,18.8276');
INSERT INTO `rg_region` VALUES ('26694', '26690', '3', '礼纪镇', 'ljz', 'lijizhen', '1898', '469006', '110.269,18.7354');
INSERT INTO `rg_region` VALUES ('26695', '26690', '3', '山根镇', 'sgz', 'shangenzhen', '1898', '469006', '110.483,18.9946');
INSERT INTO `rg_region` VALUES ('26696', '26690', '3', '国营东兴农场', 'gydxnc', 'guoyingdongxingnongchang', '1898', '469006', '110.375,18.894');
INSERT INTO `rg_region` VALUES ('26697', '26690', '3', '大茂镇', 'dmz', 'damaozhen', '1898', '469006', '110.39,18.8759');
INSERT INTO `rg_region` VALUES ('26698', '26690', '3', '龙滚镇', 'lgz', 'longgunzhen', '1898', '469006', '110.451,19.0536');
INSERT INTO `rg_region` VALUES ('26699', '26690', '3', '和乐镇', 'hlz', 'helezhen', '1898', '469006', '110.416,18.9625');
INSERT INTO `rg_region` VALUES ('26700', '26690', '3', '兴隆华侨农场', 'xlhqnc', 'xinglonghuaqiaonongchang', '1898', '469006', '110.106,18.8195');
INSERT INTO `rg_region` VALUES ('26701', '26690', '3', '三更罗镇', 'sglz', 'sangengluozhen', '1898', '469006', '110.214,18.9979');
INSERT INTO `rg_region` VALUES ('26702', '26690', '3', '长丰镇', 'cfz', 'changfengzhen', '1898', '469006', '110.321,18.7876');
INSERT INTO `rg_region` VALUES ('26703', '26690', '3', '北大镇', 'bdz', 'beidazhen', '1898', '469006', '110.24,18.9316');
INSERT INTO `rg_region` VALUES ('26704', '26690', '3', '地方国营六连林场', 'dfgylllc', 'difangguoyingliulianlinchang', '1898', '469006', '110.505,18.9899');
INSERT INTO `rg_region` VALUES ('26705', '26690', '3', '国营新中农场', 'gyxznc', 'guoyingxinzhongnongchang', '1898', '469006', '110.17,18.6967');
INSERT INTO `rg_region` VALUES ('26706', '26690', '3', '南桥镇', 'nqz', 'nanqiaozhen', '1898', '469006', '110.196,18.7201');
INSERT INTO `rg_region` VALUES ('26707', '26690', '3', '东澳镇', 'daz', 'dongaozhen', '1898', '469006', '110.429,18.6408');
INSERT INTO `rg_region` VALUES ('26708', '26610', '2', '屯昌县', 'tcx', 'tunchangxian', '1892', '469022', '110.102773,19.362916');
INSERT INTO `rg_region` VALUES ('26709', '26708', '3', '屯城镇', 'tcz', 'tunchengzhen', '1892', '469022', '110.161,19.4468');
INSERT INTO `rg_region` VALUES ('26710', '26708', '3', '国营中建农场', 'gyzjnc', 'guoyingzhongjiannongchang', '1892', '469022', '109.966,19.2466');
INSERT INTO `rg_region` VALUES ('26711', '26708', '3', '新兴镇', 'xxz', 'xinxingzhen', '1892', '469022', '110.154,19.5707');
INSERT INTO `rg_region` VALUES ('26712', '26708', '3', '南吕镇', 'nlz', 'nanluzhen', '1892', '469022', '110.05,19.2222');
INSERT INTO `rg_region` VALUES ('26713', '26708', '3', '坡心镇', 'pxz', 'poxinzhen', '1892', '469022', '110.11,19.3302');
INSERT INTO `rg_region` VALUES ('26714', '26708', '3', '国营中坤农场', 'gyzknc', 'guoyingzhongkunnongchang', '1892', '469022', '109.855,19.2944');
INSERT INTO `rg_region` VALUES ('26715', '26708', '3', '西昌镇', 'xcz', 'xichangzhen', '1892', '469022', '110.024,19.4428');
INSERT INTO `rg_region` VALUES ('26716', '26708', '3', '枫木镇', 'fmz', 'fengmuzhen', '1892', '469022', '109.994,19.1901');
INSERT INTO `rg_region` VALUES ('26717', '26708', '3', '乌坡镇', 'wpz', 'wupozhen', '1892', '469022', '110.093,19.1953');
INSERT INTO `rg_region` VALUES ('26718', '26708', '3', '南坤镇', 'nkz', 'nankunzhen', '1892', '469022', '109.857,19.2939');
INSERT INTO `rg_region` VALUES ('26719', '26610', '2', '乐东黎族自治县', 'ldlzzzx', 'ledonglizuzizhixian', '2802', '469027', '109.175444,18.74758');
INSERT INTO `rg_region` VALUES ('26720', '26719', '3', '莺歌海镇', 'yghz', 'yinggehaizhen', '2802', '469027', '108.728,18.4959');
INSERT INTO `rg_region` VALUES ('26721', '26719', '3', '国营保国农场', 'gybgnc', 'guoyingbaoguonongchang', '2802', '469027', '109.245,18.6612');
INSERT INTO `rg_region` VALUES ('26722', '26719', '3', '万冲镇', 'wcz', 'wanchongzhen', '2802', '469027', '109.339,18.7838');
INSERT INTO `rg_region` VALUES ('26723', '26719', '3', '国营山荣农场', 'gysrnc', 'guoyingshanrongnongchang', '2802', '469027', '109.223,18.7507');
INSERT INTO `rg_region` VALUES ('26724', '26719', '3', '利国镇', 'lgz', 'liguozhen', '2802', '469027', '108.965,18.529');
INSERT INTO `rg_region` VALUES ('26725', '26719', '3', '国营乐光农场', 'gylgnc', 'guoyingleguangnongchang', '2802', '469027', '109.192,18.5331');
INSERT INTO `rg_region` VALUES ('26726', '26719', '3', '抱由镇', 'byz', 'baoyouzhen', '2802', '469027', '109.138,18.8948');
INSERT INTO `rg_region` VALUES ('26727', '26719', '3', '佛罗镇', 'flz', 'foluozhen', '2802', '469027', '108.792,18.5833');
INSERT INTO `rg_region` VALUES ('26728', '26719', '3', '大安镇', 'daz', 'daanzhen', '2802', '469027', '109.225,18.5876');
INSERT INTO `rg_region` VALUES ('26729', '26719', '3', '九所镇', 'jsz', 'jiusuozhen', '2802', '469027', '108.927,18.5276');
INSERT INTO `rg_region` VALUES ('26730', '26719', '3', '国营尖峰岭林业公司', 'gyjfllygs', 'guoyingjianfenglinglinyegongsi', '2802', '469027', '109.027,18.726');
INSERT INTO `rg_region` VALUES ('26731', '26719', '3', '黄流镇', 'hlz', 'huangliuzhen', '2802', '469027', '108.808,18.597');
INSERT INTO `rg_region` VALUES ('26732', '26719', '3', '志仲镇', 'zzz', 'zhizhongzhen', '2802', '469027', '109.224,18.5932');
INSERT INTO `rg_region` VALUES ('26733', '26719', '3', '国营莺歌海盐场', 'gyyghyc', 'guoyingyinggehaiyanchang', '2802', '469027', '108.729,18.5523');
INSERT INTO `rg_region` VALUES ('26734', '26719', '3', '尖峰镇', 'jfz', 'jianfengzhen', '2802', '469027', '108.7,18.7124');
INSERT INTO `rg_region` VALUES ('26735', '26719', '3', '千家镇', 'qjz', 'qianjiazhen', '2802', '469027', '109.15,18.6353');
INSERT INTO `rg_region` VALUES ('26736', '26610', '2', '琼海市', 'qhs', 'qionghaishi', '1894', '469002', '110.466785,19.246011');
INSERT INTO `rg_region` VALUES ('26737', '26736', '3', '嘉积镇', 'jjz', 'jiajizhen', '1894', '469002', '110.441,19.3208');
INSERT INTO `rg_region` VALUES ('26738', '26736', '3', '会山镇', 'hsz', 'huishanzhen', '1894', '469002', '110.302,19.0792');
INSERT INTO `rg_region` VALUES ('26739', '26736', '3', '国营东升农场', 'gydsnc', 'guoyingdongshengnongchang', '1894', '469002', '110.413,19.284');
INSERT INTO `rg_region` VALUES ('26740', '26736', '3', '国营东太农场', 'gydtnc', 'guoyingdongtainongchang', '1894', '469002', '110.367,19.1372');
INSERT INTO `rg_region` VALUES ('26741', '26736', '3', '万泉镇', 'wqz', 'wanquanzhen', '1894', '469002', '110.364,19.2516');
INSERT INTO `rg_region` VALUES ('26742', '26736', '3', '彬村山华侨农场', 'bcshqnc', 'bincunshanhuaqiaonongchang', '1894', '469002', '110.623,19.3022');
INSERT INTO `rg_region` VALUES ('26743', '26736', '3', '国营东红农场', 'gydhnc', 'guoyingdonghongnongchang', '1894', '469002', '110.509,19.364');
INSERT INTO `rg_region` VALUES ('26744', '26736', '3', '大路镇', 'dlz', 'daluzhen', '1894', '469002', '110.424,19.354');
INSERT INTO `rg_region` VALUES ('26745', '26736', '3', '龙江镇', 'ljz', 'longjiangzhen', '1894', '469002', '110.36,19.1595');
INSERT INTO `rg_region` VALUES ('26746', '26736', '3', '潭门镇', 'tmz', 'tanmenzhen', '1894', '469002', '110.546,19.2013');
INSERT INTO `rg_region` VALUES ('26747', '26736', '3', '中原镇', 'zyz', 'zhongyuanzhen', '1894', '469002', '110.419,19.1765');
INSERT INTO `rg_region` VALUES ('26748', '26736', '3', '石壁镇', 'sbz', 'shibizhen', '1894', '469002', '110.168,19.167');
INSERT INTO `rg_region` VALUES ('26749', '26736', '3', '博鳌镇', 'baz', 'boaozhen', '1894', '469002', '110.5,19.1754');
INSERT INTO `rg_region` VALUES ('26750', '26736', '3', '塔洋镇', 'tyz', 'tayangzhen', '1894', '469002', '110.475,19.3404');
INSERT INTO `rg_region` VALUES ('26751', '26736', '3', '长坡镇', 'cpz', 'changpozhen', '1894', '469002', '110.594,19.3213');
INSERT INTO `rg_region` VALUES ('26752', '26736', '3', '阳江镇', 'yjz', 'yangjiangzhen', '1894', '469002', '110.334,19.0558');
INSERT INTO `rg_region` VALUES ('26753', '26610', '2', '东方市', 'dfs', 'dongfangshi', '0807', '469007', '108.653789,19.10198');
INSERT INTO `rg_region` VALUES ('26754', '26753', '3', '东方华侨农场', 'dfhqnc', 'dongfanghuaqiaonongchang', '0807', '469007', '108.696,18.9726');
INSERT INTO `rg_region` VALUES ('26755', '26753', '3', '江边乡', 'jbx', 'jiangbianxiang', '0807', '469007', '109.108,18.8945');
INSERT INTO `rg_region` VALUES ('26756', '26753', '3', '东河镇', 'dhz', 'donghezhen', '0807', '469007', '108.991,19.1321');
INSERT INTO `rg_region` VALUES ('26757', '26753', '3', '新龙镇', 'xlz', 'xinlongzhen', '0807', '469007', '108.686,18.9263');
INSERT INTO `rg_region` VALUES ('26758', '26753', '3', '天安乡', 'tax', 'tiananxiang', '0807', '469007', '108.817,18.8803');
INSERT INTO `rg_region` VALUES ('26759', '26753', '3', '国营广坝农场', 'gygbnc', 'guoyingguangbanongchang', '0807', '469007', '108.732,18.8589');
INSERT INTO `rg_region` VALUES ('26760', '26753', '3', '感城镇', 'gcz', 'ganchengzhen', '0807', '469007', '108.83,18.8833');
INSERT INTO `rg_region` VALUES ('26761', '26753', '3', '四更镇', 'sgz', 'sigengzhen', '0807', '469007', '108.606,19.2646');
INSERT INTO `rg_region` VALUES ('26762', '26753', '3', '三家镇', 'sjz', 'sanjiazhen', '0807', '469007', '108.798,19.2498');
INSERT INTO `rg_region` VALUES ('26763', '26753', '3', '板桥镇', 'bqz', 'banqiaozhen', '0807', '469007', '108.87,18.8744');
INSERT INTO `rg_region` VALUES ('26764', '26753', '3', '大田镇', 'dtz', 'datianzhen', '0807', '469007', '108.976,19.1314');
INSERT INTO `rg_region` VALUES ('26765', '26753', '3', '八所镇', 'bsz', 'basuozhen', '0807', '469007', '108.622,19.0927');
INSERT INTO `rg_region` VALUES ('26766', '26610', '2', '儋州市', 'dzs', 'danzhoushi', '0805', '460400', '109.576782,19.517486');
INSERT INTO `rg_region` VALUES ('26767', '26766', '3', '洋浦经济开发区', 'ypjjkfq', 'yangpujingjikaifaqu', '0805', '460400', '109.162,19.7962');
INSERT INTO `rg_region` VALUES ('26768', '26766', '3', '光村镇', 'gcz', 'guangcunzhen', '0805', '460400', '109.467,19.9035');
INSERT INTO `rg_region` VALUES ('26769', '26766', '3', '兰洋镇', 'lyz', 'lanyangzhen', '0805', '460400', '109.682,19.4833');
INSERT INTO `rg_region` VALUES ('26770', '26766', '3', '和庆镇', 'hqz', 'heqingzhen', '0805', '460400', '109.677,19.5887');
INSERT INTO `rg_region` VALUES ('26771', '26766', '3', '国营蓝洋农场', 'gylync', 'guoyinglanyangnongchang', '0805', '460400', '109.618,19.5107');
INSERT INTO `rg_region` VALUES ('26772', '26766', '3', '东成镇', 'dcz', 'dongchengzhen', '0805', '460400', '109.579,19.7102');
INSERT INTO `rg_region` VALUES ('26773', '26766', '3', '华南热作学院', 'hnrzxy', 'huananrezuoxueyuan', '0805', '460400', '109.505,19.573');
INSERT INTO `rg_region` VALUES ('26774', '26766', '3', '海头镇', 'htz', 'haitouzhen', '0805', '460400', '108.948,19.4939');
INSERT INTO `rg_region` VALUES ('26775', '26766', '3', '木棠镇', 'mtz', 'mutangzhen', '0805', '460400', '109.33,19.8594');
INSERT INTO `rg_region` VALUES ('26776', '26766', '3', '中和镇', 'zhz', 'zhonghezhen', '0805', '460400', '109.351,19.7747');
INSERT INTO `rg_region` VALUES ('26777', '26766', '3', '新州镇', 'xzz', 'xinzhouzhen', '0805', '460400', '109.321,19.7523');
INSERT INTO `rg_region` VALUES ('26778', '26766', '3', '王五镇', 'wwz', 'wangwuzhen', '0805', '460400', '109.258,19.6415');
INSERT INTO `rg_region` VALUES ('26779', '26766', '3', '排浦镇', 'ppz', 'paipuzhen', '0805', '460400', '109.196,19.65');
INSERT INTO `rg_region` VALUES ('26780', '26766', '3', '雅星镇', 'yxz', 'yaxingzhen', '0805', '460400', '109.156,19.4695');
INSERT INTO `rg_region` VALUES ('26781', '26766', '3', '国营八一农场', 'gybync', 'guoyingbayinongchang', '0805', '460400', '109.23,19.3915');
INSERT INTO `rg_region` VALUES ('26782', '26766', '3', '国营西联农场', 'gyxlnc', 'guoyingxiliannongchang', '0805', '460400', '109.537,19.6556');
INSERT INTO `rg_region` VALUES ('26783', '26766', '3', '南丰镇', 'nfz', 'nanfengzhen', '0805', '460400', '109.532,19.4981');
INSERT INTO `rg_region` VALUES ('26784', '26766', '3', '国营西培农场', 'gyxpnc', 'guoyingxipeinongchang', '0805', '460400', '109.31,19.4969');
INSERT INTO `rg_region` VALUES ('26785', '26766', '3', '白马井镇', 'bmjz', 'baimajingzhen', '0805', '460400', '109.268,19.7046');
INSERT INTO `rg_region` VALUES ('26786', '26766', '3', '大成镇', 'dcz', 'dachengzhen', '0805', '460400', '109.345,19.4765');
INSERT INTO `rg_region` VALUES ('26787', '26766', '3', '那大镇', 'ndz', 'nadazhen', '0805', '460400', '109.573,19.5907');
INSERT INTO `rg_region` VALUES ('26788', '26766', '3', '峨蔓镇', 'ewz', 'ewanzhen', '0805', '460400', '109.333,19.8438');
INSERT INTO `rg_region` VALUES ('26789', '26766', '3', '三都镇', 'sdz', 'sanduzhen', '0805', '460400', '109.176,19.7946');
INSERT INTO `rg_region` VALUES ('26790', '26610', '2', '保亭黎族苗族自治县', 'btlzmzzzx', 'baotinglizumiaozuzizhixian', '0801', '469029', '109.70245,18.636371');
INSERT INTO `rg_region` VALUES ('26791', '26790', '3', '国营金江农场', 'gyjjnc', 'guoyingjinjiangnongchang', '0801', '469029', '109.682,18.547');
INSERT INTO `rg_region` VALUES ('26792', '26790', '3', '新政镇', 'xzz', 'xinzhengzhen', '0801', '469029', '109.578,18.5685');
INSERT INTO `rg_region` VALUES ('26793', '26790', '3', '海南保亭热带作物研究所', 'hnbtrdzwyjs', 'hainanbaotingredaizuowuyanjiusuo', '0801', '469029', '109.709,18.6282');
INSERT INTO `rg_region` VALUES ('26794', '26790', '3', '加茂镇', 'jmz', 'jiamaozhen', '0801', '469029', '109.719,18.5033');
INSERT INTO `rg_region` VALUES ('26795', '26790', '3', '保城镇', 'bcz', 'baochengzhen', '0801', '469029', '109.747,18.6854');
INSERT INTO `rg_region` VALUES ('26796', '26790', '3', '国营新星农场', 'gyxxnc', 'guoyingxinxingnongchang', '0801', '469029', '109.729,18.6749');
INSERT INTO `rg_region` VALUES ('26797', '26790', '3', '南林乡', 'nlx', 'nanlinxiang', '0801', '469029', '109.577,18.3893');
INSERT INTO `rg_region` VALUES ('26798', '26790', '3', '国营三道农场', 'gysdnc', 'guoyingsandaonongchang', '0801', '469029', '109.649,18.5179');
INSERT INTO `rg_region` VALUES ('26799', '26790', '3', '什玲镇', 'slz', 'shilingzhen', '0801', '469029', '109.74,18.6941');
INSERT INTO `rg_region` VALUES ('26800', '26790', '3', '毛感乡', 'mgx', 'maoganxiang', '0801', '469029', '109.503,18.5563');
INSERT INTO `rg_region` VALUES ('26801', '26790', '3', '六弓乡', 'lgx', 'liugongxiang', '0801', '469029', '109.803,18.5393');
INSERT INTO `rg_region` VALUES ('26802', '26790', '3', '响水镇', 'xsz', 'xiangshuizhen', '0801', '469029', '109.565,18.7404');
INSERT INTO `rg_region` VALUES ('26803', '26790', '3', '三道镇', 'sdz', 'sandaozhen', '0801', '469029', '109.66,18.5251');
INSERT INTO `rg_region` VALUES ('26804', '26610', '2', '澄迈县', 'cmx', 'chengmaixian', '0804', '469023', '110.007147,19.737095');
INSERT INTO `rg_region` VALUES ('26805', '26804', '3', '福山镇', 'fsz', 'fushanzhen', '0804', '469023', '109.919,19.7325');
INSERT INTO `rg_region` VALUES ('26806', '26804', '3', '永发镇', 'yfz', 'yongfazhen', '0804', '469023', '110.186,19.6424');
INSERT INTO `rg_region` VALUES ('26807', '26804', '3', '桥头镇', 'qtz', 'qiaotouzhen', '0804', '469023', '109.931,19.9171');
INSERT INTO `rg_region` VALUES ('26808', '26804', '3', '中兴镇', 'zxz', 'zhongxingzhen', '0804', '469023', '109.938,19.5697');
INSERT INTO `rg_region` VALUES ('26809', '26804', '3', '金江镇', 'jjz', 'jinjiangzhen', '0804', '469023', '109.987,19.7817');
INSERT INTO `rg_region` VALUES ('26810', '26804', '3', '文儒镇', 'wrz', 'wenruzhen', '0804', '469023', '110.121,19.6454');
INSERT INTO `rg_region` VALUES ('26811', '26804', '3', '老城镇', 'lcz', 'laochengzhen', '0804', '469023', '110.159,19.9529');
INSERT INTO `rg_region` VALUES ('26812', '26804', '3', '国营红岗农场', 'gyhgnc', 'guoyinghonggangnongchang', '0804', '469023', '110.038,19.5642');
INSERT INTO `rg_region` VALUES ('26813', '26804', '3', '国营红光农场', 'gyhgnc', 'guoyinghongguangnongchang', '0804', '469023', '109.957,19.8731');
INSERT INTO `rg_region` VALUES ('26814', '26804', '3', '瑞溪镇', 'rxz', 'ruixizhen', '0804', '469023', '110.087,19.7731');
INSERT INTO `rg_region` VALUES ('26815', '26804', '3', '加乐镇', 'jlz', 'jialezhen', '0804', '469023', '110.042,19.6276');
INSERT INTO `rg_region` VALUES ('26816', '26804', '3', '大丰镇', 'dfz', 'dafengzhen', '0804', '469023', '109.989,19.904');
INSERT INTO `rg_region` VALUES ('26817', '26804', '3', '国营金安农场', 'gyjanc', 'guoyingjinannongchang', '0804', '469023', '110.123,19.7367');
INSERT INTO `rg_region` VALUES ('26818', '26804', '3', '仁兴镇', 'rxz', 'renxingzhen', '0804', '469023', '109.916,19.5062');
INSERT INTO `rg_region` VALUES ('26819', '26804', '3', '国营和岭农场', 'gyhlnc', 'guoyinghelingnongchang', '0804', '469023', '109.814,19.5367');
INSERT INTO `rg_region` VALUES ('26820', '26804', '3', '国营西达农场', 'gyxdnc', 'guoyingxidanongchang', '0804', '469023', '109.862,19.4343');
INSERT INTO `rg_region` VALUES ('26821', '26804', '3', '国营昆仑农场', 'gyklnc', 'guoyingkunlunnongchang', '0804', '469023', '109.802,19.5127');
INSERT INTO `rg_region` VALUES ('26822', '26610', '2', '三亚市', 'sys', 'sanyashi', '0899', '460200', '109.508268,18.247872');
INSERT INTO `rg_region` VALUES ('26823', '26822', '3', '崖州区', 'yzq', 'yazhouqu', '0899', '460205', '109.174306,18.352192');
INSERT INTO `rg_region` VALUES ('26826', '26822', '3', '天涯区', 'tyq', 'tianyaqu', '0899', '460204', '109.506357,18.24734');
INSERT INTO `rg_region` VALUES ('26832', '26822', '3', '海棠区', 'htq', 'haitangqu', '0899', '460202', '109.760778,18.407516');
INSERT INTO `rg_region` VALUES ('26835', '26822', '3', '吉阳区', 'jyq', 'jiyangqu', '0899', '460203', '109.512081,18.247436');
INSERT INTO `rg_region` VALUES ('26839', '26610', '2', '文昌市', 'wcs', 'wenchangshi', '1893', '469005', '110.753975,19.612986');
INSERT INTO `rg_region` VALUES ('26840', '26839', '3', '东阁镇', 'dgz', 'donggezhen', '1893', '469005', '110.799,19.7566');
INSERT INTO `rg_region` VALUES ('26841', '26839', '3', '国营罗豆农场', 'gyldnc', 'guoyingluodounongchang', '1893', '469005', '110.624,19.9713');
INSERT INTO `rg_region` VALUES ('26842', '26839', '3', '文教镇', 'wjz', 'wenjiaozhen', '1893', '469005', '110.856,19.7083');
INSERT INTO `rg_region` VALUES ('26843', '26839', '3', '会文镇', 'hwz', 'huiwenzhen', '1893', '469005', '110.708,19.4957');
INSERT INTO `rg_region` VALUES ('26844', '26839', '3', '国营东路农场', 'gydlnc', 'guoyingdonglunongchang', '1893', '469005', '110.714,19.8524');
INSERT INTO `rg_region` VALUES ('26845', '26839', '3', '铺前镇', 'pqz', 'puqianzhen', '1893', '469005', '110.675,20.0377');
INSERT INTO `rg_region` VALUES ('26846', '26839', '3', '锦山镇', 'jsz', 'jinshanzhen', '1893', '469005', '110.67,20.0418');
INSERT INTO `rg_region` VALUES ('26847', '26839', '3', '翁田镇', 'wtz', 'wengtianzhen', '1893', '469005', '110.813,19.9295');
INSERT INTO `rg_region` VALUES ('26848', '26839', '3', '东郊镇', 'djz', 'dongjiaozhen', '1893', '469005', '110.91,19.6291');
INSERT INTO `rg_region` VALUES ('26849', '26839', '3', '龙楼镇', 'llz', 'longlouzhen', '1893', '469005', '110.938,19.6606');
INSERT INTO `rg_region` VALUES ('26850', '26839', '3', '国营南阳农场', 'gynync', 'guoyingnanyangnongchang', '1893', '469005', '110.556,19.4727');
INSERT INTO `rg_region` VALUES ('26851', '26839', '3', '冯坡镇', 'fpz', 'fengpozhen', '1893', '469005', '110.774,20.0176');
INSERT INTO `rg_region` VALUES ('26852', '26839', '3', '昌洒镇', 'csz', 'changsazhen', '1893', '469005', '111.26,19.9626');
INSERT INTO `rg_region` VALUES ('26853', '26839', '3', '公坡镇', 'gpz', 'gongpozhen', '1893', '469005', '110.836,19.8543');
INSERT INTO `rg_region` VALUES ('26854', '26839', '3', '抱罗镇', 'blz', 'baoluozhen', '1893', '469005', '110.73,19.889');
INSERT INTO `rg_region` VALUES ('26855', '26839', '3', '潭牛镇', 'tnz', 'tanniuzhen', '1893', '469005', '110.623,19.6785');
INSERT INTO `rg_region` VALUES ('26856', '26839', '3', '东路镇', 'dlz', 'dongluzhen', '1893', '469005', '110.658,19.8051');
INSERT INTO `rg_region` VALUES ('26857', '26839', '3', '蓬莱镇', 'plz', 'penglaizhen', '1893', '469005', '110.638,19.5164');
INSERT INTO `rg_region` VALUES ('26858', '26839', '3', '文城镇', 'wcz', 'wenchengzhen', '1893', '469005', '110.708,19.4982');
INSERT INTO `rg_region` VALUES ('26859', '26839', '3', '重兴镇', 'zxz', 'zhongxingzhen', '1893', '469005', '110.654,19.4341');
INSERT INTO `rg_region` VALUES ('26860', '26610', '2', '陵水黎族自治县', 'lslzzzx', 'lingshuilizuzizhixian', '0809', '469028', '110.037218,18.505006');
INSERT INTO `rg_region` VALUES ('26861', '26860', '3', '黎安镇', 'laz', 'lianzhen', '0809', '469028', '110.146,18.4342');
INSERT INTO `rg_region` VALUES ('26862', '26860', '3', '椰林镇', 'ylz', 'yelinzhen', '0809', '469028', '110.02,18.4825');
INSERT INTO `rg_region` VALUES ('26863', '26860', '3', '文罗镇', 'wlz', 'wenluozhen', '0809', '469028', '109.914,18.5734');
INSERT INTO `rg_region` VALUES ('26864', '26860', '3', '新村镇', 'xcz', 'xincunzhen', '0809', '469028', '110.026,18.446');
INSERT INTO `rg_region` VALUES ('26865', '26860', '3', '国营吊罗山林业公司', 'gydlslygs', 'guoyingdiaoluoshanlinyegongsi', '0809', '469028', '109.948,18.6553');
INSERT INTO `rg_region` VALUES ('26866', '26860', '3', '本号镇', 'bhz', 'bonhaozhen', '0809', '469028', '109.856,18.6617');
INSERT INTO `rg_region` VALUES ('26867', '26860', '3', '国营南平农场', 'gynpnc', 'guoyingnanpingnongchang', '0809', '469028', '109.833,18.6336');
INSERT INTO `rg_region` VALUES ('26868', '26860', '3', '群英乡', 'qyx', 'qunyingxiang', '0809', '469028', '109.847,18.5697');
INSERT INTO `rg_region` VALUES ('26869', '26860', '3', '光坡镇', 'gpz', 'guangpozhen', '0809', '469028', '110.04,18.5564');
INSERT INTO `rg_region` VALUES ('26870', '26860', '3', '提蒙乡', 'tmx', 'timengxiang', '0809', '469028', '110.013,18.6404');
INSERT INTO `rg_region` VALUES ('26871', '26860', '3', '三才镇', 'scz', 'sancaizhen', '0809', '469028', '109.963,18.4915');
INSERT INTO `rg_region` VALUES ('26872', '26860', '3', '隆广镇', 'lgz', 'longguangzhen', '0809', '469028', '109.858,18.4802');
INSERT INTO `rg_region` VALUES ('26873', '26860', '3', '国营岭门农场', 'gylmnc', 'guoyinglingmennongchang', '0809', '469028', '110.046,18.6244');
INSERT INTO `rg_region` VALUES ('26874', '26860', '3', '英州镇', 'yzz', 'yingzhouzhen', '0809', '469028', '109.876,18.4739');
INSERT INTO `rg_region` VALUES ('26875', '26610', '2', '三沙市', 'sss', 'sanshashi', '2898', '460300', '112.34882,16.831039');
INSERT INTO `rg_region` VALUES ('26876', '26875', '3', '中沙群岛的岛礁及其海域', 'zsqdddjjqhy', 'zhongshaqundaodidaojiaojiqihaiyu', '2801', '460323', '117.740071,15.112856');
INSERT INTO `rg_region` VALUES ('26877', '26875', '3', '西沙群岛', 'xsqd', 'xishaqundao', '1895', '460321', '111.792944,16.204546');
INSERT INTO `rg_region` VALUES ('26879', '26875', '3', '南沙群岛', 'nsqd', 'nanshaqundao', '1891', '460322', '116.749998,11.471888');
INSERT INTO `rg_region` VALUES ('26880', '26610', '2', '海口市', 'hks', 'haikoushi', '0898', '460100', '110.33119,20.031971');
INSERT INTO `rg_region` VALUES ('26881', '26880', '3', '美兰区', 'mlq', 'moilanqu', '0898', '460108', '110.356566,20.03074');
INSERT INTO `rg_region` VALUES ('26898', '26880', '3', '龙华区', 'lhq', 'longhuaqu', '0898', '460106', '110.330373,20.031026');
INSERT INTO `rg_region` VALUES ('26910', '26880', '3', '琼山区', 'qsq', 'qiongshanqu', '0898', '460107', '110.354722,20.001051');
INSERT INTO `rg_region` VALUES ('26926', '26880', '3', '秀英区', 'xyq', 'xiuyingqu', '0898', '460105', '110.282393,20.008145');
INSERT INTO `rg_region` VALUES ('26935', '0', '1', '青海省', 'qhs', 'qinghaisheng', '', '630000', '101.778916,36.623178');
INSERT INTO `rg_region` VALUES ('26936', '26935', '2', '果洛藏族自治州', 'glczzzz', 'guoluocangzuzizhizhou', '0975', '632600', '100.242143,34.4736');
INSERT INTO `rg_region` VALUES ('26937', '26936', '3', '达日县', 'drx', 'darixian', '0975', '632624', '99.651715,33.753259');
INSERT INTO `rg_region` VALUES ('26948', '26936', '3', '玛沁县', 'mqx', 'maqinxian', '0975', '632621', '100.243531,34.473386');
INSERT INTO `rg_region` VALUES ('26957', '26936', '3', '甘德县', 'gdx', 'gandexian', '0975', '632623', '99.902589,33.966987');
INSERT INTO `rg_region` VALUES ('26965', '26936', '3', '班玛县', 'bmx', 'banmaxian', '0975', '632622', '100.737955,32.931589');
INSERT INTO `rg_region` VALUES ('26975', '26936', '3', '久治县', 'jzx', 'jiuzhixian', '0975', '632625', '101.484884,33.430217');
INSERT INTO `rg_region` VALUES ('26982', '26936', '3', '玛多县', 'mdx', 'maduoxian', '0975', '632626', '98.211343,34.91528');
INSERT INTO `rg_region` VALUES ('26987', '26935', '2', '海西蒙古族藏族自治州', 'hxmgzczzzz', 'haiximengguzucangzuzizhizhou', '0977', '632800', '97.370785,37.374663');
INSERT INTO `rg_region` VALUES ('26988', '26987', '3', '都兰县', 'dlx', 'dulanxian', '0977', '632822', '98.089161,36.298553');
INSERT INTO `rg_region` VALUES ('26997', '26987', '3', '德令哈市', 'dlhs', 'delinghashi', '0977', '632802', '97.370143,37.374555');
INSERT INTO `rg_region` VALUES ('27005', '26987', '3', '天峻县', 'tjx', 'tianjunxian', '0977', '632823', '99.02078,37.29906');
INSERT INTO `rg_region` VALUES ('27016', '26987', '3', '格尔木市', 'goms', 'geormushi', '0977', '632801', '94.905777,36.401541');
INSERT INTO `rg_region` VALUES ('27028', '26987', '3', '乌兰县', 'wlx', 'wulanxian', '0977', '632821', '98.479852,36.930389');
INSERT INTO `rg_region` VALUES ('27034', '26987', '3', '海西蒙古族藏族自治州直辖', 'hxmgzczzzzzx', 'haiximengguzucangzuzizhizhouzhixia', '0977', '632825', '95.357233,37.853631');
INSERT INTO `rg_region` VALUES ('27037', '26987', '3', '茫崖市', 'mys', 'mangyashi', '0977', '632803', '90.855955,38.247117');
INSERT INTO `rg_region` VALUES ('27041', '26935', '2', '黄南藏族自治州', 'hnczzzz', 'huangnancangzuzizhizhou', '0973', '632300', '102.019988,35.517744');
INSERT INTO `rg_region` VALUES ('27042', '27041', '3', '同仁县', 'trx', 'tongrenxian', '0973', '632321', '102.017604,35.516337');
INSERT INTO `rg_region` VALUES ('27054', '27041', '3', '尖扎县', 'jzx', 'jianzaxian', '0973', '632322', '102.031953,35.938205');
INSERT INTO `rg_region` VALUES ('27064', '27041', '3', '泽库县', 'zkx', 'zekuxian', '0973', '632323', '101.469343,35.036842');
INSERT INTO `rg_region` VALUES ('27072', '27041', '3', '河南蒙古族自治县', 'hnmgzzzx', 'henanmengguzuzizhixian', '0973', '632324', '101.611877,34.734522');
INSERT INTO `rg_region` VALUES ('27078', '26935', '2', '海南藏族自治州', 'hnczzzz', 'hainancangzuzizhizhou', '0974', '632500', '100.619542,36.280353');
INSERT INTO `rg_region` VALUES ('27079', '27078', '3', '共和县', 'ghx', 'gonghexian', '0974', '632521', '100.619597,36.280286');
INSERT INTO `rg_region` VALUES ('27095', '27078', '3', '贵南县', 'gnx', 'guinanxian', '0974', '632525', '100.74792,35.587085');
INSERT INTO `rg_region` VALUES ('27103', '27078', '3', '贵德县', 'gdx', 'guidexian', '0974', '632523', '101.431856,36.040456');
INSERT INTO `rg_region` VALUES ('27111', '27078', '3', '同德县', 'tdx', 'tongdexian', '0974', '632522', '100.579465,35.254492');
INSERT INTO `rg_region` VALUES ('27118', '27078', '3', '兴海县', 'xhx', 'xinghaixian', '0974', '632524', '99.986963,35.58909');
INSERT INTO `rg_region` VALUES ('27127', '26935', '2', '海东市', 'hds', 'haidongshi', '0972', '630200', '102.10327,36.502916');
INSERT INTO `rg_region` VALUES ('27128', '27127', '3', '民和回族土族自治县', 'mhhztzzzx', 'minhehuizutuzuzizhixian', '0972', '630222', '102.804209,36.329451');
INSERT INTO `rg_region` VALUES ('27151', '27127', '3', '乐都区', 'ldq', 'leduqu', '0972', '630202', '102.402431,36.480291');
INSERT INTO `rg_region` VALUES ('27171', '27127', '3', '循化撒拉族自治县', 'xhslzzzx', 'xunhuasalazuzizhixian', '0972', '630225', '102.486534,35.847247');
INSERT INTO `rg_region` VALUES ('27181', '27127', '3', '化隆回族自治县', 'hlhzzzx', 'hualonghuizuzizhixian', '0972', '630224', '102.262329,36.098322');
INSERT INTO `rg_region` VALUES ('27201', '27127', '3', '平安区', 'paq', 'pinganqu', '0972', '630203', '102.104295,36.502714');
INSERT INTO `rg_region` VALUES ('27210', '27127', '3', '互助土族自治县', 'hztzzzx', 'huzhutuzuzizhixian', '0972', '630223', '101.956734,36.83994');
INSERT INTO `rg_region` VALUES ('27230', '26935', '2', '玉树藏族自治州', 'ysczzzz', 'yushucangzuzizhizhou', '0976', '632700', '97.008522,33.004049');
INSERT INTO `rg_region` VALUES ('27231', '27230', '3', '治多县', 'zdx', 'zhiduoxian', '0976', '632724', '95.616843,33.852322');
INSERT INTO `rg_region` VALUES ('27238', '27230', '3', '曲麻莱县', 'qmlx', 'qumalaixian', '0976', '632726', '95.800674,34.12654');
INSERT INTO `rg_region` VALUES ('27245', '27230', '3', '玉树市', 'yss', 'yushushi', '0976', '632701', '97.008762,33.00393');
INSERT INTO `rg_region` VALUES ('27255', '27230', '3', '杂多县', 'zdx', 'zaduoxian', '0976', '632722', '95.293423,32.891886');
INSERT INTO `rg_region` VALUES ('27264', '27230', '3', '称多县', 'cdx', 'chengduoxian', '0976', '632723', '97.110893,33.367884');
INSERT INTO `rg_region` VALUES ('27272', '27230', '3', '囊谦县', 'nqx', 'nangqianxian', '0976', '632725', '96.479797,32.203206');
INSERT INTO `rg_region` VALUES ('27283', '26935', '2', '西宁市', 'xns', 'xiningshi', '0971', '630100', '101.778916,36.623178');
INSERT INTO `rg_region` VALUES ('27284', '27283', '3', '湟源县', 'hyx', 'huangyuanxian', '0971', '630123', '101.263435,36.684818');
INSERT INTO `rg_region` VALUES ('27294', '27283', '3', '大通回族土族自治县', 'dthztzzzx', 'datonghuizutuzuzizhixian', '0971', '630121', '101.684183,36.931343');
INSERT INTO `rg_region` VALUES ('27315', '27283', '3', '城东区', 'cdq', 'chengdongqu', '0971', '630102', '101.796095,36.616043');
INSERT INTO `rg_region` VALUES ('27325', '27283', '3', '城中区', 'czq', 'chengzhongqu', '0971', '630103', '101.784554,36.621181');
INSERT INTO `rg_region` VALUES ('27335', '27283', '3', '湟中县', 'hzx', 'huangzhongxian', '0971', '630122', '101.569475,36.500419');
INSERT INTO `rg_region` VALUES ('27353', '27283', '3', '城西区', 'cxq', 'chengxiqu', '0971', '630104', '101.763649,36.628323');
INSERT INTO `rg_region` VALUES ('27360', '27283', '3', '城北区', 'cbq', 'chengbeiqu', '0971', '630105', '101.761297,36.648448');
INSERT INTO `rg_region` VALUES ('27367', '26935', '2', '海北藏族自治州', 'hbczzzz', 'haibeicangzuzizhizhou', '0970', '632200', '100.901059,36.959435');
INSERT INTO `rg_region` VALUES ('27368', '27367', '3', '海晏县', 'hyx', 'haiyanxian', '0970', '632223', '100.90049,36.959542');
INSERT INTO `rg_region` VALUES ('27375', '27367', '3', '门源回族自治县', 'myhzzzx', 'menyuanhuizuzizhixian', '0970', '632221', '101.618461,37.376627');
INSERT INTO `rg_region` VALUES ('27390', '27367', '3', '刚察县', 'gcx', 'gangchaxian', '0970', '632224', '100.138417,37.326263');
INSERT INTO `rg_region` VALUES ('27398', '27367', '3', '祁连县', 'qlx', 'qilianxian', '0970', '632222', '100.249778,38.175409');
INSERT INTO `rg_region` VALUES ('27406', '0', '1', '广西壮族自治区', 'gxzzzzq', 'guangxizhuangzuzizhiqu', '', '450000', '108.320004,22.82402');
INSERT INTO `rg_region` VALUES ('27407', '27406', '2', '百色市', 'bss', 'baiseshi', '0776', '451000', '106.616285,23.897742');
INSERT INTO `rg_region` VALUES ('27408', '27407', '3', '乐业县', 'lyx', 'leyexian', '0776', '451028', '106.559638,24.782204');
INSERT INTO `rg_region` VALUES ('27417', '27407', '3', '隆林各族自治县', 'llgzzzx', 'longlingezuzizhixian', '0776', '451031', '105.342363,24.774318');
INSERT INTO `rg_region` VALUES ('27434', '27407', '3', '西林县', 'xlx', 'xilinxian', '0776', '451030', '105.095025,24.492041');
INSERT INTO `rg_region` VALUES ('27443', '27407', '3', '凌云县', 'lyx', 'lingyunxian', '0776', '451027', '106.56487,24.345643');
INSERT INTO `rg_region` VALUES ('27452', '27407', '3', '田阳县', 'tyx', 'tianyangxian', '0776', '451021', '106.904315,23.736079');
INSERT INTO `rg_region` VALUES ('27463', '27407', '3', '右江区', 'yjq', 'youjiangqu', '0776', '451002', '106.615727,23.897675');
INSERT INTO `rg_region` VALUES ('27473', '27407', '3', '那坡县', 'npx', 'napoxian', '0776', '451026', '105.833553,23.400785');
INSERT INTO `rg_region` VALUES ('27483', '27407', '3', '田东县', 'tdx', 'tiandongxian', '0776', '451022', '107.12426,23.600444');
INSERT INTO `rg_region` VALUES ('27494', '27407', '3', '靖西市', 'jxs', 'jingxishi', '0776', '451081', '106.417549,23.134766');
INSERT INTO `rg_region` VALUES ('27514', '27407', '3', '平果县', 'pgx', 'pingguoxian', '0776', '451023', '107.580403,23.320479');
INSERT INTO `rg_region` VALUES ('27528', '27407', '3', '德保县', 'dbx', 'debaoxian', '0776', '451024', '106.618164,23.321464');
INSERT INTO `rg_region` VALUES ('27542', '27407', '3', '田林县', 'tlx', 'tianlinxian', '0776', '451029', '106.235047,24.290262');
INSERT INTO `rg_region` VALUES ('27557', '27406', '2', '钦州市', 'qzs', 'qinzhoushi', '0777', '450700', '108.624175,21.967127');
INSERT INTO `rg_region` VALUES ('27558', '27557', '3', '灵山县', 'lsx', 'lingshanxian', '0777', '450721', '109.293468,22.418041');
INSERT INTO `rg_region` VALUES ('27579', '27557', '3', '浦北县', 'pbx', 'pubeixian', '0777', '450722', '109.556341,22.268335');
INSERT INTO `rg_region` VALUES ('27596', '27557', '3', '钦南区', 'qnq', 'qinnanqu', '0777', '450702', '108.626629,21.966808');
INSERT INTO `rg_region` VALUES ('27618', '27557', '3', '钦北区', 'qbq', 'qinbeiqu', '0777', '450703', '108.44911,22.132761');
INSERT INTO `rg_region` VALUES ('27633', '27406', '2', '北海市', 'bhs', 'beihaishi', '0779', '450500', '109.119254,21.473343');
INSERT INTO `rg_region` VALUES ('27634', '27633', '3', '合浦县', 'hpx', 'hepuxian', '0779', '450521', '109.200695,21.663554');
INSERT INTO `rg_region` VALUES ('27650', '27633', '3', '铁山港区', 'tsgq', 'tioshangangqu', '0779', '450512', '109.450573,21.5928');
INSERT INTO `rg_region` VALUES ('27654', '27633', '3', '银海区', 'yhq', 'yinhaiqu', '0779', '450503', '109.118707,21.444909');
INSERT INTO `rg_region` VALUES ('27659', '27633', '3', '海城区', 'hcq', 'haichengqu', '0779', '450502', '109.107529,21.468443');
INSERT INTO `rg_region` VALUES ('27668', '27406', '2', '桂林市', 'gls', 'guilinshi', '0773', '450300', '110.299121,25.274215');
INSERT INTO `rg_region` VALUES ('27669', '27668', '3', '资源县', 'zyx', 'ziyuanxian', '0773', '450329', '110.642587,26.0342');
INSERT INTO `rg_region` VALUES ('27677', '27668', '3', '临桂区', 'lgq', 'linguiqu', '0773', '450312', '110.205487,25.246257');
INSERT INTO `rg_region` VALUES ('27689', '27668', '3', '兴安县', 'xax', 'xinganxian', '0773', '450325', '110.670783,25.609554');
INSERT INTO `rg_region` VALUES ('27700', '27668', '3', '雁山区', 'ysq', 'yanshanqu', '0773', '450311', '110.305667,25.077646');
INSERT INTO `rg_region` VALUES ('27705', '27668', '3', '永福县', 'yfx', 'yongfuxian', '0773', '450326', '109.989208,24.986692');
INSERT INTO `rg_region` VALUES ('27715', '27668', '3', '阳朔县', 'ysx', 'yangshuoxian', '0773', '450321', '110.494699,24.77534');
INSERT INTO `rg_region` VALUES ('27725', '27668', '3', '恭城瑶族自治县', 'gcyzzzx', 'gongchengyaozuzizhixian', '0773', '450332', '110.82952,24.833612');
INSERT INTO `rg_region` VALUES ('27735', '27668', '3', '七星区', 'qxq', 'qixingqu', '0773', '450305', '110.317577,25.254339');
INSERT INTO `rg_region` VALUES ('27741', '27668', '3', '平乐县', 'plx', 'pinglexian', '0773', '450330', '110.642821,24.632216');
INSERT INTO `rg_region` VALUES ('27752', '27668', '3', '荔浦市', 'lps', 'lipushi', '0773', '450381', '110.400149,24.497786');
INSERT INTO `rg_region` VALUES ('27766', '27668', '3', '龙胜各族自治县', 'lsgzzzx', 'longshenggezuzizhixian', '0773', '450328', '110.009423,25.796428');
INSERT INTO `rg_region` VALUES ('27777', '27668', '3', '秀峰区', 'xfq', 'xiufengqu', '0773', '450302', '110.292445,25.278544');
INSERT INTO `rg_region` VALUES ('27781', '27668', '3', '象山区', 'xsq', 'xiangshanqu', '0773', '450304', '110.284882,25.261986');
INSERT INTO `rg_region` VALUES ('27786', '27668', '3', '灌阳县', 'gyx', 'guanyangxian', '0773', '450327', '111.160248,25.489098');
INSERT INTO `rg_region` VALUES ('27796', '27668', '3', '全州县', 'qzx', 'quanzhouxian', '0773', '450324', '111.072989,25.929897');
INSERT INTO `rg_region` VALUES ('27815', '27668', '3', '叠彩区', 'dcq', 'diecaiqu', '0773', '450303', '110.300783,25.301334');
INSERT INTO `rg_region` VALUES ('27819', '27668', '3', '灵川县', 'lcx', 'lingchuanxian', '0773', '450323', '110.325712,25.408541');
INSERT INTO `rg_region` VALUES ('27831', '27406', '2', '柳州市', 'lzs', 'liuzhoushi', '0772', '450200', '109.411703,24.314617');
INSERT INTO `rg_region` VALUES ('27832', '27831', '3', '三江侗族自治县', 'sjdzzzx', 'sanjiangdongzuzizhixian', '0772', '450226', '109.614846,25.78553');
INSERT INTO `rg_region` VALUES ('27848', '27831', '3', '融水苗族自治县', 'rsmzzzx', 'rongshuimiaozuzizhixian', '0772', '450225', '109.252744,25.068812');
INSERT INTO `rg_region` VALUES ('27869', '27831', '3', '融安县', 'rax', 'ronganxian', '0772', '450224', '109.403621,25.214703');
INSERT INTO `rg_region` VALUES ('27882', '27831', '3', '鹿寨县', 'lzx', 'luzhaixian', '0772', '450223', '109.740805,24.483405');
INSERT INTO `rg_region` VALUES ('27892', '27831', '3', '柳北区', 'lbq', 'liubeiqu', '0772', '450205', '109.406577,24.359145');
INSERT INTO `rg_region` VALUES ('27903', '27831', '3', '城中区', 'czq', 'chengzhongqu', '0772', '450202', '109.411749,24.312324');
INSERT INTO `rg_region` VALUES ('27911', '27831', '3', '柳城县', 'lcx', 'liuchengxian', '0772', '450222', '109.245812,24.655121');
INSERT INTO `rg_region` VALUES ('27924', '27831', '3', '鱼峰区', 'yfq', 'yufengqu', '0772', '450203', '109.415364,24.303848');
INSERT INTO `rg_region` VALUES ('27937', '27831', '3', '柳江区', 'ljq', 'liujiangqu', '0772', '450206', '109.334503,24.257512');
INSERT INTO `rg_region` VALUES ('27948', '27831', '3', '柳南区', 'lnq', 'liunanqu', '0772', '450204', '109.395936,24.287013');
INSERT INTO `rg_region` VALUES ('27960', '27406', '2', '河池市', 'hcs', 'hechishi', '0778', '451200', '108.062105,24.695899');
INSERT INTO `rg_region` VALUES ('27961', '27960', '3', '南丹县', 'ndx', 'nandanxian', '0778', '451221', '107.546605,24.983192');
INSERT INTO `rg_region` VALUES ('27973', '27960', '3', '环江毛南族自治县', 'hjmnzzzx', 'huanjiangmaonanzuzizhixian', '0778', '451226', '108.258669,24.827628');
INSERT INTO `rg_region` VALUES ('27986', '27960', '3', '天峨县', 'tex', 'tianexian', '0778', '451222', '107.174939,24.985964');
INSERT INTO `rg_region` VALUES ('27996', '27960', '3', '罗城仫佬族自治县', 'lcmlzzzx', 'luochengmulaozuzizhixian', '0778', '451225', '108.902453,24.779327');
INSERT INTO `rg_region` VALUES ('28008', '27960', '3', '金城江区', 'jcjq', 'jinchengjiangqu', '0778', '451202', '108.062131,24.695625');
INSERT INTO `rg_region` VALUES ('28021', '27960', '3', '凤山县', 'fsx', 'fengshanxian', '0778', '451223', '107.044592,24.544561');
INSERT INTO `rg_region` VALUES ('28031', '27960', '3', '宜州区', 'yzq', 'yizhouqu', '0778', '451203', '108.653965,24.492193');
INSERT INTO `rg_region` VALUES ('28048', '27960', '3', '都安瑶族自治县', 'dayzzzx', 'duanyaozuzizhixian', '0778', '451228', '108.102761,23.934964');
INSERT INTO `rg_region` VALUES ('28068', '27960', '3', '巴马瑶族自治县', 'bmyzzzx', 'bamayaozuzizhixian', '0778', '451227', '107.253126,24.139538');
INSERT INTO `rg_region` VALUES ('28079', '27960', '3', '大化瑶族自治县', 'dhyzzzx', 'dahuayaozuzizhixian', '0778', '451229', '107.9945,23.739596');
INSERT INTO `rg_region` VALUES ('28096', '27960', '3', '东兰县', 'dlx', 'donglanxian', '0778', '451224', '107.373696,24.509367');
INSERT INTO `rg_region` VALUES ('28111', '27406', '2', '南宁市', 'nns', 'nanningshi', '0771', '450100', '108.320004,22.82402');
INSERT INTO `rg_region` VALUES ('28112', '28111', '3', '马山县', 'msx', 'mashanxian', '0771', '450124', '108.172903,23.711758');
INSERT INTO `rg_region` VALUES ('28125', '28111', '3', '武鸣区', 'wmq', 'wumingqu', '0771', '450110', '108.280717,23.157163');
INSERT INTO `rg_region` VALUES ('28142', '28111', '3', '上林县', 'slx', 'shanglinxian', '0771', '450125', '108.603937,23.431769');
INSERT INTO `rg_region` VALUES ('28154', '28111', '3', '横县', 'hx', 'hengxian', '0771', '450127', '109.270987,22.68743');
INSERT INTO `rg_region` VALUES ('28173', '28111', '3', '宾阳县', 'byx', 'binyangxian', '0771', '450126', '108.816735,23.216884');
INSERT INTO `rg_region` VALUES ('28191', '28111', '3', '良庆区', 'lqq', 'liangqingqu', '0771', '450108', '108.322102,22.75909');
INSERT INTO `rg_region` VALUES ('28199', '28111', '3', '江南区', 'jnq', 'jiangnanqu', '0771', '450105', '108.310478,22.799593');
INSERT INTO `rg_region` VALUES ('28211', '28111', '3', '邕宁区', 'ynq', 'yongningqu', '0771', '450109', '108.484251,22.756598');
INSERT INTO `rg_region` VALUES ('28217', '28111', '3', '西乡塘区', 'xxtq', 'xixiangtangqu', '0771', '450107', '108.306903,22.832779');
INSERT INTO `rg_region` VALUES ('28234', '28111', '3', '青秀区', 'qxq', 'qingxiuqu', '0771', '450103', '108.346113,22.816614');
INSERT INTO `rg_region` VALUES ('28246', '28111', '3', '隆安县', 'lax', 'longanxian', '0771', '450123', '107.688661,23.174763');
INSERT INTO `rg_region` VALUES ('28258', '28111', '3', '兴宁区', 'xnq', 'xingningqu', '0771', '450102', '108.320189,22.819511');
INSERT INTO `rg_region` VALUES ('28265', '27406', '2', '来宾市', 'lbs', 'laibinshi', '1772', '451300', '109.229772,23.733766');
INSERT INTO `rg_region` VALUES ('28266', '28265', '3', '金秀瑶族自治县', 'jxyzzzx', 'jinxiuyaozuzizhixian', '1772', '451324', '110.188556,24.134941');
INSERT INTO `rg_region` VALUES ('28277', '28265', '3', '忻城县', 'xcx', 'xinchengxian', '1772', '451321', '108.667361,24.064779');
INSERT INTO `rg_region` VALUES ('28290', '28265', '3', '象州县', 'xzx', 'xiangzhouxian', '1772', '451322', '109.684555,23.959824');
INSERT INTO `rg_region` VALUES ('28302', '28265', '3', '兴宾区', 'xbq', 'xingbinqu', '1772', '451302', '109.230541,23.732926');
INSERT INTO `rg_region` VALUES ('28329', '28265', '3', '合山市', 'hss', 'heshanshi', '1772', '451381', '108.88858,23.81311');
INSERT INTO `rg_region` VALUES ('28333', '28265', '3', '武宣县', 'wxx', 'wuxuanxian', '1772', '451323', '109.66287,23.604162');
INSERT INTO `rg_region` VALUES ('28345', '27406', '2', '崇左市', 'czs', 'chongzuoshi', '1771', '451400', '107.353926,22.404108');
INSERT INTO `rg_region` VALUES ('28346', '28345', '3', '天等县', 'tdx', 'tiandongxian', '1771', '451425', '107.142441,23.082484');
INSERT INTO `rg_region` VALUES ('28360', '28345', '3', '扶绥县', 'fsx', 'fusuixian', '1771', '451421', '107.911533,22.635821');
INSERT INTO `rg_region` VALUES ('28372', '28345', '3', '大新县', 'dxx', 'daxinxian', '1771', '451424', '107.200803,22.833369');
INSERT INTO `rg_region` VALUES ('28388', '28345', '3', '江州区', 'jzq', 'jiangzhouqu', '1771', '451402', '107.354443,22.40469');
INSERT INTO `rg_region` VALUES ('28402', '28345', '3', '宁明县', 'nmx', 'ningmingxian', '1771', '451422', '107.067616,22.131353');
INSERT INTO `rg_region` VALUES ('28418', '28345', '3', '凭祥市', 'pxs', 'pingxiangshi', '1771', '451481', '106.759038,22.108882');
INSERT INTO `rg_region` VALUES ('28424', '28345', '3', '龙州县', 'lzx', 'longzhouxian', '1771', '451423', '106.857502,22.343716');
INSERT INTO `rg_region` VALUES ('28437', '27406', '2', '贺州市', 'hzs', 'hezhoushi', '1774', '451100', '111.552056,24.414141');
INSERT INTO `rg_region` VALUES ('28438', '28437', '3', '富川瑶族自治县', 'fcyzzzx', 'fuchuanyaozuzizhixian', '1774', '451123', '111.277228,24.81896');
INSERT INTO `rg_region` VALUES ('28451', '28437', '3', '昭平县', 'zpx', 'zhaopingxian', '1774', '451121', '110.810865,24.172958');
INSERT INTO `rg_region` VALUES ('28464', '28437', '3', '八步区', 'bbq', 'babuqu', '1774', '451102', '111.551991,24.412446');
INSERT INTO `rg_region` VALUES ('28481', '28437', '3', '平桂区', 'pgq', 'pingguiqu', '1774', '451103', '111.524014,24.417148');
INSERT INTO `rg_region` VALUES ('28491', '28437', '3', '钟山县', 'zsx', 'zhongshanxian', '1774', '451122', '111.303629,24.528566');
INSERT INTO `rg_region` VALUES ('28504', '27406', '2', '防城港市', 'fcgs', 'fangchenggangshi', '0770', '450600', '108.345478,21.614631');
INSERT INTO `rg_region` VALUES ('28505', '28504', '3', '防城区', 'fcq', 'fangchengqu', '0770', '450603', '108.358426,21.764758');
INSERT INTO `rg_region` VALUES ('28521', '28504', '3', '上思县', 'ssx', 'shangsixian', '0770', '450621', '107.982139,22.151423');
INSERT INTO `rg_region` VALUES ('28531', '28504', '3', '港口区', 'gkq', 'gangkouqu', '0770', '450602', '108.346281,21.614406');
INSERT INTO `rg_region` VALUES ('28537', '28504', '3', '东兴市', 'dxs', 'dongxingshi', '0770', '450681', '107.97017,21.541172');
INSERT INTO `rg_region` VALUES ('28541', '27406', '2', '梧州市', 'wzs', 'wuzhoushi', '0774', '450400', '111.297604,23.474803');
INSERT INTO `rg_region` VALUES ('28542', '28541', '3', '蒙山县', 'msx', 'mengshanxian', '0774', '450423', '110.5226,24.199829');
INSERT INTO `rg_region` VALUES ('28552', '28541', '3', '藤县', 'tx', 'tengxian', '0774', '450422', '110.931826,23.373963');
INSERT INTO `rg_region` VALUES ('28570', '28541', '3', '长洲区', 'czq', 'changzhouqu', '0774', '450405', '111.275678,23.4777');
INSERT INTO `rg_region` VALUES ('28575', '28541', '3', '岑溪市', 'cxs', 'cenxishi', '0774', '450481', '110.998114,22.918406');
INSERT INTO `rg_region` VALUES ('28590', '28541', '3', '龙圩区', 'lwq', 'longweiqu', '0774', '450406', '111.246035,23.40996');
INSERT INTO `rg_region` VALUES ('28595', '28541', '3', '苍梧县', 'cwx', 'cangwuxian', '0774', '450421', '111.544008,23.845097');
INSERT INTO `rg_region` VALUES ('28605', '28541', '3', '万秀区', 'wxq', 'wanxiuqu', '0774', '450403', '111.315817,23.471318');
INSERT INTO `rg_region` VALUES ('28616', '27406', '2', '玉林市', 'yls', 'yulinshi', '0775', '450900', '110.154393,22.63136');
INSERT INTO `rg_region` VALUES ('28617', '28616', '3', '兴业县', 'xyx', 'xingyexian', '0775', '450924', '109.877768,22.74187');
INSERT INTO `rg_region` VALUES ('28631', '28616', '3', '福绵区', 'fmq', 'fumianqu', '0775', '450903', '110.054155,22.58163');
INSERT INTO `rg_region` VALUES ('28638', '28616', '3', '玉州区', 'yzq', 'yuzhouqu', '0775', '450902', '110.154912,22.632132');
INSERT INTO `rg_region` VALUES ('28648', '28616', '3', '博白县', 'bbx', 'bobaixian', '0775', '450923', '109.980004,22.271285');
INSERT INTO `rg_region` VALUES ('28677', '28616', '3', '陆川县', 'lcx', 'luchuanxian', '0775', '450922', '110.264842,22.321054');
INSERT INTO `rg_region` VALUES ('28692', '28616', '3', '北流市', 'bls', 'beiliushi', '0775', '450981', '110.348052,22.701648');
INSERT INTO `rg_region` VALUES ('28718', '28616', '3', '容县', 'rx', 'rongxian', '0775', '450921', '110.552467,22.856435');
INSERT INTO `rg_region` VALUES ('28734', '27406', '2', '贵港市', 'ggs', 'guigangshi', '1755', '450800', '109.602146,23.0936');
INSERT INTO `rg_region` VALUES ('28735', '28734', '3', '港南区', 'gnq', 'gangnanqu', '1755', '450803', '109.604665,23.067516');
INSERT INTO `rg_region` VALUES ('28745', '28734', '3', '覃塘区', 'ttq', 'tantangqu', '1755', '450804', '109.415697,23.132815');
INSERT INTO `rg_region` VALUES ('28756', '28734', '3', '港北区', 'gbq', 'gangbeiqu', '1755', '450802', '109.59481,23.107677');
INSERT INTO `rg_region` VALUES ('28765', '28734', '3', '平南县', 'pnx', 'pingnanxian', '1755', '450821', '110.397485,23.544546');
INSERT INTO `rg_region` VALUES ('28787', '28734', '3', '桂平市', 'gps', 'guipingshi', '1755', '450881', '110.074668,23.382473');
INSERT INTO `rg_region` VALUES ('28814', '0', '1', '宁夏回族自治区', 'nxhzzzq', 'ningxiahuizuzizhiqu', '', '640000', '106.278179,38.46637');
INSERT INTO `rg_region` VALUES ('28815', '28814', '2', '石嘴山市', 'szss', 'shizuishanshi', '0952', '640200', '106.376173,39.01333');
INSERT INTO `rg_region` VALUES ('28816', '28815', '3', '大武口区', 'dwkq', 'dawukouqu', '0952', '640202', '106.376651,39.014158');
INSERT INTO `rg_region` VALUES ('28828', '28815', '3', '平罗县', 'plx', 'pingluoxian', '0952', '640221', '106.54489,38.90674');
INSERT INTO `rg_region` VALUES ('28843', '28815', '3', '惠农区', 'hnq', 'huinongqu', '0952', '640205', '106.775513,39.230094');
INSERT INTO `rg_region` VALUES ('28859', '28814', '2', '固原市', 'gys', 'guyuanshi', '0954', '640400', '106.285241,36.004561');
INSERT INTO `rg_region` VALUES ('28860', '28859', '3', '彭阳县', 'pyx', 'pengyangxian', '0954', '640425', '106.641512,35.849975');
INSERT INTO `rg_region` VALUES ('28873', '28859', '3', '隆德县', 'ldx', 'longdexian', '0954', '640423', '106.12344,35.618234');
INSERT INTO `rg_region` VALUES ('28888', '28859', '3', '泾源县', 'jyx', 'jingyuanxian', '0954', '640424', '106.338674,35.49344');
INSERT INTO `rg_region` VALUES ('28896', '28859', '3', '西吉县', 'xjx', 'xijixian', '0954', '640422', '105.731801,35.965384');
INSERT INTO `rg_region` VALUES ('28916', '28859', '3', '原州区', 'yzq', 'yuanzhouqu', '0954', '640402', '106.28477,36.005337');
INSERT INTO `rg_region` VALUES ('28931', '28814', '2', '吴忠市', 'wzs', 'wuzhongshi', '0953', '640300', '106.199409,37.986165');
INSERT INTO `rg_region` VALUES ('28932', '28931', '3', '青铜峡市', 'qtxs', 'qingtongxiashi', '0953', '640381', '106.075395,38.021509');
INSERT INTO `rg_region` VALUES ('28944', '28931', '3', '红寺堡区', 'hsbq', 'hongsibaoqu', '0953', '640303', '106.067315,37.421616');
INSERT INTO `rg_region` VALUES ('28950', '28931', '3', '盐池县', 'ycx', 'yanchixian', '0953', '640323', '107.40541,37.784222');
INSERT INTO `rg_region` VALUES ('28959', '28931', '3', '同心县', 'txx', 'tongxinxian', '0953', '640324', '105.914764,36.9829');
INSERT INTO `rg_region` VALUES ('28971', '28931', '3', '利通区', 'ltq', 'litongqu', '0953', '640302', '106.199419,37.985967');
INSERT INTO `rg_region` VALUES ('28987', '28814', '2', '中卫市', 'zws', 'zhongweishi', '1953', '640500', '105.189568,37.514951');
INSERT INTO `rg_region` VALUES ('28988', '28987', '3', '沙坡头区', 'sptq', 'shapotouqu', '1953', '640502', '105.190536,37.514564');
INSERT INTO `rg_region` VALUES ('29003', '28987', '3', '海原县', 'hyx', 'haiyuanxian', '1953', '640522', '105.647323,36.562007');
INSERT INTO `rg_region` VALUES ('29025', '28987', '3', '中宁县', 'znx', 'zhongningxian', '1953', '640521', '105.675784,37.489736');
INSERT INTO `rg_region` VALUES ('29039', '28814', '2', '银川市', 'ycs', 'yinchuanshi', '0951', '640100', '106.278179,38.46637');
INSERT INTO `rg_region` VALUES ('29040', '29039', '3', '兴庆区', 'xqq', 'xingqingqu', '0951', '640104', '106.278393,38.46747');
INSERT INTO `rg_region` VALUES ('29057', '29039', '3', '永宁县', 'ynx', 'yongningxian', '0951', '640121', '106.253781,38.28043');
INSERT INTO `rg_region` VALUES ('29066', '29039', '3', '贺兰县', 'hlx', 'helanxian', '0951', '640122', '106.345904,38.554563');
INSERT INTO `rg_region` VALUES ('29076', '29039', '3', '金凤区', 'jfq', 'jinfengqu', '0951', '640106', '106.228486,38.477353');
INSERT INTO `rg_region` VALUES ('29084', '29039', '3', '西夏区', 'xxq', 'xixiaqu', '0951', '640105', '106.132116,38.492424');
INSERT INTO `rg_region` VALUES ('29093', '29039', '3', '灵武市', 'lws', 'lingwushi', '0951', '640181', '106.334701,38.094058');
INSERT INTO `rg_region` VALUES ('29105', '0', '1', '江西省', 'jxs', 'jiangxisheng', '', '360000', '115.892151,28.676493');
INSERT INTO `rg_region` VALUES ('29106', '29105', '2', '九江市', 'jjs', 'jiujiangshi', '0792', '360400', '115.992811,29.712034');
INSERT INTO `rg_region` VALUES ('29107', '29106', '3', '都昌县', 'dcx', 'duchangxian', '0792', '360428', '116.205114,29.275105');
INSERT INTO `rg_region` VALUES ('29134', '29106', '3', '瑞昌市', 'rcs', 'ruichangshi', '0792', '360481', '115.669081,29.676599');
INSERT INTO `rg_region` VALUES ('29156', '29106', '3', '彭泽县', 'pzx', 'pengzexian', '0792', '360430', '116.55584,29.898865');
INSERT INTO `rg_region` VALUES ('29179', '29106', '3', '湖口县', 'hkx', 'hukouxian', '0792', '360429', '116.244313,29.7263');
INSERT INTO `rg_region` VALUES ('29194', '29106', '3', '柴桑区', 'csq', 'chaisangqu', '0792', '360404', '115.892977,29.610264');
INSERT INTO `rg_region` VALUES ('29211', '29106', '3', '武宁县', 'wnx', 'wuningxian', '0792', '360423', '115.105646,29.260182');
INSERT INTO `rg_region` VALUES ('29233', '29106', '3', '修水县', 'xsx', 'xiushuixian', '0792', '360424', '114.573428,29.032729');
INSERT INTO `rg_region` VALUES ('29270', '29106', '3', '濂溪区', 'lxq', 'lianxiqu', '0792', '360402', '115.99012,29.676175');
INSERT INTO `rg_region` VALUES ('29283', '29106', '3', '庐山市', 'lss', 'lushanshi', '0792', '360483', '116.043743,29.456169');
INSERT INTO `rg_region` VALUES ('29299', '29106', '3', '浔阳区', 'xyq', 'xunyangqu', '0792', '360403', '115.995947,29.72465');
INSERT INTO `rg_region` VALUES ('29308', '29106', '3', '德安县', 'dax', 'deanxian', '0792', '360426', '115.762611,29.327474');
INSERT INTO `rg_region` VALUES ('29324', '29106', '3', '永修县', 'yxx', 'yongxiuxian', '0792', '360425', '115.809055,29.018212');
INSERT INTO `rg_region` VALUES ('29345', '29106', '3', '共青城市', 'gqcs', 'gongqingchengshi', '0792', '360482', '115.805712,29.247884');
INSERT INTO `rg_region` VALUES ('29352', '29105', '2', '新余市', 'xys', 'xinyushi', '0790', '360500', '114.930835,27.810834');
INSERT INTO `rg_region` VALUES ('29353', '29352', '3', '渝水区', 'ysq', 'yushuiqu', '0790', '360502', '114.923923,27.819171');
INSERT INTO `rg_region` VALUES ('29375', '29352', '3', '分宜县', 'fyx', 'fenyixian', '0790', '360521', '114.675262,27.811301');
INSERT INTO `rg_region` VALUES ('29394', '29105', '2', '抚州市', 'fzs', 'fuzhoushi', '0794', '361000', '116.358351,27.98385');
INSERT INTO `rg_region` VALUES ('29395', '29394', '3', '东乡区', 'dxq', 'dongxiangqu', '0794', '361003', '116.605341,28.2325');
INSERT INTO `rg_region` VALUES ('29416', '29394', '3', '资溪县', 'zxx', 'zixixian', '0794', '361028', '117.066095,27.70653');
INSERT INTO `rg_region` VALUES ('29424', '29394', '3', '临川区', 'lcq', 'linchuanqu', '0794', '361002', '116.361404,27.981919');
INSERT INTO `rg_region` VALUES ('29462', '29394', '3', '南城县', 'ncx', 'nanchengxian', '0794', '361021', '116.63945,27.55531');
INSERT INTO `rg_region` VALUES ('29476', '29394', '3', '崇仁县', 'crx', 'chongrenxian', '0794', '361024', '116.059109,27.760907');
INSERT INTO `rg_region` VALUES ('29492', '29394', '3', '宜黄县', 'yhx', 'yihuangxian', '0794', '361026', '116.223023,27.546512');
INSERT INTO `rg_region` VALUES ('29508', '29394', '3', '乐安县', 'lax', 'leanxian', '0794', '361025', '115.838432,27.420101');
INSERT INTO `rg_region` VALUES ('29525', '29394', '3', '黎川县', 'lcx', 'lichuanxian', '0794', '361022', '116.91457,27.292561');
INSERT INTO `rg_region` VALUES ('29543', '29394', '3', '金溪县', 'jxx', 'jinxixian', '0794', '361027', '116.778751,27.907387');
INSERT INTO `rg_region` VALUES ('29558', '29394', '3', '广昌县', 'gcx', 'guangchangxian', '0794', '361030', '116.327291,26.838426');
INSERT INTO `rg_region` VALUES ('29572', '29394', '3', '南丰县', 'nfx', 'nanfengxian', '0794', '361023', '116.532994,27.210132');
INSERT INTO `rg_region` VALUES ('29587', '29105', '2', '鹰潭市', 'yts', 'yingtanshi', '0701', '360600', '117.033838,28.238638');
INSERT INTO `rg_region` VALUES ('29588', '29587', '3', '贵溪市', 'gxs', 'guixishi', '0701', '360681', '117.212103,28.283693');
INSERT INTO `rg_region` VALUES ('29622', '29587', '3', '余江区', 'yjq', 'yujiangqu', '0701', '360603', '116.822763,28.206177');
INSERT INTO `rg_region` VALUES ('29644', '29587', '3', '月湖区', 'yhq', 'yuehuqu', '0701', '360602', '117.034112,28.239076');
INSERT INTO `rg_region` VALUES ('29653', '29105', '2', '赣州市', 'gzs', 'ganzhoushi', '0797', '360700', '114.940278,25.85097');
INSERT INTO `rg_region` VALUES ('29654', '29653', '3', '宁都县', 'ndx', 'ningduxian', '0797', '360730', '116.018782,26.472054');
INSERT INTO `rg_region` VALUES ('29680', '29653', '3', '瑞金市', 'rjs', 'ruijinshi', '0797', '360781', '116.034854,25.875278');
INSERT INTO `rg_region` VALUES ('29699', '29653', '3', '于都县', 'ydx', 'yuduxian', '0797', '360731', '115.411198,25.955033');
INSERT INTO `rg_region` VALUES ('29724', '29653', '3', '石城县', 'scx', 'shichengxian', '0797', '360735', '116.342249,26.326582');
INSERT INTO `rg_region` VALUES ('29735', '29653', '3', '兴国县', 'xgx', 'xingguoxian', '0797', '360732', '115.351896,26.330489');
INSERT INTO `rg_region` VALUES ('29762', '29653', '3', '上犹县', 'syx', 'shangyouxian', '0797', '360724', '114.540537,25.794284');
INSERT INTO `rg_region` VALUES ('29778', '29653', '3', '信丰县', 'xfx', 'xinfengxian', '0797', '360722', '114.930893,25.38023');
INSERT INTO `rg_region` VALUES ('29796', '29653', '3', '全南县', 'qnx', 'quannanxian', '0797', '360729', '114.531589,24.742651');
INSERT INTO `rg_region` VALUES ('29807', '29653', '3', '龙南县', 'lnx', 'longnanxian', '0797', '360727', '114.792657,24.90476');
INSERT INTO `rg_region` VALUES ('29824', '29653', '3', '崇义县', 'cyx', 'chongyixian', '0797', '360725', '114.307348,25.687911');
INSERT INTO `rg_region` VALUES ('29842', '29653', '3', '寻乌县', 'xwx', 'xunwuxian', '0797', '360734', '115.651399,24.954136');
INSERT INTO `rg_region` VALUES ('29858', '29653', '3', '安远县', 'ayx', 'anyuanxian', '0797', '360726', '115.392328,25.134591');
INSERT INTO `rg_region` VALUES ('29878', '29653', '3', '大余县', 'dyx', 'dayuxian', '0797', '360723', '114.362243,25.395937');
INSERT INTO `rg_region` VALUES ('29891', '29653', '3', '会昌县', 'hcx', 'huichangxian', '0797', '360733', '115.791158,25.599125');
INSERT INTO `rg_region` VALUES ('29912', '29653', '3', '赣县区', 'gxq', 'ganxianqu', '0797', '360704', '115.018461,25.865432');
INSERT INTO `rg_region` VALUES ('29933', '29653', '3', '定南县', 'dnx', 'dingnanxian', '0797', '360728', '115.03267,24.774277');
INSERT INTO `rg_region` VALUES ('29942', '29653', '3', '章贡区', 'zgq', 'zhanggongqu', '0797', '360702', '114.93872,25.851367');
INSERT INTO `rg_region` VALUES ('29959', '29653', '3', '南康区', 'nkq', 'nankangqu', '0797', '360703', '114.756933,25.661721');
INSERT INTO `rg_region` VALUES ('29981', '29105', '2', '南昌市', 'ncs', 'nanchangshi', '0791', '360100', '115.892151,28.676493');
INSERT INTO `rg_region` VALUES ('29982', '29981', '3', '安义县', 'ayx', 'anyixian', '0791', '360123', '115.553109,28.841334');
INSERT INTO `rg_region` VALUES ('29996', '29981', '3', '进贤县', 'jxx', 'jinxianxian', '0791', '360124', '116.267671,28.365681');
INSERT INTO `rg_region` VALUES ('30019', '29981', '3', '青云谱区', 'qypq', 'qingyunpuqu', '0791', '360104', '115.907292,28.635724');
INSERT INTO `rg_region` VALUES ('30027', '29981', '3', '南昌县', 'ncx', 'nanchangxian', '0791', '360121', '115.942465,28.543781');
INSERT INTO `rg_region` VALUES ('30050', '29981', '3', '新建区', 'xjq', 'xinjianqu', '0791', '360112', '115.820806,28.690788');
INSERT INTO `rg_region` VALUES ('30079', '29981', '3', '湾里区', 'wlq', 'wanliqu', '0791', '360105', '115.731324,28.714803');
INSERT INTO `rg_region` VALUES ('30086', '29981', '3', '西湖区', 'xhq', 'xihuqu', '0791', '360103', '115.91065,28.662901');
INSERT INTO `rg_region` VALUES ('30099', '29981', '3', '东湖区', 'dhq', 'donghuqu', '0791', '360102', '115.889675,28.682988');
INSERT INTO `rg_region` VALUES ('30113', '29981', '3', '青山湖区', 'qshq', 'qingshanhuqu', '0791', '360111', '115.949044,28.689292');
INSERT INTO `rg_region` VALUES ('30128', '29105', '2', '吉安市', 'jas', 'jianshi', '0796', '360800', '114.986373,27.111699');
INSERT INTO `rg_region` VALUES ('30129', '30128', '3', '峡江县', 'xjx', 'xiajiangxian', '0796', '360823', '115.319331,27.580862');
INSERT INTO `rg_region` VALUES ('30142', '30128', '3', '吉安县', 'jax', 'jianxian', '0796', '360821', '114.905117,27.040042');
INSERT INTO `rg_region` VALUES ('30165', '30128', '3', '吉水县', 'jsx', 'jishuixian', '0796', '360822', '115.134569,27.213445');
INSERT INTO `rg_region` VALUES ('30185', '30128', '3', '永丰县', 'yfx', 'yongfengxian', '0796', '360825', '115.435559,27.321087');
INSERT INTO `rg_region` VALUES ('30210', '30128', '3', '吉州区', 'jzq', 'jizhouqu', '0796', '360802', '114.987331,27.112367');
INSERT INTO `rg_region` VALUES ('30223', '30128', '3', '永新县', 'yxx', 'yongxinxian', '0796', '360830', '114.242534,26.944721');
INSERT INTO `rg_region` VALUES ('30249', '30128', '3', '青原区', 'qyq', 'qingyuanqu', '0796', '360803', '115.016306,27.105879');
INSERT INTO `rg_region` VALUES ('30261', '30128', '3', '泰和县', 'thx', 'taihexian', '0796', '360826', '114.901393,26.790164');
INSERT INTO `rg_region` VALUES ('30290', '30128', '3', '井冈山市', 'jgss', 'jinggangshanshi', '0796', '360881', '114.284421,26.745919');
INSERT INTO `rg_region` VALUES ('30314', '30128', '3', '万安县', 'wax', 'wananxian', '0796', '360828', '114.784694,26.462085');
INSERT INTO `rg_region` VALUES ('30333', '30128', '3', '遂川县', 'scx', 'suichuanxian', '0796', '360827', '114.51689,26.323705');
INSERT INTO `rg_region` VALUES ('30358', '30128', '3', '新干县', 'xgx', 'xinganxian', '0796', '360824', '115.399294,27.755758');
INSERT INTO `rg_region` VALUES ('30376', '30128', '3', '安福县', 'afx', 'anfuxian', '0796', '360829', '114.61384,27.382746');
INSERT INTO `rg_region` VALUES ('30397', '29105', '2', '萍乡市', 'pxs', 'pingxiangshi', '0799', '360300', '113.852186,27.622946');
INSERT INTO `rg_region` VALUES ('30398', '30397', '3', '湘东区', 'xdq', 'xiangdongqu', '0799', '360313', '113.7456,27.639319');
INSERT INTO `rg_region` VALUES ('30410', '30397', '3', '安源区', 'ayq', 'anyuanqu', '0799', '360302', '113.855044,27.625826');
INSERT INTO `rg_region` VALUES ('30423', '30397', '3', '上栗县', 'slx', 'shanglixian', '0799', '360322', '113.800525,27.877041');
INSERT INTO `rg_region` VALUES ('30434', '30397', '3', '莲花县', 'lhx', 'lianhuaxian', '0799', '360321', '113.955582,27.127807');
INSERT INTO `rg_region` VALUES ('30448', '30397', '3', '芦溪县', 'lxx', 'luxixian', '0799', '360323', '114.041206,27.633633');
INSERT INTO `rg_region` VALUES ('30459', '29105', '2', '宜春市', 'ycs', 'yichunshi', '0795', '360900', '114.391136,27.8043');
INSERT INTO `rg_region` VALUES ('30460', '30459', '3', '靖安县', 'jax', 'jinganxian', '0795', '360925', '115.361744,28.86054');
INSERT INTO `rg_region` VALUES ('30473', '30459', '3', '奉新县', 'fxx', 'fengxinxian', '0795', '360921', '115.389899,28.700672');
INSERT INTO `rg_region` VALUES ('30493', '30459', '3', '宜丰县', 'yfx', 'yifengxian', '0795', '360924', '114.787381,28.388289');
INSERT INTO `rg_region` VALUES ('30511', '30459', '3', '高安市', 'gas', 'gaoanshi', '0795', '360983', '115.381527,28.420951');
INSERT INTO `rg_region` VALUES ('30542', '30459', '3', '上高县', 'sgx', 'shanggaoxian', '0795', '360923', '114.932653,28.234789');
INSERT INTO `rg_region` VALUES ('30560', '30459', '3', '丰城市', 'fcs', 'fengchengshi', '0795', '360981', '115.786005,28.191584');
INSERT INTO `rg_region` VALUES ('30596', '30459', '3', '万载县', 'wzx', 'wanzaixian', '0795', '360922', '114.449012,28.104528');
INSERT INTO `rg_region` VALUES ('30615', '30459', '3', '铜鼓县', 'tgx', 'tongguxian', '0795', '360926', '114.37014,28.520956');
INSERT INTO `rg_region` VALUES ('30629', '30459', '3', '袁州区', 'yzq', 'yuanzhouqu', '0795', '360902', '114.387379,27.800117');
INSERT INTO `rg_region` VALUES ('30669', '30459', '3', '樟树市', 'zss', 'zhangshushi', '0795', '360982', '115.543388,28.055898');
INSERT INTO `rg_region` VALUES ('30691', '29105', '2', '景德镇市', 'jdzs', 'jingdezhenshi', '0798', '360200', '117.214664,29.29256');
INSERT INTO `rg_region` VALUES ('30692', '30691', '3', '珠山区', 'zsq', 'zhushanqu', '0798', '360203', '117.214814,29.292812');
INSERT INTO `rg_region` VALUES ('30704', '30691', '3', '浮梁县', 'flx', 'fuliangxian', '0798', '360222', '117.217611,29.352251');
INSERT INTO `rg_region` VALUES ('30724', '30691', '3', '昌江区', 'cjq', 'changjiangqu', '0798', '360202', '117.195023,29.288465');
INSERT INTO `rg_region` VALUES ('30735', '30691', '3', '乐平市', 'lps', 'lepingshi', '0798', '360281', '117.129376,28.967361');
INSERT INTO `rg_region` VALUES ('30756', '29105', '2', '上饶市', 'srs', 'shangraoshi', '0793', '361100', '117.971185,28.44442');
INSERT INTO `rg_region` VALUES ('30757', '30756', '3', '铅山县', 'qsx', 'qianshanxian', '0793', '361124', '117.711906,28.310892');
INSERT INTO `rg_region` VALUES ('30778', '30756', '3', '德兴市', 'dxs', 'dexingshi', '0793', '361181', '117.578732,28.945034');
INSERT INTO `rg_region` VALUES ('30794', '30756', '3', '婺源县', 'wyx', 'wuyuanxian', '0793', '361130', '117.86219,29.254015');
INSERT INTO `rg_region` VALUES ('30812', '30756', '3', '横峰县', 'hfx', 'hengfengxian', '0793', '361125', '117.608247,28.415103');
INSERT INTO `rg_region` VALUES ('30827', '30756', '3', '上饶县', 'srx', 'shangraoxian', '0793', '361121', '117.90612,28.453897');
INSERT INTO `rg_region` VALUES ('30852', '30756', '3', '余干县', 'ygx', 'yuganxian', '0793', '361127', '116.691072,28.69173');
INSERT INTO `rg_region` VALUES ('30880', '30756', '3', '信州区', 'xzq', 'xinzhouqu', '0793', '361102', '117.970522,28.445378');
INSERT INTO `rg_region` VALUES ('30890', '30756', '3', '弋阳县', 'yyx', 'yiyangxian', '0793', '361126', '117.435002,28.402391');
INSERT INTO `rg_region` VALUES ('30907', '30756', '3', '广丰区', 'gfq', 'guangfengqu', '0793', '361103', '118.189852,28.440285');
INSERT INTO `rg_region` VALUES ('30932', '30756', '3', '玉山县', 'ysx', 'yushanxian', '0793', '361123', '118.244408,28.673479');
INSERT INTO `rg_region` VALUES ('30951', '30756', '3', '万年县', 'wnx', 'wannianxian', '0793', '361129', '117.07015,28.692589');
INSERT INTO `rg_region` VALUES ('30964', '30756', '3', '鄱阳县', 'pyx', 'poyangxian', '0793', '361128', '116.673748,28.993374');
INSERT INTO `rg_region` VALUES ('30996', '0', '1', '浙江省', 'zjs', 'zhejiangsheng', '', '330000', '120.153576,30.287459');
INSERT INTO `rg_region` VALUES ('30997', '30996', '2', '温州市', 'wzs', 'wenzhoushi', '0577', '330300', '120.672111,28.000575');
INSERT INTO `rg_region` VALUES ('30998', '30997', '3', '永嘉县', 'yjx', 'yongjiaxian', '0577', '330324', '120.690968,28.153886');
INSERT INTO `rg_region` VALUES ('31024', '30997', '3', '平阳县', 'pyx', 'pingyangxian', '0577', '330326', '120.564387,27.6693');
INSERT INTO `rg_region` VALUES ('31041', '30997', '3', '泰顺县', 'tsx', 'taishunxian', '0577', '330329', '119.71624,27.557309');
INSERT INTO `rg_region` VALUES ('31062', '30997', '3', '苍南县', 'cnx', 'cangnanxian', '0577', '330327', '120.406256,27.507743');
INSERT INTO `rg_region` VALUES ('31076', '30997', '3', '洞头区', 'dtq', 'dongtouqu', '0577', '330305', '121.156181,27.836057');
INSERT INTO `rg_region` VALUES ('31084', '30997', '3', '瑞安市', 'ras', 'ruianshi', '0577', '330381', '120.646171,27.779321');
INSERT INTO `rg_region` VALUES ('31101', '30997', '3', '乐清市', 'lqs', 'leqingshi', '0577', '330382', '120.967147,28.116083');
INSERT INTO `rg_region` VALUES ('31121', '30997', '3', '文成县', 'wcx', 'wenchengxian', '0577', '330328', '120.09245,27.789133');
INSERT INTO `rg_region` VALUES ('31133', '30997', '3', '瓯海区', 'ohq', 'ouhaiqu', '0577', '330304', '120.637145,28.006444');
INSERT INTO `rg_region` VALUES ('31147', '30997', '3', '鹿城区', 'lcq', 'luchengqu', '0577', '330302', '120.674231,28.003352');
INSERT INTO `rg_region` VALUES ('31156', '30997', '3', '龙湾区', 'lwq', 'longwanqu', '0577', '330303', '120.763469,27.970254');
INSERT INTO `rg_region` VALUES ('31167', '30996', '2', '宁波市', 'nbs', 'ningboshi', '0574', '330200', '121.549792,29.868388');
INSERT INTO `rg_region` VALUES ('31168', '31167', '3', '北仑区', 'blq', 'beilunqu', '0574', '330206', '121.831303,29.90944');
INSERT INTO `rg_region` VALUES ('31180', '31167', '3', '象山县', 'xsx', 'xiangshanxian', '0574', '330225', '121.877091,29.470206');
INSERT INTO `rg_region` VALUES ('31199', '31167', '3', '镇海区', 'zhq', 'zhenhaiqu', '0574', '330211', '121.713162,29.952107');
INSERT INTO `rg_region` VALUES ('31206', '31167', '3', '江北区', 'jbq', 'jiangbeiqu', '0574', '330205', '121.559282,29.888361');
INSERT INTO `rg_region` VALUES ('31215', '31167', '3', '奉化区', 'fhq', 'fenghuaqu', '0574', '330213', '121.41089,29.662348');
INSERT INTO `rg_region` VALUES ('31228', '31167', '3', '宁海县', 'nhx', 'ninghaixian', '0574', '330226', '121.432606,29.299836');
INSERT INTO `rg_region` VALUES ('31247', '31167', '3', '余姚市', 'yys', 'yuyaoshi', '0574', '330281', '121.156294,30.045404');
INSERT INTO `rg_region` VALUES ('31269', '31167', '3', '鄞州区', 'yzq', 'yinzhouqu', '0574', '330212', '121.558436,29.831662');
INSERT INTO `rg_region` VALUES ('31295', '31167', '3', '海曙区', 'hsq', 'haishuqu', '0574', '330203', '121.539698,29.874452');
INSERT INTO `rg_region` VALUES ('31313', '31167', '3', '慈溪市', 'cxs', 'cixishi', '0574', '330282', '121.248052,30.177142');
INSERT INTO `rg_region` VALUES ('31336', '30996', '2', '舟山市', 'zss', 'zhoushanshi', '0580', '330900', '122.106863,30.016028');
INSERT INTO `rg_region` VALUES ('31337', '31336', '3', '嵊泗县', 'ssx', 'shengsixian', '0580', '330922', '122.457809,30.727166');
INSERT INTO `rg_region` VALUES ('31345', '31336', '3', '普陀区', 'ptq', 'putuoqu', '0580', '330903', '122.301953,29.945614');
INSERT INTO `rg_region` VALUES ('31355', '31336', '3', '岱山县', 'dsx', 'daishanxian', '0580', '330921', '122.201132,30.242865');
INSERT INTO `rg_region` VALUES ('31363', '31336', '3', '定海区', 'dhq', 'dinghaiqu', '0580', '330902', '122.108496,30.016423');
INSERT INTO `rg_region` VALUES ('31376', '30996', '2', '嘉兴市', 'jxs', 'jiaxingshi', '0573', '330400', '120.750865,30.762653');
INSERT INTO `rg_region` VALUES ('31377', '31376', '3', '平湖市', 'phs', 'pinghushi', '0573', '330482', '121.014666,30.698921');
INSERT INTO `rg_region` VALUES ('31387', '31376', '3', '海宁市', 'hns', 'hainingshi', '0573', '330481', '120.688821,30.525544');
INSERT INTO `rg_region` VALUES ('31400', '31376', '3', '南湖区', 'nhq', 'nanhuqu', '0573', '330402', '120.749953,30.764652');
INSERT INTO `rg_region` VALUES ('31414', '31376', '3', '秀洲区', 'xzq', 'xiuzhouqu', '0573', '330411', '120.720431,30.763323');
INSERT INTO `rg_region` VALUES ('31424', '31376', '3', '嘉善县', 'jsx', 'jiashanxian', '0573', '330421', '120.921871,30.841352');
INSERT INTO `rg_region` VALUES ('31434', '31376', '3', '海盐县', 'hyx', 'haiyanxian', '0573', '330424', '120.942017,30.522223');
INSERT INTO `rg_region` VALUES ('31444', '31376', '3', '桐乡市', 'txs', 'tongxiangshi', '0573', '330483', '120.551085,30.629065');
INSERT INTO `rg_region` VALUES ('31457', '30996', '2', '台州市', 'tzs', 'taizhoushi', '0576', '331000', '121.428599,28.661378');
INSERT INTO `rg_region` VALUES ('31458', '31457', '3', '天台县', 'ttx', 'tiantaixian', '0576', '331023', '121.031227,29.141126');
INSERT INTO `rg_region` VALUES ('31474', '31457', '3', '温岭市', 'wls', 'wenlingshi', '0576', '331081', '121.373611,28.368781');
INSERT INTO `rg_region` VALUES ('31492', '31457', '3', '三门县', 'smx', 'sanmenxian', '0576', '331022', '121.376429,29.118955');
INSERT INTO `rg_region` VALUES ('31502', '31457', '3', '椒江区', 'jjq', 'jiaojiangqu', '0576', '331002', '121.431049,28.67615');
INSERT INTO `rg_region` VALUES ('31514', '31457', '3', '玉环市', 'yhs', 'yuhuanshi', '0576', '331083', '121.232337,28.12842');
INSERT INTO `rg_region` VALUES ('31526', '31457', '3', '临海市', 'lhs', 'linhaishi', '0576', '331082', '121.131229,28.845441');
INSERT INTO `rg_region` VALUES ('31546', '31457', '3', '路桥区', 'lqq', 'luqiaoqu', '0576', '331004', '121.37292,28.581799');
INSERT INTO `rg_region` VALUES ('31559', '31457', '3', '仙居县', 'xjx', 'xianjuxian', '0576', '331024', '120.735074,28.849213');
INSERT INTO `rg_region` VALUES ('31580', '31457', '3', '黄岩区', 'hyq', 'huangyanqu', '0576', '331003', '121.262138,28.64488');
INSERT INTO `rg_region` VALUES ('31600', '30996', '2', '丽水市', 'lss', 'lishuishi', '0578', '331100', '119.921786,28.451993');
INSERT INTO `rg_region` VALUES ('31601', '31600', '3', '莲都区', 'ldq', 'lianduqu', '0578', '331102', '119.922293,28.451103');
INSERT INTO `rg_region` VALUES ('31618', '31600', '3', '松阳县', 'syx', 'songyangxian', '0578', '331124', '119.485292,28.449937');
INSERT INTO `rg_region` VALUES ('31638', '31600', '3', '龙泉市', 'lqs', 'longquanshi', '0578', '331181', '119.132319,28.069177');
INSERT INTO `rg_region` VALUES ('31658', '31600', '3', '云和县', 'yhx', 'yunhexian', '0578', '331125', '119.569458,28.111077');
INSERT INTO `rg_region` VALUES ('31669', '31600', '3', '遂昌县', 'scx', 'suichangxian', '0578', '331123', '119.27589,28.5924');
INSERT INTO `rg_region` VALUES ('31690', '31600', '3', '景宁畲族自治县', 'jnszzzx', 'jingningshezuzizhixian', '0578', '331127', '119.634669,27.977247');
INSERT INTO `rg_region` VALUES ('31712', '31600', '3', '青田县', 'qtx', 'qingtianxian', '0578', '331121', '120.291939,28.135247');
INSERT INTO `rg_region` VALUES ('31745', '31600', '3', '缙云县', 'jyx', 'jinyunxian', '0578', '331122', '120.078965,28.654208');
INSERT INTO `rg_region` VALUES ('31764', '31600', '3', '庆元县', 'qyx', 'qingyuanxian', '0578', '331126', '119.067233,27.618231');
INSERT INTO `rg_region` VALUES ('31784', '30996', '2', '杭州市', 'hzs', 'hangzhoushi', '0571', '330100', '120.153576,30.287459');
INSERT INTO `rg_region` VALUES ('31785', '31784', '3', '桐庐县', 'tlx', 'tongluxian', '0571', '330122', '119.685045,29.797437');
INSERT INTO `rg_region` VALUES ('31800', '31784', '3', '上城区', 'scq', 'shangchengqu', '0571', '330102', '120.171465,30.250236');
INSERT INTO `rg_region` VALUES ('31807', '31784', '3', '建德市', 'jds', 'jiandeshi', '0571', '330182', '119.279089,29.472284');
INSERT INTO `rg_region` VALUES ('31824', '31784', '3', '西湖区', 'xhq', 'xihuqu', '0571', '330106', '120.147376,30.272934');
INSERT INTO `rg_region` VALUES ('31837', '31784', '3', '富阳区', 'fyq', 'fuyangqu', '0571', '330111', '119.949869,30.049871');
INSERT INTO `rg_region` VALUES ('31862', '31784', '3', '淳安县', 'cax', 'chunanxian', '0571', '330127', '119.044276,29.604177');
INSERT INTO `rg_region` VALUES ('31886', '31784', '3', '萧山区', 'xsq', 'xiaoshanqu', '0571', '330109', '120.27069,30.162932');
INSERT INTO `rg_region` VALUES ('31918', '31784', '3', '滨江区', 'bjq', 'binjiangqu', '0571', '330108', '120.21062,30.206615');
INSERT INTO `rg_region` VALUES ('31922', '31784', '3', '江干区', 'jgq', 'jiangganqu', '0571', '330104', '120.202633,30.266603');
INSERT INTO `rg_region` VALUES ('31933', '31784', '3', '下城区', 'xcq', 'xiachengqu', '0571', '330103', '120.172763,30.276271');
INSERT INTO `rg_region` VALUES ('31942', '31784', '3', '临安区', 'laq', 'linanqu', '0571', '330112', '119.715101,30.231153');
INSERT INTO `rg_region` VALUES ('31961', '31784', '3', '余杭区', 'yhq', 'yuhangqu', '0571', '330110', '120.301737,30.421187');
INSERT INTO `rg_region` VALUES ('31982', '31784', '3', '拱墅区', 'gsq', 'gongshuqu', '0571', '330105', '120.150053,30.314697');
INSERT INTO `rg_region` VALUES ('31993', '30996', '2', '绍兴市', 'sxs', 'shaoxingshi', '0575', '330600', '120.582112,29.997117');
INSERT INTO `rg_region` VALUES ('31994', '31993', '3', '嵊州市', 'szs', 'shengzhoushi', '0575', '330683', '120.82888,29.586606');
INSERT INTO `rg_region` VALUES ('32017', '31993', '3', '上虞区', 'syq', 'shangyuqu', '0575', '330604', '120.874185,30.016769');
INSERT INTO `rg_region` VALUES ('32039', '31993', '3', '越城区', 'ycq', 'yuechengqu', '0575', '330602', '120.585315,29.996993');
INSERT INTO `rg_region` VALUES ('32057', '31993', '3', '柯桥区', 'kqq', 'keqiaoqu', '0575', '330603', '120.476075,30.078038');
INSERT INTO `rg_region` VALUES ('32074', '31993', '3', '诸暨市', 'zjs', 'zhujishi', '0575', '330681', '120.244326,29.713662');
INSERT INTO `rg_region` VALUES ('32102', '31993', '3', '新昌县', 'xcx', 'xinchangxian', '0575', '330624', '120.905665,29.501205');
INSERT INTO `rg_region` VALUES ('32119', '30996', '2', '湖州市', 'hzs', 'huzhoushi', '0572', '330500', '120.102398,30.867198');
INSERT INTO `rg_region` VALUES ('32120', '32119', '3', '德清县', 'dqx', 'deqingxian', '0572', '330521', '119.967662,30.534927');
INSERT INTO `rg_region` VALUES ('32131', '32119', '3', '安吉县', 'ajx', 'anjixian', '0572', '330523', '119.687891,30.631974');
INSERT INTO `rg_region` VALUES ('32147', '32119', '3', '长兴县', 'cxx', 'changxingxian', '0572', '330522', '119.910122,31.00475');
INSERT INTO `rg_region` VALUES ('32162', '32119', '3', '吴兴区', 'wxq', 'wuxingqu', '0572', '330502', '120.101416,30.867252');
INSERT INTO `rg_region` VALUES ('32182', '32119', '3', '南浔区', 'nxq', 'nanxunqu', '0572', '330503', '120.417195,30.872742');
INSERT INTO `rg_region` VALUES ('32192', '30996', '2', '衢州市', 'qzs', 'quzhoushi', '0570', '330800', '118.87263,28.941708');
INSERT INTO `rg_region` VALUES ('32193', '32192', '3', '开化县', 'khx', 'kaihuaxian', '0570', '330824', '118.414435,29.136503');
INSERT INTO `rg_region` VALUES ('32212', '32192', '3', '柯城区', 'kcq', 'kechengqu', '0570', '330802', '118.873041,28.944539');
INSERT INTO `rg_region` VALUES ('32230', '32192', '3', '衢江区', 'qjq', 'qujiangqu', '0570', '330803', '118.957683,28.973195');
INSERT INTO `rg_region` VALUES ('32251', '32192', '3', '常山县', 'csx', 'changshanxian', '0570', '330822', '118.521654,28.900039');
INSERT INTO `rg_region` VALUES ('32266', '32192', '3', '江山市', 'jss', 'jiangshanshi', '0570', '330881', '118.627879,28.734674');
INSERT INTO `rg_region` VALUES ('32287', '32192', '3', '龙游县', 'lyx', 'longyouxian', '0570', '330825', '119.172525,29.031364');
INSERT INTO `rg_region` VALUES ('32303', '30996', '2', '金华市', 'jhs', 'jinhuashi', '0579', '330700', '119.649506,29.089524');
INSERT INTO `rg_region` VALUES ('32304', '32303', '3', '浦江县', 'pjx', 'pujiangxian', '0579', '330726', '119.893363,29.451254');
INSERT INTO `rg_region` VALUES ('32320', '32303', '3', '兰溪市', 'lxs', 'lanxishi', '0579', '330781', '119.460521,29.210065');
INSERT INTO `rg_region` VALUES ('32337', '32303', '3', '东阳市', 'dys', 'dongyangshi', '0579', '330783', '120.23334,29.262546');
INSERT INTO `rg_region` VALUES ('32356', '32303', '3', '永康市', 'yks', 'yongkangshi', '0579', '330784', '120.036328,28.895293');
INSERT INTO `rg_region` VALUES ('32371', '32303', '3', '磐安县', 'pax', 'pananxian', '0579', '330727', '120.44513,29.052627');
INSERT INTO `rg_region` VALUES ('32386', '32303', '3', '武义县', 'wyx', 'wuyixian', '0579', '330723', '119.819159,28.896563');
INSERT INTO `rg_region` VALUES ('32405', '32303', '3', '金东区', 'jdq', 'jindongqu', '0579', '330703', '119.681264,29.095835');
INSERT INTO `rg_region` VALUES ('32417', '32303', '3', '义乌市', 'yws', 'yiwushi', '0579', '330782', '120.074911,29.306863');
INSERT INTO `rg_region` VALUES ('32431', '32303', '3', '婺城区', 'wcq', 'wuchengqu', '0579', '330702', '119.652579,29.082607');
INSERT INTO `rg_region` VALUES ('32459', '0', '1', '河北省', 'hbs', 'hebeisheng', '', '130000', '114.502461,38.045474');
INSERT INTO `rg_region` VALUES ('32460', '32459', '2', '承德市', 'cds', 'chengdeshi', '0314', '130800', '117.939152,40.976204');
INSERT INTO `rg_region` VALUES ('32461', '32460', '3', '隆化县', 'lhx', 'longhuaxian', '0314', '130825', '117.736343,41.316667');
INSERT INTO `rg_region` VALUES ('32487', '32460', '3', '丰宁满族自治县', 'fnmzzzx', 'fengningmanzuzizhixian', '0314', '130826', '116.65121,41.209903');
INSERT INTO `rg_region` VALUES ('32514', '32460', '3', '鹰手营子矿区', 'ysyzkq', 'yingshouyingzikuangqu', '0314', '130804', '117.661154,40.546956');
INSERT INTO `rg_region` VALUES ('32520', '32460', '3', '围场满族蒙古族自治县', 'wcmzmgzzzx', 'weichangmanzumengguzuzizhixian', '0314', '130828', '117.764086,41.949404');
INSERT INTO `rg_region` VALUES ('32560', '32460', '3', '宽城满族自治县', 'kcmzzzx', 'kuanchengmanzuzizhixian', '0314', '130827', '118.488642,40.607981');
INSERT INTO `rg_region` VALUES ('32579', '32460', '3', '兴隆县', 'xlx', 'xinglongxian', '0314', '130822', '117.507098,40.418525');
INSERT INTO `rg_region` VALUES ('32600', '32460', '3', '平泉市', 'pqs', 'pingquanshi', '0314', '130881', '118.690238,41.00561');
INSERT INTO `rg_region` VALUES ('32620', '32460', '3', '滦平县', 'lpx', 'luanpingxian', '0314', '130824', '117.337124,40.936644');
INSERT INTO `rg_region` VALUES ('32642', '32460', '3', '双滦区', 'slq', 'shuangluanqu', '0314', '130803', '117.797485,40.959756');
INSERT INTO `rg_region` VALUES ('32651', '32460', '3', '双桥区', 'sqq', 'shuangqiaoqu', '0314', '130802', '117.939152,40.976204');
INSERT INTO `rg_region` VALUES ('32667', '32460', '3', '承德县', 'cdx', 'chengdexian', '0314', '130821', '118.172496,40.768637');
INSERT INTO `rg_region` VALUES ('32691', '32459', '2', '唐山市', 'tss', 'tangshanshi', '0315', '130200', '118.175393,39.635113');
INSERT INTO `rg_region` VALUES ('32692', '32691', '3', '迁安市', 'qas', 'qiananshi', '0315', '130283', '118.701933,40.012108');
INSERT INTO `rg_region` VALUES ('32712', '32691', '3', '迁西县', 'qxx', 'qianxixian', '0315', '130227', '118.305139,40.146238');
INSERT INTO `rg_region` VALUES ('32732', '32691', '3', '遵化市', 'zhs', 'zunhuashi', '0315', '130281', '117.965875,40.188616');
INSERT INTO `rg_region` VALUES ('32760', '32691', '3', '滦州市', 'lzs', 'luanzhoushi', '0315', '130284', '118.699547,39.744851');
INSERT INTO `rg_region` VALUES ('32775', '32691', '3', '曹妃甸区', 'cfdq', 'caofeidianqu', '0315', '130209', '118.446585,39.278277');
INSERT INTO `rg_region` VALUES ('32794', '32691', '3', '滦南县', 'lnx', 'luannanxian', '0315', '130224', '118.681552,39.506201');
INSERT INTO `rg_region` VALUES ('32812', '32691', '3', '乐亭县', 'ltx', 'letingxian', '0315', '130225', '118.905341,39.42813');
INSERT INTO `rg_region` VALUES ('32832', '32691', '3', '玉田县', 'ytx', 'yutianxian', '0315', '130229', '117.753665,39.887323');
INSERT INTO `rg_region` VALUES ('32853', '32691', '3', '路南区', 'lnq', 'lunanqu', '0315', '130202', '118.210821,39.615162');
INSERT INTO `rg_region` VALUES ('32866', '32691', '3', '路北区', 'lbq', 'lubeiqu', '0315', '130203', '118.174736,39.628538');
INSERT INTO `rg_region` VALUES ('32880', '32691', '3', '丰南区', 'fnq', 'fengnanqu', '0315', '130207', '118.110793,39.56303');
INSERT INTO `rg_region` VALUES ('32898', '32691', '3', '丰润区', 'frq', 'fengrunqu', '0315', '130208', '118.155779,39.831363');
INSERT INTO `rg_region` VALUES ('32925', '32691', '3', '古冶区', 'gyq', 'guyoqu', '0315', '130204', '118.45429,39.715736');
INSERT INTO `rg_region` VALUES ('32936', '32691', '3', '开平区', 'kpq', 'kaipingqu', '0315', '130205', '118.264425,39.676171');
INSERT INTO `rg_region` VALUES ('32948', '32459', '2', '廊坊市', 'lfs', 'langfangshi', '0316', '131000', '116.704441,39.523927');
INSERT INTO `rg_region` VALUES ('32949', '32948', '3', '大厂回族自治县', 'dchzzzx', 'dachanghuizuzizhixian', '0316', '131028', '116.986501,39.889266');
INSERT INTO `rg_region` VALUES ('32956', '32948', '3', '大城县', 'dcx', 'dachengxian', '0316', '131025', '116.640735,38.699215');
INSERT INTO `rg_region` VALUES ('32968', '32948', '3', '霸州市', 'bzs', 'bazhoushi', '0316', '131081', '116.392021,39.117331');
INSERT INTO `rg_region` VALUES ('32982', '32948', '3', '香河县', 'xhx', 'xianghexian', '0316', '131024', '117.007161,39.757212');
INSERT INTO `rg_region` VALUES ('32994', '32948', '3', '固安县', 'gax', 'guanxian', '0316', '131022', '116.299894,39.436468');
INSERT INTO `rg_region` VALUES ('33005', '32948', '3', '永清县', 'yqx', 'yongqingxian', '0316', '131023', '116.498089,39.319717');
INSERT INTO `rg_region` VALUES ('33018', '32948', '3', '文安县', 'wax', 'wenanxian', '0316', '131026', '116.460107,38.866801');
INSERT INTO `rg_region` VALUES ('33032', '32948', '3', '三河市', 'shs', 'sanheshi', '0316', '131082', '117.077018,39.982778');
INSERT INTO `rg_region` VALUES ('33047', '32948', '3', '广阳区', 'gyq', 'guangyangqu', '0316', '131003', '116.713708,39.521931');
INSERT INTO `rg_region` VALUES ('33059', '32948', '3', '安次区', 'acq', 'anciqu', '0316', '131002', '116.694544,39.502569');
INSERT INTO `rg_region` VALUES ('33071', '32459', '2', '秦皇岛市', 'qhds', 'qinhuangdaoshi', '0335', '130300', '119.586579,39.942531');
INSERT INTO `rg_region` VALUES ('33072', '33071', '3', '青龙满族自治县', 'qlmzzzx', 'qinglongmanzuzizhixian', '0335', '130321', '118.954555,40.406023');
INSERT INTO `rg_region` VALUES ('33098', '33071', '3', '山海关区', 'shgq', 'shanhaiguanqu', '0335', '130303', '119.753591,39.998023');
INSERT INTO `rg_region` VALUES ('33108', '33071', '3', '卢龙县', 'llx', 'lulongxian', '0335', '130324', '118.881809,39.891639');
INSERT INTO `rg_region` VALUES ('33122', '33071', '3', '海港区', 'hgq', 'haigangqu', '0335', '130302', '119.596224,39.943458');
INSERT INTO `rg_region` VALUES ('33146', '33071', '3', '北戴河区', 'bdhq', 'beidaihequ', '0335', '130304', '119.486286,39.825121');
INSERT INTO `rg_region` VALUES ('33153', '33071', '3', '抚宁区', 'fnq', 'funingqu', '0335', '130306', '119.240651,39.887053');
INSERT INTO `rg_region` VALUES ('33165', '33071', '3', '昌黎县', 'clx', 'changlixian', '0335', '130322', '119.164541,39.709729');
INSERT INTO `rg_region` VALUES ('33184', '32459', '2', '保定市', 'bds', 'baodingshi', '0312', '130600', '115.482331,38.867657');
INSERT INTO `rg_region` VALUES ('33185', '33184', '3', '阜平县', 'fpx', 'fupingxian', '0312', '130624', '114.198801,38.847276');
INSERT INTO `rg_region` VALUES ('33199', '33184', '3', '易县', 'yx', 'yixian', '0312', '130633', '115.501146,39.35297');
INSERT INTO `rg_region` VALUES ('33227', '33184', '3', '安新县', 'axx', 'anxinxian', '0312', '130632', '115.931979,38.929912');
INSERT INTO `rg_region` VALUES ('33240', '33184', '3', '容城县', 'rcx', 'rongchengxian', '0312', '130629', '115.866247,39.05282');
INSERT INTO `rg_region` VALUES ('33249', '33184', '3', '顺平县', 'spx', 'shunpingxian', '0312', '130636', '115.132749,38.845127');
INSERT INTO `rg_region` VALUES ('33260', '33184', '3', '涞源县', 'lyx', 'laiyuanxian', '0312', '130630', '114.692567,39.35755');
INSERT INTO `rg_region` VALUES ('33278', '33184', '3', '雄县', 'xx', 'xiongxian', '0312', '130638', '116.107474,38.990819');
INSERT INTO `rg_region` VALUES ('33288', '33184', '3', '徐水区', 'xsq', 'xushuiqu', '0312', '130609', '115.64941,39.020395');
INSERT INTO `rg_region` VALUES ('33303', '33184', '3', '定兴县', 'dxx', 'dingxingxian', '0312', '130626', '115.796895,39.266195');
INSERT INTO `rg_region` VALUES ('33320', '33184', '3', '望都县', 'wdx', 'wangduxian', '0312', '130631', '115.154009,38.707448');
INSERT INTO `rg_region` VALUES ('33329', '33184', '3', '高阳县', 'gyx', 'gaoyangxian', '0312', '130628', '115.778878,38.690092');
INSERT INTO `rg_region` VALUES ('33339', '33184', '3', '竞秀区', 'jxq', 'jingxiuqu', '0312', '130602', '115.470659,38.88662');
INSERT INTO `rg_region` VALUES ('33353', '33184', '3', '曲阳县', 'qyx', 'quyangxian', '0312', '130634', '114.704055,38.619992');
INSERT INTO `rg_region` VALUES ('33372', '33184', '3', '唐县', 'tx', 'tangxian', '0312', '130627', '114.981241,38.748542');
INSERT INTO `rg_region` VALUES ('33393', '33184', '3', '满城区', 'mcq', 'manchengqu', '0312', '130607', '115.32442,38.95138');
INSERT INTO `rg_region` VALUES ('33406', '33184', '3', '定州市', 'dzs', 'dingzhoushi', '0312', '130682', '114.991389,38.517602');
INSERT INTO `rg_region` VALUES ('33432', '33184', '3', '安国市', 'ags', 'anguoshi', '0312', '130683', '115.33141,38.421367');
INSERT INTO `rg_region` VALUES ('33444', '33184', '3', '莲池区', 'lcq', 'lianchiqu', '0312', '130606', '115.500934,38.865005');
INSERT INTO `rg_region` VALUES ('33462', '33184', '3', '清苑区', 'qyq', 'qingyuanqu', '0312', '130608', '115.492221,38.771012');
INSERT INTO `rg_region` VALUES ('33481', '33184', '3', '涞水县', 'lsx', 'laishuixian', '0312', '130623', '115.711985,39.393148');
INSERT INTO `rg_region` VALUES ('33498', '33184', '3', '涿州市', 'zzs', 'zhuozhoushi', '0312', '130681', '115.973409,39.485765');
INSERT INTO `rg_region` VALUES ('33514', '33184', '3', '蠡县', 'lx', 'lixian', '0312', '130635', '115.583631,38.496429');
INSERT INTO `rg_region` VALUES ('33528', '33184', '3', '高碑店市', 'gbds', 'gaobeidianshi', '0312', '130684', '115.882704,39.327689');
INSERT INTO `rg_region` VALUES ('33544', '33184', '3', '博野县', 'byx', 'boyoxian', '0312', '130637', '115.461798,38.458271');
INSERT INTO `rg_region` VALUES ('33552', '32459', '2', '石家庄市', 'sjzs', 'shijiazhuangshi', '0311', '130100', '114.502461,38.045474');
INSERT INTO `rg_region` VALUES ('33553', '33552', '3', '行唐县', 'xtx', 'xingtangxian', '0311', '130125', '114.552734,38.437422');
INSERT INTO `rg_region` VALUES ('33569', '33552', '3', '灵寿县', 'lsx', 'lingshouxian', '0311', '130126', '114.37946,38.306546');
INSERT INTO `rg_region` VALUES ('33585', '33552', '3', '平山县', 'psx', 'pingshanxian', '0311', '130131', '114.184144,38.259311');
INSERT INTO `rg_region` VALUES ('33609', '33552', '3', '鹿泉区', 'lqq', 'luquanqu', '0311', '130110', '114.321023,38.093994');
INSERT INTO `rg_region` VALUES ('33623', '33552', '3', '正定县', 'zdx', 'zhengdingxian', '0311', '130123', '114.569887,38.147835');
INSERT INTO `rg_region` VALUES ('33634', '33552', '3', '晋州市', 'jzs', 'jinzhoushi', '0311', '130183', '115.044886,38.027478');
INSERT INTO `rg_region` VALUES ('33645', '33552', '3', '裕华区', 'yhq', 'yuhuaqu', '0311', '130108', '114.533257,38.027696');
INSERT INTO `rg_region` VALUES ('33659', '33552', '3', '藁城区', 'gcq', 'gaochengqu', '0311', '130109', '114.849647,38.033767');
INSERT INTO `rg_region` VALUES ('33675', '33552', '3', '无极县', 'wjx', 'wujixian', '0311', '130130', '114.977845,38.176376');
INSERT INTO `rg_region` VALUES ('33687', '33552', '3', '栾城区', 'lcq', 'luanchengqu', '0311', '130111', '114.654281,37.886911');
INSERT INTO `rg_region` VALUES ('33696', '33552', '3', '赵县', 'zx', 'zhaoxian', '0311', '130133', '114.775362,37.754341');
INSERT INTO `rg_region` VALUES ('33708', '33552', '3', '赞皇县', 'zhx', 'zanhuangxian', '0311', '130129', '114.387756,37.660199');
INSERT INTO `rg_region` VALUES ('33720', '33552', '3', '新华区', 'xhq', 'xinhuaqu', '0311', '130105', '114.465974,38.067142');
INSERT INTO `rg_region` VALUES ('33735', '33552', '3', '高邑县', 'gyx', 'gaoyixian', '0311', '130127', '114.610699,37.605714');
INSERT INTO `rg_region` VALUES ('33741', '33552', '3', '井陉矿区', 'jxkq', 'jingxingkuangqu', '0311', '130107', '114.058178,38.069748');
INSERT INTO `rg_region` VALUES ('33747', '33552', '3', '桥西区', 'qxq', 'qiaoxiqu', '0311', '130104', '114.462931,38.028383');
INSERT INTO `rg_region` VALUES ('33765', '33552', '3', '元氏县', 'ysx', 'yuanshixian', '0311', '130132', '114.52618,37.762514');
INSERT INTO `rg_region` VALUES ('33782', '33552', '3', '新乐市', 'xls', 'xinleshi', '0311', '130184', '114.68578,38.344768');
INSERT INTO `rg_region` VALUES ('33795', '33552', '3', '长安区', 'caq', 'changanqu', '0311', '130102', '114.548151,38.047501');
INSERT INTO `rg_region` VALUES ('33812', '33552', '3', '井陉县', 'jxx', 'jingxingxian', '0311', '130121', '114.144488,38.033614');
INSERT INTO `rg_region` VALUES ('33830', '33552', '3', '辛集市', 'xjs', 'xinjishi', '0311', '130181', '115.217451,37.92904');
INSERT INTO `rg_region` VALUES ('33847', '33552', '3', '深泽县', 'szx', 'shenzexian', '0311', '130128', '115.200207,38.18454');
INSERT INTO `rg_region` VALUES ('33854', '32459', '2', '张家口市', 'zjks', 'zhangjiakoushi', '0313', '130700', '114.884091,40.811901');
INSERT INTO `rg_region` VALUES ('33855', '33854', '3', '尚义县', 'syx', 'shangyixian', '0313', '130725', '113.977713,41.080091');
INSERT INTO `rg_region` VALUES ('33870', '33854', '3', '涿鹿县', 'zlx', 'zhuoluxian', '0313', '130731', '115.219246,40.378701');
INSERT INTO `rg_region` VALUES ('33888', '33854', '3', '阳原县', 'yyx', 'yangyuanxian', '0313', '130727', '114.167343,40.113419');
INSERT INTO `rg_region` VALUES ('33903', '33854', '3', '康保县', 'kbx', 'kangbaoxian', '0313', '130723', '114.615809,41.850046');
INSERT INTO `rg_region` VALUES ('33921', '33854', '3', '崇礼区', 'clq', 'chongliqu', '0313', '130709', '115.281652,40.971302');
INSERT INTO `rg_region` VALUES ('33933', '33854', '3', '张北县', 'zbx', 'zhangbeixian', '0313', '130722', '114.715951,41.151713');
INSERT INTO `rg_region` VALUES ('33955', '33854', '3', '怀来县', 'hlx', 'huailaixian', '0313', '130730', '115.520846,40.405405');
INSERT INTO `rg_region` VALUES ('33973', '33854', '3', '赤城县', 'ccx', 'chichengxian', '0313', '130732', '115.832708,40.912081');
INSERT INTO `rg_region` VALUES ('33992', '33854', '3', '下花园区', 'xhyq', 'xiahuayuanqu', '0313', '130706', '115.281002,40.488645');
INSERT INTO `rg_region` VALUES ('33999', '33854', '3', '沽源县', 'gyx', 'guyuanxian', '0313', '130724', '115.684836,41.667419');
INSERT INTO `rg_region` VALUES ('34018', '33854', '3', '万全区', 'wqq', 'wanquanqu', '0313', '130708', '114.736131,40.765136');
INSERT INTO `rg_region` VALUES ('34030', '33854', '3', '蔚县', 'wx', 'weixian', '0313', '130726', '114.582695,39.837181');
INSERT INTO `rg_region` VALUES ('34053', '33854', '3', '桥东区', 'qdq', 'qiaodongqu', '0313', '130702', '114.885658,40.813875');
INSERT INTO `rg_region` VALUES ('34065', '33854', '3', '桥西区', 'qxq', 'qiaoxiqu', '0313', '130703', '114.882127,40.824385');
INSERT INTO `rg_region` VALUES ('34077', '33854', '3', '宣化区', 'xhq', 'xuanhuaqu', '0313', '130705', '115.0632,40.609368');
INSERT INTO `rg_region` VALUES ('34099', '33854', '3', '怀安县', 'hax', 'huaianxian', '0313', '130728', '114.422364,40.671274');
INSERT INTO `rg_region` VALUES ('34111', '32459', '2', '邯郸市', 'hds', 'handanshi', '0310', '130400', '114.490686,36.612273');
INSERT INTO `rg_region` VALUES ('34112', '34111', '3', '涉县', 'sx', 'shexian', '0310', '130426', '113.673297,36.563143');
INSERT INTO `rg_region` VALUES ('34131', '34111', '3', '武安市', 'was', 'wuanshi', '0310', '130481', '114.194581,36.696115');
INSERT INTO `rg_region` VALUES ('34154', '34111', '3', '肥乡区', 'fxq', 'feixiangqu', '0310', '130407', '114.805154,36.555778');
INSERT INTO `rg_region` VALUES ('34164', '34111', '3', '临漳县', 'lzx', 'linzhangxian', '0310', '130423', '114.610703,36.337604');
INSERT INTO `rg_region` VALUES ('34179', '34111', '3', '广平县', 'gpx', 'guangpingxian', '0310', '130432', '114.950859,36.483603');
INSERT INTO `rg_region` VALUES ('34187', '34111', '3', '魏县', 'wx', 'weixian', '0310', '130434', '114.93411,36.354248');
INSERT INTO `rg_region` VALUES ('34209', '34111', '3', '峰峰矿区', 'ffkq', 'fengfengkuangqu', '0310', '130406', '114.209936,36.420487');
INSERT INTO `rg_region` VALUES ('34219', '34111', '3', '大名县', 'dmx', 'damingxian', '0310', '130425', '115.152586,36.283316');
INSERT INTO `rg_region` VALUES ('34240', '34111', '3', '鸡泽县', 'jzx', 'jizexian', '0310', '130431', '114.878517,36.914908');
INSERT INTO `rg_region` VALUES ('34248', '34111', '3', '曲周县', 'qzx', 'quzhouxian', '0310', '130435', '114.957588,36.773398');
INSERT INTO `rg_region` VALUES ('34259', '34111', '3', '复兴区', 'fxq', 'fuxingqu', '0310', '130404', '114.458242,36.615484');
INSERT INTO `rg_region` VALUES ('34271', '34111', '3', '丛台区', 'ctq', 'congtaiqu', '0310', '130403', '114.494703,36.611082');
INSERT INTO `rg_region` VALUES ('34291', '34111', '3', '永年区', 'ynq', 'yongnianqu', '0310', '130408', '114.496162,36.776413');
INSERT INTO `rg_region` VALUES ('34309', '34111', '3', '磁县', 'cx', 'cixian', '0310', '130427', '114.38208,36.367673');
INSERT INTO `rg_region` VALUES ('34322', '34111', '3', '成安县', 'cax', 'chenganxian', '0310', '130424', '114.680356,36.443832');
INSERT INTO `rg_region` VALUES ('34332', '34111', '3', '邯山区', 'hsq', 'hanshanqu', '0310', '130402', '114.484989,36.603196');
INSERT INTO `rg_region` VALUES ('34354', '34111', '3', '馆陶县', 'gtx', 'guantaoxian', '0310', '130433', '115.289057,36.539461');
INSERT INTO `rg_region` VALUES ('34363', '34111', '3', '邱县', 'qx', 'qiuxian', '0310', '130430', '115.168584,36.81325');
INSERT INTO `rg_region` VALUES ('34371', '32459', '2', '邢台市', 'xts', 'xingtaishi', '0319', '130500', '114.508851,37.0682');
INSERT INTO `rg_region` VALUES ('34372', '34371', '3', '临城县', 'lcx', 'linchengxian', '0319', '130522', '114.506873,37.444009');
INSERT INTO `rg_region` VALUES ('34381', '34371', '3', '新河县', 'xhx', 'xinhexian', '0319', '130530', '115.247537,37.526216');
INSERT INTO `rg_region` VALUES ('34388', '34371', '3', '清河县', 'qhx', 'qinghexian', '0319', '130534', '115.668999,37.059991');
INSERT INTO `rg_region` VALUES ('34395', '34371', '3', '宁晋县', 'njx', 'ningjinxian', '0319', '130528', '114.921027,37.618956');
INSERT INTO `rg_region` VALUES ('34413', '34371', '3', '广宗县', 'gzx', 'guangzongxian', '0319', '130531', '115.142797,37.075548');
INSERT INTO `rg_region` VALUES ('34422', '34371', '3', '桥西区', 'qxq', 'qiaoxiqu', '0319', '130503', '114.473687,37.068009');
INSERT INTO `rg_region` VALUES ('34432', '34371', '3', '平乡县', 'pxx', 'pingxiangxian', '0319', '130532', '115.029218,37.069404');
INSERT INTO `rg_region` VALUES ('34440', '34371', '3', '隆尧县', 'lyx', 'longyaoxian', '0319', '130525', '114.776348,37.350925');
INSERT INTO `rg_region` VALUES ('34454', '34371', '3', '柏乡县', 'bxx', 'baixiangxian', '0319', '130524', '114.693382,37.483596');
INSERT INTO `rg_region` VALUES ('34461', '34371', '3', '内丘县', 'nqx', 'neiqiuxian', '0319', '130523', '114.511523,37.287663');
INSERT INTO `rg_region` VALUES ('34471', '34371', '3', '南和县', 'nhx', 'nanhexian', '0319', '130527', '114.691377,37.003812');
INSERT INTO `rg_region` VALUES ('34480', '34371', '3', '南宫市', 'ngs', 'nangongshi', '0319', '130581', '115.398102,37.359668');
INSERT INTO `rg_region` VALUES ('34496', '34371', '3', '沙河市', 'shs', 'shaheshi', '0319', '130582', '114.504902,36.861903');
INSERT INTO `rg_region` VALUES ('34512', '34371', '3', '巨鹿县', 'jlx', 'juluxian', '0319', '130529', '115.038782,37.21768');
INSERT INTO `rg_region` VALUES ('34523', '34371', '3', '任县', 'rx', 'renxian', '0319', '130526', '114.684469,37.129952');
INSERT INTO `rg_region` VALUES ('34532', '34371', '3', '桥东区', 'qdq', 'qiaodongqu', '0319', '130502', '114.507131,37.064125');
INSERT INTO `rg_region` VALUES ('34540', '34371', '3', '邢台县', 'xtx', 'xingtaixian', '0319', '130521', '114.561132,37.05073');
INSERT INTO `rg_region` VALUES ('34561', '34371', '3', '临西县', 'lxx', 'linxixian', '0319', '130535', '115.498684,36.8642');
INSERT INTO `rg_region` VALUES ('34571', '34371', '3', '威县', 'wx', 'weixian', '0319', '130533', '115.272749,36.983272');
INSERT INTO `rg_region` VALUES ('34588', '32459', '2', '衡水市', 'hss', 'hengshuishi', '0318', '131100', '115.665993,37.735097');
INSERT INTO `rg_region` VALUES ('34589', '34588', '3', '枣强县', 'zqx', 'zaoqiangxian', '0318', '131121', '115.726499,37.511512');
INSERT INTO `rg_region` VALUES ('34601', '34588', '3', '武强县', 'wqx', 'wuqiangxian', '0318', '131123', '115.970236,38.03698');
INSERT INTO `rg_region` VALUES ('34608', '34588', '3', '武邑县', 'wyx', 'wuyixian', '0318', '131122', '115.892415,37.803774');
INSERT INTO `rg_region` VALUES ('34618', '34588', '3', '冀州区', 'jzq', 'jizhouqu', '0318', '131103', '115.579173,37.542788');
INSERT INTO `rg_region` VALUES ('34630', '34588', '3', '桃城区', 'tcq', 'taochengqu', '0318', '131102', '115.694945,37.732237');
INSERT INTO `rg_region` VALUES ('34643', '34588', '3', '故城县', 'gcx', 'guchengxian', '0318', '131126', '115.966747,37.350981');
INSERT INTO `rg_region` VALUES ('34657', '34588', '3', '景县', 'jx', 'jingxian', '0318', '131127', '116.258446,37.686622');
INSERT INTO `rg_region` VALUES ('34674', '34588', '3', '深州市', 'szs', 'shenzhoushi', '0318', '131182', '115.554596,38.00347');
INSERT INTO `rg_region` VALUES ('34695', '34588', '3', '阜城县', 'fcx', 'fuchengxian', '0318', '131128', '116.164727,37.869945');
INSERT INTO `rg_region` VALUES ('34706', '34588', '3', '饶阳县', 'ryx', 'raoyangxian', '0318', '131124', '115.726577,38.232671');
INSERT INTO `rg_region` VALUES ('34714', '34588', '3', '安平县', 'apx', 'anpingxian', '0318', '131125', '115.519627,38.233511');
INSERT INTO `rg_region` VALUES ('34723', '32459', '2', '沧州市', 'czs', 'cangzhoushi', '0317', '130900', '116.857461,38.310582');
INSERT INTO `rg_region` VALUES ('34724', '34723', '3', '任丘市', 'rqs', 'renqiushi', '0317', '130982', '116.106764,38.706513');
INSERT INTO `rg_region` VALUES ('34747', '34723', '3', '运河区', 'yhq', 'yunhequ', '0317', '130903', '116.840063,38.307405');
INSERT INTO `rg_region` VALUES ('34757', '34723', '3', '河间市', 'hjs', 'hejianshi', '0317', '130984', '116.089452,38.44149');
INSERT INTO `rg_region` VALUES ('34779', '34723', '3', '献县', 'xx', 'xianxian', '0317', '130929', '116.123844,38.189661');
INSERT INTO `rg_region` VALUES ('34799', '34723', '3', '肃宁县', 'snx', 'suningxian', '0317', '130926', '115.835856,38.427102');
INSERT INTO `rg_region` VALUES ('34809', '34723', '3', '新华区', 'xhq', 'xinhuaqu', '0317', '130902', '116.873049,38.308273');
INSERT INTO `rg_region` VALUES ('34817', '34723', '3', '孟村回族自治县', 'mchzzzx', 'mengcunhuizuzizhixian', '0317', '130930', '117.105104,38.057953');
INSERT INTO `rg_region` VALUES ('34824', '34723', '3', '吴桥县', 'wqx', 'wuqiaoxian', '0317', '130928', '116.391512,37.628182');
INSERT INTO `rg_region` VALUES ('34836', '34723', '3', '海兴县', 'hxx', 'haixingxian', '0317', '130924', '117.496606,38.141582');
INSERT INTO `rg_region` VALUES ('34847', '34723', '3', '东光县', 'dgx', 'dongguangxian', '0317', '130923', '116.542062,37.88655');
INSERT INTO `rg_region` VALUES ('34857', '34723', '3', '南皮县', 'npx', 'nanpixian', '0317', '130927', '116.709171,38.042439');
INSERT INTO `rg_region` VALUES ('34867', '34723', '3', '盐山县', 'ysx', 'yanshanxian', '0317', '130925', '117.229814,38.056141');
INSERT INTO `rg_region` VALUES ('34880', '34723', '3', '黄骅市', 'hhs', 'huanghuashi', '0317', '130983', '117.343803,38.369238');
INSERT INTO `rg_region` VALUES ('34899', '34723', '3', '泊头市', 'bts', 'botoushi', '0317', '130981', '116.570163,38.073479');
INSERT INTO `rg_region` VALUES ('34916', '34723', '3', '沧县', 'cx', 'cangxian', '0317', '130921', '117.007478,38.219856');
INSERT INTO `rg_region` VALUES ('34936', '34723', '3', '青县', 'qx', 'qingxian', '0317', '130922', '116.838384,38.569646');
INSERT INTO `rg_region` VALUES ('34948', '0', '1', '香港特别行政区', 'xgtbxzq', 'xianggangtebiexingzhengqu', '1852', '810000', '114.173355,22.320048');
INSERT INTO `rg_region` VALUES ('34949', '34948', '2', '西贡区', 'xgq', 'xigongqu', '1852', '810015', '114.264813,22.314203');
INSERT INTO `rg_region` VALUES ('34950', '34948', '2', '观塘区', 'gtq', 'guantangqu', '1852', '810009', '114.214083,22.320679');
INSERT INTO `rg_region` VALUES ('34951', '34948', '2', '沙田区', 'stq', 'shatianqu', '1852', '810016', '114.195126,22.379715');
INSERT INTO `rg_region` VALUES ('34952', '34948', '2', '九龙城区', 'jlcq', 'jiulongchengqu', '1852', '810007', '114.193047,22.312373');
INSERT INTO `rg_region` VALUES ('34953', '34948', '2', '大埔区', 'dpq', 'dapuqu', '1852', '810014', '114.171713,22.44573');
INSERT INTO `rg_region` VALUES ('34954', '34948', '2', '黄大仙区', 'hdxq', 'huangdaxianqu', '1852', '810008', '114.203985,22.336112');
INSERT INTO `rg_region` VALUES ('34955', '34948', '2', '深水埗区', 'ssbq', 'shenshuibuqu', '1852', '810006', '114.163349,22.333775');
INSERT INTO `rg_region` VALUES ('34956', '34948', '2', '油尖旺区', 'yjwq', 'youjianwangqu', '1852', '810005', '114.173347,22.311632');
INSERT INTO `rg_region` VALUES ('34957', '34948', '2', '北区', 'bq', 'beiqu', '1852', '810013', '114.147404,22.496143');
INSERT INTO `rg_region` VALUES ('34958', '34948', '2', '屯门区', 'tmq', 'tunmenqu', '1852', '810011', '113.976308,22.393896');
INSERT INTO `rg_region` VALUES ('34959', '34948', '2', '离岛区', 'ldq', 'lidaoqu', '1852', '810018', '113.946059,22.286371');
INSERT INTO `rg_region` VALUES ('34960', '34948', '2', '东区', 'dq', 'dongqu', '1852', '810003', '114.225965,22.279779');
INSERT INTO `rg_region` VALUES ('34961', '34948', '2', '元朗区', 'ylq', 'yuanlangqu', '1852', '810012', '114.032528,22.44132');
INSERT INTO `rg_region` VALUES ('34962', '34948', '2', '湾仔区', 'wzq', 'wanziqu', '1852', '810002', '114.18299,22.276345');
INSERT INTO `rg_region` VALUES ('34963', '34948', '2', '中西区', 'zxq', 'zhongxiqu', '1852', '810001', '114.154334,22.281931');
INSERT INTO `rg_region` VALUES ('34964', '34948', '2', '南区', 'nq', 'nanqu', '1852', '810004', '114.160023,22.245811');
INSERT INTO `rg_region` VALUES ('34965', '34948', '2', '荃湾区', 'qwq', 'quanwanqu', '1852', '810010', '114.121234,22.368458');
INSERT INTO `rg_region` VALUES ('34966', '34948', '2', '葵青区', 'kqq', 'kuiqingqu', '1852', '810017', '114.13918,22.363908');
INSERT INTO `rg_region` VALUES ('34967', '0', '1', '台湾省', 'tws', 'taiwansheng', '1886', '710000', '121.509062,25.044332');
INSERT INTO `rg_region` VALUES ('34968', '0', '1', '澳门特别行政区', 'amtbxzq', 'aomentebiexingzhengqu', '1853', '820000', '113.54909,22.198951');
INSERT INTO `rg_region` VALUES ('34969', '34968', '2', '大堂区', 'dtq', 'datangqu', '1853', '820004', '113.55374,22.188119');
INSERT INTO `rg_region` VALUES ('34970', '34968', '2', '望德堂区', 'wdtq', 'wangdetangqu', '1853', '820003', '113.550252,22.193791');
INSERT INTO `rg_region` VALUES ('34971', '34968', '2', '圣方济各堂区', 'sfjgtq', 'shengfangjigetangqu', '1853', '820008', '113.559954,22.124049');
INSERT INTO `rg_region` VALUES ('34972', '34968', '2', '嘉模堂区', 'jmtq', 'jiamotangqu', '1853', '820006', '113.558783,22.154124');
INSERT INTO `rg_region` VALUES ('34973', '34968', '2', '风顺堂区', 'fstq', 'fengshuntangqu', '1853', '820005', '113.54167,22.187778');
INSERT INTO `rg_region` VALUES ('34974', '34968', '2', '花王堂区', 'hwtq', 'huawangtangqu', '1853', '820002', '113.549052,22.199175');
INSERT INTO `rg_region` VALUES ('34975', '34968', '2', '花地玛堂区', 'hdmtq', 'huadimatangqu', '1853', '820001', '113.552965,22.207882');
INSERT INTO `rg_region` VALUES ('34976', '34968', '2', '路凼填海区', 'ldthq', 'ludangtianhaiqu', '1853', '820007', '113.56925,22.136546');
INSERT INTO `rg_region` VALUES ('34977', '0', '1', '甘肃省', 'gss', 'gansusheng', '', '620000', '103.823557,36.058039');
INSERT INTO `rg_region` VALUES ('34978', '34977', '2', '嘉峪关市', 'jygs', 'jiayuguanshi', '1937', '620200', '98.277304,39.786529');
INSERT INTO `rg_region` VALUES ('34979', '34978', '3', '峪泉镇', 'yqz', 'yuquanzhen', '1937', '620200', '98.3204,39.9583');
INSERT INTO `rg_region` VALUES ('34980', '34978', '3', '新城镇', 'xcz', 'xinchengzhen', '1937', '620200', '98.3627,39.9581');
INSERT INTO `rg_region` VALUES ('34981', '34978', '3', '文殊镇', 'wsz', 'wenshuzhen', '1937', '620200', '98.1579,39.6969');
INSERT INTO `rg_region` VALUES ('34982', '34978', '3', '雄关区', 'xgq', 'xiongguanqu', '1937', '620200', '98.317,39.8839');
INSERT INTO `rg_region` VALUES ('34983', '34978', '3', '镜铁区', 'jtq', 'jingtioqu', '1937', '620200', '98.3342,39.7378');
INSERT INTO `rg_region` VALUES ('34984', '34978', '3', '长城区', 'ccq', 'changchengqu', '1937', '620200', '98.255,39.8552');
INSERT INTO `rg_region` VALUES ('34985', '34977', '2', '酒泉市', 'jqs', 'jiuquanshi', '0937', '620900', '98.510795,39.744023');
INSERT INTO `rg_region` VALUES ('34986', '34985', '3', '肃州区', 'szq', 'suzhouqu', '0937', '620902', '98.511155,39.743858');
INSERT INTO `rg_region` VALUES ('35011', '34985', '3', '玉门市', 'yms', 'yumenshi', '0937', '620981', '97.037206,40.28682');
INSERT INTO `rg_region` VALUES ('35031', '34985', '3', '金塔县', 'jtx', 'jintaxian', '0937', '620921', '98.902959,39.983036');
INSERT INTO `rg_region` VALUES ('35046', '34985', '3', '敦煌市', 'dhs', 'dunhuangshi', '0937', '620982', '94.664279,40.141119');
INSERT INTO `rg_region` VALUES ('35058', '34985', '3', '肃北蒙古族自治县', 'sbmgzzzx', 'subeimengguzuzizhixian', '0937', '620923', '94.87728,39.51224');
INSERT INTO `rg_region` VALUES ('35063', '34985', '3', '瓜州县', 'gzx', 'guazhouxian', '0937', '620922', '95.780591,40.516525');
INSERT INTO `rg_region` VALUES ('35080', '34985', '3', '阿克塞哈萨克族自治县', 'akshskzzzx', 'akesaihasakezuzizhixian', '0937', '620924', '94.337642,39.631642');
INSERT INTO `rg_region` VALUES ('35084', '34977', '2', '金昌市', 'jcs', 'jinchangshi', '0935', '620300', '102.187888,38.514238');
INSERT INTO `rg_region` VALUES ('35085', '35084', '3', '金川区', 'jcq', 'jinchuanqu', '0935', '620302', '102.187683,38.513793');
INSERT INTO `rg_region` VALUES ('35094', '35084', '3', '永昌县', 'ycx', 'yongchangxian', '0935', '620321', '101.971957,38.247354');
INSERT INTO `rg_region` VALUES ('35105', '34977', '2', '兰州市', 'lzs', 'lanzhoushi', '0931', '620100', '103.823557,36.058039');
INSERT INTO `rg_region` VALUES ('35106', '35105', '3', '永登县', 'ydx', 'yongdengxian', '0931', '620121', '103.262203,36.734428');
INSERT INTO `rg_region` VALUES ('35125', '35105', '3', '皋兰县', 'glx', 'gaolanxian', '0931', '620122', '103.94933,36.331254');
INSERT INTO `rg_region` VALUES ('35133', '35105', '3', '红古区', 'hgq', 'hongguqu', '0931', '620111', '102.861814,36.344177');
INSERT INTO `rg_region` VALUES ('35141', '35105', '3', '西固区', 'xgq', 'xiguqu', '0931', '620104', '103.622331,36.100369');
INSERT INTO `rg_region` VALUES ('35157', '35105', '3', '七里河区', 'qlhq', 'qilihequ', '0931', '620103', '103.784326,36.06673');
INSERT INTO `rg_region` VALUES ('35173', '35105', '3', '安宁区', 'anq', 'anningqu', '0931', '620105', '103.724038,36.10329');
INSERT INTO `rg_region` VALUES ('35182', '35105', '3', '城关区', 'cgq', 'chengguanqu', '0931', '620102', '103.841032,36.049115');
INSERT INTO `rg_region` VALUES ('35208', '35105', '3', '榆中县', 'yzx', 'yuzhongxian', '0931', '620123', '104.114975,35.84443');
INSERT INTO `rg_region` VALUES ('35232', '34977', '2', '平凉市', 'pls', 'pingliangshi', '0933', '620800', '106.684691,35.54279');
INSERT INTO `rg_region` VALUES ('35233', '35232', '3', '庄浪县', 'zlx', 'zhuanglangxian', '0933', '620825', '106.041979,35.203428');
INSERT INTO `rg_region` VALUES ('35253', '35232', '3', '崇信县', 'cxx', 'chongxinxian', '0933', '620823', '107.031253,35.304533');
INSERT INTO `rg_region` VALUES ('35264', '35232', '3', '崆峒区', 'ktq', 'kongtongqu', '0933', '620802', '106.684223,35.54173');
INSERT INTO `rg_region` VALUES ('35287', '35232', '3', '灵台县', 'ltx', 'lingtaixian', '0933', '620822', '107.620587,35.064009');
INSERT INTO `rg_region` VALUES ('35303', '35232', '3', '华亭市', 'hts', 'huatingshi', '0933', '620881', '106.649308,35.215342');
INSERT INTO `rg_region` VALUES ('35316', '35232', '3', '静宁县', 'jnx', 'jingningxian', '0933', '620826', '105.733489,35.525243');
INSERT INTO `rg_region` VALUES ('35342', '35232', '3', '泾川县', 'jcx', 'jingchuanxian', '0933', '620821', '107.365218,35.335283');
INSERT INTO `rg_region` VALUES ('35360', '34977', '2', '白银市', 'bys', 'baiyinshi', '0943', '620400', '104.173606,36.54568');
INSERT INTO `rg_region` VALUES ('35361', '35360', '3', '靖远县', 'jyx', 'jingyuanxian', '0943', '620421', '104.686972,36.561424');
INSERT INTO `rg_region` VALUES ('35380', '35360', '3', '白银区', 'byq', 'baiyinqu', '0943', '620402', '104.17425,36.545649');
INSERT INTO `rg_region` VALUES ('35391', '35360', '3', '平川区', 'pcq', 'pingchuanqu', '0943', '620403', '104.819207,36.72921');
INSERT INTO `rg_region` VALUES ('35403', '35360', '3', '会宁县', 'hnx', 'huiningxian', '0943', '620422', '105.054337,35.692486');
INSERT INTO `rg_region` VALUES ('35432', '35360', '3', '景泰县', 'jtx', 'jingtaixian', '0943', '620423', '104.066394,37.193519');
INSERT INTO `rg_region` VALUES ('35445', '34977', '2', '天水市', 'tss', 'tianshuishi', '0938', '620500', '105.724998,34.578529');
INSERT INTO `rg_region` VALUES ('35446', '35445', '3', '张家川回族自治县', 'zjchzzzx', 'zhangjiachuanhuizuzizhixian', '0938', '620525', '106.212416,34.993237');
INSERT INTO `rg_region` VALUES ('35462', '35445', '3', '秦安县', 'qax', 'qinanxian', '0938', '620522', '105.6733,34.862354');
INSERT INTO `rg_region` VALUES ('35480', '35445', '3', '清水县', 'qsx', 'qingshuixian', '0938', '620521', '106.139878,34.75287');
INSERT INTO `rg_region` VALUES ('35500', '35445', '3', '甘谷县', 'ggx', 'ganguxian', '0938', '620523', '105.332347,34.747327');
INSERT INTO `rg_region` VALUES ('35516', '35445', '3', '秦州区', 'qzq', 'qinzhouqu', '0938', '620502', '105.724477,34.578645');
INSERT INTO `rg_region` VALUES ('35540', '35445', '3', '武山县', 'wsx', 'wushanxian', '0938', '620524', '104.891696,34.721955');
INSERT INTO `rg_region` VALUES ('35556', '35445', '3', '麦积区', 'mjq', 'maijiqu', '0938', '620503', '105.897631,34.563504');
INSERT INTO `rg_region` VALUES ('35583', '34977', '2', '武威市', 'wws', 'wuweishi', '1935', '620600', '102.634697,37.929996');
INSERT INTO `rg_region` VALUES ('35584', '35583', '3', '凉州区', 'lzq', 'liangzhouqu', '1935', '620602', '102.634492,37.93025');
INSERT INTO `rg_region` VALUES ('35631', '35583', '3', '古浪县', 'glx', 'gulangxian', '1935', '620622', '102.898047,37.470571');
INSERT INTO `rg_region` VALUES ('35651', '35583', '3', '天祝藏族自治县', 'tzczzzx', 'tianzhucangzuzizhixian', '1935', '620623', '103.142034,36.971678');
INSERT INTO `rg_region` VALUES ('35673', '35583', '3', '民勤县', 'mqx', 'minqinxian', '1935', '620621', '103.090654,38.624621');
INSERT INTO `rg_region` VALUES ('35692', '34977', '2', '陇南市', 'lns', 'longnanshi', '2935', '621200', '104.929379,33.388598');
INSERT INTO `rg_region` VALUES ('35693', '35692', '3', '礼县', 'lx', 'lixian', '2935', '621226', '105.181616,34.189387');
INSERT INTO `rg_region` VALUES ('35723', '35692', '3', '徽县', 'hx', 'huixian', '2935', '621227', '106.085632,33.767785');
INSERT INTO `rg_region` VALUES ('35739', '35692', '3', '两当县', 'ldx', 'liangdangxian', '2935', '621228', '106.306959,33.910729');
INSERT INTO `rg_region` VALUES ('35752', '35692', '3', '康县', 'kx', 'kangxian', '2935', '621224', '105.609534,33.328266');
INSERT INTO `rg_region` VALUES ('35774', '35692', '3', '成县', 'cx', 'chengxian', '2935', '621221', '105.734434,33.739863');
INSERT INTO `rg_region` VALUES ('35792', '35692', '3', '武都区', 'wdq', 'wuduqu', '2935', '621202', '104.929866,33.388155');
INSERT INTO `rg_region` VALUES ('35829', '35692', '3', '宕昌县', 'dcx', 'dangchangxian', '2935', '621223', '104.394475,34.042655');
INSERT INTO `rg_region` VALUES ('35855', '35692', '3', '文县', 'wx', 'wenxian', '2935', '621222', '104.682448,32.942171');
INSERT INTO `rg_region` VALUES ('35876', '35692', '3', '西和县', 'xhx', 'xihexian', '2935', '621225', '105.299737,34.013718');
INSERT INTO `rg_region` VALUES ('35897', '34977', '2', '甘南藏族自治州', 'gnczzzz', 'gannancangzuzizhizhou', '0941', '623000', '102.911008,34.986354');
INSERT INTO `rg_region` VALUES ('35898', '35897', '3', '临潭县', 'ltx', 'lintanxian', '0941', '623021', '103.353054,34.69164');
INSERT INTO `rg_region` VALUES ('35915', '35897', '3', '玛曲县', 'mqx', 'maquxian', '0941', '623025', '102.075767,33.998068');
INSERT INTO `rg_region` VALUES ('35927', '35897', '3', '夏河县', 'xhx', 'xiahexian', '0941', '623027', '102.520743,35.200853');
INSERT INTO `rg_region` VALUES ('35941', '35897', '3', '迭部县', 'dbx', 'diebuxian', '0941', '623024', '103.221009,34.055348');
INSERT INTO `rg_region` VALUES ('35953', '35897', '3', '卓尼县', 'znx', 'zhuonixian', '0941', '623022', '103.508508,34.588165');
INSERT INTO `rg_region` VALUES ('35969', '35897', '3', '合作市', 'hzs', 'hezuoshi', '0941', '623001', '102.91149,34.985973');
INSERT INTO `rg_region` VALUES ('35980', '35897', '3', '舟曲县', 'zqx', 'zhouquxian', '0941', '623023', '104.370271,33.782964');
INSERT INTO `rg_region` VALUES ('36000', '35897', '3', '碌曲县', 'lqx', 'luquxian', '0941', '623026', '102.488495,34.589591');
INSERT INTO `rg_region` VALUES ('36010', '34977', '2', '临夏回族自治州', 'lxhzzzz', 'linxiahuizuzizhizhou', '0930', '622900', '103.212006,35.599446');
INSERT INTO `rg_region` VALUES ('36011', '36010', '3', '永靖县', 'yjx', 'yongjingxian', '0930', '622923', '103.319871,35.938933');
INSERT INTO `rg_region` VALUES ('36029', '36010', '3', '东乡族自治县', 'dxzzzx', 'dongxiangzuzizhixian', '0930', '622926', '103.389568,35.66383');
INSERT INTO `rg_region` VALUES ('36054', '36010', '3', '积石山保安族东乡族撒拉族自治县', 'jssbazdxzslzzzx', 'jishishanbaoanzudongxiangzusalazuzizhixian', '0930', '622927', '102.877473,35.712906');
INSERT INTO `rg_region` VALUES ('36072', '36010', '3', '临夏市', 'lxs', 'linxiashi', '0930', '622901', '103.211634,35.59941');
INSERT INTO `rg_region` VALUES ('36083', '36010', '3', '临夏县', 'lxx', 'linxiaxian', '0930', '622921', '102.993873,35.49236');
INSERT INTO `rg_region` VALUES ('36109', '36010', '3', '和政县', 'hzx', 'hezhengxian', '0930', '622925', '103.350357,35.425971');
INSERT INTO `rg_region` VALUES ('36123', '36010', '3', '广河县', 'ghx', 'guanghexian', '0930', '622924', '103.576188,35.481688');
INSERT INTO `rg_region` VALUES ('36133', '36010', '3', '康乐县', 'klx', 'kanglexian', '0930', '622922', '103.709852,35.371906');
INSERT INTO `rg_region` VALUES ('36149', '34977', '2', '张掖市', 'zys', 'zhangyeshi', '0936', '620700', '100.455472,38.932897');
INSERT INTO `rg_region` VALUES ('36150', '36149', '3', '高台县', 'gtx', 'gaotaixian', '0936', '620724', '99.81665,39.376308');
INSERT INTO `rg_region` VALUES ('36161', '36149', '3', '肃南裕固族自治县', 'snygzzzx', 'sunanyuguzuzizhixian', '0936', '620721', '99.617086,38.837269');
INSERT INTO `rg_region` VALUES ('36172', '36149', '3', '山丹县', 'sdx', 'shandanxian', '0936', '620725', '101.088442,38.784839');
INSERT INTO `rg_region` VALUES ('36183', '36149', '3', '民乐县', 'mlx', 'minlexian', '0936', '620722', '100.816623,38.434454');
INSERT INTO `rg_region` VALUES ('36195', '36149', '3', '临泽县', 'lzx', 'linzexian', '0936', '620723', '100.166333,39.152151');
INSERT INTO `rg_region` VALUES ('36209', '36149', '3', '甘州区', 'gzq', 'ganzhouqu', '0936', '620702', '100.454862,38.931774');
INSERT INTO `rg_region` VALUES ('36237', '34977', '2', '庆阳市', 'qys', 'qingyangshi', '0934', '621000', '107.638372,35.734218');
INSERT INTO `rg_region` VALUES ('36238', '36237', '3', '合水县', 'hsx', 'heshuixian', '0934', '621024', '108.019865,35.819005');
INSERT INTO `rg_region` VALUES ('36251', '36237', '3', '庆城县', 'qcx', 'qingchengxian', '0934', '621021', '107.885664,36.013504');
INSERT INTO `rg_region` VALUES ('36267', '36237', '3', '正宁县', 'znx', 'zhengningxian', '0934', '621025', '108.361068,35.490642');
INSERT INTO `rg_region` VALUES ('36278', '36237', '3', '西峰区', 'xfq', 'xifengqu', '0934', '621002', '107.638824,35.733713');
INSERT INTO `rg_region` VALUES ('36289', '36237', '3', '镇原县', 'zyx', 'zhenyuanxian', '0934', '621027', '107.195706,35.677806');
INSERT INTO `rg_region` VALUES ('36309', '36237', '3', '华池县', 'hcx', 'huachixian', '0934', '621023', '107.986288,36.457304');
INSERT INTO `rg_region` VALUES ('36325', '36237', '3', '环县', 'hx', 'huanxian', '0934', '621022', '107.308754,36.569322');
INSERT INTO `rg_region` VALUES ('36347', '36237', '3', '宁县', 'nx', 'ningxian', '0934', '621026', '107.921182,35.50201');
INSERT INTO `rg_region` VALUES ('36366', '34977', '2', '定西市', 'dxs', 'dingxishi', '0932', '621100', '104.626294,35.579578');
INSERT INTO `rg_region` VALUES ('36367', '36366', '3', '临洮县', 'ltx', 'lintaoxian', '0932', '621124', '103.862186,35.376233');
INSERT INTO `rg_region` VALUES ('36386', '36366', '3', '渭源县', 'wyx', 'weiyuanxian', '0932', '621123', '104.211742,35.133023');
INSERT INTO `rg_region` VALUES ('36403', '36366', '3', '陇西县', 'lxx', 'longxixian', '0932', '621122', '104.637554,35.003409');
INSERT INTO `rg_region` VALUES ('36421', '36366', '3', '岷县', 'mx', 'minxian', '0932', '621126', '104.039882,34.439105');
INSERT INTO `rg_region` VALUES ('36440', '36366', '3', '通渭县', 'twx', 'tongweixian', '0932', '621121', '105.250102,35.208922');
INSERT INTO `rg_region` VALUES ('36459', '36366', '3', '漳县', 'zx', 'zhangxian', '0932', '621125', '104.466756,34.848642');
INSERT INTO `rg_region` VALUES ('36473', '36366', '3', '安定区', 'adq', 'andingqu', '0932', '621102', '104.62577,35.579764');
INSERT INTO `rg_region` VALUES ('36495', '0', '1', '四川省', 'scs', 'sichuansheng', '', '510000', '104.065735,30.659462');
INSERT INTO `rg_region` VALUES ('36496', '36495', '2', '广元市', 'gys', 'guangyuanshi', '0839', '510800', '105.829757,32.433668');
INSERT INTO `rg_region` VALUES ('36497', '36496', '3', '昭化区', 'zhq', 'zhaohuaqu', '0839', '510811', '105.964121,32.322788');
INSERT INTO `rg_region` VALUES ('36527', '36496', '3', '剑阁县', 'jgx', 'jiangexian', '0839', '510823', '105.527035,32.286517');
INSERT INTO `rg_region` VALUES ('36585', '36496', '3', '朝天区', 'ztq', 'zhaotianqu', '0839', '510812', '105.88917,32.642632');
INSERT INTO `rg_region` VALUES ('36611', '36496', '3', '苍溪县', 'cxx', 'cangxixian', '0839', '510824', '105.939706,31.732251');
INSERT INTO `rg_region` VALUES ('36654', '36496', '3', '旺苍县', 'wcx', 'wangcangxian', '0839', '510821', '106.290426,32.22833');
INSERT INTO `rg_region` VALUES ('36693', '36496', '3', '青川县', 'qcx', 'qingchuanxian', '0839', '510822', '105.238847,32.585655');
INSERT INTO `rg_region` VALUES ('36731', '36496', '3', '利州区', 'lzq', 'lizhouqu', '0839', '510802', '105.826194,32.432276');
INSERT INTO `rg_region` VALUES ('36752', '36495', '2', '南充市', 'ncs', 'nanchongshi', '0817', '511300', '106.082974,30.795281');
INSERT INTO `rg_region` VALUES ('36753', '36752', '3', '顺庆区', 'sqq', 'shunqingqu', '0817', '511302', '106.084091,30.795572');
INSERT INTO `rg_region` VALUES ('36783', '36752', '3', '南部县', 'nbx', 'nanbuxian', '0817', '511321', '106.061138,31.349407');
INSERT INTO `rg_region` VALUES ('36858', '36752', '3', '嘉陵区', 'jlq', 'jialingqu', '0817', '511304', '106.067027,30.762976');
INSERT INTO `rg_region` VALUES ('36904', '36752', '3', '西充县', 'xcx', 'xichongxian', '0817', '511325', '105.893021,30.994616');
INSERT INTO `rg_region` VALUES ('36949', '36752', '3', '营山县', 'ysx', 'yingshanxian', '0817', '511322', '106.564893,31.075907');
INSERT INTO `rg_region` VALUES ('37003', '36752', '3', '蓬安县', 'pax', 'penganxian', '0817', '511323', '106.413488,31.027978');
INSERT INTO `rg_region` VALUES ('37043', '36752', '3', '仪陇县', 'ylx', 'yilongxian', '0817', '511324', '106.297083,31.271261');
INSERT INTO `rg_region` VALUES ('37101', '36752', '3', '阆中市', 'lzs', 'langzhongshi', '0817', '511381', '105.975266,31.580466');
INSERT INTO `rg_region` VALUES ('37152', '36752', '3', '高坪区', 'gpq', 'gaopingqu', '0817', '511303', '106.108996,30.781809');
INSERT INTO `rg_region` VALUES ('37185', '36495', '2', '巴中市', 'bzs', 'bazhongshi', '0827', '511900', '106.753669,31.858809');
INSERT INTO `rg_region` VALUES ('37186', '37185', '3', '通江县', 'tjx', 'tongjiangxian', '0827', '511921', '107.247621,31.91212');
INSERT INTO `rg_region` VALUES ('37236', '37185', '3', '南江县', 'njx', 'nanjiangxian', '0827', '511922', '106.843418,32.353164');
INSERT INTO `rg_region` VALUES ('37286', '37185', '3', '平昌县', 'pcx', 'pingchangxian', '0827', '511923', '107.101937,31.562814');
INSERT INTO `rg_region` VALUES ('37331', '37185', '3', '巴州区', 'bzq', 'bazhouqu', '0827', '511902', '106.753671,31.858366');
INSERT INTO `rg_region` VALUES ('37362', '37185', '3', '恩阳区', 'eyq', 'enyangqu', '0827', '511903', '106.486515,31.816336');
INSERT INTO `rg_region` VALUES ('37387', '36495', '2', '德阳市', 'dys', 'deyangshi', '0838', '510600', '104.398651,31.127991');
INSERT INTO `rg_region` VALUES ('37388', '37387', '3', '旌阳区', 'jyq', 'jingyangqu', '0838', '510603', '104.389648,31.130428');
INSERT INTO `rg_region` VALUES ('37406', '37387', '3', '广汉市', 'ghs', 'guanghanshi', '0838', '510681', '104.281903,30.97715');
INSERT INTO `rg_region` VALUES ('37425', '37387', '3', '什邡市', 'sfs', 'shifangshi', '0838', '510682', '104.173653,31.126881');
INSERT INTO `rg_region` VALUES ('37442', '37387', '3', '中江县', 'zjx', 'zhongjiangxian', '0838', '510623', '104.677831,31.03681');
INSERT INTO `rg_region` VALUES ('37488', '37387', '3', '罗江区', 'ljq', 'luojiangqu', '0838', '510604', '104.507126,31.303281');
INSERT INTO `rg_region` VALUES ('37499', '37387', '3', '绵竹市', 'mzs', 'mianzhushi', '0838', '510683', '104.200162,31.343084');
INSERT INTO `rg_region` VALUES ('37522', '36495', '2', '绵阳市', 'mys', 'mianyangshi', '0816', '510700', '104.741722,31.46402');
INSERT INTO `rg_region` VALUES ('37523', '37522', '3', '江油市', 'jys', 'jiangyoushi', '0816', '510781', '104.744431,31.776386');
INSERT INTO `rg_region` VALUES ('37567', '37522', '3', '游仙区', 'yxq', 'youxianqu', '0816', '510704', '104.770006,31.484772');
INSERT INTO `rg_region` VALUES ('37598', '37522', '3', '三台县', 'stx', 'santaixian', '0816', '510722', '105.090316,31.090909');
INSERT INTO `rg_region` VALUES ('37662', '37522', '3', '梓潼县', 'ztx', 'zitongxian', '0816', '510725', '105.16353,31.635225');
INSERT INTO `rg_region` VALUES ('37695', '37522', '3', '盐亭县', 'ytx', 'yantingxian', '0816', '510723', '105.391991,31.22318');
INSERT INTO `rg_region` VALUES ('37732', '37522', '3', '安州区', 'azq', 'anzhouqu', '0816', '510705', '104.560341,31.53894');
INSERT INTO `rg_region` VALUES ('37751', '37522', '3', '涪城区', 'fcq', 'fuchengqu', '0816', '510703', '104.740971,31.463557');
INSERT INTO `rg_region` VALUES ('37777', '37522', '3', '北川羌族自治县', 'bcqzzzx', 'beichuanqiangzuzizhixian', '0816', '510726', '104.468069,31.615863');
INSERT INTO `rg_region` VALUES ('37801', '37522', '3', '平武县', 'pwx', 'pingwuxian', '0816', '510727', '104.530555,32.407588');
INSERT INTO `rg_region` VALUES ('37827', '36495', '2', '成都市', 'cds', 'chengdushi', '028', '510100', '104.065735,30.659462');
INSERT INTO `rg_region` VALUES ('37828', '37827', '3', '彭州市', 'pzs', 'pengzhoushi', '028', '510182', '103.941173,30.985161');
INSERT INTO `rg_region` VALUES ('37849', '37827', '3', '都江堰市', 'djys', 'dujiangyanshi', '028', '510181', '103.627898,30.99114');
INSERT INTO `rg_region` VALUES ('37869', '37827', '3', '青白江区', 'qbjq', 'qingbaijiangqu', '028', '510113', '104.25494,30.883438');
INSERT INTO `rg_region` VALUES ('37881', '37827', '3', '崇州市', 'czs', 'chongzhoushi', '028', '510184', '103.671049,30.631478');
INSERT INTO `rg_region` VALUES ('37907', '37827', '3', '大邑县', 'dyx', 'dayixian', '028', '510129', '103.522397,30.586602');
INSERT INTO `rg_region` VALUES ('37928', '37827', '3', '蒲江县', 'pjx', 'pujiangxian', '028', '510131', '103.511541,30.194359');
INSERT INTO `rg_region` VALUES ('37941', '37827', '3', '简阳市', 'jys', 'jianyangshi', '028', '510185', '104.550339,30.390666');
INSERT INTO `rg_region` VALUES ('38000', '37827', '3', '金堂县', 'jtx', 'jintangxian', '028', '510121', '104.415604,30.858417');
INSERT INTO `rg_region` VALUES ('38022', '37827', '3', '新津县', 'xjx', 'xinjinxian', '028', '510132', '103.812449,30.414284');
INSERT INTO `rg_region` VALUES ('38035', '37827', '3', '邛崃市', 'qls', 'qionglaishi', '028', '510183', '103.46143,30.413271');
INSERT INTO `rg_region` VALUES ('38059', '37827', '3', '青羊区', 'qyq', 'qingyangqu', '028', '510105', '104.055731,30.667648');
INSERT INTO `rg_region` VALUES ('38074', '37827', '3', '温江区', 'wjq', 'wenjiangqu', '028', '510115', '103.836776,30.697996');
INSERT INTO `rg_region` VALUES ('38085', '37827', '3', '金牛区', 'jnq', 'jinniuqu', '028', '510106', '104.043487,30.692058');
INSERT INTO `rg_region` VALUES ('38101', '37827', '3', '双流区', 'slq', 'shuangliuqu', '028', '510116', '103.922706,30.573243');
INSERT INTO `rg_region` VALUES ('38128', '37827', '3', '武侯区', 'whq', 'wuhouqu', '028', '510107', '104.05167,30.630862');
INSERT INTO `rg_region` VALUES ('38146', '37827', '3', '郫都区', 'pdq', 'piduqu', '028', '510117', '103.887842,30.808752');
INSERT INTO `rg_region` VALUES ('38162', '37827', '3', '新都区', 'xdq', 'xinduqu', '028', '510114', '104.16022,30.824223');
INSERT INTO `rg_region` VALUES ('38176', '37827', '3', '龙泉驿区', 'lqyq', 'longquanyiqu', '028', '510112', '104.269181,30.56065');
INSERT INTO `rg_region` VALUES ('38189', '37827', '3', '成华区', 'chq', 'chenghuaqu', '028', '510108', '104.103077,30.660275');
INSERT INTO `rg_region` VALUES ('38204', '37827', '3', '锦江区', 'jjq', 'jinjiangqu', '028', '510104', '104.080989,30.657689');
INSERT INTO `rg_region` VALUES ('38221', '36495', '2', '广安市', 'gas', 'guanganshi', '0826', '511600', '106.633369,30.456398');
INSERT INTO `rg_region` VALUES ('38222', '38221', '3', '邻水县', 'lsx', 'linshuixian', '0826', '511623', '106.934968,30.334323');
INSERT INTO `rg_region` VALUES ('38268', '38221', '3', '武胜县', 'wsx', 'wushengxian', '0826', '511622', '106.292473,30.344291');
INSERT INTO `rg_region` VALUES ('38300', '38221', '3', '岳池县', 'ycx', 'yuechixian', '0826', '511621', '106.444451,30.533538');
INSERT INTO `rg_region` VALUES ('38344', '38221', '3', '广安区', 'gaq', 'guanganqu', '0826', '511602', '106.632907,30.456462');
INSERT INTO `rg_region` VALUES ('38381', '38221', '3', '前锋区', 'qfq', 'qianfengqu', '0826', '511603', '106.893277,30.4963');
INSERT INTO `rg_region` VALUES ('38395', '38221', '3', '华蓥市', 'hys', 'huayingshi', '0826', '511681', '106.777882,30.380574');
INSERT INTO `rg_region` VALUES ('38409', '36495', '2', '达州市', 'dzs', 'dazhoushi', '0818', '511700', '107.502262,31.209484');
INSERT INTO `rg_region` VALUES ('38410', '38409', '3', '大竹县', 'dzx', 'dazhuxian', '0818', '511724', '107.20742,30.736289');
INSERT INTO `rg_region` VALUES ('38462', '38409', '3', '宣汉县', 'xhx', 'xuanhanxian', '0818', '511722', '107.722254,31.355025');
INSERT INTO `rg_region` VALUES ('38517', '38409', '3', '达川区', 'dcq', 'dachuanqu', '0818', '511703', '107.507926,31.199062');
INSERT INTO `rg_region` VALUES ('38574', '38409', '3', '通川区', 'tcq', 'tongchuanqu', '0818', '511702', '107.501062,31.213522');
INSERT INTO `rg_region` VALUES ('38597', '38409', '3', '渠县', 'qx', 'quxian', '0818', '511725', '106.970746,30.836348');
INSERT INTO `rg_region` VALUES ('38658', '38409', '3', '开江县', 'kjx', 'kaijiangxian', '0818', '511723', '107.864135,31.085537');
INSERT INTO `rg_region` VALUES ('38679', '38409', '3', '万源市', 'wys', 'wanyuanshi', '0818', '511781', '108.037548,32.06777');
INSERT INTO `rg_region` VALUES ('38732', '36495', '2', '遂宁市', 'sns', 'suiningshi', '0825', '510900', '105.571331,30.513311');
INSERT INTO `rg_region` VALUES ('38733', '38732', '3', '船山区', 'csq', 'chuanshanqu', '0825', '510903', '105.582215,30.502647');
INSERT INTO `rg_region` VALUES ('38764', '38732', '3', '蓬溪县', 'pxx', 'pengxixian', '0825', '510921', '105.713699,30.774883');
INSERT INTO `rg_region` VALUES ('38798', '38732', '3', '射洪县', 'shx', 'shehongxian', '0825', '510922', '105.381849,30.868752');
INSERT INTO `rg_region` VALUES ('38831', '38732', '3', '安居区', 'ajq', 'anjuqu', '0825', '510904', '105.459383,30.346121');
INSERT INTO `rg_region` VALUES ('38855', '38732', '3', '大英县', 'dyx', 'dayingxian', '0825', '510923', '105.252187,30.581571');
INSERT INTO `rg_region` VALUES ('38867', '36495', '2', '资阳市', 'zys', 'ziyangshi', '0832', '512000', '104.641917,30.122211');
INSERT INTO `rg_region` VALUES ('38868', '38867', '3', '乐至县', 'lzx', 'lezhixian', '0832', '512022', '105.031142,30.275619');
INSERT INTO `rg_region` VALUES ('38894', '38867', '3', '安岳县', 'ayx', 'anyuexian', '0832', '512021', '105.336764,30.099206');
INSERT INTO `rg_region` VALUES ('38964', '38867', '3', '雁江区', 'yjq', 'yanjiangqu', '0832', '512002', '104.642338,30.121686');
INSERT INTO `rg_region` VALUES ('38992', '36495', '2', '眉山市', 'mss', 'meishanshi', '1833', '511400', '103.831788,30.048318');
INSERT INTO `rg_region` VALUES ('38993', '38992', '3', '丹棱县', 'dlx', 'danlengxian', '1833', '511424', '103.518333,30.012751');
INSERT INTO `rg_region` VALUES ('39001', '38992', '3', '仁寿县', 'rsx', 'renshouxian', '1833', '511421', '104.147646,29.996721');
INSERT INTO `rg_region` VALUES ('39062', '38992', '3', '洪雅县', 'hyx', 'hongyaxian', '1833', '511423', '103.375006,29.904867');
INSERT INTO `rg_region` VALUES ('39078', '38992', '3', '东坡区', 'dpq', 'dongpoqu', '1833', '511402', '103.831553,30.048128');
INSERT INTO `rg_region` VALUES ('39105', '38992', '3', '彭山区', 'psq', 'pengshanqu', '1833', '511403', '103.8701,30.192298');
INSERT INTO `rg_region` VALUES ('39119', '38992', '3', '青神县', 'qsx', 'qingshenxian', '1833', '511425', '103.846131,29.831469');
INSERT INTO `rg_region` VALUES ('39130', '36495', '2', '内江市', 'njs', 'neijiangshi', '1832', '511000', '105.066138,29.58708');
INSERT INTO `rg_region` VALUES ('39131', '39130', '3', '东兴区', 'dxq', 'dongxingqu', '1832', '511011', '105.067203,29.600107');
INSERT INTO `rg_region` VALUES ('39161', '39130', '3', '资中县', 'zzx', 'zizhongxian', '1832', '511025', '104.852463,29.775295');
INSERT INTO `rg_region` VALUES ('39195', '39130', '3', '威远县', 'wyx', 'weiyuanxian', '1832', '511024', '104.668327,29.52686');
INSERT INTO `rg_region` VALUES ('39216', '39130', '3', '隆昌市', 'lcs', 'longchangshi', '1832', '511083', '105.288074,29.338162');
INSERT INTO `rg_region` VALUES ('39236', '39130', '3', '市中区', 'szq', 'shizhongqu', '1832', '511002', '105.065467,29.585265');
INSERT INTO `rg_region` VALUES ('39258', '36495', '2', '乐山市', 'lss', 'leshanshi', '0833', '511100', '103.761263,29.582024');
INSERT INTO `rg_region` VALUES ('39259', '39258', '3', '五通桥区', 'wtqq', 'wutongqiaoqu', '0833', '511112', '103.816837,29.406186');
INSERT INTO `rg_region` VALUES ('39272', '39258', '3', '沙湾区', 'swq', 'shawanqu', '0833', '511111', '103.549961,29.416536');
INSERT INTO `rg_region` VALUES ('39287', '39258', '3', '夹江县', 'jjx', 'jiajiangxian', '0833', '511126', '103.578862,29.741019');
INSERT INTO `rg_region` VALUES ('39310', '39258', '3', '井研县', 'jyx', 'jingyanxian', '0833', '511124', '104.06885,29.651645');
INSERT INTO `rg_region` VALUES ('39338', '39258', '3', '峨边彝族自治县', 'ebyzzzx', 'ebianyizuzizhixian', '0833', '511132', '103.262148,29.230271');
INSERT INTO `rg_region` VALUES ('39358', '39258', '3', '金口河区', 'jkhq', 'jinkouhequ', '0833', '511113', '103.077831,29.24602');
INSERT INTO `rg_region` VALUES ('39365', '39258', '3', '犍为县', 'jwx', 'jianweixian', '0833', '511123', '103.944266,29.209782');
INSERT INTO `rg_region` VALUES ('39396', '39258', '3', '沐川县', 'mcx', 'muchuanxian', '0833', '511129', '103.90211,28.956338');
INSERT INTO `rg_region` VALUES ('39416', '39258', '3', '市中区', 'szq', 'shizhongqu', '0833', '511102', '103.75539,29.588327');
INSERT INTO `rg_region` VALUES ('39449', '39258', '3', '马边彝族自治县', 'mbyzzzx', 'mabianyizuzizhixian', '0833', '511133', '103.546851,28.838933');
INSERT INTO `rg_region` VALUES ('39470', '39258', '3', '峨眉山市', 'emss', 'emeishanshi', '0833', '511181', '103.492488,29.597478');
INSERT INTO `rg_region` VALUES ('39489', '36495', '2', '自贡市', 'zgs', 'zigongshi', '0813', '510300', '104.773447,29.352765');
INSERT INTO `rg_region` VALUES ('39490', '39489', '3', '大安区', 'daq', 'daanqu', '0813', '510304', '104.783229,29.367136');
INSERT INTO `rg_region` VALUES ('39507', '39489', '3', '贡井区', 'gjq', 'gongjingqu', '0813', '510303', '104.714372,29.345675');
INSERT INTO `rg_region` VALUES ('39521', '39489', '3', '荣县', 'rx', 'rongxian', '0813', '510321', '104.423932,29.454851');
INSERT INTO `rg_region` VALUES ('39549', '39489', '3', '自流井区', 'zljq', 'ziliujingqu', '0813', '510302', '104.778188,29.343231');
INSERT INTO `rg_region` VALUES ('39563', '39489', '3', '富顺县', 'fsx', 'fushunxian', '0813', '510322', '104.984256,29.181282');
INSERT INTO `rg_region` VALUES ('39590', '39489', '3', '沿滩区', 'ytq', 'yantanqu', '0813', '510311', '104.876417,29.272521');
INSERT INTO `rg_region` VALUES ('39604', '36495', '2', '泸州市', 'lzs', 'luzhoushi', '0830', '510500', '105.443348,28.889138');
INSERT INTO `rg_region` VALUES ('39605', '39604', '3', '龙马潭区', 'lmtq', 'longmatanqu', '0830', '510504', '105.435228,28.897572');
INSERT INTO `rg_region` VALUES ('39619', '39604', '3', '叙永县', 'xyx', 'xuyongxian', '0830', '510524', '105.437775,28.167919');
INSERT INTO `rg_region` VALUES ('39645', '39604', '3', '纳溪区', 'nxq', 'naxiqu', '0830', '510503', '105.37721,28.77631');
INSERT INTO `rg_region` VALUES ('39661', '39604', '3', '泸县', 'lx', 'luxian', '0830', '510521', '105.376335,29.151288');
INSERT INTO `rg_region` VALUES ('39684', '39604', '3', '古蔺县', 'glx', 'gulinxian', '0830', '510525', '105.813359,28.03948');
INSERT INTO `rg_region` VALUES ('39711', '39604', '3', '江阳区', 'jyq', 'jiangyangqu', '0830', '510502', '105.445131,28.882889');
INSERT INTO `rg_region` VALUES ('39733', '39604', '3', '合江县', 'hjx', 'hejiangxian', '0830', '510522', '105.834098,28.810325');
INSERT INTO `rg_region` VALUES ('39762', '36495', '2', '宜宾市', 'ybs', 'yibinshi', '0831', '511500', '104.630825,28.760189');
INSERT INTO `rg_region` VALUES ('39763', '39762', '3', '高县', 'gx', 'gaoxian', '0831', '511525', '104.519187,28.435676');
INSERT INTO `rg_region` VALUES ('39783', '39762', '3', '筠连县', 'ylx', 'yunlianxian', '0831', '511527', '104.507848,28.162017');
INSERT INTO `rg_region` VALUES ('39802', '39762', '3', '江安县', 'jax', 'jianganxian', '0831', '511523', '105.068697,28.728102');
INSERT INTO `rg_region` VALUES ('39821', '39762', '3', '长宁县', 'cnx', 'changningxian', '0831', '511524', '104.921116,28.577271');
INSERT INTO `rg_region` VALUES ('39840', '39762', '3', '兴文县', 'xwx', 'xingwenxian', '0831', '511528', '105.236549,28.302988');
INSERT INTO `rg_region` VALUES ('39856', '39762', '3', '珙县', 'gx', 'gongxian', '0831', '511526', '104.712268,28.449041');
INSERT INTO `rg_region` VALUES ('39874', '39762', '3', '南溪区', 'nxq', 'nanxiqu', '0831', '511503', '104.981133,28.839806');
INSERT INTO `rg_region` VALUES ('39890', '39762', '3', '屏山县', 'psx', 'pingshanxian', '0831', '511529', '104.162617,28.64237');
INSERT INTO `rg_region` VALUES ('39906', '39762', '3', '翠屏区', 'cpq', 'cuipingqu', '0831', '511502', '104.630231,28.760179');
INSERT INTO `rg_region` VALUES ('39933', '39762', '3', '叙州区', 'xzq', 'xuzhouqu', '0831', '511504', '104.541489,28.695678');
INSERT INTO `rg_region` VALUES ('39958', '36495', '2', '凉山彝族自治州', 'lsyzzzz', 'liangshanyizuzizhizhou', '0834', '513400', '102.258746,27.886762');
INSERT INTO `rg_region` VALUES ('39959', '39958', '3', '昭觉县', 'zjx', 'zhaojuexian', '0834', '513431', '102.843991,28.010554');
INSERT INTO `rg_region` VALUES ('40007', '39958', '3', '木里藏族自治县', 'mlczzzx', 'mulicangzuzizhixian', '0834', '513422', '101.280184,27.926859');
INSERT INTO `rg_region` VALUES ('40037', '39958', '3', '甘洛县', 'glx', 'ganluoxian', '0834', '513435', '102.775924,28.977094');
INSERT INTO `rg_region` VALUES ('40066', '39958', '3', '美姑县', 'mgx', 'moiguxian', '0834', '513436', '103.132007,28.327946');
INSERT INTO `rg_region` VALUES ('40103', '39958', '3', '雷波县', 'lbx', 'leiboxian', '0834', '513437', '103.571584,28.262946');
INSERT INTO `rg_region` VALUES ('40152', '39958', '3', '盐源县', 'yyx', 'yanyuanxian', '0834', '513423', '101.508909,27.423415');
INSERT INTO `rg_region` VALUES ('40183', '39958', '3', '冕宁县', 'mnx', 'mianningxian', '0834', '513433', '102.170046,28.550844');
INSERT INTO `rg_region` VALUES ('40222', '39958', '3', '布拖县', 'btx', 'butuoxian', '0834', '513429', '102.808801,27.709062');
INSERT INTO `rg_region` VALUES ('40253', '39958', '3', '越西县', 'yxx', 'yuexixian', '0834', '513434', '102.508875,28.639632');
INSERT INTO `rg_region` VALUES ('40294', '39958', '3', '金阳县', 'jyx', 'jinyangxian', '0834', '513430', '103.248704,27.695916');
INSERT INTO `rg_region` VALUES ('40329', '39958', '3', '西昌市', 'xcs', 'xichangshi', '0834', '513401', '102.258758,27.885786');
INSERT INTO `rg_region` VALUES ('40373', '39958', '3', '普格县', 'pgx', 'pugexian', '0834', '513428', '102.541082,27.376828');
INSERT INTO `rg_region` VALUES ('40408', '39958', '3', '喜德县', 'xdx', 'xidexian', '0834', '513432', '102.412342,28.305486');
INSERT INTO `rg_region` VALUES ('40433', '39958', '3', '会东县', 'hdx', 'huidongxian', '0834', '513426', '102.578985,26.630713');
INSERT INTO `rg_region` VALUES ('40455', '39958', '3', '会理县', 'hlx', 'huilixian', '0834', '513425', '102.249548,26.658702');
INSERT INTO `rg_region` VALUES ('40488', '39958', '3', '德昌县', 'dcx', 'dechangxian', '0834', '513424', '102.178845,27.403827');
INSERT INTO `rg_region` VALUES ('40509', '39958', '3', '宁南县', 'nnx', 'ningnanxian', '0834', '513427', '102.757374,27.065205');
INSERT INTO `rg_region` VALUES ('40535', '36495', '2', '攀枝花市', 'pzhs', 'panzhihuashi', '0812', '510400', '101.716007,26.580446');
INSERT INTO `rg_region` VALUES ('40536', '40535', '3', '仁和区', 'rhq', 'renhequ', '0812', '510411', '101.737916,26.497185');
INSERT INTO `rg_region` VALUES ('40552', '40535', '3', '米易县', 'myx', 'miyixian', '0812', '510421', '102.109877,26.887474');
INSERT INTO `rg_region` VALUES ('40565', '40535', '3', '东区', 'dq', 'dongqu', '0812', '510402', '101.715134,26.580887');
INSERT INTO `rg_region` VALUES ('40576', '40535', '3', '西区', 'xq', 'xiqu', '0812', '510403', '101.637969,26.596776');
INSERT INTO `rg_region` VALUES ('40584', '40535', '3', '盐边县', 'ybx', 'yanbianxian', '0812', '510422', '101.851848,26.677619');
INSERT INTO `rg_region` VALUES ('40601', '36495', '2', '阿坝藏族羌族自治州', 'abczqzzzz', 'abacangzuqiangzuzizhizhou', '0837', '513200', '102.221374,31.899792');
INSERT INTO `rg_region` VALUES ('40602', '40601', '3', '红原县', 'hyx', 'hongyuanxian', '0837', '513233', '102.544906,32.793902');
INSERT INTO `rg_region` VALUES ('40614', '40601', '3', '阿坝县', 'abx', 'abaxian', '0837', '513231', '101.700985,32.904223');
INSERT INTO `rg_region` VALUES ('40636', '40601', '3', '九寨沟县', 'jzgx', 'jiuzhaigouxian', '0837', '513225', '104.236344,33.262097');
INSERT INTO `rg_region` VALUES ('40654', '40601', '3', '马尔康市', 'moks', 'maorkangshi', '0837', '513201', '102.221187,31.899761');
INSERT INTO `rg_region` VALUES ('40669', '40601', '3', '若尔盖县', 'rogx', 'ruoorgaixian', '0837', '513232', '102.963726,33.575934');
INSERT INTO `rg_region` VALUES ('40689', '40601', '3', '黑水县', 'hsx', 'heishuixian', '0837', '513228', '102.990805,32.061721');
INSERT INTO `rg_region` VALUES ('40707', '40601', '3', '理县', 'lx', 'lixian', '0837', '513222', '103.165486,31.436764');
INSERT INTO `rg_region` VALUES ('40721', '40601', '3', '金川县', 'jcx', 'jinchuanxian', '0837', '513226', '102.064647,31.476356');
INSERT INTO `rg_region` VALUES ('40744', '40601', '3', '汶川县', 'wcx', 'wenchuanxian', '0837', '513221', '103.580675,31.47463');
INSERT INTO `rg_region` VALUES ('40757', '40601', '3', '小金县', 'xjx', 'xiaojinxian', '0837', '513227', '102.363193,30.999016');
INSERT INTO `rg_region` VALUES ('40779', '40601', '3', '茂县', 'mx', 'maoxian', '0837', '513223', '103.850684,31.680407');
INSERT INTO `rg_region` VALUES ('40801', '40601', '3', '松潘县', 'spx', 'songpanxian', '0837', '513224', '103.599177,32.63838');
INSERT INTO `rg_region` VALUES ('40828', '40601', '3', '壤塘县', 'rtx', 'rangtangxian', '0837', '513230', '100.979136,32.264887');
INSERT INTO `rg_region` VALUES ('40841', '36495', '2', '雅安市', 'yas', 'yaanshi', '0835', '511800', '103.001033,29.987722');
INSERT INTO `rg_region` VALUES ('40842', '40841', '3', '宝兴县', 'bxx', 'baoxingxian', '0835', '511827', '102.813377,30.369026');
INSERT INTO `rg_region` VALUES ('40852', '40841', '3', '天全县', 'tqx', 'tianquanxian', '0835', '511825', '102.763462,30.059955');
INSERT INTO `rg_region` VALUES ('40868', '40841', '3', '芦山县', 'lsx', 'lushanxian', '0835', '511826', '102.924016,30.152907');
INSERT INTO `rg_region` VALUES ('40878', '40841', '3', '荥经县', 'xjx', 'xingjingxian', '0835', '511822', '102.844674,29.795529');
INSERT INTO `rg_region` VALUES ('40900', '40841', '3', '雨城区', 'ycq', 'yuchengqu', '0835', '511802', '103.003398,29.981831');
INSERT INTO `rg_region` VALUES ('40923', '40841', '3', '汉源县', 'hyx', 'hanyuanxian', '0835', '511823', '102.677145,29.349915');
INSERT INTO `rg_region` VALUES ('40954', '40841', '3', '石棉县', 'smx', 'shimianxian', '0835', '511824', '102.35962,29.234063');
INSERT INTO `rg_region` VALUES ('40972', '40841', '3', '名山区', 'msq', 'mingshanqu', '0835', '511803', '103.112214,30.084718');
INSERT INTO `rg_region` VALUES ('40993', '36495', '2', '甘孜藏族自治州', 'gzczzzz', 'ganzicangzuzizhizhou', '0836', '513300', '101.963815,30.050663');
INSERT INTO `rg_region` VALUES ('40994', '40993', '3', '德格县', 'dgx', 'degexian', '0836', '513330', '98.57999,31.806729');
INSERT INTO `rg_region` VALUES ('41021', '40993', '3', '甘孜县', 'gzx', 'ganzixian', '0836', '513328', '99.991753,31.61975');
INSERT INTO `rg_region` VALUES ('41044', '40993', '3', '石渠县', 'sqx', 'shiquxian', '0836', '513332', '98.100887,32.975302');
INSERT INTO `rg_region` VALUES ('41067', '40993', '3', '新龙县', 'xlx', 'xinlongxian', '0836', '513329', '100.312094,30.93896');
INSERT INTO `rg_region` VALUES ('41087', '40993', '3', '理塘县', 'ltx', 'litangxian', '0836', '513334', '100.269862,29.991807');
INSERT INTO `rg_region` VALUES ('41112', '40993', '3', '白玉县', 'byx', 'baiyuxian', '0836', '513331', '98.824343,31.208805');
INSERT INTO `rg_region` VALUES ('41130', '40993', '3', '雅江县', 'yjx', 'yajiangxian', '0836', '513325', '101.015735,30.03225');
INSERT INTO `rg_region` VALUES ('41148', '40993', '3', '炉霍县', 'lhx', 'luhuoxian', '0836', '513327', '100.679495,31.392674');
INSERT INTO `rg_region` VALUES ('41165', '40993', '3', '道孚县', 'dfx', 'daofuxian', '0836', '513326', '101.123327,30.978767');
INSERT INTO `rg_region` VALUES ('41188', '40993', '3', '康定市', 'kds', 'kangdingshi', '0836', '513301', '101.964057,30.050738');
INSERT INTO `rg_region` VALUES ('41209', '40993', '3', '巴塘县', 'btx', 'batangxian', '0836', '513335', '99.109037,30.005723');
INSERT INTO `rg_region` VALUES ('41229', '40993', '3', '稻城县', 'dcx', 'daochengxian', '0836', '513337', '100.296689,29.037544');
INSERT INTO `rg_region` VALUES ('41244', '40993', '3', '乡城县', 'xcx', 'xiangchengxian', '0836', '513336', '99.799943,28.930855');
INSERT INTO `rg_region` VALUES ('41257', '40993', '3', '九龙县', 'jlx', 'jiulongxian', '0836', '513324', '101.506942,29.001975');
INSERT INTO `rg_region` VALUES ('41276', '40993', '3', '得荣县', 'drx', 'derongxian', '0836', '513338', '99.288036,28.71134');
INSERT INTO `rg_region` VALUES ('41289', '40993', '3', '丹巴县', 'dbx', 'danbaxian', '0836', '513323', '101.886125,30.877083');
INSERT INTO `rg_region` VALUES ('41305', '40993', '3', '色达县', 'sdx', 'sedaxian', '0836', '513333', '100.331657,32.268777');
INSERT INTO `rg_region` VALUES ('41323', '40993', '3', '泸定县', 'ldx', 'ludingxian', '0836', '513322', '102.233225,29.912482');
INSERT INTO `rg_region` VALUES ('41336', '0', '1', '吉林省', 'jls', 'jilinsheng', '', '220000', '125.3245,43.886841');
INSERT INTO `rg_region` VALUES ('41337', '41336', '2', '长春市', 'ccs', 'changchunshi', '0431', '220100', '125.3245,43.886841');
INSERT INTO `rg_region` VALUES ('41338', '41337', '3', '榆树市', 'yss', 'yushushi', '0431', '220182', '126.550107,44.827642');
INSERT INTO `rg_region` VALUES ('41367', '41337', '3', '德惠市', 'dhs', 'dehuishi', '0431', '220183', '125.703327,44.533909');
INSERT INTO `rg_region` VALUES ('41386', '41337', '3', '双阳区', 'syq', 'shuangyangqu', '0431', '220112', '125.659018,43.525168');
INSERT INTO `rg_region` VALUES ('41395', '41337', '3', '农安县', 'nax', 'nonganxian', '0431', '220122', '125.175287,44.431258');
INSERT INTO `rg_region` VALUES ('41418', '41337', '3', '朝阳区', 'cyq', 'chaoyangqu', '0431', '220104', '125.318042,43.86491');
INSERT INTO `rg_region` VALUES ('41432', '41337', '3', '绿园区', 'lyq', 'lǜyuanqu', '0431', '220106', '125.272467,43.892177');
INSERT INTO `rg_region` VALUES ('41445', '41337', '3', '宽城区', 'kcq', 'kuanchengqu', '0431', '220103', '125.342828,43.903823');
INSERT INTO `rg_region` VALUES ('41462', '41337', '3', '九台区', 'jtq', 'jiutaiqu', '0431', '220113', '125.844682,44.157155');
INSERT INTO `rg_region` VALUES ('41481', '41337', '3', '二道区', 'edq', 'erdaoqu', '0431', '220105', '125.384727,43.870824');
INSERT INTO `rg_region` VALUES ('41494', '41337', '3', '南关区', 'ngq', 'nanguanqu', '0431', '220102', '125.337237,43.890235');
INSERT INTO `rg_region` VALUES ('41514', '41336', '2', '松原市', 'sys', 'songyuanshi', '0438', '220700', '124.823608,45.118243');
INSERT INTO `rg_region` VALUES ('41515', '41514', '3', '扶余市', 'fys', 'fuyushi', '0438', '220781', '126.042758,44.986199');
INSERT INTO `rg_region` VALUES ('41537', '41514', '3', '前郭尔罗斯蒙古族自治县', 'qgolsmgzzzx', 'qianguoorluosimengguzuzizhixian', '0438', '220721', '124.826808,45.116288');
INSERT INTO `rg_region` VALUES ('41575', '41514', '3', '宁江区', 'njq', 'ningjiangqu', '0438', '220702', '124.827851,45.176498');
INSERT INTO `rg_region` VALUES ('41607', '41514', '3', '乾安县', 'qax', 'qiananxian', '0438', '220723', '124.024361,45.006846');
INSERT INTO `rg_region` VALUES ('41624', '41514', '3', '长岭县', 'clx', 'changlingxian', '0438', '220722', '123.985184,44.276579');
INSERT INTO `rg_region` VALUES ('41657', '41336', '2', '白城市', 'bcs', 'baichengshi', '0436', '220800', '122.841114,45.619026');
INSERT INTO `rg_region` VALUES ('41658', '41657', '3', '洮南市', 'tns', 'taonanshi', '0436', '220881', '122.783779,45.339113');
INSERT INTO `rg_region` VALUES ('41686', '41657', '3', '大安市', 'das', 'daanshi', '0436', '220882', '124.291512,45.507648');
INSERT INTO `rg_region` VALUES ('41722', '41657', '3', '通榆县', 'tyx', 'tongyuxian', '0436', '220822', '123.088543,44.80915');
INSERT INTO `rg_region` VALUES ('41745', '41657', '3', '洮北区', 'tbq', 'taobeiqu', '0436', '220802', '122.842499,45.619253');
INSERT INTO `rg_region` VALUES ('41774', '41657', '3', '镇赉县', 'zlx', 'zhenlaixian', '0436', '220821', '123.202246,45.846089');
INSERT INTO `rg_region` VALUES ('41794', '41336', '2', '吉林市', 'jls', 'jilinshi', '0432', '220200', '126.55302,43.843577');
INSERT INTO `rg_region` VALUES ('41795', '41794', '3', '舒兰市', 'sls', 'shulanshi', '0432', '220283', '126.947813,44.410906');
INSERT INTO `rg_region` VALUES ('41816', '41794', '3', '丰满区', 'fmq', 'fengmanqu', '0432', '220211', '126.560759,43.816594');
INSERT INTO `rg_region` VALUES ('41829', '41794', '3', '船营区', 'cyq', 'chuanyingqu', '0432', '220204', '126.55239,43.843804');
INSERT INTO `rg_region` VALUES ('41845', '41794', '3', '桦甸市', 'hds', 'huadianshi', '0432', '220282', '126.745445,42.972093');
INSERT INTO `rg_region` VALUES ('41860', '41794', '3', '龙潭区', 'ltq', 'longtanqu', '0432', '220203', '126.561429,43.909755');
INSERT INTO `rg_region` VALUES ('41881', '41794', '3', '蛟河市', 'jhs', 'jiaoheshi', '0432', '220281', '127.342739,43.720579');
INSERT INTO `rg_region` VALUES ('41899', '41794', '3', '昌邑区', 'cyq', 'changyiqu', '0432', '220202', '126.570766,43.851118');
INSERT INTO `rg_region` VALUES ('41922', '41794', '3', '永吉县', 'yjx', 'yongjixian', '0432', '220221', '126.501622,43.667416');
INSERT INTO `rg_region` VALUES ('41933', '41794', '3', '磐石市', 'pss', 'panshishi', '0432', '220284', '126.059929,42.942476');
INSERT INTO `rg_region` VALUES ('41952', '41336', '2', '辽源市', 'lys', 'liaoyuanshi', '0437', '220400', '125.145349,42.902692');
INSERT INTO `rg_region` VALUES ('41953', '41952', '3', '西安区', 'xaq', 'xianqu', '0437', '220403', '125.151424,42.920415');
INSERT INTO `rg_region` VALUES ('41956', '41952', '3', '龙山区', 'lsq', 'longshanqu', '0437', '220402', '125.145164,42.902702');
INSERT INTO `rg_region` VALUES ('41962', '41952', '3', '东辽县', 'dlx', 'dongliaoxian', '0437', '220422', '124.991995,42.927724');
INSERT INTO `rg_region` VALUES ('41976', '41952', '3', '东丰县', 'dfx', 'dongfengxian', '0437', '220421', '125.529623,42.675228');
INSERT INTO `rg_region` VALUES ('41991', '41336', '2', '四平市', 'sps', 'sipingshi', '0434', '220300', '124.370785,43.170344');
INSERT INTO `rg_region` VALUES ('41992', '41991', '3', '铁东区', 'tdq', 'tiodongqu', '0434', '220303', '124.388464,43.16726');
INSERT INTO `rg_region` VALUES ('42006', '41991', '3', '双辽市', 'sls', 'shuangliaoshi', '0434', '220382', '123.505283,43.518275');
INSERT INTO `rg_region` VALUES ('42028', '41991', '3', '公主岭市', 'gzls', 'gongzhulingshi', '0434', '220381', '124.817588,43.509474');
INSERT INTO `rg_region` VALUES ('42067', '41991', '3', '伊通满族自治县', 'ytmzzzx', 'yitongmanzuzizhixian', '0434', '220323', '125.303124,43.345464');
INSERT INTO `rg_region` VALUES ('42083', '41991', '3', '梨树县', 'lsx', 'lishuxian', '0434', '220322', '124.335802,43.30831');
INSERT INTO `rg_region` VALUES ('42106', '41991', '3', '铁西区', 'txq', 'tioxiqu', '0434', '220302', '124.360894,43.176263');
INSERT INTO `rg_region` VALUES ('42115', '41336', '2', '延边朝鲜族自治州', 'ybzxzzzz', 'yanbianzhaoxianzuzizhizhou', '1433', '222400', '129.513228,42.904823');
INSERT INTO `rg_region` VALUES ('42116', '42115', '3', '敦化市', 'dhs', 'dunhuashi', '1433', '222403', '128.22986,43.366921');
INSERT INTO `rg_region` VALUES ('42143', '42115', '3', '珲春市', 'hcs', 'hunchunshi', '1433', '222404', '130.365787,42.871057');
INSERT INTO `rg_region` VALUES ('42159', '42115', '3', '和龙市', 'hls', 'helongshi', '1433', '222406', '129.008748,42.547004');
INSERT INTO `rg_region` VALUES ('42174', '42115', '3', '图们市', 'tms', 'tumenshi', '1433', '222402', '129.846701,42.966621');
INSERT INTO `rg_region` VALUES ('42182', '42115', '3', '汪清县', 'wqx', 'wangqingxian', '1433', '222424', '129.766161,43.315426');
INSERT INTO `rg_region` VALUES ('42203', '42115', '3', '延吉市', 'yjs', 'yanjishi', '1433', '222401', '129.51579,42.906964');
INSERT INTO `rg_region` VALUES ('42218', '42115', '3', '龙井市', 'ljs', 'longjingshi', '1433', '222405', '129.425747,42.771029');
INSERT INTO `rg_region` VALUES ('42230', '42115', '3', '安图县', 'atx', 'antuxian', '1433', '222426', '128.901865,43.110994');
INSERT INTO `rg_region` VALUES ('42246', '41336', '2', '白山市', 'bss', 'baishanshi', '0439', '220600', '126.427839,41.942505');
INSERT INTO `rg_region` VALUES ('42247', '42246', '3', '江源区', 'jyq', 'jiangyuanqu', '0439', '220605', '126.584229,42.048109');
INSERT INTO `rg_region` VALUES ('42258', '42246', '3', '长白朝鲜族自治县', 'cbzxzzzx', 'changbaizhaoxianzuzizhixian', '0439', '220623', '128.203384,41.419361');
INSERT INTO `rg_region` VALUES ('42267', '42246', '3', '靖宇县', 'jyx', 'jingyuxian', '0439', '220622', '126.808386,42.389689');
INSERT INTO `rg_region` VALUES ('42276', '42246', '3', '抚松县', 'fsx', 'fusongxian', '0439', '220621', '127.273796,42.332643');
INSERT INTO `rg_region` VALUES ('42294', '42246', '3', '浑江区', 'hjq', 'hunjiangqu', '0439', '220602', '126.428035,41.943065');
INSERT INTO `rg_region` VALUES ('42307', '42246', '3', '临江市', 'ljs', 'linjiangshi', '0439', '220681', '126.919296,41.810689');
INSERT INTO `rg_region` VALUES ('42323', '41336', '2', '通化市', 'ths', 'tonghuashi', '0435', '220500', '125.936501,41.721177');
INSERT INTO `rg_region` VALUES ('42324', '42323', '3', '通化县', 'thx', 'tonghuaxian', '0435', '220521', '125.753121,41.677918');
INSERT INTO `rg_region` VALUES ('42342', '42323', '3', '东昌区', 'dcq', 'dongchangqu', '0435', '220502', '125.936716,41.721233');
INSERT INTO `rg_region` VALUES ('42354', '42323', '3', '二道江区', 'edjq', 'erdaojiangqu', '0435', '220503', '126.045987,41.777564');
INSERT INTO `rg_region` VALUES ('42361', '42323', '3', '柳河县', 'lhx', 'liuhexian', '0435', '220524', '125.740536,42.281484');
INSERT INTO `rg_region` VALUES ('42377', '42323', '3', '辉南县', 'hnx', 'huinanxian', '0435', '220523', '126.042821,42.683459');
INSERT INTO `rg_region` VALUES ('42390', '42323', '3', '梅河口市', 'mhks', 'meihekoushi', '0435', '220581', '125.687336,42.530002');
INSERT INTO `rg_region` VALUES ('42415', '42323', '3', '集安市', 'jas', 'jianshi', '0435', '220582', '126.186204,41.126276');
INSERT INTO `rg_region` VALUES ('42430', '0', '1', '天津市', 'tjs', 'tianjinshi', '022', '120000', '117.190182,39.125596');
INSERT INTO `rg_region` VALUES ('42431', '42430', '2', '天津城区', 'tjcq', 'tianjinchengqu', '022', '120100', '117.190182,39.125596');
INSERT INTO `rg_region` VALUES ('42432', '42431', '3', '津南区', 'jnq', 'jinnanqu', '022', '120112', '117.382549,38.989577');
INSERT INTO `rg_region` VALUES ('42448', '42431', '3', '和平区', 'hpq', 'hepingqu', '022', '120101', '117.195907,39.118327');
INSERT INTO `rg_region` VALUES ('42455', '42431', '3', '河东区', 'hdq', 'hedongqu', '022', '120102', '117.226568,39.122125');
INSERT INTO `rg_region` VALUES ('42468', '42431', '3', '东丽区', 'dlq', 'dongliqu', '022', '120110', '117.313967,39.087764');
INSERT INTO `rg_region` VALUES ('42486', '42431', '3', '宝坻区', 'bdq', 'baodiqu', '022', '120115', '117.308094,39.716965');
INSERT INTO `rg_region` VALUES ('42517', '42431', '3', '河北区', 'hbq', 'hebeiqu', '022', '120105', '117.201569,39.156632');
INSERT INTO `rg_region` VALUES ('42528', '42431', '3', '河西区', 'hxq', 'hexiqu', '022', '120103', '117.217536,39.101897');
INSERT INTO `rg_region` VALUES ('42542', '42431', '3', '静海区', 'jhq', 'jinghaiqu', '022', '120118', '116.925304,38.935671');
INSERT INTO `rg_region` VALUES ('42564', '42431', '3', '滨海新区', 'bhxq', 'binhaixinqu', '022', '120116', '117.654173,39.032846');
INSERT INTO `rg_region` VALUES ('42606', '42431', '3', '蓟州区', 'jzq', 'jizhouqu', '022', '120119', '117.407449,40.045342');
INSERT INTO `rg_region` VALUES ('42634', '42431', '3', '武清区', 'wqq', 'wuqingqu', '022', '120114', '117.057959,39.376925');
INSERT INTO `rg_region` VALUES ('42673', '42431', '3', '南开区', 'nkq', 'nankaiqu', '022', '120104', '117.164143,39.120474');
INSERT INTO `rg_region` VALUES ('42686', '42431', '3', '西青区', 'xqq', 'xiqingqu', '022', '120111', '117.012247,39.139446');
INSERT INTO `rg_region` VALUES ('42700', '42431', '3', '宁河区', 'nhq', 'ninghequ', '022', '120117', '117.82828,39.328886');
INSERT INTO `rg_region` VALUES ('42720', '42431', '3', '红桥区', 'hqq', 'hongqiaoqu', '022', '120106', '117.163301,39.175066');
INSERT INTO `rg_region` VALUES ('42731', '42431', '3', '北辰区', 'bcq', 'beichenqu', '022', '120113', '117.13482,39.225555');
INSERT INTO `rg_region` VALUES ('42753', '0', '1', '云南省', 'yns', 'yunnansheng', '', '530000', '102.712251,25.040609');
INSERT INTO `rg_region` VALUES ('42754', '42753', '2', '昭通市', 'zts', 'zhaotongshi', '0870', '530600', '103.717216,27.336999');
INSERT INTO `rg_region` VALUES ('42755', '42754', '3', '水富市', 'sfs', 'shuifushi', '0870', '530681', '104.415376,28.629688');
INSERT INTO `rg_region` VALUES ('42760', '42754', '3', '绥江县', 'sjx', 'suijiangxian', '0870', '530626', '103.961095,28.599953');
INSERT INTO `rg_region` VALUES ('42766', '42754', '3', '永善县', 'ysx', 'yongshanxian', '0870', '530625', '103.63732,28.231526');
INSERT INTO `rg_region` VALUES ('42782', '42754', '3', '大关县', 'dgx', 'daguanxian', '0870', '530624', '103.891608,27.747114');
INSERT INTO `rg_region` VALUES ('42792', '42754', '3', '威信县', 'wxx', 'weixinxian', '0870', '530629', '105.04869,27.843381');
INSERT INTO `rg_region` VALUES ('42803', '42754', '3', '巧家县', 'qjx', 'qiaojiaxian', '0870', '530622', '102.929284,26.9117');
INSERT INTO `rg_region` VALUES ('42820', '42754', '3', '盐津县', 'yjx', 'yanjinxian', '0870', '530623', '104.23506,28.106923');
INSERT INTO `rg_region` VALUES ('42831', '42754', '3', '昭阳区', 'zyq', 'zhaoyangqu', '0870', '530602', '103.717267,27.336636');
INSERT INTO `rg_region` VALUES ('42852', '42754', '3', '彝良县', 'ylx', 'yiliangxian', '0870', '530628', '104.048492,27.627425');
INSERT INTO `rg_region` VALUES ('42868', '42754', '3', '镇雄县', 'zxx', 'zhenxiongxian', '0870', '530627', '104.873055,27.436267');
INSERT INTO `rg_region` VALUES ('42897', '42754', '3', '鲁甸县', 'ldx', 'ludianxian', '0870', '530621', '103.549333,27.191637');
INSERT INTO `rg_region` VALUES ('42910', '42753', '2', '西双版纳傣族自治州', 'xsbndzzzz', 'xishuangbannadaizuzizhizhou', '0691', '532800', '100.797941,22.001724');
INSERT INTO `rg_region` VALUES ('42911', '42910', '3', '景洪市', 'jhs', 'jinghongshi', '0691', '532801', '100.797947,22.002087');
INSERT INTO `rg_region` VALUES ('42931', '42910', '3', '勐腊县', 'mxx', 'mongxixian', '0691', '532823', '101.567051,21.479449');
INSERT INTO `rg_region` VALUES ('42946', '42910', '3', '勐海县', 'mhx', 'monghaixian', '0691', '532822', '100.448288,21.955866');
INSERT INTO `rg_region` VALUES ('42959', '42753', '2', '红河哈尼族彝族自治州', 'hhhnzyzzzz', 'honghehanizuyizuzizhizhou', '0873', '532500', '103.384182,23.366775');
INSERT INTO `rg_region` VALUES ('42960', '42959', '3', '泸西县', 'lxx', 'luxixian', '0873', '532527', '103.759622,24.532368');
INSERT INTO `rg_region` VALUES ('42969', '42959', '3', '弥勒市', 'mls', 'mileshi', '0873', '532504', '103.436988,24.40837');
INSERT INTO `rg_region` VALUES ('42982', '42959', '3', '建水县', 'jsx', 'jianshuixian', '0873', '532524', '102.820493,23.618387');
INSERT INTO `rg_region` VALUES ('42997', '42959', '3', '石屏县', 'spx', 'shipingxian', '0873', '532525', '102.484469,23.712569');
INSERT INTO `rg_region` VALUES ('43007', '42959', '3', '开远市', 'kys', 'kaiyuanshi', '0873', '532502', '103.258679,23.713832');
INSERT INTO `rg_region` VALUES ('43015', '42959', '3', '蒙自市', 'mzs', 'mengzishi', '0873', '532503', '103.385005,23.366843');
INSERT INTO `rg_region` VALUES ('43027', '42959', '3', '个旧市', 'gjs', 'gejiushi', '0873', '532501', '103.154752,23.360383');
INSERT INTO `rg_region` VALUES ('43038', '42959', '3', '红河县', 'hhx', 'honghexian', '0873', '532529', '102.42121,23.369191');
INSERT INTO `rg_region` VALUES ('43052', '42959', '3', '元阳县', 'yyx', 'yuanyangxian', '0873', '532528', '102.837056,23.219773');
INSERT INTO `rg_region` VALUES ('43067', '42959', '3', '屏边苗族自治县', 'pbmzzzx', 'pingbianmiaozuzizhixian', '0873', '532523', '103.687229,22.987013');
INSERT INTO `rg_region` VALUES ('43075', '42959', '3', '绿春县', 'lcx', 'lǜchunxian', '0873', '532531', '102.39286,22.99352');
INSERT INTO `rg_region` VALUES ('43085', '42959', '3', '金平苗族瑶族傣族自治县', 'jpmzyzdzzzx', 'jinpingmiaozuyaozudaizuzizhixian', '0873', '532530', '103.228359,22.779982');
INSERT INTO `rg_region` VALUES ('43099', '42959', '3', '河口瑶族自治县', 'hkyzzzx', 'hekouyaozuzizhixian', '0873', '532532', '103.961593,22.507563');
INSERT INTO `rg_region` VALUES ('43106', '42753', '2', '曲靖市', 'qjs', 'qujingshi', '0874', '530300', '103.797851,25.501557');
INSERT INTO `rg_region` VALUES ('43107', '43106', '3', '会泽县', 'hzx', 'huizexian', '0874', '530326', '103.300041,26.412861');
INSERT INTO `rg_region` VALUES ('43129', '43106', '3', '沾益区', 'zyq', 'zhanyiqu', '0874', '530303', '103.819262,25.600878');
INSERT INTO `rg_region` VALUES ('43139', '43106', '3', '马龙区', 'mlq', 'malongqu', '0874', '530304', '103.578755,25.429451');
INSERT INTO `rg_region` VALUES ('43150', '43106', '3', '麒麟区', 'qlq', 'qilinqu', '0874', '530302', '103.798054,25.501269');
INSERT INTO `rg_region` VALUES ('43166', '43106', '3', '罗平县', 'lpx', 'luopingxian', '0874', '530324', '104.309263,24.885708');
INSERT INTO `rg_region` VALUES ('43180', '43106', '3', '陆良县', 'llx', 'luliangxian', '0874', '530322', '103.655233,25.022878');
INSERT INTO `rg_region` VALUES ('43192', '43106', '3', '师宗县', 'szx', 'shizongxian', '0874', '530323', '103.993808,24.825681');
INSERT INTO `rg_region` VALUES ('43201', '43106', '3', '富源县', 'fyx', 'fuyuanxian', '0874', '530325', '104.25692,25.67064');
INSERT INTO `rg_region` VALUES ('43213', '43106', '3', '宣威市', 'xws', 'xuanweishi', '0874', '530381', '104.09554,26.227777');
INSERT INTO `rg_region` VALUES ('43240', '42753', '2', '怒江傈僳族自治州', 'njlszzzz', 'nujianglisuzuzizhizhou', '0886', '533300', '98.854304,25.850949');
INSERT INTO `rg_region` VALUES ('43241', '43240', '3', '贡山独龙族怒族自治县', 'gsdlznzzzx', 'gongshandulongzunuzuzizhixian', '0886', '533324', '98.666141,27.738054');
INSERT INTO `rg_region` VALUES ('43247', '43240', '3', '兰坪白族普米族自治县', 'lpbzpmzzzx', 'lanpingbaizupumizuzizhixian', '0886', '533325', '99.421378,26.453839');
INSERT INTO `rg_region` VALUES ('43256', '43240', '3', '福贡县', 'fgx', 'fugongxian', '0886', '533323', '98.867413,26.902738');
INSERT INTO `rg_region` VALUES ('43264', '43240', '3', '泸水市', 'lss', 'lushuishi', '0886', '533301', '98.854063,25.851142');
INSERT INTO `rg_region` VALUES ('43274', '42753', '2', '玉溪市', 'yxs', 'yuxishi', '0877', '530400', '102.543907,24.350461');
INSERT INTO `rg_region` VALUES ('43275', '43274', '3', '澄江县', 'cjx', 'chengjiangxian', '0877', '530422', '102.916652,24.669679');
INSERT INTO `rg_region` VALUES ('43282', '43274', '3', '易门县', 'ymx', 'yimenxian', '0877', '530425', '102.16211,24.669598');
INSERT INTO `rg_region` VALUES ('43290', '43274', '3', '江川区', 'jcq', 'jiangchuanqu', '0877', '530403', '102.749839,24.291006');
INSERT INTO `rg_region` VALUES ('43298', '43274', '3', '红塔区', 'htq', 'hongtaqu', '0877', '530402', '102.543468,24.350753');
INSERT INTO `rg_region` VALUES ('43310', '43274', '3', '峨山彝族自治县', 'esyzzzx', 'eshanyizuzizhixian', '0877', '530426', '102.404358,24.173256');
INSERT INTO `rg_region` VALUES ('43319', '43274', '3', '新平彝族傣族自治县', 'xpyzdzzzx', 'xinpingyizudaizuzizhixian', '0877', '530427', '101.990903,24.0664');
INSERT INTO `rg_region` VALUES ('43332', '43274', '3', '华宁县', 'hnx', 'huaningxian', '0877', '530424', '102.928982,24.189807');
INSERT INTO `rg_region` VALUES ('43338', '43274', '3', '通海县', 'thx', 'tonghaixian', '0877', '530423', '102.760039,24.112205');
INSERT INTO `rg_region` VALUES ('43348', '43274', '3', '元江哈尼族彝族傣族自治县', 'yjhnzyzdzzzx', 'yuanjianghanizuyizudaizuzizhixian', '0877', '530428', '101.999658,23.597618');
INSERT INTO `rg_region` VALUES ('43359', '42753', '2', '大理白族自治州', 'dlbzzzz', 'dalibaizuzizhizhou', '0872', '532900', '100.225668,25.589449');
INSERT INTO `rg_region` VALUES ('43360', '43359', '3', '剑川县', 'jcx', 'jianchuanxian', '0872', '532931', '99.905887,26.530066');
INSERT INTO `rg_region` VALUES ('43369', '43359', '3', '鹤庆县', 'hqx', 'heqingxian', '0872', '532932', '100.173375,26.55839');
INSERT INTO `rg_region` VALUES ('43379', '43359', '3', '云龙县', 'ylx', 'yunlongxian', '0872', '532929', '99.369402,25.884955');
INSERT INTO `rg_region` VALUES ('43391', '43359', '3', '洱源县', 'oyx', 'oryuanxian', '0872', '532930', '99.951708,26.111184');
INSERT INTO `rg_region` VALUES ('43401', '43359', '3', '宾川县', 'bcx', 'binchuanxian', '0872', '532924', '100.578957,25.825904');
INSERT INTO `rg_region` VALUES ('43412', '43359', '3', '永平县', 'ypx', 'yongpingxian', '0872', '532928', '99.533536,25.461281');
INSERT INTO `rg_region` VALUES ('43420', '43359', '3', '大理市', 'dls', 'dalishi', '0872', '532901', '100.241369,25.593067');
INSERT INTO `rg_region` VALUES ('43434', '43359', '3', '漾濞彝族自治县', 'ybyzzzx', 'yangbiyizuzizhixian', '0872', '532922', '99.95797,25.669543');
INSERT INTO `rg_region` VALUES ('43444', '43359', '3', '祥云县', 'xyx', 'xiangyunxian', '0872', '532923', '100.554025,25.477072');
INSERT INTO `rg_region` VALUES ('43455', '43359', '3', '巍山彝族回族自治县', 'wsyzhzzzx', 'weishanyizuhuizuzizhixian', '0872', '532927', '100.30793,25.230909');
INSERT INTO `rg_region` VALUES ('43466', '43359', '3', '弥渡县', 'mdx', 'miduxian', '0872', '532925', '100.490669,25.342594');
INSERT INTO `rg_region` VALUES ('43475', '43359', '3', '南涧彝族自治县', 'njyzzzx', 'nanjianyizuzizhixian', '0872', '532926', '100.518683,25.041279');
INSERT INTO `rg_region` VALUES ('43484', '42753', '2', '保山市', 'bss', 'baoshanshi', '0875', '530500', '99.167133,25.111802');
INSERT INTO `rg_region` VALUES ('43485', '43484', '3', '腾冲市', 'tcs', 'tengchongshi', '0875', '530581', '98.497292,25.01757');
INSERT INTO `rg_region` VALUES ('43504', '43484', '3', '隆阳区', 'lyq', 'longyangqu', '0875', '530502', '99.165825,25.112144');
INSERT INTO `rg_region` VALUES ('43525', '43484', '3', '昌宁县', 'cnx', 'changningxian', '0875', '530524', '99.612344,24.823662');
INSERT INTO `rg_region` VALUES ('43539', '43484', '3', '施甸县', 'sdx', 'shidianxian', '0875', '530521', '99.183758,24.730847');
INSERT INTO `rg_region` VALUES ('43554', '43484', '3', '龙陵县', 'llx', 'longlingxian', '0875', '530523', '98.693567,24.591912');
INSERT INTO `rg_region` VALUES ('43565', '42753', '2', '普洱市', 'pos', 'puorshi', '0879', '530800', '100.972344,22.777321');
INSERT INTO `rg_region` VALUES ('43566', '43565', '3', '景东彝族自治县', 'jdyzzzx', 'jingdongyizuzizhixian', '0879', '530823', '100.840011,24.448523');
INSERT INTO `rg_region` VALUES ('43580', '43565', '3', '镇沅彝族哈尼族拉祜族自治县', 'zyyzhnzlhzzzx', 'zhenyuanyizuhanizulahuzuzizhixian', '0879', '530825', '101.108512,24.005712');
INSERT INTO `rg_region` VALUES ('43590', '43565', '3', '墨江哈尼族自治县', 'mjhnzzzx', 'mojianghanizuzizhixian', '0879', '530822', '101.687606,23.428165');
INSERT INTO `rg_region` VALUES ('43606', '43565', '3', '景谷傣族彝族自治县', 'jgdzyzzzx', 'jinggudaizuyizuzizhixian', '0879', '530824', '100.701425,23.500278');
INSERT INTO `rg_region` VALUES ('43617', '43565', '3', '宁洱哈尼族彝族自治县', 'nohnzyzzzx', 'ningorhanizuyizuzizhixian', '0879', '530821', '101.04524,23.062507');
INSERT INTO `rg_region` VALUES ('43627', '43565', '3', '澜沧拉祜族自治县', 'lclhzzzx', 'lancanglahuzuzizhixian', '0879', '530828', '99.931201,22.553083');
INSERT INTO `rg_region` VALUES ('43648', '43565', '3', '思茅区', 'smq', 'simaoqu', '0879', '530802', '100.973227,22.776595');
INSERT INTO `rg_region` VALUES ('43656', '43565', '3', '西盟佤族自治县', 'xmwzzzx', 'ximengwazuzizhixian', '0879', '530829', '99.594372,22.644423');
INSERT INTO `rg_region` VALUES ('43664', '43565', '3', '孟连傣族拉祜族佤族自治县', 'mldzlhzwzzzx', 'mengliandaizulahuzuwazuzizhixian', '0879', '530827', '99.585406,22.325924');
INSERT INTO `rg_region` VALUES ('43671', '43565', '3', '江城哈尼族彝族自治县', 'jchnzyzzzx', 'jiangchenghanizuyizuzizhixian', '0879', '530826', '101.859144,22.58336');
INSERT INTO `rg_region` VALUES ('43679', '42753', '2', '丽江市', 'ljs', 'lijiangshi', '0888', '530700', '100.233026,26.872108');
INSERT INTO `rg_region` VALUES ('43680', '43679', '3', '宁蒗彝族自治县', 'nlyzzzx', 'ninglangyizuzizhixian', '0888', '530724', '100.852427,27.281109');
INSERT INTO `rg_region` VALUES ('43696', '43679', '3', '玉龙纳西族自治县', 'ylnxzzzx', 'yulongnaxizuzizhixian', '0888', '530721', '100.238312,26.830593');
INSERT INTO `rg_region` VALUES ('43713', '43679', '3', '古城区', 'gcq', 'guchengqu', '0888', '530702', '100.234412,26.872229');
INSERT INTO `rg_region` VALUES ('43723', '43679', '3', '永胜县', 'ysx', 'yongshengxian', '0888', '530722', '100.750901,26.685623');
INSERT INTO `rg_region` VALUES ('43739', '43679', '3', '华坪县', 'hpx', 'huapingxian', '0888', '530723', '101.267796,26.628834');
INSERT INTO `rg_region` VALUES ('43748', '42753', '2', '昆明市', 'kms', 'kunmingshi', '0871', '530100', '102.712251,25.040609');
INSERT INTO `rg_region` VALUES ('43749', '43748', '3', '东川区', 'dcq', 'dongchuanqu', '0871', '530113', '103.182,26.08349');
INSERT INTO `rg_region` VALUES ('43758', '43748', '3', '寻甸回族彝族自治县', 'xdhzyzzzx', 'xundianhuizuyizuzizhixian', '0871', '530129', '103.257588,25.559474');
INSERT INTO `rg_region` VALUES ('43774', '43748', '3', '五华区', 'whq', 'wuhuaqu', '0871', '530102', '102.704412,25.042165');
INSERT INTO `rg_region` VALUES ('43786', '43748', '3', '呈贡区', 'cgq', 'chenggongqu', '0871', '530114', '102.801382,24.889275');
INSERT INTO `rg_region` VALUES ('43797', '43748', '3', '西山区', 'xsq', 'xishanqu', '0871', '530112', '102.705904,25.02436');
INSERT INTO `rg_region` VALUES ('43809', '43748', '3', '宜良县', 'ylx', 'yiliangxian', '0871', '530125', '103.145989,24.918215');
INSERT INTO `rg_region` VALUES ('43818', '43748', '3', '石林彝族自治县', 'slyzzzx', 'shilinyizuzizhixian', '0871', '530126', '103.271962,24.754545');
INSERT INTO `rg_region` VALUES ('43824', '43748', '3', '晋宁区', 'jnq', 'jinningqu', '0871', '530115', '102.594987,24.666944');
INSERT INTO `rg_region` VALUES ('43832', '43748', '3', '安宁市', 'ans', 'anningshi', '0871', '530181', '102.485544,24.921785');
INSERT INTO `rg_region` VALUES ('43842', '43748', '3', '富民县', 'fmx', 'fuminxian', '0871', '530124', '102.497888,25.219667');
INSERT INTO `rg_region` VALUES ('43849', '43748', '3', '禄劝彝族苗族自治县', 'lqyzmzzzx', 'luquanyizumiaozuzizhixian', '0871', '530128', '102.46905,25.556533');
INSERT INTO `rg_region` VALUES ('43867', '43748', '3', '官渡区', 'gdq', 'guanduqu', '0871', '530111', '102.723437,25.021211');
INSERT INTO `rg_region` VALUES ('43879', '43748', '3', '嵩明县', 'smx', 'songmingxian', '0871', '530127', '103.038777,25.335087');
INSERT INTO `rg_region` VALUES ('43885', '43748', '3', '盘龙区', 'plq', 'panlongqu', '0871', '530103', '102.729044,25.070239');
INSERT INTO `rg_region` VALUES ('43898', '42753', '2', '迪庆藏族自治州', 'dqczzzz', 'diqingcangzuzizhizhou', '0887', '533400', '99.706463,27.826853');
INSERT INTO `rg_region` VALUES ('43899', '43898', '3', '德钦县', 'dqx', 'deqinxian', '0887', '533422', '98.91506,28.483272');
INSERT INTO `rg_region` VALUES ('43908', '43898', '3', '香格里拉市', 'xglls', 'xianggelilashi', '0887', '533401', '99.708667,27.825804');
INSERT INTO `rg_region` VALUES ('43920', '43898', '3', '维西傈僳族自治县', 'wxlszzzx', 'weixilisuzuzizhixian', '0887', '533423', '99.286355,27.180948');
INSERT INTO `rg_region` VALUES ('43931', '42753', '2', '楚雄彝族自治州', 'cxyzzzz', 'chuxiongyizuzizhizhou', '0878', '532300', '101.546046,25.041988');
INSERT INTO `rg_region` VALUES ('43932', '43931', '3', '大姚县', 'dyx', 'dayaoxian', '0878', '532326', '101.323602,25.722348');
INSERT INTO `rg_region` VALUES ('43945', '43931', '3', '元谋县', 'ymx', 'yuanmouxian', '0878', '532328', '101.870837,25.703313');
INSERT INTO `rg_region` VALUES ('43956', '43931', '3', '牟定县', 'mdx', 'moudingxian', '0878', '532323', '101.543044,25.312111');
INSERT INTO `rg_region` VALUES ('43964', '43931', '3', '姚安县', 'yax', 'yaoanxian', '0878', '532325', '101.238399,25.505403');
INSERT INTO `rg_region` VALUES ('43974', '43931', '3', '南华县', 'nhx', 'nanhuaxian', '0878', '532324', '101.274991,25.192408');
INSERT INTO `rg_region` VALUES ('43985', '43931', '3', '楚雄市', 'cxs', 'chuxiongshi', '0878', '532301', '101.546145,25.040912');
INSERT INTO `rg_region` VALUES ('44001', '43931', '3', '禄丰县', 'lfx', 'lufengxian', '0878', '532331', '102.075694,25.14327');
INSERT INTO `rg_region` VALUES ('44016', '43931', '3', '双柏县', 'sbx', 'shuangbaixian', '0878', '532322', '101.63824,24.685094');
INSERT INTO `rg_region` VALUES ('44025', '43931', '3', '武定县', 'wdx', 'wudingxian', '0878', '532329', '102.406785,25.5301');
INSERT INTO `rg_region` VALUES ('44037', '43931', '3', '永仁县', 'yrx', 'yongrenxian', '0878', '532327', '101.671175,26.056316');
INSERT INTO `rg_region` VALUES ('44045', '42753', '2', '文山壮族苗族自治州', 'wszzmzzzz', 'wenshanzhuangzumiaozuzizhizhou', '0876', '532600', '104.24401,23.36951');
INSERT INTO `rg_region` VALUES ('44046', '44045', '3', '广南县', 'gnx', 'guangnanxian', '0876', '532627', '105.056684,24.050272');
INSERT INTO `rg_region` VALUES ('44065', '44045', '3', '丘北县', 'qbx', 'qiubeixian', '0876', '532626', '104.194366,24.040982');
INSERT INTO `rg_region` VALUES ('44078', '44045', '3', '砚山县', 'ysx', 'yanshanxian', '0876', '532622', '104.343989,23.612301');
INSERT INTO `rg_region` VALUES ('44093', '44045', '3', '西畴县', 'xcx', 'xichouxian', '0876', '532623', '104.675711,23.437439');
INSERT INTO `rg_region` VALUES ('44103', '44045', '3', '文山市', 'wss', 'wenshanshi', '0876', '532601', '104.244277,23.369216');
INSERT INTO `rg_region` VALUES ('44121', '44045', '3', '麻栗坡县', 'mlpx', 'malipoxian', '0876', '532624', '104.701899,23.124202');
INSERT INTO `rg_region` VALUES ('44133', '44045', '3', '马关县', 'mgx', 'maguanxian', '0876', '532625', '104.398619,23.011723');
INSERT INTO `rg_region` VALUES ('44147', '44045', '3', '富宁县', 'fnx', 'funingxian', '0876', '532628', '105.62856,23.626494');
INSERT INTO `rg_region` VALUES ('44161', '42753', '2', '临沧市', 'lcs', 'lincangshi', '0883', '530900', '100.08697,23.886567');
INSERT INTO `rg_region` VALUES ('44162', '44161', '3', '凤庆县', 'fqx', 'fengqingxian', '0883', '530921', '99.91871,24.592738');
INSERT INTO `rg_region` VALUES ('44176', '44161', '3', '云县', 'yx', 'yunxian', '0883', '530922', '100.125637,24.439026');
INSERT INTO `rg_region` VALUES ('44191', '44161', '3', '永德县', 'ydx', 'yongdexian', '0883', '530923', '99.253679,24.028159');
INSERT INTO `rg_region` VALUES ('44203', '44161', '3', '临翔区', 'lxq', 'linxiangqu', '0883', '530902', '100.086486,23.886562');
INSERT INTO `rg_region` VALUES ('44214', '44161', '3', '耿马傣族佤族自治县', 'gmdzwzzzx', 'gongmadaizuwazuzizhixian', '0883', '530926', '99.402495,23.534579');
INSERT INTO `rg_region` VALUES ('44227', '44161', '3', '镇康县', 'zkx', 'zhenkangxian', '0883', '530924', '98.82743,23.761415');
INSERT INTO `rg_region` VALUES ('44235', '44161', '3', '沧源佤族自治县', 'cywzzzx', 'cangyuanwazuzizhixian', '0883', '530927', '99.2474,23.146887');
INSERT INTO `rg_region` VALUES ('44247', '44161', '3', '双江拉祜族佤族布朗族傣族自治县', 'sjlhzwzblzdzzzx', 'shuangjianglahuzuwazubulangzudaizuzizhixian', '0883', '530925', '99.824419,23.477476');
INSERT INTO `rg_region` VALUES ('44254', '42753', '2', '德宏傣族景颇族自治州', 'dhdzjpzzzz', 'dehongdaizujingpozuzizhizhou', '0692', '533100', '98.578363,24.436694');
INSERT INTO `rg_region` VALUES ('44255', '44254', '3', '盈江县', 'yjx', 'yingjiangxian', '0692', '533123', '97.93393,24.709541');
INSERT INTO `rg_region` VALUES ('44271', '44254', '3', '梁河县', 'lhx', 'lianghexian', '0692', '533122', '98.298196,24.80742');
INSERT INTO `rg_region` VALUES ('44281', '44254', '3', '芒市', 'ms', 'mangshi', '0692', '533103', '98.577608,24.436699');
INSERT INTO `rg_region` VALUES ('44294', '44254', '3', '陇川县', 'lcx', 'longchuanxian', '0692', '533124', '97.794441,24.184065');
INSERT INTO `rg_region` VALUES ('44304', '44254', '3', '瑞丽市', 'rls', 'ruilishi', '0692', '533102', '97.855883,24.010734');
INSERT INTO `rg_region` VALUES ('44311', '0', '1', '北京市', 'bjs', 'beijingshi', '010', '110000', '116.405285,39.904989');
INSERT INTO `rg_region` VALUES ('44312', '44311', '2', '北京城区', 'bjcq', 'beijingchengqu', '010', '110100', '116.405285,39.904989');
INSERT INTO `rg_region` VALUES ('44313', '44312', '3', '怀柔区', 'hrq', 'huairouqu', '010', '110116', '116.637122,40.324272');
INSERT INTO `rg_region` VALUES ('44331', '44312', '3', '密云区', 'myq', 'miyunqu', '010', '110118', '116.843352,40.377362');
INSERT INTO `rg_region` VALUES ('44353', '44312', '3', '延庆区', 'yqq', 'yanqingqu', '010', '110119', '115.985006,40.465325');
INSERT INTO `rg_region` VALUES ('44372', '44312', '3', '丰台区', 'ftq', 'fengtaiqu', '010', '110106', '116.286968,39.863642');
INSERT INTO `rg_region` VALUES ('44394', '44312', '3', '顺义区', 'syq', 'shunyiqu', '010', '110113', '116.653525,40.128936');
INSERT INTO `rg_region` VALUES ('44420', '44312', '3', '门头沟区', 'mtgq', 'mentougouqu', '010', '110109', '116.105381,39.937183');
INSERT INTO `rg_region` VALUES ('44434', '44312', '3', '朝阳区', 'cyq', 'chaoyangqu', '010', '110105', '116.486409,39.921489');
INSERT INTO `rg_region` VALUES ('44478', '44312', '3', '石景山区', 'sjsq', 'shijingshanqu', '010', '110107', '116.195445,39.914601');
INSERT INTO `rg_region` VALUES ('44488', '44312', '3', '平谷区', 'pgq', 'pingguqu', '010', '110117', '117.112335,40.144783');
INSERT INTO `rg_region` VALUES ('44507', '44312', '3', '通州区', 'tzq', 'tongzhouqu', '010', '110112', '116.658603,39.902486');
INSERT INTO `rg_region` VALUES ('44523', '44312', '3', '大兴区', 'dxq', 'daxingqu', '010', '110115', '116.338033,39.728908');
INSERT INTO `rg_region` VALUES ('44546', '44312', '3', '昌平区', 'cpq', 'changpingqu', '010', '110114', '116.235906,40.218085');
INSERT INTO `rg_region` VALUES ('44569', '44312', '3', '海淀区', 'hdq', 'haidianqu', '010', '110108', '116.310316,39.956074');
INSERT INTO `rg_region` VALUES ('44599', '44312', '3', '西城区', 'xcq', 'xichengqu', '010', '110102', '116.366794,39.915309');
INSERT INTO `rg_region` VALUES ('44615', '44312', '3', '东城区', 'dcq', 'dongchengqu', '010', '110101', '116.418757,39.917544');
INSERT INTO `rg_region` VALUES ('44633', '44312', '3', '房山区', 'fsq', 'fangshanqu', '010', '110111', '116.139157,39.735535');
INSERT INTO `rg_region` VALUES ('44662', '0', '1', '山西省', 'sxs', 'shanxisheng', '', '140000', '112.549248,37.857014');
INSERT INTO `rg_region` VALUES ('44663', '44662', '2', '阳泉市', 'yqs', 'yangquanshi', '0353', '140300', '113.583285,37.861188');
INSERT INTO `rg_region` VALUES ('44664', '44663', '3', '平定县', 'pdx', 'pingdingxian', '0353', '140321', '113.631049,37.800289');
INSERT INTO `rg_region` VALUES ('44675', '44663', '3', '郊区', 'jq', 'jiaoqu', '0353', '140311', '113.58664,37.94096');
INSERT INTO `rg_region` VALUES ('44685', '44663', '3', '矿区', 'kq', 'kuangqu', '0353', '140303', '113.559066,37.870085');
INSERT INTO `rg_region` VALUES ('44691', '44663', '3', '城区', 'cq', 'chengqu', '0353', '140302', '113.586513,37.860938');
INSERT INTO `rg_region` VALUES ('44697', '44663', '3', '盂县', 'yx', 'yuxian', '0353', '140322', '113.41223,38.086131');
INSERT INTO `rg_region` VALUES ('44712', '44662', '2', '太原市', 'tys', 'taiyuanshi', '0351', '140100', '112.549248,37.857014');
INSERT INTO `rg_region` VALUES ('44713', '44712', '3', '尖草坪区', 'jcpq', 'jiancaopingqu', '0351', '140108', '112.487122,37.939893');
INSERT INTO `rg_region` VALUES ('44728', '44712', '3', '娄烦县', 'lfx', 'loufanxian', '0351', '140123', '111.793798,38.066035');
INSERT INTO `rg_region` VALUES ('44737', '44712', '3', '晋源区', 'jyq', 'jinyuanqu', '0351', '140110', '112.477849,37.715619');
INSERT INTO `rg_region` VALUES ('44744', '44712', '3', '杏花岭区', 'xhlq', 'xinghualingqu', '0351', '140107', '112.560743,37.879291');
INSERT INTO `rg_region` VALUES ('44758', '44712', '3', '万柏林区', 'wblq', 'wanbailinqu', '0351', '140109', '112.522258,37.862653');
INSERT INTO `rg_region` VALUES ('44774', '44712', '3', '小店区', 'xdq', 'xiaodianqu', '0351', '140105', '112.564273,37.817974');
INSERT INTO `rg_region` VALUES ('44786', '44712', '3', '迎泽区', 'yzq', 'yingzequ', '0351', '140106', '112.558851,37.855804');
INSERT INTO `rg_region` VALUES ('44795', '44712', '3', '古交市', 'gjs', 'gujiaoshi', '0351', '140181', '112.174353,37.908534');
INSERT INTO `rg_region` VALUES ('44810', '44712', '3', '阳曲县', 'yqx', 'yangquxian', '0351', '140122', '112.673818,38.058797');
INSERT INTO `rg_region` VALUES ('44825', '44712', '3', '清徐县', 'qxx', 'qingxuxian', '0351', '140121', '112.357961,37.60729');
INSERT INTO `rg_region` VALUES ('44835', '44662', '2', '临汾市', 'lfs', 'linfenshi', '0357', '141000', '111.517973,36.08415');
INSERT INTO `rg_region` VALUES ('44836', '44835', '3', '隰县', 'xx', 'xixian', '0357', '141031', '110.935809,36.692675');
INSERT INTO `rg_region` VALUES ('44845', '44835', '3', '古县', 'gx', 'guxian', '0357', '141025', '111.920207,36.26855');
INSERT INTO `rg_region` VALUES ('44853', '44835', '3', '尧都区', 'ydq', 'yaoduqu', '0357', '141002', '111.522945,36.080366');
INSERT INTO `rg_region` VALUES ('44880', '44835', '3', '浮山县', 'fsx', 'fushanxian', '0357', '141027', '111.850039,35.971359');
INSERT INTO `rg_region` VALUES ('44890', '44835', '3', '大宁县', 'dnx', 'daningxian', '0357', '141030', '110.751283,36.46383');
INSERT INTO `rg_region` VALUES ('44897', '44835', '3', '安泽县', 'azx', 'anzexian', '0357', '141026', '112.251372,36.146032');
INSERT INTO `rg_region` VALUES ('44905', '44835', '3', '吉县', 'jx', 'jixian', '0357', '141028', '110.682853,36.099355');
INSERT INTO `rg_region` VALUES ('44914', '44835', '3', '汾西县', 'fxx', 'fenxixian', '0357', '141034', '111.563021,36.653368');
INSERT INTO `rg_region` VALUES ('44924', '44835', '3', '洪洞县', 'hdx', 'hongdongxian', '0357', '141024', '111.673692,36.255742');
INSERT INTO `rg_region` VALUES ('44941', '44835', '3', '襄汾县', 'xfx', 'xiangfenxian', '0357', '141023', '111.442932,35.876139');
INSERT INTO `rg_region` VALUES ('44955', '44835', '3', '侯马市', 'hms', 'houmashi', '0357', '141081', '111.371272,35.620302');
INSERT INTO `rg_region` VALUES ('44964', '44835', '3', '永和县', 'yhx', 'yonghexian', '0357', '141032', '110.631276,36.760614');
INSERT INTO `rg_region` VALUES ('44972', '44835', '3', '曲沃县', 'qwx', 'quwoxian', '0357', '141021', '111.475529,35.641387');
INSERT INTO `rg_region` VALUES ('44980', '44835', '3', '乡宁县', 'xnx', 'xiangningxian', '0357', '141029', '110.857365,35.975402');
INSERT INTO `rg_region` VALUES ('44991', '44835', '3', '翼城县', 'ycx', 'yichengxian', '0357', '141022', '111.713508,35.738621');
INSERT INTO `rg_region` VALUES ('45002', '44835', '3', '霍州市', 'hzs', 'huozhoushi', '0357', '141082', '111.723103,36.57202');
INSERT INTO `rg_region` VALUES ('45015', '44835', '3', '蒲县', 'px', 'puxian', '0357', '141033', '111.09733,36.411682');
INSERT INTO `rg_region` VALUES ('45025', '44662', '2', '运城市', 'ycs', 'yunchengshi', '0359', '140800', '111.003957,35.022778');
INSERT INTO `rg_region` VALUES ('45026', '45025', '3', '盐湖区', 'yhq', 'yanhuqu', '0359', '140802', '111.000627,35.025643');
INSERT INTO `rg_region` VALUES ('45050', '45025', '3', '闻喜县', 'wxx', 'wenxixian', '0359', '140823', '111.220306,35.353839');
INSERT INTO `rg_region` VALUES ('45064', '45025', '3', '临猗县', 'lyx', 'linyixian', '0359', '140821', '110.77493,35.141883');
INSERT INTO `rg_region` VALUES ('45081', '45025', '3', '平陆县', 'plx', 'pingluxian', '0359', '140829', '111.212377,34.837256');
INSERT INTO `rg_region` VALUES ('45092', '45025', '3', '芮城县', 'rcx', 'ruichengxian', '0359', '140830', '110.69114,34.694769');
INSERT INTO `rg_region` VALUES ('45104', '45025', '3', '万荣县', 'wrx', 'wanrongxian', '0359', '140822', '110.843561,35.417042');
INSERT INTO `rg_region` VALUES ('45119', '45025', '3', '垣曲县', 'yqx', 'yuanquxian', '0359', '140827', '111.67099,35.298293');
INSERT INTO `rg_region` VALUES ('45131', '45025', '3', '夏县', 'xx', 'xiaxian', '0359', '140828', '111.223174,35.140441');
INSERT INTO `rg_region` VALUES ('45143', '45025', '3', '新绛县', 'xjx', 'xinjiangxian', '0359', '140825', '111.225205,35.613697');
INSERT INTO `rg_region` VALUES ('45155', '45025', '3', '永济市', 'yjs', 'yongjishi', '0359', '140881', '110.447984,34.865125');
INSERT INTO `rg_region` VALUES ('45169', '45025', '3', '绛县', 'jx', 'jiangxian', '0359', '140826', '111.576182,35.49045');
INSERT INTO `rg_region` VALUES ('45181', '45025', '3', '稷山县', 'jsx', 'jishanxian', '0359', '140824', '110.978996,35.600412');
INSERT INTO `rg_region` VALUES ('45189', '45025', '3', '河津市', 'hjs', 'hejinshi', '0359', '140882', '110.710268,35.59715');
INSERT INTO `rg_region` VALUES ('45200', '44662', '2', '长治市', 'czs', 'changzhishi', '0355', '140400', '113.113556,36.191112');
INSERT INTO `rg_region` VALUES ('45201', '45200', '3', '屯留区', 'tlq', 'tunliuqu', '0355', '140405', '112.892741,36.314072');
INSERT INTO `rg_region` VALUES ('45216', '45200', '3', '潞城区', 'lcq', 'luchengqu', '0355', '140406', '113.223245,36.332233');
INSERT INTO `rg_region` VALUES ('45226', '45200', '3', '上党区', 'sdq', 'shangdangqu', '0355', '140404', '113.056679,36.052438');
INSERT INTO `rg_region` VALUES ('45240', '45200', '3', '黎城县', 'lcx', 'lichengxian', '0355', '140426', '113.387366,36.502971');
INSERT INTO `rg_region` VALUES ('45250', '45200', '3', '平顺县', 'psx', 'pingshunxian', '0355', '140425', '113.438791,36.200202');
INSERT INTO `rg_region` VALUES ('45263', '45200', '3', '长子县', 'czx', 'changzixian', '0355', '140428', '112.884656,36.119484');
INSERT INTO `rg_region` VALUES ('45276', '45200', '3', '壶关县', 'hgx', 'huguanxian', '0355', '140427', '113.206138,36.110938');
INSERT INTO `rg_region` VALUES ('45290', '45200', '3', '沁源县', 'qyx', 'qinyuanxian', '0355', '140431', '112.340878,36.500777');
INSERT INTO `rg_region` VALUES ('45305', '45200', '3', '襄垣县', 'xyx', 'xiangyuanxian', '0355', '140423', '113.050094,36.532854');
INSERT INTO `rg_region` VALUES ('45319', '45200', '3', '潞州区', 'lzq', 'luzhouqu', '0355', '140403', '113.114107,36.187896');
INSERT INTO `rg_region` VALUES ('45339', '45200', '3', '武乡县', 'wxx', 'wuxiangxian', '0355', '140429', '112.8653,36.834315');
INSERT INTO `rg_region` VALUES ('45354', '45200', '3', '沁县', 'qx', 'qinxian', '0355', '140430', '112.70138,36.757123');
INSERT INTO `rg_region` VALUES ('45368', '44662', '2', '朔州市', 'szs', 'shuozhoushi', '0349', '140600', '112.433387,39.331261');
INSERT INTO `rg_region` VALUES ('45369', '45368', '3', '右玉县', 'yyx', 'youyuxian', '0349', '140623', '112.465588,39.988812');
INSERT INTO `rg_region` VALUES ('45380', '45368', '3', '平鲁区', 'plq', 'pingluqu', '0349', '140603', '112.295227,39.515603');
INSERT INTO `rg_region` VALUES ('45394', '45368', '3', '应县', 'yx', 'yingxian', '0349', '140622', '113.187505,39.559187');
INSERT INTO `rg_region` VALUES ('45407', '45368', '3', '怀仁市', 'hrs', 'huairenshi', '0349', '140681', '113.100512,39.82079');
INSERT INTO `rg_region` VALUES ('45420', '45368', '3', '朔城区', 'scq', 'shuochengqu', '0349', '140602', '112.428676,39.324525');
INSERT INTO `rg_region` VALUES ('45437', '45368', '3', '山阴县', 'syx', 'shanyinxian', '0349', '140621', '112.816396,39.52677');
INSERT INTO `rg_region` VALUES ('45454', '44662', '2', '忻州市', 'xzs', 'xinzhoushi', '0350', '140900', '112.733538,38.41769');
INSERT INTO `rg_region` VALUES ('45455', '45454', '3', '河曲县', 'hqx', 'hequxian', '0350', '140930', '111.146609,39.381895');
INSERT INTO `rg_region` VALUES ('45469', '45454', '3', '偏关县', 'pgx', 'pianguanxian', '0350', '140932', '111.500477,39.442153');
INSERT INTO `rg_region` VALUES ('45480', '45454', '3', '五寨县', 'wzx', 'wuzhaixian', '0350', '140928', '111.841015,38.912761');
INSERT INTO `rg_region` VALUES ('45493', '45454', '3', '代县', 'dx', 'daixian', '0350', '140923', '112.962519,39.065138');
INSERT INTO `rg_region` VALUES ('45505', '45454', '3', '原平市', 'yps', 'yuanpingshi', '0350', '140981', '112.713132,38.729186');
INSERT INTO `rg_region` VALUES ('45529', '45454', '3', '宁武县', 'nwx', 'ningwuxian', '0350', '140925', '112.307936,39.001718');
INSERT INTO `rg_region` VALUES ('45546', '45454', '3', '繁峙县', 'fzx', 'fanzhixian', '0350', '140924', '113.267707,39.188104');
INSERT INTO `rg_region` VALUES ('45561', '45454', '3', '岢岚县', 'klx', 'kolanxian', '0350', '140929', '111.56981,38.705625');
INSERT INTO `rg_region` VALUES ('45574', '45454', '3', '忻府区', 'xfq', 'xinfuqu', '0350', '140902', '112.734112,38.417743');
INSERT INTO `rg_region` VALUES ('45595', '45454', '3', '定襄县', 'dxx', 'dingxiangxian', '0350', '140921', '112.963231,38.484948');
INSERT INTO `rg_region` VALUES ('45605', '45454', '3', '五台县', 'wtx', 'wutaixian', '0350', '140922', '113.259012,38.725711');
INSERT INTO `rg_region` VALUES ('45625', '45454', '3', '神池县', 'scx', 'shenchixian', '0350', '140927', '112.200438,39.088467');
INSERT INTO `rg_region` VALUES ('45636', '45454', '3', '保德县', 'bdx', 'baodexian', '0350', '140931', '111.085688,39.022576');
INSERT INTO `rg_region` VALUES ('45650', '45454', '3', '静乐县', 'jlx', 'jinglexian', '0350', '140926', '111.940231,38.355947');
INSERT INTO `rg_region` VALUES ('45665', '44662', '2', '晋城市', 'jcs', 'jinchengshi', '0356', '140500', '112.851274,35.497553');
INSERT INTO `rg_region` VALUES ('45666', '45665', '3', '城区', 'cq', 'chengqu', '0356', '140502', '112.853106,35.496641');
INSERT INTO `rg_region` VALUES ('45676', '45665', '3', '高平市', 'gps', 'gaopingshi', '0356', '140581', '112.930691,35.791355');
INSERT INTO `rg_region` VALUES ('45693', '45665', '3', '泽州县', 'zzx', 'zezhouxian', '0356', '140525', '112.899137,35.617221');
INSERT INTO `rg_region` VALUES ('45711', '45665', '3', '陵川县', 'lcx', 'lingchuanxian', '0356', '140524', '113.278877,35.775614');
INSERT INTO `rg_region` VALUES ('45724', '45665', '3', '沁水县', 'qsx', 'qinshuixian', '0356', '140521', '112.187213,35.689472');
INSERT INTO `rg_region` VALUES ('45739', '45665', '3', '阳城县', 'ycx', 'yangchengxian', '0356', '140522', '112.422014,35.482177');
INSERT INTO `rg_region` VALUES ('45759', '44662', '2', '晋中市', 'jzs', 'jinzhongshi', '0354', '140700', '112.736465,37.696495');
INSERT INTO `rg_region` VALUES ('45760', '45759', '3', '昔阳县', 'xyx', 'xiyangxian', '0354', '140724', '113.706166,37.60437');
INSERT INTO `rg_region` VALUES ('45773', '45759', '3', '平遥县', 'pyx', 'pingyaoxian', '0354', '140728', '112.174059,37.195474');
INSERT INTO `rg_region` VALUES ('45791', '45759', '3', '太谷县', 'tgx', 'taiguxian', '0354', '140726', '112.554103,37.424595');
INSERT INTO `rg_region` VALUES ('45804', '45759', '3', '榆社县', 'ysx', 'yushexian', '0354', '140721', '112.973521,37.069019');
INSERT INTO `rg_region` VALUES ('45815', '45759', '3', '介休市', 'jxs', 'jiexiushi', '0354', '140781', '111.913857,37.027616');
INSERT INTO `rg_region` VALUES ('45831', '45759', '3', '左权县', 'zqx', 'zuoquanxian', '0354', '140722', '113.377834,37.079672');
INSERT INTO `rg_region` VALUES ('45843', '45759', '3', '和顺县', 'hsx', 'heshunxian', '0354', '140723', '113.572919,37.327027');
INSERT INTO `rg_region` VALUES ('45854', '45759', '3', '榆次区', 'ycq', 'yuciqu', '0354', '140702', '112.740056,37.6976');
INSERT INTO `rg_region` VALUES ('45875', '45759', '3', '寿阳县', 'syx', 'shouyangxian', '0354', '140725', '113.177708,37.891136');
INSERT INTO `rg_region` VALUES ('45890', '45759', '3', '祁县', 'qx', 'qixian', '0354', '140727', '112.330532,37.358739');
INSERT INTO `rg_region` VALUES ('45903', '45759', '3', '灵石县', 'lsx', 'lingshixian', '0354', '140729', '111.772759,36.847469');
INSERT INTO `rg_region` VALUES ('45919', '44662', '2', '吕梁市', 'lls', 'luliangshi', '0358', '141100', '111.134335,37.524366');
INSERT INTO `rg_region` VALUES ('45920', '45919', '3', '柳林县', 'llx', 'liulinxian', '0358', '141125', '110.89613,37.431664');
INSERT INTO `rg_region` VALUES ('45936', '45919', '3', '岚县', 'lx', 'lanxian', '0358', '141127', '111.671555,38.278654');
INSERT INTO `rg_region` VALUES ('45949', '45919', '3', '离石区', 'lsq', 'lishiqu', '0358', '141102', '111.134462,37.524037');
INSERT INTO `rg_region` VALUES ('45962', '45919', '3', '交口县', 'jkx', 'jiaokouxian', '0358', '141130', '111.183188,36.983068');
INSERT INTO `rg_region` VALUES ('45970', '45919', '3', '临县', 'lx', 'linxian', '0358', '141124', '110.995963,37.960806');
INSERT INTO `rg_region` VALUES ('45994', '45919', '3', '中阳县', 'zyx', 'zhongyangxian', '0358', '141129', '111.193319,37.342054');
INSERT INTO `rg_region` VALUES ('46002', '45919', '3', '方山县', 'fsx', 'fangshanxian', '0358', '141128', '111.238885,37.892632');
INSERT INTO `rg_region` VALUES ('46010', '45919', '3', '兴县', 'xx', 'xingxian', '0358', '141123', '111.124816,38.464136');
INSERT INTO `rg_region` VALUES ('46028', '45919', '3', '石楼县', 'slx', 'shilouxian', '0358', '141126', '110.837119,36.999426');
INSERT INTO `rg_region` VALUES ('46038', '45919', '3', '交城县', 'jcx', 'jiaochengxian', '0358', '141122', '112.159154,37.555155');
INSERT INTO `rg_region` VALUES ('46050', '45919', '3', '孝义市', 'xys', 'xiaoyishi', '0358', '141181', '111.781568,37.144474');
INSERT INTO `rg_region` VALUES ('46068', '45919', '3', '汾阳市', 'fys', 'fenyangshi', '0358', '141182', '111.785273,37.267742');
INSERT INTO `rg_region` VALUES ('46085', '45919', '3', '文水县', 'wsx', 'wenshuixian', '0358', '141121', '112.032595,37.436314');
INSERT INTO `rg_region` VALUES ('46098', '44662', '2', '大同市', 'dts', 'datongshi', '0352', '140200', '113.295259,40.09031');
INSERT INTO `rg_region` VALUES ('46099', '46098', '3', '广灵县', 'glx', 'guanglingxian', '0352', '140223', '114.279252,39.763051');
INSERT INTO `rg_region` VALUES ('46109', '46098', '3', '灵丘县', 'lqx', 'lingqiuxian', '0352', '140224', '114.23576,39.438867');
INSERT INTO `rg_region` VALUES ('46122', '46098', '3', '浑源县', 'hyx', 'hunyuanxian', '0352', '140225', '113.698091,39.699099');
INSERT INTO `rg_region` VALUES ('46141', '46098', '3', '左云县', 'zyx', 'zuoyunxian', '0352', '140226', '112.70641,40.012873');
INSERT INTO `rg_region` VALUES ('46151', '46098', '3', '阳高县', 'ygx', 'yanggaoxian', '0352', '140221', '113.749871,40.364927');
INSERT INTO `rg_region` VALUES ('46164', '46098', '3', '云州区', 'yzq', 'yunzhouqu', '0352', '140215', '113.61244,40.040295');
INSERT INTO `rg_region` VALUES ('46179', '46098', '3', '云冈区', 'ygq', 'yungangqu', '0352', '140214', '113.149693,40.005405');
INSERT INTO `rg_region` VALUES ('46200', '46098', '3', '平城区', 'pcq', 'pingchengqu', '0352', '140213', '113.298027,40.075667');
INSERT INTO `rg_region` VALUES ('46217', '46098', '3', '新荣区', 'xrq', 'xinrongqu', '0352', '140212', '113.141044,40.258269');
INSERT INTO `rg_region` VALUES ('46227', '46098', '3', '天镇县', 'tzx', 'tianzhenxian', '0352', '140222', '114.09112,40.421336');

-- -----------------------------
-- Table structure for `rg_site`
-- -----------------------------
DROP TABLE IF EXISTS `rg_site`;
CREATE TABLE `rg_site` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `alias` varchar(20) DEFAULT NULL,
  `isdefault` int(11) DEFAULT '0',
  `pctemplate` varchar(50) DEFAULT NULL,
  `pchtml` varchar(50) DEFAULT NULL,
  `waptemplate` varchar(50) DEFAULT NULL,
  `waphtml` varchar(50) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  `wapstatus` int(11) DEFAULT '0',
  `offline` varchar(255) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `icp` varchar(20) DEFAULT NULL,
  `logo` varchar(150) DEFAULT NULL,
  `tel` varchar(100) DEFAULT NULL,
  `mobile` varchar(50) DEFAULT NULL,
  `fax` varchar(100) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `contact` varchar(50) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lng` varchar(100) DEFAULT NULL,
  `lat` varchar(100) DEFAULT NULL,
  `index_title` varchar(255) DEFAULT NULL,
  `keys` varchar(255) DEFAULT NULL,
  `desc` mediumtext,
  `nav_title` varchar(255) DEFAULT NULL,
  `nav_desc` mediumtext,
  `info_title` varchar(255) DEFAULT NULL,
  `torder` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `end_time` bigint(20) DEFAULT '0',
  `views` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_site`
-- -----------------------------
INSERT INTO `rg_site` VALUES ('1', '中文', 'zh', '1', 'demo202009', 'pages', 'demo202009', 'pages', 'http://www.yourdomain.com/', '1', '0', '站点维护中，请稍后访问！', 'RGCMS内容管理系统', 'RGCMS内容管理系统', '沪ICP备0000000号', '/upload/image/20200904/de6f62ebe88833304773d1a07ae7ede9.jpg', '021-88888888', '13000000000', '021-66666666', '上海市松江区佘山工业区', '', '联系人', 'info@yourdomain.com', '121.188932', '31.119116', '{$site_company}', 'RGCMS,PHPCMS建站,网站模板,PHP网站系统,网站SEO,建站系统,PHP建站,网站管理系统', '{$site_name}可以为您提供专业的{$site_keys}系列产品，质量上乘，欢迎新老客户咨询。', '{$nav_name},{$site_name}', '{$site_name}多年来致力于为您提供各种{$site_keys}。价格优惠，质量保证，欢迎垂询。', '{$info_title},{$nav_name},{$site_name}', '1', '1598659200', '1599275797', '4058737349', '12');
INSERT INTO `rg_site` VALUES ('4', 'ENGLISH', 'en', '0', 'demo202009', 'pages', 'demo202009', 'pages', 'http://www.yourdomain.com/', '1', '0', '站点维护中，请稍后访问！', 'RGCMS content management system', 'RGCMS content management system', '沪ICP备0000000号', '/upload/image/20200904/de6f62ebe88833304773d1a07ae7ede9.jpg', '+86-21-88888888', '+86-13000000000', '+86-21-66666666', 'Sheshan Industrial Zone, Songjiang District, Shanghai', '', 'Tom', 'info@yourdomain.com', '121.188932', '31.119116', '{$site_company}', 'RGCMS,PHPCMS website,Website template,PHP website system,Website SEO,Website system,PHP website,Website Management System', '{$site_name}可以为您提供专业的{$site_keys}系列产品，质量上乘，欢迎新老客户咨询。', '{$nav_name},{$site_name}', '{$site_name}多年来致力于为您提供各种{$site_keys}。价格优惠，质量保证，欢迎垂询。', '{$info_title},{$nav_name},{$site_name}', '1', '1598659200', '1599284556', '4058737349', '12');

-- -----------------------------
-- Table structure for `rg_sitekey`
-- -----------------------------
DROP TABLE IF EXISTS `rg_sitekey`;
CREATE TABLE `rg_sitekey` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `istop` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_sitekey`
-- -----------------------------
INSERT INTO `rg_sitekey` VALUES ('1', 'PHP建站', 'http://www.rgxx.com', '1', '1', '5', '1599200940', '1599273793');
INSERT INTO `rg_sitekey` VALUES ('2', 'PHP网站系统', '', '0', '1', '2', '1599200948', '1599272938');
INSERT INTO `rg_sitekey` VALUES ('3', '网站SEO', '', '0', '1', '3', '1599200954', '1599272918');
INSERT INTO `rg_sitekey` VALUES ('4', '网站管理系统', 'http://www.rgxx.com', '1', '1', '6', '1599200961', '1599273794');
INSERT INTO `rg_sitekey` VALUES ('5', '建站系统', 'http://www.rgxx.com', '1', '1', '4', '1599200968', '1599273791');
INSERT INTO `rg_sitekey` VALUES ('6', 'RGCMS', '', '0', '1', '1', '1599200976', '1599272944');
INSERT INTO `rg_sitekey` VALUES ('7', 'PHPCMS建站', '', '0', '1', '1', '1599200984', '1599272953');
INSERT INTO `rg_sitekey` VALUES ('8', '网站模板', 'http://www.rgxx.com', '1', '1', '1', '1599200991', '1599273787');
INSERT INTO `rg_sitekey` VALUES ('49', 'PHP website', 'http://www.rgxx.com', '1', '4', '5', '1599200940', '1599284525');
INSERT INTO `rg_sitekey` VALUES ('50', 'PHP website system', '', '0', '4', '2', '1599200948', '1599284503');
INSERT INTO `rg_sitekey` VALUES ('51', 'Website SEO', '', '0', '4', '3', '1599200954', '1599284509');
INSERT INTO `rg_sitekey` VALUES ('52', 'Website Management System', 'http://www.rgxx.com', '1', '4', '6', '1599200961', '1599284531');
INSERT INTO `rg_sitekey` VALUES ('53', 'Website system', 'http://www.rgxx.com', '1', '4', '4', '1599200968', '1599284517');
INSERT INTO `rg_sitekey` VALUES ('54', 'RGCMS', '', '0', '4', '1', '1599200976', '1599272944');
INSERT INTO `rg_sitekey` VALUES ('55', 'PHPCMS website', '', '0', '4', '1', '1599200984', '1599284495');
INSERT INTO `rg_sitekey` VALUES ('56', 'Website template', 'http://www.rgxx.com', '1', '4', '1', '1599200991', '1599284488');

-- -----------------------------
-- Table structure for `rg_slidemodel`
-- -----------------------------
DROP TABLE IF EXISTS `rg_slidemodel`;
CREATE TABLE `rg_slidemodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT '0',
  `province` int(11) DEFAULT '0',
  `city` int(11) DEFAULT '0',
  `district` int(11) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  `cmsmodels_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  `title` mediumtext,
  `img` mediumtext,
  `link` mediumtext,
  `iwap` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_slidemodel`
-- -----------------------------
INSERT INTO `rg_slidemodel` VALUES ('1', '1', '0', '0', '0', '1', '162', '1', '1', '1599200817', '1599200817', '0', '幻灯片一', '/upload/image/20200904/5a59e604011c32be4f424a9700d6e33b.jpg', '#', '');
INSERT INTO `rg_slidemodel` VALUES ('2', '1', '0', '0', '0', '1', '162', '2', '1', '1599200826', '1599200826', '0', '幻灯片二', '/upload/image/20200904/d16f1d7350b99cf118b77163332cbc3c.jpg', '#', '');
INSERT INTO `rg_slidemodel` VALUES ('14', '1', '0', '0', '0', '4', '162', '1', '1', '1599200817', '1599200817', '0', '幻灯片一', '/upload/image/20200904/5a59e604011c32be4f424a9700d6e33b.jpg', '#', '');
INSERT INTO `rg_slidemodel` VALUES ('15', '1', '0', '0', '0', '4', '162', '2', '1', '1599200826', '1599200826', '0', '幻灯片二', '/upload/image/20200904/d16f1d7350b99cf118b77163332cbc3c.jpg', '#', '');

-- -----------------------------
-- Table structure for `rg_spider`
-- -----------------------------
DROP TABLE IF EXISTS `rg_spider`;
CREATE TABLE `rg_spider` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bot` varchar(100) DEFAULT NULL,
  `ip` varchar(100) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `method` varchar(20) DEFAULT NULL,
  `create_time` bigint(20) DEFAULT '0',
  `site_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `rg_tkdtemp`
-- -----------------------------
DROP TABLE IF EXISTS `rg_tkdtemp`;
CREATE TABLE `rg_tkdtemp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `class` varchar(100) DEFAULT NULL,
  `content` mediumtext,
  `torder` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_tkdtemp`
-- -----------------------------
INSERT INTO `rg_tkdtemp` VALUES ('1', '首页标题二', '首页标题', '{$site_keys}厂家,{$site_name}', '2', '1571886680', '1596729717');
INSERT INTO `rg_tkdtemp` VALUES ('2', '首页标题一', '首页标题', '{$site_keys},{$site_company}', '1', '1571886437', '1596729711');
INSERT INTO `rg_tkdtemp` VALUES ('3', '首页标题三', '首页标题', '{$site_keys}供应商,{$site_name}', '3', '1571886776', '1596729721');
INSERT INTO `rg_tkdtemp` VALUES ('4', '首页标题四', '首页标题', '中国{$site_keys}生产厂家,{$site_name}', '4', '1571886833', '1596729708');
INSERT INTO `rg_tkdtemp` VALUES ('5', '首页描述一', '描述', '{$site_name}多年来致力于为您提供各种{$site_keys}。价格优惠，质量保证，欢迎垂询。', '5', '1571886883', '1578109332');
INSERT INTO `rg_tkdtemp` VALUES ('6', '首页描述二', '描述', '{$site_name}专业生产{$site_keys}。公司以先进的生产技术和优质工艺成为行业知名供应商。欢迎来电洽谈业务。', '6', '1571886934', '1571886934');
INSERT INTO `rg_tkdtemp` VALUES ('7', '首页描述三', '描述', '{$site_name}可以为您提供专业的{$site_keys}系列产品，质量上乘，欢迎新老客户咨询。', '7', '1571886984', '1571886984');
INSERT INTO `rg_tkdtemp` VALUES ('8', '首页描述四', '描述', '{$site_name}是国内专业生产{$site_keys}的厂家。公司所生产的{$site_keys}质优价廉，远销多个国家和地区。', '8', '1571887036', '1571887036');
INSERT INTO `rg_tkdtemp` VALUES ('14', '', '栏目页标题', '{$nav_name},{$site_name}', '9', '1596729591', '1596729728');
INSERT INTO `rg_tkdtemp` VALUES ('15', '', '栏目页标题', '{$nav_name},{$site_keys},{$site_name}', '10', '1596729673', '1596729758');
INSERT INTO `rg_tkdtemp` VALUES ('16', '', '内容页标题', '{$info_title},{$nav_name},{$site_name}', '11', '1596729802', '1596729802');
INSERT INTO `rg_tkdtemp` VALUES ('17', '', '内容页标题', '{$info_title},{$site_keys}厂家,{$site_name}', '12', '1596729862', '1596729862');

-- -----------------------------
-- Table structure for `rg_upgrade`
-- -----------------------------
DROP TABLE IF EXISTS `rg_upgrade`;
CREATE TABLE `rg_upgrade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ver` varchar(20) DEFAULT NULL,
  `desc` mediumtext,
  `create_time` bigint(20) DEFAULT '0',
  `files` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Table structure for `rg_user`
-- -----------------------------
DROP TABLE IF EXISTS `rg_user`;
CREATE TABLE `rg_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(30) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `nickname` varchar(30) DEFAULT NULL,
  `sex` int(11) DEFAULT '0',
  `face` varchar(255) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobile` varchar(50) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `site_id` int(11) DEFAULT '0',
  `admin_id` int(11) DEFAULT '0',
  `usergroup_id` int(11) DEFAULT '0',
  `logincount` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `salt` varchar(10) DEFAULT NULL,
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_user`
-- -----------------------------
INSERT INTO `rg_user` VALUES ('13', 'user1', 'bbe2c5479bdf6d272f83929de9eefabb', 'xingm', '1', '/public/static/images/face/06.png', '', '13000000000', '', '', '0', '0', '1', '1', '1', 'PfzjbjCqPb', '1593401123', '1593401123');

-- -----------------------------
-- Table structure for `rg_usergroup`
-- -----------------------------
DROP TABLE IF EXISTS `rg_usergroup`;
CREATE TABLE `rg_usergroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(80) DEFAULT NULL,
  `point` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `rg_usergroup`
-- -----------------------------
INSERT INTO `rg_usergroup` VALUES ('1', '会员分组一', '1', '1', '1564364985', '1593360649');
INSERT INTO `rg_usergroup` VALUES ('6', '会员分组二', '2', '1', '1593360145', '1593360650');

-- -----------------------------
-- Table structure for `rg_usermenu`
-- -----------------------------
DROP TABLE IF EXISTS `rg_usermenu`;
CREATE TABLE `rg_usermenu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `icon` varchar(50) DEFAULT NULL,
  `type` varchar(10) DEFAULT NULL,
  `usergroupids` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `content` mediumtext,
  `model_id` int(11) DEFAULT '0',
  `torder` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  `update_time` bigint(20) DEFAULT '0',
  `delete_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `rg_visits`
-- -----------------------------
DROP TABLE IF EXISTS `rg_visits`;
CREATE TABLE `rg_visits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `fromwhere` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT '0',
  `method` varchar(20) DEFAULT NULL,
  `site_id` int(11) DEFAULT '0',
  `create_time` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

