<?php
namespace rg;

class Alisms
{
    // 保存错误信息
    public $error;
    // Access Key ID
    private $accessKeyId = '';
    // Access Access Key Secret
    private $accessKeySecret = '';
    // 签名
    private $signName = '';
    // 模版ID
    private $templateCode = '';

    public function __construct($config = array()) {
        // 配置参数
        $this->accessKeyId = $config['accessKeyId'];
        $this->accessKeySecret = $config['accessKeySecret'];
        $this->signName = $config['signName'];
        $this->templateCode = $config['templateCode'];
    }

    private function percentEncode($string) {
        $string = urlencode ( $string );
        $string = preg_replace ( '/\+/', '%20', $string );
        $string = preg_replace ( '/\*/', '%2A', $string );
        $string = preg_replace ( '/%7E/', '~', $string );
        return $string;
    }

    // 签名
    private function computeSignature($parameters, $accessKeySecret) {
        ksort ( $parameters );
        $canonicalizedQueryString = '';
        foreach ( $parameters as $key => $value ) {
            $canonicalizedQueryString .= '&' . $this->percentEncode ( $key ) . '=' . $this->percentEncode ( $value );
        }
        $stringToSign = 'GET&%2F&' . $this->percentencode ( substr ( $canonicalizedQueryString, 1 ) );
        $signature = base64_encode ( hash_hmac ( 'sha1', $stringToSign, $accessKeySecret . '&', true ) );
        return $signature;
    }

    public function send_verify($mobile, $verify_code) {
        $params = array (   //此处作了修改
                'SignName' => $this->signName,
                'Format' => 'JSON',
                'Version' => '2017-05-25',
                'AccessKeyId' => $this->accessKeyId,
                'SignatureVersion' => '1.0',
                'SignatureMethod' => 'HMAC-SHA1',
                'SignatureNonce' => uniqid(),
                'Timestamp' => gmdate('Y-m-d\TH:i:s\Z'),
                'Action' => 'SendSms',
                'TemplateCode' => $this->templateCode,
                'PhoneNumbers' => $mobile,
                'TemplateParam' => '{"code":"' . $verify_code . '"}'

        );
        // 计算签名并把签名结果加入请求参数
        $params ['Signature'] = $this->computeSignature ( $params, $this->accessKeySecret );
        // 发送请求
        //$url = 'https://sms.aliyuncs.com/?' . http_build_query ( $params );
        $url = 'http://dysmsapi.aliyuncs.com/?' . http_build_query ( $params );
        $ch = curl_init ();
        curl_setopt ( $ch, CURLOPT_URL, $url );
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt ( $ch, CURLOPT_TIMEOUT, 10 );
        $result = curl_exec ( $ch );
        curl_close ( $ch );
        $result = json_decode ( $result, true );
        // var_dump($result);die;
        if (isset($result['Code']) && $result['Code'] == 'OK') {
            return true;
        } else {
            $this->error = $this->getErrorMessage ($result['Code']);
            return false;
        }
    }

    public function getErrorMessage($status) {
        // https://api.alidayu.com/doc2/apiDetail?spm=a3142.7629140.1.19.SmdYoA&apiId=25450
        $message = array (
                'isv.OUT_OF_SERVICE' => '业务停机',
                'isv.PRODUCT_UNSUBSCRIBE' => '产品服务未开通',
                'isv.ACCOUNT_NOT_EXISTS' => '账户信息不存在',
                'isv.ACCOUNT_ABNORMAL' => '账户信息异常',
                'isv.SMS_TEMPLATE_ILLEGAL' => '模板不合法',
                'isv.SMS_SIGNATURE_ILLEGAL' => '签名不合法',
                'isv.MOBILE_NUMBER_ILLEGAL' => '手机号码格式错误',
                'isv.MOBILE_COUNT_OVER_LIMIT' => '手机号码数量超过限制',
                'isv.TEMPLATE_MISSING_PARAMETERS' => '短信模板变量缺少参数',
                'isv.INVALID_PARAMETERS' => '参数异常',
                'isv.BUSINESS_LIMIT_CONTROL' => '触发业务流控限制',
                'isv.INVALID_JSON_PARAM' => 'JSON参数不合法',
                'isv.BLACK_KEY_CONTROL_LIMIT' => '模板变量中存在黑名单关键字',
                'isv.PARAM_NOT_SUPPORT_URL' => '不支持url为变量',
                'isv.PARAM_LENGTH_LIMIT' => '变量长度受限',
                'isv.AMOUNT_NOT_ENOUGH' => '余额不足',
                'isv.DAY_LIMIT_CONTROL' => '触发日发送限额',
                'isv.MONTH_LIMIT_CONTROL' => '触发月发送限额',
                'isv.SMS_SIGN_ILLEGAL' => '短信签名非法',
                'isv.UNKNOWN_ERROR' => '未知错误'
        );
        if (isset ( $message [$status] )) {
            return $message [$status];
        }
        return $status;
    }
}