<?php
/**
* @author 龙虾 <15108148@qq.com>
* @version 2.0 2020-08-26
* @copyright 睿谷信息 <www.rgxx.com>
*/
namespace rg;
use think\Image as TpImage;
use think\facade\Config;

class Image
{
	private $config;
	public function __construct($config=[])
	{
		$this->config = array_merge(config('app.image'),$config);
	}
	public function make($file)
	{
		$config = $this->config;
		// 缩略图
		if($config['do_thumb']) {
			$image = TpImage::open('.'.$file);
			$image->thumb($config['width'], $config['height'],$config['thumbtype'])->save('.'.$file,null,$config['thumbquality']);
		}
		// 水印
		if($config['do_water']) {
			$image = TpImage::open('.'.$file);
			switch ($config['do_water']) {
				case 1:
					$font = ['./public/static/font/arial.ttf','./public/static/font/simhei.ttf',];
					$image->text($config['textcontent'],$font[$config['textfont']],$config['textsize'],$config['textcolor'],$config['watertype'],[$config['offset_x'],$config['offset_y']],$config['textangle'])->save('.'.$file);
					break;
				case 2:
					$image->water('.'.$config['waterimg'],$config['watertype'],$config['wateralpha'])->save('.'.$file);
					break;
			}
		}
	}
}