<?php
namespace rg;
use think\Db;
/*
 * 关键词匹配类 * $str = "是是是是是范德萨下一年，下一年谁谁谁水水水水的洒落开是是是是军";
 * $key = new KeyReplace($str,array("下一年1"=>'http://baidu.com',"下一年"=>'baidu.com'));
 * echo $key->getResultText();
 * echo $key->getRuntime();
 */
class KeyReplace
{
    private $keys = array();
    private $text = "";
    private $runtime = 0;
    private $url = true;
    private $stopkeys = array();
    private $all = false;
    private $urlcolor = "";
    /**
     * @access public
     * @param string $text 指定被处理的文章
     * @param array $keys 指定字典词组array(key=>url,...) url可以是数组，如果是数组将随机替换其中的一个
     * @param array $stopkeys 指定停止词array(key,...) 这里面的词将不会被处理
     * @param boolean $url true 表示替换成链接否则只替换
     * @param boolean $all true 表示替换所有找到的词，否则只替换第一次
     */
    public function __construct($info='',$keys=array(),$url=true,$stopkeys=array(),$all=false) {
        $this->keys = $keys;
        $this->text = $info['content'];
        $this->url = $url;
        $this->stopkeys = $stopkeys;
        $this->all = boolval(config('app.seo.keyreplaceall'));
        $this->urlcolor = config('app.seo.keyreplacecolor');
    }

    /**
     * 获取处理好的文章
     * @access public
     * @return string text
     */
    public function getResultText() {
        if(!boolval(config('app.seo.keyreplace'))) {
            return $this->text;
        } else {
            $this->keys = Db::name('sitekey')->where('link','<>','')->column('link','name');
        }
        $start = microtime(true);
        $keys = $this->hits_keys();

        $keys_tmp = array_keys($keys);
        usort($keys_tmp,'cmp');

    foreach($keys_tmp as $key){

        if(is_array($keys[$key])){
            $url = $keys[$key][rand(0,count($keys[$key])-1)];
        }else
            $url = $keys[$key];

        $this->text = $this->r_s($this->text,$key,$url);

    }
    $this->runtime = microtime(true)-$start;

    return $this->text;
  }
    /**
     * 获取处理时间
     * @access public
     * @return float
     */
    public function getRuntime() {

        return $this->runtime;

    }

    /**
     * 设置关键词
     * @access public
     * @param array $keys array(key=>url,...)
     */
    public function setKeys($keys) {

        $this->keys = $keys;

    }
    /**
     * 设置停止词
     * @access public
     * @param array $keys array(key,...)
     */
    public function setStopKeys($keys) {

        $this->stopkeys = $keys;

    }
    /**
     * 设置文章
     * @access public
     * @param string $text
     */
    public function setText($text) {

        $this->text = $text;

    }

    /**
     * 用来找到字符串里面命中的关键词
     * @access public
     * @return array $keys 返回匹配到的词array(key=>url,...)
     */
    public function hits_keys(){
        $ar = $this->keys;
        $ar = $ar?$ar:array();
        $result=array();
        $str = $this->text;
        foreach($ar as $k=>$url){
            $k = trim($k);
            if(!$k)
                continue;
            if(strpos($str,$k)!==false && !in_array($k,$this->stopkeys)){
                $result[$k] = $url;
            }
        }
        return $result?$result:array();
    }

    /**
     * 用来找到字符串里面命中的停止词
     * @access public
     * @return array $keys 返回匹配到的词array(key,...)
     */
    public function hits_stop_keys(){
        $ar = $this->stopkeys;
        $ar = $ar?$ar:array();
        $result=array();
        $str = $this->text;
        foreach($ar as $k){
            $k = trim($k);
            if(!$k)
                continue;
            if(strpos($str,$k)!==false && in_array($k,$this->stopkeys)){
                $result[] = $k;
            }
        }
        return $result?$result:array();
    }

    /**
     * 处理替换过程
     * @access private
     * @param string $text 被替换者
     * @param string $key 关键词
     * @param string $url 链接
     * @return string $text 处理好的文章
     */
    private function r_s($text,$key,$url){

        $tmp = $text;

        $stop_keys = $this->hits_stop_keys();

        $stopkeys = $tags = $a = array();
        if(preg_match_all("#<a[^>]+>[^<]*</a[^>]*>#su",$tmp,$m)){
            $a=$m[0];

            foreach($m[0] as $k=>$z){
                $z = preg_replace("#\##s","\#",$z);

                $tmp = preg_replace('#'.$z.'#s',"[_a".$k."_]",$tmp,1);
            }

        };

        if(preg_match_all("#<[^>]+>#s",$tmp,$m)){
            $tags = $m[0];
            foreach($m[0] as $k=>$z){
                $z = preg_replace("#\##s","\#",$z);
                $tmp = preg_replace('#'.$z.'#s',"[_tag".$k."_]",$tmp,1);
            }
        }
        if(!empty($stop_keys)){
            if(preg_match_all("#".implode("|",$stop_keys)."#s",$tmp,$m)){
                $stopkeys = $m[0];
                foreach($m[0] as $k=>$z){
                    $z = preg_replace("#\##s","\#",$z);
                    $tmp = preg_replace('#'.$z.'#s',"[_s".$k."_]",$tmp,1);
                }
            }
        }
        $key1 = preg_replace("#([\#\(\)\[\]\*])#s","\\\\$1",$key);

        if($this->url)
            $tmp = preg_replace("#(?!\[_s|\[_a|\[_|\[_t|\[_ta|\[_tag)".$key1."(?!ag\d+_\]|g\d+_\]|\d+_\]|s\d+_\]|_\])#us",'<a href="'.$url.'" style="color:'.$this->urlcolor.'">'.$key.'</a>',$tmp,$this->all?-1:1);
        else
            $tmp = preg_replace("#(?!\[_s|\[_a|\[_|\[_t|\[_ta|\[_tag)".$key1."(?!ag\d+_\]|g\d+_\]|\d+_\]|s\d+_\]|_\])#us",$url,$tmp,$this->all?-1:1);

        if(!empty($a)){

            foreach($a as $n=>$at){

                $tmp = str_replace("[_a".$n."_]",$at,$tmp);

            }

        }
        if(!empty($tags)){

            foreach($tags as $n=>$at){

                $tmp = str_replace("[_tag".$n."_]",$at,$tmp);

            }

        }
        if(!empty($stopkeys)){

            foreach($stopkeys as $n=>$at){

                $tmp = str_replace("[_s".$n."_]",$at,$tmp);

            }

        }
        return $tmp;
    }
}