<?php
namespace rg;
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006~2017 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: zhangyajun <448901948@qq.com>
// +----------------------------------------------------------------------
 
use think\Paginator;
 
class Page extends Paginator
{
 
    //首页
    protected function home() {
        if ($this->currentPage() > 1) {
            return "<a href='" . $this->url(1) . "'>&#60;&#60;</a>";
        } else {
            return "<p>&#60;&#60;</p>";
        }
    }
 
    //上一页
    protected function prev() {
        if ($this->currentPage() > 1) {
            return "<a href='" . $this->url($this->currentPage - 1) . "'>&#60;</a>";
        } else {
            return "<p>&#60;</p>";
        }
    }
 
    //下一页
    protected function next() {
        if ($this->hasMore) {
            return "<a href='" . $this->url($this->currentPage + 1) . "'>&#62;</a>";
        } else {
            return"<p>&#62;</p>";
        }
    }
 
    //尾页
    protected function last() {
        if ($this->hasMore) {
            return "<a href='" . $this->url($this->lastPage) . "'>&#62;&#62;</a>";
        } else {
            return "<p>&#62;&#62;</p>";
        }
    }
 
    //统计信息
    protected function info(){
        return "<p>" . $this->currentPage .
            "/" . $this->lastPage . "</p>";
    }

    public function pageArray() {
        $pages = [];
        $pages['homeUrl'] = $this->url(1);
        $pages['lastUrl'] = $this->url($this->lastPage);
        $pages['prevUrl'] = $this->currentPage() > 1 ? $this->url($this->currentPage - 1) : $this->url(1);
        $pages['nextUrl'] = $this->hasMore ? $this->url($this->currentPage + 1) : $this->url($this->lastPage);
        $pages['pageList'] = $this->getUrlRange(1, $this->lastPage);
        $pages['total'] = $this->total;
        $pages['currentPage'] = $this->currentPage;
        $pages['lastPage'] = $this->lastPage;
        return $pages;
    }
 
    /**
     * 页码按钮
     * @return string
     */
    protected function getLinks()
    {
 
        $block = [
            'first'  => null,
            'slider' => null,
            'last'   => null
        ];
 
        $side   = 3;
        $window = $side * 2;
 
        if ($this->lastPage < $window + 6) {
            $block['first'] = $this->getUrlRange(1, $this->lastPage);
        } elseif ($this->currentPage <= $window) {
            $block['first'] = $this->getUrlRange(1, $window + 2);
            $block['last']  = $this->getUrlRange($this->lastPage - 1, $this->lastPage);
        } elseif ($this->currentPage > ($this->lastPage - $window)) {
            $block['first'] = $this->getUrlRange(1, 2);
            $block['last']  = $this->getUrlRange($this->lastPage - ($window + 2), $this->lastPage);
        } else {
            $block['first']  = $this->getUrlRange(1, 2);
            $block['slider'] = $this->getUrlRange($this->currentPage - $side, $this->currentPage + $side);
            $block['last']   = $this->getUrlRange($this->lastPage - 1, $this->lastPage);
        }
 
        $html = '';
 
        if (is_array($block['first'])) {
            $html .= $this->getUrlLinks($block['first']);
        }
 
        if (is_array($block['slider'])) {
            $html .= $this->getDots();
            $html .= $this->getUrlLinks($block['slider']);
        }
 
        if (is_array($block['last'])) {
            $html .= $this->getDots();
            $html .= $this->getUrlLinks($block['last']);
        }
 
        return $html;
    }
 
    /**
     * 渲染分页html
     * @return mixed
     */
    public function render()
    {
        if ($this->hasPages()) {
            if ($this->simple) {
                return sprintf(
                    '%s<div class="pagination">%s %s %s</div>',
                    $this->css(),
                    $this->prev(),
                    $this->getLinks(),
                    $this->next()
                );
            } else {
                return sprintf(
                    '%s<div class="pagination">%s %s %s %s %s %s</div>',
                    $this->css(),
                    $this->home(),
                    $this->prev(),
                    $this->getLinks(),
                    $this->next(),
                    $this->last(),
                    $this->info()
                );
            }
        }
    }
 
    /**
     * 生成一个可点击的按钮
     *
     * @param  string $url
     * @param  int    $page
     * @return string
     */
    protected function getAvailablePageWrapper($url, $page)
    {
        return '<a href="' . htmlentities($url) . '">' . $page . '</a>';
    }
 
    /**
     * 生成一个禁用的按钮
     *
     * @param  string $text
     * @return string
     */
    protected function getDisabledTextWrapper($text)
    {
        return '<p class="pageEllipsis">' . $text . '</p>';
    }
 
    /**
     * 生成一个激活的按钮
     *
     * @param  string $text
     * @return string
     */
    protected function getActivePageWrapper($text)
    {
        return '<a href="" class="cur">' . $text . '</a>';
    }
 
    /**
     * 生成省略号按钮
     *
     * @return string
     */
    protected function getDots()
    {
        return $this->getDisabledTextWrapper('...');
    }
 
    /**
     * 批量生成页码按钮.
     *
     * @param  array $urls
     * @return string
     */
    protected function getUrlLinks(array $urls)
    {
        $html = '';
 
        foreach ($urls as $page => $url) {
            $html .= $this->getPageLinkWrapper($url, $page);
        }
 
        return $html;
    }
 
    /**
     * 生成普通页码按钮
     *
     * @param  string $url
     * @param  int    $page
     * @return string
     */
    protected function getPageLinkWrapper($url, $page)
    {
        if ($page == $this->currentPage()) {
            return $this->getActivePageWrapper($page);
        }
 
        return $this->getAvailablePageWrapper($url, $page);
    }
 
    /**
     * 分页样式
     */
    protected function css(){
        return "\n".'<style type="text/css">
            .pagination{
                display:table;
                height:40px;
                padding:20px 0px;
            }
            .pagination a{
                display:block;
                float:left;
                margin-right:8px;
                padding:2px 12px;
                min-height:24px;
                border:1px #cccccc solid;
                background:#fff;
                text-decoration:none;
                color:#808080;
                font-size:12px;
                line-height:24px;
                font-family:Verdana,Arial
            }
            .pagination a:hover{
                color:#000000;
                background: white;
                border:1px #000000 solid;
            }
            .pagination a.cur{
                border:1px #000000 solid;
                background:#000000;
                color:#fff;
            }
            .pagination p{
                padding:0px;
                margin:0px;
                float:left;
                cursor:pointer;
                font-family:Verdana,Arial;
                padding:2px 12px;
                font-size:12px;
                min-height:24px;
                line-height:24px;
                color:#bbb;
                border:1px #ccc solid;
                background:#fcfcfc;
                margin-right:8px;
            }
            .pagination p.pageRemark{
                border-style:none;
                background:none;
                margin-right:0px;
                padding:4px 0px;
                color:#666;
            }
            .pagination p.pageRemark b{
                color:red;
            }
            .pagination p.pageEllipsis{
                border-style:none;
                background:none;
                padding:4px 0px;
                color:#808080;
            }
        </style><script>
        $(function(){
            $(window).resize(function(){
                $(".pagination").css({
                    margin: "auto",
                    width: $(".pagination").outerWidth()+"px"
                });
            });
            $(window).resize();
        });
        </script>'."\n";
    }
}