$(function(){
	container01();//柱状图
	container02();//饼状图
})

function container01(){
	var ydataYwc = new Array(); //数值
	var xtext = new Array(); //X轴TEXT
	$.ajax({
		type:'POST',
		url: conurl, //请求数据的地址
		data: {act:'line'},
		success: function(data) {
			var json = data;
			for(var key in json.list){
				ydataYwc.push(parseFloat(json.list[key].sum)); //数值
				xtext.push(json.list[key].type); //给X轴TEXT赋值
			}
			Highcharts.chart('container01',{
				credits: {
					enabled: false
				},
				exporting: {
					enabled: false
				},
				chart: {
					backgroundColor: 'rgba(0,0,0,0)',
					plotBackgroundColor: null,
					plotBorderWidth: null,
					plotShadow: false,
					type: 'column'
				},
				legend: {
					enabled: false,//影藏图例
				},
				colors:['#AB4CF1','#3EE80B','#FF962B','#00BD8D','#FFF12B'],
			    title: {
			        text: ''
			    },
			    subtitle: {
			        text: ''
			    },
			    xAxis: {
			        categories: xtext,
			        crosshair: true,
			        labels: {
						style: {
							color: '#666',
							fontWeight:500
						}
					},
			    },
			    yAxis: {
			    	allowDecimals:false,
			        min: 0,
			        title: {
			            text: '访问量',
			            style: {
							color: '#666',
						}
			        },
			        labels: {
						style: {
							color: '#666',
						}
					},
			    },
			    tooltip: {
			        headerFormat: '<span>{point.key}</span><table>',
			        pointFormat: '<tr><td style="padding:0">{series.name}: </td>' +
			        '<td style="padding:0">{point.y:1f}</td></tr>',
			        footerFormat: '</table>',
			    },
			    plotOptions: {
			        column: {
			            borderWidth: 0,
			            colorByPoint:true,
			        }
			    },
			    series: [{
			        name: '',
			        data: ydataYwc
			    }]
			});
			//统计图表结束
		}
	});
	
};


//饼状图
function container02(){
	$.ajax({
		type:'POST',
		url:conurl, //请求数据的地址
		data: {act:'round'},
		success:function(data){
			var dataVice = data.list;
			var datas = new Array();
			for(var i=0;i<dataVice.length;i++){
				var obj = new Object();
				obj.name = dataVice[i].type;
				obj.y=dataVice[i].sum;
				datas.push(obj);
			}
			$('#container02').highcharts().series[0].setData(datas);
		}
	});
	
	$('#container02').highcharts({
		credits: {
			enabled: false
		},
		exporting: {
			enabled: false
		},
		legend:{
			itemStyle:{
				color:'#797979',
			}
		},
		chart: {
			backgroundColor: 'rgba(0,0,0,0)',
			plotBackgroundColor: null,
			plotBorderWidth: null,
			plotShadow: false,
			type: 'pie'
		},
		colors:['#19ABFF','#FFC720','#87BA2F','#F36270','#8085E9','#7CB5EC','#4CB050'],
	    title: {
	        text: '',
	        style: {
	        	"fontSize": "14px",
	        	color: '#797979',
	        }
	    },
	    tooltip: {
	        pointFormat: '{series.name}: <b>{point.y:1f}</b>'
	    },
	    plotOptions: {
			pie: {
				allowPointSelect: true,
				cursor: 'pointer',
				dataLabels: {
					enabled: false
				},
				showInLegend: true
			}
		},
	    series: [{
	        name: '访问量',
	        showInLegend: true,
	        colorByPoint: true,
	    }]
		        
	});
};