<?php

namespace App;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

use App\Settings;
use Carbon\Carbon;

class Answers extends Authenticatable
{

    protected $primarykey = 'id';
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'reply', 'id_question', 'sent_by', 'sent_to'
    ];

    // Likes
    public function likes(){
        return $this->hasMany('App\Likes', 'answer_id')->count();
    }
    
    // Check if user already likes post or not
    public function checkLike($user_id, $answer_id)
    {
        $query = DB::table('likes')
            ->where('sent_by', $user_id)
            ->where('answer_id', $answer_id)
            ->get();
        
        return $query->count();
        
    }
    
}