<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

use Socialite;
use Auth;
use Exception;
use App\User;
use App\Role;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    
    /**
      * Redirect the user to the Google authentication page.
      *
      * @return \Illuminate\Http\Response
      */
    public function redirectToProvider()
    {
        return Socialite::driver('google')->redirect();
    }
    
    /**
     * Obtain the user information from Google.
     *
     * @return \Illuminate\Http\Response
     */
    public function handleProviderCallback()
    {
        try {
            $user = Socialite::driver('google')->user();
        } catch (\Exception $e) {
            return redirect('/login');
        }
        // only allow people with @company.com to login
        if(explode("@", $user->email)[1] !== 'gmail.com'){
            return redirect()->to('/');
        }
        // check if they're an existing user
        $existingUser = User::where('email', $user->email)->first();
        if($existingUser){
            // log them in
            Auth::login($existingUser, true);
        } else {
            
            $existingUserName = User::where('name', $user->name)->count();
            //
            if($existingUserName == 1) {
                $username = $user->name.'_'.$user->id;
            } else {
                $username = $user->name;
            }
            
            // create a new user
            $newUser                  = new User;
            $newUser->name            = $username;
            $newUser->email           = $user->email;
            $newUser->google_id       = $user->id;
            $newUser->save();
            
            $newUser
                ->roles()
                ->attach(Role::where('name', 'User')->first());
            
            auth()->login($newUser, true);
        }
        return redirect()->to('/');
    }
    
    public function redirectToFacebook() {
        return Socialite::driver('facebook')->redirect();
    }
    
    public function handleFacebookCallback() {
        try {
            $user = Socialite::driver('facebook')->user();
        } catch (\Exception $e) {
            return redirect('/login');
        }
        
        // check if they're an existing user
        $existingUser = User::where('email', $user->email)->first();
        if($existingUser){
            // log them in
            Auth::login($existingUser, true);
        } else {
            
            $existingUserName = User::where('name', $user->name)->count();
            //
            if($existingUserName == 1) {
                $username = $user->name.'_'.$user->id;
            } else {
                $username = $user->name;
            }
            
            // create a new user
            $newUser                  = new User;
            $newUser->name            = $username;
            $newUser->email           = $user->email;
            $newUser->facebook_id       = $user->id;
            $newUser->save();
            
            $newUser
                ->roles()
                ->attach(Role::where('name', 'User')->first());
            
            auth()->login($newUser, true);
        }
        return redirect()->to('/');
    }
    
}