<?php

namespace App;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

use Carbon\Carbon;

class Notifications extends Authenticatable
{

    protected $primarykey = 'id';
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'by_user_id', 'to_user_id', 'item_id', 'comment_id'
    ];
    
    // Check if the user has already read the notifications
    public function checkUnreadNotifications($user_id)
    {
        $query = DB::table('notifications')
            ->where('to_user_id', $user_id)
            ->where('read_at', null)
            ->get();

        if($query->count() >= 1){
            return true;
        } else {
            return false;
        }
        
    }
    
}