@extends('admin.layouts.app')
@section('content')
<!-- Page title -->
<div class="page-header">
    <div class="row align-items-center">
        <div class="col-auto">
            <!-- Page pre-title -->
            <h2 class="page-title">
                @lang('app.text_58')
            </h2>
        </div>
    </div>
</div>
<div class="row row-deck row-cards">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">@lang('app.text_67')</h3>
            </div>
            <div class="table-responsive">
                <table class="table card-table table-vcenter text-nowrap datatable">
                    <thead>
                        <tr>
                            <th class="w-1">ID</th>
                            <th>@lang('app.text_80')</th>
                            <th>@lang('app.text_81')</th>
                            <th>@lang('app.text_73')</th>
                            <th>@lang('app.text_74')</th>
                            <th>@lang('app.text_82')</th>
                            <th>@lang('app.text_114')</th>
                            <th>@lang('app.text_115')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($items as $item)
                        <tr>
                            <td>
                                <span class="text-muted">
                                    {{ $item->id }}
                                </span>
                            </td>
                            <td>
                                <span class="text-muted">
                                    {{ Str::limit($item->reply, 25) }} <a href="{{ url('question/'.$item->id_question) }}" class="link-secondary ml-2" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><path d="M10 14a3.5 3.5 0 0 0 5 0l4 -4a3.5 3.5 0 0 0 -5 -5l-.5 .5"></path><path d="M14 10a3.5 3.5 0 0 0 -5 0l-4 4a3.5 3.5 0 0 0 5 5l.5 -.5"></path></svg></a>
                                </span>
                            </td>
                            <td>
                                <span class="text-muted">
                                    <a href="{{ url('question/'.$item->id_question) }}" target="_blank" data-toggle="tooltip" data-placement="right" title="{{ App\Questions::find($item->id_question)->question }}">
                                        {{ $item->id_question }}
                                    </a>
                                </span>
                            </td>
                            <td>
                                <span class="text-muted">
                                    <a href="{{ url('admin/user/edit/'.$item->sent_to) }}" class="">
                                        {{ App\User::find($item->sent_to)->name }}
                                    </a>
                                </span>
                            </td>
                            <td>
                                <span class="text-muted">
                                    <a href="{{ url('admin/user/edit/'.$item->sent_by) }}" class="">
                                        {{ App\User::find($item->sent_by)->name }}
                                    </a>
                                </span>
                            </td>
                            <td>
                                <span class="text-muted">
                                    @if(!empty($item->photo))
                                    <code class="highlighter-rouge">
                                        <a href="{{ url('dist/img/answers/'.$item->photo) }}" target="_blank" title="">
                                            {{ $item->photo }}
                                        </a>
                                    </code>
                                    @else
                                    <code class="highlighter-rouge">
                                        @lang('app.text_83')
                                    </code>
                                    @endif
                                </span>
                            </td>
                            <td>
                                {{ $item->created_at }}
                            </td>
                            <td>
                                <div class="btn-list">
                                    <a href="{{ url('admin/answer/delete/'.$item->id) }}" 
                                       onclick="return confirm('This action is final, are you sure?');" 
                                       class="btn btn-danger btn-sm btn-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-md" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><line x1="4" y1="7" x2="20" y2="7"></line><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path></svg>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td>{{ __('app.text_60') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="card-footer d-flex align-items-center">
                <p class="m-0 text-muted">
                    Showing {{ $items->currentPage() }} page of {{ $items->total() }} entries
                </p>
                <ul class="pagination m-0 ml-auto">
                    {{ $items->links() }} 
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection