@extends('admin.layouts.app')
@section('content')
<!-- Page title -->
<div class="page-header">
    <div class="row align-items-center">
        <div class="col-auto">
            <!-- Page pre-title -->
            <h2 class="page-title">
                @lang('app.text_57')
            </h2>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-12">
        
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">@lang('app.text_79_1')</h3>
            </div>
            <div class="card-body">
                <form method="post" action="{{ url('admin/fake_questions') }}">
                    @csrf

                    <label class="form-label">@lang('app.text_79_2')</label>
                    <input type="text" class="form-control @error('fake_question') is-invalid @enderror" name="fake_question" value="{{ old('fake_question') }}" placeholder="@lang('app.text_79_2')">
                    
                    @error('fake_question')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror

                    <div class="form-footer">
                        <button type="submit" class="btn btn-primary">
                            @lang('app.text_104')
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">@lang('app.text_57')</h3>
            </div>
            <div class="table-responsive">
                <table class="table card-table table-vcenter text-nowrap datatable">
                    <thead>
                        <tr>
                            <th class="w-1">ID</th>
                            <th>@lang('app.text_79')</th>
                            <th>@lang('app.text_114')</th>
                            <th>@lang('app.text_115')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($items as $item)
                        <tr>
                            <td>
                                <span class="text-muted">
                                    {{ $item->id }}
                                </span>
                            </td>
                            <td style="width: 70%">
                                <span class="text-muted">
                                    {{ Str::limit($item->question, 35) }}
                                </span>
                            </td>
                            
                            <td>
                                {{ $item->created_at }}
                            </td>
                            <td>
                                <div class="btn-list">
                                    <a href="{{ url('admin/fake/question/delete/'.$item->id) }}" 
                                       onclick="return confirm('This action is final, are you sure?');" 
                                       class="btn btn-danger btn-sm btn-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-md" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><line x1="4" y1="7" x2="20" y2="7"></line><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path></svg>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td>{{ __('app.text_60') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="card-footer d-flex align-items-center">
                <p class="m-0 text-muted">
                    Showing {{ $items->currentPage() }} page of {{ $items->total() }} entries
                </p>
                <ul class="pagination m-0 ml-auto">
                    {{ $items->links() }} 
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection