@extends('admin.layouts.app')
@section('content')
<!-- Page title -->
<div class="page-header">
    <div class="row align-items-center">
        <div class="col-auto">
            <h2 class="page-title">
                Settings
            </h2>
        </div>
    </div>
</div>
<div class="row row-deck row-cards">

        
    <form method="post" action="{{ url('admin/settings') }}" enctype="multipart/form-data">
    @csrf

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">General</h3>
            </div>
            <div class="card-body">

                <div class="card shadow">
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="form-label col-lg-3 col-form-label">Logo <small class="form-hint mt-2">This field is optional. If you don't upload a logo, a text logo will be shown.</small></label>
                            <div class="col">
                                @if(!$settings->logo == NULL)
                                <img src="{{ url('dist/img/logo/'.$settings->logo) }}" class="img-thumbnail mb-2" width="100px" height="100px">
                                @endif
                                <input type="file" name="logo" class="form-control @error('logo') is-invalid @enderror">

                                @error('logo')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                            </div>
                        </div>
                    </div>
                    @if(!$settings->logo == NULL)
                    <div class="ribbon bg-red">
                        <a href="{{ url('admin/settings/delete_logo') }}" class="text-white">     
                            @lang('app.text_100')
                        </a>
                    </div>
                    @endif
                </div>


                <div class="form-group mt-4 mb-3 row">
                    <label class="form-label col-3 col-form-label">Website Name <small class="form-hint mt-2">Set the Name you want to give to your website.</small></label>
                    <div class="col">
                        <input type="text" class="form-control @error('website_name') is-invalid @enderror" value="{{ !empty(old('website_name')) ? old('website_name') : $settings->website_name }}" name="website_name">
                        
                        @error('website_name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>
                </div>

                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Website Tagline <small class="form-hint mt-2">Set the Tagline you want to give to your website.</small></label>
                    <div class="col">
                        <input type="text" class="form-control @error('website_tagline') is-invalid @enderror" value="{{ !empty(old('website_tagline')) ? old('website_tagline') : $settings->website_tagline }}" name="website_tagline">
                        
                        @error('website_tagline')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>
                </div>

                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Website Description <small class="form-hint mt-2">Set the Description you want to give to your website.</small></label>
                    <div class="col">
                        <textarea class="form-control @error('website_desc') is-invalid @enderror" data-toggle="autosize" style="overflow: hidden; overflow-wrap: break-word; resize: none; height: 56px;" name="website_desc">{{ !empty(old('website_desc')) ? old('website_desc') : $settings->website_desc }}</textarea>
                        
                        @error('website_desc')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>
                </div>

                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Analytics <small class="form-hint mt-2">Just enter the code after <mark>UA-</mark> from your Tracking ID.</small></label>
                    <div class="col">
                        <input type="text" class="form-control @error('analytics') is-invalid @enderror" value="{{ !empty(old('analytics')) ? old('analytics') : $settings->analytics }}" name="analytics" placeholder="UA-">
                        
                        @error('analytics')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>
                </div>

            </div>
        </div>


        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Settings</h3>
            </div>

            <div class="card-body">

                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Photo Upload <small class="form-hint mt-2">Lets you answer questions by uploading an image.</small></label>
                
                    <div class="col mt-2">
                        
                        <div class="form-selectgroup">
                            <label class="form-selectgroup-item">
                                <input type="radio" name="photo_upload" value="1" class="form-selectgroup-input" @if($settings->photo_upload == 1) checked="checked" @endif>
                                <span class="form-selectgroup-label">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon mr-1" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><circle cx="12" cy="12" r="9"></circle><path d="M9 12l2 2l4 -4"></path></svg> Enabled
                                </span>
                            </label>
                            <label class="form-selectgroup-item">
                                <input type="radio" name="photo_upload" value="2" class="form-selectgroup-input" @if($settings->photo_upload == 2) checked="checked" @endif>
                                <span class="form-selectgroup-label">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon mr-1" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><circle cx="12" cy="12" r="9"></circle><path d="M10 10l4 4m0 -4l-4 4"></path></svg> Disabled
                                </span>
                            </label>
                        </div>
                        
                        @error('photo_upload')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>
                </div>

                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Items Result <small class="form-hint mt-2">Set how many results per page are shown.</small></label>
                    <div class="col">
                        <input type="number" class="form-control @error('items_result') is-invalid @enderror" value="{{ !empty(old('items_result')) ? old('items_result') : $settings->items_result }}" name="items_result">
                        
                        @error('items_result')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>
                </div>
                
                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Questions <small class="form-hint">Set the minimum and maximum characters allowed for a question.</small></label>
                    <div class="col">
                        <input type="number" class="form-control @error('min_question') is-invalid @enderror" value="{{ !empty(old('min_question')) ? old('min_question') : $settings->min_question }}" name="min_question">
                        <small class="form-hint">Set the <strong>minimum</strong> characters for the question.</small>

                        @error('min_question')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>

                    <div class="col">
                        <input type="number" class="form-control @error('max_question') is-invalid @enderror" value="{{ !empty(old('max_question')) ? old('max_question') : $settings->max_question }}" name="max_question">
                        <small class="form-hint">Set the <strong>maximum</strong> characters for the question.</small>

                        @error('max_question')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Answers <small class="form-hint">Set the minimum and maximum characters allowed for a answer.</small></label>
                    <div class="col">
                        <input type="number" class="form-control @error('min_answer') is-invalid @enderror" value="{{ !empty(old('min_answer')) ? old('min_answer') : $settings->min_answer }}" name="min_answer">
                        <small class="form-hint">Set the <strong>minimum</strong> characters for the answer.</small>

                        @error('min_question')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>

                    <div class="col">
                        <input type="number" class="form-control @error('max_answer') is-invalid @enderror" value="{{ !empty(old('max_answer')) ? old('max_answer') : $settings->max_answer }}" name="max_answer">
                        <small class="form-hint">Set the <strong>maximum</strong> characters for the answer.</small>

                        @error('max_answer')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                
            </div>
        </div>
       
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><svg xmlns="http://www.w3.org/2000/svg" class="icon icon-md" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><rect x="3" y="5" width="18" height="14" rx="2"></rect><path d="M7 15v-4a2 2 0 0 1 4 0v4"></path><line x1="7" y1="13" x2="11" y2="13"></line><path d="M17 9v6h-1.5a1.5 1.5 0 1 1 1.5 -1.5"></path></svg> @lang('app.text_53')</h3>
            </div>

            <div class="card-body">
                
                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">High position</label>
                    <div class="col">
                        
                        <select class="form-select" name="adv_1">
                            <option value="" {{ null == App\Settings::first()->adv_1 ? 'selected' : '' }}>@lang('app.text_107')</option>
                            @foreach($advertisements as $adv)
                            <option value="{{ $adv->id }}" {{ $adv->id == App\Settings::first()->adv_1 ? 'selected' : '' }}>
                                {{ $adv->title }}
                            </option>
                            @endforeach
                        </select>

                    </div>
                </div>
                
                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Internal position</label>
                    <div class="col">
                        
                        <select class="form-select" name="adv_2">
                            <option value="" {{ null == App\Settings::first()->adv_2 ? 'selected' : '' }}>@lang('app.text_107')</option>
                            @foreach($advertisements as $adv)
                            <option value="{{ $adv->id }}" {{ $adv->id == App\Settings::first()->adv_2 ? 'selected' : '' }}>
                                {{ $adv->title }}
                            </option>
                            @endforeach
                        </select>
                        
                    </div>
                </div>
                
                <div class="form-group mb-3 row">
                    <label class="form-label col-3 col-form-label">Sidebar</label>
                    <div class="col">
                        
                        <select class="form-select" name="adv_3">
                            <option value="" {{ null == App\Settings::first()->adv_3 ? 'selected' : '' }}>@lang('app.text_107')</option>
                            @foreach($advertisements as $adv)
                            <option value="{{ $adv->id }}" {{ $adv->id == App\Settings::first()->adv_3 ? 'selected' : '' }}>
                                {{ $adv->title }}
                            </option>
                            @endforeach
                        </select>
                        
                    </div>
                </div>
                
            </div>
            
        </div>
        
        <small class="text-muted">Last update: {{ $settings->updated_at }}</small>
        
        <div class="form-footer">
            <button type="submit" class="btn btn-primary">
                @lang('app.text_105')
            </button>
        </div>

    </form>    
    
</div>
@endsection