@php
$auth_title = __('auth.register')
@endphp
@extends('auth.layouts.app')
@section('content')
<div class="container-tight py-6">

    <div class="text-center mb-4">
        <a href="{{ url('/') }}" class="navbar-brand d-none-navbar-horizontal pr-0 pr-md-3">
            @if(!empty(App\Settings::first()->logo))
            <img src="{{ url('dist/img/logo/'.App\Settings::first()->logo) }}" class="navbar-brand-image" alt="" title="{{ App\Settings::first()->website_name }}" data-toggle="tooltip" data-placement="bottom" title="{{ App\Settings::first()->website_name }}"/>
            @else
            <h2 class="text-muted">
                {{ App\Settings::first()->website_name }}
            </h2>
            @endif
        </a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">{{ __('auth.register') }}</h3>
        </div>
        
        <form method="POST" action="{{ route('register') }}">
            <div class="card-body">
                @csrf
                
                <div class="form-group mb-3 row">
                    <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('auth.name') }}</label>

                    <div class="col">
                        <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>

                        @error('name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="form-group mb-3 row">
                    <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('E-Mail Address') }}</label>

                    <div class="col">
                        <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">

                        @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
            

                <div class="form-group mb-3 row">
                    <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('auth.password') }}</label>

                    <div class="col">
                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                        @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="form-group mb-3 row">
                    <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('auth.confirm_password') }}</label>

                    <div class="col">
                        <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                    </div>
                </div>
            </div>
            
            <div class="card-footer text-right">
                <div class="d-flex">
                    <a class="btn btn-link" href="{{ url('login') }}">
                        {{ __('auth.login') }}
                    </a>
                    
                    <button type="submit" class="btn btn-primary ml-auto">
                        {{ __('auth.register') }}
                    </button>
                </div>
            </div>
            
        </form>
    </div>
</div>    
@endsection