@php
$auth_title = __('auth.verify_your_email_address')
@endphp
@extends('auth.layouts.app')
@section('content')
<div class="container-tight py-6">
    
    <div class="text-center mb-4">
        <a href="{{ url('/') }}" class="navbar-brand d-none-navbar-horizontal pr-0 pr-md-3">
            @if(!empty(App\Settings::first()->logo))
            <img src="{{ url('dist/img/logo/'.App\Settings::first()->logo) }}" class="navbar-brand-image" alt="" title="{{ App\Settings::first()->website_name }}" data-toggle="tooltip" data-placement="bottom" title="{{ App\Settings::first()->website_name }}"/>
            @else
            <h2 class="text-muted">
                {{ App\Settings::first()->website_name }}
            </h2>
            @endif
        </a>
    </div>
    
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">{{ __('auth.verify_your_email_address') }}</div>

                <div class="card-body">
                    @if (session('resent'))
                        <div class="alert alert-success" role="alert">
                            {{ __('auth.verificatio_link') }}
                        </div>
                    @endif

                    {{ __('auth.before_proceeding') }}
                    {{ __('auth.not_receive') }},
                    <form class="d-inline" method="POST" action="{{ route('verification.resend') }}">
                        @csrf
                        <button type="submit" class="btn btn-link p-0 m-0 align-baseline">
                            {{ __('auth.click_here') }}
                        </button>.
                    </form>
                    
                    <p class="mt-4 mark strong">
                        {{ __('auth.before_proceeding_1') }}
                    </p>
                </div>
            </div>
            
            <div class="btn-list">
                <a href="{{ url('user/confirm/delete_account') }}" class="btn btn-outline-danger mr-auto" onclick="return confirm('@lang('app.text_49')');">{{ __('auth.delete_account') }}</a>
                <a href="{{ url('/') }}" class="btn btn-primary">{{ __('auth.come_back') }}</a>
            </div>
            
        </div>
    </div>
</div>
@endsection
