@extends('layouts.app')
@section('content')
<section class="duik-promo bg-light">
    <div class="container duik-promo-container">

      <div class="row justify-content-center py-11">
        <div class="col-lg-9">

            <!-- Contact Form -->
            <form method="post" action="{{ route('postContacts') }}">
                @csrf
                <div class="row">
                    <div class="col-md-6 form-group mb-4">
                        <label for="c_name">@lang('app.text_40_3')</label>
                        <input class="form-control @error('name') is-invalid @enderror" type="text" placeholder="John Doe" name="name">
                        
                        @error('name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                        
                    </div>

                    <div class="col-md-6 form-group mb-4">
                        <label for="c_email">@lang('app.text_40_4')</label>
                        <input class="form-control @error('email') is-invalid @enderror" type="email" placeholder="johndoe@gmail.com" name="email">
                        
                        @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                        
                    </div>
                    
                    <div class="col-md-12 form-group mb-6">
                        <label for="c_msg">@lang('app.text_40_5')</label>
                        <textarea class="form-control @error('message') is-invalid @enderror" name="message" rows="7" placeholder="@lang('app.text_40_6')."></textarea>
                        
                        @error('message')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                        
                    </div>
                </div>
                
                <div class="text-center">
                    <button class="btn btn-primary px-5" type="submit">@lang('app.text_104')</button>
                </div>
            </form>
            <!-- End Contact Form -->
          </div>
        </div>
    </div>
</section>
@endsection