@extends('layouts.app')
@section('content')

<section class="duik-promo bg-primary-darker">
    <div class="container duik-promo-container">
        <div class="d-flex justify-content-center position-relative py-10">
        </div>
    </div>

    <!-- SVG BG -->
    <svg class="position-absolute bottom-0 left-0" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 323" enable-background="new 0 0 1920 323" xml:space="preserve">
      <polygon fill="#ffffff" class="opacity_0_5" points="-0.5,322.5 -0.5,121.5 658.3,212.3 "></polygon>
      <polygon fill="#ffffff" class="opacity_1" points="-2,323 1920,323 1920,-1 "></polygon>
    </svg>
    <!-- End SVG BG -->

    <!-- SVG BG Separator -->
    <svg class="position-absolute bottom-0 left-0" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1920 300">
      <path id="Path_1" fill="#f8fafd" data-name="Path 1" d="M0,1081.586H1920v-300Z" transform="translate(0 -781.586)"></path>
    </svg>
    <!-- SVG BG Separator -->
</section>

<section class="duik-icon-block--pull2top rounded bg-light pb-8">
    <div class="container z-index-2 position-relative duik-promo-container">
        <div class="row justify-content-center">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-wrench"></i> @lang('app.text_40_2')</h6>
                    </div>
                    
                    <form method="post" action="{{ url('user/account/') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            
                            <div class="row mb-3">
                                <div class="col-auto text-center">
                                    @if($item->avatar == NULL)
                                    <img class="rounded-circle u-box-shadow-sm mr-2" width="64" height="64" src="{{ url('dist/img/avatar/default_avatar.png')}}" alt="">
                                    @else
                                    <img class="rounded-circle u-box-shadow-sm mr-2" width="64" height="64" src="{{ url('dist/img/avatar/'.Auth::user()->avatar)}}" alt="">
                                    <div class="mt-2">
                                    <a href="{{ url('user/delete/avatar') }}" data-toggle="tooltip" data-placement="top" title="{{ __('app.text_35') }}">
                                        <span class="badge badge-danger">
                                            {{ __('app.text_28') }} <i class="fas fa-trash"></i>
                                        </span>
                                    </a>
                                    </div>
                                    @endif
                                </div>
                                
                                <div class="col">
                                    <div class="mb-2">
                                        <label class="form-label">{{ __('app.text_35') }}</label>
                                        <input type="file" name="avatar" class="form-control @error('logo') is-invalid @enderror">
                            
                                        @error('avatar')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-2">
                                <label class="form-label">{{ __('app.text_36') }}</label>
                                <textarea class="form-control @error('bio') is-invalid @enderror" name="bio" rows="5">{{ $item->bio }}</textarea>
                        
                                @error('bio')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('app.text_37') }}</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" value="{{ !empty(old('email')) ? old('email') : $item->email }}" name="email">

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                      
                        
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('app.text_38') }}</label>
                                    <input id="new_password" type="password" class="form-control @error('new_password') is-invalid @enderror" name="new_password" autocomplete="new-password" value="{{old('new_password')}}" placeholder="{{ __('app.text_38') }}">

                                    @error('new_password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror

                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('app.text_39') }}</label>
                                    <input id="new_confirm_password" type="password" class="form-control" name="new_confirm_password" autocomplete="new_confirm_password" placeholder="{{ __('app.text_39') }}">
                            </div>
                        </div>
                    
                        <div class="modal-footer">
                            <a href="{{ url('user/confirm/delete_account') }}" class="btn btn-sm btn-outline-danger" onclick="return confirm('@lang('app.text_49')');">{{ __('auth.delete_account') }}</a>
                            <button class="btn btn-sm btn-primary ml-auto"><i class="far fa-thumbs-up"></i> {{ __('app.text_40') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection