<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <!-- analytics -->
        @if(!App\Settings::first()->analytics == null)
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=UA-{{ App\Settings::first()->analytics }}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            
            gtag('config', 'UA-{{ App\Settings::first()->analytics }}');
        </script>
        @endif
        <!-- end analytics -->
        <meta charset="utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
        <title>{{ $title }}</title>
        <meta name="description" content="{{ $desc }}">
        <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
        <meta name="msapplication-TileColor" content="#206bc4"/>
        <meta name="theme-color" content="#206bc4"/>
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"/>
        <meta name="apple-mobile-web-app-capable" content="yes"/>
        <meta name="mobile-web-app-capable" content="yes"/>
        <meta name="HandheldFriendly" content="True"/>
        <meta name="MobileOptimized" content="320"/>
        <link rel="icon" href="" type="image/x-icon"/>
        <link rel="shortcut icon" href="" type="image/x-icon"/>
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <!-- Google Fonts -->
        <link href="//fonts.googleapis.com/css?family=Poppins:300,400,500,600" rel="stylesheet">
        <!-- CSS files -->
        <link rel="stylesheet" href="{{ asset('resources/views/font-awesome/css/fontawesome-all.min.css') }}" />
        <link rel="stylesheet" href="{{ asset('resources/views/css/theme.css') }}" />
        <link rel="stylesheet" href="{{ asset('resources/views/css/demo.css') }}" />
        <!-- facebook -->
        <meta property="og:url"                content="{{ \Request::fullUrl() }}"/>
        <meta property="og:type"               content="website" />
        <meta property="og:title"              content="{{ $title }}" />
        <meta property="og:description"        content="{{ $desc }}" />
        
    </head>
    <body>
        
        @include('admin.layouts.message')

        <header class="duik-header">
            
            <nav class="navbar navbar-expand-lg navbar-dark navbar-dark bg-primary-darker flex-nowrap z-index-3 shadow">
                <div class="container">
                    
                    @if(!empty(App\Settings::first()->logo))
                    <a class="navbar-brand mr-0" href="{{ url('/') }}">
                        <img src="{{ url('dist/img/logo/'.App\Settings::first()->logo) }}" class="navbar-brand-image shadow" alt="" data-toggle="tooltip" data-placement="bottom" title="{{ App\Settings::first()->website_name }}" width="35px" />
                    </a>
                    @else
                    <a class="navbar-brand mr-0" href="{{ url('/') }}">
                        {{ App\Settings::first()->website_name }}
                    </a>
                    @endif
                    
                    <!-- Header Search -->
                    <form action="{{ route('search') }}" method="GET" class="d-none d-lg-block w-100 ml-lg-3">
                        @csrf
                        <input class="border-0 d-none d-lg-block form-control form-control-sm w-100 ml-lg-3 shadow-lg @error('key') is-invalid @enderror" name="key" value="{{ old('key') }}" type="search" placeholder="{{ __('app.text_10') }}">

                        @error('key')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror

                    </form>
                    <!-- End Header Search -->

                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse-2" aria-controls="navbarCollapse-2" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarCollapse-2">
                        <ul class="navbar-nav ml-auto mr-sm-2 mt-2 mt-lg-0 duik-header__nav small text-nowrap ml-0 ml-md-3">
                            
                            @if(Auth::check())
                            <!-- inbox -->
                            <li class="nav-item {{ (request()->is('inbox')) ? 'active' : '' }} ml-4 mx-2">
                                <a class="nav-link" href="{{ url('inbox') }}" title="{{ __('app.text_2') }}"><i class="fas fa-question-circle text-success mr-md-1"></i> {{ __('app.text_2') }}
                                @if(App\Questions::where('sent_to', Auth::id())->where('replied', 2)->count() > 0)
                                    <span class="badge badge-pill badge-success badge-sm ml-2">
                                        <small>{{ App\Questions::where('sent_to', Auth::id())->where('replied', 2)->count() }}</small>
                                    </span>
                                    @endif
                                </a>
                            </li>
                            
                            <!-- notifications -->
                            <li class="nav-item ml-4 mx-2">
                                <a href="#notificationsModal" class="nav-link" data-toggle="modal" title="{{ __('app.text_3') }}">
                                    <i class="fas fa-bell text-warning"></i> {{ __('app.text_3') }}
                                    @if(App\Notifications::where('sent_to', Auth::id())->where('read_at', null)->count() > 0)
                                    <span class="badge badge-pill badge-warning badge-sm ml-2">
                                        <small>{{ App\Notifications::where('sent_to', Auth::id())->where('read_at', null)->count() }}</small>
                                    </span>
                                    @endif
                                </a>
                            </li>
                        
                        </ul>

                        <ul class="navbar-nav">
                            <li class="nav-item dropdown ml-4">
                                <a class="nav-link" href="#" id="navbarDropdown1" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    @if(Auth::user()->avatar == NULL)
                                    <img class="rounded-circle shadow" width="35" height="35" src="{{ url('dist/img/avatar/default_avatar.png')}}" alt="">
                                    @else
                                    <img class="rounded-circle shadow" width="35" height="35" src="{{ url('dist/img/avatar/'.Auth::user()->avatar)}}" alt="">
                                    @endif
                                </a>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown2">
                                    <a class="dropdown-item" href="{{ url('@'.Auth::user()->name) }}">
                                        <i class="fas fa-address-card"></i> {{ __('app.text_4') }}
                                    </a>

                                    <a class="dropdown-item" href="{{ url('user/account/') }}">
                                        <i class="fas fa-user-cog"></i> {{ __('app.text_5') }}
                                    </a>

                                    @if(Auth::user()->hasRole('admin'))
                                    <a class="dropdown-item" href="{{ url('admin') }}">
                                        <strong><i class="fas fa-tools"></i> {{ __('app.text_6') }}</strong>
                                    </a>
                                    @endif
                                    <div class="dropdown-divider"></div>
                                    <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault();
                                                             document.getElementById('logout-form').submit();">
                                        <i class="fas fa-sign-out-alt"></i> {{ __('app.text_7') }}
                                    </a>
                                    <form id="logout-form" action="{{ route('logout') }}" method="POST">
                                        @csrf
                                    </form>
                                </div>
                            </li>
            
                            @else

                            <li class="nav-item ml-6 mx-2">
                                <a href="{{ url('/') }}" class="nav-link">
                                    <i class="fas fa-home"></i> {{ __('app.text_9') }} 
                                </a>
                            </li>

                            <li class="nav-item ml-4 mx-2">
                                <a href="{{ url('contacts') }}" class="nav-link">
                                    <i class="fas fa-at"></i> {{ __('app.text_8') }}
                                </a>
                            </li>

                            @endif
                        </ul>
                    </div>
                </div>
            </nav>
        </header>
        
        @yield('content')
                 
        <div class="modal fade" id="notificationsModal" tabindex="-1" role="dialog" aria-labelledby="basic-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="basic-modal">{{ __('app.text_3') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                      @php $notifications = App\Notifications::where('sent_to', Auth::id())->where('read_at', null)->orderByDesc('created_at')->limit(30)->get() @endphp
                        <ul class="list-group">
                            @forelse($notifications as $notify)
                            <a href="{{ url('question/'.$notify->item_id) }}" class="list-group-item text-decoration-none">
                                <div class="media">
                                    <div class="d-flex mr-3">
                                        @if(App\User::find($notify->sent_by)->avatar == NULL)
                                        <img class="rounded-circle shadow" width="40" height="40" src="{{ url('dist/img/avatar/default_avatar.png') }}">
                                        @else
                                        <img class="rounded-circle shadow" width="40" height="40" src="{{ url('dist/img/avatar/'.App\User::find($notify->sent_by)->avatar)}}" alt="">
                                        @endif
                                    </div>

                                    <div class="media-body text-muted">
                                        <strong>{{ Str::limit(App\User::find($notify->sent_by)->name, 25) }}</strong> @if($notify->type == "reply") <i class="fas fa-reply text-primary"></i> {{ __('app.text_33') }} "<strong>{{ Str::limit(App\Questions::find($notify->item_id)->question, 35) }}</strong>" @else <i class="fas fa-heart text-danger"></i> {{ __('app.text_34') }} "<strong>{{ Str::limit(App\Answers::find($notify->reply_id)->reply, 35) }}</strong>" @endif
                                        <div class="extra-small">{{ Carbon::createFromTimeStamp(strtotime($notify->created_at))->diffForHumans() }}</div>
                                    </div>
                                </div>
                            </a>
                            @empty
                            <div class="card p-4 border-0 text-center">
                                <div class="card-header border-0"><i class="fas fa-bell text-muted fa-3x"></i></div>
                                <div class="card-body pt-0">
                                    <h4 class="h5 mb-2">{{ __('app.text_31') }}</h4>
                                </div>
                            </div>
                            @endforelse
                        </ul>
                    </div>
                    <div class="modal-footer">
                      <a href="{{ url('mark-as-read') }}" class="btn btn-block btn-sm btn-primary strong">
                          {{ __('app.text_32') }}
                          <span class="ml-auto">
                              <i class="fas fa-envelope-open-text"></i>
                          </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
          
        <footer class="duik-promo p-2 bg-primary-darker">
            <div class="container duik-promo-container">
                
                <!-- Copyright and Social Icons -->
                <div class="row px-md-3 py-4">
                    <div class="col-md-6 text-center text-md-left mb-3 mb-md-0">
                        <small>&copy;{{ date("Y") }} <a href="{{ url('/') }}" class="link-white">{{ App\Settings::first()->website_name }}</a> - Produced by <a href="https://www.9020.com" target="_blank" class="link-white"><span class="text-danger">&hearts;</span> 9020.com</a></small>
                    </div>
                    
                    <div class="col-md-6 align-self-center">
                        <ul class="list-inline text-center text-md-right mb-0">
                            <small>{{ App\Settings::first()->website_tagline }}</small>
                        </ul>
                    </div>
                </div>
                <!-- End Copyright and Social Icons -->
            </div>
        </footer>
          
        <a class="js-go-to duik-go-to show" href="#top">
            <span class="fa fa-arrow-up duik-go-to__inner"></span>
        </a>
        
        <!-- Libs JS -->
        <script type="text/javascript" src="{{ asset('resources/views/vendor/jquery/dist/jquery-3.5.1.min.js') }}"></script>
        <script src="{{ asset('resources/views/vendor/bootstrap/dist/js/bootstrap.bundle.min.js') }}"></script>
        <script src="{{ asset('resources/views/vendor/bootstrap/dist/js/popper.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('resources/js/like-system.js') }}"></script>
        <!-- Scripts -->
        
    </body>
</html>