<section id="demos" class="bg-primary-darker position-relative pt-4 pb-2">
    <div class="container">
        <header class="mb-2">
            <h2 class="text-white">
                {{ __('app.text_24') }}
            </h2>
        </header>
        
        <p class="mb-4">
            <a href="{{ url('user/bulk-delete-questions') }}" onclick="return confirm('@lang('app.text_49')');" class="btn btn-sm btn-danger mr-2">
                <i class="far fa-trash-alt"></i> <strong>{{ __('app.text_25') }}</strong>
            </a>
            <a href="{{ url('user/new-random-question') }}" class="btn btn-sm btn-primary">
                <i class="fas fa-random"></i> <strong>{{ __('app.text_26') }}</strong>
            </a>
        </p>

    </div>
</section>

<section class="duik-promo bg-light pt-4 pb-8">
    <div class="container duik-promo-container">
        <div class="d-flex justify-content-center">
            <div class="col-lg-8 mb-4">
                
                <div class="duik-callout duik-callout-warning bg-light mt-4">
                    <p class="text-dark mb-0">{{ __('app.text_27') }}</p>
                </div>
                
                @forelse($items as $quest)
                <div class="card shadow mb-4">
                    <div class="card-header d-flex">
                        <h6 class="mb-0">{{ $quest->question }} @if($quest->private == 2) &mdash; <small><a href="{{ url('@'.App\User::find($quest->sent_by)->name) }}"><strong>{{ App\User::find($quest->sent_by)->name }}</strong></a></small> @endif</h6>
                        
                        <span class="ml-auto">
                              <a href="{{ url('user/delete-question/'.$quest->id) }}" onclick="return confirm('@lang('app.text_49')');">
                                  <small><i class="fas fa-trash-alt text-danger"></i></small>
                            </a>
                        </span>
                    </div>
        
                    <!-- Card Body -->
                    <div class="card-body">
                        <form method="POST" action="{{ url('user/answer-the-question') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="input-group mb-2">
                                <input class="form-control form-control-lg @error('answer') is-invalid @enderror" type="text" placeholder="{{ __('app.text_29') }}" name="answer" value="{{ old('answer') }}">
                                <div class="input-group-append">
                                    <span class="input-group-text">
                                        <i class="fas fa-question-circle"></i>
                                    </span>
                                </div>
                      
                                @error('answer')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            
                            <input type="hidden" name="id_question" value="{{ $quest->id }}">
                            <input type="hidden" name="sent_to" value="{{ $quest->sent_by }}">
                            <div class="form-group">
                                
                                <!-- form for uploading the photo -->
                                @if(App\Settings::first()->photo_upload == 1)
                                <label class="file-upload float-left">
                                    <input type="file" class="form-control-file" name="image" />
                                    <small class="text-danger">{{ $errors->first('image') }}</small>
                                </label>
                                @endif
                                
                                <button class="btn btn-sm btn-primary float-right" type="submit"><i class="fas fa-reply"></i> {{ __('app.text_30') }}</button>
                            </div>
                        </form>
                    </div>
                    <!-- End Card Body -->      
                </div>
                @empty
                <div class="card pt-6 border-0 shadow text-center">
                    <div class="card-header border-0">
                        <div class="card-body pt-0">
                            <i class="far fa-envelope-open text-muted fa-6x mb-4"></i>
                            <h4 class="h5 mb-2">{{ __('app.text_30_1') }}</h4>
                        </div>
                    </div>
                </div>
                @endforelse
                {{ $items->onEachSide(1)->links() }}
            </div>
        </div>
    </div>
</section>