<div class="card shadow mb-4" id="item-{{ $quest->id }}">
    <div class="card-header">
        <h6 class="mb-0">{{ $quest->question }} 
            @if(e($quest->private) == 2) &mdash; <small><a href="{{ url('@'.App\User::find($quest->sent_by)->name) }}"><strong>{{ App\User::find(e($quest->sent_by))->name }}</strong></a></small> @endif</h6>
    </div>
    
    <!-- answer -->
    <div class="card-body"> 
        @php
        $answer = App\Answers::where('id_question', $quest->id)->first()
        @endphp
        <div class="d-flex align-items-center mt-auto">
            <div class="text-muted">
                <div class="media align-items-center mb-4">
                    <div class="rounded-circle mr-3">
                        @if(App\User::find(e($answer->sent_by))->avatar == NULL)
                        <img class="rounded-circle" width="45" height="45" src="{{ url('dist/img/avatar/default_avatar.png') }}" alt="">
                        @else
                        <img class="rounded-circle" width="45" height="45" src="{{ url('dist/img/avatar/'.App\User::find($answer->sent_by)->avatar)}}" alt="">
                        @endif
                    </div>
                    
                    <div class="media-body">
                        <a href="{{ url('@'.App\User::find($answer->sent_by)->name) }}">
                            <strong>{{ Str::limit(App\User::find($answer->sent_by)->name, 25) }}</strong>
                        </a>
                        <small class="d-block text-muted">
                            {{ Carbon::createFromTimeStamp(strtotime($answer->created_at))->diffForHumans() }}
                        </small>
                    </div>
                </div>
                
                <span class="d-block text-muted"><i class="fas fa-reply"></i> {{ $answer->reply }}</span>
                @if(!empty($answer->photo))
                <div class="mt-2">
                    <img class="shadow img-thumbnail" src="{{ url('dist/img/answers/'.$answer->photo) }}" width="150" height="150" alt="">
                </div>
                @endif
            </div>
            <!--<div class="ml-auto"></div>!-->
        </div>
    </div>
    <!-- end answer -->
    
    <div class="card-footer">
        <div class="d-flex">
            <a href="" class="btn btn-sm btn-secondary btn-pill mr-2 dropdown-toggle" id="dropdownShare" data-toggle="dropdown"  aria-haspopup="true" aria-expanded="false"><i class="fas fa-share-alt"></i> {{ __('app.text_15') }}</a>
            <div class="dropdown-menu navbar-left" aria-labelledby="dropdownShare">
                <a class="dropdown-item text-muted" href="https://www.facebook.com/sharer/sharer.php?u={{url('/question/'.$quest->id)}}&text={{ Str::of($quest->question)->words(12, '...') }}" target="_blank">
                    <i class="fab fa-facebook text-primary"></i> Facebook
                </a>
                <a class="dropdown-item text-muted" href="http://twitter.com/share?text={{ Str::of($quest->question)->words(12, '...') }}&url={{url('/question/'.$quest->id)}}&hashtags=ask,question,answer" target="_blank">
                    <i class="fab fa-twitter text-info"></i> Twitter
                </a>
                <a class="dropdown-item text-muted" href="whatsapp://send?text={{url('/question/'.$quest->id)}}" target="_blank">
                    <i class="fab fa-whatsapp text-success"></i> Whatsapp
                </a>
            </div>
            
            
            <div class="dropdown">
                <button class="btn btn-sm btn-light btn-pill dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                        <a class="dropdown-item text-muted" href="{{ url('question/'.$quest->id) }}">
                            <i class="fas fa-eye"></i> {{ __('app.text_16') }}
                        </a>
                        <a class="dropdown-item text-muted" href="{{ route('report') }}" onclick="event.preventDefault(); document.getElementById('report-form-q{{ $quest->id}}a{{ $answer->id }}').submit();">
                            <i class="fas fa-flag"></i> {{ __('app.text_17') }}
                        </a>
                        <form id="report-form-q{{ $quest->id}}a{{ $answer->id }}" action="{{ route('report') }}" method="POST">
                            @csrf
                            <input type="hidden" name="question_id" value="{{ $quest->id }}" /> 
                            <input type="hidden" name="answer_id" value="{{ $answer->id }}" />
                        </form>
                        
                        @if($answer->sent_by == Auth::id())
                        <a class="dropdown-item text-primary" href="{{ url('user/delete-question/'.$quest->id) }}" onclick="return confirm('@lang('app.text_49')');">
                            <i class="fas fa-trash-alt"></i> {{ __('app.text_17_1') }}
                        </a>
                        <a class="dropdown-item text-danger" href="{{ url('user/delete-answer/'.$answer->id) }}" onclick="return confirm('@lang('app.text_48')');">
                            <i class="fas fa-trash-alt"></i> {{ __('app.text_17_2') }}
                        </a>
                        @endif
                    </div>
                </div>
          
            <div class="ml-auto">
                <span id="saveLike" data-url="{{ url('save-like') }}" data-post="{{ $quest->id }}" data-answer="{{ $answer->id }}" data-touser="{{ $answer->sent_by }}" class="btn btn-sm btn-pill @if(@App\Answers::checkLike(Auth::id(), $answer->id) == 1) btn-outline-danger active @else btn-light @endif">
                    <i class="far fa-heart"></i> <span class="like-{{ $answer->id }}">@json($answer->likes())</span>
                </span>
            </div>
        </div>
    </div>
</div>