<div class="modal-body">
    @php $notifications = App\Notifications::where('sent_to', Auth::id())->where('read_at', null)->orderByDesc('created_at')->limit(30)->get() @endphp
    <ul class="list-group d-none d-sm-block">
        @forelse($notifications as $notify)
        <a href="{{ url('question/'.$notify->item_id) }}" class="list-group-item text-decoration-none">
            <div class="media">
                <div class="d-flex mr-3">
                    @if(App\User::find($notify->sent_by)->avatar == NULL)
                    <img class="rounded-circle shadow" width="40" height="40" src="{{ url('dist/img/avatar/default_avatar.png') }}">
                    @else
                    <img class="rounded-circle shadow" width="40" height="40" src="{{ url('dist/img/avatar/'.App\User::find($notify->sent_by)->avatar)}}" alt="">
                    @endif
                </div>

                <div class="media-body text-muted">
                    <strong>{{ Str::limit(App\User::find($notify->sent_by)->name, 25) }}</strong> @if($notify->type == "reply") <i class="fas fa-reply text-primary"></i> {{ __('app.text_33') }} "<strong>{{ Str::limit(App\Questions::find($notify->item_id)->question, 35) }}</strong>" @else <i class="fas fa-heart text-danger"></i> {{ __('app.text_34') }} "<strong>{{ Str::limit(App\Answers::find($notify->reply_id)->reply, 35) }}</strong>" @endif
                    <div class="extra-small">{{ Carbon::createFromTimeStamp(strtotime($notify->created_at))->diffForHumans() }}</div>
                </div>
            </div>
        </a>
        @empty
        <div class="card p-4 border-0 shadow text-center">
            <div class="card-header border-0"><i class="fas fa-bell text-muted fa-3x"></i></div>
            <div class="card-body pt-0">
                <h4 class="h5 mb-2">{{ __('app.text_31') }}</h4>
            </div>
        </div>
        @endforelse
    </ul>
    @if(!$notifications->count() == 0)          
    <a href="{{ url('mark-as-read') }}" class="btn btn-block btn-sm btn-light mt-2 d-none d-sm-block">
        {{ __('app.text_32') }}
        <span class="ml-auto">
            <i class="fas fa-envelope-open-text"></i>
        </span>
    </a>
    @endif
</div>