<div class="card bg-primary shadow rounded border-0 mt-4 d-none d-sm-block">
    <div class="card-body p-5 px-md-6">
        <div class="text-center text-warning">
            <i class="fas fa-medal fa-3x"></i> 
            <h2 class="card-header text-light mb-4">
                <strong>{{ __('app.text_18') }}</strong>
            </h2>
        </div>
        
        @forelse($rankings as $rank)
        <div class="media mb-4">
            <div class="d-flex mr-3">
                @if(App\User::find($rank->sent_to)->avatar == NULL)
                <img class="rounded-circle" width="45" height="45" src="{{ url('dist/img/avatar/default_avatar.png')}}" alt="">
                @else
                <img class="rounded-circle" width="45" height="45" src="{{ url('dist/img/avatar/'.App\User::find($rank->sent_to)->avatar)}}" alt="">
                @endif
            </div>
            
            <div class="media-body">
                <a href="{{ url('@'.App\User::find($rank->sent_to)->name) }}" class="text-light">
                    <strong>{{ Str::limit(App\User::find($rank->sent_to)->name, 11) }}</strong>
                </a>
                <div class="small">
                    <i class="fas fa-heart text-danger"></i> {{ App\Likes::where('sent_to', $rank->sent_to)->count() }}
                </div>
            </div>
        </div>
        @empty
        <p class="text-white">
            @lang('app.text_23_2')
        </p>
        @endforelse
    </div>
    
    <!-- SVG BG -->
    <svg class="position-absolute bottom-0 left-0" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 323" enable-background="new 0 0 1920 323" xml:space="preserve">
        <polygon fill="#ffffff" class="opacity_0_5" points="-0.5,322.5 -0.5,121.5 658.3,212.3 "></polygon>
        <polygon fill="#ffffff" class="opacity_1" points="-2,323 1920,323 1920,-1 "></polygon>
    </svg>
    <!-- End SVG BG -->
</div>